/*************************************************************************
** psdefs.cpp                                                           **
**                                                                      **
** This file is part of dvisvgm -- a fast DVI to SVG converter          **
** Copyright (C) 2005-2024 Martin Gieseking <martin.gieseking@uos.de>   **
**                                                                      **
** This program is free software; you can redistribute it and/or        **
** modify it under the terms of the GNU General Public License as       **
** published by the Free Software Foundation; either version 3 of       **
** the License, or (at your option) any later version.                  **
**                                                                      **
** This program is distributed in the hope that it will be useful, but  **
** WITHOUT ANY WARRANTY; without even the implied warranty of           **
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         **
** GNU General Public License for more details.                         **
**                                                                      **
** You should have received a copy of the GNU General Public License    **
** along with this program; if not, see <http://www.gnu.org/licenses/>. **
*************************************************************************/

#include "PSInterpreter.hpp"

const char *PSInterpreter::PSDEFS =
"<</Install{matrix setmatrix}/HWResolution[72 72]/PageSize[10000 10000]/Imaging"
"BBox null>>setpagedevice/@dodraw true store/@GD globaldict def/@SD systemdict "
"def/@UD userdict def @GD/@nulldev false put @GD/@patcnt 0 put true setglobal @"
"SD/:save @SD/save get put @SD/:restore @SD/restore get put @SD/:gsave @SD/gsav"
"e get put @SD/:grestore @SD/grestore get put @SD/:grestoreall @SD/grestoreall "
"get put @SD/:newpath @SD/newpath get put @SD/:stroke @SD/stroke get put @SD/:f"
"ill @SD/fill get put @SD/:eofill @SD/eofill get put @SD/:clip @SD/clip get put"
" @SD/:eoclip @SD/eoclip get put @SD/:charpath @SD/charpath get put @SD/:show @"
"SD/show get put @SD/:stringwidth @SD/stringwidth get put @SD/:nulldevice @SD/n"
"ulldevice get put @SD/:image @SD/image get put @SD/:colorimage @SD/colorimage "
"get put @SD/.setopacityalpha known not{@SD/.setopacityalpha{pop}put}if @SD/.se"
"tshapealpha known not{@SD/.setshapealpha{pop}put}if @SD/.setblendmode known no"
"t{@SD/.setblendmode{pop}put}if @SD/prseq{[exch 1 add 1 roll]{=only( )print}for"
"all(\\n)print}put @SD/prcmd{( )exch(\\ndvi.)3{print}repeat prseq}put @SD/cvxal"
"l{{cvx}forall}put @SD/defpr{[exch/copy cvx @SD 4 index[/get/exec]cvxall 5 inde"
"x 3 index dup length string cvs/prcmd cvx]cvx bind def}put @SD/querypos{{curre"
"ntpoint}stopped{$error/newerror false put}{2(querypos)prcmd}ifelse}put @SD/app"
"lyscalevals{1 0 dtransform exch dup mul exch dup mul add sqrt 0 1 dtransform e"
"xch dup mul exch dup mul add sqrt 1 0 dtransform dup mul exch dup dup mul 3 -1"
" roll add dup 0 eq{pop}{sqrt div}ifelse 3(applyscalevals)prcmd}put @SD/prpath{"
"{2(moveto)prcmd}{2(lineto)prcmd}{6(curveto)prcmd}{0(closepath)prcmd}pathforall"
"}put @SD/nulldevice{@GD/@nulldev true put :nulldevice 1 1(setnulldevice)prcmd}"
"put @SD/charpath{/@dodraw false store :charpath/@dodraw true store}put @SD/str"
"ingwidth{/@dodraw false store :stringwidth/@dodraw true store}put @SD/show{@do"
"draw @GD/@nulldev get not and{dup :gsave currentpoint 2{50 mul exch}repeat :ne"
"wpath moveto 50 50/scale sysexec true charpath fill :grestore/@dodraw false st"
"ore :show/@dodraw true store}{:show}ifelse}put @SD/varxyshow{dup 0 ge{<</chr 3"
" -1 roll string/prc 5 -1 roll/arr 7 -1 roll/str 9 -1 roll/idx 0>>begin 0 chr l"
"ength str length 1 sub{str exch chr length getinterval/chr exch store :gsave c"
"hr show :grestore currentpoint prc moveto/idx idx 1 add store}for end}{pop pop"
" show}ifelse}put @SD/xyshow{dup dup type/arraytype eq exch length 0 gt and{dup"
" length 2 idiv 2 index length exch idiv}{-1}ifelse{exch arr idx 2 mul get add "
"exch arr idx 2 mul 1 add get add}exch varxyshow}put @SD/xshow{dup dup type/arr"
"aytype eq exch length 0 gt and{dup length 2 index length exch idiv}{-1}ifelse{"
"exch arr idx get add exch}exch varxyshow}put @SD/yshow{dup dup type/arraytype "
"eq exch length 0 gt and{dup length 2 index length exch idiv}{-1}ifelse{arr idx"
" get add}exch varxyshow}put @SD/awidthshow{{1 string dup 0 5 index put :gsave "
"show :grestore pop 0 rmoveto 3 index eq{4 index 4 index rmoveto}if 1 index 1 i"
"ndex rmoveto}exch cshow 5{pop}repeat}put @SD/widthshow{0 0 3 -1 roll awidthsho"
"w}put @SD/ashow{0 0 0 6 3 roll awidthshow}put @SD/newpath{:newpath 1 1(newpath"
")prcmd}put @SD/stroke{@dodraw @GD/@nulldev get not and{prcolor 0 1(newpath)prc"
"md prpath 0(stroke)prcmd :newpath}{:stroke}ifelse}put @SD/fill{@dodraw @GD/@nu"
"lldev get not and{prcolor 0 1(newpath)prcmd prpath 0(fill)prcmd :newpath}{:fil"
"l}ifelse}put @SD/eofill{@dodraw @GD/@nulldev get not and{prcolor 0 1(newpath)p"
"rcmd prpath 0(eofill)prcmd :newpath}{:eofill}ifelse}put/.fillstroke{:gsave fil"
"l :grestore .swapcolors stroke .swapcolors}bind def/.eofillstroke{:gsave eofil"
"l :grestore .swapcolors stroke .swapcolors}bind def @SD/clip{:clip @GD/@nullde"
"v get not{0 1(newpath)prcmd prpath 0(clip)prcmd}if}put @SD/eoclip{:eoclip @GD/"
"@nulldev get not{0 1(newpath)prcmd prpath 0(eoclip)prcmd}if}put @SD/shfill{beg"
"in currentdict/ShadingType known currentdict/ColorSpace known and currentdict/"
"DataSource known and currentdict/Function known not and ShadingType 4 ge{DataS"
"ource type/arraytype eq{<</DeviceGray 1/DeviceRGB 3/DeviceCMYK 4/bgknown curre"
"ntdict/Background known/bbknown currentdict/BBox known>>begin currentdict Colo"
"rSpace known{ShadingType ColorSpace load bgknown{1 Background aload pop}{0}ife"
"lse bbknown{1 BBox aload pop}{0}ifelse ShadingType 5 eq{VerticesPerRow}if Data"
"Source aload length 4 add bgknown{ColorSpace load add}if bbknown{4 add}if Shad"
"ingType 5 eq{1 add}if(shfill)prcmd}if end}if}if end}put @SD/image{dup type/dic"
"ttype eq{dup}{<</Width 6 index/Height 7 index/colorimg false>>}ifelse @execimg"
"}put @SD/colorimage{<<2 index{/Width 2 index 8 add index/Height 4 index 9 add "
"index}{/Width 8 index/Height 9 index}ifelse/colorimg true>>@execimg}put/@imgba"
"se(./)def/@imgdevice(jpeg)def/@execimg{@GD/@imgcnt 2 copy .knownget{1 add}{1}i"
"felse put begin<</imgdev null/imgid @GD/@imgcnt get/ispng @imgdevice 0 3 getin"
"terval(png)eq dup/suffix exch{(.png)}{(.jpg)}ifelse/colorimg currentdict/color"
"img .knownget dup{pop}if/colordev 1 index currentcolorspace dup length 1 ne ex"
"ch 0 get/DeviceGray ne or or>>begin @imgdevice(png)ne @imgdevice(jpeg)ne and{@"
"imgdevice cvn}{colordev{ispng{/png16m}{/jpeg}ifelse}{ispng{/pnggray}{/jpeggray"
"}ifelse}ifelse}ifelse dup devicedict exch known{:gsave/imgdev exch finddevice "
"def mark/OutputFile @imgbase imgid 20 string cvs strconcat suffix strconcat/Pa"
"geSize[Width Height]/UseFastColor true ispng{@imgdevice(pngmonod)eq{/MinFeatur"
"eSize where{pop/MinFeatureSize MinFeatureSize}if}if}{/JPEGQ where{pop/JPEGQ JP"
"EGQ}if}ifelse imgdev putdeviceprops setdevice[Width 0 0 Height neg 0 Height]/s"
"etmatrix sysexec colorimg{:colorimage}{:image}ifelse/copypage sysexec mark/Out"
"putFile()imgdev putdeviceprops pop :grestore imgid Width Height 3(image)prcmd}"
"{pop colorimg{:colorimage}{:image}ifelse}ifelse end end}def/@rect{4 -2 roll mo"
"veto exch dup 0 rlineto exch 0 exch rlineto neg 0 rlineto closepath}bind def/@"
"rectcc{4 -2 roll moveto 2 copy 0 lt exch 0 lt xor{dup 0 exch rlineto exch 0 rl"
"ineto neg 0 exch rlineto}{exch dup 0 rlineto exch 0 exch rlineto neg 0 rlineto"
"}ifelse closepath}bind def @SD/rectclip{:newpath dup type/arraytype eq{aload l"
"ength 4 idiv{@rectcc}repeat}{@rectcc}ifelse clip :newpath}put @SD/rectfill{:gs"
"ave :newpath dup type/arraytype eq{aload length 4 idiv{@rectcc}repeat}{@rectcc"
"}ifelse fill :grestore}put @SD/rectstroke{gsave :newpath dup type/arraytype eq"
"{aload length 4 idiv{@rect}repeat}{@rect}ifelse stroke grestore}put false setg"
"lobal @SD readonly pop/initclip 0 defpr/clippath 0 defpr/sysexec{@SD exch get "
"exec}def/adddot{dup length 1 add string dup 0 46 put dup 3 -1 roll 1 exch puti"
"nterval}def/setlinewidth{dup/setlinewidth sysexec 1(setlinewidth)prcmd}def/set"
"linecap 1 defpr/setlinejoin 1 defpr/setmiterlimit 1 defpr/setdash{mark 3 1 rol"
"l 2 copy/setdash sysexec exch aload length 1 add -1 roll counttomark(setdash)p"
"rcmd pop}def/@setpagedevice{pop<<>>/setpagedevice sysexec matrix setmatrix new"
"path 0(setpagedevice)prcmd}def/@checknulldev{@GD/@nulldev get{currentpagedevic"
"e maxlength 0 ne{@GD/@nulldev false put 0 1(setnulldevice)prcmd}if}if}def/prco"
"lor{currentcolorspace @setcolorspace currentrgbcolor 3(setrgbcolor)prcmd}def/p"
"rintgstate{@dodraw @GD/@nulldev get not and{matrix currentmatrix aload pop 6(s"
"etmatrix)prcmd applyscalevals currentlinewidth 1(setlinewidth)prcmd currentlin"
"ecap 1(setlinecap)prcmd currentlinejoin 1(setlinejoin)prcmd currentmiterlimit "
"1(setmiterlimit)prcmd revision dup 952 lt{pop}{.currentblendmode .setblendmode"
" 952 eq{.currentopacityalpha .setopacityalpha .currentshapealpha .setshapealph"
"a}{.currentalphaisshape{1}{0}ifelse 1(setalphaisshape)prcmd .currentstrokecons"
"tantalpha 1(setstrokeconstantalpha)prcmd .currentfillconstantalpha 1(setfillco"
"nstantalpha)prcmd}ifelse}ifelse prcolor currentdash mark 3 1 roll exch aload l"
"ength 1 add -1 roll counttomark(setdash)prcmd pop}if}def/strconcat{exch dup le"
"ngth 2 index length add string dup dup 4 2 roll copy length 4 -1 roll putinter"
"val}def/setgstate{/setgstate sysexec printgstate}def/save{@UD begin/@saveID vm"
"status pop pop def end :save @saveID 1(save)prcmd}def/restore{:restore @checkn"
"ulldev printgstate @UD/@saveID known{@UD begin @saveID end}{0}ifelse 1(restore"
")prcmd}def/gsave 0 defpr/grestore{:grestore @checknulldev printgstate 0(gresto"
"re)prcmd}def/grestoreall{:grestoreall @checknulldev setstate 0(grestoreall)prc"
"md}def/rotate{dup type/arraytype ne @dodraw and{dup 1(rotate)prcmd}if/rotate s"
"ysexec applyscalevals}def/scale{dup type/arraytype ne @dodraw and{2 copy 2(sca"
"le)prcmd}if/scale sysexec applyscalevals}def/translate{dup type/arraytype ne @"
"dodraw and{2 copy 2(translate)prcmd}if/translate sysexec}def/setmatrix{dup/set"
"matrix sysexec @dodraw{aload pop 6(setmatrix)prcmd applyscalevals}{pop}ifelse}"
"def/initmatrix{matrix setmatrix}def/concat{matrix currentmatrix matrix concatm"
"atrix setmatrix}def/makepattern{gsave<</mx 3 -1 roll>>begin<</XUID[1000000 @pa"
"tcnt]>>copy mx/makepattern sysexec dup begin PatternType 2 lt{PatternType @pat"
"cnt BBox aload pop XStep YStep PaintType mx aload pop 15(makepattern)prcmd :ne"
"wpath matrix setmatrix dup PaintProc 0 1(makepattern)prcmd @GD/@patcnt @patcnt"
" 1 add put}if end end grestore}def/setpattern{dup begin PatternType end 1 eq{b"
"egin PaintType 1 eq{XUID aload pop exch pop 1}{:gsave[currentcolorspace aload "
"length -1 roll pop]/setcolorspace sysexec/setcolor sysexec XUID aload pop exch"
" pop currentrgbcolor :grestore 4}ifelse(setpattern)prcmd currentcolorspace 0 g"
"et/Pattern ne{[/Pattern currentcolorspace]/setcolorspace sysexec}if currentcol"
"orspace @setcolorspace end}{/setpattern sysexec}ifelse}def/setcolor{dup type/d"
"icttype eq{setpattern}{/setcolor sysexec/currentrgbcolor sysexec setrgbcolor}i"
"felse}def/setcolorspace{dup/setcolorspace sysexec @setcolorspace}def/@setcolor"
"space{dup type/arraytype eq{0 get}if/Pattern eq{1}{0}ifelse 1(setcolorspace)pr"
"cmd}def/setgray 1 defpr/setcmykcolor 4 defpr/sethsbcolor 3 defpr/setrgbcolor 3"
" defpr/.setalphaisshape{@SD/.setalphaisshape known{dup/.setalphaisshape sysexe"
"c}if{1}{0}ifelse 1(setalphaisshape)prcmd}bind def/.setfillconstantalpha{@SD/.s"
"etfillconstantalpha known{dup/.setfillconstantalpha sysexec}if 1(setfillconsta"
"ntalpha)prcmd}bind def/.setstrokeconstantalpha{@SD/.setstrokeconstantalpha kno"
"wn{dup/.setstrokeconstantalpha sysexec}if 1(setstrokeconstantalpha)prcmd}bind "
"def/.setopacityalpha{false .setalphaisshape dup .setfillconstantalpha .setstro"
"keconstantalpha}bind def/.setshapealpha{true .setalphaisshape dup .setfillcons"
"tantalpha .setstrokeconstantalpha}bind def/.setblendmode{dup/.setblendmode sys"
"exec<</Normal 0/Compatible 0/Multiply 1/Screen 2/Overlay 3/SoftLight 4/HardLig"
"ht 5/ColorDodge 6/ColorBurn 7/Darken 8/Lighten 9/Difference 10/Exclusion 11/Hu"
"e 12/Saturation 13/Color 14/Luminosity 15/CompatibleOverprint 16>>exch get 1(s"
"etblendmode)prcmd}def/@pdfpagecount{(r)file runpdfbegin pdfpagecount runpdfend"
"}def/@pdfpagebox{(r)file runpdfbegin dup dup 1 lt exch pdfpagecount gt or{pop}"
"{pdfgetpage/MediaBox pget pop aload pop}ifelse runpdfend}def DELAYBIND{.bindno"
"w}if ";

