/*
 * Copyright (c) 1998, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
//     Oracle - initial API and implementation from Oracle TopLink
package org.eclipse.persistence.internal.xr;

//EclipseLink imports
import org.eclipse.persistence.internal.dynamic.ValuesAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;

/**
 * <p>
 * <b>INTERNAL:</b> XRDynamicEntityAccessor is used by dynamically generated
 * subclasses of {@link XRDynamicEntity} to 'close over' information for the
 * psuedo-attributes in the propertiesMap inherited from {@link XRDynamicEntity}.
 *
 * @author Mike Norman - michael.norman@oracle.com
 * @since EclipseLink 1.x
 */

@SuppressWarnings("serial")
public class XRDynamicEntityAccessor extends ValuesAccessor {

    public XRDynamicEntityAccessor(DatabaseMapping mapping) {
        super(mapping);
    }
}
