/*
 * Decompiled with CFR 0.152.
 */
package jalview.commands;

import jalview.commands.CommandI;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceI;

public class ChangeCaseCommand
implements CommandI {
    String description;
    public static int TO_LOWER = 0;
    public static int TO_UPPER = 1;
    public static int TOGGLE_CASE = 2;
    int caseChange = -1;
    SequenceI[] seqs;
    int[][] regions;

    public ChangeCaseCommand(String description, SequenceI[] seqs, int[][] regions, int caseChange) {
        this.description = description;
        this.seqs = seqs;
        this.regions = regions;
        this.caseChange = caseChange;
        this.doCommand(null);
    }

    public String getDescription() {
        return this.description;
    }

    public int getSize() {
        return 1;
    }

    public void doCommand(AlignmentI[] views) {
        this.changeCase(true);
    }

    public void undoCommand(AlignmentI[] views) {
        this.changeCase(false);
    }

    void changeCase(boolean doCommand) {
        for (int r = 0; r < this.regions.length; ++r) {
            int start = this.regions[r][0];
            for (int s = 0; s < this.seqs.length; ++s) {
                String sequence = this.seqs[s].getSequenceAsString();
                StringBuffer newSeq = new StringBuffer();
                int end = this.regions[r][1] > sequence.length() ? sequence.length() : this.regions[r][1];
                if (start > 0) {
                    newSeq.append(sequence.substring(0, start));
                }
                if (this.caseChange == TO_UPPER && doCommand || this.caseChange == TO_LOWER && !doCommand) {
                    newSeq.append(sequence.substring(start, end).toUpperCase());
                } else if (this.caseChange == TO_LOWER && doCommand || this.caseChange == TO_UPPER && !doCommand) {
                    newSeq.append(sequence.substring(start, end).toLowerCase());
                } else {
                    for (int c = start; c < end; ++c) {
                        char nextChar = sequence.charAt(c);
                        if ('a' <= nextChar && nextChar <= 'z') {
                            nextChar = (char)(nextChar - 32);
                        } else if ('A' <= nextChar && nextChar <= 'Z') {
                            nextChar = (char)(nextChar + 32);
                        }
                        newSeq.append(nextChar);
                    }
                }
                if (end < sequence.length()) {
                    newSeq.append(sequence.substring(end));
                }
                this.seqs[s].setSequence(newSeq.toString());
            }
        }
    }
}

