C Copyright 1981-2012 ECMWF.
C
C This software is licensed under the terms of the Apache Licence 
C Version 2.0 which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
C
C In applying this licence, ECMWF does not waive the privileges and immunities 
C granted to it by virtue of its status as an intergovernmental organisation 
C nor does it submit to any jurisdiction.
C

      INTEGER FUNCTION JNUMGGQ( KNUM, KPTS)
C
C---->
C**** JNUMGGQ
C
C     PURPOSE
C     -------
C
C     This routine returns the number of points in each latitude of 
C     a gaussian grid.
C
C
C     INTERFACE
C     ---------
C
C     CALL JNUMGGQ( KNUM, KPTS)
C
C
C     Input parameters
C     ----------------
C
C     KNUM - Gaussian grid number
C
C
C     Output parameters
C     -----------------
C
C     KPTS - Array giving number of points at each gaussian latitude 
C            (both hemispheres)
C
C     Returns 0 if OK, otherwise passes the return status from JNUMGG
C
C
C     Common block usage
C     ------------------
C
C     None.
C
C
C     Method
C     ------
C
C     Simplified interface to JNUMGG. 
C
C
C     Externals
C     ---------
C
C     JGETGG - Get the gaussian grid definition. 
C
C
C     Reference
C     ---------
C
C     None
C
C
C     Comments
C     --------
C
C     None
C
C
C     Author
C     ------
C
C     J.D.Chambers      *ECMWF*      January 2002
C
C
C     Modifications
C     -------------
C
C     None.
C
C----<
C
      IMPLICIT NONE
#include "jparams.h"
#include "parim.h"
C
C     Subroutine arguments
C
      INTEGER KNUM, KPTS
      DIMENSION KPTS(KNUM*2)
C
C     Local variables
C
      CHARACTER*1 HTYPE
      INTEGER KRET
C
C     -----------------------------------------------------------------|
C*    Section 1.    Get the information.
C     -----------------------------------------------------------------|
C
  100 CONTINUE
C
      HTYPE = 'R'
      CALL JNUMGG( KNUM, HTYPE, KPTS, KRET)
C
C     -----------------------------------------------------------------|
C*    Section 9. Return to calling routine. Format statements
C     -----------------------------------------------------------------|
C
 900  CONTINUE
C
      JNUMGGQ = KRET
C
      RETURN
      END
