//
// File: PanelSaisieRepertoire.cc
// Created by: Éric Laly <elaly@free.fr>
// Created on: Tue Oct 24 18:50:08 2006
//

#include "PanelSaisieRepertoire.h"


PanelSaisieRepertoire::PanelSaisieRepertoire(wxString label, wxString chemin, bool choixpossible, wxWindow* parent, int id):wxPanel(parent, id)
{
    label_repertoire= new wxStaticText(this, -1, label);
    text_ctrl_repertoire= new wxTextCtrl(this, -1, chemin, wxDefaultPosition, wxDefaultSize, wxTE_READONLY);
    button_choix_repertoire= new wxButton(this, -1, wxT("Choisir"), wxDefaultPosition, wxDefaultSize, wxBU_EXACTFIT);

    
    sizer_panel_saisie_repertoire= new wxBoxSizer(wxHORIZONTAL);
    sizer_panel_saisie_repertoire->Add(label_repertoire, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);
    sizer_panel_saisie_repertoire->Add(text_ctrl_repertoire, 1, wxALL|wxEXPAND|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL|wxADJUST_MINSIZE, 2);
    sizer_panel_saisie_repertoire->Add(button_choix_repertoire, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);
    if (!choixpossible) button_choix_repertoire->Hide();
    SetSizer(sizer_panel_saisie_repertoire);
    
	// on connecte les événements
	Connect(button_choix_repertoire->GetId( ), wxEVT_COMMAND_BUTTON_CLICKED, 
											(wxObjectEventFunction) &PanelSaisieRepertoire::on_click_button_choix_repertoire);
}


PanelSaisieRepertoire::~PanelSaisieRepertoire()
{
	// TODO: put destructor code here
}

void PanelSaisieRepertoire::on_click_button_choix_repertoire(wxCommandEvent& event)
{
	wxString  chemin_par_defaut(text_ctrl_repertoire->GetValue());
    if (chemin_par_defaut.IsSameAs(wxT(""))) chemin_par_defaut=wxGetCwd(); 
        
	wxDirDialog dialog (this,wxT("Choisissez le répertoire"),chemin_par_defaut, wxDD_DEFAULT_STYLE);
	if (dialog.ShowModal()==wxID_OK) 
	{
		text_ctrl_repertoire->SetValue(dialog.GetPath());
	}
}	

wxString PanelSaisieRepertoire::GetRepertoire()
{
    return text_ctrl_repertoire->GetValue();
}
