/* Ergo, version 3.3, a program for linear scaling electronic structure
 * calculations.
 * Copyright (C) 2013 Elias Rudberg, Emanuel H. Rubensson, and Pawel Salek.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Primary academic reference:
 * Kohn−Sham Density Functional Theory Electronic Structure Calculations 
 * with Linearly Scaling Computational Time and Memory Usage,
 * Elias Rudberg, Emanuel H. Rubensson, and Pawel Salek,
 * J. Chem. Theory Comput. 7, 340 (2011),
 * <http://dx.doi.org/10.1021/ct100611z>
 * 
 * For further information about Ergo, see <http://www.ergoscf.org>.
 */

#ifndef DENSFROMFGENERALHEADER
#define DENSFROMFGENERALHEADER

#include "realtype.h"
#include "matrix_typedefs.h"

int get_dens_from_fock_general(int n, /**< System size. */
			       int noOfOccupiedOrbs, /**< Number of occupied orbitals. */
			       int use_diagonalization, /**< Flag to turn on diagonalization. */
			       int use_diag_if_puri_fail, /**< Flag to fall back on diagonalization if purification fails. */
			       ergo_real electronicTemperature, /**< Electronic temperature. */
			       symmMatrix & resultDens, /**< Density matrix. (output) */
			       ergo_real factor, /**< Factor to scale the resulting density matrix. (for restricted vs unrestricted calc) */
			       ergo_real & resultEntropyTerm, /**< Electronic entropy term, computed if electronicTemperature > 0. */
			       symmMatrix & Finput, /**< Effective Hamiltonian matrix (input, written to file) */
			       intervalType & homoInterval_Finput, /**< (out)
								      Output: Contains the homo eigenvalue of Finput. */
			       intervalType & lumoInterval_Finput, /**< (out)
								      Output: Contains the lumo eigenvalue of Finput. */
			       symmMatrix & overlapMatrix, /**< Overlap matrix. */
			       triangMatrix const & invCholFactor, /**< Inverse Cholesky factor (input, written to file) */  
			       ergo_real invCholFactor_euclnorm,  /**< Euclidean norm of inverse Cholesky factor. */
			       ergo_real gap_expected_lower_bound, /**< Expected lower bound for the gap to be used in early iterations. */
			       mat::SizesAndBlocks const & matrixSizesAndBlocks, /**< Information about HML matrix block sizes etc. */
			       symmMatrix & F_ort_prev, /**< (in/out) 
							   Input: Previous F matrix in orthogonal basis. (written to file)
							   Output: New F matrix in orthogonal basis ( ZT*Finput*Z ). (written to file) */
			       intervalType & homoInterval_F_ort_prev, /**< (in/out)
									  Input: Contains the homo eigenvalue of F_ort_prev.
									  Output: Contains the homo eigenvalue of F_ort_prev. */
			       intervalType & lumoInterval_F_ort_prev, /**< (in/out)
									  Input: Contains the lumo eigenvalue of F_ort_prev.
									  Output: Contains the lumo eigenvalue of F_ort_prev. */
			       ergo_real eigvalueErrorLimit, /**< Tolerated deviation of eigenvalues from 0 and 1 in the computed density matrix. */
			       ergo_real subspaceErrorLimit, /**< Tolerated error in the occupied subspace as measured by the sinus 
								of the largest canonical angle. */
			       mat::normType const truncationNormPurification, /**< Norm to be used for truncation. */
			       int maxMul, /**< Maximum allowed number of matrix multiplications. */
			       int create_m_files, /**< Flag to create m-files with information about the purification process. */
			       int ignore_purification_failure, /**< Continue even if purification fails to converge. */
			       int use_rand_perturbation_for_alleigsint, /**< Apply a random perturbation to (try to) improve the convergence speed of Lanczos calculation of extremal eigenvalues.  */
			       std::string stats_prefix, /**<  Prefix to be added to statistics files. */
			       std::map<std::string, double> & puri_stats, /**< Map to store stats for purification. */
			       int do_sparsity_investigation, /**< Flag to turn on sparsity investigation. */
			       int sparsity_plots_resolution_m, /**< Resolution in element magnitude histograms. */
			       int do_comparison_to_simple_purification, /**< Flag to turn on comparison to simple purification. */
			       int do_puri_mmul_tests, /**< Flag to turn on purification matrix-matrix multiplication tests. */
			       generalVector * eigVecLUMO = 0, /**<  LUMO eigenvector */
			       generalVector * eigVecHOMO = 0  /**<  HOMO eigenvector */
			       );

#endif
