!================================================================
! WARNING! this file is autogenerated. All modifications should
! will be overwritten on next build. This file is automatically
! produced by the config/scripts/autogen_low_level.py.
!================================================================

subroutine read_var_integer_0D(ncid, varname, var, lstat, &
    & start, count, map, ncvarid, error_data)
  integer, intent(in)                            :: ncid
  integer, intent(out) :: var
  character(len = *), intent(in)                 :: varname
  logical, intent(out)                           :: lstat
  integer, intent(in), optional                  :: start(:), count(:), map(:)
  integer, intent(out), optional                 :: ncvarid
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_var_integer_0D"
  character(len = 80) :: err
  type(etsf_io_low_var_infos) :: var_nc, var_user
  type(etsf_io_low_error) :: error
  integer :: s, i
  integer :: my_start(16), my_count(16), my_map(16)
  logical :: stat

  lstat = .false.
  ! We get the dimensions and shape of the ref variable in the NetCDF file.
  call etsf_io_low_read_var_infos(ncid, varname, var_nc, &
                                & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  var_user%name = varname
  var_user%nctype = NF90_INT
  var_user%ncshape = 0
  !var_user%ncdims(1:0) = shape(var)
  !var_user%ncdims(1) = charlen
  
  ! Create the access arrays from optional arguments.
  if (present(start) .and. present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & opt_map = map, error_data = error)
  else if (present(start) .and. present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & error_data = error)
  else if (present(start) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_map = map, &
                               & error_data = error)
  else if (present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, opt_map = map, &
                               & error_data = error)
  else if (present(start)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, error_data = error)
  else if (present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, error_data = error)
  else if (present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_map = map, error_data = error)
  else
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, &
                               & stat, error_data = error)
  end if
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
    
  ! Number of elements checks
  call etsf_io_low_check_var(var_nc, var_user, my_start(1:var_nc%ncshape), &
                           & my_count(1:var_nc%ncshape), &
                           & my_map(1:var_nc%ncshape), &
                           & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  
  ! Now that we are sure that the read var has compatible type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_var(ncid, var_nc%ncid, values = var, &
                 & start = my_start(1:max(1, var_nc%ncshape)) &
  !               & ,count = my_count(1:max(1, var_nc%ncshape)) &
  !               & ,map = my_map(1:max(1, var_nc%ncshape)) &
                 & )
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_VAR, &
                    & me, tgtname = varname, tgtid = var_nc%ncid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  if (present(ncvarid)) then
    ncvarid = var_nc%ncid
  end if
  lstat = .true.
end subroutine read_var_integer_0D

subroutine read_var_integer_1D(ncid, varname, var, lstat, &
    & start, count, map, ncvarid, error_data)
  integer, intent(in)                            :: ncid
  integer, intent(out) :: var(:)
  character(len = *), intent(in)                 :: varname
  logical, intent(out)                           :: lstat
  integer, intent(in), optional                  :: start(:), count(:), map(:)
  integer, intent(out), optional                 :: ncvarid
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_var_integer_1D"
  character(len = 80) :: err
  type(etsf_io_low_var_infos) :: var_nc, var_user
  type(etsf_io_low_error) :: error
  integer :: s, i
  integer :: my_start(16), my_count(16), my_map(16)
  logical :: stat

  lstat = .false.
  ! We get the dimensions and shape of the ref variable in the NetCDF file.
  call etsf_io_low_read_var_infos(ncid, varname, var_nc, &
                                & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  var_user%name = varname
  var_user%nctype = NF90_INT
  var_user%ncshape = 1
  var_user%ncdims(1:1) = shape(var)
  !var_user%ncdims(1) = charlen
  
  ! Create the access arrays from optional arguments.
  if (present(start) .and. present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & opt_map = map, error_data = error)
  else if (present(start) .and. present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & error_data = error)
  else if (present(start) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_map = map, &
                               & error_data = error)
  else if (present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, opt_map = map, &
                               & error_data = error)
  else if (present(start)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, error_data = error)
  else if (present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, error_data = error)
  else if (present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_map = map, error_data = error)
  else
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, &
                               & stat, error_data = error)
  end if
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
    
  ! Number of elements checks
  call etsf_io_low_check_var(var_nc, var_user, my_start(1:var_nc%ncshape), &
                           & my_count(1:var_nc%ncshape), &
                           & my_map(1:var_nc%ncshape), &
                           & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  
  ! Now that we are sure that the read var has compatible type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_var(ncid, var_nc%ncid, values = var, &
                 & start = my_start(1:max(1, var_nc%ncshape)) &
                 & ,count = my_count(1:max(1, var_nc%ncshape)) &
                 & ,map = my_map(1:max(1, var_nc%ncshape)) &
                 & )
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_VAR, &
                    & me, tgtname = varname, tgtid = var_nc%ncid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  if (present(ncvarid)) then
    ncvarid = var_nc%ncid
  end if
  lstat = .true.
end subroutine read_var_integer_1D

subroutine read_var_integer_2D(ncid, varname, var, lstat, &
    & start, count, map, ncvarid, error_data)
  integer, intent(in)                            :: ncid
  integer, intent(out) :: var(:,:)
  character(len = *), intent(in)                 :: varname
  logical, intent(out)                           :: lstat
  integer, intent(in), optional                  :: start(:), count(:), map(:)
  integer, intent(out), optional                 :: ncvarid
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_var_integer_2D"
  character(len = 80) :: err
  type(etsf_io_low_var_infos) :: var_nc, var_user
  type(etsf_io_low_error) :: error
  integer :: s, i
  integer :: my_start(16), my_count(16), my_map(16)
  logical :: stat

  lstat = .false.
  ! We get the dimensions and shape of the ref variable in the NetCDF file.
  call etsf_io_low_read_var_infos(ncid, varname, var_nc, &
                                & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  var_user%name = varname
  var_user%nctype = NF90_INT
  var_user%ncshape = 2
  var_user%ncdims(1:2) = shape(var)
  !var_user%ncdims(1) = charlen
  
  ! Create the access arrays from optional arguments.
  if (present(start) .and. present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & opt_map = map, error_data = error)
  else if (present(start) .and. present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & error_data = error)
  else if (present(start) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_map = map, &
                               & error_data = error)
  else if (present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, opt_map = map, &
                               & error_data = error)
  else if (present(start)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, error_data = error)
  else if (present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, error_data = error)
  else if (present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_map = map, error_data = error)
  else
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, &
                               & stat, error_data = error)
  end if
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
    
  ! Number of elements checks
  call etsf_io_low_check_var(var_nc, var_user, my_start(1:var_nc%ncshape), &
                           & my_count(1:var_nc%ncshape), &
                           & my_map(1:var_nc%ncshape), &
                           & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  
  ! Now that we are sure that the read var has compatible type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_var(ncid, var_nc%ncid, values = var, &
                 & start = my_start(1:max(1, var_nc%ncshape)) &
                 & ,count = my_count(1:max(1, var_nc%ncshape)) &
                 & ,map = my_map(1:max(1, var_nc%ncshape)) &
                 & )
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_VAR, &
                    & me, tgtname = varname, tgtid = var_nc%ncid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  if (present(ncvarid)) then
    ncvarid = var_nc%ncid
  end if
  lstat = .true.
end subroutine read_var_integer_2D

subroutine read_var_integer_3D(ncid, varname, var, lstat, &
    & start, count, map, ncvarid, error_data)
  integer, intent(in)                            :: ncid
  integer, intent(out) :: var(:,:,:)
  character(len = *), intent(in)                 :: varname
  logical, intent(out)                           :: lstat
  integer, intent(in), optional                  :: start(:), count(:), map(:)
  integer, intent(out), optional                 :: ncvarid
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_var_integer_3D"
  character(len = 80) :: err
  type(etsf_io_low_var_infos) :: var_nc, var_user
  type(etsf_io_low_error) :: error
  integer :: s, i
  integer :: my_start(16), my_count(16), my_map(16)
  logical :: stat

  lstat = .false.
  ! We get the dimensions and shape of the ref variable in the NetCDF file.
  call etsf_io_low_read_var_infos(ncid, varname, var_nc, &
                                & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  var_user%name = varname
  var_user%nctype = NF90_INT
  var_user%ncshape = 3
  var_user%ncdims(1:3) = shape(var)
  !var_user%ncdims(1) = charlen
  
  ! Create the access arrays from optional arguments.
  if (present(start) .and. present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & opt_map = map, error_data = error)
  else if (present(start) .and. present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & error_data = error)
  else if (present(start) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_map = map, &
                               & error_data = error)
  else if (present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, opt_map = map, &
                               & error_data = error)
  else if (present(start)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, error_data = error)
  else if (present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, error_data = error)
  else if (present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_map = map, error_data = error)
  else
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, &
                               & stat, error_data = error)
  end if
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
    
  ! Number of elements checks
  call etsf_io_low_check_var(var_nc, var_user, my_start(1:var_nc%ncshape), &
                           & my_count(1:var_nc%ncshape), &
                           & my_map(1:var_nc%ncshape), &
                           & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  
  ! Now that we are sure that the read var has compatible type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_var(ncid, var_nc%ncid, values = var, &
                 & start = my_start(1:max(1, var_nc%ncshape)) &
                 & ,count = my_count(1:max(1, var_nc%ncshape)) &
                 & ,map = my_map(1:max(1, var_nc%ncshape)) &
                 & )
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_VAR, &
                    & me, tgtname = varname, tgtid = var_nc%ncid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  if (present(ncvarid)) then
    ncvarid = var_nc%ncid
  end if
  lstat = .true.
end subroutine read_var_integer_3D

subroutine read_var_integer_4D(ncid, varname, var, lstat, &
    & start, count, map, ncvarid, error_data)
  integer, intent(in)                            :: ncid
  integer, intent(out) :: var(:,:,:,:)
  character(len = *), intent(in)                 :: varname
  logical, intent(out)                           :: lstat
  integer, intent(in), optional                  :: start(:), count(:), map(:)
  integer, intent(out), optional                 :: ncvarid
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_var_integer_4D"
  character(len = 80) :: err
  type(etsf_io_low_var_infos) :: var_nc, var_user
  type(etsf_io_low_error) :: error
  integer :: s, i
  integer :: my_start(16), my_count(16), my_map(16)
  logical :: stat

  lstat = .false.
  ! We get the dimensions and shape of the ref variable in the NetCDF file.
  call etsf_io_low_read_var_infos(ncid, varname, var_nc, &
                                & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  var_user%name = varname
  var_user%nctype = NF90_INT
  var_user%ncshape = 4
  var_user%ncdims(1:4) = shape(var)
  !var_user%ncdims(1) = charlen
  
  ! Create the access arrays from optional arguments.
  if (present(start) .and. present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & opt_map = map, error_data = error)
  else if (present(start) .and. present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & error_data = error)
  else if (present(start) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_map = map, &
                               & error_data = error)
  else if (present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, opt_map = map, &
                               & error_data = error)
  else if (present(start)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, error_data = error)
  else if (present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, error_data = error)
  else if (present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_map = map, error_data = error)
  else
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, &
                               & stat, error_data = error)
  end if
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
    
  ! Number of elements checks
  call etsf_io_low_check_var(var_nc, var_user, my_start(1:var_nc%ncshape), &
                           & my_count(1:var_nc%ncshape), &
                           & my_map(1:var_nc%ncshape), &
                           & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  
  ! Now that we are sure that the read var has compatible type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_var(ncid, var_nc%ncid, values = var, &
                 & start = my_start(1:max(1, var_nc%ncshape)) &
                 & ,count = my_count(1:max(1, var_nc%ncshape)) &
                 & ,map = my_map(1:max(1, var_nc%ncshape)) &
                 & )
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_VAR, &
                    & me, tgtname = varname, tgtid = var_nc%ncid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  if (present(ncvarid)) then
    ncvarid = var_nc%ncid
  end if
  lstat = .true.
end subroutine read_var_integer_4D

subroutine read_var_integer_5D(ncid, varname, var, lstat, &
    & start, count, map, ncvarid, error_data)
  integer, intent(in)                            :: ncid
  integer, intent(out) :: var(:,:,:,:,:)
  character(len = *), intent(in)                 :: varname
  logical, intent(out)                           :: lstat
  integer, intent(in), optional                  :: start(:), count(:), map(:)
  integer, intent(out), optional                 :: ncvarid
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_var_integer_5D"
  character(len = 80) :: err
  type(etsf_io_low_var_infos) :: var_nc, var_user
  type(etsf_io_low_error) :: error
  integer :: s, i
  integer :: my_start(16), my_count(16), my_map(16)
  logical :: stat

  lstat = .false.
  ! We get the dimensions and shape of the ref variable in the NetCDF file.
  call etsf_io_low_read_var_infos(ncid, varname, var_nc, &
                                & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  var_user%name = varname
  var_user%nctype = NF90_INT
  var_user%ncshape = 5
  var_user%ncdims(1:5) = shape(var)
  !var_user%ncdims(1) = charlen
  
  ! Create the access arrays from optional arguments.
  if (present(start) .and. present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & opt_map = map, error_data = error)
  else if (present(start) .and. present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & error_data = error)
  else if (present(start) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_map = map, &
                               & error_data = error)
  else if (present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, opt_map = map, &
                               & error_data = error)
  else if (present(start)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, error_data = error)
  else if (present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, error_data = error)
  else if (present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_map = map, error_data = error)
  else
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, &
                               & stat, error_data = error)
  end if
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
    
  ! Number of elements checks
  call etsf_io_low_check_var(var_nc, var_user, my_start(1:var_nc%ncshape), &
                           & my_count(1:var_nc%ncshape), &
                           & my_map(1:var_nc%ncshape), &
                           & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  
  ! Now that we are sure that the read var has compatible type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_var(ncid, var_nc%ncid, values = var, &
                 & start = my_start(1:max(1, var_nc%ncshape)) &
                 & ,count = my_count(1:max(1, var_nc%ncshape)) &
                 & ,map = my_map(1:max(1, var_nc%ncshape)) &
                 & )
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_VAR, &
                    & me, tgtname = varname, tgtid = var_nc%ncid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  if (present(ncvarid)) then
    ncvarid = var_nc%ncid
  end if
  lstat = .true.
end subroutine read_var_integer_5D

subroutine read_var_integer_6D(ncid, varname, var, lstat, &
    & start, count, map, ncvarid, error_data)
  integer, intent(in)                            :: ncid
  integer, intent(out) :: var(:,:,:,:,:,:)
  character(len = *), intent(in)                 :: varname
  logical, intent(out)                           :: lstat
  integer, intent(in), optional                  :: start(:), count(:), map(:)
  integer, intent(out), optional                 :: ncvarid
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_var_integer_6D"
  character(len = 80) :: err
  type(etsf_io_low_var_infos) :: var_nc, var_user
  type(etsf_io_low_error) :: error
  integer :: s, i
  integer :: my_start(16), my_count(16), my_map(16)
  logical :: stat

  lstat = .false.
  ! We get the dimensions and shape of the ref variable in the NetCDF file.
  call etsf_io_low_read_var_infos(ncid, varname, var_nc, &
                                & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  var_user%name = varname
  var_user%nctype = NF90_INT
  var_user%ncshape = 6
  var_user%ncdims(1:6) = shape(var)
  !var_user%ncdims(1) = charlen
  
  ! Create the access arrays from optional arguments.
  if (present(start) .and. present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & opt_map = map, error_data = error)
  else if (present(start) .and. present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & error_data = error)
  else if (present(start) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_map = map, &
                               & error_data = error)
  else if (present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, opt_map = map, &
                               & error_data = error)
  else if (present(start)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, error_data = error)
  else if (present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, error_data = error)
  else if (present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_map = map, error_data = error)
  else
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, &
                               & stat, error_data = error)
  end if
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
    
  ! Number of elements checks
  call etsf_io_low_check_var(var_nc, var_user, my_start(1:var_nc%ncshape), &
                           & my_count(1:var_nc%ncshape), &
                           & my_map(1:var_nc%ncshape), &
                           & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  
  ! Now that we are sure that the read var has compatible type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_var(ncid, var_nc%ncid, values = var, &
                 & start = my_start(1:max(1, var_nc%ncshape)) &
                 & ,count = my_count(1:max(1, var_nc%ncshape)) &
                 & ,map = my_map(1:max(1, var_nc%ncshape)) &
                 & )
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_VAR, &
                    & me, tgtname = varname, tgtid = var_nc%ncid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  if (present(ncvarid)) then
    ncvarid = var_nc%ncid
  end if
  lstat = .true.
end subroutine read_var_integer_6D

subroutine read_var_integer_7D(ncid, varname, var, lstat, &
    & start, count, map, ncvarid, error_data)
  integer, intent(in)                            :: ncid
  integer, intent(out) :: var(:,:,:,:,:,:,:)
  character(len = *), intent(in)                 :: varname
  logical, intent(out)                           :: lstat
  integer, intent(in), optional                  :: start(:), count(:), map(:)
  integer, intent(out), optional                 :: ncvarid
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_var_integer_7D"
  character(len = 80) :: err
  type(etsf_io_low_var_infos) :: var_nc, var_user
  type(etsf_io_low_error) :: error
  integer :: s, i
  integer :: my_start(16), my_count(16), my_map(16)
  logical :: stat

  lstat = .false.
  ! We get the dimensions and shape of the ref variable in the NetCDF file.
  call etsf_io_low_read_var_infos(ncid, varname, var_nc, &
                                & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  var_user%name = varname
  var_user%nctype = NF90_INT
  var_user%ncshape = 7
  var_user%ncdims(1:7) = shape(var)
  !var_user%ncdims(1) = charlen
  
  ! Create the access arrays from optional arguments.
  if (present(start) .and. present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & opt_map = map, error_data = error)
  else if (present(start) .and. present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & error_data = error)
  else if (present(start) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_map = map, &
                               & error_data = error)
  else if (present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, opt_map = map, &
                               & error_data = error)
  else if (present(start)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, error_data = error)
  else if (present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, error_data = error)
  else if (present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_map = map, error_data = error)
  else
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, &
                               & stat, error_data = error)
  end if
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
    
  ! Number of elements checks
  call etsf_io_low_check_var(var_nc, var_user, my_start(1:var_nc%ncshape), &
                           & my_count(1:var_nc%ncshape), &
                           & my_map(1:var_nc%ncshape), &
                           & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  
  ! Now that we are sure that the read var has compatible type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_var(ncid, var_nc%ncid, values = var, &
                 & start = my_start(1:max(1, var_nc%ncshape)) &
                 & ,count = my_count(1:max(1, var_nc%ncshape)) &
                 & ,map = my_map(1:max(1, var_nc%ncshape)) &
                 & )
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_VAR, &
                    & me, tgtname = varname, tgtid = var_nc%ncid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  if (present(ncvarid)) then
    ncvarid = var_nc%ncid
  end if
  lstat = .true.
end subroutine read_var_integer_7D

subroutine read_var_double_0D(ncid, varname, var, lstat, &
    & start, count, map, ncvarid, error_data)
  integer, intent(in)                            :: ncid
  double precision, intent(out) :: var
  character(len = *), intent(in)                 :: varname
  logical, intent(out)                           :: lstat
  integer, intent(in), optional                  :: start(:), count(:), map(:)
  integer, intent(out), optional                 :: ncvarid
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_var_double_0D"
  character(len = 80) :: err
  type(etsf_io_low_var_infos) :: var_nc, var_user
  type(etsf_io_low_error) :: error
  integer :: s, i
  integer :: my_start(16), my_count(16), my_map(16)
  logical :: stat

  lstat = .false.
  ! We get the dimensions and shape of the ref variable in the NetCDF file.
  call etsf_io_low_read_var_infos(ncid, varname, var_nc, &
                                & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  var_user%name = varname
  var_user%nctype = NF90_DOUBLE
  var_user%ncshape = 0
  !var_user%ncdims(1:0) = shape(var)
  !var_user%ncdims(1) = charlen
  
  ! Create the access arrays from optional arguments.
  if (present(start) .and. present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & opt_map = map, error_data = error)
  else if (present(start) .and. present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & error_data = error)
  else if (present(start) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_map = map, &
                               & error_data = error)
  else if (present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, opt_map = map, &
                               & error_data = error)
  else if (present(start)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, error_data = error)
  else if (present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, error_data = error)
  else if (present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_map = map, error_data = error)
  else
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, &
                               & stat, error_data = error)
  end if
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
    
  ! Number of elements checks
  call etsf_io_low_check_var(var_nc, var_user, my_start(1:var_nc%ncshape), &
                           & my_count(1:var_nc%ncshape), &
                           & my_map(1:var_nc%ncshape), &
                           & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  
  ! Now that we are sure that the read var has compatible type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_var(ncid, var_nc%ncid, values = var, &
                 & start = my_start(1:max(1, var_nc%ncshape)) &
  !               & ,count = my_count(1:max(1, var_nc%ncshape)) &
  !               & ,map = my_map(1:max(1, var_nc%ncshape)) &
                 & )
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_VAR, &
                    & me, tgtname = varname, tgtid = var_nc%ncid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  if (present(ncvarid)) then
    ncvarid = var_nc%ncid
  end if
  lstat = .true.
end subroutine read_var_double_0D

subroutine read_var_double_1D(ncid, varname, var, lstat, &
    & start, count, map, ncvarid, error_data)
  integer, intent(in)                            :: ncid
  double precision, intent(out) :: var(:)
  character(len = *), intent(in)                 :: varname
  logical, intent(out)                           :: lstat
  integer, intent(in), optional                  :: start(:), count(:), map(:)
  integer, intent(out), optional                 :: ncvarid
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_var_double_1D"
  character(len = 80) :: err
  type(etsf_io_low_var_infos) :: var_nc, var_user
  type(etsf_io_low_error) :: error
  integer :: s, i
  integer :: my_start(16), my_count(16), my_map(16)
  logical :: stat

  lstat = .false.
  ! We get the dimensions and shape of the ref variable in the NetCDF file.
  call etsf_io_low_read_var_infos(ncid, varname, var_nc, &
                                & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  var_user%name = varname
  var_user%nctype = NF90_DOUBLE
  var_user%ncshape = 1
  var_user%ncdims(1:1) = shape(var)
  !var_user%ncdims(1) = charlen
  
  ! Create the access arrays from optional arguments.
  if (present(start) .and. present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & opt_map = map, error_data = error)
  else if (present(start) .and. present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & error_data = error)
  else if (present(start) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_map = map, &
                               & error_data = error)
  else if (present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, opt_map = map, &
                               & error_data = error)
  else if (present(start)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, error_data = error)
  else if (present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, error_data = error)
  else if (present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_map = map, error_data = error)
  else
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, &
                               & stat, error_data = error)
  end if
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
    
  ! Number of elements checks
  call etsf_io_low_check_var(var_nc, var_user, my_start(1:var_nc%ncshape), &
                           & my_count(1:var_nc%ncshape), &
                           & my_map(1:var_nc%ncshape), &
                           & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  
  ! Now that we are sure that the read var has compatible type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_var(ncid, var_nc%ncid, values = var, &
                 & start = my_start(1:max(1, var_nc%ncshape)) &
                 & ,count = my_count(1:max(1, var_nc%ncshape)) &
                 & ,map = my_map(1:max(1, var_nc%ncshape)) &
                 & )
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_VAR, &
                    & me, tgtname = varname, tgtid = var_nc%ncid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  if (present(ncvarid)) then
    ncvarid = var_nc%ncid
  end if
  lstat = .true.
end subroutine read_var_double_1D

subroutine read_var_double_2D(ncid, varname, var, lstat, &
    & start, count, map, ncvarid, error_data)
  integer, intent(in)                            :: ncid
  double precision, intent(out) :: var(:,:)
  character(len = *), intent(in)                 :: varname
  logical, intent(out)                           :: lstat
  integer, intent(in), optional                  :: start(:), count(:), map(:)
  integer, intent(out), optional                 :: ncvarid
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_var_double_2D"
  character(len = 80) :: err
  type(etsf_io_low_var_infos) :: var_nc, var_user
  type(etsf_io_low_error) :: error
  integer :: s, i
  integer :: my_start(16), my_count(16), my_map(16)
  logical :: stat

  lstat = .false.
  ! We get the dimensions and shape of the ref variable in the NetCDF file.
  call etsf_io_low_read_var_infos(ncid, varname, var_nc, &
                                & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  var_user%name = varname
  var_user%nctype = NF90_DOUBLE
  var_user%ncshape = 2
  var_user%ncdims(1:2) = shape(var)
  !var_user%ncdims(1) = charlen
  
  ! Create the access arrays from optional arguments.
  if (present(start) .and. present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & opt_map = map, error_data = error)
  else if (present(start) .and. present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & error_data = error)
  else if (present(start) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_map = map, &
                               & error_data = error)
  else if (present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, opt_map = map, &
                               & error_data = error)
  else if (present(start)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, error_data = error)
  else if (present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, error_data = error)
  else if (present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_map = map, error_data = error)
  else
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, &
                               & stat, error_data = error)
  end if
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
    
  ! Number of elements checks
  call etsf_io_low_check_var(var_nc, var_user, my_start(1:var_nc%ncshape), &
                           & my_count(1:var_nc%ncshape), &
                           & my_map(1:var_nc%ncshape), &
                           & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  
  ! Now that we are sure that the read var has compatible type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_var(ncid, var_nc%ncid, values = var, &
                 & start = my_start(1:max(1, var_nc%ncshape)) &
                 & ,count = my_count(1:max(1, var_nc%ncshape)) &
                 & ,map = my_map(1:max(1, var_nc%ncshape)) &
                 & )
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_VAR, &
                    & me, tgtname = varname, tgtid = var_nc%ncid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  if (present(ncvarid)) then
    ncvarid = var_nc%ncid
  end if
  lstat = .true.
end subroutine read_var_double_2D

subroutine read_var_double_3D(ncid, varname, var, lstat, &
    & start, count, map, ncvarid, error_data)
  integer, intent(in)                            :: ncid
  double precision, intent(out) :: var(:,:,:)
  character(len = *), intent(in)                 :: varname
  logical, intent(out)                           :: lstat
  integer, intent(in), optional                  :: start(:), count(:), map(:)
  integer, intent(out), optional                 :: ncvarid
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_var_double_3D"
  character(len = 80) :: err
  type(etsf_io_low_var_infos) :: var_nc, var_user
  type(etsf_io_low_error) :: error
  integer :: s, i
  integer :: my_start(16), my_count(16), my_map(16)
  logical :: stat

  lstat = .false.
  ! We get the dimensions and shape of the ref variable in the NetCDF file.
  call etsf_io_low_read_var_infos(ncid, varname, var_nc, &
                                & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  var_user%name = varname
  var_user%nctype = NF90_DOUBLE
  var_user%ncshape = 3
  var_user%ncdims(1:3) = shape(var)
  !var_user%ncdims(1) = charlen
  
  ! Create the access arrays from optional arguments.
  if (present(start) .and. present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & opt_map = map, error_data = error)
  else if (present(start) .and. present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & error_data = error)
  else if (present(start) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_map = map, &
                               & error_data = error)
  else if (present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, opt_map = map, &
                               & error_data = error)
  else if (present(start)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, error_data = error)
  else if (present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, error_data = error)
  else if (present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_map = map, error_data = error)
  else
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, &
                               & stat, error_data = error)
  end if
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
    
  ! Number of elements checks
  call etsf_io_low_check_var(var_nc, var_user, my_start(1:var_nc%ncshape), &
                           & my_count(1:var_nc%ncshape), &
                           & my_map(1:var_nc%ncshape), &
                           & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  
  ! Now that we are sure that the read var has compatible type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_var(ncid, var_nc%ncid, values = var, &
                 & start = my_start(1:max(1, var_nc%ncshape)) &
                 & ,count = my_count(1:max(1, var_nc%ncshape)) &
                 & ,map = my_map(1:max(1, var_nc%ncshape)) &
                 & )
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_VAR, &
                    & me, tgtname = varname, tgtid = var_nc%ncid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  if (present(ncvarid)) then
    ncvarid = var_nc%ncid
  end if
  lstat = .true.
end subroutine read_var_double_3D

subroutine read_var_double_4D(ncid, varname, var, lstat, &
    & start, count, map, ncvarid, error_data)
  integer, intent(in)                            :: ncid
  double precision, intent(out) :: var(:,:,:,:)
  character(len = *), intent(in)                 :: varname
  logical, intent(out)                           :: lstat
  integer, intent(in), optional                  :: start(:), count(:), map(:)
  integer, intent(out), optional                 :: ncvarid
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_var_double_4D"
  character(len = 80) :: err
  type(etsf_io_low_var_infos) :: var_nc, var_user
  type(etsf_io_low_error) :: error
  integer :: s, i
  integer :: my_start(16), my_count(16), my_map(16)
  logical :: stat

  lstat = .false.
  ! We get the dimensions and shape of the ref variable in the NetCDF file.
  call etsf_io_low_read_var_infos(ncid, varname, var_nc, &
                                & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  var_user%name = varname
  var_user%nctype = NF90_DOUBLE
  var_user%ncshape = 4
  var_user%ncdims(1:4) = shape(var)
  !var_user%ncdims(1) = charlen
  
  ! Create the access arrays from optional arguments.
  if (present(start) .and. present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & opt_map = map, error_data = error)
  else if (present(start) .and. present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & error_data = error)
  else if (present(start) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_map = map, &
                               & error_data = error)
  else if (present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, opt_map = map, &
                               & error_data = error)
  else if (present(start)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, error_data = error)
  else if (present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, error_data = error)
  else if (present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_map = map, error_data = error)
  else
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, &
                               & stat, error_data = error)
  end if
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
    
  ! Number of elements checks
  call etsf_io_low_check_var(var_nc, var_user, my_start(1:var_nc%ncshape), &
                           & my_count(1:var_nc%ncshape), &
                           & my_map(1:var_nc%ncshape), &
                           & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  
  ! Now that we are sure that the read var has compatible type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_var(ncid, var_nc%ncid, values = var, &
                 & start = my_start(1:max(1, var_nc%ncshape)) &
                 & ,count = my_count(1:max(1, var_nc%ncshape)) &
                 & ,map = my_map(1:max(1, var_nc%ncshape)) &
                 & )
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_VAR, &
                    & me, tgtname = varname, tgtid = var_nc%ncid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  if (present(ncvarid)) then
    ncvarid = var_nc%ncid
  end if
  lstat = .true.
end subroutine read_var_double_4D

subroutine read_var_double_5D(ncid, varname, var, lstat, &
    & start, count, map, ncvarid, error_data)
  integer, intent(in)                            :: ncid
  double precision, intent(out) :: var(:,:,:,:,:)
  character(len = *), intent(in)                 :: varname
  logical, intent(out)                           :: lstat
  integer, intent(in), optional                  :: start(:), count(:), map(:)
  integer, intent(out), optional                 :: ncvarid
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_var_double_5D"
  character(len = 80) :: err
  type(etsf_io_low_var_infos) :: var_nc, var_user
  type(etsf_io_low_error) :: error
  integer :: s, i
  integer :: my_start(16), my_count(16), my_map(16)
  logical :: stat

  lstat = .false.
  ! We get the dimensions and shape of the ref variable in the NetCDF file.
  call etsf_io_low_read_var_infos(ncid, varname, var_nc, &
                                & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  var_user%name = varname
  var_user%nctype = NF90_DOUBLE
  var_user%ncshape = 5
  var_user%ncdims(1:5) = shape(var)
  !var_user%ncdims(1) = charlen
  
  ! Create the access arrays from optional arguments.
  if (present(start) .and. present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & opt_map = map, error_data = error)
  else if (present(start) .and. present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & error_data = error)
  else if (present(start) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_map = map, &
                               & error_data = error)
  else if (present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, opt_map = map, &
                               & error_data = error)
  else if (present(start)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, error_data = error)
  else if (present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, error_data = error)
  else if (present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_map = map, error_data = error)
  else
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, &
                               & stat, error_data = error)
  end if
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
    
  ! Number of elements checks
  call etsf_io_low_check_var(var_nc, var_user, my_start(1:var_nc%ncshape), &
                           & my_count(1:var_nc%ncshape), &
                           & my_map(1:var_nc%ncshape), &
                           & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  
  ! Now that we are sure that the read var has compatible type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_var(ncid, var_nc%ncid, values = var, &
                 & start = my_start(1:max(1, var_nc%ncshape)) &
                 & ,count = my_count(1:max(1, var_nc%ncshape)) &
                 & ,map = my_map(1:max(1, var_nc%ncshape)) &
                 & )
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_VAR, &
                    & me, tgtname = varname, tgtid = var_nc%ncid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  if (present(ncvarid)) then
    ncvarid = var_nc%ncid
  end if
  lstat = .true.
end subroutine read_var_double_5D

subroutine read_var_double_6D(ncid, varname, var, lstat, &
    & start, count, map, ncvarid, error_data)
  integer, intent(in)                            :: ncid
  double precision, intent(out) :: var(:,:,:,:,:,:)
  character(len = *), intent(in)                 :: varname
  logical, intent(out)                           :: lstat
  integer, intent(in), optional                  :: start(:), count(:), map(:)
  integer, intent(out), optional                 :: ncvarid
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_var_double_6D"
  character(len = 80) :: err
  type(etsf_io_low_var_infos) :: var_nc, var_user
  type(etsf_io_low_error) :: error
  integer :: s, i
  integer :: my_start(16), my_count(16), my_map(16)
  logical :: stat

  lstat = .false.
  ! We get the dimensions and shape of the ref variable in the NetCDF file.
  call etsf_io_low_read_var_infos(ncid, varname, var_nc, &
                                & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  var_user%name = varname
  var_user%nctype = NF90_DOUBLE
  var_user%ncshape = 6
  var_user%ncdims(1:6) = shape(var)
  !var_user%ncdims(1) = charlen
  
  ! Create the access arrays from optional arguments.
  if (present(start) .and. present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & opt_map = map, error_data = error)
  else if (present(start) .and. present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & error_data = error)
  else if (present(start) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_map = map, &
                               & error_data = error)
  else if (present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, opt_map = map, &
                               & error_data = error)
  else if (present(start)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, error_data = error)
  else if (present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, error_data = error)
  else if (present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_map = map, error_data = error)
  else
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, &
                               & stat, error_data = error)
  end if
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
    
  ! Number of elements checks
  call etsf_io_low_check_var(var_nc, var_user, my_start(1:var_nc%ncshape), &
                           & my_count(1:var_nc%ncshape), &
                           & my_map(1:var_nc%ncshape), &
                           & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  
  ! Now that we are sure that the read var has compatible type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_var(ncid, var_nc%ncid, values = var, &
                 & start = my_start(1:max(1, var_nc%ncshape)) &
                 & ,count = my_count(1:max(1, var_nc%ncshape)) &
                 & ,map = my_map(1:max(1, var_nc%ncshape)) &
                 & )
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_VAR, &
                    & me, tgtname = varname, tgtid = var_nc%ncid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  if (present(ncvarid)) then
    ncvarid = var_nc%ncid
  end if
  lstat = .true.
end subroutine read_var_double_6D

subroutine read_var_double_7D(ncid, varname, var, lstat, &
    & start, count, map, ncvarid, error_data)
  integer, intent(in)                            :: ncid
  double precision, intent(out) :: var(:,:,:,:,:,:,:)
  character(len = *), intent(in)                 :: varname
  logical, intent(out)                           :: lstat
  integer, intent(in), optional                  :: start(:), count(:), map(:)
  integer, intent(out), optional                 :: ncvarid
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_var_double_7D"
  character(len = 80) :: err
  type(etsf_io_low_var_infos) :: var_nc, var_user
  type(etsf_io_low_error) :: error
  integer :: s, i
  integer :: my_start(16), my_count(16), my_map(16)
  logical :: stat

  lstat = .false.
  ! We get the dimensions and shape of the ref variable in the NetCDF file.
  call etsf_io_low_read_var_infos(ncid, varname, var_nc, &
                                & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  var_user%name = varname
  var_user%nctype = NF90_DOUBLE
  var_user%ncshape = 7
  var_user%ncdims(1:7) = shape(var)
  !var_user%ncdims(1) = charlen
  
  ! Create the access arrays from optional arguments.
  if (present(start) .and. present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & opt_map = map, error_data = error)
  else if (present(start) .and. present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & error_data = error)
  else if (present(start) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_map = map, &
                               & error_data = error)
  else if (present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, opt_map = map, &
                               & error_data = error)
  else if (present(start)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, error_data = error)
  else if (present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, error_data = error)
  else if (present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_map = map, error_data = error)
  else
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, &
                               & stat, error_data = error)
  end if
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
    
  ! Number of elements checks
  call etsf_io_low_check_var(var_nc, var_user, my_start(1:var_nc%ncshape), &
                           & my_count(1:var_nc%ncshape), &
                           & my_map(1:var_nc%ncshape), &
                           & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  
  ! Now that we are sure that the read var has compatible type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_var(ncid, var_nc%ncid, values = var, &
                 & start = my_start(1:max(1, var_nc%ncshape)) &
                 & ,count = my_count(1:max(1, var_nc%ncshape)) &
                 & ,map = my_map(1:max(1, var_nc%ncshape)) &
                 & )
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_VAR, &
                    & me, tgtname = varname, tgtid = var_nc%ncid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  if (present(ncvarid)) then
    ncvarid = var_nc%ncid
  end if
  lstat = .true.
end subroutine read_var_double_7D

subroutine read_var_character_1D(ncid, varname, var, charlen, lstat, &
    & start, count, map, ncvarid, error_data)
  integer, intent(in)                            :: ncid, charlen
  character(len = charlen), intent(out) :: var
  character(len = *), intent(in)                 :: varname
  logical, intent(out)                           :: lstat
  integer, intent(in), optional                  :: start(:), count(:), map(:)
  integer, intent(out), optional                 :: ncvarid
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_var_character_1D"
  character(len = 80) :: err
  type(etsf_io_low_var_infos) :: var_nc, var_user
  type(etsf_io_low_error) :: error
  integer :: s, i
  integer :: my_start(16), my_count(16), my_map(16)
  logical :: stat

  lstat = .false.
  ! We get the dimensions and shape of the ref variable in the NetCDF file.
  call etsf_io_low_read_var_infos(ncid, varname, var_nc, &
                                & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  var_user%name = varname
  var_user%nctype = NF90_CHAR
  var_user%ncshape = 1
  !var_user%ncdims(2:1) = shape(var)
  var_user%ncdims(1) = charlen
  
  ! Create the access arrays from optional arguments.
  if (present(start) .and. present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & opt_map = map, error_data = error)
  else if (present(start) .and. present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & error_data = error)
  else if (present(start) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_map = map, &
                               & error_data = error)
  else if (present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, opt_map = map, &
                               & error_data = error)
  else if (present(start)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, error_data = error)
  else if (present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, error_data = error)
  else if (present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_map = map, error_data = error)
  else
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, &
                               & stat, error_data = error)
  end if
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
    
  ! Number of elements checks
  call etsf_io_low_check_var(var_nc, var_user, my_start(1:var_nc%ncshape), &
                           & my_count(1:var_nc%ncshape), &
                           & my_map(1:var_nc%ncshape), &
                           & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  
  ! Now that we are sure that the read var has compatible type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_var(ncid, var_nc%ncid, values = var, &
                 & start = my_start(1:max(1, var_nc%ncshape)) &
  !               & ,count = my_count(1:max(1, var_nc%ncshape)) &
  !               & ,map = my_map(1:max(1, var_nc%ncshape)) &
                 & )
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_VAR, &
                    & me, tgtname = varname, tgtid = var_nc%ncid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  if (present(ncvarid)) then
    ncvarid = var_nc%ncid
  end if
  lstat = .true.
end subroutine read_var_character_1D

subroutine read_var_character_2D(ncid, varname, var, charlen, lstat, &
    & start, count, map, ncvarid, error_data)
  integer, intent(in)                            :: ncid, charlen
  character(len = charlen), intent(out) :: var(:)
  character(len = *), intent(in)                 :: varname
  logical, intent(out)                           :: lstat
  integer, intent(in), optional                  :: start(:), count(:), map(:)
  integer, intent(out), optional                 :: ncvarid
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_var_character_2D"
  character(len = 80) :: err
  type(etsf_io_low_var_infos) :: var_nc, var_user
  type(etsf_io_low_error) :: error
  integer :: s, i
  integer :: my_start(16), my_count(16), my_map(16)
  logical :: stat

  lstat = .false.
  ! We get the dimensions and shape of the ref variable in the NetCDF file.
  call etsf_io_low_read_var_infos(ncid, varname, var_nc, &
                                & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  var_user%name = varname
  var_user%nctype = NF90_CHAR
  var_user%ncshape = 2
  var_user%ncdims(2:2) = shape(var)
  var_user%ncdims(1) = charlen
  
  ! Create the access arrays from optional arguments.
  if (present(start) .and. present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & opt_map = map, error_data = error)
  else if (present(start) .and. present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & error_data = error)
  else if (present(start) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_map = map, &
                               & error_data = error)
  else if (present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, opt_map = map, &
                               & error_data = error)
  else if (present(start)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, error_data = error)
  else if (present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, error_data = error)
  else if (present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_map = map, error_data = error)
  else
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, &
                               & stat, error_data = error)
  end if
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
    
  ! Number of elements checks
  call etsf_io_low_check_var(var_nc, var_user, my_start(1:var_nc%ncshape), &
                           & my_count(1:var_nc%ncshape), &
                           & my_map(1:var_nc%ncshape), &
                           & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  
  ! Now that we are sure that the read var has compatible type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_var(ncid, var_nc%ncid, values = var, &
                 & start = my_start(1:max(1, var_nc%ncshape)) &
                 & ,count = my_count(1:max(1, var_nc%ncshape)) &
                 & ,map = my_map(1:max(1, var_nc%ncshape)) &
                 & )
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_VAR, &
                    & me, tgtname = varname, tgtid = var_nc%ncid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  if (present(ncvarid)) then
    ncvarid = var_nc%ncid
  end if
  lstat = .true.
end subroutine read_var_character_2D

subroutine read_var_character_3D(ncid, varname, var, charlen, lstat, &
    & start, count, map, ncvarid, error_data)
  integer, intent(in)                            :: ncid, charlen
  character(len = charlen), intent(out) :: var(:,:)
  character(len = *), intent(in)                 :: varname
  logical, intent(out)                           :: lstat
  integer, intent(in), optional                  :: start(:), count(:), map(:)
  integer, intent(out), optional                 :: ncvarid
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_var_character_3D"
  character(len = 80) :: err
  type(etsf_io_low_var_infos) :: var_nc, var_user
  type(etsf_io_low_error) :: error
  integer :: s, i
  integer :: my_start(16), my_count(16), my_map(16)
  logical :: stat

  lstat = .false.
  ! We get the dimensions and shape of the ref variable in the NetCDF file.
  call etsf_io_low_read_var_infos(ncid, varname, var_nc, &
                                & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  var_user%name = varname
  var_user%nctype = NF90_CHAR
  var_user%ncshape = 3
  var_user%ncdims(2:3) = shape(var)
  var_user%ncdims(1) = charlen
  
  ! Create the access arrays from optional arguments.
  if (present(start) .and. present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & opt_map = map, error_data = error)
  else if (present(start) .and. present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & error_data = error)
  else if (present(start) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_map = map, &
                               & error_data = error)
  else if (present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, opt_map = map, &
                               & error_data = error)
  else if (present(start)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, error_data = error)
  else if (present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, error_data = error)
  else if (present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_map = map, error_data = error)
  else
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, &
                               & stat, error_data = error)
  end if
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
    
  ! Number of elements checks
  call etsf_io_low_check_var(var_nc, var_user, my_start(1:var_nc%ncshape), &
                           & my_count(1:var_nc%ncshape), &
                           & my_map(1:var_nc%ncshape), &
                           & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  
  ! Now that we are sure that the read var has compatible type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_var(ncid, var_nc%ncid, values = var, &
                 & start = my_start(1:max(1, var_nc%ncshape)) &
                 & ,count = my_count(1:max(1, var_nc%ncshape)) &
                 & ,map = my_map(1:max(1, var_nc%ncshape)) &
                 & )
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_VAR, &
                    & me, tgtname = varname, tgtid = var_nc%ncid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  if (present(ncvarid)) then
    ncvarid = var_nc%ncid
  end if
  lstat = .true.
end subroutine read_var_character_3D

subroutine read_var_character_4D(ncid, varname, var, charlen, lstat, &
    & start, count, map, ncvarid, error_data)
  integer, intent(in)                            :: ncid, charlen
  character(len = charlen), intent(out) :: var(:,:,:)
  character(len = *), intent(in)                 :: varname
  logical, intent(out)                           :: lstat
  integer, intent(in), optional                  :: start(:), count(:), map(:)
  integer, intent(out), optional                 :: ncvarid
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_var_character_4D"
  character(len = 80) :: err
  type(etsf_io_low_var_infos) :: var_nc, var_user
  type(etsf_io_low_error) :: error
  integer :: s, i
  integer :: my_start(16), my_count(16), my_map(16)
  logical :: stat

  lstat = .false.
  ! We get the dimensions and shape of the ref variable in the NetCDF file.
  call etsf_io_low_read_var_infos(ncid, varname, var_nc, &
                                & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  var_user%name = varname
  var_user%nctype = NF90_CHAR
  var_user%ncshape = 4
  var_user%ncdims(2:4) = shape(var)
  var_user%ncdims(1) = charlen
  
  ! Create the access arrays from optional arguments.
  if (present(start) .and. present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & opt_map = map, error_data = error)
  else if (present(start) .and. present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & error_data = error)
  else if (present(start) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_map = map, &
                               & error_data = error)
  else if (present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, opt_map = map, &
                               & error_data = error)
  else if (present(start)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, error_data = error)
  else if (present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, error_data = error)
  else if (present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_map = map, error_data = error)
  else
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, &
                               & stat, error_data = error)
  end if
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
    
  ! Number of elements checks
  call etsf_io_low_check_var(var_nc, var_user, my_start(1:var_nc%ncshape), &
                           & my_count(1:var_nc%ncshape), &
                           & my_map(1:var_nc%ncshape), &
                           & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  
  ! Now that we are sure that the read var has compatible type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_var(ncid, var_nc%ncid, values = var, &
                 & start = my_start(1:max(1, var_nc%ncshape)) &
                 & ,count = my_count(1:max(1, var_nc%ncshape)) &
                 & ,map = my_map(1:max(1, var_nc%ncshape)) &
                 & )
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_VAR, &
                    & me, tgtname = varname, tgtid = var_nc%ncid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  if (present(ncvarid)) then
    ncvarid = var_nc%ncid
  end if
  lstat = .true.
end subroutine read_var_character_4D

subroutine read_var_character_5D(ncid, varname, var, charlen, lstat, &
    & start, count, map, ncvarid, error_data)
  integer, intent(in)                            :: ncid, charlen
  character(len = charlen), intent(out) :: var(:,:,:,:)
  character(len = *), intent(in)                 :: varname
  logical, intent(out)                           :: lstat
  integer, intent(in), optional                  :: start(:), count(:), map(:)
  integer, intent(out), optional                 :: ncvarid
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_var_character_5D"
  character(len = 80) :: err
  type(etsf_io_low_var_infos) :: var_nc, var_user
  type(etsf_io_low_error) :: error
  integer :: s, i
  integer :: my_start(16), my_count(16), my_map(16)
  logical :: stat

  lstat = .false.
  ! We get the dimensions and shape of the ref variable in the NetCDF file.
  call etsf_io_low_read_var_infos(ncid, varname, var_nc, &
                                & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  var_user%name = varname
  var_user%nctype = NF90_CHAR
  var_user%ncshape = 5
  var_user%ncdims(2:5) = shape(var)
  var_user%ncdims(1) = charlen
  
  ! Create the access arrays from optional arguments.
  if (present(start) .and. present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & opt_map = map, error_data = error)
  else if (present(start) .and. present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & error_data = error)
  else if (present(start) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_map = map, &
                               & error_data = error)
  else if (present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, opt_map = map, &
                               & error_data = error)
  else if (present(start)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, error_data = error)
  else if (present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, error_data = error)
  else if (present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_map = map, error_data = error)
  else
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, &
                               & stat, error_data = error)
  end if
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
    
  ! Number of elements checks
  call etsf_io_low_check_var(var_nc, var_user, my_start(1:var_nc%ncshape), &
                           & my_count(1:var_nc%ncshape), &
                           & my_map(1:var_nc%ncshape), &
                           & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  
  ! Now that we are sure that the read var has compatible type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_var(ncid, var_nc%ncid, values = var, &
                 & start = my_start(1:max(1, var_nc%ncshape)) &
                 & ,count = my_count(1:max(1, var_nc%ncshape)) &
                 & ,map = my_map(1:max(1, var_nc%ncshape)) &
                 & )
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_VAR, &
                    & me, tgtname = varname, tgtid = var_nc%ncid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  if (present(ncvarid)) then
    ncvarid = var_nc%ncid
  end if
  lstat = .true.
end subroutine read_var_character_5D

subroutine read_var_character_6D(ncid, varname, var, charlen, lstat, &
    & start, count, map, ncvarid, error_data)
  integer, intent(in)                            :: ncid, charlen
  character(len = charlen), intent(out) :: var(:,:,:,:,:)
  character(len = *), intent(in)                 :: varname
  logical, intent(out)                           :: lstat
  integer, intent(in), optional                  :: start(:), count(:), map(:)
  integer, intent(out), optional                 :: ncvarid
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_var_character_6D"
  character(len = 80) :: err
  type(etsf_io_low_var_infos) :: var_nc, var_user
  type(etsf_io_low_error) :: error
  integer :: s, i
  integer :: my_start(16), my_count(16), my_map(16)
  logical :: stat

  lstat = .false.
  ! We get the dimensions and shape of the ref variable in the NetCDF file.
  call etsf_io_low_read_var_infos(ncid, varname, var_nc, &
                                & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  var_user%name = varname
  var_user%nctype = NF90_CHAR
  var_user%ncshape = 6
  var_user%ncdims(2:6) = shape(var)
  var_user%ncdims(1) = charlen
  
  ! Create the access arrays from optional arguments.
  if (present(start) .and. present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & opt_map = map, error_data = error)
  else if (present(start) .and. present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & error_data = error)
  else if (present(start) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_map = map, &
                               & error_data = error)
  else if (present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, opt_map = map, &
                               & error_data = error)
  else if (present(start)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, error_data = error)
  else if (present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, error_data = error)
  else if (present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_map = map, error_data = error)
  else
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, &
                               & stat, error_data = error)
  end if
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
    
  ! Number of elements checks
  call etsf_io_low_check_var(var_nc, var_user, my_start(1:var_nc%ncshape), &
                           & my_count(1:var_nc%ncshape), &
                           & my_map(1:var_nc%ncshape), &
                           & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  
  ! Now that we are sure that the read var has compatible type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_var(ncid, var_nc%ncid, values = var, &
                 & start = my_start(1:max(1, var_nc%ncshape)) &
                 & ,count = my_count(1:max(1, var_nc%ncshape)) &
                 & ,map = my_map(1:max(1, var_nc%ncshape)) &
                 & )
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_VAR, &
                    & me, tgtname = varname, tgtid = var_nc%ncid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  if (present(ncvarid)) then
    ncvarid = var_nc%ncid
  end if
  lstat = .true.
end subroutine read_var_character_6D

subroutine read_var_character_7D(ncid, varname, var, charlen, lstat, &
    & start, count, map, ncvarid, error_data)
  integer, intent(in)                            :: ncid, charlen
  character(len = charlen), intent(out) :: var(:,:,:,:,:,:)
  character(len = *), intent(in)                 :: varname
  logical, intent(out)                           :: lstat
  integer, intent(in), optional                  :: start(:), count(:), map(:)
  integer, intent(out), optional                 :: ncvarid
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_var_character_7D"
  character(len = 80) :: err
  type(etsf_io_low_var_infos) :: var_nc, var_user
  type(etsf_io_low_error) :: error
  integer :: s, i
  integer :: my_start(16), my_count(16), my_map(16)
  logical :: stat

  lstat = .false.
  ! We get the dimensions and shape of the ref variable in the NetCDF file.
  call etsf_io_low_read_var_infos(ncid, varname, var_nc, &
                                & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  var_user%name = varname
  var_user%nctype = NF90_CHAR
  var_user%ncshape = 7
  var_user%ncdims(2:7) = shape(var)
  var_user%ncdims(1) = charlen
  
  ! Create the access arrays from optional arguments.
  if (present(start) .and. present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & opt_map = map, error_data = error)
  else if (present(start) .and. present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_count = count, &
                               & error_data = error)
  else if (present(start) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, opt_map = map, &
                               & error_data = error)
  else if (present(count) .and. present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, opt_map = map, &
                               & error_data = error)
  else if (present(start)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_start = start, error_data = error)
  else if (present(count)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_count = count, error_data = error)
  else if (present(map)) then
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, stat, &
                               & opt_map = map, error_data = error)
  else
    call etsf_io_low_make_access(my_start, my_count, my_map, var_nc, &
                               & stat, error_data = error)
  end if
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
    
  ! Number of elements checks
  call etsf_io_low_check_var(var_nc, var_user, my_start(1:var_nc%ncshape), &
                           & my_count(1:var_nc%ncshape), &
                           & my_map(1:var_nc%ncshape), &
                           & stat, error_data = error)
  if (.not. stat) then
    if (present(error_data)) then
      error_data = error
      if (.not. lstat) call etsf_io_low_error_update(error_data, me)
    end if
    return
  end if
  
  ! Now that we are sure that the read var has compatible type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_var(ncid, var_nc%ncid, values = var, &
                 & start = my_start(1:max(1, var_nc%ncshape)) &
                 & ,count = my_count(1:max(1, var_nc%ncshape)) &
                 & ,map = my_map(1:max(1, var_nc%ncshape)) &
                 & )
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_VAR, &
                    & me, tgtname = varname, tgtid = var_nc%ncid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  if (present(ncvarid)) then
    ncvarid = var_nc%ncid
  end if
  lstat = .true.
end subroutine read_var_character_7D

subroutine read_att_integer_0D(ncid, varname, attname, att, &
    & lstat, error_data)
  character(len = *), intent(in)                            :: varname
  !integer, intent(in)                            :: attlen
  integer, intent(out)                    :: att
  integer, intent(in)                            :: ncid
  character(len = *), intent(in)                 :: attname
  logical, intent(out)                           :: lstat
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_att_integer_0D"
  integer :: s
  type(etsf_io_low_var_infos) :: var_infos
  lstat = .false.
  
  
  if (present(error_data)) then
    call etsf_io_low_read_var_infos(ncid, varname, var_infos, &
                                  & lstat, error_data = error_data)
    if (.not. lstat) call etsf_io_low_error_update(error_data, me)
  else
    call etsf_io_low_read_var_infos(ncid, varname, var_infos, lstat)
  end if
  if (.not. lstat) return
  
  ! We first check the definition of the attribute (name, type and dims)
  if (present(error_data)) then
    call etsf_io_low_check_att(ncid, var_infos%ncid, attname, NF90_INT, &
                             & 1, lstat, error_data = error_data)
    if (.not. lstat) call etsf_io_low_error_update(error_data, me)
  else
    call etsf_io_low_check_att(ncid, var_infos%ncid, attname, NF90_INT, &
                             & 1, lstat)
  end if
  if (.not. lstat) return
  ! Now that we are sure that the read attribute has the same type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_att(ncid, var_infos%ncid, attname, att)
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_ATT, &
                    & me, tgtname = attname, tgtid = var_infos%ncid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  lstat = .true.
end subroutine read_att_integer_0D

subroutine read_att_id_integer_0D(ncid, ncvarid, attname, att, &
    & lstat, error_data)
  integer, intent(in)                            :: ncvarid
  !integer, intent(in)                            :: attlen
  integer, intent(out)                    :: att
  integer, intent(in)                            :: ncid
  character(len = *), intent(in)                 :: attname
  logical, intent(out)                           :: lstat
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_att_id_integer_0D"
  integer :: s

  lstat = .false.
  
  
  
  ! We first check the definition of the attribute (name, type and dims)
  if (present(error_data)) then
    call etsf_io_low_check_att(ncid, ncvarid, attname, NF90_INT, &
                             & 1, lstat, error_data = error_data)
    if (.not. lstat) call etsf_io_low_error_update(error_data, me)
  else
    call etsf_io_low_check_att(ncid, ncvarid, attname, NF90_INT, &
                             & 1, lstat)
  end if
  if (.not. lstat) return
  ! Now that we are sure that the read attribute has the same type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_att(ncid, ncvarid, attname, att)
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_ATT, &
                    & me, tgtname = attname, tgtid = ncvarid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  lstat = .true.
end subroutine read_att_id_integer_0D

subroutine read_att_integer_1D(ncid, varname, attname, attlen, att, &
    & lstat, error_data)
  character(len = *), intent(in)                            :: varname
  integer, intent(in)                            :: attlen
  integer, intent(out)                    :: att(1:attlen)
  integer, intent(in)                            :: ncid
  character(len = *), intent(in)                 :: attname
  logical, intent(out)                           :: lstat
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_att_integer_1D"
  integer :: s
  type(etsf_io_low_var_infos) :: var_infos
  lstat = .false.
  
  
  if (present(error_data)) then
    call etsf_io_low_read_var_infos(ncid, varname, var_infos, &
                                  & lstat, error_data = error_data)
    if (.not. lstat) call etsf_io_low_error_update(error_data, me)
  else
    call etsf_io_low_read_var_infos(ncid, varname, var_infos, lstat)
  end if
  if (.not. lstat) return
  
  ! We first check the definition of the attribute (name, type and dims)
  if (present(error_data)) then
    call etsf_io_low_check_att(ncid, var_infos%ncid, attname, NF90_INT, &
                             & attlen, lstat, error_data = error_data)
    if (.not. lstat) call etsf_io_low_error_update(error_data, me)
  else
    call etsf_io_low_check_att(ncid, var_infos%ncid, attname, NF90_INT, &
                             & attlen, lstat)
  end if
  if (.not. lstat) return
  ! Now that we are sure that the read attribute has the same type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_att(ncid, var_infos%ncid, attname, att)
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_ATT, &
                    & me, tgtname = attname, tgtid = var_infos%ncid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  lstat = .true.
end subroutine read_att_integer_1D

subroutine read_att_id_integer_1D(ncid, ncvarid, attname, attlen, att, &
    & lstat, error_data)
  integer, intent(in)                            :: ncvarid
  integer, intent(in)                            :: attlen
  integer, intent(out)                    :: att(1:attlen)
  integer, intent(in)                            :: ncid
  character(len = *), intent(in)                 :: attname
  logical, intent(out)                           :: lstat
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_att_id_integer_1D"
  integer :: s

  lstat = .false.
  
  
  
  ! We first check the definition of the attribute (name, type and dims)
  if (present(error_data)) then
    call etsf_io_low_check_att(ncid, ncvarid, attname, NF90_INT, &
                             & attlen, lstat, error_data = error_data)
    if (.not. lstat) call etsf_io_low_error_update(error_data, me)
  else
    call etsf_io_low_check_att(ncid, ncvarid, attname, NF90_INT, &
                             & attlen, lstat)
  end if
  if (.not. lstat) return
  ! Now that we are sure that the read attribute has the same type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_att(ncid, ncvarid, attname, att)
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_ATT, &
                    & me, tgtname = attname, tgtid = ncvarid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  lstat = .true.
end subroutine read_att_id_integer_1D

subroutine read_att_real_0D(ncid, varname, attname, att, &
    & lstat, error_data)
  character(len = *), intent(in)                            :: varname
  !integer, intent(in)                            :: attlen
  real, intent(out)                    :: att
  integer, intent(in)                            :: ncid
  character(len = *), intent(in)                 :: attname
  logical, intent(out)                           :: lstat
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_att_real_0D"
  integer :: s
  type(etsf_io_low_var_infos) :: var_infos
  lstat = .false.
  
  
  if (present(error_data)) then
    call etsf_io_low_read_var_infos(ncid, varname, var_infos, &
                                  & lstat, error_data = error_data)
    if (.not. lstat) call etsf_io_low_error_update(error_data, me)
  else
    call etsf_io_low_read_var_infos(ncid, varname, var_infos, lstat)
  end if
  if (.not. lstat) return
  
  ! We first check the definition of the attribute (name, type and dims)
  if (present(error_data)) then
    call etsf_io_low_check_att(ncid, var_infos%ncid, attname, NF90_FLOAT, &
                             & 1, lstat, error_data = error_data)
    if (.not. lstat) call etsf_io_low_error_update(error_data, me)
  else
    call etsf_io_low_check_att(ncid, var_infos%ncid, attname, NF90_FLOAT, &
                             & 1, lstat)
  end if
  if (.not. lstat) return
  ! Now that we are sure that the read attribute has the same type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_att(ncid, var_infos%ncid, attname, att)
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_ATT, &
                    & me, tgtname = attname, tgtid = var_infos%ncid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  lstat = .true.
end subroutine read_att_real_0D

subroutine read_att_id_real_0D(ncid, ncvarid, attname, att, &
    & lstat, error_data)
  integer, intent(in)                            :: ncvarid
  !integer, intent(in)                            :: attlen
  real, intent(out)                    :: att
  integer, intent(in)                            :: ncid
  character(len = *), intent(in)                 :: attname
  logical, intent(out)                           :: lstat
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_att_id_real_0D"
  integer :: s

  lstat = .false.
  
  
  
  ! We first check the definition of the attribute (name, type and dims)
  if (present(error_data)) then
    call etsf_io_low_check_att(ncid, ncvarid, attname, NF90_FLOAT, &
                             & 1, lstat, error_data = error_data)
    if (.not. lstat) call etsf_io_low_error_update(error_data, me)
  else
    call etsf_io_low_check_att(ncid, ncvarid, attname, NF90_FLOAT, &
                             & 1, lstat)
  end if
  if (.not. lstat) return
  ! Now that we are sure that the read attribute has the same type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_att(ncid, ncvarid, attname, att)
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_ATT, &
                    & me, tgtname = attname, tgtid = ncvarid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  lstat = .true.
end subroutine read_att_id_real_0D

subroutine read_att_real_1D(ncid, varname, attname, attlen, att, &
    & lstat, error_data)
  character(len = *), intent(in)                            :: varname
  integer, intent(in)                            :: attlen
  real, intent(out)                    :: att(1:attlen)
  integer, intent(in)                            :: ncid
  character(len = *), intent(in)                 :: attname
  logical, intent(out)                           :: lstat
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_att_real_1D"
  integer :: s
  type(etsf_io_low_var_infos) :: var_infos
  lstat = .false.
  
  
  if (present(error_data)) then
    call etsf_io_low_read_var_infos(ncid, varname, var_infos, &
                                  & lstat, error_data = error_data)
    if (.not. lstat) call etsf_io_low_error_update(error_data, me)
  else
    call etsf_io_low_read_var_infos(ncid, varname, var_infos, lstat)
  end if
  if (.not. lstat) return
  
  ! We first check the definition of the attribute (name, type and dims)
  if (present(error_data)) then
    call etsf_io_low_check_att(ncid, var_infos%ncid, attname, NF90_FLOAT, &
                             & attlen, lstat, error_data = error_data)
    if (.not. lstat) call etsf_io_low_error_update(error_data, me)
  else
    call etsf_io_low_check_att(ncid, var_infos%ncid, attname, NF90_FLOAT, &
                             & attlen, lstat)
  end if
  if (.not. lstat) return
  ! Now that we are sure that the read attribute has the same type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_att(ncid, var_infos%ncid, attname, att)
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_ATT, &
                    & me, tgtname = attname, tgtid = var_infos%ncid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  lstat = .true.
end subroutine read_att_real_1D

subroutine read_att_id_real_1D(ncid, ncvarid, attname, attlen, att, &
    & lstat, error_data)
  integer, intent(in)                            :: ncvarid
  integer, intent(in)                            :: attlen
  real, intent(out)                    :: att(1:attlen)
  integer, intent(in)                            :: ncid
  character(len = *), intent(in)                 :: attname
  logical, intent(out)                           :: lstat
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_att_id_real_1D"
  integer :: s

  lstat = .false.
  
  
  
  ! We first check the definition of the attribute (name, type and dims)
  if (present(error_data)) then
    call etsf_io_low_check_att(ncid, ncvarid, attname, NF90_FLOAT, &
                             & attlen, lstat, error_data = error_data)
    if (.not. lstat) call etsf_io_low_error_update(error_data, me)
  else
    call etsf_io_low_check_att(ncid, ncvarid, attname, NF90_FLOAT, &
                             & attlen, lstat)
  end if
  if (.not. lstat) return
  ! Now that we are sure that the read attribute has the same type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_att(ncid, ncvarid, attname, att)
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_ATT, &
                    & me, tgtname = attname, tgtid = ncvarid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  lstat = .true.
end subroutine read_att_id_real_1D

subroutine read_att_double_0D(ncid, varname, attname, att, &
    & lstat, error_data)
  character(len = *), intent(in)                            :: varname
  !integer, intent(in)                            :: attlen
  double precision, intent(out)                    :: att
  integer, intent(in)                            :: ncid
  character(len = *), intent(in)                 :: attname
  logical, intent(out)                           :: lstat
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_att_double_0D"
  integer :: s
  type(etsf_io_low_var_infos) :: var_infos
  lstat = .false.
  
  
  if (present(error_data)) then
    call etsf_io_low_read_var_infos(ncid, varname, var_infos, &
                                  & lstat, error_data = error_data)
    if (.not. lstat) call etsf_io_low_error_update(error_data, me)
  else
    call etsf_io_low_read_var_infos(ncid, varname, var_infos, lstat)
  end if
  if (.not. lstat) return
  
  ! We first check the definition of the attribute (name, type and dims)
  if (present(error_data)) then
    call etsf_io_low_check_att(ncid, var_infos%ncid, attname, NF90_DOUBLE, &
                             & 1, lstat, error_data = error_data)
    if (.not. lstat) call etsf_io_low_error_update(error_data, me)
  else
    call etsf_io_low_check_att(ncid, var_infos%ncid, attname, NF90_DOUBLE, &
                             & 1, lstat)
  end if
  if (.not. lstat) return
  ! Now that we are sure that the read attribute has the same type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_att(ncid, var_infos%ncid, attname, att)
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_ATT, &
                    & me, tgtname = attname, tgtid = var_infos%ncid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  lstat = .true.
end subroutine read_att_double_0D

subroutine read_att_id_double_0D(ncid, ncvarid, attname, att, &
    & lstat, error_data)
  integer, intent(in)                            :: ncvarid
  !integer, intent(in)                            :: attlen
  double precision, intent(out)                    :: att
  integer, intent(in)                            :: ncid
  character(len = *), intent(in)                 :: attname
  logical, intent(out)                           :: lstat
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_att_id_double_0D"
  integer :: s

  lstat = .false.
  
  
  
  ! We first check the definition of the attribute (name, type and dims)
  if (present(error_data)) then
    call etsf_io_low_check_att(ncid, ncvarid, attname, NF90_DOUBLE, &
                             & 1, lstat, error_data = error_data)
    if (.not. lstat) call etsf_io_low_error_update(error_data, me)
  else
    call etsf_io_low_check_att(ncid, ncvarid, attname, NF90_DOUBLE, &
                             & 1, lstat)
  end if
  if (.not. lstat) return
  ! Now that we are sure that the read attribute has the same type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_att(ncid, ncvarid, attname, att)
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_ATT, &
                    & me, tgtname = attname, tgtid = ncvarid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  lstat = .true.
end subroutine read_att_id_double_0D

subroutine read_att_double_1D(ncid, varname, attname, attlen, att, &
    & lstat, error_data)
  character(len = *), intent(in)                            :: varname
  integer, intent(in)                            :: attlen
  double precision, intent(out)                    :: att(1:attlen)
  integer, intent(in)                            :: ncid
  character(len = *), intent(in)                 :: attname
  logical, intent(out)                           :: lstat
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_att_double_1D"
  integer :: s
  type(etsf_io_low_var_infos) :: var_infos
  lstat = .false.
  
  
  if (present(error_data)) then
    call etsf_io_low_read_var_infos(ncid, varname, var_infos, &
                                  & lstat, error_data = error_data)
    if (.not. lstat) call etsf_io_low_error_update(error_data, me)
  else
    call etsf_io_low_read_var_infos(ncid, varname, var_infos, lstat)
  end if
  if (.not. lstat) return
  
  ! We first check the definition of the attribute (name, type and dims)
  if (present(error_data)) then
    call etsf_io_low_check_att(ncid, var_infos%ncid, attname, NF90_DOUBLE, &
                             & attlen, lstat, error_data = error_data)
    if (.not. lstat) call etsf_io_low_error_update(error_data, me)
  else
    call etsf_io_low_check_att(ncid, var_infos%ncid, attname, NF90_DOUBLE, &
                             & attlen, lstat)
  end if
  if (.not. lstat) return
  ! Now that we are sure that the read attribute has the same type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_att(ncid, var_infos%ncid, attname, att)
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_ATT, &
                    & me, tgtname = attname, tgtid = var_infos%ncid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  lstat = .true.
end subroutine read_att_double_1D

subroutine read_att_id_double_1D(ncid, ncvarid, attname, attlen, att, &
    & lstat, error_data)
  integer, intent(in)                            :: ncvarid
  integer, intent(in)                            :: attlen
  double precision, intent(out)                    :: att(1:attlen)
  integer, intent(in)                            :: ncid
  character(len = *), intent(in)                 :: attname
  logical, intent(out)                           :: lstat
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_att_id_double_1D"
  integer :: s

  lstat = .false.
  
  
  
  ! We first check the definition of the attribute (name, type and dims)
  if (present(error_data)) then
    call etsf_io_low_check_att(ncid, ncvarid, attname, NF90_DOUBLE, &
                             & attlen, lstat, error_data = error_data)
    if (.not. lstat) call etsf_io_low_error_update(error_data, me)
  else
    call etsf_io_low_check_att(ncid, ncvarid, attname, NF90_DOUBLE, &
                             & attlen, lstat)
  end if
  if (.not. lstat) return
  ! Now that we are sure that the read attribute has the same type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_att(ncid, ncvarid, attname, att)
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_ATT, &
                    & me, tgtname = attname, tgtid = ncvarid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  lstat = .true.
end subroutine read_att_id_double_1D

subroutine read_att_character_1D(ncid, varname, attname, attlen, att, &
    & lstat, error_data)
  character(len = *), intent(in)                            :: varname
  integer, intent(in)                            :: attlen
  character(len = attlen), intent(out)                    :: att
  integer, intent(in)                            :: ncid
  character(len = *), intent(in)                 :: attname
  logical, intent(out)                           :: lstat
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_att_character_1D"
  integer :: s
  type(etsf_io_low_var_infos) :: var_infos
  lstat = .false.
  write(att, "(A)") repeat(" " , attlen)
  
  if (present(error_data)) then
    call etsf_io_low_read_var_infos(ncid, varname, var_infos, &
                                  & lstat, error_data = error_data)
    if (.not. lstat) call etsf_io_low_error_update(error_data, me)
  else
    call etsf_io_low_read_var_infos(ncid, varname, var_infos, lstat)
  end if
  if (.not. lstat) return
  
  ! We first check the definition of the attribute (name, type and dims)
  if (present(error_data)) then
    call etsf_io_low_check_att(ncid, var_infos%ncid, attname, NF90_CHAR, &
                             & attlen, lstat, error_data = error_data)
    if (.not. lstat) call etsf_io_low_error_update(error_data, me)
  else
    call etsf_io_low_check_att(ncid, var_infos%ncid, attname, NF90_CHAR, &
                             & attlen, lstat)
  end if
  if (.not. lstat) return
  ! Now that we are sure that the read attribute has the same type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_att(ncid, var_infos%ncid, attname, att)
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_ATT, &
                    & me, tgtname = attname, tgtid = var_infos%ncid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  lstat = .true.
end subroutine read_att_character_1D

subroutine read_att_id_character_1D(ncid, ncvarid, attname, attlen, att, &
    & lstat, error_data)
  integer, intent(in)                            :: ncvarid
  integer, intent(in)                            :: attlen
  character(len = attlen), intent(out)                    :: att
  integer, intent(in)                            :: ncid
  character(len = *), intent(in)                 :: attname
  logical, intent(out)                           :: lstat
  type(etsf_io_low_error), intent(out), optional :: error_data

  !Local
  character(len = *), parameter :: me = "read_att_id_character_1D"
  integer :: s

  lstat = .false.
  write(att, "(A)") repeat(" " , attlen)
  
  
  ! We first check the definition of the attribute (name, type and dims)
  if (present(error_data)) then
    call etsf_io_low_check_att(ncid, ncvarid, attname, NF90_CHAR, &
                             & attlen, lstat, error_data = error_data)
    if (.not. lstat) call etsf_io_low_error_update(error_data, me)
  else
    call etsf_io_low_check_att(ncid, ncvarid, attname, NF90_CHAR, &
                             & attlen, lstat)
  end if
  if (.not. lstat) return
  ! Now that we are sure that the read attribute has the same type and dimension
  ! that the argument one, we can do the get action securely.
  s = nf90_get_att(ncid, ncvarid, attname, att)
  if (s /= nf90_noerr) then
    if (present(error_data)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_GET, ERROR_TYPE_ATT, &
                    & me, tgtname = attname, tgtid = ncvarid, errid = s, &
                    & errmess = nf90_strerror(s))
    end if
    return
  end if
  lstat = .true.
end subroutine read_att_id_character_1D

