!{\src2tex{textfont=tt}}
!!****m* etsf_main/etsf_io_main_put
!! NAME
!!  etsf_io_main_put
!!
!! FUNCTION
!!    Write data related to the given group in an opened ETSF file (it must be in
!!    write mode, use etsf_io_low_set_write_mode() to change it).
!!    Only associated pointers of argument @folder will be accessed. If any errors
!!    occurs it returns with @lstat = .false..
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2010 (Damien Caliste)
!!  This file is distributed under the terms of the
!!  GNU Lesser General Public License, see the COPYING file
!!  or http://www.gnu.org/copyleft/lesser.txt .
!!
!! INPUTS
!! * ncid = 
!!     integer returned by an 'open' NetCDF call. The file can be 
!!     either in define or write mode. This status can be changed
!!     by the call.
!! * folder <type(etsf_main)> = 
!!     an allocated structure with pointers on allocated areas in memory.
!!     These areas will be read or written if the pointer is associated, if
!!     not, the variable will be ignored. It is possible to access to specific
!!     dimensions of a variable using the <short_var_name>__kpoint_access or
!!     <short_var_name>__spin_access of this @folder structure. The 
!!     <short_var_name>__number_of_<something> can also been set if only a subpart
!!     in one dimension should be accessed (this is possible when the specifications
!!     have been declared with a max_number_of_<something>.
!! OUTPUT
!! * lstat = 
!!     return .true. if all the actions succeed, if not the status
!!     of the file is undefined.
!! * error_data <type(etsf_io_low_error)> = 
!!     contains the details of the error is @lstat is false.
!!
!! NOTES
!!  This file has been automatically generated by the autogen_subroutines.py
!!  script. Any change you would bring to it will systematically be
!!  overwritten.
!!
!! SOURCE
subroutine etsf_io_main_put(ncid, folder, lstat, error_data)

  !Arguments ------------------------------------
  integer, intent(in) :: ncid
  type(etsf_main), intent(in) :: folder
  logical, intent(out) :: lstat
  type(etsf_io_low_error), intent(out) :: error_data

  !Local variables-------------------------------
  character(len = *), parameter :: my_name = 'etsf_io_main_put'
  integer,allocatable :: varid(:)
  integer,allocatable :: start(:)
  integer,allocatable :: count(:)
  integer :: len
  character(etsf_charlen) :: flag


  ! *************************************************************************

!DEBUG
!write (*,*) 'etsf_io_main_put : enter'
!ENDDEBUG

  
  allocate(varid(6))
  ! Begin by putting the file in write mode.
  call etsf_io_low_set_write_mode(ncid, lstat, error_data = error_data)
  if (.not. lstat) then
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  
  if (etsf_io_low_var_associated(folder%density)) then
    call etsf_io_low_write_var(ncid, "density", &
                            & folder%density, &
                            & lstat, ncvarid = varid(1), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (etsf_io_low_var_associated(folder%exchange_potential)) then
    call etsf_io_low_write_var(ncid, "exchange_potential", &
                            & folder%exchange_potential, &
                            & lstat, ncvarid = varid(2), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (etsf_io_low_var_associated(folder%correlation_potential)) then
    call etsf_io_low_write_var(ncid, "correlation_potential", &
                            & folder%correlation_potential, &
                            & lstat, ncvarid = varid(3), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (etsf_io_low_var_associated(folder%exchange_correlation_potential)) then
    call etsf_io_low_write_var(ncid, "exchange_correlation_potential", &
                            & folder%exchange_correlation_potential, &
                            & lstat, ncvarid = varid(4), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (etsf_io_low_var_associated(folder%coefficients_of_wavefunctions)) then
    allocate(start(6), count(6))
    start(:) = 1
    count(:) = 0
    if (folder%wfs_coeff__spin_access /= etsf_no_sub_access) then
      start(6) = folder%wfs_coeff__spin_access
      count(6) = 1
    end if
    if (folder%wfs_coeff__kpoint_access /= etsf_no_sub_access) then
      start(5) = folder%wfs_coeff__kpoint_access
      count(5) = 1
    end if
    count(4) = folder%wfs_coeff__number_of_states
    if (folder%wfs_coeff__state_access /= etsf_no_sub_access) then
      start(4) = folder%wfs_coeff__state_access
      count(4) = 1
    end if
    count(2) = folder%wfs_coeff__number_of_coefficients
    call etsf_io_low_write_var(ncid, "coefficients_of_wavefunctions", &
                            & folder%coefficients_of_wavefunctions, &
                            & lstat, ncvarid = varid(5), &
                            & error_data = error_data, start = start, count = count)
    deallocate(start, count)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (etsf_io_low_var_associated(folder%real_space_wavefunctions)) then
    allocate(start(8), count(8))
    start(:) = 1
    count(:) = 0
    if (folder%wfs_rsp__spin_access /= etsf_no_sub_access) then
      start(8) = folder%wfs_rsp__spin_access
      count(8) = 1
    end if
    if (folder%wfs_rsp__kpoint_access /= etsf_no_sub_access) then
      start(7) = folder%wfs_rsp__kpoint_access
      count(7) = 1
    end if
    count(6) = folder%wfs_rsp__number_of_states
    if (folder%wfs_rsp__state_access /= etsf_no_sub_access) then
      start(6) = folder%wfs_rsp__state_access
      count(6) = 1
    end if
    call etsf_io_low_write_var(ncid, "real_space_wavefunctions", &
                            & folder%real_space_wavefunctions, &
                            & lstat, ncvarid = varid(6), &
                            & error_data = error_data, start = start, count = count)
    deallocate(start, count)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  deallocate(varid)

!DEBUG
!write (*,*) 'etsf_io_main_put : exit'
!ENDDEBUG

end subroutine etsf_io_main_put
!!***
