!! NOTES
!!  This file has been automatically generated by the config/scripts/autogen_tests.py
!!  script. Any change you would bring to it will systematically be
!!  overwritten. See the template file in config/etsf/template.tests.

program tests_write

  use etsf_io_low_level
  use etsf_io
  
  use tests
  
  implicit none

  call test_data_write()
  call test_write_geometry()
  call test_write_electrons()
  call test_write_kpoints()
  call test_write_basisdata()
  call test_write_gwdata()
  call test_write_dielectric()
  call test_write_main()

  
contains

  subroutine test_data_write()
    type(etsf_dims) :: dims
    type(etsf_groups) :: grp
    integer :: ncid
    type(etsf_io_low_error) :: error
    type(etsf_io_low_var_double) :: var
    character(len = *), parameter :: me = "test_data_write"
    logical :: lstat

    write(*,*)
    write(*,*) "Testing etsf_io_data_write()..."

call etsf_io_data_write("pouet", grp, lstat, error)
call tests_status("dest_file: wrong value (no file)", (.not. lstat), error)

call etsf_io_data_write("Makefile", grp, lstat, error)
call tests_status("dest_file: wrong value (text file)", (.not. lstat), error)


    write(*,*)

  end subroutine test_data_write

  subroutine test_write_geometry()
    type(etsf_dims) :: dims
    type(etsf_groups) :: groups
    type(etsf_groups_flags) :: flags
    type(etsf_geometry), target :: group
    logical :: lstat
    type(etsf_io_low_error) :: error_data
    character(len = *), parameter :: me = "test_write_geometry"
    integer :: ncid
  
    groups%geometry => group
    
    write(*,*)
    write(*,*) "Testing etsf_io_data_write()..."
  
  dims%number_of_grid_points_vector3 = 5
  dims%number_of_symmetry_operations = 4
  dims%max_number_of_coefficients = 6
  dims%max_number_of_projectors = 2
  dims%max_number_of_states = 8
  dims%number_of_atoms = 5
  dims%number_of_atom_species = 3
  dims%number_of_kpoints = 12
  dims%number_of_components = 2
  
    flags%geometry = etsf_geometry_all
    call etsf_io_data_init("test_write_geometry.nc", flags, &
                         & dims, "Test", "", lstat, error_data)
    call tests_status("Create file test_write_geometry.nc", lstat, error_data)
    ! Allocate and init space_group
    call tests_init_variable(group%space_group)
      ! Allocate and init primitive_vectors
    call tests_init_variable(group%primitive_vectors, (/ &
      & dims%number_of_cartesian_directions, &
      & dims%number_of_vectors /))
      ! Allocate and init reduced_symmetry_matrices
    call tests_init_variable(group%reduced_symmetry_matrices, (/ &
      & dims%number_of_reduced_dimensions, &
      & dims%number_of_reduced_dimensions, &
      & dims%number_of_symmetry_operations /))
      ! Allocate and init reduced_symmetry_translations
    call tests_init_variable(group%reduced_symmetry_translations, (/ &
      & dims%number_of_reduced_dimensions, &
      & dims%number_of_symmetry_operations /))
      ! Allocate and init atom_species
    call tests_init_variable(group%atom_species, (/ &
      & dims%number_of_atoms /))
      ! Allocate and init reduced_atom_positions
    call tests_init_variable(group%reduced_atom_positions, (/ &
      & dims%number_of_reduced_dimensions, &
      & dims%number_of_atoms /))
      ! Allocate and init valence_charges
    call tests_init_variable(group%valence_charges, (/ &
      & dims%number_of_atom_species /))
      ! Allocate and init atomic_numbers
    call tests_init_variable(group%atomic_numbers, (/ &
      & dims%number_of_atom_species /))
      ! Allocate and init atom_species_names
    call tests_init_variable(group%atom_species_names, (/ &
      & dims%character_string_length, &
      & dims%number_of_atom_species /))
      ! Allocate and init chemical_symbols
    call tests_init_variable(group%chemical_symbols, (/ &
      & dims%symbol_length, &
      & dims%number_of_atom_species /))
      ! Allocate and init pseudopotential_types
    call tests_init_variable(group%pseudopotential_types, (/ &
      & dims%character_string_length, &
      & dims%number_of_atom_species /))
    
    call etsf_io_data_write("test_write_geometry.nc", &
                          & groups, lstat, error_data)
    call tests_status("write data", lstat, error_data)
    ! check informations.
    call etsf_io_low_open_read(ncid, "test_write_geometry.nc", lstat, error_data = error_data)
    call tests_status(" | opening", lstat, error_data)
  call tests_check_variable(ncid, "space_group", "integer", lstat, error_data)
  call tests_check_variable(ncid, "primitive_vectors", "real double_precision", (/ &
    & dims%number_of_cartesian_directions, &
    & dims%number_of_vectors /), lstat, error_data)
  call tests_check_variable(ncid, "reduced_symmetry_matrices", "integer", (/ &
    & dims%number_of_reduced_dimensions, &
    & dims%number_of_reduced_dimensions, &
    & dims%number_of_symmetry_operations /), lstat, error_data)
  call tests_check_variable(ncid, "reduced_symmetry_translations", "real double_precision", (/ &
    & dims%number_of_reduced_dimensions, &
    & dims%number_of_symmetry_operations /), lstat, error_data)
  call tests_check_variable(ncid, "atom_species", "integer", (/ &
    & dims%number_of_atoms /), lstat, error_data)
  call tests_check_variable(ncid, "reduced_atom_positions", "real double_precision", (/ &
    & dims%number_of_reduced_dimensions, &
    & dims%number_of_atoms /), lstat, error_data)
  call tests_check_variable(ncid, "valence_charges", "real double_precision", (/ &
    & dims%number_of_atom_species /), lstat, error_data)
  call tests_check_variable(ncid, "atomic_numbers", "real double_precision", (/ &
    & dims%number_of_atom_species /), lstat, error_data)
  call tests_check_variable(ncid, "atom_species_names", "string", (/ &
    & dims%character_string_length, &
    & dims%number_of_atom_species /), lstat, error_data)
  call tests_check_variable(ncid, "chemical_symbols", "string", (/ &
    & dims%symbol_length, &
    & dims%number_of_atom_species /), lstat, error_data)
  call tests_check_variable(ncid, "pseudopotential_types", "string", (/ &
    & dims%character_string_length, &
    & dims%number_of_atom_species /), lstat, error_data)
  
    ! close file
    call etsf_io_low_close(ncid, lstat, error_data = error_data)
    call tests_status(" | closing", lstat, error_data)
    
    deallocate(group%space_group)
    deallocate(group%primitive_vectors)
    deallocate(group%reduced_symmetry_matrices)
    deallocate(group%reduced_symmetry_translations)
    deallocate(group%atom_species)
    deallocate(group%reduced_atom_positions)
    deallocate(group%valence_charges)
    deallocate(group%atomic_numbers)
    deallocate(group%atom_species_names)
    deallocate(group%chemical_symbols)
    deallocate(group%pseudopotential_types)
  
    write(*,*)
  end subroutine test_write_geometry
  
    subroutine test_write_electrons()
    type(etsf_dims) :: dims
    type(etsf_groups) :: groups
    type(etsf_groups_flags) :: flags
    type(etsf_electrons), target :: group
    logical :: lstat
    type(etsf_io_low_error) :: error_data
    character(len = *), parameter :: me = "test_write_electrons"
    integer :: ncid
  
    groups%electrons => group
    
    write(*,*)
    write(*,*) "Testing etsf_io_data_write()..."
  
  dims%number_of_grid_points_vector3 = 5
  dims%number_of_symmetry_operations = 4
  dims%max_number_of_coefficients = 6
  dims%max_number_of_projectors = 2
  dims%max_number_of_states = 8
  dims%number_of_atoms = 5
  dims%number_of_atom_species = 3
  dims%number_of_kpoints = 12
  dims%number_of_components = 2
  
    flags%electrons = etsf_electrons_all
    call etsf_io_data_init("test_write_electrons.nc", flags, &
                         & dims, "Test", "", lstat, error_data)
    call tests_status("Create file test_write_electrons.nc", lstat, error_data)
    ! Allocate and init number_of_electrons
    call tests_init_variable(group%number_of_electrons)
      ! Allocate and init exchange_functional
    call tests_init_variable(group%exchange_functional, (/ &
      & dims%character_string_length /))
      ! Allocate and init correlation_functional
    call tests_init_variable(group%correlation_functional, (/ &
      & dims%character_string_length /))
      ! Allocate and init fermi_energy
    call tests_init_variable(group%fermi_energy)
      ! Allocate and init smearing_scheme
    call tests_init_variable(group%smearing_scheme, (/ &
      & dims%character_string_length /))
      ! Allocate and init smearing_width
    call tests_init_variable(group%smearing_width)
      ! Allocate and init number_of_states
    call tests_init_variable(group%number_of_states%data1D, (/ &
      & dims%number_of_spins * &
      & dims%number_of_kpoints /))
      ! Allocate and init eigenvalues
    call tests_init_variable(group%eigenvalues%data1D, (/ &
      & dims%number_of_spins * &
      & dims%number_of_kpoints * &
      & dims%max_number_of_states /))
      ! Allocate and init occupations
    call tests_init_variable(group%occupations%data1D, (/ &
      & dims%number_of_spins * &
      & dims%number_of_kpoints * &
      & dims%max_number_of_states /))
    
    call etsf_io_data_write("test_write_electrons.nc", &
                          & groups, lstat, error_data)
    call tests_status("write data", lstat, error_data)
    ! check informations.
    call etsf_io_low_open_read(ncid, "test_write_electrons.nc", lstat, error_data = error_data)
    call tests_status(" | opening", lstat, error_data)
  call tests_check_variable(ncid, "number_of_electrons", "integer", lstat, error_data)
  call tests_check_variable(ncid, "exchange_functional", "string", (/ &
    & dims%character_string_length /), lstat, error_data)
  call tests_check_variable(ncid, "correlation_functional", "string", (/ &
    & dims%character_string_length /), lstat, error_data)
  call tests_check_variable(ncid, "fermi_energy", "real double_precision", lstat, error_data)
  call tests_check_variable(ncid, "smearing_scheme", "string", (/ &
    & dims%character_string_length /), lstat, error_data)
  call tests_check_variable(ncid, "smearing_width", "real double_precision", lstat, error_data)
  call tests_check_variable(ncid, "number_of_states", "integer", (/ &
    & dims%number_of_kpoints, &
    & dims%number_of_spins /), lstat, error_data)
  call tests_check_variable(ncid, "eigenvalues", "real double_precision", (/ &
    & dims%max_number_of_states, &
    & dims%number_of_kpoints, &
    & dims%number_of_spins /), lstat, error_data)
  call tests_check_variable(ncid, "occupations", "real double_precision", (/ &
    & dims%max_number_of_states, &
    & dims%number_of_kpoints, &
    & dims%number_of_spins /), lstat, error_data)
  
    ! close file
    call etsf_io_low_close(ncid, lstat, error_data = error_data)
    call tests_status(" | closing", lstat, error_data)
    
    deallocate(group%number_of_electrons)
    deallocate(group%exchange_functional)
    deallocate(group%correlation_functional)
    deallocate(group%fermi_energy)
    deallocate(group%smearing_scheme)
    deallocate(group%smearing_width)
    deallocate(group%number_of_states%data1D)
    deallocate(group%eigenvalues%data1D)
    deallocate(group%occupations%data1D)
  
    write(*,*)
  end subroutine test_write_electrons
  
    subroutine test_write_kpoints()
    type(etsf_dims) :: dims
    type(etsf_groups) :: groups
    type(etsf_groups_flags) :: flags
    type(etsf_kpoints), target :: group
    logical :: lstat
    type(etsf_io_low_error) :: error_data
    character(len = *), parameter :: me = "test_write_kpoints"
    integer :: ncid
  
    groups%kpoints => group
    
    write(*,*)
    write(*,*) "Testing etsf_io_data_write()..."
  
  dims%number_of_grid_points_vector3 = 5
  dims%number_of_symmetry_operations = 4
  dims%max_number_of_coefficients = 6
  dims%max_number_of_projectors = 2
  dims%max_number_of_states = 8
  dims%number_of_atoms = 5
  dims%number_of_atom_species = 3
  dims%number_of_kpoints = 12
  dims%number_of_components = 2
  
    flags%kpoints = etsf_kpoints_all
    call etsf_io_data_init("test_write_kpoints.nc", flags, &
                         & dims, "Test", "", lstat, error_data)
    call tests_status("Create file test_write_kpoints.nc", lstat, error_data)
    ! Allocate and init kpoint_grid_shift
    call tests_init_variable(group%kpoint_grid_shift, (/ &
      & dims%number_of_reduced_dimensions /))
      ! Allocate and init kpoint_grid_vectors
    call tests_init_variable(group%kpoint_grid_vectors, (/ &
      & dims%number_of_reduced_dimensions, &
      & dims%number_of_vectors /))
      ! Allocate and init monkhorst_pack_folding
    call tests_init_variable(group%monkhorst_pack_folding, (/ &
      & dims%number_of_vectors /))
      ! Allocate and init reduced_coordinates_of_kpoints
    call tests_init_variable(group%reduced_coordinates_of_kpoints, (/ &
      & dims%number_of_reduced_dimensions, &
      & dims%number_of_kpoints /))
      ! Allocate and init kpoint_weights
    call tests_init_variable(group%kpoint_weights, (/ &
      & dims%number_of_kpoints /))
    
    call etsf_io_data_write("test_write_kpoints.nc", &
                          & groups, lstat, error_data)
    call tests_status("write data", lstat, error_data)
    ! check informations.
    call etsf_io_low_open_read(ncid, "test_write_kpoints.nc", lstat, error_data = error_data)
    call tests_status(" | opening", lstat, error_data)
  call tests_check_variable(ncid, "kpoint_grid_shift", "real double_precision", (/ &
    & dims%number_of_reduced_dimensions /), lstat, error_data)
  call tests_check_variable(ncid, "kpoint_grid_vectors", "real double_precision", (/ &
    & dims%number_of_reduced_dimensions, &
    & dims%number_of_vectors /), lstat, error_data)
  call tests_check_variable(ncid, "monkhorst_pack_folding", "integer", (/ &
    & dims%number_of_vectors /), lstat, error_data)
  call tests_check_variable(ncid, "reduced_coordinates_of_kpoints", "real double_precision", (/ &
    & dims%number_of_reduced_dimensions, &
    & dims%number_of_kpoints /), lstat, error_data)
  call tests_check_variable(ncid, "kpoint_weights", "real double_precision", (/ &
    & dims%number_of_kpoints /), lstat, error_data)
  
    ! close file
    call etsf_io_low_close(ncid, lstat, error_data = error_data)
    call tests_status(" | closing", lstat, error_data)
    
    deallocate(group%kpoint_grid_shift)
    deallocate(group%kpoint_grid_vectors)
    deallocate(group%monkhorst_pack_folding)
    deallocate(group%reduced_coordinates_of_kpoints)
    deallocate(group%kpoint_weights)
  
    write(*,*)
  end subroutine test_write_kpoints
  
    subroutine test_write_basisdata()
    type(etsf_dims) :: dims
    type(etsf_groups) :: groups
    type(etsf_groups_flags) :: flags
    type(etsf_basisdata), target :: group
    logical :: lstat
    type(etsf_io_low_error) :: error_data
    character(len = *), parameter :: me = "test_write_basisdata"
    integer :: ncid
  
    groups%basisdata => group
    
    write(*,*)
    write(*,*) "Testing etsf_io_data_write()..."
  
  dims%number_of_grid_points_vector3 = 5
  dims%number_of_symmetry_operations = 4
  dims%max_number_of_coefficients = 6
  dims%max_number_of_projectors = 2
  dims%max_number_of_states = 8
  dims%number_of_atoms = 5
  dims%number_of_atom_species = 3
  dims%number_of_kpoints = 12
  dims%number_of_components = 2
  
    flags%basisdata = etsf_basisdata_all
    call etsf_io_data_init("test_write_basisdata.nc", flags, &
                         & dims, "Test", "", lstat, error_data)
    call tests_status("Create file test_write_basisdata.nc", lstat, error_data)
    ! Allocate and init basis_set
    call tests_init_variable(group%basis_set, (/ &
      & dims%character_string_length /))
      ! Allocate and init kinetic_energy_cutoff
    call tests_init_variable(group%kinetic_energy_cutoff)
      ! Allocate and init number_of_coefficients
    call tests_init_variable(group%number_of_coefficients, (/ &
      & dims%number_of_kpoints /))
      ! Allocate and init reduced_coordinates_of_plane_waves
    call tests_init_variable(group%reduced_coordinates_of_plane_waves%data1D, (/ &
      & dims%number_of_kpoints * &
      & dims%max_number_of_coefficients * &
      & dims%number_of_reduced_dimensions /))
      ! Allocate and init coordinates_of_basis_grid_points
    call tests_init_variable(group%coordinates_of_basis_grid_points%data1D, (/ &
      & dims%number_of_localization_regions * &
      & dims%max_number_of_basis_grid_points * &
      & dims%number_of_reduced_dimensions /))
      ! Allocate and init number_of_coefficients_per_grid_point
    call tests_init_variable(group%number_of_coefficients_per_grid_point%data1D, (/ &
      & dims%number_of_localization_regions * &
      & dims%max_number_of_basis_grid_points /))
    
    call etsf_io_data_write("test_write_basisdata.nc", &
                          & groups, lstat, error_data)
    call tests_status("write data", lstat, error_data)
    ! check informations.
    call etsf_io_low_open_read(ncid, "test_write_basisdata.nc", lstat, error_data = error_data)
    call tests_status(" | opening", lstat, error_data)
  call tests_check_variable(ncid, "basis_set", "string", (/ &
    & dims%character_string_length /), lstat, error_data)
  call tests_check_variable(ncid, "kinetic_energy_cutoff", "real double_precision", lstat, error_data)
  call tests_check_variable(ncid, "number_of_coefficients", "integer", (/ &
    & dims%number_of_kpoints /), lstat, error_data)
  call tests_check_variable(ncid, "reduced_coordinates_of_plane_waves", "integer", (/ &
    & dims%number_of_reduced_dimensions, &
    & dims%max_number_of_coefficients, &
    & dims%number_of_kpoints /), lstat, error_data)
  call tests_check_variable(ncid, "coordinates_of_basis_grid_points", "integer", (/ &
    & dims%number_of_reduced_dimensions, &
    & dims%max_number_of_basis_grid_points, &
    & dims%number_of_localization_regions /), lstat, error_data)
  call tests_check_variable(ncid, "number_of_coefficients_per_grid_point", "integer", (/ &
    & dims%max_number_of_basis_grid_points, &
    & dims%number_of_localization_regions /), lstat, error_data)
  
    ! close file
    call etsf_io_low_close(ncid, lstat, error_data = error_data)
    call tests_status(" | closing", lstat, error_data)
    
    deallocate(group%basis_set)
    deallocate(group%kinetic_energy_cutoff)
    deallocate(group%number_of_coefficients)
    deallocate(group%reduced_coordinates_of_plane_waves%data1D)
    deallocate(group%coordinates_of_basis_grid_points%data1D)
    deallocate(group%number_of_coefficients_per_grid_point%data1D)
  
    write(*,*)
  end subroutine test_write_basisdata
  
    subroutine test_write_gwdata()
    type(etsf_dims) :: dims
    type(etsf_groups) :: groups
    type(etsf_groups_flags) :: flags
    type(etsf_gwdata), target :: group
    logical :: lstat
    type(etsf_io_low_error) :: error_data
    character(len = *), parameter :: me = "test_write_gwdata"
    integer :: ncid
  
    groups%gwdata => group
    
    write(*,*)
    write(*,*) "Testing etsf_io_data_write()..."
  
  dims%number_of_grid_points_vector3 = 5
  dims%number_of_symmetry_operations = 4
  dims%max_number_of_coefficients = 6
  dims%max_number_of_projectors = 2
  dims%max_number_of_states = 8
  dims%number_of_atoms = 5
  dims%number_of_atom_species = 3
  dims%number_of_kpoints = 12
  dims%number_of_components = 2
  
    flags%gwdata = etsf_gwdata_all
    call etsf_io_data_init("test_write_gwdata.nc", flags, &
                         & dims, "Test", "", lstat, error_data)
    call tests_status("Create file test_write_gwdata.nc", lstat, error_data)
    ! Allocate and init gw_corrections
    call tests_init_variable(group%gw_corrections%data1D, (/ &
      & dims%number_of_spins * &
      & dims%number_of_kpoints * &
      & dims%max_number_of_states * &
      & dims%real_or_complex_gw_corrections /))
      ! Allocate and init kb_formfactor_sign
    call tests_init_variable(group%kb_formfactor_sign%data1D, (/ &
      & dims%number_of_atom_species * &
      & dims%max_number_of_angular_momenta * &
      & dims%max_number_of_projectors /))
      ! Allocate and init kb_formfactors
    call tests_init_variable(group%kb_formfactors%data1D, (/ &
      & dims%number_of_atom_species * &
      & dims%max_number_of_angular_momenta * &
      & dims%max_number_of_projectors * &
      & dims%number_of_kpoints * &
      & dims%max_number_of_coefficients /))
      ! Allocate and init kb_formfactor_derivative
    call tests_init_variable(group%kb_formfactor_derivative%data1D, (/ &
      & dims%number_of_atom_species * &
      & dims%max_number_of_angular_momenta * &
      & dims%max_number_of_projectors * &
      & dims%number_of_kpoints * &
      & dims%max_number_of_coefficients /))
    
    call etsf_io_data_write("test_write_gwdata.nc", &
                          & groups, lstat, error_data)
    call tests_status("write data", lstat, error_data)
    ! check informations.
    call etsf_io_low_open_read(ncid, "test_write_gwdata.nc", lstat, error_data = error_data)
    call tests_status(" | opening", lstat, error_data)
  call tests_check_variable(ncid, "gw_corrections", "real double_precision", (/ &
    & dims%real_or_complex_gw_corrections, &
    & dims%max_number_of_states, &
    & dims%number_of_kpoints, &
    & dims%number_of_spins /), lstat, error_data)
  call tests_check_variable(ncid, "kb_formfactor_sign", "integer", (/ &
    & dims%max_number_of_projectors, &
    & dims%max_number_of_angular_momenta, &
    & dims%number_of_atom_species /), lstat, error_data)
  call tests_check_variable(ncid, "kb_formfactors", "real double_precision", (/ &
    & dims%max_number_of_coefficients, &
    & dims%number_of_kpoints, &
    & dims%max_number_of_projectors, &
    & dims%max_number_of_angular_momenta, &
    & dims%number_of_atom_species /), lstat, error_data)
  call tests_check_variable(ncid, "kb_formfactor_derivative", "real double_precision", (/ &
    & dims%max_number_of_coefficients, &
    & dims%number_of_kpoints, &
    & dims%max_number_of_projectors, &
    & dims%max_number_of_angular_momenta, &
    & dims%number_of_atom_species /), lstat, error_data)
  
    ! close file
    call etsf_io_low_close(ncid, lstat, error_data = error_data)
    call tests_status(" | closing", lstat, error_data)
    
    deallocate(group%gw_corrections%data1D)
    deallocate(group%kb_formfactor_sign%data1D)
    deallocate(group%kb_formfactors%data1D)
    deallocate(group%kb_formfactor_derivative%data1D)
  
    write(*,*)
  end subroutine test_write_gwdata
  
    subroutine test_write_dielectric()
    type(etsf_dims) :: dims
    type(etsf_groups) :: groups
    type(etsf_groups_flags) :: flags
    type(etsf_dielectric), target :: group
    logical :: lstat
    type(etsf_io_low_error) :: error_data
    character(len = *), parameter :: me = "test_write_dielectric"
    integer :: ncid
  
    groups%dielectric => group
    
    write(*,*)
    write(*,*) "Testing etsf_io_data_write()..."
  
  dims%number_of_grid_points_vector3 = 5
  dims%number_of_symmetry_operations = 4
  dims%max_number_of_coefficients = 6
  dims%max_number_of_projectors = 2
  dims%max_number_of_states = 8
  dims%number_of_atoms = 5
  dims%number_of_atom_species = 3
  dims%number_of_kpoints = 12
  dims%number_of_components = 2
  
    flags%dielectric = etsf_dielectric_all
    call etsf_io_data_init("test_write_dielectric.nc", flags, &
                         & dims, "Test", "", lstat, error_data)
    call tests_status("Create file test_write_dielectric.nc", lstat, error_data)
    ! Allocate and init frequencies_dielectric_function
    call tests_init_variable(group%frequencies_dielectric_function, (/ &
      & dims%complex, &
      & dims%number_of_frequencies_dielectric_function /))
      ! Allocate and init qpoints_dielectric_function
    call tests_init_variable(group%qpoints_dielectric_function, (/ &
      & dims%number_of_reduced_dimensions, &
      & dims%number_of_qpoints_dielectric_function /))
      ! Allocate and init qpoints_gamma_limit
    call tests_init_variable(group%qpoints_gamma_limit, (/ &
      & dims%number_of_reduced_dimensions, &
      & dims%number_of_qpoints_gamma_limit /))
      ! Allocate and init dielectric_function
    call tests_init_variable(group%dielectric_function%data1D, (/ &
      & dims%number_of_frequencies_dielectric_function * &
      & dims%number_of_qpoints_dielectric_function * &
      & dims%number_of_spins * &
      & dims%number_of_spins * &
      & dims%number_of_coefficients_dielectric_function * &
      & dims%number_of_coefficients_dielectric_function * &
      & dims%complex /))
      ! Allocate and init dielectric_function_head
    call tests_init_variable(group%dielectric_function_head%data1D, (/ &
      & dims%number_of_frequencies_dielectric_function * &
      & dims%number_of_qpoints_dielectric_function * &
      & dims%number_of_spins * &
      & dims%number_of_spins * &
      & dims%complex /))
      ! Allocate and init dielectric_function_lower_wing
    call tests_init_variable(group%dielectric_function_lower_wing%data1D, (/ &
      & dims%number_of_frequencies_dielectric_function * &
      & dims%number_of_qpoints_gamma_limit * &
      & dims%number_of_spins * &
      & dims%number_of_spins * &
      & dims%number_of_coefficients_dielectric_function * &
      & dims%complex /))
      ! Allocate and init dielectric_function_upper_wing
    call tests_init_variable(group%dielectric_function_upper_wing%data1D, (/ &
      & dims%number_of_frequencies_dielectric_function * &
      & dims%number_of_qpoints_gamma_limit * &
      & dims%number_of_spins * &
      & dims%number_of_spins * &
      & dims%number_of_coefficients_dielectric_function * &
      & dims%complex /))
      ! Allocate and init inverse_dielectric_function
    call tests_init_variable(group%inverse_dielectric_function%data1D, (/ &
      & dims%number_of_frequencies_dielectric_function * &
      & dims%number_of_qpoints_dielectric_function * &
      & dims%number_of_spins * &
      & dims%number_of_spins * &
      & dims%number_of_coefficients_dielectric_function * &
      & dims%number_of_coefficients_dielectric_function * &
      & dims%complex /))
      ! Allocate and init inverse_dielectric_function_head
    call tests_init_variable(group%inverse_dielectric_function_head%data1D, (/ &
      & dims%number_of_frequencies_dielectric_function * &
      & dims%number_of_qpoints_dielectric_function * &
      & dims%number_of_spins * &
      & dims%number_of_spins * &
      & dims%complex /))
      ! Allocate and init inverse_dielectric_function_lower_wing
    call tests_init_variable(group%inverse_dielectric_function_lower_wing%data1D, (/ &
      & dims%number_of_frequencies_dielectric_function * &
      & dims%number_of_qpoints_gamma_limit * &
      & dims%number_of_spins * &
      & dims%number_of_spins * &
      & dims%number_of_coefficients_dielectric_function * &
      & dims%complex /))
      ! Allocate and init inverse_dielectric_function_upper_wing
    call tests_init_variable(group%inverse_dielectric_function_upper_wing%data1D, (/ &
      & dims%number_of_frequencies_dielectric_function * &
      & dims%number_of_qpoints_gamma_limit * &
      & dims%number_of_spins * &
      & dims%number_of_spins * &
      & dims%number_of_coefficients_dielectric_function * &
      & dims%complex /))
      ! Allocate and init polarizability
    call tests_init_variable(group%polarizability%data1D, (/ &
      & dims%number_of_frequencies_dielectric_function * &
      & dims%number_of_qpoints_dielectric_function * &
      & dims%number_of_spins * &
      & dims%number_of_spins * &
      & dims%number_of_coefficients_dielectric_function * &
      & dims%number_of_coefficients_dielectric_function * &
      & dims%complex /))
      ! Allocate and init polarizability_head
    call tests_init_variable(group%polarizability_head%data1D, (/ &
      & dims%number_of_frequencies_dielectric_function * &
      & dims%number_of_qpoints_dielectric_function * &
      & dims%number_of_spins * &
      & dims%number_of_spins * &
      & dims%complex /))
      ! Allocate and init polarizability_lower_wing
    call tests_init_variable(group%polarizability_lower_wing%data1D, (/ &
      & dims%number_of_frequencies_dielectric_function * &
      & dims%number_of_qpoints_gamma_limit * &
      & dims%number_of_spins * &
      & dims%number_of_spins * &
      & dims%number_of_coefficients_dielectric_function * &
      & dims%complex /))
      ! Allocate and init polarizability_upper_wing
    call tests_init_variable(group%polarizability_upper_wing%data1D, (/ &
      & dims%number_of_frequencies_dielectric_function * &
      & dims%number_of_qpoints_gamma_limit * &
      & dims%number_of_spins * &
      & dims%number_of_spins * &
      & dims%number_of_coefficients_dielectric_function * &
      & dims%complex /))
      ! Allocate and init inverse_polarizability
    call tests_init_variable(group%inverse_polarizability%data1D, (/ &
      & dims%number_of_frequencies_dielectric_function * &
      & dims%number_of_qpoints_dielectric_function * &
      & dims%number_of_spins * &
      & dims%number_of_spins * &
      & dims%number_of_coefficients_dielectric_function * &
      & dims%number_of_coefficients_dielectric_function * &
      & dims%complex /))
      ! Allocate and init inverse_polarizability_head
    call tests_init_variable(group%inverse_polarizability_head%data1D, (/ &
      & dims%number_of_frequencies_dielectric_function * &
      & dims%number_of_qpoints_dielectric_function * &
      & dims%number_of_spins * &
      & dims%number_of_spins * &
      & dims%complex /))
      ! Allocate and init inverse_polarizability_lower_wing
    call tests_init_variable(group%inverse_polarizability_lower_wing%data1D, (/ &
      & dims%number_of_frequencies_dielectric_function * &
      & dims%number_of_qpoints_gamma_limit * &
      & dims%number_of_spins * &
      & dims%number_of_spins * &
      & dims%number_of_coefficients_dielectric_function * &
      & dims%complex /))
      ! Allocate and init inverse_polarizability_upper_wing
    call tests_init_variable(group%inverse_polarizability_upper_wing%data1D, (/ &
      & dims%number_of_frequencies_dielectric_function * &
      & dims%number_of_qpoints_gamma_limit * &
      & dims%number_of_spins * &
      & dims%number_of_spins * &
      & dims%number_of_coefficients_dielectric_function * &
      & dims%complex /))
    
    call etsf_io_data_write("test_write_dielectric.nc", &
                          & groups, lstat, error_data)
    call tests_status("write data", lstat, error_data)
    ! check informations.
    call etsf_io_low_open_read(ncid, "test_write_dielectric.nc", lstat, error_data = error_data)
    call tests_status(" | opening", lstat, error_data)
  call tests_check_variable(ncid, "frequencies_dielectric_function", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "qpoints_dielectric_function", "real double_precision", (/ &
    & dims%number_of_reduced_dimensions, &
    & dims%number_of_qpoints_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "qpoints_gamma_limit", "real double_precision", (/ &
    & dims%number_of_reduced_dimensions, &
    & dims%number_of_qpoints_gamma_limit /), lstat, error_data)
  call tests_check_variable(ncid, "dielectric_function", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_dielectric_function, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "dielectric_function_head", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_dielectric_function, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "dielectric_function_lower_wing", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_gamma_limit, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "dielectric_function_upper_wing", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_gamma_limit, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "inverse_dielectric_function", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_dielectric_function, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "inverse_dielectric_function_head", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_dielectric_function, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "inverse_dielectric_function_lower_wing", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_gamma_limit, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "inverse_dielectric_function_upper_wing", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_gamma_limit, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "polarizability", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_dielectric_function, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "polarizability_head", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_dielectric_function, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "polarizability_lower_wing", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_gamma_limit, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "polarizability_upper_wing", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_gamma_limit, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "inverse_polarizability", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_dielectric_function, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "inverse_polarizability_head", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_dielectric_function, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "inverse_polarizability_lower_wing", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_gamma_limit, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  call tests_check_variable(ncid, "inverse_polarizability_upper_wing", "real double_precision", (/ &
    & dims%complex, &
    & dims%number_of_coefficients_dielectric_function, &
    & dims%number_of_spins, &
    & dims%number_of_spins, &
    & dims%number_of_qpoints_gamma_limit, &
    & dims%number_of_frequencies_dielectric_function /), lstat, error_data)
  
    ! close file
    call etsf_io_low_close(ncid, lstat, error_data = error_data)
    call tests_status(" | closing", lstat, error_data)
    
    deallocate(group%frequencies_dielectric_function)
    deallocate(group%qpoints_dielectric_function)
    deallocate(group%qpoints_gamma_limit)
    deallocate(group%dielectric_function%data1D)
    deallocate(group%dielectric_function_head%data1D)
    deallocate(group%dielectric_function_lower_wing%data1D)
    deallocate(group%dielectric_function_upper_wing%data1D)
    deallocate(group%inverse_dielectric_function%data1D)
    deallocate(group%inverse_dielectric_function_head%data1D)
    deallocate(group%inverse_dielectric_function_lower_wing%data1D)
    deallocate(group%inverse_dielectric_function_upper_wing%data1D)
    deallocate(group%polarizability%data1D)
    deallocate(group%polarizability_head%data1D)
    deallocate(group%polarizability_lower_wing%data1D)
    deallocate(group%polarizability_upper_wing%data1D)
    deallocate(group%inverse_polarizability%data1D)
    deallocate(group%inverse_polarizability_head%data1D)
    deallocate(group%inverse_polarizability_lower_wing%data1D)
    deallocate(group%inverse_polarizability_upper_wing%data1D)
  
    write(*,*)
  end subroutine test_write_dielectric
  
    subroutine test_write_main()
    type(etsf_dims) :: dims
    type(etsf_groups) :: groups
    type(etsf_groups_flags) :: flags
    type(etsf_main), target :: group
    logical :: lstat
    type(etsf_io_low_error) :: error_data
    character(len = *), parameter :: me = "test_write_main"
    integer :: ncid
  
    groups%main => group
    
    write(*,*)
    write(*,*) "Testing etsf_io_data_write()..."
  
  dims%number_of_grid_points_vector3 = 5
  dims%number_of_symmetry_operations = 4
  dims%max_number_of_coefficients = 6
  dims%max_number_of_projectors = 2
  dims%max_number_of_states = 8
  dims%number_of_atoms = 5
  dims%number_of_atom_species = 3
  dims%number_of_kpoints = 12
  dims%number_of_components = 2
  
    flags%main = etsf_main_all
    call etsf_io_data_init("test_write_main.nc", flags, &
                         & dims, "Test", "", lstat, error_data)
    call tests_status("Create file test_write_main.nc", lstat, error_data)
    ! Allocate and init density
    call tests_init_variable(group%density%data1D, (/ &
      & dims%number_of_components * &
      & dims%number_of_grid_points_vector3 * &
      & dims%number_of_grid_points_vector2 * &
      & dims%number_of_grid_points_vector1 * &
      & dims%real_or_complex_density /))
      ! Allocate and init exchange_potential
    call tests_init_variable(group%exchange_potential%data1D, (/ &
      & dims%number_of_components * &
      & dims%number_of_grid_points_vector3 * &
      & dims%number_of_grid_points_vector2 * &
      & dims%number_of_grid_points_vector1 * &
      & dims%real_or_complex_potential /))
      ! Allocate and init correlation_potential
    call tests_init_variable(group%correlation_potential%data1D, (/ &
      & dims%number_of_components * &
      & dims%number_of_grid_points_vector3 * &
      & dims%number_of_grid_points_vector2 * &
      & dims%number_of_grid_points_vector1 * &
      & dims%real_or_complex_potential /))
      ! Allocate and init exchange_correlation_potential
    call tests_init_variable(group%exchange_correlation_potential%data1D, (/ &
      & dims%number_of_components * &
      & dims%number_of_grid_points_vector3 * &
      & dims%number_of_grid_points_vector2 * &
      & dims%number_of_grid_points_vector1 * &
      & dims%real_or_complex_potential /))
      ! Allocate and init coefficients_of_wavefunctions
    call tests_init_variable(group%coefficients_of_wavefunctions%data1D, (/ &
      & dims%number_of_spins * &
      & dims%number_of_kpoints * &
      & dims%max_number_of_states * &
      & dims%number_of_spinor_components * &
      & dims%max_number_of_coefficients * &
      & dims%real_or_complex_coefficients /))
      ! Allocate and init real_space_wavefunctions
    call tests_init_variable(group%real_space_wavefunctions%data1D, (/ &
      & dims%number_of_spins * &
      & dims%number_of_kpoints * &
      & dims%max_number_of_states * &
      & dims%number_of_spinor_components * &
      & dims%number_of_grid_points_vector3 * &
      & dims%number_of_grid_points_vector2 * &
      & dims%number_of_grid_points_vector1 * &
      & dims%real_or_complex_wavefunctions /))
    
    call etsf_io_data_write("test_write_main.nc", &
                          & groups, lstat, error_data)
    call tests_status("write data", lstat, error_data)
    ! check informations.
    call etsf_io_low_open_read(ncid, "test_write_main.nc", lstat, error_data = error_data)
    call tests_status(" | opening", lstat, error_data)
  call tests_check_variable(ncid, "density", "real double_precision", (/ &
    & dims%real_or_complex_density, &
    & dims%number_of_grid_points_vector1, &
    & dims%number_of_grid_points_vector2, &
    & dims%number_of_grid_points_vector3, &
    & dims%number_of_components /), lstat, error_data)
  call tests_check_variable(ncid, "exchange_potential", "real double_precision", (/ &
    & dims%real_or_complex_potential, &
    & dims%number_of_grid_points_vector1, &
    & dims%number_of_grid_points_vector2, &
    & dims%number_of_grid_points_vector3, &
    & dims%number_of_components /), lstat, error_data)
  call tests_check_variable(ncid, "correlation_potential", "real double_precision", (/ &
    & dims%real_or_complex_potential, &
    & dims%number_of_grid_points_vector1, &
    & dims%number_of_grid_points_vector2, &
    & dims%number_of_grid_points_vector3, &
    & dims%number_of_components /), lstat, error_data)
  call tests_check_variable(ncid, "exchange_correlation_potential", "real double_precision", (/ &
    & dims%real_or_complex_potential, &
    & dims%number_of_grid_points_vector1, &
    & dims%number_of_grid_points_vector2, &
    & dims%number_of_grid_points_vector3, &
    & dims%number_of_components /), lstat, error_data)
  call tests_check_variable(ncid, "coefficients_of_wavefunctions", "real double_precision", (/ &
    & dims%real_or_complex_coefficients, &
    & dims%max_number_of_coefficients, &
    & dims%number_of_spinor_components, &
    & dims%max_number_of_states, &
    & dims%number_of_kpoints, &
    & dims%number_of_spins /), lstat, error_data)
  call tests_check_variable(ncid, "real_space_wavefunctions", "real double_precision", (/ &
    & dims%real_or_complex_wavefunctions, &
    & dims%number_of_grid_points_vector1, &
    & dims%number_of_grid_points_vector2, &
    & dims%number_of_grid_points_vector3, &
    & dims%number_of_spinor_components, &
    & dims%max_number_of_states, &
    & dims%number_of_kpoints, &
    & dims%number_of_spins /), lstat, error_data)
  
    ! close file
    call etsf_io_low_close(ncid, lstat, error_data = error_data)
    call tests_status(" | closing", lstat, error_data)
    
    deallocate(group%density%data1D)
    deallocate(group%exchange_potential%data1D)
    deallocate(group%correlation_potential%data1D)
    deallocate(group%exchange_correlation_potential%data1D)
    deallocate(group%coefficients_of_wavefunctions%data1D)
    deallocate(group%real_space_wavefunctions%data1D)
  
    write(*,*)
  end subroutine test_write_main
  
  

end program tests_write
