/*
 * Decompiled with CFR 0.152.
 */
package info.dolezel.fatrat.applet.util;

import java.text.DecimalFormat;

public class Util {
    public static String formatSize(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return Util.singleDecimalDigit((double)bytes / 1024.0) + " KB";
        }
        if (bytes < 0x40000000L) {
            return Util.singleDecimalDigit((double)bytes / 1024.0 / 1024.0) + " MB";
        }
        return Util.singleDecimalDigit((double)bytes / 1024.0 / 1024.0 / 1024.0) + " GB";
    }

    public static String formatTime(int seconds) {
        StringBuilder result = new StringBuilder();
        int days = seconds / 86400;
        int hrs = (seconds %= 86400) / 3600;
        int mins = (seconds %= 3600) / 60;
        int secs = seconds % 60;
        if (days > 0) {
            result.append(days).append("d ");
        }
        if (hrs > 0) {
            result.append(hrs).append("h ");
        }
        if (mins > 0) {
            result.append(mins).append("m ");
        }
        if (secs > 0) {
            result.append(secs).append("s ");
        }
        return result.toString();
    }

    public static String singleDecimalDigit(double d) {
        return new DecimalFormat("#.#").format(d);
    }

    public static String shortenText(String text, int chars) {
        if (text.length() <= chars) {
            return text;
        }
        return text.substring(0, chars - 1) + "\u2026";
    }
}

