/* $Id: ConstInteger.cpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "frontend/ast/ConstInteger.hpp"
#include "frontend/ast/SimpleName.hpp"
#include "frontend/ast/PhysicalTypeUnit.hpp"
#include "frontend/misc/Symbol.hpp"
#include "frontend/reporting/SyntaxError.hpp"
#include "util/MiscUtil.hpp"

namespace ast {

ConstInteger::ConstInteger(
	universal_integer val,
	Name* unit,
	Location loc
) : 		Expression(BASE_TYPE_INTEGER, loc),
		physUnit(unit),
		value(ConstInteger::makeValue(unit, val)) {}

ConstInteger::ConstInteger(
	universal_real val,
	Name* unit,
	Location loc
	) : 	Expression(BASE_TYPE_INTEGER, loc),
		physUnit(unit),
		value(ConstInteger::makeValue(unit, val)) {}


template<typename T>
universal_integer
ConstInteger::makeValue(Name *unit, T numericValue) {
	assert(unit != NULL);
	if (unit->candidates.size() != 1) {
		std::string msg = util::MiscUtil::toString(unit->location);
		msg += " Not a physical literal: <";
		msg += util::MiscUtil::toString(unit);
		msg += ">";

		throw yy::SyntaxError(msg);
	}

	Symbol *sym = unit->candidates.front();
	// FIXME? must this really be a simple name (expanded names are
	//        stored as SimpleName as well!).
	const SimpleName *sn = dynamic_cast<const SimpleName*>(unit);
	if ((sym->type != SYMBOL_UNIT) || (sn == NULL)) {
		std::string msg = util::MiscUtil::toString(unit->location);
		msg += " Not a physical literal: <";
		msg += util::MiscUtil::toString(unit);
		msg += ">";

		throw yy::SyntaxError(msg);
	}


	const PhysicalTypeUnit *pu = 
		dynamic_cast<const PhysicalTypeUnit*>(&sym->declaration);
	assert(pu != NULL);
	return static_cast<universal_integer>(
		static_cast<universal_real>(pu->factor) * 
		static_cast<universal_real>(numericValue));
}


}; /* namespace ast */
