/* $Id: SetPathName.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * For different symbol bearing nodes, determine the full vhdl path name.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */


#ifndef __SET_PATHNAME_HPP_INCLUDED
#define __SET_PATHNAME_HPP_INCLUDED

#include "frontend/visitor/TopDownVisitor.hpp"
#include <list>

namespace ast {

//! set the path name of any symbol.
/** This visitor will set the corresponding path name of any symbol. 
 *  Dependencies: Any visitor that adds declarations *must* have been
 *                executed before. NormalizeAssocs is one example.
 */
class SetPathName : public TopDownVisitor {
public:
	//! c'tor
	SetPathName();
	
	/** Visit a Library.
	 *  @param node Library node that get's visited.
	 */
	virtual void visit(Library &node);

	/** Visit an Entity declaration.
	 *  @param node Entity Declaration node that get's visited.
	 */
	virtual void visit(Entity &node);

	/** Visit an Architecture node.
	 *  @param node Architecture node that get's visited.
	 */
	virtual void visit(Architecture &node);

	/** Visit a Package node.
	 *  @param node Package node that get's visited.
	 */
	virtual void visit(Package &node);

	/** Visit a Process node.
	 *  @param node Process node that get's visited.
	 */
	virtual void visit(Process &node);

	/** Visit a FunctionDeclaration node.
	 *  @param node FunctionDeclaration node that get's visited.
	 */
	virtual void visit(FunctionDeclaration &node);

	/** Visit a ProcedureDeclaration node.
	 *  @param node ProcedureDeclaration node that get's visited.
	 */
	virtual void visit(ProcedureDeclaration &node);

private:
	/** process a generic SymbolDeclaration
	 *  @param node SymbolDeclaration to process
	 */
	virtual void process(SymbolDeclaration &node);

	//! Process a generic Callable.
	/** This function will set the path name of a callable, adding 
	 *  suffix to it if not NULL.
	 */
	void processCallable(Callable &node, const std::string *pSuffix);

	//! determine the current path name.
	std::string getPath(void) const;
	//! stack with entries of the current path.
	std::list<std::string> currentPath;
	//! counter to make unique path names for anonymous constructs.
	int anonCounter;
}; 

}; /* namespace ast */

#endif /* __SET_PATHNAME_HPP_INCLUDED */
