/* $Id$ 
 * NullVisitor: base class for visitors that don't want any default traversal.
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "frontend/visitor/NullVisitor.hpp"
#include "frontend/ast/ConstInteger.hpp"
#include "frontend/ast/ConstReal.hpp"
#include "frontend/ast/ConstArray.hpp"
#include "frontend/ast/Entity.hpp"
#include "frontend/ast/SymbolDeclaration.hpp"
#include "frontend/ast/ValDeclaration.hpp"
#include "frontend/ast/SignalDeclaration.hpp"
#include "frontend/ast/ConstantDeclaration.hpp"
#include "frontend/ast/Expression.hpp"
#include "frontend/ast/IfStat.hpp"
#include "frontend/ast/NullStat.hpp"
#include "frontend/ast/ForLoopStat.hpp"
#include "frontend/ast/WhileLoopStat.hpp"
#include "frontend/ast/NextStat.hpp"
#include "frontend/ast/VarAssignStat.hpp"
#include "frontend/ast/WaitStat.hpp"
#include "frontend/ast/ExitStat.hpp"
#include "frontend/ast/SigAssignStat.hpp"
#include "frontend/ast/WaveFormElem.hpp"
#include "frontend/ast/ReturnStat.hpp"
#include "frontend/ast/ProcCallStat.hpp"
#include "frontend/ast/AssertStat.hpp"
#include "frontend/ast/VarDeclaration.hpp"
#include "frontend/ast/DiscreteRange.hpp"
#include "frontend/ast/CaseStat.hpp"
#include "frontend/ast/CaseAlternative.hpp"
#include "frontend/ast/Others.hpp"
#include "frontend/ast/Architecture.hpp"
#include "frontend/ast/AssociationElement.hpp"
#include "frontend/ast/FunctionDeclaration.hpp"
#include "frontend/ast/ProcedureDeclaration.hpp"
#include "frontend/ast/CompInstStat.hpp"
#include "frontend/ast/Package.hpp"
#include "frontend/ast/PackageBody.hpp"
#include "frontend/ast/Process.hpp"
#include "frontend/ast/SubprogBody.hpp"
#include "frontend/ast/CondalSigAssign.hpp"
#include "frontend/ast/EnumerationType.hpp"
#include "frontend/ast/PhysicalType.hpp"
#include "frontend/ast/PhysicalTypeUnit.hpp"
#include "frontend/ast/RangeConstraintType.hpp"
#include "frontend/ast/UnconstrainedArrayType.hpp"
#include "frontend/ast/RecordType.hpp"
#include "frontend/ast/Aggregate.hpp"
#include "frontend/ast/FunctionCall.hpp"
#include "frontend/ast/ElementAssociation.hpp"
#include "frontend/ast/SubtypeIndication.hpp"
#include "frontend/ast/Library.hpp"
#include "frontend/ast/LibraryList.hpp"
#include "frontend/ast/Subscript.hpp"
#include "frontend/ast/Slice.hpp"
#include "frontend/ast/TemporaryName.hpp"
#include "frontend/ast/SelectedName.hpp"
#include "frontend/ast/AttributeName.hpp"
#include "frontend/ast/TypeConversion.hpp"
#include "frontend/ast/AttributeDeclaration.hpp"
#include "frontend/ast/AttributeSpecification.hpp"

namespace ast {

void
NullVisitor::visit(ElementAssociation& node)
{
	this->process(node);
}

void
NullVisitor::visit(ConstReal& node)
{
	this->process(node);
}

void
NullVisitor::visit(ConstArray &node)
{
	this->process(node);
}

void 
NullVisitor::visit(SimpleName &node)
{
	this->process(node);
}

void 
NullVisitor::visit(TemporaryName &node)
{
	this->process(node);
}

void 
NullVisitor::visit(SelectedName &node)
{
	this->process(node);
}

void 
NullVisitor::visit(AttributeName &node)
{
	this->process(node);
}

void
NullVisitor::visit(Entity& node)
{
	this->process(node);
}

void
NullVisitor::visit(LibraryList& node)
{
	this->process(node);
}

void
NullVisitor::visit(SignalDeclaration& node)
{
	this->process(node);
}

void
NullVisitor::visit(ConstantDeclaration& node)
{
	this->process(node);
}

void
NullVisitor::visit(FunctionCall& node)
{
	this->process(node);
}

void
NullVisitor::visit(IfStat& node)
{
	this->process(node);
}

void
NullVisitor::visit(NullStat& node)
{
	this->process(node);
}

void
NullVisitor::visit(ForLoopStat& node)
{
	this->process(node);
}

void
NullVisitor::visit(WhileLoopStat& node)
{
	this->process(node);
}

void 
NullVisitor::visit(NextStat& node) 
{
	this->process(node);
}

void 
NullVisitor::visit(VarAssignStat& node) 
{
	this->process(node);
}

void 
NullVisitor::visit(WaitStat& node) 
{
	this->process(node);
}

void 
NullVisitor::visit(ExitStat& node) 
{
	this->process(node);
}

void 
NullVisitor::visit(SigAssignStat& node) 
{
	this->process(node);
}

void 
NullVisitor::visit(WaveFormElem& node) 
{
	this->process(node);
}

void 
NullVisitor::visit(ReturnStat& node) 
{
	this->process(node);
}

void 
NullVisitor::visit(ProcCallStat& node) 
{
	this->process(node);

}

void 
NullVisitor::visit(AssertStat& node) 
{
	this->process(node);
}

void 
NullVisitor::visit(VarDeclaration& node) 
{
	this->process(node);
}

void 
NullVisitor::visit(DiscreteRange& node) 
{
	this->process(node);
}


void 
NullVisitor::visit(CaseStat& node) 
{
	this->process(node);
}

void 
NullVisitor::visit(CaseAlternative& node) 
{
	this->process(node);
}

void 
NullVisitor::visit(Others& node) 
{
	this->process(node);
}

void 
NullVisitor::visit(Architecture& node) 
{
	this->process(node);
}

void 
NullVisitor::visit(AssociationElement& node) 
{
	this->process(node);
}

void 
NullVisitor::visit(FunctionDeclaration& node) 
{
	this->process(node);
}

void 
NullVisitor::visit(ProcedureDeclaration& node) 
{
	this->process(node);
}

void 
NullVisitor::visit(CompInstStat& node) 
{
	this->process(node);
}

void 
NullVisitor::visit(Package& node) 
{
	this->process(node);
}

void 
NullVisitor::visit(PackageBody& node) 
{
	this->process(node);
}

void 
NullVisitor::visit(Process& node) 
{
	this->process(node);
}

void 
NullVisitor::visit(SubprogBody& node) 
{
	this->process(node);
}

void 
NullVisitor::visit(CondalSigAssign& node) 
{
	this->process(node);
}

void 
NullVisitor::visit(EnumerationType& node) 
{
	this->process(node);
}

void 
NullVisitor::visit(PhysicalType& node) 
{
	this->process(node);
}

void 
NullVisitor::visit(PhysicalTypeUnit& node) 
{
	this->process(node);
}

void 
NullVisitor::visit(RangeConstraintType& node) 
{
	this->process(node);
}

void 
NullVisitor::visit(UnconstrainedArrayType& node) 
{
	this->process(node);
}

void 
NullVisitor::visit(RecordType& node) 
{
	this->process(node);
}

void
NullVisitor::visit(RecordTypeElement& node)
{
	this->process(node);
}

void
NullVisitor::visit(Aggregate& node)
{
	this->process(node);
}

void
NullVisitor::visit(SubtypeIndication& node)
{
	this->process(node);
}

void
NullVisitor::visit(Library& node)
{
	this->process(node);
}

void
NullVisitor::visit(Subscript& node)
{
	this->process(node);
}

void
NullVisitor::visit(Slice &node)
{
	this->process(node);
}

void
NullVisitor::visit(ConstInteger &node)
{
	this->process(node);
}

void
NullVisitor::visit(TypeConversion &node)
{
	this->process(node);
}

void
NullVisitor::visit(AttributeDeclaration &node)
{
	this->process(node);
}

void
NullVisitor::visit(AttributeSpecification &node)
{
	this->process(node);
}

void
NullVisitor::process(ValDeclaration &node)
{
	SymbolDeclaration& sNode = static_cast<SymbolDeclaration&>(node);
	this->process(sNode);
}

void
NullVisitor::process(SymbolDeclaration &node) 
{
	AstNode& aNode = static_cast<AstNode&>(node);
	this->process(aNode);
}

void
NullVisitor::process(Expression &node) 
{
	AstNode& aNode = static_cast<AstNode&>(node);
	this->process(aNode);
}

void
NullVisitor::process(SeqStat &node) 
{
	AstNode& anode = static_cast<AstNode&>(node);
	this->process(anode);
}

void
NullVisitor::process(LoopStat &node) 
{
	SeqStat& snode = static_cast<SeqStat&>(node);
	this->process(snode);

}

void
NullVisitor::process(ConditionedStat &node) 
{
	SeqStat& snode = static_cast<SeqStat&>(node);
	this->process(snode);
}

void
NullVisitor::process(Callable &node) 
{
	SymbolDeclaration& snode = static_cast<SymbolDeclaration&>(node);
	this->process(snode);
}

void
NullVisitor::process(LibUnit &node) 
{
	AttributableDeclaration& snode = 
		static_cast<AttributableDeclaration&>(node);
	this->process(snode);
}

void
NullVisitor::process(TypeDeclaration &node) 
{
	SymbolDeclaration& snode = static_cast<SymbolDeclaration&>(node);
	this->process(snode);
}

void
NullVisitor::process(PrefixedName &node) 
{
	Name &n = static_cast<Name&>(node);
	this->process(n);
}

void
NullVisitor::process(Name &node) 
{
	Expression& exp = static_cast<Expression&>(node);
	this->process(exp);
}

void
NullVisitor::process(AttributableDeclaration &node)
{
	SymbolDeclaration &snode = static_cast<SymbolDeclaration &>(node);
	this->process(snode);
}


}; /* namespace ast */
