-- $Id$ 

-- check ports which are arrays of signals.

-- Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.


package t is
	type ba is array(integer range <>) of boolean;
end package;

use t.ba;
ENTITY bottom IS
	PORT (
		x : in ba(1 to 10);
		y : out boolean
	);
END ENTITY bottom;

ARCHITECTURE bottom_impl OF bottom IS
BEGIN
	p : process(x)
		variable r : boolean;
	begin
		r := false;
		for i in x'range loop
			r := r or x(i);
		end loop;
		y <= r;
	end process;
END ARCHITECTURE;

use t.ba;
ENTITY test_bench IS
END ENTITY test_bench;

ARCHITECTURE test_bench_impl of test_bench IS
	signal int_x : ba(1 to 10);
	signal int_y : boolean;
BEGIN
	b : bottom port map(x => int_x, y => int_y);

	p : process
	begin
		assert false report "simulation finished" severity note;
		wait;
	end process;
end;
