/* $Id: sig_boolean_or.h,v 1.13 2012-03-06 14:46:49 siflkres Exp $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_BOOLEAN_OR_H_INCLUDED
#define __SIG_BOOLEAN_OR_H_INCLUDED

#include "sig_gen.h"

struct sig_boolean_or_funcs {
	void (*set)(void *s, unsigned int val);
	void (*set_ext)(void *s, unsigned int val);
};

struct sig_boolean_or {
	enum sig_gen_type type;
	struct {
		void *s;
		const struct sig_boolean_or_funcs *f;
		unsigned int in;
	} in[16];
	int in_count;

	struct {
		void *s;
		unsigned int out;
	} out[16];
	int out_count;
};

struct sig_boolean_or_merge {
	struct sig_boolean_or *s0;
	struct sig_boolean_or *s1;
};

extern void
sig_boolean_or_set(struct sig_boolean_or *b, void *s, unsigned int val);

extern void
sig_boolean_or_connect_in(struct sig_boolean_or *b,
		void *s, const struct sig_boolean_or_funcs *f);
extern void
sig_boolean_or_connect_out(struct sig_boolean_or *b,
		void *s, unsigned int val);

extern struct sig_boolean_or_merge *
sig_boolean_or_merge(struct sig_boolean_or *s0, struct sig_boolean_or *s1);
extern void
sig_boolean_or_split(struct sig_boolean_or_merge *m);

extern struct sig_boolean_or *
sig_boolean_or_create(const char *name);
extern void
sig_boolean_or_destroy(struct sig_boolean_or *b);

extern void
sig_boolean_or_suspend(struct sig_boolean_or *b, FILE *fSig);
extern void
sig_boolean_or_resume(struct sig_boolean_or *b, FILE *fSig);

#endif /* __SIG_BOOLEAN_OR_H_INCLUDED */
