/* $Id: arch_gen_cpu_x86_mmu.h,v 1.30 2009-11-06 14:15:06 vrsieh Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __CPU_MMU_H_INCLUDED
#define __CPU_MMU_H_INCLUDED

#include "sig_boolean.h"

#include "exec-all.h"

/*
 * Constants
 */
#define TLB_INVALID_MASK	(1 << 3)
#define IO_MEM_SHIFT		4

#define IO_MEM_RAM		(0 << IO_MEM_SHIFT) /* hardcoded offset */
#define IO_MEM_CODE		(1 << IO_MEM_SHIFT) /* used internally */
#define IO_MEM_IO		(2 << IO_MEM_SHIFT)
#define IO_MEM_IO_CODE		(3 << IO_MEM_SHIFT) /* used internally */
#define IO_MEM_NB_ENTRIES	4

/*
 * Types
 */
typedef void CPUWriteMemoryFunc(Paddr addr, uint32_t value);
typedef uint32_t CPUReadMemoryFunc(Paddr addr);

/*
 * Variables
 */
extern CPUReadMemoryFunc *const NAME_(io_mem_read)[IO_MEM_NB_ENTRIES][4];
extern CPUWriteMemoryFunc *const NAME_(io_mem_write)[IO_MEM_NB_ENTRIES][4];
extern CPUReadMemoryFunc *const NAME_(io_mem_code)[IO_MEM_NB_ENTRIES][4];

/*
 * Functions
 */
#define ACCESS_TYPE 3
#define MEMSUFFIX _code

#define DATA_SIZE 1
#include "arch_gen_cpu_x86_mmu_template.h"

#define DATA_SIZE 2
#include "arch_gen_cpu_x86_mmu_template.h"

#define DATA_SIZE 4
#include "arch_gen_cpu_x86_mmu_template.h"

#if CONFIG_CPU >= 80486 && CONFIG_CPU_LM_SUPPORT
#define DATA_SIZE 8
#include "arch_gen_cpu_x86_mmu_template.h"
#endif /* CONFIG_CPU >= 80486 && CONFIG_CPU_LM_SUPPORT */

#undef ACCESS_TYPE
#undef MEMSUFFIX

extern void
NAME_(mmu_invlpg)(Vaddr page);
extern void
NAME_(mmu_flush_all)(int flush_global);

extern void
NAME_(tlb_protect)(unsigned long pa);
extern void
NAME_(tlb_unprotect)(unsigned long pa);

extern Paddr
NAME_(tlb_virt_to_phys)(Vaddr va);

/* QEMU: Located in *fast* path! FIXME VOSSI */
extern void
NAME_(tlb_fill)(Vaddr addr, int is_write, int is_user, void *retaddr);
extern int
NAME_(mmu_fault)(Vaddr addr, int rwx, int is_user);

extern void
NAME_(mmu_unmap_range)(unsigned long pa, unsigned long len);

extern void
NAME_(mmu_reset)(void);

extern void
NAME_(mmu_init)(struct cpu *css);

#endif /* __CPU_MMU_H_INCLUDED */
