#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core import debug


class sound_driver:
    def __init__(self):
        self.volume = None
        self._initialized = False

    def initialize(self, environment):
        self.env = environment
        self._initialized = True

    def shutdown(self):
        if not self._initialized:
            return
        self.cancel()
        self._is_initialized = False

    def play_frequence(
        self, frequence, duration, adjust_volume=0.0, interrupt=True
    ):
        if not self._initialized:
            return
        if interrupt:
            self.cancel()

    def play_sound_file(self, file_path, interrupt=True):
        if not self._initialized:
            return
        if interrupt:
            self.cancel()

    def cancel(self):
        if not self._initialized:
            return

    def set_callback(self, callback):
        if not self._initialized:
            return

    def set_volume(self, volume):
        if not self._initialized:
            return
        self.volume = volume
