	SUBROUTINE LINFIT(ILNE,X,NSIZE,IBASE,PBUF)
	DIMENSION X(NSIZE)
*
*
*  This software was developed by the Thermal Modeling and Analysis
*  Project(TMAP) of the National Oceanographic and Atmospheric
*  Administration's (NOAA) Pacific Marine Environmental Lab(PMEL),
*  hereafter referred to as NOAA/PMEL/TMAP.
*
*  Access and use of this software shall impose the following
*  obligations and understandings on the user. The user is granted the
*  right, without any fee or cost, to use, copy, modify, alter, enhance
*  and distribute this software, and any derivative works thereof, and
*  its supporting documentation for any purpose whatsoever, provided
*  that this entire notice appears in all copies of the software,
*  derivative works and supporting documentation.  Further, the user
*  agrees to credit NOAA/PMEL/TMAP in any publications that result from
*  the use of this software or in any product that includes this
*  software. The names TMAP, NOAA and/or PMEL, however, may not be used
*  in any advertising or publicity to endorse or promote any products
*  or commercial entity unless specific written permission is obtained
*  from NOAA/PMEL/TMAP. The user also understands that NOAA/PMEL/TMAP
*  is not obligated to provide the user with any support, consulting,
*  training or assistance of any kind with regard to the use, operation
*  and performance of this software nor to provide the user with any
*  updates, revisions, new versions or "bug fixes".
*
*  THIS SOFTWARE IS PROVIDED BY NOAA/PMEL/TMAP "AS IS" AND ANY EXPRESS
*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
*  ARE DISCLAIMED. IN NO EVENT SHALL NOAA/PMEL/TMAP BE LIABLE FOR ANY SPECIAL,
*  INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
*  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
*  CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
*  CONNECTION WITH THE ACCESS, USE OR PERFORMANCE OF THIS SOFTWARE. 
*
*
C**    @(#)linfit.F	1.1    3/10/88
C**
* v580 *acm* 8/04 Change use of 256 to buflen+1, 
*                 where buflen is defined in cmndlen.inc
C**
C***********************************************************************
C**
C**                 PLOT+ Scientific Graphics System
C**
C***********************************************************************
C**
C**

	INCLUDE 'PARAMPL5.DAT'
	INCLUDE 'LINES.INC'
	INCLUDE 'DATA.INC'
	INCLUDE 'CMRD.INC'
	INCLUDE 'LUNITS.INC'
	INCLUDE 'SYSTEM.INC'
        INCLUDE 'cmndlen.inc'

	CHARACTER OUT*80,SYM*30
C
C	DO A LEAST SQUARES FIT ON LINE 'ILNE', PLACE THE RESULT INTO
C	THE ECHO FILE AND INTO 'LINEN+1' AND CLEAN UP VARIABLES
C
C	CALCULATE BASE FOR REGRESSION DATA
C
	CALL SETFIT(ILNE,X,NSIZE,IBASEJ,XIMIN,XIMAX)
	NPTS=LLENG(ILNE)
	CALL CORREL(X,NSIZE,IBASEJ,NPTS,XIMIN,XIMAX,R,A,B,AS,BS,VAR,STD)
C
C	WRITE RESULTS INTO GLOBAL SYMBOLS
C
	SYM='*PPL$LF_R2'
	WRITE(OUT,'(F10.4)')R*R
	CALL PUTSYM(SYM,OUT,10,IER)
	SYM='*PPL$LF_A'
	CALL PUTVAL(SYM,A,4,IER)
	SYM='*PPL$LF_A_STDEV'
	CALL PUTVAL(SYM,AS,4,IER)
	SYM='*PPL$LF_B'
	CALL PUTVAL(SYM,B,4,IER)
	SYM='*PPL$LF_B_STDEV'
	CALL PUTVAL(SYM,BS,4,IER)
	SYM='*PPL$LF_VAR'
	CALL PUTVAL(SYM,VAR,4,IER)
	SYM='*PPL$LF_RES_VAR'
	ST2=STD*STD
	CALL PUTVAL(SYM,ST2,4,IER)
C
C	WRITE STATS INTO ECHO FILE AND ON SCREEN
C
	WRITE(OUT,999)
	IF(.NOT.QUIETF)WRITE(LTTOUT,991)OUT
	NOUT=LNBLK(OUT,80)
	CALL ECHO(OUT,NOUT)
	WRITE(OUT,998)NPTS
	IF(.NOT.QUIETF)WRITE(LTTOUT,991)OUT
	NOUT=LNBLK(OUT,80)
	CALL ECHO(OUT,NOUT)
	WRITE(OUT,997)XIMIN,XIMAX
	IF(.NOT.QUIETF)WRITE(LTTOUT,991)OUT
	NOUT=LNBLK(OUT,80)
	CALL ECHO(OUT,NOUT)
	WRITE(OUT,996)R*R
	IF(.NOT.QUIETF)WRITE(LTTOUT,991)OUT
	NOUT=LNBLK(OUT,80)
	CALL ECHO(OUT,NOUT)
	WRITE(OUT,995)A,AS
	IF(.NOT.QUIETF)WRITE(LTTOUT,991)OUT
	NOUT=LNBLK(OUT,80)
	CALL ECHO(OUT,NOUT)
	WRITE(OUT,994)B,BS
	IF(.NOT.QUIETF)WRITE(LTTOUT,991)OUT
	NOUT=LNBLK(OUT,80)
	CALL ECHO(OUT,NOUT)
	WRITE(OUT,993)VAR
	IF(.NOT.QUIETF)WRITE(LTTOUT,991)OUT
	NOUT=LNBLK(OUT,80)
	CALL ECHO(OUT,NOUT)
	WRITE(OUT,992)STD*STD
	IF(.NOT.QUIETF)WRITE(LTTOUT,991)OUT
	NOUT=LNBLK(OUT,80)
	CALL ECHO(OUT,NOUT)
999	FORMAT(
     *	'C --  LINFIT RESULTS      Y = A + B*X')
998	FORMAT(
     *	'C --                 LENGTH = ',I10)
997	FORMAT(
     *	'C --  X LIMITS USED FOR FIT = ',1PG10.3,',',G10.3)
996	FORMAT(
     *	'C --                     R2 = ',0PF10.4)
995	FORMAT(
     *	'C --  REGRESSION COEFFS:  A = ',1PG10.3,'   ST-DEV = ',G10.3)
994	FORMAT(
     *	'C --                      B = ',  G10.3,'   ST-DEV = ',G10.3)
993	FORMAT(
     *	'C --         TOTAL VARIANCE = ',G10.3)
992	FORMAT(
     *	'C --      RESIDUAL VARIANCE = ',G10.3)
991	FORMAT(1X,A70)
C
C	INSERT INTO NEXT LINE
C
	CALL GETFIT(X,NSIZE,IBASE,XIMIN,XIMAX,A,B,PBUF)
	RETURN
	END
	SUBROUTINE GETFIT(X,NSIZE,IBASE,XIMIN,XIMAX,A,B,PBUF)
	DIMENSION X(NSIZE)
#ifdef  unix
	INCLUDE 'PARAMPL5.DAT'
	INCLUDE 'LINES.INC'
	INCLUDE 'DATA.INC'
	INCLUDE 'CMRD.INC'
	INCLUDE 'LUNITS.INC'
	INCLUDE 'SYSTEM.INC'
#else
        INCLUDE 'pplinc:PARAMPL5.DAT'
        INCLUDE 'pplinc:LINES.INC'
        INCLUDE 'pplinc:DATA.INC'
        INCLUDE 'pplinc:CMRD.INC'
        INCLUDE 'pplinc:LUNITS.INC'
        INCLUDE 'CMDINC:SYSTEM.INC'
#endif
	CHARACTER OUT*80
	LINEN=LINEN+1
	XMIN=XIMIN
	XMAX=XIMAX
	IF(M.GE.4.AND.IFLG(4).EQ.1)XMIN=P(4)
	IF(M.GE.5.AND.IFLG(5).EQ.1)XMAX=P(5)
	YMIN=A+B*XMIN
	YMAX=A+B*XMAX
	IX=IBASE-1
	IY=NSIZE/2+IX
C
C	LOAD FITTED LINE
C
	WRITE(OUT,996)XMIN,XMAX
	IF(.NOT.QUIETF)WRITE(LTTOUT,997)OUT
997	FORMAT(1X,A79)
	NOUT=LNBLK(OUT,80)
	CALL ECHO(OUT,NOUT)
996	FORMAT(
     *	'C -- X LIMITS USED FOR LINE = ',1PG10.3,',',G10.3)
	X(IX+1)=XMIN
	X(IY+1)=YMIN
	X(IX+2)=XMAX
	X(IY+2)=YMAX
	LLENG(LINEN)=2
	CALL STMNMX(X,NSIZE,XMIN,XMAX,YMIN,YMAX)
	IBASE=IBASE+2
	IF(.NOT.QUIETF)WRITE(LTTOUT,999)
999	FORMAT(1X,'     2 POINTS READ')
	lnum=linen
	RETURN
	END
      SUBROUTINE CORREL (X,NSIZE,IBASE,N,XMN,XMX,R,A,B,AS,BS,VAR,STD)
#ifdef  unix
	INCLUDE 'MISS.INC'
#else
	INCLUDE 'pplinc:MISS.INC'
#endif
C
C     COMPUTES THE SAMPLE CORRELATION, R, BETWEEN TWO ARRAYS OF VALUES
C     (X,Y) WITH N DATA POINTS. CALCULATES CORRELATION SIGNIFICANCE
C     PARAMETERS - T (UNCORRELATED POPULATION) AND Z (CORRELATED
C     POPULATION).
C     ALSO CALCULATES LINEAR REGRESSION COEFFICIENTS (A,B)
C
C     PROGRAMMED BY JIM HOLBROOK, AUG, 72.
C
      DIMENSION X(NSIZE)
      IX=IBASE
      IY=NSIZE/2+IX
      XX=0.
      YY=0.
      XY=0.
      X1=0.
      Y1=0.
	NN=N
	N=0
      DO 900 I=1,NN
	XT=X(IX+I)
	YT=X(IY+I)
	IF(XT.LT.XMN.OR.XT.GT.XMX)GOTO 900
	IF((XLE.AND.XT.LE.CMXLE).OR.
     *	   (XEQ.AND.XT.EQ.CMXEQ).OR.
     *	   (XGE.AND.XT.GE.CMXGE).OR.
     *	   (YLE.AND.YT.LE.CMYLE).OR.
     *	   (YEQ.AND.YT.EQ.CMYEQ).OR.
     *	   (YGE.AND.YT.GE.CMYGE))GOTO 900
	N=N+1
      XY=XY+XT*YT
      X1=X1+XT
      Y1=Y1+YT
      XX=XX+XT**2
      YY=YY+YT**2
900	CONTINUE
      XN=N
      A=(XX*Y1-X1*XY)/(XN*XX-X1*X1)
      B=(XN*XY-X1*Y1)/(XN*XX-X1*X1)
      S=(-2.0*(B*XY-A*B*X1+A*Y1)+B*B*XX+XN*A*A+YY)
      S=SQRT(S/(XN-2))
      AS=S*SQRT(XX/(XN*XX-X1*X1))
      BS=S*SQRT(1.0/(XX-X1*X1/XN))
      R1=XN*XY-X1*Y1
      R2=(XN*XX-X1**2)*(XN*YY-Y1**2)
 903  R=R1/SQRT(R2)
	VAR=(YY/N-(Y1/N)**2)
      IF (ABS(R-1.) .LE. 1.E-6) R=1.
      STD=VAR*(1-R*R)
      STD=SQRT(STD)
      RETURN
      END
	SUBROUTINE SETFIT(ILNE,X,NSIZE,JBASE,XIMIN,XIMAX)
	DIMENSION X(NSIZE)
	INCLUDE 'PARAMPL5.DAT'
	INCLUDE 'MISS.INC'
	INCLUDE 'LINES.INC'
	INCLUDE 'DATA.INC'
	INCLUDE 'CMRD.INC'
	INCLUDE 'CMRDL.INC'
	INCLUDE 'AXISL.INC'
	INCLUDE 'TAXIS.INC'

	CHARACTER DATE*10
	IF(ITFLG.EQ.1.AND.N.NE.0)THEN
C
C	PARSE THE LABEL FOR MIN AND MAX TIMES
C
200	IW=INDEX(LABEL,'W')
	IF(IW.EQ.0)GOTO 100
	ICM=INDEX(LABEL,',')
	ISPC=INDEX(LABEL,' ')
	IF(ICM.EQ.0)ICM=buflen+1
	IF(ISPC.EQ.0)ISPC=buflen+1
	IF(ICM.LT.IW)THEN
		M=M+1
		IFLG(M)=0
		LABEL=LABEL(ICM+1:)
	ELSE
		IEND=MIN0(ICM,ISPC,N)
		ILEN=IEND-IW-2
		DATE=LABEL(IW+1:IEND-1)
		IF(ILEN.LT.10)DATE(ILEN+1:)='0000000000'
		M=M+1
		IFLG(M)=1
		P(M)=DIFF(ITSTRT,DATE)/DT+1.0
		LABEL=LABEL(IEND+1:)
	ENDIF
	GOTO 200
	ENDIF
100	JBASE=0
	DO 10 J=1,ILNE-1
10	JBASE=JBASE+LLENG(J)
C
	N=LLENG(ILNE)
C
C	FIND XMIN, AND XMAX
C
	XMIN=1.E38
	XMAX=-XMIN
	DO 20 I=1,LLENG(ILNE)
	IF((XLE.AND.X(JBASE+I).LE.CMXLE).OR.
     *	   (XEQ.AND.X(JBASE+I).EQ.CMXEQ).OR.
     *	   (XGE.AND.X(JBASE+I).GE.CMXGE))GOTO 20
	IF(X(JBASE+I).LT.XMIN)XMIN=X(JBASE+I)
	IF(X(JBASE+I).GT.XMAX)XMAX=X(JBASE+I)
20	CONTINUE
C
C	TEST FOR MIN AND MAX
C
	IF(M.GE.2.AND.IFLG(2).EQ.1)THEN
		XIMIN=P(2)
	ELSE
		XIMIN=XMIN
	ENDIF
	IF(M.GE.3.AND.IFLG(3).EQ.1)THEN
		XIMAX=P(3)
	ELSE
		XIMAX=XMAX
	ENDIF
	RETURN
	END
