/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import visad.CoordinateSystem;
import visad.DoubleSet;
import visad.FloatSet;
import visad.SetType;
import visad.SimpleSet;
import visad.Unit;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryCoordinateSystem;
import visad.data.visad.object.BinaryIntegerArray;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinarySetType;
import visad.data.visad.object.BinaryUnit;
import visad.data.visad.object.BinaryUnknown;

public class BinarySimpleSet
implements BinaryObject {
    public static final int computeBytes(CoordinateSystem cs, Unit[] units) {
        int unitsLen = BinaryUnit.computeBytes(units);
        return 10 + (cs == null ? 0 : 5) + (unitsLen == 0 ? 0 : unitsLen + 1) + 1;
    }

    public static final SimpleSet read(BinaryReader reader, byte dataType) throws IOException, VisADException {
        BinaryObjectCache typeCache = reader.getTypeCache();
        BinaryObjectCache cSysCache = reader.getCoordinateSystemCache();
        DataInput file = reader.getInput();
        int typeIndex = file.readInt();
        SetType st = (SetType)typeCache.get(typeIndex);
        CoordinateSystem cs = null;
        Unit[] units = null;
        boolean reading = true;
        block11: while (reading) {
            byte directive;
            try {
                directive = file.readByte();
            }
            catch (EOFException eofe) {
                return null;
            }
            switch (directive) {
                case 32: {
                    int index = file.readInt();
                    cs = (CoordinateSystem)cSysCache.get(index);
                    continue block11;
                }
                case 40: {
                    units = BinaryUnit.readList(reader);
                    continue block11;
                }
                case 80: {
                    reading = false;
                    continue block11;
                }
            }
            throw new IOException("Unknown SimpleSet directive " + directive);
        }
        if (st == null) {
            throw new IOException("No SetType found for SimpleSet");
        }
        switch (dataType) {
            case 33: {
                return new FloatSet(st, cs, units);
            }
            case 32: {
                return new DoubleSet(st, cs, units);
            }
        }
        throw new IOException("Unknown SimpleSet type " + dataType);
    }

    public static final void writeDependentData(BinaryWriter writer, SetType type, CoordinateSystem cs, Unit[] units, SimpleSet set, Class canonicalClass, Object token) throws IOException {
        DataOutput file = writer.getOutput();
        if (!(set.getClass().equals(canonicalClass) || set instanceof SimpleSet && set instanceof Saveable)) {
            return;
        }
        BinarySetType.write(writer, type, set, SAVE_DATA);
        if (cs != null) {
            BinaryCoordinateSystem.write(writer, cs, SAVE_DATA);
        }
        if (units != null) {
            BinaryUnit.writeList(writer, units, SAVE_DATA);
        }
    }

    public static final void write(BinaryWriter writer, SetType type, CoordinateSystem cs, Unit[] units, SimpleSet set, Class canonicalClass, byte dataType, Object token) throws IOException {
        BinarySimpleSet.writeDependentData(writer, type, cs, units, set, canonicalClass, token);
        if (token == SAVE_DEPEND || token == SAVE_DEPEND_BIG) {
            return;
        }
        if (!(set.getClass().equals(canonicalClass) || set instanceof SimpleSet && set instanceof Saveable)) {
            BinaryUnknown.write(writer, set, token);
            return;
        }
        int typeIndex = writer.getTypeCache().getIndex(type);
        if (typeIndex < 0) {
            throw new IOException("SetType " + type + " not cached");
        }
        int csIndex = -1;
        if (cs != null && (csIndex = writer.getCoordinateSystemCache().getIndex(cs)) < 0) {
            throw new IOException("CoordinateSystem " + cs + " not cached");
        }
        int[] unitsIndex = null;
        if (units != null) {
            unitsIndex = BinaryUnit.lookupList(writer.getCoordinateSystemCache(), units);
        }
        int objLen = BinarySimpleSet.computeBytes(cs, units);
        DataOutput file = writer.getOutput();
        file.writeByte(2);
        file.writeInt(objLen);
        file.writeByte(dataType);
        file.writeInt(typeIndex);
        if (csIndex >= 0) {
            file.writeByte(32);
            file.writeInt(csIndex);
        }
        if (unitsIndex != null) {
            file.writeByte(40);
            BinaryIntegerArray.write(writer, unitsIndex, token);
        }
        file.writeByte(80);
    }
}

