# Gotico-Antiqua, Proto-Roman, Hybrid. *15th century types between gothic and roman*

Atelier national de recherche typographique (École nationale supérieure d’art et de design de Nancy).

# Introduction

The most important change in typography occurred in the fifteenth century. […] It is unbelievable for me, that in the same century, in a very short period of time, an evolution arose from strict gothic to modern roman type. It always remained a mystery to me.
Adrian Frutiger, in Ein Leben, film by Sebastian Rohner, 2011.

The two-day symposium and the exhibition Gotico-Antiqua, Proto-Roman, Hybrid. 15th century types between gothic and roman are based on a current research programme at Atelier national de recherche typographique (ANRT), which investigates the period 1459-1482. The symposium aims to bring together researchers from the fields of typography, palaeography and incunabula studies, with a particular focus on type and letterforms. This relatively understudied period – after Gutenberg and before the consolidation of Jenson’s model – extends from the earliest traces of ‘humanistic’ tendencies to ‘pure’ roman, including many cases of uncertain or experimental design, voluntary hybridisation and proto- or archaic roman. In 1459 in Mainz, Johann Fust and Peter Schöffer printed the Rationale Divinorum Officiorum by Guillaume Durand, using a typeface (now known as Durandus) that looked like no other before. From that point, we can follow a wide variety of developments, partly related to the travels of early printers from the Rhine area to Italy and France. By extension, we are also interested in the Private Press movement initiated by William Morris and Emery Walker at the end of the nineteenth century in England, which revived some of those typefaces before they were once more largely forgotten.

# Typefaces

In parallel to historical research, Rafael Ribas & Alexis Faudot, researchers at ANRT, produced fifteen fonts and one set of initial letters. Based on a series of workshop sessions conducted between 2015 and 2018 in art & design schools across France and Germany, with over 150 students, the digital typefaces are the result of a thorough analysis and redesign of the originals.

Fust & Schöffer ‘Durandus’ 118G, Gotico-Antiqua first used in Mainz by Peter Schöffer & Johann Fust for Guillaume Durand’s Rationale Divinorum Officorum in 1459. The book displays two sizes, the smaller 92G for the main text and the bigger and more contrasted 118G used only for the colophon and later for the famous 48-line Bible in 1462. Used until the end of the century. Type design workshop at Hochschule Mainz and Gutenberg-Bibliothek, Mainz, June 2016.

Sweynheim & Pannartz ‘Subiaco’ 120R, Proto-Roman first used in Subiaco by Konrad Sweynheim & Arnold Pannartz, for an edition of Donatus in 1465 (no longer preserved) and used until 1467 in four editions in total. Type design workshop with students of ANRT at Biblioteca Statale del Monumento Nazionale di Santa Scolastica, Subiaco, May 2018.

Sweynheim & Pannartz 115R, Proto-Roman first used in Rome by Konrad Sweynheim & Arnold Pannartz, for Cicero’s Epistolae ad familiares in 1467 and used until 1476. Type design workshop with students of ANRT at Biblioteca Statale del Monumento Nazionale di Santa Scolastica, Subiaco, May 2018.

Spira 110R, Proto-Roman first used in Venice by Johannes and Vindelinus de Spira for Cicero’s Epistolae ad familiares in 1469 and used until 1473 by Vindelinus. Type design workshop at ENSBA Lyon and Bibliothèque municipale de Lyon, March 2017.

Rot 102R, Proto-Roman first used in Rome by Adam Rot for Dominicus de Sancto Geminiano’s Lecturae super secunda parte sexti Decretalium in 1471 and used until 1474. Type design workshop at HBK Saar and Bibliothèque municipale de Metz, Sarrebrücken, December 2016.

Rusch ‘R-Bizarre’ 103R, Proto-Roman first used in Strasbourg by Adolf Rusch for Raban Maur’s De universo between 1467-74 (exact date unknown) and used until 1475. Type design workshop at ESAL Metz and Bibliothèque municipale de Metz, April 2018. 

Rusch 100G, Gotico-Antiqua first used in Strasbourg by Adolf Rusch for Balbus’ Catholicon, between 1470-75 (exact date unknown) and used until 1478. Type design workshop at ESAL Metz and Bibliothèque municipale de Metz, April 2018.

Soufflet Vert 106R, Hybrid first used in Paris by the Au Soufflet Vert workshop for Guido de Monte Rochen’s Manipulus curatorum, 1476 and used until 1480. Type design workshop at ISBA Besançon and Bibliothèque d’étude et de conservation de Besançon, May 2018. 

Parix 111R, Hybrid first used in Toulouse by Johann Parix for Rodericus Zamorensis’ Speculum vitae humanae, around 1475 (exact date unknown) and used until 1481. Type design workshop at isdaT Toulouse and Bibliothèque municipale de Toulouse, February 2018.

Zainer 96G, Gotico-Antiqua first used in Ulm by Johann Zainer for Jacques de Voragine’s Legenda aurea not after 1477 and used until 1485. Type design workshop at Hochschule Aachen and Stadtbibliothek Aachen, October 2017.

Zainer Initials, richly decorated gothic initials of 45 mm height, first used in Ulm by Johann Zainer for the Spiritual Interpretations of the Life of Jesus Christ around 1478. Used until 1480. Type design workshop at Hochschule Aachen and Stadtbibliothek Aachen, October 2017.

Ptolemy, designed in Chelsea by St John Hornby, Sidney Cockerell and Emery Walker, cut in 18 pt by Edward Prince for Cervantes’ Don Quixote. Published by the Ashendene Press in 1927. The type used until 1935 is a revival of Lienhart Holl’s cut for Ptolemaeus’ Cosmographia printed in 1482 in Ulm. Type design workshop at HEAR Mulhouse, March 2015.

Jessen, hybrid of gothic minuscules and roman capitals designed and cut without preliminary drawings in Offenbach am Main by Rudolf Koch for The Four Gospels. Printed at the Klingspor press in 1926 and published by Koch himself. Formerly named Bibel-Gotisch, the type was released as Jessen in several sizes by the Klingspor foundry in 1930. Type design workshop at ESAD •Valence, April 2016.

Hamlet (also named Kessler-Blackletter), designed by Edward Johnston, cut in three sizes (10, 12 and 18 pt) by Edward Prince for William Shakespeare’s Hamlet. Published by Harry Kessler’s Cranach Press in Weimar in 1929. The type is based on the Durandus for the lowercases, and Sweynheim & Pannartz’ Subiaco type for the capitals. The type was used for trials in other books, none of which were completed. Type design workshop at Bauhaus Universität Weimar and Anna Amalia Bibliothek Weimar, January 2018.
