/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.renderers.OnTheFlyRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmacsRenderer
extends OnTheFlyRenderer {
    protected static final String EOL = System.getProperty("line.separator", "\n");

    @Override
    public void start() throws IOException {
    }

    @Override
    public void renderFileViolations(Iterator<IRuleViolation> violations) throws IOException {
        Writer writer = this.getWriter();
        StringBuffer buf = new StringBuffer();
        while (violations.hasNext()) {
            IRuleViolation rv = violations.next();
            buf.setLength(0);
            buf.append(EOL).append(rv.getFilename());
            buf.append(':').append(Integer.toString(rv.getBeginLine()));
            buf.append(": ").append(rv.getDescription());
            writer.write(buf.toString());
        }
    }

    @Override
    public void end() throws IOException {
    }
}

