/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.junit;

import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.rules.junit.AbstractJUnitRule;

public class TestClassWithoutTestCases
extends AbstractJUnitRule {
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isAbstract() || node.isInterface() || node.isNested()) {
            return data;
        }
        List<ASTMethodDeclaration> m = node.findChildrenOfType(ASTMethodDeclaration.class);
        boolean testsFound = false;
        if (m != null) {
            Iterator<ASTMethodDeclaration> it = m.iterator();
            while (it.hasNext() && !testsFound) {
                ASTMethodDeclaration md = it.next();
                if (this.isInInnerClassOrInterface(md) || !this.isJUnitMethod(md, data)) continue;
                testsFound = true;
            }
        }
        if (!testsFound) {
            this.addViolation(data, node);
        }
        return data;
    }

    private boolean isInInnerClassOrInterface(ASTMethodDeclaration md) {
        ASTClassOrInterfaceDeclaration p = md.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class);
        return p != null && p.isNested();
    }
}

