/* Freebirth
 * Copyright (C) 1999 topher lafata <topher@topher.com>,
 *		      Jake Donham <jake@bitmechanic.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#define __SAMPLE_PRODUCER_H

typedef struct sample_producer sample_producer;

#ifndef __SAMPLE_H
 #include "sample.h"
#endif

#ifndef __EVENT_H
 #include "event.h"
#endif

#define TBASS_BUFF_SIZE 512
#define SAMPLE_MAX 32767
#define SAMPLE_MIN -32767

struct event;

struct sample_producer{ 
  sample *(*get_buffer)(struct sample_producer *); 
  void (*next_buffer)(struct sample_producer *);
  struct sample_producer **(*get_children)(struct sample_producer *);
  char **(*get_header)(struct sample_producer *);
  char **(*get_code)(struct sample_producer *);
  char **(*get_footer)(struct sample_producer *);
  void(* schedule)(struct sample_producer *sp, struct event *e , int offset);  
  void(* trigger)(struct sample_producer *);
  struct event **events;

};


void sp_schedule_event(sample_producer *this,struct event *e, int offset);


/*
  Local Variables:
  mode: font-lock
  End:
*/

