
 /****************************************************************************
 *                       THIS FILE WAS GENERATED                             *
 * Script: common/generate_packets.py                                        *
 * Input:  common/packets.def                                                *
 *                       DO NOT CHANGE THIS FILE                             *
 ****************************************************************************/


#ifdef HAVE_CONFIG_H
#include <fc_config.h>
#endif

#include <string.h>

/* utility */
#include "bitvector.h"
#include "capability.h"
#include "genhash.h"
#include "log.h"
#include "mem.h"
#include "support.h"

/* common */
#include "capstr.h"
#include "connection.h"
#include "dataio.h"
#include "game.h"

#include "packets.h"

static genhash_val_t hash_const(const void *vkey, size_t num_buckets)
{
  return 0;
}

static bool cmp_const(const void *vkey1, const void *vkey2)
{
  return TRUE;
}

void delta_stats_report(void) {}

void delta_stats_reset(void) {}

void *get_packet_from_connection_helper(struct connection *pc,
    enum packet_type type)
{
  switch (type) {

  case PACKET_PROCESSING_STARTED:
    return receive_packet_processing_started(pc, type);

  case PACKET_PROCESSING_FINISHED:
    return receive_packet_processing_finished(pc, type);

  case PACKET_SERVER_JOIN_REQ:
    return receive_packet_server_join_req(pc, type);

  case PACKET_SERVER_JOIN_REPLY:
    return receive_packet_server_join_reply(pc, type);

  case PACKET_AUTHENTICATION_REQ:
    return receive_packet_authentication_req(pc, type);

  case PACKET_AUTHENTICATION_REPLY:
    return receive_packet_authentication_reply(pc, type);

  case PACKET_SERVER_SHUTDOWN:
    return receive_packet_server_shutdown(pc, type);

  case PACKET_NATION_SELECT_REQ:
    return receive_packet_nation_select_req(pc, type);

  case PACKET_PLAYER_READY:
    return receive_packet_player_ready(pc, type);

  case PACKET_ENDGAME_REPORT:
    return receive_packet_endgame_report(pc, type);

  case PACKET_ENDGAME_PLAYER:
    return receive_packet_endgame_player(pc, type);

  case PACKET_TILE_INFO:
    return receive_packet_tile_info(pc, type);

  case PACKET_GAME_INFO:
    return receive_packet_game_info(pc, type);

  case PACKET_MAP_INFO:
    return receive_packet_map_info(pc, type);

  case PACKET_NUKE_TILE_INFO:
    return receive_packet_nuke_tile_info(pc, type);

  case PACKET_TEAM_NAME_INFO:
    return receive_packet_team_name_info(pc, type);

  case PACKET_CHAT_MSG:
    return receive_packet_chat_msg(pc, type);

  case PACKET_CHAT_MSG_REQ:
    return receive_packet_chat_msg_req(pc, type);

  case PACKET_CONNECT_MSG:
    return receive_packet_connect_msg(pc, type);

  case PACKET_CITY_REMOVE:
    return receive_packet_city_remove(pc, type);

  case PACKET_CITY_INFO:
    return receive_packet_city_info(pc, type);

  case PACKET_CITY_SHORT_INFO:
    return receive_packet_city_short_info(pc, type);

  case PACKET_CITY_SELL:
    return receive_packet_city_sell(pc, type);

  case PACKET_CITY_BUY:
    return receive_packet_city_buy(pc, type);

  case PACKET_CITY_CHANGE:
    return receive_packet_city_change(pc, type);

  case PACKET_CITY_WORKLIST:
    return receive_packet_city_worklist(pc, type);

  case PACKET_CITY_MAKE_SPECIALIST:
    return receive_packet_city_make_specialist(pc, type);

  case PACKET_CITY_MAKE_WORKER:
    return receive_packet_city_make_worker(pc, type);

  case PACKET_CITY_CHANGE_SPECIALIST:
    return receive_packet_city_change_specialist(pc, type);

  case PACKET_CITY_RENAME:
    return receive_packet_city_rename(pc, type);

  case PACKET_CITY_OPTIONS_REQ:
    return receive_packet_city_options_req(pc, type);

  case PACKET_CITY_REFRESH:
    return receive_packet_city_refresh(pc, type);

  case PACKET_CITY_NAME_SUGGESTION_REQ:
    return receive_packet_city_name_suggestion_req(pc, type);

  case PACKET_CITY_NAME_SUGGESTION_INFO:
    return receive_packet_city_name_suggestion_info(pc, type);

  case PACKET_CITY_SABOTAGE_LIST:
    return receive_packet_city_sabotage_list(pc, type);

  case PACKET_PLAYER_REMOVE:
    return receive_packet_player_remove(pc, type);

  case PACKET_PLAYER_INFO:
    return receive_packet_player_info(pc, type);

  case PACKET_PLAYER_PHASE_DONE:
    return receive_packet_player_phase_done(pc, type);

  case PACKET_PLAYER_RATES:
    return receive_packet_player_rates(pc, type);

  case PACKET_PLAYER_CHANGE_GOVERNMENT:
    return receive_packet_player_change_government(pc, type);

  case PACKET_PLAYER_RESEARCH:
    return receive_packet_player_research(pc, type);

  case PACKET_PLAYER_TECH_GOAL:
    return receive_packet_player_tech_goal(pc, type);

  case PACKET_PLAYER_ATTRIBUTE_BLOCK:
    return receive_packet_player_attribute_block(pc, type);

  case PACKET_PLAYER_ATTRIBUTE_CHUNK:
    return receive_packet_player_attribute_chunk(pc, type);

  case PACKET_PLAYER_DIPLSTATE:
    return receive_packet_player_diplstate(pc, type);

  case PACKET_UNIT_REMOVE:
    return receive_packet_unit_remove(pc, type);

  case PACKET_UNIT_INFO:
    return receive_packet_unit_info(pc, type);

  case PACKET_UNIT_SHORT_INFO:
    return receive_packet_unit_short_info(pc, type);

  case PACKET_UNIT_COMBAT_INFO:
    return receive_packet_unit_combat_info(pc, type);

  case PACKET_UNIT_MOVE:
    return receive_packet_unit_move(pc, type);

  case PACKET_UNIT_BUILD_CITY:
    return receive_packet_unit_build_city(pc, type);

  case PACKET_UNIT_DISBAND:
    return receive_packet_unit_disband(pc, type);

  case PACKET_UNIT_CHANGE_HOMECITY:
    return receive_packet_unit_change_homecity(pc, type);

  case PACKET_UNIT_ESTABLISH_TRADE:
    return receive_packet_unit_establish_trade(pc, type);

  case PACKET_UNIT_BATTLEGROUP:
    return receive_packet_unit_battlegroup(pc, type);

  case PACKET_UNIT_HELP_BUILD_WONDER:
    return receive_packet_unit_help_build_wonder(pc, type);

  case PACKET_UNIT_ORDERS:
    return receive_packet_unit_orders(pc, type);

  case PACKET_UNIT_AUTOSETTLERS:
    return receive_packet_unit_autosettlers(pc, type);

  case PACKET_UNIT_LOAD:
    return receive_packet_unit_load(pc, type);

  case PACKET_UNIT_UNLOAD:
    return receive_packet_unit_unload(pc, type);

  case PACKET_UNIT_UPGRADE:
    return receive_packet_unit_upgrade(pc, type);

  case PACKET_UNIT_CONVERT:
    return receive_packet_unit_convert(pc, type);

  case PACKET_UNIT_NUKE:
    return receive_packet_unit_nuke(pc, type);

  case PACKET_UNIT_PARADROP_TO:
    return receive_packet_unit_paradrop_to(pc, type);

  case PACKET_UNIT_AIRLIFT:
    return receive_packet_unit_airlift(pc, type);

  case PACKET_UNIT_DIPLOMAT_QUERY:
    return receive_packet_unit_diplomat_query(pc, type);

  case PACKET_UNIT_TYPE_UPGRADE:
    return receive_packet_unit_type_upgrade(pc, type);

  case PACKET_UNIT_DIPLOMAT_ACTION:
    return receive_packet_unit_diplomat_action(pc, type);

  case PACKET_UNIT_DIPLOMAT_ANSWER:
    return receive_packet_unit_diplomat_answer(pc, type);

  case PACKET_UNIT_CHANGE_ACTIVITY:
    return receive_packet_unit_change_activity(pc, type);

  case PACKET_DIPLOMACY_INIT_MEETING_REQ:
    return receive_packet_diplomacy_init_meeting_req(pc, type);

  case PACKET_DIPLOMACY_INIT_MEETING:
    return receive_packet_diplomacy_init_meeting(pc, type);

  case PACKET_DIPLOMACY_CANCEL_MEETING_REQ:
    return receive_packet_diplomacy_cancel_meeting_req(pc, type);

  case PACKET_DIPLOMACY_CANCEL_MEETING:
    return receive_packet_diplomacy_cancel_meeting(pc, type);

  case PACKET_DIPLOMACY_CREATE_CLAUSE_REQ:
    return receive_packet_diplomacy_create_clause_req(pc, type);

  case PACKET_DIPLOMACY_CREATE_CLAUSE:
    return receive_packet_diplomacy_create_clause(pc, type);

  case PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ:
    return receive_packet_diplomacy_remove_clause_req(pc, type);

  case PACKET_DIPLOMACY_REMOVE_CLAUSE:
    return receive_packet_diplomacy_remove_clause(pc, type);

  case PACKET_DIPLOMACY_ACCEPT_TREATY_REQ:
    return receive_packet_diplomacy_accept_treaty_req(pc, type);

  case PACKET_DIPLOMACY_ACCEPT_TREATY:
    return receive_packet_diplomacy_accept_treaty(pc, type);

  case PACKET_DIPLOMACY_CANCEL_PACT:
    return receive_packet_diplomacy_cancel_pact(pc, type);

  case PACKET_PAGE_MSG:
    return receive_packet_page_msg(pc, type);

  case PACKET_REPORT_REQ:
    return receive_packet_report_req(pc, type);

  case PACKET_CONN_INFO:
    return receive_packet_conn_info(pc, type);

  case PACKET_CONN_PING_INFO:
    return receive_packet_conn_ping_info(pc, type);

  case PACKET_CONN_PING:
    return receive_packet_conn_ping(pc, type);

  case PACKET_CONN_PONG:
    return receive_packet_conn_pong(pc, type);

  case PACKET_CLIENT_INFO:
    return receive_packet_client_info(pc, type);

  case PACKET_END_PHASE:
    return receive_packet_end_phase(pc, type);

  case PACKET_START_PHASE:
    return receive_packet_start_phase(pc, type);

  case PACKET_NEW_YEAR:
    return receive_packet_new_year(pc, type);

  case PACKET_BEGIN_TURN:
    return receive_packet_begin_turn(pc, type);

  case PACKET_END_TURN:
    return receive_packet_end_turn(pc, type);

  case PACKET_FREEZE_CLIENT:
    return receive_packet_freeze_client(pc, type);

  case PACKET_THAW_CLIENT:
    return receive_packet_thaw_client(pc, type);

  case PACKET_SPACESHIP_LAUNCH:
    return receive_packet_spaceship_launch(pc, type);

  case PACKET_SPACESHIP_PLACE:
    return receive_packet_spaceship_place(pc, type);

  case PACKET_SPACESHIP_INFO:
    return receive_packet_spaceship_info(pc, type);

  case PACKET_RULESET_UNIT:
    return receive_packet_ruleset_unit(pc, type);

  case PACKET_RULESET_GAME:
    return receive_packet_ruleset_game(pc, type);

  case PACKET_RULESET_SPECIALIST:
    return receive_packet_ruleset_specialist(pc, type);

  case PACKET_RULESET_GOVERNMENT_RULER_TITLE:
    return receive_packet_ruleset_government_ruler_title(pc, type);

  case PACKET_RULESET_TECH:
    return receive_packet_ruleset_tech(pc, type);

  case PACKET_RULESET_GOVERNMENT:
    return receive_packet_ruleset_government(pc, type);

  case PACKET_RULESET_TERRAIN_CONTROL:
    return receive_packet_ruleset_terrain_control(pc, type);

  case PACKET_RULESETS_READY:
    return receive_packet_rulesets_ready(pc, type);

  case PACKET_RULESET_NATION_GROUPS:
    return receive_packet_ruleset_nation_groups(pc, type);

  case PACKET_RULESET_NATION:
    return receive_packet_ruleset_nation(pc, type);

  case PACKET_RULESET_CITY:
    return receive_packet_ruleset_city(pc, type);

  case PACKET_RULESET_BUILDING:
    return receive_packet_ruleset_building(pc, type);

  case PACKET_RULESET_TERRAIN:
    return receive_packet_ruleset_terrain(pc, type);

  case PACKET_RULESET_UNIT_CLASS:
    return receive_packet_ruleset_unit_class(pc, type);

  case PACKET_RULESET_BASE:
    return receive_packet_ruleset_base(pc, type);

  case PACKET_RULESET_CONTROL:
    return receive_packet_ruleset_control(pc, type);

  case PACKET_SINGLE_WANT_HACK_REQ:
    return receive_packet_single_want_hack_req(pc, type);

  case PACKET_SINGLE_WANT_HACK_REPLY:
    return receive_packet_single_want_hack_reply(pc, type);

  case PACKET_RULESET_CHOICES:
    return receive_packet_ruleset_choices(pc, type);

  case PACKET_GAME_LOAD:
    return receive_packet_game_load(pc, type);

  case PACKET_SERVER_SETTING_CONTROL:
    return receive_packet_server_setting_control(pc, type);

  case PACKET_SERVER_SETTING_CONST:
    return receive_packet_server_setting_const(pc, type);

  case PACKET_SERVER_SETTING_BOOL:
    return receive_packet_server_setting_bool(pc, type);

  case PACKET_SERVER_SETTING_INT:
    return receive_packet_server_setting_int(pc, type);

  case PACKET_SERVER_SETTING_STR:
    return receive_packet_server_setting_str(pc, type);

  case PACKET_SERVER_SETTING_ENUM:
    return receive_packet_server_setting_enum(pc, type);

  case PACKET_SERVER_SETTING_BITWISE:
    return receive_packet_server_setting_bitwise(pc, type);

  case PACKET_RULESET_EFFECT:
    return receive_packet_ruleset_effect(pc, type);

  case PACKET_RULESET_EFFECT_REQ:
    return receive_packet_ruleset_effect_req(pc, type);

  case PACKET_RULESET_RESOURCE:
    return receive_packet_ruleset_resource(pc, type);

  case PACKET_SCENARIO_INFO:
    return receive_packet_scenario_info(pc, type);

  case PACKET_SAVE_SCENARIO:
    return receive_packet_save_scenario(pc, type);

  case PACKET_VOTE_NEW:
    return receive_packet_vote_new(pc, type);

  case PACKET_VOTE_UPDATE:
    return receive_packet_vote_update(pc, type);

  case PACKET_VOTE_REMOVE:
    return receive_packet_vote_remove(pc, type);

  case PACKET_VOTE_RESOLVE:
    return receive_packet_vote_resolve(pc, type);

  case PACKET_VOTE_SUBMIT:
    return receive_packet_vote_submit(pc, type);

  case PACKET_EDIT_MODE:
    return receive_packet_edit_mode(pc, type);

  case PACKET_EDIT_RECALCULATE_BORDERS:
    return receive_packet_edit_recalculate_borders(pc, type);

  case PACKET_EDIT_CHECK_TILES:
    return receive_packet_edit_check_tiles(pc, type);

  case PACKET_EDIT_TOGGLE_FOGOFWAR:
    return receive_packet_edit_toggle_fogofwar(pc, type);

  case PACKET_EDIT_TILE_TERRAIN:
    return receive_packet_edit_tile_terrain(pc, type);

  case PACKET_EDIT_TILE_RESOURCE:
    return receive_packet_edit_tile_resource(pc, type);

  case PACKET_EDIT_TILE_SPECIAL:
    return receive_packet_edit_tile_special(pc, type);

  case PACKET_EDIT_TILE_BASE:
    return receive_packet_edit_tile_base(pc, type);

  case PACKET_EDIT_STARTPOS:
    return receive_packet_edit_startpos(pc, type);

  case PACKET_EDIT_STARTPOS_FULL:
    return receive_packet_edit_startpos_full(pc, type);

  case PACKET_EDIT_TILE:
    return receive_packet_edit_tile(pc, type);

  case PACKET_EDIT_UNIT_CREATE:
    return receive_packet_edit_unit_create(pc, type);

  case PACKET_EDIT_UNIT_REMOVE:
    return receive_packet_edit_unit_remove(pc, type);

  case PACKET_EDIT_UNIT_REMOVE_BY_ID:
    return receive_packet_edit_unit_remove_by_id(pc, type);

  case PACKET_EDIT_UNIT:
    return receive_packet_edit_unit(pc, type);

  case PACKET_EDIT_CITY_CREATE:
    return receive_packet_edit_city_create(pc, type);

  case PACKET_EDIT_CITY_REMOVE:
    return receive_packet_edit_city_remove(pc, type);

  case PACKET_EDIT_CITY:
    return receive_packet_edit_city(pc, type);

  case PACKET_EDIT_PLAYER_CREATE:
    return receive_packet_edit_player_create(pc, type);

  case PACKET_EDIT_PLAYER_REMOVE:
    return receive_packet_edit_player_remove(pc, type);

  case PACKET_EDIT_PLAYER:
    return receive_packet_edit_player(pc, type);

  case PACKET_EDIT_PLAYER_VISION:
    return receive_packet_edit_player_vision(pc, type);

  case PACKET_EDIT_GAME:
    return receive_packet_edit_game(pc, type);

  case PACKET_EDIT_OBJECT_CREATED:
    return receive_packet_edit_object_created(pc, type);

  default:
    log_error("unknown packet type %d received from %s",
              type, conn_description(pc));
    remove_packet_from_buffer(pc->buffer);
    return NULL;
  };
}

const char *packet_name(enum packet_type type)
{
  switch (type) {

  case PACKET_PROCESSING_STARTED:
    return "PACKET_PROCESSING_STARTED";

  case PACKET_PROCESSING_FINISHED:
    return "PACKET_PROCESSING_FINISHED";

  case PACKET_SERVER_JOIN_REQ:
    return "PACKET_SERVER_JOIN_REQ";

  case PACKET_SERVER_JOIN_REPLY:
    return "PACKET_SERVER_JOIN_REPLY";

  case PACKET_AUTHENTICATION_REQ:
    return "PACKET_AUTHENTICATION_REQ";

  case PACKET_AUTHENTICATION_REPLY:
    return "PACKET_AUTHENTICATION_REPLY";

  case PACKET_SERVER_SHUTDOWN:
    return "PACKET_SERVER_SHUTDOWN";

  case PACKET_NATION_SELECT_REQ:
    return "PACKET_NATION_SELECT_REQ";

  case PACKET_PLAYER_READY:
    return "PACKET_PLAYER_READY";

  case PACKET_ENDGAME_REPORT:
    return "PACKET_ENDGAME_REPORT";

  case PACKET_ENDGAME_PLAYER:
    return "PACKET_ENDGAME_PLAYER";

  case PACKET_TILE_INFO:
    return "PACKET_TILE_INFO";

  case PACKET_GAME_INFO:
    return "PACKET_GAME_INFO";

  case PACKET_MAP_INFO:
    return "PACKET_MAP_INFO";

  case PACKET_NUKE_TILE_INFO:
    return "PACKET_NUKE_TILE_INFO";

  case PACKET_TEAM_NAME_INFO:
    return "PACKET_TEAM_NAME_INFO";

  case PACKET_CHAT_MSG:
    return "PACKET_CHAT_MSG";

  case PACKET_CHAT_MSG_REQ:
    return "PACKET_CHAT_MSG_REQ";

  case PACKET_CONNECT_MSG:
    return "PACKET_CONNECT_MSG";

  case PACKET_CITY_REMOVE:
    return "PACKET_CITY_REMOVE";

  case PACKET_CITY_INFO:
    return "PACKET_CITY_INFO";

  case PACKET_CITY_SHORT_INFO:
    return "PACKET_CITY_SHORT_INFO";

  case PACKET_CITY_SELL:
    return "PACKET_CITY_SELL";

  case PACKET_CITY_BUY:
    return "PACKET_CITY_BUY";

  case PACKET_CITY_CHANGE:
    return "PACKET_CITY_CHANGE";

  case PACKET_CITY_WORKLIST:
    return "PACKET_CITY_WORKLIST";

  case PACKET_CITY_MAKE_SPECIALIST:
    return "PACKET_CITY_MAKE_SPECIALIST";

  case PACKET_CITY_MAKE_WORKER:
    return "PACKET_CITY_MAKE_WORKER";

  case PACKET_CITY_CHANGE_SPECIALIST:
    return "PACKET_CITY_CHANGE_SPECIALIST";

  case PACKET_CITY_RENAME:
    return "PACKET_CITY_RENAME";

  case PACKET_CITY_OPTIONS_REQ:
    return "PACKET_CITY_OPTIONS_REQ";

  case PACKET_CITY_REFRESH:
    return "PACKET_CITY_REFRESH";

  case PACKET_CITY_NAME_SUGGESTION_REQ:
    return "PACKET_CITY_NAME_SUGGESTION_REQ";

  case PACKET_CITY_NAME_SUGGESTION_INFO:
    return "PACKET_CITY_NAME_SUGGESTION_INFO";

  case PACKET_CITY_SABOTAGE_LIST:
    return "PACKET_CITY_SABOTAGE_LIST";

  case PACKET_PLAYER_REMOVE:
    return "PACKET_PLAYER_REMOVE";

  case PACKET_PLAYER_INFO:
    return "PACKET_PLAYER_INFO";

  case PACKET_PLAYER_PHASE_DONE:
    return "PACKET_PLAYER_PHASE_DONE";

  case PACKET_PLAYER_RATES:
    return "PACKET_PLAYER_RATES";

  case PACKET_PLAYER_CHANGE_GOVERNMENT:
    return "PACKET_PLAYER_CHANGE_GOVERNMENT";

  case PACKET_PLAYER_RESEARCH:
    return "PACKET_PLAYER_RESEARCH";

  case PACKET_PLAYER_TECH_GOAL:
    return "PACKET_PLAYER_TECH_GOAL";

  case PACKET_PLAYER_ATTRIBUTE_BLOCK:
    return "PACKET_PLAYER_ATTRIBUTE_BLOCK";

  case PACKET_PLAYER_ATTRIBUTE_CHUNK:
    return "PACKET_PLAYER_ATTRIBUTE_CHUNK";

  case PACKET_PLAYER_DIPLSTATE:
    return "PACKET_PLAYER_DIPLSTATE";

  case PACKET_UNIT_REMOVE:
    return "PACKET_UNIT_REMOVE";

  case PACKET_UNIT_INFO:
    return "PACKET_UNIT_INFO";

  case PACKET_UNIT_SHORT_INFO:
    return "PACKET_UNIT_SHORT_INFO";

  case PACKET_UNIT_COMBAT_INFO:
    return "PACKET_UNIT_COMBAT_INFO";

  case PACKET_UNIT_MOVE:
    return "PACKET_UNIT_MOVE";

  case PACKET_UNIT_BUILD_CITY:
    return "PACKET_UNIT_BUILD_CITY";

  case PACKET_UNIT_DISBAND:
    return "PACKET_UNIT_DISBAND";

  case PACKET_UNIT_CHANGE_HOMECITY:
    return "PACKET_UNIT_CHANGE_HOMECITY";

  case PACKET_UNIT_ESTABLISH_TRADE:
    return "PACKET_UNIT_ESTABLISH_TRADE";

  case PACKET_UNIT_BATTLEGROUP:
    return "PACKET_UNIT_BATTLEGROUP";

  case PACKET_UNIT_HELP_BUILD_WONDER:
    return "PACKET_UNIT_HELP_BUILD_WONDER";

  case PACKET_UNIT_ORDERS:
    return "PACKET_UNIT_ORDERS";

  case PACKET_UNIT_AUTOSETTLERS:
    return "PACKET_UNIT_AUTOSETTLERS";

  case PACKET_UNIT_LOAD:
    return "PACKET_UNIT_LOAD";

  case PACKET_UNIT_UNLOAD:
    return "PACKET_UNIT_UNLOAD";

  case PACKET_UNIT_UPGRADE:
    return "PACKET_UNIT_UPGRADE";

  case PACKET_UNIT_CONVERT:
    return "PACKET_UNIT_CONVERT";

  case PACKET_UNIT_NUKE:
    return "PACKET_UNIT_NUKE";

  case PACKET_UNIT_PARADROP_TO:
    return "PACKET_UNIT_PARADROP_TO";

  case PACKET_UNIT_AIRLIFT:
    return "PACKET_UNIT_AIRLIFT";

  case PACKET_UNIT_DIPLOMAT_QUERY:
    return "PACKET_UNIT_DIPLOMAT_QUERY";

  case PACKET_UNIT_TYPE_UPGRADE:
    return "PACKET_UNIT_TYPE_UPGRADE";

  case PACKET_UNIT_DIPLOMAT_ACTION:
    return "PACKET_UNIT_DIPLOMAT_ACTION";

  case PACKET_UNIT_DIPLOMAT_ANSWER:
    return "PACKET_UNIT_DIPLOMAT_ANSWER";

  case PACKET_UNIT_CHANGE_ACTIVITY:
    return "PACKET_UNIT_CHANGE_ACTIVITY";

  case PACKET_DIPLOMACY_INIT_MEETING_REQ:
    return "PACKET_DIPLOMACY_INIT_MEETING_REQ";

  case PACKET_DIPLOMACY_INIT_MEETING:
    return "PACKET_DIPLOMACY_INIT_MEETING";

  case PACKET_DIPLOMACY_CANCEL_MEETING_REQ:
    return "PACKET_DIPLOMACY_CANCEL_MEETING_REQ";

  case PACKET_DIPLOMACY_CANCEL_MEETING:
    return "PACKET_DIPLOMACY_CANCEL_MEETING";

  case PACKET_DIPLOMACY_CREATE_CLAUSE_REQ:
    return "PACKET_DIPLOMACY_CREATE_CLAUSE_REQ";

  case PACKET_DIPLOMACY_CREATE_CLAUSE:
    return "PACKET_DIPLOMACY_CREATE_CLAUSE";

  case PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ:
    return "PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ";

  case PACKET_DIPLOMACY_REMOVE_CLAUSE:
    return "PACKET_DIPLOMACY_REMOVE_CLAUSE";

  case PACKET_DIPLOMACY_ACCEPT_TREATY_REQ:
    return "PACKET_DIPLOMACY_ACCEPT_TREATY_REQ";

  case PACKET_DIPLOMACY_ACCEPT_TREATY:
    return "PACKET_DIPLOMACY_ACCEPT_TREATY";

  case PACKET_DIPLOMACY_CANCEL_PACT:
    return "PACKET_DIPLOMACY_CANCEL_PACT";

  case PACKET_PAGE_MSG:
    return "PACKET_PAGE_MSG";

  case PACKET_REPORT_REQ:
    return "PACKET_REPORT_REQ";

  case PACKET_CONN_INFO:
    return "PACKET_CONN_INFO";

  case PACKET_CONN_PING_INFO:
    return "PACKET_CONN_PING_INFO";

  case PACKET_CONN_PING:
    return "PACKET_CONN_PING";

  case PACKET_CONN_PONG:
    return "PACKET_CONN_PONG";

  case PACKET_CLIENT_INFO:
    return "PACKET_CLIENT_INFO";

  case PACKET_END_PHASE:
    return "PACKET_END_PHASE";

  case PACKET_START_PHASE:
    return "PACKET_START_PHASE";

  case PACKET_NEW_YEAR:
    return "PACKET_NEW_YEAR";

  case PACKET_BEGIN_TURN:
    return "PACKET_BEGIN_TURN";

  case PACKET_END_TURN:
    return "PACKET_END_TURN";

  case PACKET_FREEZE_CLIENT:
    return "PACKET_FREEZE_CLIENT";

  case PACKET_THAW_CLIENT:
    return "PACKET_THAW_CLIENT";

  case PACKET_SPACESHIP_LAUNCH:
    return "PACKET_SPACESHIP_LAUNCH";

  case PACKET_SPACESHIP_PLACE:
    return "PACKET_SPACESHIP_PLACE";

  case PACKET_SPACESHIP_INFO:
    return "PACKET_SPACESHIP_INFO";

  case PACKET_RULESET_UNIT:
    return "PACKET_RULESET_UNIT";

  case PACKET_RULESET_GAME:
    return "PACKET_RULESET_GAME";

  case PACKET_RULESET_SPECIALIST:
    return "PACKET_RULESET_SPECIALIST";

  case PACKET_RULESET_GOVERNMENT_RULER_TITLE:
    return "PACKET_RULESET_GOVERNMENT_RULER_TITLE";

  case PACKET_RULESET_TECH:
    return "PACKET_RULESET_TECH";

  case PACKET_RULESET_GOVERNMENT:
    return "PACKET_RULESET_GOVERNMENT";

  case PACKET_RULESET_TERRAIN_CONTROL:
    return "PACKET_RULESET_TERRAIN_CONTROL";

  case PACKET_RULESETS_READY:
    return "PACKET_RULESETS_READY";

  case PACKET_RULESET_NATION_GROUPS:
    return "PACKET_RULESET_NATION_GROUPS";

  case PACKET_RULESET_NATION:
    return "PACKET_RULESET_NATION";

  case PACKET_RULESET_CITY:
    return "PACKET_RULESET_CITY";

  case PACKET_RULESET_BUILDING:
    return "PACKET_RULESET_BUILDING";

  case PACKET_RULESET_TERRAIN:
    return "PACKET_RULESET_TERRAIN";

  case PACKET_RULESET_UNIT_CLASS:
    return "PACKET_RULESET_UNIT_CLASS";

  case PACKET_RULESET_BASE:
    return "PACKET_RULESET_BASE";

  case PACKET_RULESET_CONTROL:
    return "PACKET_RULESET_CONTROL";

  case PACKET_SINGLE_WANT_HACK_REQ:
    return "PACKET_SINGLE_WANT_HACK_REQ";

  case PACKET_SINGLE_WANT_HACK_REPLY:
    return "PACKET_SINGLE_WANT_HACK_REPLY";

  case PACKET_RULESET_CHOICES:
    return "PACKET_RULESET_CHOICES";

  case PACKET_GAME_LOAD:
    return "PACKET_GAME_LOAD";

  case PACKET_SERVER_SETTING_CONTROL:
    return "PACKET_SERVER_SETTING_CONTROL";

  case PACKET_SERVER_SETTING_CONST:
    return "PACKET_SERVER_SETTING_CONST";

  case PACKET_SERVER_SETTING_BOOL:
    return "PACKET_SERVER_SETTING_BOOL";

  case PACKET_SERVER_SETTING_INT:
    return "PACKET_SERVER_SETTING_INT";

  case PACKET_SERVER_SETTING_STR:
    return "PACKET_SERVER_SETTING_STR";

  case PACKET_SERVER_SETTING_ENUM:
    return "PACKET_SERVER_SETTING_ENUM";

  case PACKET_SERVER_SETTING_BITWISE:
    return "PACKET_SERVER_SETTING_BITWISE";

  case PACKET_RULESET_EFFECT:
    return "PACKET_RULESET_EFFECT";

  case PACKET_RULESET_EFFECT_REQ:
    return "PACKET_RULESET_EFFECT_REQ";

  case PACKET_RULESET_RESOURCE:
    return "PACKET_RULESET_RESOURCE";

  case PACKET_SCENARIO_INFO:
    return "PACKET_SCENARIO_INFO";

  case PACKET_SAVE_SCENARIO:
    return "PACKET_SAVE_SCENARIO";

  case PACKET_VOTE_NEW:
    return "PACKET_VOTE_NEW";

  case PACKET_VOTE_UPDATE:
    return "PACKET_VOTE_UPDATE";

  case PACKET_VOTE_REMOVE:
    return "PACKET_VOTE_REMOVE";

  case PACKET_VOTE_RESOLVE:
    return "PACKET_VOTE_RESOLVE";

  case PACKET_VOTE_SUBMIT:
    return "PACKET_VOTE_SUBMIT";

  case PACKET_EDIT_MODE:
    return "PACKET_EDIT_MODE";

  case PACKET_EDIT_RECALCULATE_BORDERS:
    return "PACKET_EDIT_RECALCULATE_BORDERS";

  case PACKET_EDIT_CHECK_TILES:
    return "PACKET_EDIT_CHECK_TILES";

  case PACKET_EDIT_TOGGLE_FOGOFWAR:
    return "PACKET_EDIT_TOGGLE_FOGOFWAR";

  case PACKET_EDIT_TILE_TERRAIN:
    return "PACKET_EDIT_TILE_TERRAIN";

  case PACKET_EDIT_TILE_RESOURCE:
    return "PACKET_EDIT_TILE_RESOURCE";

  case PACKET_EDIT_TILE_SPECIAL:
    return "PACKET_EDIT_TILE_SPECIAL";

  case PACKET_EDIT_TILE_BASE:
    return "PACKET_EDIT_TILE_BASE";

  case PACKET_EDIT_STARTPOS:
    return "PACKET_EDIT_STARTPOS";

  case PACKET_EDIT_STARTPOS_FULL:
    return "PACKET_EDIT_STARTPOS_FULL";

  case PACKET_EDIT_TILE:
    return "PACKET_EDIT_TILE";

  case PACKET_EDIT_UNIT_CREATE:
    return "PACKET_EDIT_UNIT_CREATE";

  case PACKET_EDIT_UNIT_REMOVE:
    return "PACKET_EDIT_UNIT_REMOVE";

  case PACKET_EDIT_UNIT_REMOVE_BY_ID:
    return "PACKET_EDIT_UNIT_REMOVE_BY_ID";

  case PACKET_EDIT_UNIT:
    return "PACKET_EDIT_UNIT";

  case PACKET_EDIT_CITY_CREATE:
    return "PACKET_EDIT_CITY_CREATE";

  case PACKET_EDIT_CITY_REMOVE:
    return "PACKET_EDIT_CITY_REMOVE";

  case PACKET_EDIT_CITY:
    return "PACKET_EDIT_CITY";

  case PACKET_EDIT_PLAYER_CREATE:
    return "PACKET_EDIT_PLAYER_CREATE";

  case PACKET_EDIT_PLAYER_REMOVE:
    return "PACKET_EDIT_PLAYER_REMOVE";

  case PACKET_EDIT_PLAYER:
    return "PACKET_EDIT_PLAYER";

  case PACKET_EDIT_PLAYER_VISION:
    return "PACKET_EDIT_PLAYER_VISION";

  case PACKET_EDIT_GAME:
    return "PACKET_EDIT_GAME";

  case PACKET_EDIT_OBJECT_CREATED:
    return "PACKET_EDIT_OBJECT_CREATED";

  default:
    return "unknown";
  }
}

bool packet_has_game_info_flag(enum packet_type type)
{
  switch (type) {

  case PACKET_PROCESSING_STARTED:
    return FALSE;

  case PACKET_PROCESSING_FINISHED:
    return FALSE;

  case PACKET_SERVER_JOIN_REQ:
    return FALSE;

  case PACKET_SERVER_JOIN_REPLY:
    return FALSE;

  case PACKET_AUTHENTICATION_REQ:
    return FALSE;

  case PACKET_AUTHENTICATION_REPLY:
    return FALSE;

  case PACKET_SERVER_SHUTDOWN:
    return FALSE;

  case PACKET_NATION_SELECT_REQ:
    return FALSE;

  case PACKET_PLAYER_READY:
    return FALSE;

  case PACKET_ENDGAME_REPORT:
    return FALSE;

  case PACKET_ENDGAME_PLAYER:
    return FALSE;

  case PACKET_TILE_INFO:
    return TRUE;

  case PACKET_GAME_INFO:
    return FALSE;

  case PACKET_MAP_INFO:
    return FALSE;

  case PACKET_NUKE_TILE_INFO:
    return FALSE;

  case PACKET_TEAM_NAME_INFO:
    return FALSE;

  case PACKET_CHAT_MSG:
    return FALSE;

  case PACKET_CHAT_MSG_REQ:
    return FALSE;

  case PACKET_CONNECT_MSG:
    return FALSE;

  case PACKET_CITY_REMOVE:
    return FALSE;

  case PACKET_CITY_INFO:
    return TRUE;

  case PACKET_CITY_SHORT_INFO:
    return TRUE;

  case PACKET_CITY_SELL:
    return FALSE;

  case PACKET_CITY_BUY:
    return FALSE;

  case PACKET_CITY_CHANGE:
    return FALSE;

  case PACKET_CITY_WORKLIST:
    return FALSE;

  case PACKET_CITY_MAKE_SPECIALIST:
    return FALSE;

  case PACKET_CITY_MAKE_WORKER:
    return FALSE;

  case PACKET_CITY_CHANGE_SPECIALIST:
    return FALSE;

  case PACKET_CITY_RENAME:
    return FALSE;

  case PACKET_CITY_OPTIONS_REQ:
    return FALSE;

  case PACKET_CITY_REFRESH:
    return FALSE;

  case PACKET_CITY_NAME_SUGGESTION_REQ:
    return FALSE;

  case PACKET_CITY_NAME_SUGGESTION_INFO:
    return FALSE;

  case PACKET_CITY_SABOTAGE_LIST:
    return FALSE;

  case PACKET_PLAYER_REMOVE:
    return FALSE;

  case PACKET_PLAYER_INFO:
    return FALSE;

  case PACKET_PLAYER_PHASE_DONE:
    return FALSE;

  case PACKET_PLAYER_RATES:
    return FALSE;

  case PACKET_PLAYER_CHANGE_GOVERNMENT:
    return FALSE;

  case PACKET_PLAYER_RESEARCH:
    return FALSE;

  case PACKET_PLAYER_TECH_GOAL:
    return FALSE;

  case PACKET_PLAYER_ATTRIBUTE_BLOCK:
    return FALSE;

  case PACKET_PLAYER_ATTRIBUTE_CHUNK:
    return FALSE;

  case PACKET_PLAYER_DIPLSTATE:
    return FALSE;

  case PACKET_UNIT_REMOVE:
    return FALSE;

  case PACKET_UNIT_INFO:
    return TRUE;

  case PACKET_UNIT_SHORT_INFO:
    return TRUE;

  case PACKET_UNIT_COMBAT_INFO:
    return FALSE;

  case PACKET_UNIT_MOVE:
    return FALSE;

  case PACKET_UNIT_BUILD_CITY:
    return FALSE;

  case PACKET_UNIT_DISBAND:
    return FALSE;

  case PACKET_UNIT_CHANGE_HOMECITY:
    return FALSE;

  case PACKET_UNIT_ESTABLISH_TRADE:
    return FALSE;

  case PACKET_UNIT_BATTLEGROUP:
    return FALSE;

  case PACKET_UNIT_HELP_BUILD_WONDER:
    return FALSE;

  case PACKET_UNIT_ORDERS:
    return FALSE;

  case PACKET_UNIT_AUTOSETTLERS:
    return FALSE;

  case PACKET_UNIT_LOAD:
    return FALSE;

  case PACKET_UNIT_UNLOAD:
    return FALSE;

  case PACKET_UNIT_UPGRADE:
    return FALSE;

  case PACKET_UNIT_CONVERT:
    return FALSE;

  case PACKET_UNIT_NUKE:
    return FALSE;

  case PACKET_UNIT_PARADROP_TO:
    return FALSE;

  case PACKET_UNIT_AIRLIFT:
    return FALSE;

  case PACKET_UNIT_DIPLOMAT_QUERY:
    return FALSE;

  case PACKET_UNIT_TYPE_UPGRADE:
    return FALSE;

  case PACKET_UNIT_DIPLOMAT_ACTION:
    return FALSE;

  case PACKET_UNIT_DIPLOMAT_ANSWER:
    return FALSE;

  case PACKET_UNIT_CHANGE_ACTIVITY:
    return FALSE;

  case PACKET_DIPLOMACY_INIT_MEETING_REQ:
    return FALSE;

  case PACKET_DIPLOMACY_INIT_MEETING:
    return FALSE;

  case PACKET_DIPLOMACY_CANCEL_MEETING_REQ:
    return FALSE;

  case PACKET_DIPLOMACY_CANCEL_MEETING:
    return FALSE;

  case PACKET_DIPLOMACY_CREATE_CLAUSE_REQ:
    return FALSE;

  case PACKET_DIPLOMACY_CREATE_CLAUSE:
    return FALSE;

  case PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ:
    return FALSE;

  case PACKET_DIPLOMACY_REMOVE_CLAUSE:
    return FALSE;

  case PACKET_DIPLOMACY_ACCEPT_TREATY_REQ:
    return FALSE;

  case PACKET_DIPLOMACY_ACCEPT_TREATY:
    return FALSE;

  case PACKET_DIPLOMACY_CANCEL_PACT:
    return FALSE;

  case PACKET_PAGE_MSG:
    return FALSE;

  case PACKET_REPORT_REQ:
    return FALSE;

  case PACKET_CONN_INFO:
    return FALSE;

  case PACKET_CONN_PING_INFO:
    return FALSE;

  case PACKET_CONN_PING:
    return FALSE;

  case PACKET_CONN_PONG:
    return FALSE;

  case PACKET_CLIENT_INFO:
    return FALSE;

  case PACKET_END_PHASE:
    return FALSE;

  case PACKET_START_PHASE:
    return FALSE;

  case PACKET_NEW_YEAR:
    return FALSE;

  case PACKET_BEGIN_TURN:
    return FALSE;

  case PACKET_END_TURN:
    return FALSE;

  case PACKET_FREEZE_CLIENT:
    return FALSE;

  case PACKET_THAW_CLIENT:
    return FALSE;

  case PACKET_SPACESHIP_LAUNCH:
    return FALSE;

  case PACKET_SPACESHIP_PLACE:
    return FALSE;

  case PACKET_SPACESHIP_INFO:
    return FALSE;

  case PACKET_RULESET_UNIT:
    return FALSE;

  case PACKET_RULESET_GAME:
    return FALSE;

  case PACKET_RULESET_SPECIALIST:
    return FALSE;

  case PACKET_RULESET_GOVERNMENT_RULER_TITLE:
    return FALSE;

  case PACKET_RULESET_TECH:
    return FALSE;

  case PACKET_RULESET_GOVERNMENT:
    return FALSE;

  case PACKET_RULESET_TERRAIN_CONTROL:
    return FALSE;

  case PACKET_RULESETS_READY:
    return FALSE;

  case PACKET_RULESET_NATION_GROUPS:
    return FALSE;

  case PACKET_RULESET_NATION:
    return FALSE;

  case PACKET_RULESET_CITY:
    return FALSE;

  case PACKET_RULESET_BUILDING:
    return FALSE;

  case PACKET_RULESET_TERRAIN:
    return FALSE;

  case PACKET_RULESET_UNIT_CLASS:
    return FALSE;

  case PACKET_RULESET_BASE:
    return FALSE;

  case PACKET_RULESET_CONTROL:
    return FALSE;

  case PACKET_SINGLE_WANT_HACK_REQ:
    return FALSE;

  case PACKET_SINGLE_WANT_HACK_REPLY:
    return FALSE;

  case PACKET_RULESET_CHOICES:
    return FALSE;

  case PACKET_GAME_LOAD:
    return FALSE;

  case PACKET_SERVER_SETTING_CONTROL:
    return FALSE;

  case PACKET_SERVER_SETTING_CONST:
    return FALSE;

  case PACKET_SERVER_SETTING_BOOL:
    return FALSE;

  case PACKET_SERVER_SETTING_INT:
    return FALSE;

  case PACKET_SERVER_SETTING_STR:
    return FALSE;

  case PACKET_SERVER_SETTING_ENUM:
    return FALSE;

  case PACKET_SERVER_SETTING_BITWISE:
    return FALSE;

  case PACKET_RULESET_EFFECT:
    return FALSE;

  case PACKET_RULESET_EFFECT_REQ:
    return FALSE;

  case PACKET_RULESET_RESOURCE:
    return FALSE;

  case PACKET_SCENARIO_INFO:
    return FALSE;

  case PACKET_SAVE_SCENARIO:
    return FALSE;

  case PACKET_VOTE_NEW:
    return FALSE;

  case PACKET_VOTE_UPDATE:
    return FALSE;

  case PACKET_VOTE_REMOVE:
    return FALSE;

  case PACKET_VOTE_RESOLVE:
    return FALSE;

  case PACKET_VOTE_SUBMIT:
    return FALSE;

  case PACKET_EDIT_MODE:
    return FALSE;

  case PACKET_EDIT_RECALCULATE_BORDERS:
    return FALSE;

  case PACKET_EDIT_CHECK_TILES:
    return FALSE;

  case PACKET_EDIT_TOGGLE_FOGOFWAR:
    return FALSE;

  case PACKET_EDIT_TILE_TERRAIN:
    return FALSE;

  case PACKET_EDIT_TILE_RESOURCE:
    return FALSE;

  case PACKET_EDIT_TILE_SPECIAL:
    return FALSE;

  case PACKET_EDIT_TILE_BASE:
    return FALSE;

  case PACKET_EDIT_STARTPOS:
    return FALSE;

  case PACKET_EDIT_STARTPOS_FULL:
    return FALSE;

  case PACKET_EDIT_TILE:
    return FALSE;

  case PACKET_EDIT_UNIT_CREATE:
    return FALSE;

  case PACKET_EDIT_UNIT_REMOVE:
    return FALSE;

  case PACKET_EDIT_UNIT_REMOVE_BY_ID:
    return FALSE;

  case PACKET_EDIT_UNIT:
    return FALSE;

  case PACKET_EDIT_CITY_CREATE:
    return FALSE;

  case PACKET_EDIT_CITY_REMOVE:
    return FALSE;

  case PACKET_EDIT_CITY:
    return FALSE;

  case PACKET_EDIT_PLAYER_CREATE:
    return FALSE;

  case PACKET_EDIT_PLAYER_REMOVE:
    return FALSE;

  case PACKET_EDIT_PLAYER:
    return FALSE;

  case PACKET_EDIT_PLAYER_VISION:
    return FALSE;

  case PACKET_EDIT_GAME:
    return FALSE;

  case PACKET_EDIT_OBJECT_CREATED:
    return FALSE;

  default:
    return FALSE;
  }
}

static struct packet_processing_started *receive_packet_processing_started_100(struct connection *pc, enum packet_type type)
{
  RECEIVE_PACKET_START(packet_processing_started, real_packet);

  log_packet_detailed("packet_processing_started_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_processing_started_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_PROCESSING_STARTED);

  log_packet_detailed("packet_processing_started_100: sending info about ()");
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_processing_started(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_PROCESSING_STARTED] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_PROCESSING_STARTED variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_PROCESSING_STARTED] = variant;
}

struct packet_processing_started *receive_packet_processing_started(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_processing_started at the server.");
  }
  ensure_valid_variant_packet_processing_started(pc);

  switch(pc->phs.variant[PACKET_PROCESSING_STARTED]) {
  case 100:
    return receive_packet_processing_started_100(pc, type);
  default:
    log_debug("Unknown PACKET_PROCESSING_STARTED variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_processing_started(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_processing_started from the client.");
  }
  ensure_valid_variant_packet_processing_started(pc);

  switch(pc->phs.variant[PACKET_PROCESSING_STARTED]) {

  case 100:
    return send_packet_processing_started_100(pc);
  default:
    log_debug("Unknown PACKET_PROCESSING_STARTED variant for connection %s", conn_description(pc));
    return -1;
  }
}
static struct packet_processing_finished *receive_packet_processing_finished_100(struct connection *pc, enum packet_type type)
{
  RECEIVE_PACKET_START(packet_processing_finished, real_packet);

  log_packet_detailed("packet_processing_finished_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_processing_finished_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_PROCESSING_FINISHED);

  log_packet_detailed("packet_processing_finished_100: sending info about ()");
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_processing_finished(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_PROCESSING_FINISHED] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_PROCESSING_FINISHED variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_PROCESSING_FINISHED] = variant;
}

struct packet_processing_finished *receive_packet_processing_finished(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_processing_finished at the server.");
  }
  ensure_valid_variant_packet_processing_finished(pc);

  switch(pc->phs.variant[PACKET_PROCESSING_FINISHED]) {
  case 100:
    return receive_packet_processing_finished_100(pc, type);
  default:
    log_debug("Unknown PACKET_PROCESSING_FINISHED variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_processing_finished(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_processing_finished from the client.");
  }
  ensure_valid_variant_packet_processing_finished(pc);

  switch(pc->phs.variant[PACKET_PROCESSING_FINISHED]) {

  case 100:
    return send_packet_processing_finished_100(pc);
  default:
    log_debug("Unknown PACKET_PROCESSING_FINISHED variant for connection %s", conn_description(pc));
    return -1;
  }
}
static struct packet_server_join_req *receive_packet_server_join_req_100(struct connection *pc, enum packet_type type)
{
  RECEIVE_PACKET_START(packet_server_join_req, real_packet);
  dio_get_string(&din, real_packet->username, sizeof(real_packet->username));
  dio_get_string(&din, real_packet->capability, sizeof(real_packet->capability));
  dio_get_string(&din, real_packet->version_label, sizeof(real_packet->version_label));
  {
    int readin;
  
    dio_get_uint32(&din, &readin);
    real_packet->major_version = readin;
  }
  {
    int readin;
  
    dio_get_uint32(&din, &readin);
    real_packet->minor_version = readin;
  }
  {
    int readin;
  
    dio_get_uint32(&din, &readin);
    real_packet->patch_version = readin;
  }

  log_packet_detailed("packet_server_join_req_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_server_join_req_100(struct connection *pc, const struct packet_server_join_req *packet)
{
  const struct packet_server_join_req *real_packet = packet;
  SEND_PACKET_START(PACKET_SERVER_JOIN_REQ);

  log_packet_detailed("packet_server_join_req_100: sending info about ()");

  dio_put_string(&dout, real_packet->username);
  dio_put_string(&dout, real_packet->capability);
  dio_put_string(&dout, real_packet->version_label);
  dio_put_uint32(&dout, real_packet->major_version);
  dio_put_uint32(&dout, real_packet->minor_version);
  dio_put_uint32(&dout, real_packet->patch_version);

  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_server_join_req(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_SERVER_JOIN_REQ] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_SERVER_JOIN_REQ variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_SERVER_JOIN_REQ] = variant;
}

struct packet_server_join_req *receive_packet_server_join_req(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_server_join_req at the client.");
  }
  ensure_valid_variant_packet_server_join_req(pc);

  switch(pc->phs.variant[PACKET_SERVER_JOIN_REQ]) {
  case 100:
    return receive_packet_server_join_req_100(pc, type);
  default:
    log_debug("Unknown PACKET_SERVER_JOIN_REQ variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_server_join_req(struct connection *pc, const struct packet_server_join_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_server_join_req from the server.");
  }
  ensure_valid_variant_packet_server_join_req(pc);

  switch(pc->phs.variant[PACKET_SERVER_JOIN_REQ]) {

  case 100:
    return send_packet_server_join_req_100(pc, packet);
  default:
    log_debug("Unknown PACKET_SERVER_JOIN_REQ variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_server_join_req(struct connection *pc, const char *username, const char *capability, const char *version_label, int major_version, int minor_version, int patch_version)
{
  struct packet_server_join_req packet, *real_packet = &packet;

  sz_strlcpy(real_packet->username, username);
  sz_strlcpy(real_packet->capability, capability);
  sz_strlcpy(real_packet->version_label, version_label);
  real_packet->major_version = major_version;
  real_packet->minor_version = minor_version;
  real_packet->patch_version = patch_version;
  
  return send_packet_server_join_req(pc, real_packet);
}

static struct packet_server_join_reply *receive_packet_server_join_reply_100(struct connection *pc, enum packet_type type)
{
  RECEIVE_PACKET_START(packet_server_join_reply, real_packet);
  dio_get_bool8(&din, &real_packet->you_can_join);
  dio_get_string(&din, real_packet->message, sizeof(real_packet->message));
  dio_get_string(&din, real_packet->capability, sizeof(real_packet->capability));
  dio_get_string(&din, real_packet->challenge_file, sizeof(real_packet->challenge_file));
  {
    int readin;
  
    dio_get_sint16(&din, &readin);
    real_packet->conn_id = readin;
  }

  log_packet_detailed("packet_server_join_reply_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_server_join_reply_100(struct connection *pc, const struct packet_server_join_reply *packet)
{
  const struct packet_server_join_reply *real_packet = packet;
  SEND_PACKET_START(PACKET_SERVER_JOIN_REPLY);

  log_packet_detailed("packet_server_join_reply_100: sending info about ()");

  dio_put_bool8(&dout, real_packet->you_can_join);
  dio_put_string(&dout, real_packet->message);
  dio_put_string(&dout, real_packet->capability);
  dio_put_string(&dout, real_packet->challenge_file);
  dio_put_sint16(&dout, real_packet->conn_id);

  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_server_join_reply(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_SERVER_JOIN_REPLY] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_SERVER_JOIN_REPLY variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_SERVER_JOIN_REPLY] = variant;
}

struct packet_server_join_reply *receive_packet_server_join_reply(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_server_join_reply at the server.");
  }
  ensure_valid_variant_packet_server_join_reply(pc);

  switch(pc->phs.variant[PACKET_SERVER_JOIN_REPLY]) {
  case 100:
    return receive_packet_server_join_reply_100(pc, type);
  default:
    log_debug("Unknown PACKET_SERVER_JOIN_REPLY variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_server_join_reply(struct connection *pc, const struct packet_server_join_reply *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_server_join_reply from the client.");
  }
  ensure_valid_variant_packet_server_join_reply(pc);

  switch(pc->phs.variant[PACKET_SERVER_JOIN_REPLY]) {

  case 100:
    return send_packet_server_join_reply_100(pc, packet);
  default:
    log_debug("Unknown PACKET_SERVER_JOIN_REPLY variant for connection %s", conn_description(pc));
    return -1;
  }
}
#define hash_packet_authentication_req_100 hash_const

#define cmp_packet_authentication_req_100 cmp_const

BV_DEFINE(packet_authentication_req_100_fields, 2);

static struct packet_authentication_req *receive_packet_authentication_req_100(struct connection *pc, enum packet_type type)
{
  packet_authentication_req_100_fields fields;
  struct packet_authentication_req *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_authentication_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_authentication_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_authentication_req_100, cmp_packet_authentication_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'message'");
    dio_get_string(&din, real_packet->message, sizeof(real_packet->message));
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_authentication_req_100(struct connection *pc, const struct packet_authentication_req *packet)
{
  const struct packet_authentication_req *real_packet = packet;
  packet_authentication_req_100_fields fields;
  struct packet_authentication_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_AUTHENTICATION_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_AUTHENTICATION_REQ);

  log_packet_detailed("packet_authentication_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_authentication_req_100, cmp_packet_authentication_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->message, real_packet->message) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'type' has changed");
    dio_put_uint8(&dout, real_packet->type);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'message' has changed");
    dio_put_string(&dout, real_packet->message);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_authentication_req(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_AUTHENTICATION_REQ] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_AUTHENTICATION_REQ variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_AUTHENTICATION_REQ] = variant;
}

struct packet_authentication_req *receive_packet_authentication_req(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_authentication_req at the server.");
  }
  ensure_valid_variant_packet_authentication_req(pc);

  switch(pc->phs.variant[PACKET_AUTHENTICATION_REQ]) {
  case 100:
    return receive_packet_authentication_req_100(pc, type);
  default:
    log_debug("Unknown PACKET_AUTHENTICATION_REQ variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_authentication_req(struct connection *pc, const struct packet_authentication_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_authentication_req from the client.");
  }
  ensure_valid_variant_packet_authentication_req(pc);

  switch(pc->phs.variant[PACKET_AUTHENTICATION_REQ]) {

  case 100:
    return send_packet_authentication_req_100(pc, packet);
  default:
    log_debug("Unknown PACKET_AUTHENTICATION_REQ variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_authentication_req(struct connection *pc, enum authentication_type type, const char *message)
{
  struct packet_authentication_req packet, *real_packet = &packet;

  real_packet->type = type;
  sz_strlcpy(real_packet->message, message);
  
  return send_packet_authentication_req(pc, real_packet);
}

#define hash_packet_authentication_reply_100 hash_const

#define cmp_packet_authentication_reply_100 cmp_const

BV_DEFINE(packet_authentication_reply_100_fields, 1);

static struct packet_authentication_reply *receive_packet_authentication_reply_100(struct connection *pc, enum packet_type type)
{
  packet_authentication_reply_100_fields fields;
  struct packet_authentication_reply *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_authentication_reply, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_authentication_reply_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_authentication_reply_100, cmp_packet_authentication_reply_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'password'");
    dio_get_string(&din, real_packet->password, sizeof(real_packet->password));
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_authentication_reply_100(struct connection *pc, const struct packet_authentication_reply *packet)
{
  const struct packet_authentication_reply *real_packet = packet;
  packet_authentication_reply_100_fields fields;
  struct packet_authentication_reply *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_AUTHENTICATION_REPLY;
  int different = 0;
  SEND_PACKET_START(PACKET_AUTHENTICATION_REPLY);

  log_packet_detailed("packet_authentication_reply_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_authentication_reply_100, cmp_packet_authentication_reply_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->password, real_packet->password) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'password' has changed");
    dio_put_string(&dout, real_packet->password);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_authentication_reply(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_AUTHENTICATION_REPLY] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_AUTHENTICATION_REPLY variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_AUTHENTICATION_REPLY] = variant;
}

struct packet_authentication_reply *receive_packet_authentication_reply(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_authentication_reply at the client.");
  }
  ensure_valid_variant_packet_authentication_reply(pc);

  switch(pc->phs.variant[PACKET_AUTHENTICATION_REPLY]) {
  case 100:
    return receive_packet_authentication_reply_100(pc, type);
  default:
    log_debug("Unknown PACKET_AUTHENTICATION_REPLY variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_authentication_reply(struct connection *pc, const struct packet_authentication_reply *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_authentication_reply from the server.");
  }
  ensure_valid_variant_packet_authentication_reply(pc);

  switch(pc->phs.variant[PACKET_AUTHENTICATION_REPLY]) {

  case 100:
    return send_packet_authentication_reply_100(pc, packet);
  default:
    log_debug("Unknown PACKET_AUTHENTICATION_REPLY variant for connection %s", conn_description(pc));
    return -1;
  }
}
static struct packet_server_shutdown *receive_packet_server_shutdown_100(struct connection *pc, enum packet_type type)
{
  RECEIVE_PACKET_START(packet_server_shutdown, real_packet);

  log_packet_detailed("packet_server_shutdown_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_server_shutdown_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_SERVER_SHUTDOWN);

  log_packet_detailed("packet_server_shutdown_100: sending info about ()");
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_server_shutdown(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_SERVER_SHUTDOWN] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_SERVER_SHUTDOWN variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_SERVER_SHUTDOWN] = variant;
}

struct packet_server_shutdown *receive_packet_server_shutdown(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_server_shutdown at the server.");
  }
  ensure_valid_variant_packet_server_shutdown(pc);

  switch(pc->phs.variant[PACKET_SERVER_SHUTDOWN]) {
  case 100:
    return receive_packet_server_shutdown_100(pc, type);
  default:
    log_debug("Unknown PACKET_SERVER_SHUTDOWN variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_server_shutdown(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_server_shutdown from the client.");
  }
  ensure_valid_variant_packet_server_shutdown(pc);

  switch(pc->phs.variant[PACKET_SERVER_SHUTDOWN]) {

  case 100:
    return send_packet_server_shutdown_100(pc);
  default:
    log_debug("Unknown PACKET_SERVER_SHUTDOWN variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_server_shutdown(struct conn_list *dest)
{
  conn_list_iterate(dest, pconn) {
    send_packet_server_shutdown(pconn);
  } conn_list_iterate_end;
}

#define hash_packet_nation_select_req_100 hash_const

#define cmp_packet_nation_select_req_100 cmp_const

BV_DEFINE(packet_nation_select_req_100_fields, 5);

static struct packet_nation_select_req *receive_packet_nation_select_req_100(struct connection *pc, enum packet_type type)
{
  packet_nation_select_req_100_fields fields;
  struct packet_nation_select_req *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_nation_select_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_nation_select_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_nation_select_req_100, cmp_packet_nation_select_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'player_no'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->player_no = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'nation_no'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->nation_no = readin;
    }
  }
  real_packet->is_male = BV_ISSET(fields, 2);
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'name'");
    dio_get_string(&din, real_packet->name, sizeof(real_packet->name));
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'city_style'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->city_style = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_nation_select_req_100(struct connection *pc, const struct packet_nation_select_req *packet)
{
  const struct packet_nation_select_req *real_packet = packet;
  packet_nation_select_req_100_fields fields;
  struct packet_nation_select_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_NATION_SELECT_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_NATION_SELECT_REQ);

  log_packet_detailed("packet_nation_select_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_nation_select_req_100, cmp_packet_nation_select_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->player_no != real_packet->player_no);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->nation_no != real_packet->nation_no);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->is_male != real_packet->is_male);
  if(differ) {
    different++;
  }
  if (packet->is_male) {
    BV_SET(fields, 2);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->city_style != real_packet->city_style);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'player_no' has changed");
    dio_put_sint8(&dout, real_packet->player_no);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'nation_no' has changed");
    dio_put_sint16(&dout, real_packet->nation_no);
  }
  /* field 2 is folded into the header */
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'city_style' has changed");
    dio_put_uint8(&dout, real_packet->city_style);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_nation_select_req(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_NATION_SELECT_REQ] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_NATION_SELECT_REQ variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_NATION_SELECT_REQ] = variant;
}

struct packet_nation_select_req *receive_packet_nation_select_req(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_nation_select_req at the client.");
  }
  ensure_valid_variant_packet_nation_select_req(pc);

  switch(pc->phs.variant[PACKET_NATION_SELECT_REQ]) {
  case 100:
    return receive_packet_nation_select_req_100(pc, type);
  default:
    log_debug("Unknown PACKET_NATION_SELECT_REQ variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_nation_select_req(struct connection *pc, const struct packet_nation_select_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_nation_select_req from the server.");
  }
  ensure_valid_variant_packet_nation_select_req(pc);

  switch(pc->phs.variant[PACKET_NATION_SELECT_REQ]) {

  case 100:
    return send_packet_nation_select_req_100(pc, packet);
  default:
    log_debug("Unknown PACKET_NATION_SELECT_REQ variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_nation_select_req(struct connection *pc, int player_no, Nation_type_id nation_no, bool is_male, const char *name, int city_style)
{
  struct packet_nation_select_req packet, *real_packet = &packet;

  real_packet->player_no = player_no;
  real_packet->nation_no = nation_no;
  real_packet->is_male = is_male;
  sz_strlcpy(real_packet->name, name);
  real_packet->city_style = city_style;
  
  return send_packet_nation_select_req(pc, real_packet);
}

#define hash_packet_player_ready_100 hash_const

#define cmp_packet_player_ready_100 cmp_const

BV_DEFINE(packet_player_ready_100_fields, 2);

static struct packet_player_ready *receive_packet_player_ready_100(struct connection *pc, enum packet_type type)
{
  packet_player_ready_100_fields fields;
  struct packet_player_ready *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_player_ready, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_player_ready_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_ready_100, cmp_packet_player_ready_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'player_no'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->player_no = readin;
    }
  }
  real_packet->is_ready = BV_ISSET(fields, 1);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_ready_100(struct connection *pc, const struct packet_player_ready *packet)
{
  const struct packet_player_ready *real_packet = packet;
  packet_player_ready_100_fields fields;
  struct packet_player_ready *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_READY;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_READY);

  log_packet_detailed("packet_player_ready_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_ready_100, cmp_packet_player_ready_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->player_no != real_packet->player_no);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->is_ready != real_packet->is_ready);
  if(differ) {
    different++;
  }
  if (packet->is_ready) {
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'player_no' has changed");
    dio_put_sint8(&dout, real_packet->player_no);
  }
  /* field 1 is folded into the header */

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_player_ready(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_PLAYER_READY] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_PLAYER_READY variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_PLAYER_READY] = variant;
}

struct packet_player_ready *receive_packet_player_ready(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_player_ready at the client.");
  }
  ensure_valid_variant_packet_player_ready(pc);

  switch(pc->phs.variant[PACKET_PLAYER_READY]) {
  case 100:
    return receive_packet_player_ready_100(pc, type);
  default:
    log_debug("Unknown PACKET_PLAYER_READY variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_player_ready(struct connection *pc, const struct packet_player_ready *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_player_ready from the server.");
  }
  ensure_valid_variant_packet_player_ready(pc);

  switch(pc->phs.variant[PACKET_PLAYER_READY]) {

  case 100:
    return send_packet_player_ready_100(pc, packet);
  default:
    log_debug("Unknown PACKET_PLAYER_READY variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_player_ready(struct connection *pc, int player_no, bool is_ready)
{
  struct packet_player_ready packet, *real_packet = &packet;

  real_packet->player_no = player_no;
  real_packet->is_ready = is_ready;
  
  return send_packet_player_ready(pc, real_packet);
}

static struct packet_endgame_report *receive_packet_endgame_report_100(struct connection *pc, enum packet_type type)
{
  RECEIVE_PACKET_START(packet_endgame_report, real_packet);
  {
    int readin;
  
    dio_get_uint8(&din, &readin);
    real_packet->category_num = readin;
  }
  
  {
    int i;
  
    if(real_packet->category_num > 32) {
      log_error("packets_gen.c: WARNING: truncation array");
      real_packet->category_num = 32;
    }
    for (i = 0; i < real_packet->category_num; i++) {
      dio_get_string(&din, real_packet->category_name[i], sizeof(real_packet->category_name[i]));
    }
  }
  {
    int readin;
  
    dio_get_uint8(&din, &readin);
    real_packet->player_num = readin;
  }

  log_packet_detailed("packet_endgame_report_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_endgame_report_100(struct connection *pc, const struct packet_endgame_report *packet)
{
  const struct packet_endgame_report *real_packet = packet;
  SEND_PACKET_START(PACKET_ENDGAME_REPORT);

  log_packet_detailed("packet_endgame_report_100: sending info about ()");

  dio_put_uint8(&dout, real_packet->category_num);

    {
      int i;

      for (i = 0; i < real_packet->category_num; i++) {
        dio_put_string(&dout, real_packet->category_name[i]);
      }
    } 
  dio_put_uint8(&dout, real_packet->player_num);

  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_endgame_report(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_ENDGAME_REPORT] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_ENDGAME_REPORT variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_ENDGAME_REPORT] = variant;
}

struct packet_endgame_report *receive_packet_endgame_report(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_endgame_report at the server.");
  }
  ensure_valid_variant_packet_endgame_report(pc);

  switch(pc->phs.variant[PACKET_ENDGAME_REPORT]) {
  case 100:
    return receive_packet_endgame_report_100(pc, type);
  default:
    log_debug("Unknown PACKET_ENDGAME_REPORT variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_endgame_report(struct connection *pc, const struct packet_endgame_report *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_endgame_report from the client.");
  }
  ensure_valid_variant_packet_endgame_report(pc);

  switch(pc->phs.variant[PACKET_ENDGAME_REPORT]) {

  case 100:
    return send_packet_endgame_report_100(pc, packet);
  default:
    log_debug("Unknown PACKET_ENDGAME_REPORT variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_endgame_report(struct conn_list *dest, const struct packet_endgame_report *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_endgame_report(pconn, packet);
  } conn_list_iterate_end;
}

static struct packet_endgame_player *receive_packet_endgame_player_100(struct connection *pc, enum packet_type type)
{
  RECEIVE_PACKET_START(packet_endgame_player, real_packet);
  {
    int readin;
  
    dio_get_uint8(&din, &readin);
    real_packet->category_num = readin;
  }
  {
    int readin;
  
    dio_get_sint8(&din, &readin);
    real_packet->player_id = readin;
  }
  {
    int readin;
  
    dio_get_uint16(&din, &readin);
    real_packet->score = readin;
  }
  
  {
    int i;
  
    if(real_packet->category_num > 32) {
      log_error("packets_gen.c: WARNING: truncation array");
      real_packet->category_num = 32;
    }
    for (i = 0; i < real_packet->category_num; i++) {
      {
    int readin;
  
    dio_get_uint32(&din, &readin);
    real_packet->category_score[i] = readin;
  }
    }
  }

  log_packet_detailed("packet_endgame_player_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_endgame_player_100(struct connection *pc, const struct packet_endgame_player *packet)
{
  const struct packet_endgame_player *real_packet = packet;
  SEND_PACKET_START(PACKET_ENDGAME_PLAYER);

  log_packet_detailed("packet_endgame_player_100: sending info about ()");

  dio_put_uint8(&dout, real_packet->category_num);
  dio_put_sint8(&dout, real_packet->player_id);
  dio_put_uint16(&dout, real_packet->score);

    {
      int i;

      for (i = 0; i < real_packet->category_num; i++) {
        dio_put_uint32(&dout, real_packet->category_score[i]);
      }
    } 

  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_endgame_player(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_ENDGAME_PLAYER] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_ENDGAME_PLAYER variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_ENDGAME_PLAYER] = variant;
}

struct packet_endgame_player *receive_packet_endgame_player(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_endgame_player at the server.");
  }
  ensure_valid_variant_packet_endgame_player(pc);

  switch(pc->phs.variant[PACKET_ENDGAME_PLAYER]) {
  case 100:
    return receive_packet_endgame_player_100(pc, type);
  default:
    log_debug("Unknown PACKET_ENDGAME_PLAYER variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_endgame_player(struct connection *pc, const struct packet_endgame_player *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_endgame_player from the client.");
  }
  ensure_valid_variant_packet_endgame_player(pc);

  switch(pc->phs.variant[PACKET_ENDGAME_PLAYER]) {

  case 100:
    return send_packet_endgame_player_100(pc, packet);
  default:
    log_debug("Unknown PACKET_ENDGAME_PLAYER variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_endgame_player(struct conn_list *dest, const struct packet_endgame_player *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_endgame_player(pconn, packet);
  } conn_list_iterate_end;
}

static genhash_val_t hash_packet_tile_info_100(const void *vkey, size_t num_buckets)
{
  const struct packet_tile_info *key = (const struct packet_tile_info *) vkey;

  return ((key->tile) % num_buckets);
}

static bool cmp_packet_tile_info_100(const void *vkey1, const void *vkey2)
{
  const struct packet_tile_info *key1 = (const struct packet_tile_info *) vkey1;
  const struct packet_tile_info *key2 = (const struct packet_tile_info *) vkey2;

  return key1->tile == key2->tile;
}

BV_DEFINE(packet_tile_info_100_fields, 10);

static struct packet_tile_info *receive_packet_tile_info_100(struct connection *pc, enum packet_type type)
{
  packet_tile_info_100_fields fields;
  struct packet_tile_info *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_tile_info, real_packet);

  DIO_BV_GET(&din, fields);
  {
    int readin;
  
    dio_get_sint32(&din, &readin);
    real_packet->tile = readin;
  }

  log_packet_detailed("packet_tile_info_100: got info about (%d)",
    real_packet->tile);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_tile_info_100, cmp_packet_tile_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int tile = real_packet->tile;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->tile = tile;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'continent'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->continent = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'known'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->known = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'owner'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->owner = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'worked'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->worked = readin;
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'terrain'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->terrain = readin;
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'resource'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->resource = readin;
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'special'");
    
    {
      int i;
    
      for (i = 0; i < S_LAST; i++) {
        dio_get_bool8(&din, &real_packet->special[i]);
      }
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'bases'");
    DIO_BV_GET(&din, real_packet->bases);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'spec_sprite'");
    dio_get_string(&din, real_packet->spec_sprite, sizeof(real_packet->spec_sprite));
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'label'");
    dio_get_string(&din, real_packet->label, sizeof(real_packet->label));
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_tile_info_100(struct connection *pc, const struct packet_tile_info *packet)
{
  const struct packet_tile_info *real_packet = packet;
  packet_tile_info_100_fields fields;
  struct packet_tile_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_TILE_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_TILE_INFO);

  log_packet_detailed("packet_tile_info_100: sending info about (%d)",
    real_packet->tile);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_tile_info_100, cmp_packet_tile_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->continent != real_packet->continent);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->known != real_packet->known);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->owner != real_packet->owner);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->worked != real_packet->worked);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->terrain != real_packet->terrain);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->resource != real_packet->resource);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


    {
      differ = (S_LAST != S_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < S_LAST; i++) {
          if (old->special[i] != real_packet->special[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = !BV_ARE_EQUAL(old->bases, real_packet->bases);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (strcmp(old->spec_sprite, real_packet->spec_sprite) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (strcmp(old->label, real_packet->label) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, fields);
  dio_put_sint32(&dout, real_packet->tile);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'continent' has changed");
    dio_put_sint16(&dout, real_packet->continent);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'known' has changed");
    dio_put_uint8(&dout, real_packet->known);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'owner' has changed");
    dio_put_sint8(&dout, real_packet->owner);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'worked' has changed");
    dio_put_uint16(&dout, real_packet->worked);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'terrain' has changed");
    dio_put_uint8(&dout, real_packet->terrain);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'resource' has changed");
    dio_put_uint8(&dout, real_packet->resource);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'special' has changed");
  
    {
      int i;

      for (i = 0; i < S_LAST; i++) {
        dio_put_bool8(&dout, real_packet->special[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'bases' has changed");
  DIO_BV_PUT(&dout, packet->bases);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'spec_sprite' has changed");
    dio_put_string(&dout, real_packet->spec_sprite);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'label' has changed");
    dio_put_string(&dout, real_packet->label);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_tile_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_TILE_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_TILE_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_TILE_INFO] = variant;
}

struct packet_tile_info *receive_packet_tile_info(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_tile_info at the server.");
  }
  ensure_valid_variant_packet_tile_info(pc);

  switch(pc->phs.variant[PACKET_TILE_INFO]) {
  case 100:
    return receive_packet_tile_info_100(pc, type);
  default:
    log_debug("Unknown PACKET_TILE_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_tile_info(struct connection *pc, const struct packet_tile_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_tile_info from the client.");
  }
  ensure_valid_variant_packet_tile_info(pc);

  switch(pc->phs.variant[PACKET_TILE_INFO]) {

  case 100:
    return send_packet_tile_info_100(pc, packet);
  default:
    log_debug("Unknown PACKET_TILE_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_tile_info(struct conn_list *dest, const struct packet_tile_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_tile_info(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_game_info_100 hash_const

#define cmp_packet_game_info_100 cmp_const

BV_DEFINE(packet_game_info_100_fields, 82);

static struct packet_game_info *receive_packet_game_info_100(struct connection *pc, enum packet_type type)
{
  packet_game_info_100_fields fields;
  struct packet_game_info *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_game_info, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_game_info_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_game_info_100, cmp_packet_game_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'add_to_size_limit'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->add_to_size_limit = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'aifill'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->aifill = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'airlifting_style'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->airlifting_style = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'angrycitizen'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->angrycitizen = readin;
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'base_pollution'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->base_pollution = readin;
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'base_tech_cost'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->base_tech_cost = readin;
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'border_city_radius_sq'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->border_city_radius_sq = readin;
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'border_size_effect'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->border_size_effect = readin;
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'borders'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->borders = readin;
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'base_bribe_cost'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->base_bribe_cost = readin;
    }
  }
  real_packet->calendar_skip_0 = BV_ISSET(fields, 10);
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'celebratesize'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->celebratesize = readin;
    }
  }
  real_packet->changable_tax = BV_ISSET(fields, 12);
  real_packet->citizen_nationality = BV_ISSET(fields, 13);
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'citymindist'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->citymindist = readin;
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'cooling'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->cooling = readin;
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'coolinglevel'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->coolinglevel = readin;
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'diplomacy'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->diplomacy = readin;
    }
  }
  real_packet->fogofwar = BV_ISSET(fields, 18);
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'food_cost'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->food_cost = readin;
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'foodbox'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->foodbox = readin;
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  got field 'forced_gold'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->forced_gold = readin;
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'forced_luxury'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->forced_luxury = readin;
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'forced_science'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->forced_science = readin;
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'fulltradesize'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->fulltradesize = readin;
    }
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  got field 'global_advances'");
    
    for (;;) {
      int i;
    
      if (!dio_get_uint8(&din, &i)) {
        break;
      }
      if (i == 255) {
        break;
      }
      if (i > A_LAST) {
        log_error("packets_gen.c: WARNING: ignoring intra array diff");
      } else {
        dio_get_bool8(&din, &real_packet->global_advances[i]);
      }
    }
  }
  real_packet->global_warming = BV_ISSET(fields, 26);
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  got field 'globalwarming'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->globalwarming = readin;
    }
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  got field 'gold'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->gold = readin;
    }
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  got field 'gold_upkeep_style'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->gold_upkeep_style = readin;
    }
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  got field 'government_during_revolution_id'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->government_during_revolution_id = readin;
    }
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  got field 'granary_food_inc'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->granary_food_inc = readin;
    }
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  got field 'granary_food_ini'");
    
    {
      int i;
    
      for (i = 0; i < MAX_GRANARY_INIS; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->granary_food_ini[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  got field 'granary_num_inis'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->granary_num_inis = readin;
    }
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  got field 'great_wonder_owners'");
    
    for (;;) {
      int i;
    
      if (!dio_get_uint8(&din, &i)) {
        break;
      }
      if (i == 255) {
        break;
      }
      if (i > B_LAST) {
        log_error("packets_gen.c: WARNING: ignoring intra array diff");
      } else {
        {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->great_wonder_owners[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  got field 'happy_cost'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->happy_cost = readin;
    }
  }
  real_packet->happyborders = BV_ISSET(fields, 36);
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  got field 'heating'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->heating = readin;
    }
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  got field 'illness_base_factor'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->illness_base_factor = readin;
    }
  }
  if (BV_ISSET(fields, 39)) {
    log_packet_detailed("  got field 'illness_min_size'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->illness_min_size = readin;
    }
  }
  real_packet->illness_on = BV_ISSET(fields, 40);
  if (BV_ISSET(fields, 41)) {
    log_packet_detailed("  got field 'illness_pollution_factor'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->illness_pollution_factor = readin;
    }
  }
  if (BV_ISSET(fields, 42)) {
    log_packet_detailed("  got field 'illness_trade_infection'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->illness_trade_infection = readin;
    }
  }
  if (BV_ISSET(fields, 43)) {
    log_packet_detailed("  got field 'init_city_radius_sq'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->init_city_radius_sq = readin;
    }
  }
  real_packet->is_edit_mode = BV_ISSET(fields, 44);
  real_packet->is_new_game = BV_ISSET(fields, 45);
  if (BV_ISSET(fields, 46)) {
    log_packet_detailed("  got field 'killcitizen'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->killcitizen = readin;
    }
  }
  real_packet->killstack = BV_ISSET(fields, 47);
  if (BV_ISSET(fields, 48)) {
    log_packet_detailed("  got field 'min_city_center_output'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->min_city_center_output[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 49)) {
    log_packet_detailed("  got field 'negative_year_label'");
    dio_get_string(&din, real_packet->negative_year_label, sizeof(real_packet->negative_year_label));
  }
  if (BV_ISSET(fields, 50)) {
    log_packet_detailed("  got field 'notradesize'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->notradesize = readin;
    }
  }
  real_packet->nuclear_winter = BV_ISSET(fields, 51);
  if (BV_ISSET(fields, 52)) {
    log_packet_detailed("  got field 'nuclearwinter'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->nuclearwinter = readin;
    }
  }
  if (BV_ISSET(fields, 53)) {
    log_packet_detailed("  got field 'phase'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->phase = readin;
    }
  }
  if (BV_ISSET(fields, 54)) {
    log_packet_detailed("  got field 'phase_mode'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->phase_mode = readin;
    }
  }
  real_packet->pillage_select = BV_ISSET(fields, 55);
  if (BV_ISSET(fields, 56)) {
    log_packet_detailed("  got field 'positive_year_label'");
    dio_get_string(&din, real_packet->positive_year_label, sizeof(real_packet->positive_year_label));
  }
  if (BV_ISSET(fields, 57)) {
    log_packet_detailed("  got field 'rapturedelay'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->rapturedelay = readin;
    }
  }
  real_packet->restrictinfra = BV_ISSET(fields, 58);
  real_packet->unreachable_protects = BV_ISSET(fields, 59);
  if (BV_ISSET(fields, 60)) {
    log_packet_detailed("  got field 'sciencebox'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->sciencebox = readin;
    }
  }
  if (BV_ISSET(fields, 61)) {
    log_packet_detailed("  got field 'seconds_to_phasedone'");
    {
      int tmp;
      
      dio_get_uint32(&din, &tmp);
      real_packet->seconds_to_phasedone = (float)(tmp) / 100.0;
    }
  }
  if (BV_ISSET(fields, 62)) {
    log_packet_detailed("  got field 'shieldbox'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->shieldbox = readin;
    }
  }
  if (BV_ISSET(fields, 63)) {
    log_packet_detailed("  got field 'skill_level'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->skill_level = readin;
    }
  }
  real_packet->slow_invasions = BV_ISSET(fields, 64);
  real_packet->spacerace = BV_ISSET(fields, 65);
  real_packet->team_pooled_research = BV_ISSET(fields, 66);
  if (BV_ISSET(fields, 67)) {
    log_packet_detailed("  got field 'tech'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->tech = readin;
    }
  }
  if (BV_ISSET(fields, 68)) {
    log_packet_detailed("  got field 'tech_cost_style'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->tech_cost_style = readin;
    }
  }
  if (BV_ISSET(fields, 69)) {
    log_packet_detailed("  got field 'tech_leakage'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->tech_leakage = readin;
    }
  }
  if (BV_ISSET(fields, 70)) {
    log_packet_detailed("  got field 'tech_upkeep_divider'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->tech_upkeep_divider = readin;
    }
  }
  if (BV_ISSET(fields, 71)) {
    log_packet_detailed("  got field 'tech_upkeep_style'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->tech_upkeep_style = readin;
    }
  }
  if (BV_ISSET(fields, 72)) {
    log_packet_detailed("  got field 'timeout'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->timeout = readin;
    }
  }
  real_packet->tired_attack = BV_ISSET(fields, 73);
  if (BV_ISSET(fields, 74)) {
    log_packet_detailed("  got field 'trademindist_new'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->trademindist_new = readin;
    }
  }
  real_packet->trading_city = BV_ISSET(fields, 75);
  real_packet->trading_gold = BV_ISSET(fields, 76);
  real_packet->trading_tech = BV_ISSET(fields, 77);
  if (BV_ISSET(fields, 78)) {
    log_packet_detailed("  got field 'turn'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->turn = readin;
    }
  }
  if (BV_ISSET(fields, 79)) {
    log_packet_detailed("  got field 'warminglevel'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->warminglevel = readin;
    }
  }
  if (BV_ISSET(fields, 80)) {
    log_packet_detailed("  got field 'year'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->year = readin;
    }
  }
  real_packet->year_0_hack = BV_ISSET(fields, 81);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_game_info_100(struct connection *pc, const struct packet_game_info *packet)
{
  const struct packet_game_info *real_packet = packet;
  packet_game_info_100_fields fields;
  struct packet_game_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_GAME_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_GAME_INFO);

  log_packet_detailed("packet_game_info_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_game_info_100, cmp_packet_game_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->add_to_size_limit != real_packet->add_to_size_limit);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->aifill != real_packet->aifill);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->airlifting_style != real_packet->airlifting_style);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->angrycitizen != real_packet->angrycitizen);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->base_pollution != real_packet->base_pollution);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->base_tech_cost != real_packet->base_tech_cost);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->border_city_radius_sq != real_packet->border_city_radius_sq);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (old->border_size_effect != real_packet->border_size_effect);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->borders != real_packet->borders);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->base_bribe_cost != real_packet->base_bribe_cost);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->calendar_skip_0 != real_packet->calendar_skip_0);
  if(differ) {
    different++;
  }
  if (packet->calendar_skip_0) {
    BV_SET(fields, 10);
  }

  differ = (old->celebratesize != real_packet->celebratesize);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = (old->changable_tax != real_packet->changable_tax);
  if(differ) {
    different++;
  }
  if (packet->changable_tax) {
    BV_SET(fields, 12);
  }

  differ = (old->citizen_nationality != real_packet->citizen_nationality);
  if(differ) {
    different++;
  }
  if (packet->citizen_nationality) {
    BV_SET(fields, 13);
  }

  differ = (old->citymindist != real_packet->citymindist);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->cooling != real_packet->cooling);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (old->coolinglevel != real_packet->coolinglevel);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }

  differ = (old->diplomacy != real_packet->diplomacy);
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }

  differ = (old->fogofwar != real_packet->fogofwar);
  if(differ) {
    different++;
  }
  if (packet->fogofwar) {
    BV_SET(fields, 18);
  }

  differ = (old->food_cost != real_packet->food_cost);
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }

  differ = (old->foodbox != real_packet->foodbox);
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }

  differ = (old->forced_gold != real_packet->forced_gold);
  if (differ) {
    different++;
    BV_SET(fields, 21);
  }

  differ = (old->forced_luxury != real_packet->forced_luxury);
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (old->forced_science != real_packet->forced_science);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }

  differ = (old->fulltradesize != real_packet->fulltradesize);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }


    {
      differ = (A_LAST != A_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < A_LAST; i++) {
          if (old->global_advances[i] != real_packet->global_advances[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 25);
  }

  differ = (old->global_warming != real_packet->global_warming);
  if(differ) {
    different++;
  }
  if (packet->global_warming) {
    BV_SET(fields, 26);
  }

  differ = (old->globalwarming != real_packet->globalwarming);
  if (differ) {
    different++;
    BV_SET(fields, 27);
  }

  differ = (old->gold != real_packet->gold);
  if (differ) {
    different++;
    BV_SET(fields, 28);
  }

  differ = (old->gold_upkeep_style != real_packet->gold_upkeep_style);
  if (differ) {
    different++;
    BV_SET(fields, 29);
  }

  differ = (old->government_during_revolution_id != real_packet->government_during_revolution_id);
  if (differ) {
    different++;
    BV_SET(fields, 30);
  }

  differ = (old->granary_food_inc != real_packet->granary_food_inc);
  if (differ) {
    different++;
    BV_SET(fields, 31);
  }


    {
      differ = (MAX_GRANARY_INIS != MAX_GRANARY_INIS);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_GRANARY_INIS; i++) {
          if (old->granary_food_ini[i] != real_packet->granary_food_ini[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 32);
  }

  differ = (old->granary_num_inis != real_packet->granary_num_inis);
  if (differ) {
    different++;
    BV_SET(fields, 33);
  }


    {
      differ = (B_LAST != B_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < B_LAST; i++) {
          if (old->great_wonder_owners[i] != real_packet->great_wonder_owners[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 34);
  }

  differ = (old->happy_cost != real_packet->happy_cost);
  if (differ) {
    different++;
    BV_SET(fields, 35);
  }

  differ = (old->happyborders != real_packet->happyborders);
  if(differ) {
    different++;
  }
  if (packet->happyborders) {
    BV_SET(fields, 36);
  }

  differ = (old->heating != real_packet->heating);
  if (differ) {
    different++;
    BV_SET(fields, 37);
  }

  differ = (old->illness_base_factor != real_packet->illness_base_factor);
  if (differ) {
    different++;
    BV_SET(fields, 38);
  }

  differ = (old->illness_min_size != real_packet->illness_min_size);
  if (differ) {
    different++;
    BV_SET(fields, 39);
  }

  differ = (old->illness_on != real_packet->illness_on);
  if(differ) {
    different++;
  }
  if (packet->illness_on) {
    BV_SET(fields, 40);
  }

  differ = (old->illness_pollution_factor != real_packet->illness_pollution_factor);
  if (differ) {
    different++;
    BV_SET(fields, 41);
  }

  differ = (old->illness_trade_infection != real_packet->illness_trade_infection);
  if (differ) {
    different++;
    BV_SET(fields, 42);
  }

  differ = (old->init_city_radius_sq != real_packet->init_city_radius_sq);
  if (differ) {
    different++;
    BV_SET(fields, 43);
  }

  differ = (old->is_edit_mode != real_packet->is_edit_mode);
  if(differ) {
    different++;
  }
  if (packet->is_edit_mode) {
    BV_SET(fields, 44);
  }

  differ = (old->is_new_game != real_packet->is_new_game);
  if(differ) {
    different++;
  }
  if (packet->is_new_game) {
    BV_SET(fields, 45);
  }

  differ = (old->killcitizen != real_packet->killcitizen);
  if (differ) {
    different++;
    BV_SET(fields, 46);
  }

  differ = (old->killstack != real_packet->killstack);
  if(differ) {
    different++;
  }
  if (packet->killstack) {
    BV_SET(fields, 47);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->min_city_center_output[i] != real_packet->min_city_center_output[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 48);
  }

  differ = (strcmp(old->negative_year_label, real_packet->negative_year_label) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 49);
  }

  differ = (old->notradesize != real_packet->notradesize);
  if (differ) {
    different++;
    BV_SET(fields, 50);
  }

  differ = (old->nuclear_winter != real_packet->nuclear_winter);
  if(differ) {
    different++;
  }
  if (packet->nuclear_winter) {
    BV_SET(fields, 51);
  }

  differ = (old->nuclearwinter != real_packet->nuclearwinter);
  if (differ) {
    different++;
    BV_SET(fields, 52);
  }

  differ = (old->phase != real_packet->phase);
  if (differ) {
    different++;
    BV_SET(fields, 53);
  }

  differ = (old->phase_mode != real_packet->phase_mode);
  if (differ) {
    different++;
    BV_SET(fields, 54);
  }

  differ = (old->pillage_select != real_packet->pillage_select);
  if(differ) {
    different++;
  }
  if (packet->pillage_select) {
    BV_SET(fields, 55);
  }

  differ = (strcmp(old->positive_year_label, real_packet->positive_year_label) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 56);
  }

  differ = (old->rapturedelay != real_packet->rapturedelay);
  if (differ) {
    different++;
    BV_SET(fields, 57);
  }

  differ = (old->restrictinfra != real_packet->restrictinfra);
  if(differ) {
    different++;
  }
  if (packet->restrictinfra) {
    BV_SET(fields, 58);
  }

  differ = (old->unreachable_protects != real_packet->unreachable_protects);
  if(differ) {
    different++;
  }
  if (packet->unreachable_protects) {
    BV_SET(fields, 59);
  }

  differ = (old->sciencebox != real_packet->sciencebox);
  if (differ) {
    different++;
    BV_SET(fields, 60);
  }

  differ = (old->seconds_to_phasedone != real_packet->seconds_to_phasedone);
  if (differ) {
    different++;
    BV_SET(fields, 61);
  }

  differ = (old->shieldbox != real_packet->shieldbox);
  if (differ) {
    different++;
    BV_SET(fields, 62);
  }

  differ = (old->skill_level != real_packet->skill_level);
  if (differ) {
    different++;
    BV_SET(fields, 63);
  }

  differ = (old->slow_invasions != real_packet->slow_invasions);
  if(differ) {
    different++;
  }
  if (packet->slow_invasions) {
    BV_SET(fields, 64);
  }

  differ = (old->spacerace != real_packet->spacerace);
  if(differ) {
    different++;
  }
  if (packet->spacerace) {
    BV_SET(fields, 65);
  }

  differ = (old->team_pooled_research != real_packet->team_pooled_research);
  if(differ) {
    different++;
  }
  if (packet->team_pooled_research) {
    BV_SET(fields, 66);
  }

  differ = (old->tech != real_packet->tech);
  if (differ) {
    different++;
    BV_SET(fields, 67);
  }

  differ = (old->tech_cost_style != real_packet->tech_cost_style);
  if (differ) {
    different++;
    BV_SET(fields, 68);
  }

  differ = (old->tech_leakage != real_packet->tech_leakage);
  if (differ) {
    different++;
    BV_SET(fields, 69);
  }

  differ = (old->tech_upkeep_divider != real_packet->tech_upkeep_divider);
  if (differ) {
    different++;
    BV_SET(fields, 70);
  }

  differ = (old->tech_upkeep_style != real_packet->tech_upkeep_style);
  if (differ) {
    different++;
    BV_SET(fields, 71);
  }

  differ = (old->timeout != real_packet->timeout);
  if (differ) {
    different++;
    BV_SET(fields, 72);
  }

  differ = (old->tired_attack != real_packet->tired_attack);
  if(differ) {
    different++;
  }
  if (packet->tired_attack) {
    BV_SET(fields, 73);
  }

  differ = (old->trademindist_new != real_packet->trademindist_new);
  if (differ) {
    different++;
    BV_SET(fields, 74);
  }

  differ = (old->trading_city != real_packet->trading_city);
  if(differ) {
    different++;
  }
  if (packet->trading_city) {
    BV_SET(fields, 75);
  }

  differ = (old->trading_gold != real_packet->trading_gold);
  if(differ) {
    different++;
  }
  if (packet->trading_gold) {
    BV_SET(fields, 76);
  }

  differ = (old->trading_tech != real_packet->trading_tech);
  if(differ) {
    different++;
  }
  if (packet->trading_tech) {
    BV_SET(fields, 77);
  }

  differ = (old->turn != real_packet->turn);
  if (differ) {
    different++;
    BV_SET(fields, 78);
  }

  differ = (old->warminglevel != real_packet->warminglevel);
  if (differ) {
    different++;
    BV_SET(fields, 79);
  }

  differ = (old->year != real_packet->year);
  if (differ) {
    different++;
    BV_SET(fields, 80);
  }

  differ = (old->year_0_hack != real_packet->year_0_hack);
  if(differ) {
    different++;
  }
  if (packet->year_0_hack) {
    BV_SET(fields, 81);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'add_to_size_limit' has changed");
    dio_put_uint8(&dout, real_packet->add_to_size_limit);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'aifill' has changed");
    dio_put_uint8(&dout, real_packet->aifill);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'airlifting_style' has changed");
    dio_put_uint8(&dout, real_packet->airlifting_style);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'angrycitizen' has changed");
    dio_put_uint8(&dout, real_packet->angrycitizen);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'base_pollution' has changed");
    dio_put_sint16(&dout, real_packet->base_pollution);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'base_tech_cost' has changed");
    dio_put_uint8(&dout, real_packet->base_tech_cost);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'border_city_radius_sq' has changed");
    dio_put_uint8(&dout, real_packet->border_city_radius_sq);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'border_size_effect' has changed");
    dio_put_uint8(&dout, real_packet->border_size_effect);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'borders' has changed");
    dio_put_uint8(&dout, real_packet->borders);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'base_bribe_cost' has changed");
    dio_put_uint32(&dout, real_packet->base_bribe_cost);
  }
  /* field 10 is folded into the header */
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'celebratesize' has changed");
    dio_put_uint8(&dout, real_packet->celebratesize);
  }
  /* field 12 is folded into the header */
  /* field 13 is folded into the header */
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'citymindist' has changed");
    dio_put_uint8(&dout, real_packet->citymindist);
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'cooling' has changed");
    dio_put_uint32(&dout, real_packet->cooling);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'coolinglevel' has changed");
    dio_put_uint32(&dout, real_packet->coolinglevel);
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'diplomacy' has changed");
    dio_put_uint8(&dout, real_packet->diplomacy);
  }
  /* field 18 is folded into the header */
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'food_cost' has changed");
    dio_put_uint8(&dout, real_packet->food_cost);
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'foodbox' has changed");
    dio_put_uint32(&dout, real_packet->foodbox);
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  field 'forced_gold' has changed");
    dio_put_uint8(&dout, real_packet->forced_gold);
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'forced_luxury' has changed");
    dio_put_uint8(&dout, real_packet->forced_luxury);
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'forced_science' has changed");
    dio_put_uint8(&dout, real_packet->forced_science);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'fulltradesize' has changed");
    dio_put_uint8(&dout, real_packet->fulltradesize);
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  field 'global_advances' has changed");
  
    {
      int i;

      fc_assert(A_LAST < 255);

      for (i = 0; i < A_LAST; i++) {
        if(old->global_advances[i] != real_packet->global_advances[i]) {
          dio_put_uint8(&dout, i);
          dio_put_bool8(&dout, real_packet->global_advances[i]);
        }
      }
      dio_put_uint8(&dout, 255);
    } 
  }
  /* field 26 is folded into the header */
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  field 'globalwarming' has changed");
    dio_put_uint32(&dout, real_packet->globalwarming);
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  field 'gold' has changed");
    dio_put_uint32(&dout, real_packet->gold);
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  field 'gold_upkeep_style' has changed");
    dio_put_uint8(&dout, real_packet->gold_upkeep_style);
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  field 'government_during_revolution_id' has changed");
    dio_put_uint8(&dout, real_packet->government_during_revolution_id);
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  field 'granary_food_inc' has changed");
    dio_put_uint8(&dout, real_packet->granary_food_inc);
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  field 'granary_food_ini' has changed");
  
    {
      int i;

      for (i = 0; i < MAX_GRANARY_INIS; i++) {
        dio_put_uint8(&dout, real_packet->granary_food_ini[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  field 'granary_num_inis' has changed");
    dio_put_uint8(&dout, real_packet->granary_num_inis);
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  field 'great_wonder_owners' has changed");
  
    {
      int i;

      fc_assert(B_LAST < 255);

      for (i = 0; i < B_LAST; i++) {
        if(old->great_wonder_owners[i] != real_packet->great_wonder_owners[i]) {
          dio_put_uint8(&dout, i);
          dio_put_sint8(&dout, real_packet->great_wonder_owners[i]);
        }
      }
      dio_put_uint8(&dout, 255);
    } 
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  field 'happy_cost' has changed");
    dio_put_uint8(&dout, real_packet->happy_cost);
  }
  /* field 36 is folded into the header */
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  field 'heating' has changed");
    dio_put_uint32(&dout, real_packet->heating);
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  field 'illness_base_factor' has changed");
    dio_put_uint8(&dout, real_packet->illness_base_factor);
  }
  if (BV_ISSET(fields, 39)) {
    log_packet_detailed("  field 'illness_min_size' has changed");
    dio_put_uint8(&dout, real_packet->illness_min_size);
  }
  /* field 40 is folded into the header */
  if (BV_ISSET(fields, 41)) {
    log_packet_detailed("  field 'illness_pollution_factor' has changed");
    dio_put_uint8(&dout, real_packet->illness_pollution_factor);
  }
  if (BV_ISSET(fields, 42)) {
    log_packet_detailed("  field 'illness_trade_infection' has changed");
    dio_put_uint8(&dout, real_packet->illness_trade_infection);
  }
  if (BV_ISSET(fields, 43)) {
    log_packet_detailed("  field 'init_city_radius_sq' has changed");
    dio_put_uint8(&dout, real_packet->init_city_radius_sq);
  }
  /* field 44 is folded into the header */
  /* field 45 is folded into the header */
  if (BV_ISSET(fields, 46)) {
    log_packet_detailed("  field 'killcitizen' has changed");
    dio_put_uint8(&dout, real_packet->killcitizen);
  }
  /* field 47 is folded into the header */
  if (BV_ISSET(fields, 48)) {
    log_packet_detailed("  field 'min_city_center_output' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint8(&dout, real_packet->min_city_center_output[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 49)) {
    log_packet_detailed("  field 'negative_year_label' has changed");
    dio_put_string(&dout, real_packet->negative_year_label);
  }
  if (BV_ISSET(fields, 50)) {
    log_packet_detailed("  field 'notradesize' has changed");
    dio_put_uint8(&dout, real_packet->notradesize);
  }
  /* field 51 is folded into the header */
  if (BV_ISSET(fields, 52)) {
    log_packet_detailed("  field 'nuclearwinter' has changed");
    dio_put_uint32(&dout, real_packet->nuclearwinter);
  }
  if (BV_ISSET(fields, 53)) {
    log_packet_detailed("  field 'phase' has changed");
    dio_put_sint16(&dout, real_packet->phase);
  }
  if (BV_ISSET(fields, 54)) {
    log_packet_detailed("  field 'phase_mode' has changed");
    dio_put_uint8(&dout, real_packet->phase_mode);
  }
  /* field 55 is folded into the header */
  if (BV_ISSET(fields, 56)) {
    log_packet_detailed("  field 'positive_year_label' has changed");
    dio_put_string(&dout, real_packet->positive_year_label);
  }
  if (BV_ISSET(fields, 57)) {
    log_packet_detailed("  field 'rapturedelay' has changed");
    dio_put_uint8(&dout, real_packet->rapturedelay);
  }
  /* field 58 is folded into the header */
  /* field 59 is folded into the header */
  if (BV_ISSET(fields, 60)) {
    log_packet_detailed("  field 'sciencebox' has changed");
    dio_put_uint32(&dout, real_packet->sciencebox);
  }
  if (BV_ISSET(fields, 61)) {
    log_packet_detailed("  field 'seconds_to_phasedone' has changed");
    dio_put_uint32(&dout, (int)(real_packet->seconds_to_phasedone * 100));
  }
  if (BV_ISSET(fields, 62)) {
    log_packet_detailed("  field 'shieldbox' has changed");
    dio_put_uint32(&dout, real_packet->shieldbox);
  }
  if (BV_ISSET(fields, 63)) {
    log_packet_detailed("  field 'skill_level' has changed");
    dio_put_uint32(&dout, real_packet->skill_level);
  }
  /* field 64 is folded into the header */
  /* field 65 is folded into the header */
  /* field 66 is folded into the header */
  if (BV_ISSET(fields, 67)) {
    log_packet_detailed("  field 'tech' has changed");
    dio_put_uint32(&dout, real_packet->tech);
  }
  if (BV_ISSET(fields, 68)) {
    log_packet_detailed("  field 'tech_cost_style' has changed");
    dio_put_uint8(&dout, real_packet->tech_cost_style);
  }
  if (BV_ISSET(fields, 69)) {
    log_packet_detailed("  field 'tech_leakage' has changed");
    dio_put_uint8(&dout, real_packet->tech_leakage);
  }
  if (BV_ISSET(fields, 70)) {
    log_packet_detailed("  field 'tech_upkeep_divider' has changed");
    dio_put_uint16(&dout, real_packet->tech_upkeep_divider);
  }
  if (BV_ISSET(fields, 71)) {
    log_packet_detailed("  field 'tech_upkeep_style' has changed");
    dio_put_uint8(&dout, real_packet->tech_upkeep_style);
  }
  if (BV_ISSET(fields, 72)) {
    log_packet_detailed("  field 'timeout' has changed");
    dio_put_uint32(&dout, real_packet->timeout);
  }
  /* field 73 is folded into the header */
  if (BV_ISSET(fields, 74)) {
    log_packet_detailed("  field 'trademindist_new' has changed");
    dio_put_uint16(&dout, real_packet->trademindist_new);
  }
  /* field 75 is folded into the header */
  /* field 76 is folded into the header */
  /* field 77 is folded into the header */
  if (BV_ISSET(fields, 78)) {
    log_packet_detailed("  field 'turn' has changed");
    dio_put_sint16(&dout, real_packet->turn);
  }
  if (BV_ISSET(fields, 79)) {
    log_packet_detailed("  field 'warminglevel' has changed");
    dio_put_uint32(&dout, real_packet->warminglevel);
  }
  if (BV_ISSET(fields, 80)) {
    log_packet_detailed("  field 'year' has changed");
    dio_put_sint16(&dout, real_packet->year);
  }
  /* field 81 is folded into the header */

  *old = *real_packet;
  SEND_PACKET_END;
}

#define hash_packet_game_info_101 hash_const

#define cmp_packet_game_info_101 cmp_const

BV_DEFINE(packet_game_info_101_fields, 82);

static struct packet_game_info *receive_packet_game_info_101(struct connection *pc, enum packet_type type)
{
  packet_game_info_101_fields fields;
  struct packet_game_info *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_game_info, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_game_info_101: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_game_info_101, cmp_packet_game_info_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'add_to_size_limit'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->add_to_size_limit = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'aifill'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->aifill = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'airlifting_style'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->airlifting_style = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'angrycitizen'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->angrycitizen = readin;
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'base_pollution'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->base_pollution = readin;
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'base_tech_cost'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->base_tech_cost = readin;
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'border_city_radius_sq'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->border_city_radius_sq = readin;
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'border_size_effect'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->border_size_effect = readin;
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'borders'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->borders = readin;
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'base_bribe_cost'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->base_bribe_cost = readin;
    }
  }
  real_packet->calendar_skip_0 = BV_ISSET(fields, 10);
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'celebratesize'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->celebratesize = readin;
    }
  }
  real_packet->changable_tax = BV_ISSET(fields, 12);
  real_packet->citizen_nationality = BV_ISSET(fields, 13);
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'citymindist'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->citymindist = readin;
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'cooling'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->cooling = readin;
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'coolinglevel'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->coolinglevel = readin;
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'diplomacy'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->diplomacy = readin;
    }
  }
  real_packet->fogofwar = BV_ISSET(fields, 18);
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'food_cost'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->food_cost = readin;
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'foodbox'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->foodbox = readin;
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  got field 'forced_gold'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->forced_gold = readin;
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'forced_luxury'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->forced_luxury = readin;
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'forced_science'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->forced_science = readin;
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'fulltradesize'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->fulltradesize = readin;
    }
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  got field 'global_advances'");
    
    for (;;) {
      int i;
    
      if (!dio_get_uint8(&din, &i)) {
        break;
      }
      if (i == 255) {
        break;
      }
      if (i > A_LAST) {
        log_error("packets_gen.c: WARNING: ignoring intra array diff");
      } else {
        dio_get_bool8(&din, &real_packet->global_advances[i]);
      }
    }
  }
  real_packet->global_warming = BV_ISSET(fields, 26);
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  got field 'globalwarming'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->globalwarming = readin;
    }
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  got field 'gold'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->gold = readin;
    }
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  got field 'gold_upkeep_style'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->gold_upkeep_style = readin;
    }
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  got field 'government_during_revolution_id'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->government_during_revolution_id = readin;
    }
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  got field 'granary_food_inc'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->granary_food_inc = readin;
    }
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  got field 'granary_food_ini'");
    
    {
      int i;
    
      for (i = 0; i < MAX_GRANARY_INIS; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->granary_food_ini[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  got field 'granary_num_inis'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->granary_num_inis = readin;
    }
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  got field 'great_wonder_owners'");
    
    for (;;) {
      int i;
    
      if (!dio_get_uint8(&din, &i)) {
        break;
      }
      if (i == 255) {
        break;
      }
      if (i > B_LAST) {
        log_error("packets_gen.c: WARNING: ignoring intra array diff");
      } else {
        {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->great_wonder_owners[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  got field 'happy_cost'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->happy_cost = readin;
    }
  }
  real_packet->happyborders = BV_ISSET(fields, 36);
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  got field 'heating'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->heating = readin;
    }
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  got field 'illness_base_factor'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->illness_base_factor = readin;
    }
  }
  if (BV_ISSET(fields, 39)) {
    log_packet_detailed("  got field 'illness_min_size'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->illness_min_size = readin;
    }
  }
  real_packet->illness_on = BV_ISSET(fields, 40);
  if (BV_ISSET(fields, 41)) {
    log_packet_detailed("  got field 'illness_pollution_factor'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->illness_pollution_factor = readin;
    }
  }
  if (BV_ISSET(fields, 42)) {
    log_packet_detailed("  got field 'illness_trade_infection'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->illness_trade_infection = readin;
    }
  }
  if (BV_ISSET(fields, 43)) {
    log_packet_detailed("  got field 'init_city_radius_sq'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->init_city_radius_sq = readin;
    }
  }
  real_packet->is_edit_mode = BV_ISSET(fields, 44);
  real_packet->is_new_game = BV_ISSET(fields, 45);
  if (BV_ISSET(fields, 46)) {
    log_packet_detailed("  got field 'killcitizen'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->killcitizen = readin;
    }
  }
  real_packet->killstack = BV_ISSET(fields, 47);
  if (BV_ISSET(fields, 48)) {
    log_packet_detailed("  got field 'min_city_center_output'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->min_city_center_output[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 49)) {
    log_packet_detailed("  got field 'negative_year_label'");
    dio_get_string(&din, real_packet->negative_year_label, sizeof(real_packet->negative_year_label));
  }
  if (BV_ISSET(fields, 50)) {
    log_packet_detailed("  got field 'notradesize'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->notradesize = readin;
    }
  }
  real_packet->nuclear_winter = BV_ISSET(fields, 51);
  if (BV_ISSET(fields, 52)) {
    log_packet_detailed("  got field 'nuclearwinter'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->nuclearwinter = readin;
    }
  }
  if (BV_ISSET(fields, 53)) {
    log_packet_detailed("  got field 'phase'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->phase = readin;
    }
  }
  if (BV_ISSET(fields, 54)) {
    log_packet_detailed("  got field 'phase_mode'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->phase_mode = readin;
    }
  }
  real_packet->pillage_select = BV_ISSET(fields, 55);
  if (BV_ISSET(fields, 56)) {
    log_packet_detailed("  got field 'positive_year_label'");
    dio_get_string(&din, real_packet->positive_year_label, sizeof(real_packet->positive_year_label));
  }
  if (BV_ISSET(fields, 57)) {
    log_packet_detailed("  got field 'rapturedelay'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->rapturedelay = readin;
    }
  }
  real_packet->restrictinfra = BV_ISSET(fields, 58);
  real_packet->unreachable_protects = BV_ISSET(fields, 59);
  if (BV_ISSET(fields, 60)) {
    log_packet_detailed("  got field 'sciencebox'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->sciencebox = readin;
    }
  }
  if (BV_ISSET(fields, 61)) {
    log_packet_detailed("  got field 'seconds_to_phasedone'");
    {
      int tmp;
      
      dio_get_uint32(&din, &tmp);
      real_packet->seconds_to_phasedone = (float)(tmp) / 100.0;
    }
  }
  if (BV_ISSET(fields, 62)) {
    log_packet_detailed("  got field 'shieldbox'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->shieldbox = readin;
    }
  }
  if (BV_ISSET(fields, 63)) {
    log_packet_detailed("  got field 'skill_level'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->skill_level = readin;
    }
  }
  real_packet->slow_invasions = BV_ISSET(fields, 64);
  real_packet->spacerace = BV_ISSET(fields, 65);
  real_packet->team_pooled_research = BV_ISSET(fields, 66);
  if (BV_ISSET(fields, 67)) {
    log_packet_detailed("  got field 'tech'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->tech = readin;
    }
  }
  if (BV_ISSET(fields, 68)) {
    log_packet_detailed("  got field 'tech_cost_style'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->tech_cost_style = readin;
    }
  }
  if (BV_ISSET(fields, 69)) {
    log_packet_detailed("  got field 'tech_leakage'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->tech_leakage = readin;
    }
  }
  if (BV_ISSET(fields, 70)) {
    log_packet_detailed("  got field 'tech_upkeep_divider'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->tech_upkeep_divider = readin;
    }
  }
  if (BV_ISSET(fields, 71)) {
    log_packet_detailed("  got field 'tech_upkeep_style'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->tech_upkeep_style = readin;
    }
  }
  if (BV_ISSET(fields, 72)) {
    log_packet_detailed("  got field 'timeout'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->timeout = readin;
    }
  }
  real_packet->tired_attack = BV_ISSET(fields, 73);
  if (BV_ISSET(fields, 74)) {
    log_packet_detailed("  got field 'trademindist_old'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->trademindist_old = readin;
    }
  }
  real_packet->trading_city = BV_ISSET(fields, 75);
  real_packet->trading_gold = BV_ISSET(fields, 76);
  real_packet->trading_tech = BV_ISSET(fields, 77);
  if (BV_ISSET(fields, 78)) {
    log_packet_detailed("  got field 'turn'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->turn = readin;
    }
  }
  if (BV_ISSET(fields, 79)) {
    log_packet_detailed("  got field 'warminglevel'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->warminglevel = readin;
    }
  }
  if (BV_ISSET(fields, 80)) {
    log_packet_detailed("  got field 'year'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->year = readin;
    }
  }
  real_packet->year_0_hack = BV_ISSET(fields, 81);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_game_info_101(struct connection *pc, const struct packet_game_info *packet)
{
  const struct packet_game_info *real_packet = packet;
  packet_game_info_101_fields fields;
  struct packet_game_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_GAME_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_GAME_INFO);

  log_packet_detailed("packet_game_info_101: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_game_info_101, cmp_packet_game_info_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->add_to_size_limit != real_packet->add_to_size_limit);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->aifill != real_packet->aifill);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->airlifting_style != real_packet->airlifting_style);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->angrycitizen != real_packet->angrycitizen);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->base_pollution != real_packet->base_pollution);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->base_tech_cost != real_packet->base_tech_cost);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->border_city_radius_sq != real_packet->border_city_radius_sq);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (old->border_size_effect != real_packet->border_size_effect);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->borders != real_packet->borders);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->base_bribe_cost != real_packet->base_bribe_cost);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->calendar_skip_0 != real_packet->calendar_skip_0);
  if(differ) {
    different++;
  }
  if (packet->calendar_skip_0) {
    BV_SET(fields, 10);
  }

  differ = (old->celebratesize != real_packet->celebratesize);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = (old->changable_tax != real_packet->changable_tax);
  if(differ) {
    different++;
  }
  if (packet->changable_tax) {
    BV_SET(fields, 12);
  }

  differ = (old->citizen_nationality != real_packet->citizen_nationality);
  if(differ) {
    different++;
  }
  if (packet->citizen_nationality) {
    BV_SET(fields, 13);
  }

  differ = (old->citymindist != real_packet->citymindist);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->cooling != real_packet->cooling);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (old->coolinglevel != real_packet->coolinglevel);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }

  differ = (old->diplomacy != real_packet->diplomacy);
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }

  differ = (old->fogofwar != real_packet->fogofwar);
  if(differ) {
    different++;
  }
  if (packet->fogofwar) {
    BV_SET(fields, 18);
  }

  differ = (old->food_cost != real_packet->food_cost);
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }

  differ = (old->foodbox != real_packet->foodbox);
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }

  differ = (old->forced_gold != real_packet->forced_gold);
  if (differ) {
    different++;
    BV_SET(fields, 21);
  }

  differ = (old->forced_luxury != real_packet->forced_luxury);
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (old->forced_science != real_packet->forced_science);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }

  differ = (old->fulltradesize != real_packet->fulltradesize);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }


    {
      differ = (A_LAST != A_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < A_LAST; i++) {
          if (old->global_advances[i] != real_packet->global_advances[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 25);
  }

  differ = (old->global_warming != real_packet->global_warming);
  if(differ) {
    different++;
  }
  if (packet->global_warming) {
    BV_SET(fields, 26);
  }

  differ = (old->globalwarming != real_packet->globalwarming);
  if (differ) {
    different++;
    BV_SET(fields, 27);
  }

  differ = (old->gold != real_packet->gold);
  if (differ) {
    different++;
    BV_SET(fields, 28);
  }

  differ = (old->gold_upkeep_style != real_packet->gold_upkeep_style);
  if (differ) {
    different++;
    BV_SET(fields, 29);
  }

  differ = (old->government_during_revolution_id != real_packet->government_during_revolution_id);
  if (differ) {
    different++;
    BV_SET(fields, 30);
  }

  differ = (old->granary_food_inc != real_packet->granary_food_inc);
  if (differ) {
    different++;
    BV_SET(fields, 31);
  }


    {
      differ = (MAX_GRANARY_INIS != MAX_GRANARY_INIS);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_GRANARY_INIS; i++) {
          if (old->granary_food_ini[i] != real_packet->granary_food_ini[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 32);
  }

  differ = (old->granary_num_inis != real_packet->granary_num_inis);
  if (differ) {
    different++;
    BV_SET(fields, 33);
  }


    {
      differ = (B_LAST != B_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < B_LAST; i++) {
          if (old->great_wonder_owners[i] != real_packet->great_wonder_owners[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 34);
  }

  differ = (old->happy_cost != real_packet->happy_cost);
  if (differ) {
    different++;
    BV_SET(fields, 35);
  }

  differ = (old->happyborders != real_packet->happyborders);
  if(differ) {
    different++;
  }
  if (packet->happyborders) {
    BV_SET(fields, 36);
  }

  differ = (old->heating != real_packet->heating);
  if (differ) {
    different++;
    BV_SET(fields, 37);
  }

  differ = (old->illness_base_factor != real_packet->illness_base_factor);
  if (differ) {
    different++;
    BV_SET(fields, 38);
  }

  differ = (old->illness_min_size != real_packet->illness_min_size);
  if (differ) {
    different++;
    BV_SET(fields, 39);
  }

  differ = (old->illness_on != real_packet->illness_on);
  if(differ) {
    different++;
  }
  if (packet->illness_on) {
    BV_SET(fields, 40);
  }

  differ = (old->illness_pollution_factor != real_packet->illness_pollution_factor);
  if (differ) {
    different++;
    BV_SET(fields, 41);
  }

  differ = (old->illness_trade_infection != real_packet->illness_trade_infection);
  if (differ) {
    different++;
    BV_SET(fields, 42);
  }

  differ = (old->init_city_radius_sq != real_packet->init_city_radius_sq);
  if (differ) {
    different++;
    BV_SET(fields, 43);
  }

  differ = (old->is_edit_mode != real_packet->is_edit_mode);
  if(differ) {
    different++;
  }
  if (packet->is_edit_mode) {
    BV_SET(fields, 44);
  }

  differ = (old->is_new_game != real_packet->is_new_game);
  if(differ) {
    different++;
  }
  if (packet->is_new_game) {
    BV_SET(fields, 45);
  }

  differ = (old->killcitizen != real_packet->killcitizen);
  if (differ) {
    different++;
    BV_SET(fields, 46);
  }

  differ = (old->killstack != real_packet->killstack);
  if(differ) {
    different++;
  }
  if (packet->killstack) {
    BV_SET(fields, 47);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->min_city_center_output[i] != real_packet->min_city_center_output[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 48);
  }

  differ = (strcmp(old->negative_year_label, real_packet->negative_year_label) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 49);
  }

  differ = (old->notradesize != real_packet->notradesize);
  if (differ) {
    different++;
    BV_SET(fields, 50);
  }

  differ = (old->nuclear_winter != real_packet->nuclear_winter);
  if(differ) {
    different++;
  }
  if (packet->nuclear_winter) {
    BV_SET(fields, 51);
  }

  differ = (old->nuclearwinter != real_packet->nuclearwinter);
  if (differ) {
    different++;
    BV_SET(fields, 52);
  }

  differ = (old->phase != real_packet->phase);
  if (differ) {
    different++;
    BV_SET(fields, 53);
  }

  differ = (old->phase_mode != real_packet->phase_mode);
  if (differ) {
    different++;
    BV_SET(fields, 54);
  }

  differ = (old->pillage_select != real_packet->pillage_select);
  if(differ) {
    different++;
  }
  if (packet->pillage_select) {
    BV_SET(fields, 55);
  }

  differ = (strcmp(old->positive_year_label, real_packet->positive_year_label) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 56);
  }

  differ = (old->rapturedelay != real_packet->rapturedelay);
  if (differ) {
    different++;
    BV_SET(fields, 57);
  }

  differ = (old->restrictinfra != real_packet->restrictinfra);
  if(differ) {
    different++;
  }
  if (packet->restrictinfra) {
    BV_SET(fields, 58);
  }

  differ = (old->unreachable_protects != real_packet->unreachable_protects);
  if(differ) {
    different++;
  }
  if (packet->unreachable_protects) {
    BV_SET(fields, 59);
  }

  differ = (old->sciencebox != real_packet->sciencebox);
  if (differ) {
    different++;
    BV_SET(fields, 60);
  }

  differ = (old->seconds_to_phasedone != real_packet->seconds_to_phasedone);
  if (differ) {
    different++;
    BV_SET(fields, 61);
  }

  differ = (old->shieldbox != real_packet->shieldbox);
  if (differ) {
    different++;
    BV_SET(fields, 62);
  }

  differ = (old->skill_level != real_packet->skill_level);
  if (differ) {
    different++;
    BV_SET(fields, 63);
  }

  differ = (old->slow_invasions != real_packet->slow_invasions);
  if(differ) {
    different++;
  }
  if (packet->slow_invasions) {
    BV_SET(fields, 64);
  }

  differ = (old->spacerace != real_packet->spacerace);
  if(differ) {
    different++;
  }
  if (packet->spacerace) {
    BV_SET(fields, 65);
  }

  differ = (old->team_pooled_research != real_packet->team_pooled_research);
  if(differ) {
    different++;
  }
  if (packet->team_pooled_research) {
    BV_SET(fields, 66);
  }

  differ = (old->tech != real_packet->tech);
  if (differ) {
    different++;
    BV_SET(fields, 67);
  }

  differ = (old->tech_cost_style != real_packet->tech_cost_style);
  if (differ) {
    different++;
    BV_SET(fields, 68);
  }

  differ = (old->tech_leakage != real_packet->tech_leakage);
  if (differ) {
    different++;
    BV_SET(fields, 69);
  }

  differ = (old->tech_upkeep_divider != real_packet->tech_upkeep_divider);
  if (differ) {
    different++;
    BV_SET(fields, 70);
  }

  differ = (old->tech_upkeep_style != real_packet->tech_upkeep_style);
  if (differ) {
    different++;
    BV_SET(fields, 71);
  }

  differ = (old->timeout != real_packet->timeout);
  if (differ) {
    different++;
    BV_SET(fields, 72);
  }

  differ = (old->tired_attack != real_packet->tired_attack);
  if(differ) {
    different++;
  }
  if (packet->tired_attack) {
    BV_SET(fields, 73);
  }

  differ = (old->trademindist_old != real_packet->trademindist_old);
  if (differ) {
    different++;
    BV_SET(fields, 74);
  }

  differ = (old->trading_city != real_packet->trading_city);
  if(differ) {
    different++;
  }
  if (packet->trading_city) {
    BV_SET(fields, 75);
  }

  differ = (old->trading_gold != real_packet->trading_gold);
  if(differ) {
    different++;
  }
  if (packet->trading_gold) {
    BV_SET(fields, 76);
  }

  differ = (old->trading_tech != real_packet->trading_tech);
  if(differ) {
    different++;
  }
  if (packet->trading_tech) {
    BV_SET(fields, 77);
  }

  differ = (old->turn != real_packet->turn);
  if (differ) {
    different++;
    BV_SET(fields, 78);
  }

  differ = (old->warminglevel != real_packet->warminglevel);
  if (differ) {
    different++;
    BV_SET(fields, 79);
  }

  differ = (old->year != real_packet->year);
  if (differ) {
    different++;
    BV_SET(fields, 80);
  }

  differ = (old->year_0_hack != real_packet->year_0_hack);
  if(differ) {
    different++;
  }
  if (packet->year_0_hack) {
    BV_SET(fields, 81);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'add_to_size_limit' has changed");
    dio_put_uint8(&dout, real_packet->add_to_size_limit);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'aifill' has changed");
    dio_put_uint8(&dout, real_packet->aifill);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'airlifting_style' has changed");
    dio_put_uint8(&dout, real_packet->airlifting_style);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'angrycitizen' has changed");
    dio_put_uint8(&dout, real_packet->angrycitizen);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'base_pollution' has changed");
    dio_put_sint16(&dout, real_packet->base_pollution);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'base_tech_cost' has changed");
    dio_put_uint8(&dout, real_packet->base_tech_cost);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'border_city_radius_sq' has changed");
    dio_put_uint8(&dout, real_packet->border_city_radius_sq);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'border_size_effect' has changed");
    dio_put_uint8(&dout, real_packet->border_size_effect);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'borders' has changed");
    dio_put_uint8(&dout, real_packet->borders);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'base_bribe_cost' has changed");
    dio_put_uint32(&dout, real_packet->base_bribe_cost);
  }
  /* field 10 is folded into the header */
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'celebratesize' has changed");
    dio_put_uint8(&dout, real_packet->celebratesize);
  }
  /* field 12 is folded into the header */
  /* field 13 is folded into the header */
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'citymindist' has changed");
    dio_put_uint8(&dout, real_packet->citymindist);
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'cooling' has changed");
    dio_put_uint32(&dout, real_packet->cooling);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'coolinglevel' has changed");
    dio_put_uint32(&dout, real_packet->coolinglevel);
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'diplomacy' has changed");
    dio_put_uint8(&dout, real_packet->diplomacy);
  }
  /* field 18 is folded into the header */
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'food_cost' has changed");
    dio_put_uint8(&dout, real_packet->food_cost);
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'foodbox' has changed");
    dio_put_uint32(&dout, real_packet->foodbox);
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  field 'forced_gold' has changed");
    dio_put_uint8(&dout, real_packet->forced_gold);
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'forced_luxury' has changed");
    dio_put_uint8(&dout, real_packet->forced_luxury);
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'forced_science' has changed");
    dio_put_uint8(&dout, real_packet->forced_science);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'fulltradesize' has changed");
    dio_put_uint8(&dout, real_packet->fulltradesize);
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  field 'global_advances' has changed");
  
    {
      int i;

      fc_assert(A_LAST < 255);

      for (i = 0; i < A_LAST; i++) {
        if(old->global_advances[i] != real_packet->global_advances[i]) {
          dio_put_uint8(&dout, i);
          dio_put_bool8(&dout, real_packet->global_advances[i]);
        }
      }
      dio_put_uint8(&dout, 255);
    } 
  }
  /* field 26 is folded into the header */
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  field 'globalwarming' has changed");
    dio_put_uint32(&dout, real_packet->globalwarming);
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  field 'gold' has changed");
    dio_put_uint32(&dout, real_packet->gold);
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  field 'gold_upkeep_style' has changed");
    dio_put_uint8(&dout, real_packet->gold_upkeep_style);
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  field 'government_during_revolution_id' has changed");
    dio_put_uint8(&dout, real_packet->government_during_revolution_id);
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  field 'granary_food_inc' has changed");
    dio_put_uint8(&dout, real_packet->granary_food_inc);
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  field 'granary_food_ini' has changed");
  
    {
      int i;

      for (i = 0; i < MAX_GRANARY_INIS; i++) {
        dio_put_uint8(&dout, real_packet->granary_food_ini[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  field 'granary_num_inis' has changed");
    dio_put_uint8(&dout, real_packet->granary_num_inis);
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  field 'great_wonder_owners' has changed");
  
    {
      int i;

      fc_assert(B_LAST < 255);

      for (i = 0; i < B_LAST; i++) {
        if(old->great_wonder_owners[i] != real_packet->great_wonder_owners[i]) {
          dio_put_uint8(&dout, i);
          dio_put_sint8(&dout, real_packet->great_wonder_owners[i]);
        }
      }
      dio_put_uint8(&dout, 255);
    } 
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  field 'happy_cost' has changed");
    dio_put_uint8(&dout, real_packet->happy_cost);
  }
  /* field 36 is folded into the header */
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  field 'heating' has changed");
    dio_put_uint32(&dout, real_packet->heating);
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  field 'illness_base_factor' has changed");
    dio_put_uint8(&dout, real_packet->illness_base_factor);
  }
  if (BV_ISSET(fields, 39)) {
    log_packet_detailed("  field 'illness_min_size' has changed");
    dio_put_uint8(&dout, real_packet->illness_min_size);
  }
  /* field 40 is folded into the header */
  if (BV_ISSET(fields, 41)) {
    log_packet_detailed("  field 'illness_pollution_factor' has changed");
    dio_put_uint8(&dout, real_packet->illness_pollution_factor);
  }
  if (BV_ISSET(fields, 42)) {
    log_packet_detailed("  field 'illness_trade_infection' has changed");
    dio_put_uint8(&dout, real_packet->illness_trade_infection);
  }
  if (BV_ISSET(fields, 43)) {
    log_packet_detailed("  field 'init_city_radius_sq' has changed");
    dio_put_uint8(&dout, real_packet->init_city_radius_sq);
  }
  /* field 44 is folded into the header */
  /* field 45 is folded into the header */
  if (BV_ISSET(fields, 46)) {
    log_packet_detailed("  field 'killcitizen' has changed");
    dio_put_uint8(&dout, real_packet->killcitizen);
  }
  /* field 47 is folded into the header */
  if (BV_ISSET(fields, 48)) {
    log_packet_detailed("  field 'min_city_center_output' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint8(&dout, real_packet->min_city_center_output[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 49)) {
    log_packet_detailed("  field 'negative_year_label' has changed");
    dio_put_string(&dout, real_packet->negative_year_label);
  }
  if (BV_ISSET(fields, 50)) {
    log_packet_detailed("  field 'notradesize' has changed");
    dio_put_uint8(&dout, real_packet->notradesize);
  }
  /* field 51 is folded into the header */
  if (BV_ISSET(fields, 52)) {
    log_packet_detailed("  field 'nuclearwinter' has changed");
    dio_put_uint32(&dout, real_packet->nuclearwinter);
  }
  if (BV_ISSET(fields, 53)) {
    log_packet_detailed("  field 'phase' has changed");
    dio_put_sint16(&dout, real_packet->phase);
  }
  if (BV_ISSET(fields, 54)) {
    log_packet_detailed("  field 'phase_mode' has changed");
    dio_put_uint8(&dout, real_packet->phase_mode);
  }
  /* field 55 is folded into the header */
  if (BV_ISSET(fields, 56)) {
    log_packet_detailed("  field 'positive_year_label' has changed");
    dio_put_string(&dout, real_packet->positive_year_label);
  }
  if (BV_ISSET(fields, 57)) {
    log_packet_detailed("  field 'rapturedelay' has changed");
    dio_put_uint8(&dout, real_packet->rapturedelay);
  }
  /* field 58 is folded into the header */
  /* field 59 is folded into the header */
  if (BV_ISSET(fields, 60)) {
    log_packet_detailed("  field 'sciencebox' has changed");
    dio_put_uint32(&dout, real_packet->sciencebox);
  }
  if (BV_ISSET(fields, 61)) {
    log_packet_detailed("  field 'seconds_to_phasedone' has changed");
    dio_put_uint32(&dout, (int)(real_packet->seconds_to_phasedone * 100));
  }
  if (BV_ISSET(fields, 62)) {
    log_packet_detailed("  field 'shieldbox' has changed");
    dio_put_uint32(&dout, real_packet->shieldbox);
  }
  if (BV_ISSET(fields, 63)) {
    log_packet_detailed("  field 'skill_level' has changed");
    dio_put_uint32(&dout, real_packet->skill_level);
  }
  /* field 64 is folded into the header */
  /* field 65 is folded into the header */
  /* field 66 is folded into the header */
  if (BV_ISSET(fields, 67)) {
    log_packet_detailed("  field 'tech' has changed");
    dio_put_uint32(&dout, real_packet->tech);
  }
  if (BV_ISSET(fields, 68)) {
    log_packet_detailed("  field 'tech_cost_style' has changed");
    dio_put_uint8(&dout, real_packet->tech_cost_style);
  }
  if (BV_ISSET(fields, 69)) {
    log_packet_detailed("  field 'tech_leakage' has changed");
    dio_put_uint8(&dout, real_packet->tech_leakage);
  }
  if (BV_ISSET(fields, 70)) {
    log_packet_detailed("  field 'tech_upkeep_divider' has changed");
    dio_put_uint16(&dout, real_packet->tech_upkeep_divider);
  }
  if (BV_ISSET(fields, 71)) {
    log_packet_detailed("  field 'tech_upkeep_style' has changed");
    dio_put_uint8(&dout, real_packet->tech_upkeep_style);
  }
  if (BV_ISSET(fields, 72)) {
    log_packet_detailed("  field 'timeout' has changed");
    dio_put_uint32(&dout, real_packet->timeout);
  }
  /* field 73 is folded into the header */
  if (BV_ISSET(fields, 74)) {
    log_packet_detailed("  field 'trademindist_old' has changed");
    dio_put_uint8(&dout, real_packet->trademindist_old);
  }
  /* field 75 is folded into the header */
  /* field 76 is folded into the header */
  /* field 77 is folded into the header */
  if (BV_ISSET(fields, 78)) {
    log_packet_detailed("  field 'turn' has changed");
    dio_put_sint16(&dout, real_packet->turn);
  }
  if (BV_ISSET(fields, 79)) {
    log_packet_detailed("  field 'warminglevel' has changed");
    dio_put_uint32(&dout, real_packet->warminglevel);
  }
  if (BV_ISSET(fields, 80)) {
    log_packet_detailed("  field 'year' has changed");
    dio_put_sint16(&dout, real_packet->year);
  }
  /* field 81 is folded into the header */

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_game_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_GAME_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if((has_capability("trademindist_size", pc->capability) && has_capability("trademindist_size", our_capability))) {
    variant = 100;
  } else if(!(has_capability("trademindist_size", pc->capability) && has_capability("trademindist_size", our_capability))) {
    variant = 101;
  } else {
    log_error("Unknown PACKET_GAME_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  log_packet_detailed("packet_game_info: using variant=%d cap=%s", variant, pc->capability);
  pc->phs.variant[PACKET_GAME_INFO] = variant;
}

struct packet_game_info *receive_packet_game_info(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_game_info at the server.");
  }
  ensure_valid_variant_packet_game_info(pc);

  switch(pc->phs.variant[PACKET_GAME_INFO]) {
  case 100:
    return receive_packet_game_info_100(pc, type);
  case 101:
    return receive_packet_game_info_101(pc, type);
  default:
    log_debug("Unknown PACKET_GAME_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_game_info(struct connection *pc, const struct packet_game_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_game_info from the client.");
  }
  ensure_valid_variant_packet_game_info(pc);

  switch(pc->phs.variant[PACKET_GAME_INFO]) {

  case 100:
    return send_packet_game_info_100(pc, packet);
  case 101:
    return send_packet_game_info_101(pc, packet);
  default:
    log_debug("Unknown PACKET_GAME_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
#define hash_packet_map_info_100 hash_const

#define cmp_packet_map_info_100 cmp_const

BV_DEFINE(packet_map_info_100_fields, 3);

static struct packet_map_info *receive_packet_map_info_100(struct connection *pc, enum packet_type type)
{
  packet_map_info_100_fields fields;
  struct packet_map_info *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_map_info, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_map_info_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_map_info_100, cmp_packet_map_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'xsize'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->xsize = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'ysize'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->ysize = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'topology_id'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->topology_id = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_map_info_100(struct connection *pc, const struct packet_map_info *packet)
{
  const struct packet_map_info *real_packet = packet;
  packet_map_info_100_fields fields;
  struct packet_map_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_MAP_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_MAP_INFO);

  log_packet_detailed("packet_map_info_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_map_info_100, cmp_packet_map_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->xsize != real_packet->xsize);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->ysize != real_packet->ysize);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->topology_id != real_packet->topology_id);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'xsize' has changed");
    dio_put_uint16(&dout, real_packet->xsize);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'ysize' has changed");
    dio_put_uint16(&dout, real_packet->ysize);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'topology_id' has changed");
    dio_put_uint8(&dout, real_packet->topology_id);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_map_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_MAP_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_MAP_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_MAP_INFO] = variant;
}

struct packet_map_info *receive_packet_map_info(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_map_info at the server.");
  }
  ensure_valid_variant_packet_map_info(pc);

  switch(pc->phs.variant[PACKET_MAP_INFO]) {
  case 100:
    return receive_packet_map_info_100(pc, type);
  default:
    log_debug("Unknown PACKET_MAP_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_map_info(struct connection *pc, const struct packet_map_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_map_info from the client.");
  }
  ensure_valid_variant_packet_map_info(pc);

  switch(pc->phs.variant[PACKET_MAP_INFO]) {

  case 100:
    return send_packet_map_info_100(pc, packet);
  default:
    log_debug("Unknown PACKET_MAP_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_map_info(struct conn_list *dest, const struct packet_map_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_map_info(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_nuke_tile_info_100 hash_const

#define cmp_packet_nuke_tile_info_100 cmp_const

BV_DEFINE(packet_nuke_tile_info_100_fields, 1);

static struct packet_nuke_tile_info *receive_packet_nuke_tile_info_100(struct connection *pc, enum packet_type type)
{
  packet_nuke_tile_info_100_fields fields;
  struct packet_nuke_tile_info *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_nuke_tile_info, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_nuke_tile_info_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_nuke_tile_info_100, cmp_packet_nuke_tile_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'tile'");
    {
      int readin;
    
      dio_get_sint32(&din, &readin);
      real_packet->tile = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_nuke_tile_info_100(struct connection *pc, const struct packet_nuke_tile_info *packet)
{
  const struct packet_nuke_tile_info *real_packet = packet;
  packet_nuke_tile_info_100_fields fields;
  struct packet_nuke_tile_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_NUKE_TILE_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_NUKE_TILE_INFO);

  log_packet_detailed("packet_nuke_tile_info_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_nuke_tile_info_100, cmp_packet_nuke_tile_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'tile' has changed");
    dio_put_sint32(&dout, real_packet->tile);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_nuke_tile_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_NUKE_TILE_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_NUKE_TILE_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_NUKE_TILE_INFO] = variant;
}

struct packet_nuke_tile_info *receive_packet_nuke_tile_info(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_nuke_tile_info at the server.");
  }
  ensure_valid_variant_packet_nuke_tile_info(pc);

  switch(pc->phs.variant[PACKET_NUKE_TILE_INFO]) {
  case 100:
    return receive_packet_nuke_tile_info_100(pc, type);
  default:
    log_debug("Unknown PACKET_NUKE_TILE_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_nuke_tile_info(struct connection *pc, const struct packet_nuke_tile_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_nuke_tile_info from the client.");
  }
  ensure_valid_variant_packet_nuke_tile_info(pc);

  switch(pc->phs.variant[PACKET_NUKE_TILE_INFO]) {

  case 100:
    return send_packet_nuke_tile_info_100(pc, packet);
  default:
    log_debug("Unknown PACKET_NUKE_TILE_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_nuke_tile_info(struct conn_list *dest, const struct packet_nuke_tile_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_nuke_tile_info(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_nuke_tile_info(struct connection *pc, int tile)
{
  struct packet_nuke_tile_info packet, *real_packet = &packet;

  real_packet->tile = tile;
  
  return send_packet_nuke_tile_info(pc, real_packet);
}

void dlsend_packet_nuke_tile_info(struct conn_list *dest, int tile)
{
  struct packet_nuke_tile_info packet, *real_packet = &packet;

  real_packet->tile = tile;
  
  lsend_packet_nuke_tile_info(dest, real_packet);
}

static genhash_val_t hash_packet_team_name_info_100(const void *vkey, size_t num_buckets)
{
  const struct packet_team_name_info *key = (const struct packet_team_name_info *) vkey;

  return ((key->team_id) % num_buckets);
}

static bool cmp_packet_team_name_info_100(const void *vkey1, const void *vkey2)
{
  const struct packet_team_name_info *key1 = (const struct packet_team_name_info *) vkey1;
  const struct packet_team_name_info *key2 = (const struct packet_team_name_info *) vkey2;

  return key1->team_id == key2->team_id;
}

BV_DEFINE(packet_team_name_info_100_fields, 1);

static struct packet_team_name_info *receive_packet_team_name_info_100(struct connection *pc, enum packet_type type)
{
  packet_team_name_info_100_fields fields;
  struct packet_team_name_info *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_team_name_info, real_packet);

  DIO_BV_GET(&din, fields);
  {
    int readin;
  
    dio_get_uint8(&din, &readin);
    real_packet->team_id = readin;
  }

  log_packet_detailed("packet_team_name_info_100: got info about (%d)",
    real_packet->team_id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_team_name_info_100, cmp_packet_team_name_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int team_id = real_packet->team_id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->team_id = team_id;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'team_name'");
    dio_get_string(&din, real_packet->team_name, sizeof(real_packet->team_name));
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_team_name_info_100(struct connection *pc, const struct packet_team_name_info *packet)
{
  const struct packet_team_name_info *real_packet = packet;
  packet_team_name_info_100_fields fields;
  struct packet_team_name_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_TEAM_NAME_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_TEAM_NAME_INFO);

  log_packet_detailed("packet_team_name_info_100: sending info about (%d)",
    real_packet->team_id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_team_name_info_100, cmp_packet_team_name_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->team_name, real_packet->team_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);
  dio_put_uint8(&dout, real_packet->team_id);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'team_name' has changed");
    dio_put_string(&dout, real_packet->team_name);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_team_name_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_TEAM_NAME_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_TEAM_NAME_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_TEAM_NAME_INFO] = variant;
}

struct packet_team_name_info *receive_packet_team_name_info(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_team_name_info at the server.");
  }
  ensure_valid_variant_packet_team_name_info(pc);

  switch(pc->phs.variant[PACKET_TEAM_NAME_INFO]) {
  case 100:
    return receive_packet_team_name_info_100(pc, type);
  default:
    log_debug("Unknown PACKET_TEAM_NAME_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_team_name_info(struct connection *pc, const struct packet_team_name_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_team_name_info from the client.");
  }
  ensure_valid_variant_packet_team_name_info(pc);

  switch(pc->phs.variant[PACKET_TEAM_NAME_INFO]) {

  case 100:
    return send_packet_team_name_info_100(pc, packet);
  default:
    log_debug("Unknown PACKET_TEAM_NAME_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_team_name_info(struct conn_list *dest, const struct packet_team_name_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_team_name_info(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_chat_msg_100 hash_const

#define cmp_packet_chat_msg_100 cmp_const

BV_DEFINE(packet_chat_msg_100_fields, 4);

static struct packet_chat_msg *receive_packet_chat_msg_100(struct connection *pc, enum packet_type type)
{
  packet_chat_msg_100_fields fields;
  struct packet_chat_msg *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_chat_msg, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_chat_msg_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_chat_msg_100, cmp_packet_chat_msg_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'message'");
    dio_get_string(&din, real_packet->message, sizeof(real_packet->message));
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'tile'");
    {
      int readin;
    
      dio_get_sint32(&din, &readin);
      real_packet->tile = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'event'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->event = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'conn_id'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->conn_id = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_chat_msg_100(struct connection *pc, const struct packet_chat_msg *packet)
{
  const struct packet_chat_msg *real_packet = packet;
  packet_chat_msg_100_fields fields;
  struct packet_chat_msg *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CHAT_MSG;
  int different = 0;
  SEND_PACKET_START(PACKET_CHAT_MSG);

  log_packet_detailed("packet_chat_msg_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_chat_msg_100, cmp_packet_chat_msg_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->message, real_packet->message) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->event != real_packet->event);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->conn_id != real_packet->conn_id);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'message' has changed");
    dio_put_string(&dout, real_packet->message);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'tile' has changed");
    dio_put_sint32(&dout, real_packet->tile);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'event' has changed");
    dio_put_sint16(&dout, real_packet->event);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'conn_id' has changed");
    dio_put_sint16(&dout, real_packet->conn_id);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_chat_msg(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CHAT_MSG] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CHAT_MSG variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CHAT_MSG] = variant;
}

struct packet_chat_msg *receive_packet_chat_msg(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_chat_msg at the server.");
  }
  ensure_valid_variant_packet_chat_msg(pc);

  switch(pc->phs.variant[PACKET_CHAT_MSG]) {
  case 100:
    return receive_packet_chat_msg_100(pc, type);
  default:
    log_debug("Unknown PACKET_CHAT_MSG variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_chat_msg(struct connection *pc, const struct packet_chat_msg *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_chat_msg from the client.");
  }
  ensure_valid_variant_packet_chat_msg(pc);

  switch(pc->phs.variant[PACKET_CHAT_MSG]) {

  case 100:
    return send_packet_chat_msg_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CHAT_MSG variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_chat_msg(struct conn_list *dest, const struct packet_chat_msg *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_chat_msg(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_chat_msg_req_100 hash_const

#define cmp_packet_chat_msg_req_100 cmp_const

BV_DEFINE(packet_chat_msg_req_100_fields, 1);

static struct packet_chat_msg_req *receive_packet_chat_msg_req_100(struct connection *pc, enum packet_type type)
{
  packet_chat_msg_req_100_fields fields;
  struct packet_chat_msg_req *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_chat_msg_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_chat_msg_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_chat_msg_req_100, cmp_packet_chat_msg_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'message'");
    dio_get_string(&din, real_packet->message, sizeof(real_packet->message));
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_chat_msg_req_100(struct connection *pc, const struct packet_chat_msg_req *packet)
{
  const struct packet_chat_msg_req *real_packet = packet;
  packet_chat_msg_req_100_fields fields;
  struct packet_chat_msg_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CHAT_MSG_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_CHAT_MSG_REQ);

  log_packet_detailed("packet_chat_msg_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_chat_msg_req_100, cmp_packet_chat_msg_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->message, real_packet->message) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'message' has changed");
    dio_put_string(&dout, real_packet->message);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_chat_msg_req(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CHAT_MSG_REQ] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CHAT_MSG_REQ variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CHAT_MSG_REQ] = variant;
}

struct packet_chat_msg_req *receive_packet_chat_msg_req(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_chat_msg_req at the client.");
  }
  ensure_valid_variant_packet_chat_msg_req(pc);

  switch(pc->phs.variant[PACKET_CHAT_MSG_REQ]) {
  case 100:
    return receive_packet_chat_msg_req_100(pc, type);
  default:
    log_debug("Unknown PACKET_CHAT_MSG_REQ variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_chat_msg_req(struct connection *pc, const struct packet_chat_msg_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_chat_msg_req from the server.");
  }
  ensure_valid_variant_packet_chat_msg_req(pc);

  switch(pc->phs.variant[PACKET_CHAT_MSG_REQ]) {

  case 100:
    return send_packet_chat_msg_req_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CHAT_MSG_REQ variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_chat_msg_req(struct connection *pc, const char *message)
{
  struct packet_chat_msg_req packet, *real_packet = &packet;

  sz_strlcpy(real_packet->message, message);
  
  return send_packet_chat_msg_req(pc, real_packet);
}

#define hash_packet_connect_msg_100 hash_const

#define cmp_packet_connect_msg_100 cmp_const

BV_DEFINE(packet_connect_msg_100_fields, 1);

static struct packet_connect_msg *receive_packet_connect_msg_100(struct connection *pc, enum packet_type type)
{
  packet_connect_msg_100_fields fields;
  struct packet_connect_msg *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_connect_msg, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_connect_msg_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_connect_msg_100, cmp_packet_connect_msg_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'message'");
    dio_get_string(&din, real_packet->message, sizeof(real_packet->message));
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_connect_msg_100(struct connection *pc, const struct packet_connect_msg *packet)
{
  const struct packet_connect_msg *real_packet = packet;
  packet_connect_msg_100_fields fields;
  struct packet_connect_msg *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CONNECT_MSG;
  int different = 0;
  SEND_PACKET_START(PACKET_CONNECT_MSG);

  log_packet_detailed("packet_connect_msg_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_connect_msg_100, cmp_packet_connect_msg_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->message, real_packet->message) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'message' has changed");
    dio_put_string(&dout, real_packet->message);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_connect_msg(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CONNECT_MSG] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CONNECT_MSG variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CONNECT_MSG] = variant;
}

struct packet_connect_msg *receive_packet_connect_msg(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_connect_msg at the server.");
  }
  ensure_valid_variant_packet_connect_msg(pc);

  switch(pc->phs.variant[PACKET_CONNECT_MSG]) {
  case 100:
    return receive_packet_connect_msg_100(pc, type);
  default:
    log_debug("Unknown PACKET_CONNECT_MSG variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_connect_msg(struct connection *pc, const struct packet_connect_msg *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_connect_msg from the client.");
  }
  ensure_valid_variant_packet_connect_msg(pc);

  switch(pc->phs.variant[PACKET_CONNECT_MSG]) {

  case 100:
    return send_packet_connect_msg_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CONNECT_MSG variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_connect_msg(struct connection *pc, const char *message)
{
  struct packet_connect_msg packet, *real_packet = &packet;

  sz_strlcpy(real_packet->message, message);
  
  return send_packet_connect_msg(pc, real_packet);
}

#define hash_packet_city_remove_100 hash_const

#define cmp_packet_city_remove_100 cmp_const

BV_DEFINE(packet_city_remove_100_fields, 1);

static struct packet_city_remove *receive_packet_city_remove_100(struct connection *pc, enum packet_type type)
{
  packet_city_remove_100_fields fields;
  struct packet_city_remove *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_city_remove, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_remove_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_remove_100, cmp_packet_city_remove_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->city_id = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_CITY_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.received + PACKET_CITY_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_remove_100(struct connection *pc, const struct packet_city_remove *packet)
{
  const struct packet_city_remove *real_packet = packet;
  packet_city_remove_100_fields fields;
  struct packet_city_remove *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_REMOVE;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_REMOVE);

  log_packet_detailed("packet_city_remove_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_remove_100, cmp_packet_city_remove_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    dio_put_uint16(&dout, real_packet->city_id);
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_CITY_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.sent + PACKET_CITY_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_city_remove(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_REMOVE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_REMOVE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_REMOVE] = variant;
}

struct packet_city_remove *receive_packet_city_remove(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_city_remove at the server.");
  }
  ensure_valid_variant_packet_city_remove(pc);

  switch(pc->phs.variant[PACKET_CITY_REMOVE]) {
  case 100:
    return receive_packet_city_remove_100(pc, type);
  default:
    log_debug("Unknown PACKET_CITY_REMOVE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_remove(struct connection *pc, const struct packet_city_remove *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_city_remove from the client.");
  }
  ensure_valid_variant_packet_city_remove(pc);

  switch(pc->phs.variant[PACKET_CITY_REMOVE]) {

  case 100:
    return send_packet_city_remove_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CITY_REMOVE variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_city_remove(struct conn_list *dest, const struct packet_city_remove *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_city_remove(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_city_remove(struct connection *pc, int city_id)
{
  struct packet_city_remove packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  
  return send_packet_city_remove(pc, real_packet);
}

void dlsend_packet_city_remove(struct conn_list *dest, int city_id)
{
  struct packet_city_remove packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  
  lsend_packet_city_remove(dest, real_packet);
}

static genhash_val_t hash_packet_city_info_100(const void *vkey, size_t num_buckets)
{
  const struct packet_city_info *key = (const struct packet_city_info *) vkey;

  return ((key->id) % num_buckets);
}

static bool cmp_packet_city_info_100(const void *vkey1, const void *vkey2)
{
  const struct packet_city_info *key1 = (const struct packet_city_info *) vkey1;
  const struct packet_city_info *key2 = (const struct packet_city_info *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_city_info_100_fields, 45);

static struct packet_city_info *receive_packet_city_info_100(struct connection *pc, enum packet_type type)
{
  packet_city_info_100_fields fields;
  struct packet_city_info *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_city_info, real_packet);

  DIO_BV_GET(&din, fields);
  {
    int readin;
  
    dio_get_uint16(&din, &readin);
    real_packet->id = readin;
  }

  log_packet_detailed("packet_city_info_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_info_100, cmp_packet_city_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'tile'");
    {
      int readin;
    
      dio_get_sint32(&din, &readin);
      real_packet->tile = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'owner'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->owner = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'size'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->size = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'city_radius_sq'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->city_radius_sq = readin;
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'ppl_happy'");
    
    {
      int i;
    
      for (i = 0; i < FEELING_LAST; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->ppl_happy[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'ppl_content'");
    
    {
      int i;
    
      for (i = 0; i < FEELING_LAST; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->ppl_content[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'ppl_unhappy'");
    
    {
      int i;
    
      for (i = 0; i < FEELING_LAST; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->ppl_unhappy[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'ppl_angry'");
    
    {
      int i;
    
      for (i = 0; i < FEELING_LAST; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->ppl_angry[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'specialists_size'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->specialists_size = readin;
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'specialists'");
    
    {
      int i;
    
      if(real_packet->specialists_size > SP_MAX) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->specialists_size = SP_MAX;
      }
      for (i = 0; i < real_packet->specialists_size; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->specialists[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'nationalities_count'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->nationalities_count = readin;
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'nation_id'");
    
    {
      int i;
    
      if(real_packet->nationalities_count > MAX_NUM_PLAYER_SLOTS) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->nationalities_count = MAX_NUM_PLAYER_SLOTS;
      }
      for (i = 0; i < real_packet->nationalities_count; i++) {
        {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->nation_id[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'nation_citizens'");
    
    {
      int i;
    
      if(real_packet->nationalities_count > MAX_NUM_PLAYER_SLOTS) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->nationalities_count = MAX_NUM_PLAYER_SLOTS;
      }
      for (i = 0; i < real_packet->nationalities_count; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->nation_citizens[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'surplus'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->surplus[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'waste'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->waste[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'unhappy_penalty'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->unhappy_penalty[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'prod'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->prod[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'citizen_base'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->citizen_base[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'usage'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->usage[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'food_stock'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->food_stock = readin;
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'shield_stock'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->shield_stock = readin;
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  got field 'trade'");
    
    {
      int i;
    
      for (i = 0; i < NUM_TRADE_ROUTES; i++) {
        {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->trade[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'trade_value'");
    
    {
      int i;
    
      for (i = 0; i < NUM_TRADE_ROUTES; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->trade_value[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'pollution'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->pollution = readin;
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'illness_trade'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->illness_trade = readin;
    }
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  got field 'production_kind'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->production_kind = readin;
    }
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  got field 'production_value'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->production_value = readin;
    }
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  got field 'turn_founded'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->turn_founded = readin;
    }
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  got field 'turn_last_built'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->turn_last_built = readin;
    }
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  got field 'changed_from_kind'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->changed_from_kind = readin;
    }
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  got field 'changed_from_value'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->changed_from_value = readin;
    }
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  got field 'before_change_shields'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->before_change_shields = readin;
    }
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  got field 'disbanded_shields'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->disbanded_shields = readin;
    }
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  got field 'caravan_shields'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->caravan_shields = readin;
    }
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  got field 'last_turns_shield_surplus'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->last_turns_shield_surplus = readin;
    }
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  got field 'airlift'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->airlift = readin;
    }
  }
  real_packet->did_buy = BV_ISSET(fields, 36);
  real_packet->did_sell = BV_ISSET(fields, 37);
  real_packet->was_happy = BV_ISSET(fields, 38);
  real_packet->diplomat_investigate = BV_ISSET(fields, 39);
  real_packet->walls = BV_ISSET(fields, 40);
  if (BV_ISSET(fields, 41)) {
    log_packet_detailed("  got field 'worklist'");
    dio_get_worklist(&din, &real_packet->worklist);
  }
  if (BV_ISSET(fields, 42)) {
    log_packet_detailed("  got field 'improvements'");
    DIO_BV_GET(&din, real_packet->improvements);
  }
  if (BV_ISSET(fields, 43)) {
    log_packet_detailed("  got field 'city_options'");
    DIO_BV_GET(&din, real_packet->city_options);
  }
  if (BV_ISSET(fields, 44)) {
    log_packet_detailed("  got field 'name'");
    dio_get_string(&din, real_packet->name, sizeof(real_packet->name));
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_CITY_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_info_100(struct connection *pc, const struct packet_city_info *packet, bool force_to_send)
{
  const struct packet_city_info *real_packet = packet;
  packet_city_info_100_fields fields;
  struct packet_city_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_INFO;
  int different = force_to_send;
  SEND_PACKET_START(PACKET_CITY_INFO);

  log_packet_detailed("packet_city_info_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_info_100, cmp_packet_city_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->owner != real_packet->owner);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->size != real_packet->size);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->city_radius_sq != real_packet->city_radius_sq);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


    {
      differ = (FEELING_LAST != FEELING_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < FEELING_LAST; i++) {
          if (old->ppl_happy[i] != real_packet->ppl_happy[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }


    {
      differ = (FEELING_LAST != FEELING_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < FEELING_LAST; i++) {
          if (old->ppl_content[i] != real_packet->ppl_content[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


    {
      differ = (FEELING_LAST != FEELING_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < FEELING_LAST; i++) {
          if (old->ppl_unhappy[i] != real_packet->ppl_unhappy[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }


    {
      differ = (FEELING_LAST != FEELING_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < FEELING_LAST; i++) {
          if (old->ppl_angry[i] != real_packet->ppl_angry[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->specialists_size != real_packet->specialists_size);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }


    {
      differ = (old->specialists_size != real_packet->specialists_size);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->specialists_size; i++) {
          if (old->specialists[i] != real_packet->specialists[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->nationalities_count != real_packet->nationalities_count);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }


    {
      differ = (old->nationalities_count != real_packet->nationalities_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->nationalities_count; i++) {
          if (old->nation_id[i] != real_packet->nation_id[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }


    {
      differ = (old->nationalities_count != real_packet->nationalities_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->nationalities_count; i++) {
          if (old->nation_citizens[i] != real_packet->nation_citizens[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->surplus[i] != real_packet->surplus[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->waste[i] != real_packet->waste[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->unhappy_penalty[i] != real_packet->unhappy_penalty[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->prod[i] != real_packet->prod[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->citizen_base[i] != real_packet->citizen_base[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->usage[i] != real_packet->usage[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }

  differ = (old->food_stock != real_packet->food_stock);
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }

  differ = (old->shield_stock != real_packet->shield_stock);
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }


    {
      differ = (NUM_TRADE_ROUTES != NUM_TRADE_ROUTES);
      if(!differ) {
        int i;
        for (i = 0; i < NUM_TRADE_ROUTES; i++) {
          if (old->trade[i] != real_packet->trade[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 21);
  }


    {
      differ = (NUM_TRADE_ROUTES != NUM_TRADE_ROUTES);
      if(!differ) {
        int i;
        for (i = 0; i < NUM_TRADE_ROUTES; i++) {
          if (old->trade_value[i] != real_packet->trade_value[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (old->pollution != real_packet->pollution);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }

  differ = (old->illness_trade != real_packet->illness_trade);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }

  differ = (old->production_kind != real_packet->production_kind);
  if (differ) {
    different++;
    BV_SET(fields, 25);
  }

  differ = (old->production_value != real_packet->production_value);
  if (differ) {
    different++;
    BV_SET(fields, 26);
  }

  differ = (old->turn_founded != real_packet->turn_founded);
  if (differ) {
    different++;
    BV_SET(fields, 27);
  }

  differ = (old->turn_last_built != real_packet->turn_last_built);
  if (differ) {
    different++;
    BV_SET(fields, 28);
  }

  differ = (old->changed_from_kind != real_packet->changed_from_kind);
  if (differ) {
    different++;
    BV_SET(fields, 29);
  }

  differ = (old->changed_from_value != real_packet->changed_from_value);
  if (differ) {
    different++;
    BV_SET(fields, 30);
  }

  differ = (old->before_change_shields != real_packet->before_change_shields);
  if (differ) {
    different++;
    BV_SET(fields, 31);
  }

  differ = (old->disbanded_shields != real_packet->disbanded_shields);
  if (differ) {
    different++;
    BV_SET(fields, 32);
  }

  differ = (old->caravan_shields != real_packet->caravan_shields);
  if (differ) {
    different++;
    BV_SET(fields, 33);
  }

  differ = (old->last_turns_shield_surplus != real_packet->last_turns_shield_surplus);
  if (differ) {
    different++;
    BV_SET(fields, 34);
  }

  differ = (old->airlift != real_packet->airlift);
  if (differ) {
    different++;
    BV_SET(fields, 35);
  }

  differ = (old->did_buy != real_packet->did_buy);
  if(differ) {
    different++;
  }
  if (packet->did_buy) {
    BV_SET(fields, 36);
  }

  differ = (old->did_sell != real_packet->did_sell);
  if(differ) {
    different++;
  }
  if (packet->did_sell) {
    BV_SET(fields, 37);
  }

  differ = (old->was_happy != real_packet->was_happy);
  if(differ) {
    different++;
  }
  if (packet->was_happy) {
    BV_SET(fields, 38);
  }

  differ = (old->diplomat_investigate != real_packet->diplomat_investigate);
  if(differ) {
    different++;
  }
  if (packet->diplomat_investigate) {
    BV_SET(fields, 39);
  }

  differ = (old->walls != real_packet->walls);
  if(differ) {
    different++;
  }
  if (packet->walls) {
    BV_SET(fields, 40);
  }

  differ = !are_worklists_equal(&old->worklist, &real_packet->worklist);
  if (differ) {
    different++;
    BV_SET(fields, 41);
  }

  differ = !BV_ARE_EQUAL(old->improvements, real_packet->improvements);
  if (differ) {
    different++;
    BV_SET(fields, 42);
  }

  differ = !BV_ARE_EQUAL(old->city_options, real_packet->city_options);
  if (differ) {
    different++;
    BV_SET(fields, 43);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 44);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, fields);
  dio_put_uint16(&dout, real_packet->id);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'tile' has changed");
    dio_put_sint32(&dout, real_packet->tile);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'owner' has changed");
    dio_put_sint8(&dout, real_packet->owner);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'size' has changed");
    dio_put_uint8(&dout, real_packet->size);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'city_radius_sq' has changed");
    dio_put_uint8(&dout, real_packet->city_radius_sq);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'ppl_happy' has changed");
  
    {
      int i;

      for (i = 0; i < FEELING_LAST; i++) {
        dio_put_uint8(&dout, real_packet->ppl_happy[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'ppl_content' has changed");
  
    {
      int i;

      for (i = 0; i < FEELING_LAST; i++) {
        dio_put_uint8(&dout, real_packet->ppl_content[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'ppl_unhappy' has changed");
  
    {
      int i;

      for (i = 0; i < FEELING_LAST; i++) {
        dio_put_uint8(&dout, real_packet->ppl_unhappy[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'ppl_angry' has changed");
  
    {
      int i;

      for (i = 0; i < FEELING_LAST; i++) {
        dio_put_uint8(&dout, real_packet->ppl_angry[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'specialists_size' has changed");
    dio_put_uint8(&dout, real_packet->specialists_size);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'specialists' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->specialists_size; i++) {
        dio_put_uint8(&dout, real_packet->specialists[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'nationalities_count' has changed");
    dio_put_uint8(&dout, real_packet->nationalities_count);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'nation_id' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->nationalities_count; i++) {
        dio_put_sint8(&dout, real_packet->nation_id[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'nation_citizens' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->nationalities_count; i++) {
        dio_put_uint8(&dout, real_packet->nation_citizens[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'surplus' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_sint16(&dout, real_packet->surplus[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'waste' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint16(&dout, real_packet->waste[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'unhappy_penalty' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_sint16(&dout, real_packet->unhappy_penalty[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'prod' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint16(&dout, real_packet->prod[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'citizen_base' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_sint16(&dout, real_packet->citizen_base[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'usage' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_sint16(&dout, real_packet->usage[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'food_stock' has changed");
    dio_put_uint16(&dout, real_packet->food_stock);
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'shield_stock' has changed");
    dio_put_uint16(&dout, real_packet->shield_stock);
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  field 'trade' has changed");
  
    {
      int i;

      for (i = 0; i < NUM_TRADE_ROUTES; i++) {
        dio_put_uint16(&dout, real_packet->trade[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'trade_value' has changed");
  
    {
      int i;

      for (i = 0; i < NUM_TRADE_ROUTES; i++) {
        dio_put_uint8(&dout, real_packet->trade_value[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'pollution' has changed");
    dio_put_uint16(&dout, real_packet->pollution);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'illness_trade' has changed");
    dio_put_uint16(&dout, real_packet->illness_trade);
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  field 'production_kind' has changed");
    dio_put_uint8(&dout, real_packet->production_kind);
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  field 'production_value' has changed");
    dio_put_uint8(&dout, real_packet->production_value);
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  field 'turn_founded' has changed");
    dio_put_sint16(&dout, real_packet->turn_founded);
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  field 'turn_last_built' has changed");
    dio_put_sint16(&dout, real_packet->turn_last_built);
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  field 'changed_from_kind' has changed");
    dio_put_uint8(&dout, real_packet->changed_from_kind);
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  field 'changed_from_value' has changed");
    dio_put_uint8(&dout, real_packet->changed_from_value);
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  field 'before_change_shields' has changed");
    dio_put_uint16(&dout, real_packet->before_change_shields);
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  field 'disbanded_shields' has changed");
    dio_put_uint16(&dout, real_packet->disbanded_shields);
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  field 'caravan_shields' has changed");
    dio_put_uint16(&dout, real_packet->caravan_shields);
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  field 'last_turns_shield_surplus' has changed");
    dio_put_uint16(&dout, real_packet->last_turns_shield_surplus);
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  field 'airlift' has changed");
    dio_put_uint8(&dout, real_packet->airlift);
  }
  /* field 36 is folded into the header */
  /* field 37 is folded into the header */
  /* field 38 is folded into the header */
  /* field 39 is folded into the header */
  /* field 40 is folded into the header */
  if (BV_ISSET(fields, 41)) {
    log_packet_detailed("  field 'worklist' has changed");
    dio_put_worklist(&dout, &real_packet->worklist);
  }
  if (BV_ISSET(fields, 42)) {
    log_packet_detailed("  field 'improvements' has changed");
  DIO_BV_PUT(&dout, packet->improvements);
  }
  if (BV_ISSET(fields, 43)) {
    log_packet_detailed("  field 'city_options' has changed");
  DIO_BV_PUT(&dout, packet->city_options);
  }
  if (BV_ISSET(fields, 44)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_CITY_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_city_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_INFO] = variant;
}

struct packet_city_info *receive_packet_city_info(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_city_info at the server.");
  }
  ensure_valid_variant_packet_city_info(pc);

  switch(pc->phs.variant[PACKET_CITY_INFO]) {
  case 100:
    return receive_packet_city_info_100(pc, type);
  default:
    log_debug("Unknown PACKET_CITY_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_info(struct connection *pc, const struct packet_city_info *packet, bool force_to_send)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_city_info from the client.");
  }
  ensure_valid_variant_packet_city_info(pc);

  switch(pc->phs.variant[PACKET_CITY_INFO]) {

  case 100:
    return send_packet_city_info_100(pc, packet, force_to_send);
  default:
    log_debug("Unknown PACKET_CITY_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_city_info(struct conn_list *dest, const struct packet_city_info *packet, bool force_to_send)
{
  conn_list_iterate(dest, pconn) {
    send_packet_city_info(pconn, packet, force_to_send);
  } conn_list_iterate_end;
}

static genhash_val_t hash_packet_city_short_info_100(const void *vkey, size_t num_buckets)
{
  const struct packet_city_short_info *key = (const struct packet_city_short_info *) vkey;

  return ((key->id) % num_buckets);
}

static bool cmp_packet_city_short_info_100(const void *vkey1, const void *vkey2)
{
  const struct packet_city_short_info *key1 = (const struct packet_city_short_info *) vkey1;
  const struct packet_city_short_info *key2 = (const struct packet_city_short_info *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_city_short_info_100_fields, 9);

static struct packet_city_short_info *receive_packet_city_short_info_100(struct connection *pc, enum packet_type type)
{
  packet_city_short_info_100_fields fields;
  struct packet_city_short_info *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_city_short_info, real_packet);

  DIO_BV_GET(&din, fields);
  {
    int readin;
  
    dio_get_uint16(&din, &readin);
    real_packet->id = readin;
  }

  log_packet_detailed("packet_city_short_info_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_short_info_100, cmp_packet_city_short_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'tile'");
    {
      int readin;
    
      dio_get_sint32(&din, &readin);
      real_packet->tile = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'owner'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->owner = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'size'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->size = readin;
    }
  }
  real_packet->occupied = BV_ISSET(fields, 3);
  real_packet->walls = BV_ISSET(fields, 4);
  real_packet->happy = BV_ISSET(fields, 5);
  real_packet->unhappy = BV_ISSET(fields, 6);
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'improvements'");
    DIO_BV_GET(&din, real_packet->improvements);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'name'");
    dio_get_string(&din, real_packet->name, sizeof(real_packet->name));
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_CITY_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_short_info_100(struct connection *pc, const struct packet_city_short_info *packet)
{
  const struct packet_city_short_info *real_packet = packet;
  packet_city_short_info_100_fields fields;
  struct packet_city_short_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_SHORT_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_SHORT_INFO);

  log_packet_detailed("packet_city_short_info_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_short_info_100, cmp_packet_city_short_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->owner != real_packet->owner);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->size != real_packet->size);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->occupied != real_packet->occupied);
  if(differ) {
    different++;
  }
  if (packet->occupied) {
    BV_SET(fields, 3);
  }

  differ = (old->walls != real_packet->walls);
  if(differ) {
    different++;
  }
  if (packet->walls) {
    BV_SET(fields, 4);
  }

  differ = (old->happy != real_packet->happy);
  if(differ) {
    different++;
  }
  if (packet->happy) {
    BV_SET(fields, 5);
  }

  differ = (old->unhappy != real_packet->unhappy);
  if(differ) {
    different++;
  }
  if (packet->unhappy) {
    BV_SET(fields, 6);
  }

  differ = !BV_ARE_EQUAL(old->improvements, real_packet->improvements);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, fields);
  dio_put_uint16(&dout, real_packet->id);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'tile' has changed");
    dio_put_sint32(&dout, real_packet->tile);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'owner' has changed");
    dio_put_sint8(&dout, real_packet->owner);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'size' has changed");
    dio_put_uint8(&dout, real_packet->size);
  }
  /* field 3 is folded into the header */
  /* field 4 is folded into the header */
  /* field 5 is folded into the header */
  /* field 6 is folded into the header */
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'improvements' has changed");
  DIO_BV_PUT(&dout, packet->improvements);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_CITY_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_city_short_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_SHORT_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_SHORT_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_SHORT_INFO] = variant;
}

struct packet_city_short_info *receive_packet_city_short_info(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_city_short_info at the server.");
  }
  ensure_valid_variant_packet_city_short_info(pc);

  switch(pc->phs.variant[PACKET_CITY_SHORT_INFO]) {
  case 100:
    return receive_packet_city_short_info_100(pc, type);
  default:
    log_debug("Unknown PACKET_CITY_SHORT_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_short_info(struct connection *pc, const struct packet_city_short_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_city_short_info from the client.");
  }
  ensure_valid_variant_packet_city_short_info(pc);

  switch(pc->phs.variant[PACKET_CITY_SHORT_INFO]) {

  case 100:
    return send_packet_city_short_info_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CITY_SHORT_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_city_short_info(struct conn_list *dest, const struct packet_city_short_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_city_short_info(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_city_sell_100 hash_const

#define cmp_packet_city_sell_100 cmp_const

BV_DEFINE(packet_city_sell_100_fields, 2);

static struct packet_city_sell *receive_packet_city_sell_100(struct connection *pc, enum packet_type type)
{
  packet_city_sell_100_fields fields;
  struct packet_city_sell *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_city_sell, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_sell_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_sell_100, cmp_packet_city_sell_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->city_id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'build_id'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->build_id = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_sell_100(struct connection *pc, const struct packet_city_sell *packet)
{
  const struct packet_city_sell *real_packet = packet;
  packet_city_sell_100_fields fields;
  struct packet_city_sell *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_SELL;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_SELL);

  log_packet_detailed("packet_city_sell_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_sell_100, cmp_packet_city_sell_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->build_id != real_packet->build_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    dio_put_uint16(&dout, real_packet->city_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'build_id' has changed");
    dio_put_uint8(&dout, real_packet->build_id);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_city_sell(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_SELL] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_SELL variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_SELL] = variant;
}

struct packet_city_sell *receive_packet_city_sell(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_city_sell at the client.");
  }
  ensure_valid_variant_packet_city_sell(pc);

  switch(pc->phs.variant[PACKET_CITY_SELL]) {
  case 100:
    return receive_packet_city_sell_100(pc, type);
  default:
    log_debug("Unknown PACKET_CITY_SELL variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_sell(struct connection *pc, const struct packet_city_sell *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_city_sell from the server.");
  }
  ensure_valid_variant_packet_city_sell(pc);

  switch(pc->phs.variant[PACKET_CITY_SELL]) {

  case 100:
    return send_packet_city_sell_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CITY_SELL variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_city_sell(struct connection *pc, int city_id, int build_id)
{
  struct packet_city_sell packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  real_packet->build_id = build_id;
  
  return send_packet_city_sell(pc, real_packet);
}

#define hash_packet_city_buy_100 hash_const

#define cmp_packet_city_buy_100 cmp_const

BV_DEFINE(packet_city_buy_100_fields, 1);

static struct packet_city_buy *receive_packet_city_buy_100(struct connection *pc, enum packet_type type)
{
  packet_city_buy_100_fields fields;
  struct packet_city_buy *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_city_buy, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_buy_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_buy_100, cmp_packet_city_buy_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->city_id = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_buy_100(struct connection *pc, const struct packet_city_buy *packet)
{
  const struct packet_city_buy *real_packet = packet;
  packet_city_buy_100_fields fields;
  struct packet_city_buy *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_BUY;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_BUY);

  log_packet_detailed("packet_city_buy_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_buy_100, cmp_packet_city_buy_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    dio_put_uint16(&dout, real_packet->city_id);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_city_buy(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_BUY] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_BUY variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_BUY] = variant;
}

struct packet_city_buy *receive_packet_city_buy(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_city_buy at the client.");
  }
  ensure_valid_variant_packet_city_buy(pc);

  switch(pc->phs.variant[PACKET_CITY_BUY]) {
  case 100:
    return receive_packet_city_buy_100(pc, type);
  default:
    log_debug("Unknown PACKET_CITY_BUY variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_buy(struct connection *pc, const struct packet_city_buy *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_city_buy from the server.");
  }
  ensure_valid_variant_packet_city_buy(pc);

  switch(pc->phs.variant[PACKET_CITY_BUY]) {

  case 100:
    return send_packet_city_buy_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CITY_BUY variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_city_buy(struct connection *pc, int city_id)
{
  struct packet_city_buy packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  
  return send_packet_city_buy(pc, real_packet);
}

#define hash_packet_city_change_100 hash_const

#define cmp_packet_city_change_100 cmp_const

BV_DEFINE(packet_city_change_100_fields, 3);

static struct packet_city_change *receive_packet_city_change_100(struct connection *pc, enum packet_type type)
{
  packet_city_change_100_fields fields;
  struct packet_city_change *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_city_change, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_change_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_change_100, cmp_packet_city_change_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->city_id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'production_kind'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->production_kind = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'production_value'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->production_value = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_change_100(struct connection *pc, const struct packet_city_change *packet)
{
  const struct packet_city_change *real_packet = packet;
  packet_city_change_100_fields fields;
  struct packet_city_change *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_CHANGE;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_CHANGE);

  log_packet_detailed("packet_city_change_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_change_100, cmp_packet_city_change_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->production_kind != real_packet->production_kind);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->production_value != real_packet->production_value);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    dio_put_uint16(&dout, real_packet->city_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'production_kind' has changed");
    dio_put_uint8(&dout, real_packet->production_kind);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'production_value' has changed");
    dio_put_uint8(&dout, real_packet->production_value);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_city_change(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_CHANGE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_CHANGE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_CHANGE] = variant;
}

struct packet_city_change *receive_packet_city_change(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_city_change at the client.");
  }
  ensure_valid_variant_packet_city_change(pc);

  switch(pc->phs.variant[PACKET_CITY_CHANGE]) {
  case 100:
    return receive_packet_city_change_100(pc, type);
  default:
    log_debug("Unknown PACKET_CITY_CHANGE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_change(struct connection *pc, const struct packet_city_change *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_city_change from the server.");
  }
  ensure_valid_variant_packet_city_change(pc);

  switch(pc->phs.variant[PACKET_CITY_CHANGE]) {

  case 100:
    return send_packet_city_change_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CITY_CHANGE variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_city_change(struct connection *pc, int city_id, int production_kind, int production_value)
{
  struct packet_city_change packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  real_packet->production_kind = production_kind;
  real_packet->production_value = production_value;
  
  return send_packet_city_change(pc, real_packet);
}

#define hash_packet_city_worklist_100 hash_const

#define cmp_packet_city_worklist_100 cmp_const

BV_DEFINE(packet_city_worklist_100_fields, 2);

static struct packet_city_worklist *receive_packet_city_worklist_100(struct connection *pc, enum packet_type type)
{
  packet_city_worklist_100_fields fields;
  struct packet_city_worklist *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_city_worklist, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_worklist_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_worklist_100, cmp_packet_city_worklist_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->city_id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'worklist'");
    dio_get_worklist(&din, &real_packet->worklist);
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_worklist_100(struct connection *pc, const struct packet_city_worklist *packet)
{
  const struct packet_city_worklist *real_packet = packet;
  packet_city_worklist_100_fields fields;
  struct packet_city_worklist *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_WORKLIST;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_WORKLIST);

  log_packet_detailed("packet_city_worklist_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_worklist_100, cmp_packet_city_worklist_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = !are_worklists_equal(&old->worklist, &real_packet->worklist);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    dio_put_uint16(&dout, real_packet->city_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'worklist' has changed");
    dio_put_worklist(&dout, &real_packet->worklist);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_city_worklist(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_WORKLIST] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_WORKLIST variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_WORKLIST] = variant;
}

struct packet_city_worklist *receive_packet_city_worklist(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_city_worklist at the client.");
  }
  ensure_valid_variant_packet_city_worklist(pc);

  switch(pc->phs.variant[PACKET_CITY_WORKLIST]) {
  case 100:
    return receive_packet_city_worklist_100(pc, type);
  default:
    log_debug("Unknown PACKET_CITY_WORKLIST variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_worklist(struct connection *pc, const struct packet_city_worklist *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_city_worklist from the server.");
  }
  ensure_valid_variant_packet_city_worklist(pc);

  switch(pc->phs.variant[PACKET_CITY_WORKLIST]) {

  case 100:
    return send_packet_city_worklist_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CITY_WORKLIST variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_city_worklist(struct connection *pc, int city_id, const struct worklist *worklist)
{
  struct packet_city_worklist packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  worklist_copy(&real_packet->worklist, worklist);
  
  return send_packet_city_worklist(pc, real_packet);
}

#define hash_packet_city_make_specialist_100 hash_const

#define cmp_packet_city_make_specialist_100 cmp_const

BV_DEFINE(packet_city_make_specialist_100_fields, 3);

static struct packet_city_make_specialist *receive_packet_city_make_specialist_100(struct connection *pc, enum packet_type type)
{
  packet_city_make_specialist_100_fields fields;
  struct packet_city_make_specialist *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_city_make_specialist, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_make_specialist_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_make_specialist_100, cmp_packet_city_make_specialist_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->city_id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'worker_x'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->worker_x = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'worker_y'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->worker_y = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_make_specialist_100(struct connection *pc, const struct packet_city_make_specialist *packet)
{
  const struct packet_city_make_specialist *real_packet = packet;
  packet_city_make_specialist_100_fields fields;
  struct packet_city_make_specialist *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_MAKE_SPECIALIST;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_MAKE_SPECIALIST);

  log_packet_detailed("packet_city_make_specialist_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_make_specialist_100, cmp_packet_city_make_specialist_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->worker_x != real_packet->worker_x);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->worker_y != real_packet->worker_y);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    dio_put_uint16(&dout, real_packet->city_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'worker_x' has changed");
    dio_put_uint8(&dout, real_packet->worker_x);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'worker_y' has changed");
    dio_put_uint8(&dout, real_packet->worker_y);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_city_make_specialist(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_MAKE_SPECIALIST] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_MAKE_SPECIALIST variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_MAKE_SPECIALIST] = variant;
}

struct packet_city_make_specialist *receive_packet_city_make_specialist(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_city_make_specialist at the client.");
  }
  ensure_valid_variant_packet_city_make_specialist(pc);

  switch(pc->phs.variant[PACKET_CITY_MAKE_SPECIALIST]) {
  case 100:
    return receive_packet_city_make_specialist_100(pc, type);
  default:
    log_debug("Unknown PACKET_CITY_MAKE_SPECIALIST variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_make_specialist(struct connection *pc, const struct packet_city_make_specialist *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_city_make_specialist from the server.");
  }
  ensure_valid_variant_packet_city_make_specialist(pc);

  switch(pc->phs.variant[PACKET_CITY_MAKE_SPECIALIST]) {

  case 100:
    return send_packet_city_make_specialist_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CITY_MAKE_SPECIALIST variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_city_make_specialist(struct connection *pc, int city_id, int worker_x, int worker_y)
{
  struct packet_city_make_specialist packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  real_packet->worker_x = worker_x;
  real_packet->worker_y = worker_y;
  
  return send_packet_city_make_specialist(pc, real_packet);
}

#define hash_packet_city_make_worker_100 hash_const

#define cmp_packet_city_make_worker_100 cmp_const

BV_DEFINE(packet_city_make_worker_100_fields, 3);

static struct packet_city_make_worker *receive_packet_city_make_worker_100(struct connection *pc, enum packet_type type)
{
  packet_city_make_worker_100_fields fields;
  struct packet_city_make_worker *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_city_make_worker, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_make_worker_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_make_worker_100, cmp_packet_city_make_worker_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->city_id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'worker_x'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->worker_x = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'worker_y'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->worker_y = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_make_worker_100(struct connection *pc, const struct packet_city_make_worker *packet)
{
  const struct packet_city_make_worker *real_packet = packet;
  packet_city_make_worker_100_fields fields;
  struct packet_city_make_worker *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_MAKE_WORKER;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_MAKE_WORKER);

  log_packet_detailed("packet_city_make_worker_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_make_worker_100, cmp_packet_city_make_worker_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->worker_x != real_packet->worker_x);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->worker_y != real_packet->worker_y);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    dio_put_uint16(&dout, real_packet->city_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'worker_x' has changed");
    dio_put_uint8(&dout, real_packet->worker_x);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'worker_y' has changed");
    dio_put_uint8(&dout, real_packet->worker_y);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_city_make_worker(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_MAKE_WORKER] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_MAKE_WORKER variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_MAKE_WORKER] = variant;
}

struct packet_city_make_worker *receive_packet_city_make_worker(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_city_make_worker at the client.");
  }
  ensure_valid_variant_packet_city_make_worker(pc);

  switch(pc->phs.variant[PACKET_CITY_MAKE_WORKER]) {
  case 100:
    return receive_packet_city_make_worker_100(pc, type);
  default:
    log_debug("Unknown PACKET_CITY_MAKE_WORKER variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_make_worker(struct connection *pc, const struct packet_city_make_worker *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_city_make_worker from the server.");
  }
  ensure_valid_variant_packet_city_make_worker(pc);

  switch(pc->phs.variant[PACKET_CITY_MAKE_WORKER]) {

  case 100:
    return send_packet_city_make_worker_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CITY_MAKE_WORKER variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_city_make_worker(struct connection *pc, int city_id, int worker_x, int worker_y)
{
  struct packet_city_make_worker packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  real_packet->worker_x = worker_x;
  real_packet->worker_y = worker_y;
  
  return send_packet_city_make_worker(pc, real_packet);
}

#define hash_packet_city_change_specialist_100 hash_const

#define cmp_packet_city_change_specialist_100 cmp_const

BV_DEFINE(packet_city_change_specialist_100_fields, 3);

static struct packet_city_change_specialist *receive_packet_city_change_specialist_100(struct connection *pc, enum packet_type type)
{
  packet_city_change_specialist_100_fields fields;
  struct packet_city_change_specialist *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_city_change_specialist, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_change_specialist_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_change_specialist_100, cmp_packet_city_change_specialist_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->city_id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'from'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->from = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'to'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->to = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_change_specialist_100(struct connection *pc, const struct packet_city_change_specialist *packet)
{
  const struct packet_city_change_specialist *real_packet = packet;
  packet_city_change_specialist_100_fields fields;
  struct packet_city_change_specialist *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_CHANGE_SPECIALIST;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_CHANGE_SPECIALIST);

  log_packet_detailed("packet_city_change_specialist_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_change_specialist_100, cmp_packet_city_change_specialist_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->from != real_packet->from);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->to != real_packet->to);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    dio_put_uint16(&dout, real_packet->city_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'from' has changed");
    dio_put_uint8(&dout, real_packet->from);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'to' has changed");
    dio_put_uint8(&dout, real_packet->to);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_city_change_specialist(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_CHANGE_SPECIALIST] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_CHANGE_SPECIALIST variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_CHANGE_SPECIALIST] = variant;
}

struct packet_city_change_specialist *receive_packet_city_change_specialist(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_city_change_specialist at the client.");
  }
  ensure_valid_variant_packet_city_change_specialist(pc);

  switch(pc->phs.variant[PACKET_CITY_CHANGE_SPECIALIST]) {
  case 100:
    return receive_packet_city_change_specialist_100(pc, type);
  default:
    log_debug("Unknown PACKET_CITY_CHANGE_SPECIALIST variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_change_specialist(struct connection *pc, const struct packet_city_change_specialist *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_city_change_specialist from the server.");
  }
  ensure_valid_variant_packet_city_change_specialist(pc);

  switch(pc->phs.variant[PACKET_CITY_CHANGE_SPECIALIST]) {

  case 100:
    return send_packet_city_change_specialist_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CITY_CHANGE_SPECIALIST variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_city_change_specialist(struct connection *pc, int city_id, Specialist_type_id from, Specialist_type_id to)
{
  struct packet_city_change_specialist packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  real_packet->from = from;
  real_packet->to = to;
  
  return send_packet_city_change_specialist(pc, real_packet);
}

#define hash_packet_city_rename_100 hash_const

#define cmp_packet_city_rename_100 cmp_const

BV_DEFINE(packet_city_rename_100_fields, 2);

static struct packet_city_rename *receive_packet_city_rename_100(struct connection *pc, enum packet_type type)
{
  packet_city_rename_100_fields fields;
  struct packet_city_rename *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_city_rename, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_rename_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_rename_100, cmp_packet_city_rename_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->city_id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    dio_get_string(&din, real_packet->name, sizeof(real_packet->name));
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_rename_100(struct connection *pc, const struct packet_city_rename *packet)
{
  const struct packet_city_rename *real_packet = packet;
  packet_city_rename_100_fields fields;
  struct packet_city_rename *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_RENAME;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_RENAME);

  log_packet_detailed("packet_city_rename_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_rename_100, cmp_packet_city_rename_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    dio_put_uint16(&dout, real_packet->city_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_city_rename(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_RENAME] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_RENAME variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_RENAME] = variant;
}

struct packet_city_rename *receive_packet_city_rename(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_city_rename at the client.");
  }
  ensure_valid_variant_packet_city_rename(pc);

  switch(pc->phs.variant[PACKET_CITY_RENAME]) {
  case 100:
    return receive_packet_city_rename_100(pc, type);
  default:
    log_debug("Unknown PACKET_CITY_RENAME variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_rename(struct connection *pc, const struct packet_city_rename *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_city_rename from the server.");
  }
  ensure_valid_variant_packet_city_rename(pc);

  switch(pc->phs.variant[PACKET_CITY_RENAME]) {

  case 100:
    return send_packet_city_rename_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CITY_RENAME variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_city_rename(struct connection *pc, int city_id, const char *name)
{
  struct packet_city_rename packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  sz_strlcpy(real_packet->name, name);
  
  return send_packet_city_rename(pc, real_packet);
}

#define hash_packet_city_options_req_100 hash_const

#define cmp_packet_city_options_req_100 cmp_const

BV_DEFINE(packet_city_options_req_100_fields, 2);

static struct packet_city_options_req *receive_packet_city_options_req_100(struct connection *pc, enum packet_type type)
{
  packet_city_options_req_100_fields fields;
  struct packet_city_options_req *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_city_options_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_options_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_options_req_100, cmp_packet_city_options_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->city_id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'options'");
    DIO_BV_GET(&din, real_packet->options);
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_options_req_100(struct connection *pc, const struct packet_city_options_req *packet)
{
  const struct packet_city_options_req *real_packet = packet;
  packet_city_options_req_100_fields fields;
  struct packet_city_options_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_OPTIONS_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_OPTIONS_REQ);

  log_packet_detailed("packet_city_options_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_options_req_100, cmp_packet_city_options_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = !BV_ARE_EQUAL(old->options, real_packet->options);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    dio_put_uint16(&dout, real_packet->city_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'options' has changed");
  DIO_BV_PUT(&dout, packet->options);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_city_options_req(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_OPTIONS_REQ] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_OPTIONS_REQ variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_OPTIONS_REQ] = variant;
}

struct packet_city_options_req *receive_packet_city_options_req(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_city_options_req at the client.");
  }
  ensure_valid_variant_packet_city_options_req(pc);

  switch(pc->phs.variant[PACKET_CITY_OPTIONS_REQ]) {
  case 100:
    return receive_packet_city_options_req_100(pc, type);
  default:
    log_debug("Unknown PACKET_CITY_OPTIONS_REQ variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_options_req(struct connection *pc, const struct packet_city_options_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_city_options_req from the server.");
  }
  ensure_valid_variant_packet_city_options_req(pc);

  switch(pc->phs.variant[PACKET_CITY_OPTIONS_REQ]) {

  case 100:
    return send_packet_city_options_req_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CITY_OPTIONS_REQ variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_city_options_req(struct connection *pc, int city_id, bv_city_options options)
{
  struct packet_city_options_req packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  real_packet->options = options;
  
  return send_packet_city_options_req(pc, real_packet);
}

#define hash_packet_city_refresh_100 hash_const

#define cmp_packet_city_refresh_100 cmp_const

BV_DEFINE(packet_city_refresh_100_fields, 1);

static struct packet_city_refresh *receive_packet_city_refresh_100(struct connection *pc, enum packet_type type)
{
  packet_city_refresh_100_fields fields;
  struct packet_city_refresh *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_city_refresh, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_refresh_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_refresh_100, cmp_packet_city_refresh_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->city_id = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_refresh_100(struct connection *pc, const struct packet_city_refresh *packet)
{
  const struct packet_city_refresh *real_packet = packet;
  packet_city_refresh_100_fields fields;
  struct packet_city_refresh *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_REFRESH;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_REFRESH);

  log_packet_detailed("packet_city_refresh_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_refresh_100, cmp_packet_city_refresh_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    dio_put_uint16(&dout, real_packet->city_id);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_city_refresh(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_REFRESH] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_REFRESH variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_REFRESH] = variant;
}

struct packet_city_refresh *receive_packet_city_refresh(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_city_refresh at the client.");
  }
  ensure_valid_variant_packet_city_refresh(pc);

  switch(pc->phs.variant[PACKET_CITY_REFRESH]) {
  case 100:
    return receive_packet_city_refresh_100(pc, type);
  default:
    log_debug("Unknown PACKET_CITY_REFRESH variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_refresh(struct connection *pc, const struct packet_city_refresh *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_city_refresh from the server.");
  }
  ensure_valid_variant_packet_city_refresh(pc);

  switch(pc->phs.variant[PACKET_CITY_REFRESH]) {

  case 100:
    return send_packet_city_refresh_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CITY_REFRESH variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_city_refresh(struct connection *pc, int city_id)
{
  struct packet_city_refresh packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  
  return send_packet_city_refresh(pc, real_packet);
}

#define hash_packet_city_name_suggestion_req_100 hash_const

#define cmp_packet_city_name_suggestion_req_100 cmp_const

BV_DEFINE(packet_city_name_suggestion_req_100_fields, 1);

static struct packet_city_name_suggestion_req *receive_packet_city_name_suggestion_req_100(struct connection *pc, enum packet_type type)
{
  packet_city_name_suggestion_req_100_fields fields;
  struct packet_city_name_suggestion_req *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_city_name_suggestion_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_name_suggestion_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_name_suggestion_req_100, cmp_packet_city_name_suggestion_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->unit_id = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_name_suggestion_req_100(struct connection *pc, const struct packet_city_name_suggestion_req *packet)
{
  const struct packet_city_name_suggestion_req *real_packet = packet;
  packet_city_name_suggestion_req_100_fields fields;
  struct packet_city_name_suggestion_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_NAME_SUGGESTION_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_NAME_SUGGESTION_REQ);

  log_packet_detailed("packet_city_name_suggestion_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_name_suggestion_req_100, cmp_packet_city_name_suggestion_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_city_name_suggestion_req(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_NAME_SUGGESTION_REQ] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_NAME_SUGGESTION_REQ variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_NAME_SUGGESTION_REQ] = variant;
}

struct packet_city_name_suggestion_req *receive_packet_city_name_suggestion_req(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_city_name_suggestion_req at the client.");
  }
  ensure_valid_variant_packet_city_name_suggestion_req(pc);

  switch(pc->phs.variant[PACKET_CITY_NAME_SUGGESTION_REQ]) {
  case 100:
    return receive_packet_city_name_suggestion_req_100(pc, type);
  default:
    log_debug("Unknown PACKET_CITY_NAME_SUGGESTION_REQ variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_name_suggestion_req(struct connection *pc, const struct packet_city_name_suggestion_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_city_name_suggestion_req from the server.");
  }
  ensure_valid_variant_packet_city_name_suggestion_req(pc);

  switch(pc->phs.variant[PACKET_CITY_NAME_SUGGESTION_REQ]) {

  case 100:
    return send_packet_city_name_suggestion_req_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CITY_NAME_SUGGESTION_REQ variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_city_name_suggestion_req(struct connection *pc, int unit_id)
{
  struct packet_city_name_suggestion_req packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  
  return send_packet_city_name_suggestion_req(pc, real_packet);
}

#define hash_packet_city_name_suggestion_info_100 hash_const

#define cmp_packet_city_name_suggestion_info_100 cmp_const

BV_DEFINE(packet_city_name_suggestion_info_100_fields, 2);

static struct packet_city_name_suggestion_info *receive_packet_city_name_suggestion_info_100(struct connection *pc, enum packet_type type)
{
  packet_city_name_suggestion_info_100_fields fields;
  struct packet_city_name_suggestion_info *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_city_name_suggestion_info, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_name_suggestion_info_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_name_suggestion_info_100, cmp_packet_city_name_suggestion_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->unit_id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    dio_get_string(&din, real_packet->name, sizeof(real_packet->name));
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_name_suggestion_info_100(struct connection *pc, const struct packet_city_name_suggestion_info *packet)
{
  const struct packet_city_name_suggestion_info *real_packet = packet;
  packet_city_name_suggestion_info_100_fields fields;
  struct packet_city_name_suggestion_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_NAME_SUGGESTION_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_NAME_SUGGESTION_INFO);

  log_packet_detailed("packet_city_name_suggestion_info_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_name_suggestion_info_100, cmp_packet_city_name_suggestion_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_city_name_suggestion_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_NAME_SUGGESTION_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_NAME_SUGGESTION_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_NAME_SUGGESTION_INFO] = variant;
}

struct packet_city_name_suggestion_info *receive_packet_city_name_suggestion_info(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_city_name_suggestion_info at the server.");
  }
  ensure_valid_variant_packet_city_name_suggestion_info(pc);

  switch(pc->phs.variant[PACKET_CITY_NAME_SUGGESTION_INFO]) {
  case 100:
    return receive_packet_city_name_suggestion_info_100(pc, type);
  default:
    log_debug("Unknown PACKET_CITY_NAME_SUGGESTION_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_name_suggestion_info(struct connection *pc, const struct packet_city_name_suggestion_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_city_name_suggestion_info from the client.");
  }
  ensure_valid_variant_packet_city_name_suggestion_info(pc);

  switch(pc->phs.variant[PACKET_CITY_NAME_SUGGESTION_INFO]) {

  case 100:
    return send_packet_city_name_suggestion_info_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CITY_NAME_SUGGESTION_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_city_name_suggestion_info(struct conn_list *dest, const struct packet_city_name_suggestion_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_city_name_suggestion_info(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_city_name_suggestion_info(struct connection *pc, int unit_id, const char *name)
{
  struct packet_city_name_suggestion_info packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  sz_strlcpy(real_packet->name, name);
  
  return send_packet_city_name_suggestion_info(pc, real_packet);
}

void dlsend_packet_city_name_suggestion_info(struct conn_list *dest, int unit_id, const char *name)
{
  struct packet_city_name_suggestion_info packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  sz_strlcpy(real_packet->name, name);
  
  lsend_packet_city_name_suggestion_info(dest, real_packet);
}

#define hash_packet_city_sabotage_list_100 hash_const

#define cmp_packet_city_sabotage_list_100 cmp_const

BV_DEFINE(packet_city_sabotage_list_100_fields, 3);

static struct packet_city_sabotage_list *receive_packet_city_sabotage_list_100(struct connection *pc, enum packet_type type)
{
  packet_city_sabotage_list_100_fields fields;
  struct packet_city_sabotage_list *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_city_sabotage_list, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_sabotage_list_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_sabotage_list_100, cmp_packet_city_sabotage_list_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'diplomat_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->diplomat_id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'city_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->city_id = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'improvements'");
    DIO_BV_GET(&din, real_packet->improvements);
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_sabotage_list_100(struct connection *pc, const struct packet_city_sabotage_list *packet)
{
  const struct packet_city_sabotage_list *real_packet = packet;
  packet_city_sabotage_list_100_fields fields;
  struct packet_city_sabotage_list *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_SABOTAGE_LIST;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_SABOTAGE_LIST);

  log_packet_detailed("packet_city_sabotage_list_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_sabotage_list_100, cmp_packet_city_sabotage_list_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->diplomat_id != real_packet->diplomat_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = !BV_ARE_EQUAL(old->improvements, real_packet->improvements);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'diplomat_id' has changed");
    dio_put_uint16(&dout, real_packet->diplomat_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'city_id' has changed");
    dio_put_uint16(&dout, real_packet->city_id);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'improvements' has changed");
  DIO_BV_PUT(&dout, packet->improvements);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_city_sabotage_list(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_SABOTAGE_LIST] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_SABOTAGE_LIST variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_SABOTAGE_LIST] = variant;
}

struct packet_city_sabotage_list *receive_packet_city_sabotage_list(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_city_sabotage_list at the server.");
  }
  ensure_valid_variant_packet_city_sabotage_list(pc);

  switch(pc->phs.variant[PACKET_CITY_SABOTAGE_LIST]) {
  case 100:
    return receive_packet_city_sabotage_list_100(pc, type);
  default:
    log_debug("Unknown PACKET_CITY_SABOTAGE_LIST variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_sabotage_list(struct connection *pc, const struct packet_city_sabotage_list *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_city_sabotage_list from the client.");
  }
  ensure_valid_variant_packet_city_sabotage_list(pc);

  switch(pc->phs.variant[PACKET_CITY_SABOTAGE_LIST]) {

  case 100:
    return send_packet_city_sabotage_list_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CITY_SABOTAGE_LIST variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_city_sabotage_list(struct conn_list *dest, const struct packet_city_sabotage_list *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_city_sabotage_list(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_player_remove_100 hash_const

#define cmp_packet_player_remove_100 cmp_const

BV_DEFINE(packet_player_remove_100_fields, 1);

static struct packet_player_remove *receive_packet_player_remove_100(struct connection *pc, enum packet_type type)
{
  packet_player_remove_100_fields fields;
  struct packet_player_remove *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_player_remove, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_player_remove_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_remove_100, cmp_packet_player_remove_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'playerno'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->playerno = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_PLAYER_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_remove_100(struct connection *pc, const struct packet_player_remove *packet)
{
  const struct packet_player_remove *real_packet = packet;
  packet_player_remove_100_fields fields;
  struct packet_player_remove *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_REMOVE;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_REMOVE);

  log_packet_detailed("packet_player_remove_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_remove_100, cmp_packet_player_remove_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->playerno != real_packet->playerno);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'playerno' has changed");
    dio_put_sint8(&dout, real_packet->playerno);
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_PLAYER_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_player_remove(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_PLAYER_REMOVE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_PLAYER_REMOVE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_PLAYER_REMOVE] = variant;
}

struct packet_player_remove *receive_packet_player_remove(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_player_remove at the server.");
  }
  ensure_valid_variant_packet_player_remove(pc);

  switch(pc->phs.variant[PACKET_PLAYER_REMOVE]) {
  case 100:
    return receive_packet_player_remove_100(pc, type);
  default:
    log_debug("Unknown PACKET_PLAYER_REMOVE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_player_remove(struct connection *pc, const struct packet_player_remove *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_player_remove from the client.");
  }
  ensure_valid_variant_packet_player_remove(pc);

  switch(pc->phs.variant[PACKET_PLAYER_REMOVE]) {

  case 100:
    return send_packet_player_remove_100(pc, packet);
  default:
    log_debug("Unknown PACKET_PLAYER_REMOVE variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_player_remove(struct connection *pc, int playerno)
{
  struct packet_player_remove packet, *real_packet = &packet;

  real_packet->playerno = playerno;
  
  return send_packet_player_remove(pc, real_packet);
}

static genhash_val_t hash_packet_player_info_100(const void *vkey, size_t num_buckets)
{
  const struct packet_player_info *key = (const struct packet_player_info *) vkey;

  return ((key->playerno) % num_buckets);
}

static bool cmp_packet_player_info_100(const void *vkey1, const void *vkey2)
{
  const struct packet_player_info *key1 = (const struct packet_player_info *) vkey1;
  const struct packet_player_info *key2 = (const struct packet_player_info *) vkey2;

  return key1->playerno == key2->playerno;
}

BV_DEFINE(packet_player_info_100_fields, 38);

static struct packet_player_info *receive_packet_player_info_100(struct connection *pc, enum packet_type type)
{
  packet_player_info_100_fields fields;
  struct packet_player_info *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_player_info, real_packet);

  DIO_BV_GET(&din, fields);
  {
    int readin;
  
    dio_get_sint8(&din, &readin);
    real_packet->playerno = readin;
  }

  log_packet_detailed("packet_player_info_100: got info about (%d)",
    real_packet->playerno);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_info_100, cmp_packet_player_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int playerno = real_packet->playerno;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->playerno = playerno;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'name'");
    dio_get_string(&din, real_packet->name, sizeof(real_packet->name));
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'username'");
    dio_get_string(&din, real_packet->username, sizeof(real_packet->username));
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'score'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->score = readin;
    }
  }
  real_packet->is_male = BV_ISSET(fields, 3);
  real_packet->was_created = BV_ISSET(fields, 4);
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'government'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->government = readin;
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'target_government'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->target_government = readin;
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'real_embassy'");
    
    {
      int i;
    
      for (i = 0; i < MAX_NUM_PLAYER_SLOTS; i++) {
        dio_get_bool8(&din, &real_packet->real_embassy[i]);
      }
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'city_style'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->city_style = readin;
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'nation'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->nation = readin;
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'team'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->team = readin;
    }
  }
  real_packet->is_ready = BV_ISSET(fields, 11);
  real_packet->phase_done = BV_ISSET(fields, 12);
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'nturns_idle'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->nturns_idle = readin;
    }
  }
  real_packet->is_alive = BV_ISSET(fields, 14);
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'gold'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->gold = readin;
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'tax'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->tax = readin;
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'science'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->science = readin;
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'luxury'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->luxury = readin;
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'bulbs_last_turn'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->bulbs_last_turn = readin;
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'bulbs_researched'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->bulbs_researched = readin;
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  got field 'techs_researched'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->techs_researched = readin;
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'researching'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->researching = readin;
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'science_cost'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->science_cost = readin;
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'future_tech'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->future_tech = readin;
    }
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  got field 'tech_goal'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->tech_goal = readin;
    }
  }
  real_packet->is_connected = BV_ISSET(fields, 26);
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  got field 'revolution_finishes'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->revolution_finishes = readin;
    }
  }
  real_packet->ai = BV_ISSET(fields, 28);
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  got field 'ai_skill_level'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->ai_skill_level = readin;
    }
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  got field 'barbarian_type'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->barbarian_type = readin;
    }
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  got field 'gives_shared_vision'");
    DIO_BV_GET(&din, real_packet->gives_shared_vision);
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  got field 'inventions'");
    dio_get_string(&din, real_packet->inventions, sizeof(real_packet->inventions));
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  got field 'love'");
    
    {
      int i;
    
      for (i = 0; i < MAX_NUM_PLAYER_SLOTS; i++) {
        {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->love[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  got field 'color_red'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->color_red = readin;
    }
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  got field 'color_green'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->color_green = readin;
    }
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  got field 'color_blue'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->color_blue = readin;
    }
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  got field 'wonders_new'");
    
    for (;;) {
      int i;
    
      if (!dio_get_uint8(&din, &i)) {
        break;
      }
      if (i == 255) {
        break;
      }
      if (i > B_LAST) {
        log_error("packets_gen.c: WARNING: ignoring intra array diff");
      } else {
        {
      int readin;
    
      dio_get_sint32(&din, &readin);
      real_packet->wonders_new[i] = readin;
    }
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_info_100(struct connection *pc, const struct packet_player_info *packet)
{
  const struct packet_player_info *real_packet = packet;
  packet_player_info_100_fields fields;
  struct packet_player_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_INFO);

  log_packet_detailed("packet_player_info_100: sending info about (%d)",
    real_packet->playerno);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_info_100, cmp_packet_player_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->username, real_packet->username) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->score != real_packet->score);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->is_male != real_packet->is_male);
  if(differ) {
    different++;
  }
  if (packet->is_male) {
    BV_SET(fields, 3);
  }

  differ = (old->was_created != real_packet->was_created);
  if(differ) {
    different++;
  }
  if (packet->was_created) {
    BV_SET(fields, 4);
  }

  differ = (old->government != real_packet->government);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->target_government != real_packet->target_government);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }


    {
      differ = (MAX_NUM_PLAYER_SLOTS != MAX_NUM_PLAYER_SLOTS);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_NUM_PLAYER_SLOTS; i++) {
          if (old->real_embassy[i] != real_packet->real_embassy[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->city_style != real_packet->city_style);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->nation != real_packet->nation);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->team != real_packet->team);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->is_ready != real_packet->is_ready);
  if(differ) {
    different++;
  }
  if (packet->is_ready) {
    BV_SET(fields, 11);
  }

  differ = (old->phase_done != real_packet->phase_done);
  if(differ) {
    different++;
  }
  if (packet->phase_done) {
    BV_SET(fields, 12);
  }

  differ = (old->nturns_idle != real_packet->nturns_idle);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->is_alive != real_packet->is_alive);
  if(differ) {
    different++;
  }
  if (packet->is_alive) {
    BV_SET(fields, 14);
  }

  differ = (old->gold != real_packet->gold);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (old->tax != real_packet->tax);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }

  differ = (old->science != real_packet->science);
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }

  differ = (old->luxury != real_packet->luxury);
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }

  differ = (old->bulbs_last_turn != real_packet->bulbs_last_turn);
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }

  differ = (old->bulbs_researched != real_packet->bulbs_researched);
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }

  differ = (old->techs_researched != real_packet->techs_researched);
  if (differ) {
    different++;
    BV_SET(fields, 21);
  }

  differ = (old->researching != real_packet->researching);
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (old->science_cost != real_packet->science_cost);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }

  differ = (old->future_tech != real_packet->future_tech);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }

  differ = (old->tech_goal != real_packet->tech_goal);
  if (differ) {
    different++;
    BV_SET(fields, 25);
  }

  differ = (old->is_connected != real_packet->is_connected);
  if(differ) {
    different++;
  }
  if (packet->is_connected) {
    BV_SET(fields, 26);
  }

  differ = (old->revolution_finishes != real_packet->revolution_finishes);
  if (differ) {
    different++;
    BV_SET(fields, 27);
  }

  differ = (old->ai != real_packet->ai);
  if(differ) {
    different++;
  }
  if (packet->ai) {
    BV_SET(fields, 28);
  }

  differ = (old->ai_skill_level != real_packet->ai_skill_level);
  if (differ) {
    different++;
    BV_SET(fields, 29);
  }

  differ = (old->barbarian_type != real_packet->barbarian_type);
  if (differ) {
    different++;
    BV_SET(fields, 30);
  }

  differ = !BV_ARE_EQUAL(old->gives_shared_vision, real_packet->gives_shared_vision);
  if (differ) {
    different++;
    BV_SET(fields, 31);
  }

  differ = (strcmp(old->inventions, real_packet->inventions) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 32);
  }


    {
      differ = (MAX_NUM_PLAYER_SLOTS != MAX_NUM_PLAYER_SLOTS);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_NUM_PLAYER_SLOTS; i++) {
          if (old->love[i] != real_packet->love[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 33);
  }

  differ = (old->color_red != real_packet->color_red);
  if (differ) {
    different++;
    BV_SET(fields, 34);
  }

  differ = (old->color_green != real_packet->color_green);
  if (differ) {
    different++;
    BV_SET(fields, 35);
  }

  differ = (old->color_blue != real_packet->color_blue);
  if (differ) {
    different++;
    BV_SET(fields, 36);
  }


    {
      differ = (B_LAST != B_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < B_LAST; i++) {
          if (old->wonders_new[i] != real_packet->wonders_new[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 37);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, fields);
  dio_put_sint8(&dout, real_packet->playerno);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'username' has changed");
    dio_put_string(&dout, real_packet->username);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'score' has changed");
    dio_put_uint32(&dout, real_packet->score);
  }
  /* field 3 is folded into the header */
  /* field 4 is folded into the header */
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'government' has changed");
    dio_put_uint8(&dout, real_packet->government);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'target_government' has changed");
    dio_put_uint8(&dout, real_packet->target_government);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'real_embassy' has changed");
  
    {
      int i;

      for (i = 0; i < MAX_NUM_PLAYER_SLOTS; i++) {
        dio_put_bool8(&dout, real_packet->real_embassy[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'city_style' has changed");
    dio_put_uint8(&dout, real_packet->city_style);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'nation' has changed");
    dio_put_sint16(&dout, real_packet->nation);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'team' has changed");
    dio_put_uint8(&dout, real_packet->team);
  }
  /* field 11 is folded into the header */
  /* field 12 is folded into the header */
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'nturns_idle' has changed");
    dio_put_sint16(&dout, real_packet->nturns_idle);
  }
  /* field 14 is folded into the header */
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'gold' has changed");
    dio_put_uint32(&dout, real_packet->gold);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'tax' has changed");
    dio_put_uint8(&dout, real_packet->tax);
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'science' has changed");
    dio_put_uint8(&dout, real_packet->science);
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'luxury' has changed");
    dio_put_uint8(&dout, real_packet->luxury);
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'bulbs_last_turn' has changed");
    dio_put_uint16(&dout, real_packet->bulbs_last_turn);
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'bulbs_researched' has changed");
    dio_put_uint32(&dout, real_packet->bulbs_researched);
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  field 'techs_researched' has changed");
    dio_put_uint32(&dout, real_packet->techs_researched);
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'researching' has changed");
    dio_put_uint8(&dout, real_packet->researching);
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'science_cost' has changed");
    dio_put_uint16(&dout, real_packet->science_cost);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'future_tech' has changed");
    dio_put_uint16(&dout, real_packet->future_tech);
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  field 'tech_goal' has changed");
    dio_put_uint8(&dout, real_packet->tech_goal);
  }
  /* field 26 is folded into the header */
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  field 'revolution_finishes' has changed");
    dio_put_sint16(&dout, real_packet->revolution_finishes);
  }
  /* field 28 is folded into the header */
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  field 'ai_skill_level' has changed");
    dio_put_uint8(&dout, real_packet->ai_skill_level);
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  field 'barbarian_type' has changed");
    dio_put_uint8(&dout, real_packet->barbarian_type);
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  field 'gives_shared_vision' has changed");
  DIO_BV_PUT(&dout, packet->gives_shared_vision);
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  field 'inventions' has changed");
    dio_put_string(&dout, real_packet->inventions);
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  field 'love' has changed");
  
    {
      int i;

      for (i = 0; i < MAX_NUM_PLAYER_SLOTS; i++) {
        dio_put_sint16(&dout, real_packet->love[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  field 'color_red' has changed");
    dio_put_uint8(&dout, real_packet->color_red);
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  field 'color_green' has changed");
    dio_put_uint8(&dout, real_packet->color_green);
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  field 'color_blue' has changed");
    dio_put_uint8(&dout, real_packet->color_blue);
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  field 'wonders_new' has changed");
  
    {
      int i;

      fc_assert(B_LAST < 255);

      for (i = 0; i < B_LAST; i++) {
        if(old->wonders_new[i] != real_packet->wonders_new[i]) {
          dio_put_uint8(&dout, i);
          dio_put_sint32(&dout, real_packet->wonders_new[i]);
        }
      }
      dio_put_uint8(&dout, 255);
    } 
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static genhash_val_t hash_packet_player_info_101(const void *vkey, size_t num_buckets)
{
  const struct packet_player_info *key = (const struct packet_player_info *) vkey;

  return ((key->playerno) % num_buckets);
}

static bool cmp_packet_player_info_101(const void *vkey1, const void *vkey2)
{
  const struct packet_player_info *key1 = (const struct packet_player_info *) vkey1;
  const struct packet_player_info *key2 = (const struct packet_player_info *) vkey2;

  return key1->playerno == key2->playerno;
}

BV_DEFINE(packet_player_info_101_fields, 38);

static struct packet_player_info *receive_packet_player_info_101(struct connection *pc, enum packet_type type)
{
  packet_player_info_101_fields fields;
  struct packet_player_info *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_player_info, real_packet);

  DIO_BV_GET(&din, fields);
  {
    int readin;
  
    dio_get_sint8(&din, &readin);
    real_packet->playerno = readin;
  }

  log_packet_detailed("packet_player_info_101: got info about (%d)",
    real_packet->playerno);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_info_101, cmp_packet_player_info_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int playerno = real_packet->playerno;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->playerno = playerno;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'name'");
    dio_get_string(&din, real_packet->name, sizeof(real_packet->name));
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'username'");
    dio_get_string(&din, real_packet->username, sizeof(real_packet->username));
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'score'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->score = readin;
    }
  }
  real_packet->is_male = BV_ISSET(fields, 3);
  real_packet->was_created = BV_ISSET(fields, 4);
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'government'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->government = readin;
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'target_government'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->target_government = readin;
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'real_embassy'");
    
    {
      int i;
    
      for (i = 0; i < MAX_NUM_PLAYER_SLOTS; i++) {
        dio_get_bool8(&din, &real_packet->real_embassy[i]);
      }
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'city_style'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->city_style = readin;
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'nation'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->nation = readin;
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'team'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->team = readin;
    }
  }
  real_packet->is_ready = BV_ISSET(fields, 11);
  real_packet->phase_done = BV_ISSET(fields, 12);
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'nturns_idle'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->nturns_idle = readin;
    }
  }
  real_packet->is_alive = BV_ISSET(fields, 14);
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'gold'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->gold = readin;
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'tax'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->tax = readin;
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'science'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->science = readin;
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'luxury'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->luxury = readin;
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'bulbs_last_turn'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->bulbs_last_turn = readin;
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'bulbs_researched'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->bulbs_researched = readin;
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  got field 'techs_researched'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->techs_researched = readin;
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'researching'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->researching = readin;
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'science_cost'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->science_cost = readin;
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'future_tech'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->future_tech = readin;
    }
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  got field 'tech_goal'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->tech_goal = readin;
    }
  }
  real_packet->is_connected = BV_ISSET(fields, 26);
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  got field 'revolution_finishes'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->revolution_finishes = readin;
    }
  }
  real_packet->ai = BV_ISSET(fields, 28);
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  got field 'ai_skill_level'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->ai_skill_level = readin;
    }
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  got field 'barbarian_type'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->barbarian_type = readin;
    }
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  got field 'gives_shared_vision'");
    DIO_BV_GET(&din, real_packet->gives_shared_vision);
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  got field 'inventions'");
    dio_get_string(&din, real_packet->inventions, sizeof(real_packet->inventions));
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  got field 'love'");
    
    {
      int i;
    
      for (i = 0; i < MAX_NUM_PLAYER_SLOTS; i++) {
        {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->love[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  got field 'color_red'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->color_red = readin;
    }
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  got field 'color_green'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->color_green = readin;
    }
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  got field 'color_blue'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->color_blue = readin;
    }
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  got field 'wonders'");
    
    for (;;) {
      int i;
    
      if (!dio_get_uint8(&din, &i)) {
        break;
      }
      if (i == 255) {
        break;
      }
      if (i > B_LAST) {
        log_error("packets_gen.c: WARNING: ignoring intra array diff");
      } else {
        {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->wonders[i] = readin;
    }
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_info_101(struct connection *pc, const struct packet_player_info *packet)
{
  const struct packet_player_info *real_packet = packet;
  packet_player_info_101_fields fields;
  struct packet_player_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_INFO);

  log_packet_detailed("packet_player_info_101: sending info about (%d)",
    real_packet->playerno);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_info_101, cmp_packet_player_info_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->username, real_packet->username) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->score != real_packet->score);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->is_male != real_packet->is_male);
  if(differ) {
    different++;
  }
  if (packet->is_male) {
    BV_SET(fields, 3);
  }

  differ = (old->was_created != real_packet->was_created);
  if(differ) {
    different++;
  }
  if (packet->was_created) {
    BV_SET(fields, 4);
  }

  differ = (old->government != real_packet->government);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->target_government != real_packet->target_government);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }


    {
      differ = (MAX_NUM_PLAYER_SLOTS != MAX_NUM_PLAYER_SLOTS);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_NUM_PLAYER_SLOTS; i++) {
          if (old->real_embassy[i] != real_packet->real_embassy[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->city_style != real_packet->city_style);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->nation != real_packet->nation);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->team != real_packet->team);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->is_ready != real_packet->is_ready);
  if(differ) {
    different++;
  }
  if (packet->is_ready) {
    BV_SET(fields, 11);
  }

  differ = (old->phase_done != real_packet->phase_done);
  if(differ) {
    different++;
  }
  if (packet->phase_done) {
    BV_SET(fields, 12);
  }

  differ = (old->nturns_idle != real_packet->nturns_idle);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->is_alive != real_packet->is_alive);
  if(differ) {
    different++;
  }
  if (packet->is_alive) {
    BV_SET(fields, 14);
  }

  differ = (old->gold != real_packet->gold);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (old->tax != real_packet->tax);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }

  differ = (old->science != real_packet->science);
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }

  differ = (old->luxury != real_packet->luxury);
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }

  differ = (old->bulbs_last_turn != real_packet->bulbs_last_turn);
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }

  differ = (old->bulbs_researched != real_packet->bulbs_researched);
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }

  differ = (old->techs_researched != real_packet->techs_researched);
  if (differ) {
    different++;
    BV_SET(fields, 21);
  }

  differ = (old->researching != real_packet->researching);
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (old->science_cost != real_packet->science_cost);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }

  differ = (old->future_tech != real_packet->future_tech);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }

  differ = (old->tech_goal != real_packet->tech_goal);
  if (differ) {
    different++;
    BV_SET(fields, 25);
  }

  differ = (old->is_connected != real_packet->is_connected);
  if(differ) {
    different++;
  }
  if (packet->is_connected) {
    BV_SET(fields, 26);
  }

  differ = (old->revolution_finishes != real_packet->revolution_finishes);
  if (differ) {
    different++;
    BV_SET(fields, 27);
  }

  differ = (old->ai != real_packet->ai);
  if(differ) {
    different++;
  }
  if (packet->ai) {
    BV_SET(fields, 28);
  }

  differ = (old->ai_skill_level != real_packet->ai_skill_level);
  if (differ) {
    different++;
    BV_SET(fields, 29);
  }

  differ = (old->barbarian_type != real_packet->barbarian_type);
  if (differ) {
    different++;
    BV_SET(fields, 30);
  }

  differ = !BV_ARE_EQUAL(old->gives_shared_vision, real_packet->gives_shared_vision);
  if (differ) {
    different++;
    BV_SET(fields, 31);
  }

  differ = (strcmp(old->inventions, real_packet->inventions) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 32);
  }


    {
      differ = (MAX_NUM_PLAYER_SLOTS != MAX_NUM_PLAYER_SLOTS);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_NUM_PLAYER_SLOTS; i++) {
          if (old->love[i] != real_packet->love[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 33);
  }

  differ = (old->color_red != real_packet->color_red);
  if (differ) {
    different++;
    BV_SET(fields, 34);
  }

  differ = (old->color_green != real_packet->color_green);
  if (differ) {
    different++;
    BV_SET(fields, 35);
  }

  differ = (old->color_blue != real_packet->color_blue);
  if (differ) {
    different++;
    BV_SET(fields, 36);
  }


    {
      differ = (B_LAST != B_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < B_LAST; i++) {
          if (old->wonders[i] != real_packet->wonders[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 37);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, fields);
  dio_put_sint8(&dout, real_packet->playerno);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'username' has changed");
    dio_put_string(&dout, real_packet->username);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'score' has changed");
    dio_put_uint32(&dout, real_packet->score);
  }
  /* field 3 is folded into the header */
  /* field 4 is folded into the header */
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'government' has changed");
    dio_put_uint8(&dout, real_packet->government);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'target_government' has changed");
    dio_put_uint8(&dout, real_packet->target_government);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'real_embassy' has changed");
  
    {
      int i;

      for (i = 0; i < MAX_NUM_PLAYER_SLOTS; i++) {
        dio_put_bool8(&dout, real_packet->real_embassy[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'city_style' has changed");
    dio_put_uint8(&dout, real_packet->city_style);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'nation' has changed");
    dio_put_sint16(&dout, real_packet->nation);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'team' has changed");
    dio_put_uint8(&dout, real_packet->team);
  }
  /* field 11 is folded into the header */
  /* field 12 is folded into the header */
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'nturns_idle' has changed");
    dio_put_sint16(&dout, real_packet->nturns_idle);
  }
  /* field 14 is folded into the header */
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'gold' has changed");
    dio_put_uint32(&dout, real_packet->gold);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'tax' has changed");
    dio_put_uint8(&dout, real_packet->tax);
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'science' has changed");
    dio_put_uint8(&dout, real_packet->science);
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'luxury' has changed");
    dio_put_uint8(&dout, real_packet->luxury);
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'bulbs_last_turn' has changed");
    dio_put_uint16(&dout, real_packet->bulbs_last_turn);
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'bulbs_researched' has changed");
    dio_put_uint32(&dout, real_packet->bulbs_researched);
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  field 'techs_researched' has changed");
    dio_put_uint32(&dout, real_packet->techs_researched);
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'researching' has changed");
    dio_put_uint8(&dout, real_packet->researching);
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'science_cost' has changed");
    dio_put_uint16(&dout, real_packet->science_cost);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'future_tech' has changed");
    dio_put_uint16(&dout, real_packet->future_tech);
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  field 'tech_goal' has changed");
    dio_put_uint8(&dout, real_packet->tech_goal);
  }
  /* field 26 is folded into the header */
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  field 'revolution_finishes' has changed");
    dio_put_sint16(&dout, real_packet->revolution_finishes);
  }
  /* field 28 is folded into the header */
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  field 'ai_skill_level' has changed");
    dio_put_uint8(&dout, real_packet->ai_skill_level);
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  field 'barbarian_type' has changed");
    dio_put_uint8(&dout, real_packet->barbarian_type);
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  field 'gives_shared_vision' has changed");
  DIO_BV_PUT(&dout, packet->gives_shared_vision);
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  field 'inventions' has changed");
    dio_put_string(&dout, real_packet->inventions);
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  field 'love' has changed");
  
    {
      int i;

      for (i = 0; i < MAX_NUM_PLAYER_SLOTS; i++) {
        dio_put_sint16(&dout, real_packet->love[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  field 'color_red' has changed");
    dio_put_uint8(&dout, real_packet->color_red);
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  field 'color_green' has changed");
    dio_put_uint8(&dout, real_packet->color_green);
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  field 'color_blue' has changed");
    dio_put_uint8(&dout, real_packet->color_blue);
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  field 'wonders' has changed");
  
    {
      int i;

      fc_assert(B_LAST < 255);

      for (i = 0; i < B_LAST; i++) {
        if(old->wonders[i] != real_packet->wonders[i]) {
          dio_put_uint8(&dout, i);
          dio_put_uint16(&dout, real_packet->wonders[i]);
        }
      }
      dio_put_uint8(&dout, 255);
    } 
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_player_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_PLAYER_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if((has_capability("wonder_city_id", pc->capability) && has_capability("wonder_city_id", our_capability))) {
    variant = 100;
  } else if(!(has_capability("wonder_city_id", pc->capability) && has_capability("wonder_city_id", our_capability))) {
    variant = 101;
  } else {
    log_error("Unknown PACKET_PLAYER_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  log_packet_detailed("packet_player_info: using variant=%d cap=%s", variant, pc->capability);
  pc->phs.variant[PACKET_PLAYER_INFO] = variant;
}

struct packet_player_info *receive_packet_player_info(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_player_info at the server.");
  }
  ensure_valid_variant_packet_player_info(pc);

  switch(pc->phs.variant[PACKET_PLAYER_INFO]) {
  case 100:
    return receive_packet_player_info_100(pc, type);
  case 101:
    return receive_packet_player_info_101(pc, type);
  default:
    log_debug("Unknown PACKET_PLAYER_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_player_info(struct connection *pc, const struct packet_player_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_player_info from the client.");
  }
  ensure_valid_variant_packet_player_info(pc);

  switch(pc->phs.variant[PACKET_PLAYER_INFO]) {

  case 100:
    return send_packet_player_info_100(pc, packet);
  case 101:
    return send_packet_player_info_101(pc, packet);
  default:
    log_debug("Unknown PACKET_PLAYER_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
#define hash_packet_player_phase_done_100 hash_const

#define cmp_packet_player_phase_done_100 cmp_const

BV_DEFINE(packet_player_phase_done_100_fields, 1);

static struct packet_player_phase_done *receive_packet_player_phase_done_100(struct connection *pc, enum packet_type type)
{
  packet_player_phase_done_100_fields fields;
  struct packet_player_phase_done *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_player_phase_done, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_player_phase_done_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_phase_done_100, cmp_packet_player_phase_done_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'turn'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->turn = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_phase_done_100(struct connection *pc, const struct packet_player_phase_done *packet)
{
  const struct packet_player_phase_done *real_packet = packet;
  packet_player_phase_done_100_fields fields;
  struct packet_player_phase_done *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_PHASE_DONE;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_PHASE_DONE);

  log_packet_detailed("packet_player_phase_done_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_phase_done_100, cmp_packet_player_phase_done_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->turn != real_packet->turn);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'turn' has changed");
    dio_put_sint16(&dout, real_packet->turn);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_player_phase_done(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_PLAYER_PHASE_DONE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_PLAYER_PHASE_DONE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_PLAYER_PHASE_DONE] = variant;
}

struct packet_player_phase_done *receive_packet_player_phase_done(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_player_phase_done at the client.");
  }
  ensure_valid_variant_packet_player_phase_done(pc);

  switch(pc->phs.variant[PACKET_PLAYER_PHASE_DONE]) {
  case 100:
    return receive_packet_player_phase_done_100(pc, type);
  default:
    log_debug("Unknown PACKET_PLAYER_PHASE_DONE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_player_phase_done(struct connection *pc, const struct packet_player_phase_done *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_player_phase_done from the server.");
  }
  ensure_valid_variant_packet_player_phase_done(pc);

  switch(pc->phs.variant[PACKET_PLAYER_PHASE_DONE]) {

  case 100:
    return send_packet_player_phase_done_100(pc, packet);
  default:
    log_debug("Unknown PACKET_PLAYER_PHASE_DONE variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_player_phase_done(struct connection *pc, int turn)
{
  struct packet_player_phase_done packet, *real_packet = &packet;

  real_packet->turn = turn;
  
  return send_packet_player_phase_done(pc, real_packet);
}

#define hash_packet_player_rates_100 hash_const

#define cmp_packet_player_rates_100 cmp_const

BV_DEFINE(packet_player_rates_100_fields, 3);

static struct packet_player_rates *receive_packet_player_rates_100(struct connection *pc, enum packet_type type)
{
  packet_player_rates_100_fields fields;
  struct packet_player_rates *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_player_rates, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_player_rates_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_rates_100, cmp_packet_player_rates_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'tax'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->tax = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'luxury'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->luxury = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'science'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->science = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_rates_100(struct connection *pc, const struct packet_player_rates *packet)
{
  const struct packet_player_rates *real_packet = packet;
  packet_player_rates_100_fields fields;
  struct packet_player_rates *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_RATES;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_RATES);

  log_packet_detailed("packet_player_rates_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_rates_100, cmp_packet_player_rates_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->tax != real_packet->tax);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->luxury != real_packet->luxury);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->science != real_packet->science);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'tax' has changed");
    dio_put_uint8(&dout, real_packet->tax);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'luxury' has changed");
    dio_put_uint8(&dout, real_packet->luxury);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'science' has changed");
    dio_put_uint8(&dout, real_packet->science);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_player_rates(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_PLAYER_RATES] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_PLAYER_RATES variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_PLAYER_RATES] = variant;
}

struct packet_player_rates *receive_packet_player_rates(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_player_rates at the client.");
  }
  ensure_valid_variant_packet_player_rates(pc);

  switch(pc->phs.variant[PACKET_PLAYER_RATES]) {
  case 100:
    return receive_packet_player_rates_100(pc, type);
  default:
    log_debug("Unknown PACKET_PLAYER_RATES variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_player_rates(struct connection *pc, const struct packet_player_rates *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_player_rates from the server.");
  }
  ensure_valid_variant_packet_player_rates(pc);

  switch(pc->phs.variant[PACKET_PLAYER_RATES]) {

  case 100:
    return send_packet_player_rates_100(pc, packet);
  default:
    log_debug("Unknown PACKET_PLAYER_RATES variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_player_rates(struct connection *pc, int tax, int luxury, int science)
{
  struct packet_player_rates packet, *real_packet = &packet;

  real_packet->tax = tax;
  real_packet->luxury = luxury;
  real_packet->science = science;
  
  return send_packet_player_rates(pc, real_packet);
}

#define hash_packet_player_change_government_100 hash_const

#define cmp_packet_player_change_government_100 cmp_const

BV_DEFINE(packet_player_change_government_100_fields, 1);

static struct packet_player_change_government *receive_packet_player_change_government_100(struct connection *pc, enum packet_type type)
{
  packet_player_change_government_100_fields fields;
  struct packet_player_change_government *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_player_change_government, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_player_change_government_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_change_government_100, cmp_packet_player_change_government_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'government'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->government = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_change_government_100(struct connection *pc, const struct packet_player_change_government *packet)
{
  const struct packet_player_change_government *real_packet = packet;
  packet_player_change_government_100_fields fields;
  struct packet_player_change_government *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_CHANGE_GOVERNMENT;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_CHANGE_GOVERNMENT);

  log_packet_detailed("packet_player_change_government_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_change_government_100, cmp_packet_player_change_government_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->government != real_packet->government);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'government' has changed");
    dio_put_uint8(&dout, real_packet->government);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_player_change_government(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_PLAYER_CHANGE_GOVERNMENT] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_PLAYER_CHANGE_GOVERNMENT variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_PLAYER_CHANGE_GOVERNMENT] = variant;
}

struct packet_player_change_government *receive_packet_player_change_government(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_player_change_government at the client.");
  }
  ensure_valid_variant_packet_player_change_government(pc);

  switch(pc->phs.variant[PACKET_PLAYER_CHANGE_GOVERNMENT]) {
  case 100:
    return receive_packet_player_change_government_100(pc, type);
  default:
    log_debug("Unknown PACKET_PLAYER_CHANGE_GOVERNMENT variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_player_change_government(struct connection *pc, const struct packet_player_change_government *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_player_change_government from the server.");
  }
  ensure_valid_variant_packet_player_change_government(pc);

  switch(pc->phs.variant[PACKET_PLAYER_CHANGE_GOVERNMENT]) {

  case 100:
    return send_packet_player_change_government_100(pc, packet);
  default:
    log_debug("Unknown PACKET_PLAYER_CHANGE_GOVERNMENT variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_player_change_government(struct connection *pc, int government)
{
  struct packet_player_change_government packet, *real_packet = &packet;

  real_packet->government = government;
  
  return send_packet_player_change_government(pc, real_packet);
}

#define hash_packet_player_research_100 hash_const

#define cmp_packet_player_research_100 cmp_const

BV_DEFINE(packet_player_research_100_fields, 1);

static struct packet_player_research *receive_packet_player_research_100(struct connection *pc, enum packet_type type)
{
  packet_player_research_100_fields fields;
  struct packet_player_research *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_player_research, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_player_research_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_research_100, cmp_packet_player_research_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'tech'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->tech = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_research_100(struct connection *pc, const struct packet_player_research *packet)
{
  const struct packet_player_research *real_packet = packet;
  packet_player_research_100_fields fields;
  struct packet_player_research *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_RESEARCH;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_RESEARCH);

  log_packet_detailed("packet_player_research_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_research_100, cmp_packet_player_research_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->tech != real_packet->tech);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'tech' has changed");
    dio_put_uint8(&dout, real_packet->tech);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_player_research(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_PLAYER_RESEARCH] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_PLAYER_RESEARCH variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_PLAYER_RESEARCH] = variant;
}

struct packet_player_research *receive_packet_player_research(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_player_research at the client.");
  }
  ensure_valid_variant_packet_player_research(pc);

  switch(pc->phs.variant[PACKET_PLAYER_RESEARCH]) {
  case 100:
    return receive_packet_player_research_100(pc, type);
  default:
    log_debug("Unknown PACKET_PLAYER_RESEARCH variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_player_research(struct connection *pc, const struct packet_player_research *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_player_research from the server.");
  }
  ensure_valid_variant_packet_player_research(pc);

  switch(pc->phs.variant[PACKET_PLAYER_RESEARCH]) {

  case 100:
    return send_packet_player_research_100(pc, packet);
  default:
    log_debug("Unknown PACKET_PLAYER_RESEARCH variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_player_research(struct connection *pc, int tech)
{
  struct packet_player_research packet, *real_packet = &packet;

  real_packet->tech = tech;
  
  return send_packet_player_research(pc, real_packet);
}

#define hash_packet_player_tech_goal_100 hash_const

#define cmp_packet_player_tech_goal_100 cmp_const

BV_DEFINE(packet_player_tech_goal_100_fields, 1);

static struct packet_player_tech_goal *receive_packet_player_tech_goal_100(struct connection *pc, enum packet_type type)
{
  packet_player_tech_goal_100_fields fields;
  struct packet_player_tech_goal *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_player_tech_goal, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_player_tech_goal_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_tech_goal_100, cmp_packet_player_tech_goal_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'tech'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->tech = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_tech_goal_100(struct connection *pc, const struct packet_player_tech_goal *packet)
{
  const struct packet_player_tech_goal *real_packet = packet;
  packet_player_tech_goal_100_fields fields;
  struct packet_player_tech_goal *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_TECH_GOAL;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_TECH_GOAL);

  log_packet_detailed("packet_player_tech_goal_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_tech_goal_100, cmp_packet_player_tech_goal_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->tech != real_packet->tech);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'tech' has changed");
    dio_put_uint8(&dout, real_packet->tech);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_player_tech_goal(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_PLAYER_TECH_GOAL] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_PLAYER_TECH_GOAL variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_PLAYER_TECH_GOAL] = variant;
}

struct packet_player_tech_goal *receive_packet_player_tech_goal(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_player_tech_goal at the client.");
  }
  ensure_valid_variant_packet_player_tech_goal(pc);

  switch(pc->phs.variant[PACKET_PLAYER_TECH_GOAL]) {
  case 100:
    return receive_packet_player_tech_goal_100(pc, type);
  default:
    log_debug("Unknown PACKET_PLAYER_TECH_GOAL variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_player_tech_goal(struct connection *pc, const struct packet_player_tech_goal *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_player_tech_goal from the server.");
  }
  ensure_valid_variant_packet_player_tech_goal(pc);

  switch(pc->phs.variant[PACKET_PLAYER_TECH_GOAL]) {

  case 100:
    return send_packet_player_tech_goal_100(pc, packet);
  default:
    log_debug("Unknown PACKET_PLAYER_TECH_GOAL variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_player_tech_goal(struct connection *pc, int tech)
{
  struct packet_player_tech_goal packet, *real_packet = &packet;

  real_packet->tech = tech;
  
  return send_packet_player_tech_goal(pc, real_packet);
}

static struct packet_player_attribute_block *receive_packet_player_attribute_block_100(struct connection *pc, enum packet_type type)
{
  RECEIVE_PACKET_START(packet_player_attribute_block, real_packet);

  log_packet_detailed("packet_player_attribute_block_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_attribute_block_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_PLAYER_ATTRIBUTE_BLOCK);

  log_packet_detailed("packet_player_attribute_block_100: sending info about ()");
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_player_attribute_block(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_PLAYER_ATTRIBUTE_BLOCK] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_PLAYER_ATTRIBUTE_BLOCK variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_PLAYER_ATTRIBUTE_BLOCK] = variant;
}

struct packet_player_attribute_block *receive_packet_player_attribute_block(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_player_attribute_block at the client.");
  }
  ensure_valid_variant_packet_player_attribute_block(pc);

  switch(pc->phs.variant[PACKET_PLAYER_ATTRIBUTE_BLOCK]) {
  case 100:
    return receive_packet_player_attribute_block_100(pc, type);
  default:
    log_debug("Unknown PACKET_PLAYER_ATTRIBUTE_BLOCK variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_player_attribute_block(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_player_attribute_block from the server.");
  }
  ensure_valid_variant_packet_player_attribute_block(pc);

  switch(pc->phs.variant[PACKET_PLAYER_ATTRIBUTE_BLOCK]) {

  case 100:
    return send_packet_player_attribute_block_100(pc);
  default:
    log_debug("Unknown PACKET_PLAYER_ATTRIBUTE_BLOCK variant for connection %s", conn_description(pc));
    return -1;
  }
}
static genhash_val_t hash_packet_player_attribute_chunk_100(const void *vkey, size_t num_buckets)
{
  const struct packet_player_attribute_chunk *key = (const struct packet_player_attribute_chunk *) vkey;

  return ((key->offset) % num_buckets);
}

static bool cmp_packet_player_attribute_chunk_100(const void *vkey1, const void *vkey2)
{
  const struct packet_player_attribute_chunk *key1 = (const struct packet_player_attribute_chunk *) vkey1;
  const struct packet_player_attribute_chunk *key2 = (const struct packet_player_attribute_chunk *) vkey2;

  return key1->offset == key2->offset;
}

BV_DEFINE(packet_player_attribute_chunk_100_fields, 3);

static struct packet_player_attribute_chunk *receive_packet_player_attribute_chunk_100(struct connection *pc, enum packet_type type)
{
  packet_player_attribute_chunk_100_fields fields;
  struct packet_player_attribute_chunk *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_player_attribute_chunk, real_packet);

  DIO_BV_GET(&din, fields);
  {
    int readin;
  
    dio_get_uint32(&din, &readin);
    real_packet->offset = readin;
  }

  log_packet_detailed("packet_player_attribute_chunk_100: got info about (%d)",
    real_packet->offset);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_attribute_chunk_100, cmp_packet_player_attribute_chunk_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int offset = real_packet->offset;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->offset = offset;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'total_length'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->total_length = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'chunk_length'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->chunk_length = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'data'");
    
      if(real_packet->chunk_length > ATTRIBUTE_CHUNK_SIZE) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->chunk_length = ATTRIBUTE_CHUNK_SIZE;
      }
      dio_get_memory(&din, real_packet->data, real_packet->chunk_length);
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_attribute_chunk_100(struct connection *pc, const struct packet_player_attribute_chunk *packet)
{
  const struct packet_player_attribute_chunk *real_packet = packet;
  packet_player_attribute_chunk_100_fields fields;
  struct packet_player_attribute_chunk *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_ATTRIBUTE_CHUNK;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_ATTRIBUTE_CHUNK);

  log_packet_detailed("packet_player_attribute_chunk_100: sending info about (%d)",
    real_packet->offset);

  {
    struct packet_player_attribute_chunk *tmp = fc_malloc(sizeof(*tmp));

    *tmp = *packet;
    pre_send_packet_player_attribute_chunk(pc, tmp);
    real_packet = tmp;
  }

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_attribute_chunk_100, cmp_packet_player_attribute_chunk_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->total_length != real_packet->total_length);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->chunk_length != real_packet->chunk_length);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (memcmp(old->data, real_packet->data, ATTRIBUTE_CHUNK_SIZE) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, fields);
  dio_put_uint32(&dout, real_packet->offset);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'total_length' has changed");
    dio_put_uint32(&dout, real_packet->total_length);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'chunk_length' has changed");
    dio_put_uint32(&dout, real_packet->chunk_length);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'data' has changed");
    dio_put_memory(&dout, &real_packet->data, real_packet->chunk_length);
  }

  *old = *real_packet;

  if (real_packet != packet) {
    free((void *) real_packet);
  }
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_player_attribute_chunk(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_PLAYER_ATTRIBUTE_CHUNK] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_PLAYER_ATTRIBUTE_CHUNK variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_PLAYER_ATTRIBUTE_CHUNK] = variant;
}

struct packet_player_attribute_chunk *receive_packet_player_attribute_chunk(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  ensure_valid_variant_packet_player_attribute_chunk(pc);

  switch(pc->phs.variant[PACKET_PLAYER_ATTRIBUTE_CHUNK]) {
  case 100:
    return receive_packet_player_attribute_chunk_100(pc, type);
  default:
    log_debug("Unknown PACKET_PLAYER_ATTRIBUTE_CHUNK variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_player_attribute_chunk(struct connection *pc, const struct packet_player_attribute_chunk *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  ensure_valid_variant_packet_player_attribute_chunk(pc);

  switch(pc->phs.variant[PACKET_PLAYER_ATTRIBUTE_CHUNK]) {

  case 100:
    return send_packet_player_attribute_chunk_100(pc, packet);
  default:
    log_debug("Unknown PACKET_PLAYER_ATTRIBUTE_CHUNK variant for connection %s", conn_description(pc));
    return -1;
  }
}
static genhash_val_t hash_packet_player_diplstate_100(const void *vkey, size_t num_buckets)
{
  const struct packet_player_diplstate *key = (const struct packet_player_diplstate *) vkey;

  return ((key->diplstate_id) % num_buckets);
}

static bool cmp_packet_player_diplstate_100(const void *vkey1, const void *vkey2)
{
  const struct packet_player_diplstate *key1 = (const struct packet_player_diplstate *) vkey1;
  const struct packet_player_diplstate *key2 = (const struct packet_player_diplstate *) vkey2;

  return key1->diplstate_id == key2->diplstate_id;
}

BV_DEFINE(packet_player_diplstate_100_fields, 6);

static struct packet_player_diplstate *receive_packet_player_diplstate_100(struct connection *pc, enum packet_type type)
{
  packet_player_diplstate_100_fields fields;
  struct packet_player_diplstate *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_player_diplstate, real_packet);

  DIO_BV_GET(&din, fields);
  {
    int readin;
  
    dio_get_uint32(&din, &readin);
    real_packet->diplstate_id = readin;
  }

  log_packet_detailed("packet_player_diplstate_100: got info about (%d)",
    real_packet->diplstate_id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_diplstate_100, cmp_packet_player_diplstate_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int diplstate_id = real_packet->diplstate_id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->diplstate_id = diplstate_id;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'plr1'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->plr1 = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'plr2'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->plr2 = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'turns_left'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->turns_left = readin;
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'has_reason_to_cancel'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->has_reason_to_cancel = readin;
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'contact_turns_left'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->contact_turns_left = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_diplstate_100(struct connection *pc, const struct packet_player_diplstate *packet)
{
  const struct packet_player_diplstate *real_packet = packet;
  packet_player_diplstate_100_fields fields;
  struct packet_player_diplstate *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_DIPLSTATE;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_DIPLSTATE);

  log_packet_detailed("packet_player_diplstate_100: sending info about (%d)",
    real_packet->diplstate_id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_diplstate_100, cmp_packet_player_diplstate_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->plr1 != real_packet->plr1);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->plr2 != real_packet->plr2);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->turns_left != real_packet->turns_left);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->has_reason_to_cancel != real_packet->has_reason_to_cancel);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->contact_turns_left != real_packet->contact_turns_left);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


  DIO_BV_PUT(&dout, fields);
  dio_put_uint32(&dout, real_packet->diplstate_id);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'plr1' has changed");
    dio_put_sint8(&dout, real_packet->plr1);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'plr2' has changed");
    dio_put_sint8(&dout, real_packet->plr2);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'type' has changed");
    dio_put_uint8(&dout, real_packet->type);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'turns_left' has changed");
    dio_put_uint16(&dout, real_packet->turns_left);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'has_reason_to_cancel' has changed");
    dio_put_uint8(&dout, real_packet->has_reason_to_cancel);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'contact_turns_left' has changed");
    dio_put_uint16(&dout, real_packet->contact_turns_left);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_player_diplstate(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_PLAYER_DIPLSTATE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_PLAYER_DIPLSTATE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_PLAYER_DIPLSTATE] = variant;
}

struct packet_player_diplstate *receive_packet_player_diplstate(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_player_diplstate at the server.");
  }
  ensure_valid_variant_packet_player_diplstate(pc);

  switch(pc->phs.variant[PACKET_PLAYER_DIPLSTATE]) {
  case 100:
    return receive_packet_player_diplstate_100(pc, type);
  default:
    log_debug("Unknown PACKET_PLAYER_DIPLSTATE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_player_diplstate(struct connection *pc, const struct packet_player_diplstate *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_player_diplstate from the client.");
  }
  ensure_valid_variant_packet_player_diplstate(pc);

  switch(pc->phs.variant[PACKET_PLAYER_DIPLSTATE]) {

  case 100:
    return send_packet_player_diplstate_100(pc, packet);
  default:
    log_debug("Unknown PACKET_PLAYER_DIPLSTATE variant for connection %s", conn_description(pc));
    return -1;
  }
}
#define hash_packet_unit_remove_100 hash_const

#define cmp_packet_unit_remove_100 cmp_const

BV_DEFINE(packet_unit_remove_100_fields, 1);

static struct packet_unit_remove *receive_packet_unit_remove_100(struct connection *pc, enum packet_type type)
{
  packet_unit_remove_100_fields fields;
  struct packet_unit_remove *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_unit_remove, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_remove_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_remove_100, cmp_packet_unit_remove_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->unit_id = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_UNIT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.received + PACKET_UNIT_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_remove_100(struct connection *pc, const struct packet_unit_remove *packet)
{
  const struct packet_unit_remove *real_packet = packet;
  packet_unit_remove_100_fields fields;
  struct packet_unit_remove *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_REMOVE;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_REMOVE);

  log_packet_detailed("packet_unit_remove_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_remove_100, cmp_packet_unit_remove_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_UNIT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.sent + PACKET_UNIT_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_unit_remove(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_REMOVE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_REMOVE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_REMOVE] = variant;
}

struct packet_unit_remove *receive_packet_unit_remove(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_unit_remove at the server.");
  }
  ensure_valid_variant_packet_unit_remove(pc);

  switch(pc->phs.variant[PACKET_UNIT_REMOVE]) {
  case 100:
    return receive_packet_unit_remove_100(pc, type);
  default:
    log_debug("Unknown PACKET_UNIT_REMOVE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_remove(struct connection *pc, const struct packet_unit_remove *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_unit_remove from the client.");
  }
  ensure_valid_variant_packet_unit_remove(pc);

  switch(pc->phs.variant[PACKET_UNIT_REMOVE]) {

  case 100:
    return send_packet_unit_remove_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_REMOVE variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_unit_remove(struct conn_list *dest, const struct packet_unit_remove *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_unit_remove(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_unit_remove(struct connection *pc, int unit_id)
{
  struct packet_unit_remove packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  
  return send_packet_unit_remove(pc, real_packet);
}

void dlsend_packet_unit_remove(struct conn_list *dest, int unit_id)
{
  struct packet_unit_remove packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  
  lsend_packet_unit_remove(dest, real_packet);
}

static genhash_val_t hash_packet_unit_info_100(const void *vkey, size_t num_buckets)
{
  const struct packet_unit_info *key = (const struct packet_unit_info *) vkey;

  return ((key->id) % num_buckets);
}

static bool cmp_packet_unit_info_100(const void *vkey1, const void *vkey2)
{
  const struct packet_unit_info *key1 = (const struct packet_unit_info *) vkey1;
  const struct packet_unit_info *key2 = (const struct packet_unit_info *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_unit_info_100_fields, 35);

static struct packet_unit_info *receive_packet_unit_info_100(struct connection *pc, enum packet_type type)
{
  packet_unit_info_100_fields fields;
  struct packet_unit_info *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_unit_info, real_packet);

  DIO_BV_GET(&din, fields);
  {
    int readin;
  
    dio_get_uint16(&din, &readin);
    real_packet->id = readin;
  }

  log_packet_detailed("packet_unit_info_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_info_100, cmp_packet_unit_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'owner'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->owner = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'tile'");
    {
      int readin;
    
      dio_get_sint32(&din, &readin);
      real_packet->tile = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'facing'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->facing = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'homecity'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->homecity = readin;
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'upkeep'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->upkeep[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'veteran'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->veteran = readin;
    }
  }
  real_packet->ai = BV_ISSET(fields, 6);
  real_packet->paradropped = BV_ISSET(fields, 7);
  real_packet->occupied = BV_ISSET(fields, 8);
  real_packet->transported = BV_ISSET(fields, 9);
  real_packet->done_moving = BV_ISSET(fields, 10);
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'transported_by'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->transported_by = readin;
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'movesleft'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->movesleft = readin;
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'hp'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->hp = readin;
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'fuel'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->fuel = readin;
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'activity_count_new'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->activity_count_new = readin;
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'changed_from_count_new'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->changed_from_count_new = readin;
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'goto_tile'");
    {
      int readin;
    
      dio_get_sint32(&din, &readin);
      real_packet->goto_tile = readin;
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'activity'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->activity = readin;
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'activity_target'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->activity_target = readin;
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  got field 'activity_base'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->activity_base = readin;
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'changed_from'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->changed_from = readin;
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'changed_from_target'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->changed_from_target = readin;
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'changed_from_base'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->changed_from_base = readin;
    }
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  got field 'battlegroup'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->battlegroup = readin;
    }
  }
  real_packet->has_orders = BV_ISSET(fields, 26);
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  got field 'orders_length'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->orders_length = readin;
    }
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  got field 'orders_index'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->orders_index = readin;
    }
  }
  real_packet->orders_repeat = BV_ISSET(fields, 29);
  real_packet->orders_vigilant = BV_ISSET(fields, 30);
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  got field 'orders'");
    
    {
      int i;
    
      if(real_packet->orders_length > MAX_LEN_ROUTE) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->orders_length = MAX_LEN_ROUTE;
      }
      for (i = 0; i < real_packet->orders_length; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->orders[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  got field 'orders_dirs'");
    
    {
      int i;
    
      if(real_packet->orders_length > MAX_LEN_ROUTE) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->orders_length = MAX_LEN_ROUTE;
      }
      for (i = 0; i < real_packet->orders_length; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->orders_dirs[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  got field 'orders_activities'");
    
    {
      int i;
    
      if(real_packet->orders_length > MAX_LEN_ROUTE) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->orders_length = MAX_LEN_ROUTE;
      }
      for (i = 0; i < real_packet->orders_length; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->orders_activities[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  got field 'orders_bases'");
    
    {
      int i;
    
      if(real_packet->orders_length > MAX_LEN_ROUTE) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->orders_length = MAX_LEN_ROUTE;
      }
      for (i = 0; i < real_packet->orders_length; i++) {
        {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->orders_bases[i] = readin;
    }
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_UNIT_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_info_100(struct connection *pc, const struct packet_unit_info *packet)
{
  const struct packet_unit_info *real_packet = packet;
  packet_unit_info_100_fields fields;
  struct packet_unit_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_INFO);

  log_packet_detailed("packet_unit_info_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_info_100, cmp_packet_unit_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->owner != real_packet->owner);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->facing != real_packet->facing);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->homecity != real_packet->homecity);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->upkeep[i] != real_packet->upkeep[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->veteran != real_packet->veteran);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->ai != real_packet->ai);
  if(differ) {
    different++;
  }
  if (packet->ai) {
    BV_SET(fields, 6);
  }

  differ = (old->paradropped != real_packet->paradropped);
  if(differ) {
    different++;
  }
  if (packet->paradropped) {
    BV_SET(fields, 7);
  }

  differ = (old->occupied != real_packet->occupied);
  if(differ) {
    different++;
  }
  if (packet->occupied) {
    BV_SET(fields, 8);
  }

  differ = (old->transported != real_packet->transported);
  if(differ) {
    different++;
  }
  if (packet->transported) {
    BV_SET(fields, 9);
  }

  differ = (old->done_moving != real_packet->done_moving);
  if(differ) {
    different++;
  }
  if (packet->done_moving) {
    BV_SET(fields, 10);
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = (old->transported_by != real_packet->transported_by);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = (old->movesleft != real_packet->movesleft);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->hp != real_packet->hp);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->fuel != real_packet->fuel);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (old->activity_count_new != real_packet->activity_count_new);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }

  differ = (old->changed_from_count_new != real_packet->changed_from_count_new);
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }

  differ = (old->goto_tile != real_packet->goto_tile);
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }

  differ = (old->activity != real_packet->activity);
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }

  differ = (old->activity_target != real_packet->activity_target);
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }

  differ = (old->activity_base != real_packet->activity_base);
  if (differ) {
    different++;
    BV_SET(fields, 21);
  }

  differ = (old->changed_from != real_packet->changed_from);
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (old->changed_from_target != real_packet->changed_from_target);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }

  differ = (old->changed_from_base != real_packet->changed_from_base);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }

  differ = (old->battlegroup != real_packet->battlegroup);
  if (differ) {
    different++;
    BV_SET(fields, 25);
  }

  differ = (old->has_orders != real_packet->has_orders);
  if(differ) {
    different++;
  }
  if (packet->has_orders) {
    BV_SET(fields, 26);
  }

  differ = (old->orders_length != real_packet->orders_length);
  if (differ) {
    different++;
    BV_SET(fields, 27);
  }

  differ = (old->orders_index != real_packet->orders_index);
  if (differ) {
    different++;
    BV_SET(fields, 28);
  }

  differ = (old->orders_repeat != real_packet->orders_repeat);
  if(differ) {
    different++;
  }
  if (packet->orders_repeat) {
    BV_SET(fields, 29);
  }

  differ = (old->orders_vigilant != real_packet->orders_vigilant);
  if(differ) {
    different++;
  }
  if (packet->orders_vigilant) {
    BV_SET(fields, 30);
  }


    {
      differ = (old->orders_length != real_packet->orders_length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->orders_length; i++) {
          if (old->orders[i] != real_packet->orders[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 31);
  }


    {
      differ = (old->orders_length != real_packet->orders_length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->orders_length; i++) {
          if (old->orders_dirs[i] != real_packet->orders_dirs[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 32);
  }


    {
      differ = (old->orders_length != real_packet->orders_length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->orders_length; i++) {
          if (old->orders_activities[i] != real_packet->orders_activities[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 33);
  }


    {
      differ = (old->orders_length != real_packet->orders_length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->orders_length; i++) {
          if (old->orders_bases[i] != real_packet->orders_bases[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 34);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, fields);
  dio_put_uint16(&dout, real_packet->id);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'owner' has changed");
    dio_put_sint8(&dout, real_packet->owner);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'tile' has changed");
    dio_put_sint32(&dout, real_packet->tile);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'facing' has changed");
    dio_put_uint8(&dout, real_packet->facing);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'homecity' has changed");
    dio_put_uint16(&dout, real_packet->homecity);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'upkeep' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint8(&dout, real_packet->upkeep[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'veteran' has changed");
    dio_put_uint8(&dout, real_packet->veteran);
  }
  /* field 6 is folded into the header */
  /* field 7 is folded into the header */
  /* field 8 is folded into the header */
  /* field 9 is folded into the header */
  /* field 10 is folded into the header */
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'type' has changed");
    dio_put_uint8(&dout, real_packet->type);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'transported_by' has changed");
    dio_put_uint16(&dout, real_packet->transported_by);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'movesleft' has changed");
    dio_put_uint8(&dout, real_packet->movesleft);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'hp' has changed");
    dio_put_uint8(&dout, real_packet->hp);
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'fuel' has changed");
    dio_put_uint8(&dout, real_packet->fuel);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'activity_count_new' has changed");
    dio_put_uint16(&dout, real_packet->activity_count_new);
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'changed_from_count_new' has changed");
    dio_put_uint16(&dout, real_packet->changed_from_count_new);
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'goto_tile' has changed");
    dio_put_sint32(&dout, real_packet->goto_tile);
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'activity' has changed");
    dio_put_uint8(&dout, real_packet->activity);
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'activity_target' has changed");
    dio_put_uint16(&dout, real_packet->activity_target);
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  field 'activity_base' has changed");
    dio_put_sint8(&dout, real_packet->activity_base);
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'changed_from' has changed");
    dio_put_uint8(&dout, real_packet->changed_from);
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'changed_from_target' has changed");
    dio_put_uint16(&dout, real_packet->changed_from_target);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'changed_from_base' has changed");
    dio_put_sint8(&dout, real_packet->changed_from_base);
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  field 'battlegroup' has changed");
    dio_put_sint8(&dout, real_packet->battlegroup);
  }
  /* field 26 is folded into the header */
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  field 'orders_length' has changed");
    dio_put_uint16(&dout, real_packet->orders_length);
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  field 'orders_index' has changed");
    dio_put_uint16(&dout, real_packet->orders_index);
  }
  /* field 29 is folded into the header */
  /* field 30 is folded into the header */
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  field 'orders' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->orders_length; i++) {
        dio_put_uint8(&dout, real_packet->orders[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  field 'orders_dirs' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->orders_length; i++) {
        dio_put_uint8(&dout, real_packet->orders_dirs[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  field 'orders_activities' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->orders_length; i++) {
        dio_put_uint8(&dout, real_packet->orders_activities[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  field 'orders_bases' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->orders_length; i++) {
        dio_put_sint8(&dout, real_packet->orders_bases[i]);
      }
    } 
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_UNIT_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  SEND_PACKET_END;
}

static genhash_val_t hash_packet_unit_info_101(const void *vkey, size_t num_buckets)
{
  const struct packet_unit_info *key = (const struct packet_unit_info *) vkey;

  return ((key->id) % num_buckets);
}

static bool cmp_packet_unit_info_101(const void *vkey1, const void *vkey2)
{
  const struct packet_unit_info *key1 = (const struct packet_unit_info *) vkey1;
  const struct packet_unit_info *key2 = (const struct packet_unit_info *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_unit_info_101_fields, 35);

static struct packet_unit_info *receive_packet_unit_info_101(struct connection *pc, enum packet_type type)
{
  packet_unit_info_101_fields fields;
  struct packet_unit_info *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_unit_info, real_packet);

  DIO_BV_GET(&din, fields);
  {
    int readin;
  
    dio_get_uint16(&din, &readin);
    real_packet->id = readin;
  }

  log_packet_detailed("packet_unit_info_101: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_info_101, cmp_packet_unit_info_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'owner'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->owner = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'tile'");
    {
      int readin;
    
      dio_get_sint32(&din, &readin);
      real_packet->tile = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'facing'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->facing = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'homecity'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->homecity = readin;
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'upkeep'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->upkeep[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'veteran'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->veteran = readin;
    }
  }
  real_packet->ai = BV_ISSET(fields, 6);
  real_packet->paradropped = BV_ISSET(fields, 7);
  real_packet->occupied = BV_ISSET(fields, 8);
  real_packet->transported = BV_ISSET(fields, 9);
  real_packet->done_moving = BV_ISSET(fields, 10);
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'transported_by'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->transported_by = readin;
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'movesleft'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->movesleft = readin;
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'hp'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->hp = readin;
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'fuel'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->fuel = readin;
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'activity_count_old'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->activity_count_old = readin;
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'changed_from_count_old'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->changed_from_count_old = readin;
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'goto_tile'");
    {
      int readin;
    
      dio_get_sint32(&din, &readin);
      real_packet->goto_tile = readin;
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'activity'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->activity = readin;
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'activity_target'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->activity_target = readin;
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  got field 'activity_base'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->activity_base = readin;
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'changed_from'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->changed_from = readin;
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'changed_from_target'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->changed_from_target = readin;
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'changed_from_base'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->changed_from_base = readin;
    }
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  got field 'battlegroup'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->battlegroup = readin;
    }
  }
  real_packet->has_orders = BV_ISSET(fields, 26);
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  got field 'orders_length'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->orders_length = readin;
    }
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  got field 'orders_index'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->orders_index = readin;
    }
  }
  real_packet->orders_repeat = BV_ISSET(fields, 29);
  real_packet->orders_vigilant = BV_ISSET(fields, 30);
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  got field 'orders'");
    
    {
      int i;
    
      if(real_packet->orders_length > MAX_LEN_ROUTE) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->orders_length = MAX_LEN_ROUTE;
      }
      for (i = 0; i < real_packet->orders_length; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->orders[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  got field 'orders_dirs'");
    
    {
      int i;
    
      if(real_packet->orders_length > MAX_LEN_ROUTE) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->orders_length = MAX_LEN_ROUTE;
      }
      for (i = 0; i < real_packet->orders_length; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->orders_dirs[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  got field 'orders_activities'");
    
    {
      int i;
    
      if(real_packet->orders_length > MAX_LEN_ROUTE) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->orders_length = MAX_LEN_ROUTE;
      }
      for (i = 0; i < real_packet->orders_length; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->orders_activities[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  got field 'orders_bases'");
    
    {
      int i;
    
      if(real_packet->orders_length > MAX_LEN_ROUTE) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->orders_length = MAX_LEN_ROUTE;
      }
      for (i = 0; i < real_packet->orders_length; i++) {
        {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->orders_bases[i] = readin;
    }
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_UNIT_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_info_101(struct connection *pc, const struct packet_unit_info *packet)
{
  const struct packet_unit_info *real_packet = packet;
  packet_unit_info_101_fields fields;
  struct packet_unit_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_INFO);

  log_packet_detailed("packet_unit_info_101: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_info_101, cmp_packet_unit_info_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->owner != real_packet->owner);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->facing != real_packet->facing);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->homecity != real_packet->homecity);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->upkeep[i] != real_packet->upkeep[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->veteran != real_packet->veteran);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->ai != real_packet->ai);
  if(differ) {
    different++;
  }
  if (packet->ai) {
    BV_SET(fields, 6);
  }

  differ = (old->paradropped != real_packet->paradropped);
  if(differ) {
    different++;
  }
  if (packet->paradropped) {
    BV_SET(fields, 7);
  }

  differ = (old->occupied != real_packet->occupied);
  if(differ) {
    different++;
  }
  if (packet->occupied) {
    BV_SET(fields, 8);
  }

  differ = (old->transported != real_packet->transported);
  if(differ) {
    different++;
  }
  if (packet->transported) {
    BV_SET(fields, 9);
  }

  differ = (old->done_moving != real_packet->done_moving);
  if(differ) {
    different++;
  }
  if (packet->done_moving) {
    BV_SET(fields, 10);
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = (old->transported_by != real_packet->transported_by);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = (old->movesleft != real_packet->movesleft);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->hp != real_packet->hp);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->fuel != real_packet->fuel);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (old->activity_count_old != real_packet->activity_count_old);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }

  differ = (old->changed_from_count_old != real_packet->changed_from_count_old);
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }

  differ = (old->goto_tile != real_packet->goto_tile);
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }

  differ = (old->activity != real_packet->activity);
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }

  differ = (old->activity_target != real_packet->activity_target);
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }

  differ = (old->activity_base != real_packet->activity_base);
  if (differ) {
    different++;
    BV_SET(fields, 21);
  }

  differ = (old->changed_from != real_packet->changed_from);
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (old->changed_from_target != real_packet->changed_from_target);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }

  differ = (old->changed_from_base != real_packet->changed_from_base);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }

  differ = (old->battlegroup != real_packet->battlegroup);
  if (differ) {
    different++;
    BV_SET(fields, 25);
  }

  differ = (old->has_orders != real_packet->has_orders);
  if(differ) {
    different++;
  }
  if (packet->has_orders) {
    BV_SET(fields, 26);
  }

  differ = (old->orders_length != real_packet->orders_length);
  if (differ) {
    different++;
    BV_SET(fields, 27);
  }

  differ = (old->orders_index != real_packet->orders_index);
  if (differ) {
    different++;
    BV_SET(fields, 28);
  }

  differ = (old->orders_repeat != real_packet->orders_repeat);
  if(differ) {
    different++;
  }
  if (packet->orders_repeat) {
    BV_SET(fields, 29);
  }

  differ = (old->orders_vigilant != real_packet->orders_vigilant);
  if(differ) {
    different++;
  }
  if (packet->orders_vigilant) {
    BV_SET(fields, 30);
  }


    {
      differ = (old->orders_length != real_packet->orders_length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->orders_length; i++) {
          if (old->orders[i] != real_packet->orders[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 31);
  }


    {
      differ = (old->orders_length != real_packet->orders_length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->orders_length; i++) {
          if (old->orders_dirs[i] != real_packet->orders_dirs[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 32);
  }


    {
      differ = (old->orders_length != real_packet->orders_length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->orders_length; i++) {
          if (old->orders_activities[i] != real_packet->orders_activities[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 33);
  }


    {
      differ = (old->orders_length != real_packet->orders_length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->orders_length; i++) {
          if (old->orders_bases[i] != real_packet->orders_bases[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 34);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, fields);
  dio_put_uint16(&dout, real_packet->id);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'owner' has changed");
    dio_put_sint8(&dout, real_packet->owner);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'tile' has changed");
    dio_put_sint32(&dout, real_packet->tile);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'facing' has changed");
    dio_put_uint8(&dout, real_packet->facing);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'homecity' has changed");
    dio_put_uint16(&dout, real_packet->homecity);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'upkeep' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint8(&dout, real_packet->upkeep[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'veteran' has changed");
    dio_put_uint8(&dout, real_packet->veteran);
  }
  /* field 6 is folded into the header */
  /* field 7 is folded into the header */
  /* field 8 is folded into the header */
  /* field 9 is folded into the header */
  /* field 10 is folded into the header */
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'type' has changed");
    dio_put_uint8(&dout, real_packet->type);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'transported_by' has changed");
    dio_put_uint16(&dout, real_packet->transported_by);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'movesleft' has changed");
    dio_put_uint8(&dout, real_packet->movesleft);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'hp' has changed");
    dio_put_uint8(&dout, real_packet->hp);
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'fuel' has changed");
    dio_put_uint8(&dout, real_packet->fuel);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'activity_count_old' has changed");
    dio_put_uint8(&dout, real_packet->activity_count_old);
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'changed_from_count_old' has changed");
    dio_put_uint8(&dout, real_packet->changed_from_count_old);
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'goto_tile' has changed");
    dio_put_sint32(&dout, real_packet->goto_tile);
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'activity' has changed");
    dio_put_uint8(&dout, real_packet->activity);
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'activity_target' has changed");
    dio_put_uint16(&dout, real_packet->activity_target);
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  field 'activity_base' has changed");
    dio_put_sint8(&dout, real_packet->activity_base);
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'changed_from' has changed");
    dio_put_uint8(&dout, real_packet->changed_from);
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'changed_from_target' has changed");
    dio_put_uint16(&dout, real_packet->changed_from_target);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'changed_from_base' has changed");
    dio_put_sint8(&dout, real_packet->changed_from_base);
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  field 'battlegroup' has changed");
    dio_put_sint8(&dout, real_packet->battlegroup);
  }
  /* field 26 is folded into the header */
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  field 'orders_length' has changed");
    dio_put_uint16(&dout, real_packet->orders_length);
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  field 'orders_index' has changed");
    dio_put_uint16(&dout, real_packet->orders_index);
  }
  /* field 29 is folded into the header */
  /* field 30 is folded into the header */
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  field 'orders' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->orders_length; i++) {
        dio_put_uint8(&dout, real_packet->orders[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  field 'orders_dirs' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->orders_length; i++) {
        dio_put_uint8(&dout, real_packet->orders_dirs[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  field 'orders_activities' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->orders_length; i++) {
        dio_put_uint8(&dout, real_packet->orders_activities[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  field 'orders_bases' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->orders_length; i++) {
        dio_put_sint8(&dout, real_packet->orders_bases[i]);
      }
    } 
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_UNIT_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_unit_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if((has_capability("actcount_range", pc->capability) && has_capability("actcount_range", our_capability))) {
    variant = 100;
  } else if(!(has_capability("actcount_range", pc->capability) && has_capability("actcount_range", our_capability))) {
    variant = 101;
  } else {
    log_error("Unknown PACKET_UNIT_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  log_packet_detailed("packet_unit_info: using variant=%d cap=%s", variant, pc->capability);
  pc->phs.variant[PACKET_UNIT_INFO] = variant;
}

struct packet_unit_info *receive_packet_unit_info(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_unit_info at the server.");
  }
  ensure_valid_variant_packet_unit_info(pc);

  switch(pc->phs.variant[PACKET_UNIT_INFO]) {
  case 100:
    return receive_packet_unit_info_100(pc, type);
  case 101:
    return receive_packet_unit_info_101(pc, type);
  default:
    log_debug("Unknown PACKET_UNIT_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_info(struct connection *pc, const struct packet_unit_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_unit_info from the client.");
  }
  ensure_valid_variant_packet_unit_info(pc);

  switch(pc->phs.variant[PACKET_UNIT_INFO]) {

  case 100:
    return send_packet_unit_info_100(pc, packet);
  case 101:
    return send_packet_unit_info_101(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_unit_info(struct conn_list *dest, const struct packet_unit_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_unit_info(pconn, packet);
  } conn_list_iterate_end;
}

static genhash_val_t hash_packet_unit_short_info_100(const void *vkey, size_t num_buckets)
{
  const struct packet_unit_short_info *key = (const struct packet_unit_short_info *) vkey;

  return ((key->id) % num_buckets);
}

static bool cmp_packet_unit_short_info_100(const void *vkey1, const void *vkey2)
{
  const struct packet_unit_short_info *key1 = (const struct packet_unit_short_info *) vkey1;
  const struct packet_unit_short_info *key2 = (const struct packet_unit_short_info *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_unit_short_info_100_fields, 15);

static struct packet_unit_short_info *receive_packet_unit_short_info_100(struct connection *pc, enum packet_type type)
{
  packet_unit_short_info_100_fields fields;
  struct packet_unit_short_info *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_unit_short_info, real_packet);

  DIO_BV_GET(&din, fields);
  {
    int readin;
  
    dio_get_uint16(&din, &readin);
    real_packet->id = readin;
  }

  log_packet_detailed("packet_unit_short_info_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_short_info_100, cmp_packet_unit_short_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'owner'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->owner = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'tile'");
    {
      int readin;
    
      dio_get_sint32(&din, &readin);
      real_packet->tile = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'facing'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->facing = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'veteran'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->veteran = readin;
    }
  }
  real_packet->occupied = BV_ISSET(fields, 5);
  real_packet->goes_out_of_sight = BV_ISSET(fields, 6);
  real_packet->transported = BV_ISSET(fields, 7);
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'hp'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->hp = readin;
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'activity'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->activity = readin;
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'activity_base'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->activity_base = readin;
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'transported_by'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->transported_by = readin;
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'packet_use'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->packet_use = readin;
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'info_city_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->info_city_id = readin;
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'serial_num'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->serial_num = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_UNIT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_short_info_100(struct connection *pc, const struct packet_unit_short_info *packet)
{
  const struct packet_unit_short_info *real_packet = packet;
  packet_unit_short_info_100_fields fields;
  struct packet_unit_short_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_SHORT_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_SHORT_INFO);

  log_packet_detailed("packet_unit_short_info_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_short_info_100, cmp_packet_unit_short_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->owner != real_packet->owner);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->facing != real_packet->facing);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->veteran != real_packet->veteran);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->occupied != real_packet->occupied);
  if(differ) {
    different++;
  }
  if (packet->occupied) {
    BV_SET(fields, 5);
  }

  differ = (old->goes_out_of_sight != real_packet->goes_out_of_sight);
  if(differ) {
    different++;
  }
  if (packet->goes_out_of_sight) {
    BV_SET(fields, 6);
  }

  differ = (old->transported != real_packet->transported);
  if(differ) {
    different++;
  }
  if (packet->transported) {
    BV_SET(fields, 7);
  }

  differ = (old->hp != real_packet->hp);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->activity != real_packet->activity);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->activity_base != real_packet->activity_base);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->transported_by != real_packet->transported_by);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = (old->packet_use != real_packet->packet_use);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = (old->info_city_id != real_packet->info_city_id);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->serial_num != real_packet->serial_num);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, fields);
  dio_put_uint16(&dout, real_packet->id);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'owner' has changed");
    dio_put_sint8(&dout, real_packet->owner);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'tile' has changed");
    dio_put_sint32(&dout, real_packet->tile);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'facing' has changed");
    dio_put_uint8(&dout, real_packet->facing);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'type' has changed");
    dio_put_uint8(&dout, real_packet->type);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'veteran' has changed");
    dio_put_uint8(&dout, real_packet->veteran);
  }
  /* field 5 is folded into the header */
  /* field 6 is folded into the header */
  /* field 7 is folded into the header */
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'hp' has changed");
    dio_put_uint8(&dout, real_packet->hp);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'activity' has changed");
    dio_put_uint8(&dout, real_packet->activity);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'activity_base' has changed");
    dio_put_sint8(&dout, real_packet->activity_base);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'transported_by' has changed");
    dio_put_uint16(&dout, real_packet->transported_by);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'packet_use' has changed");
    dio_put_uint8(&dout, real_packet->packet_use);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'info_city_id' has changed");
    dio_put_uint16(&dout, real_packet->info_city_id);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'serial_num' has changed");
    dio_put_uint16(&dout, real_packet->serial_num);
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_UNIT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_unit_short_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_SHORT_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_SHORT_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_SHORT_INFO] = variant;
}

struct packet_unit_short_info *receive_packet_unit_short_info(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_unit_short_info at the server.");
  }
  ensure_valid_variant_packet_unit_short_info(pc);

  switch(pc->phs.variant[PACKET_UNIT_SHORT_INFO]) {
  case 100:
    return receive_packet_unit_short_info_100(pc, type);
  default:
    log_debug("Unknown PACKET_UNIT_SHORT_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_short_info(struct connection *pc, const struct packet_unit_short_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_unit_short_info from the client.");
  }
  ensure_valid_variant_packet_unit_short_info(pc);

  switch(pc->phs.variant[PACKET_UNIT_SHORT_INFO]) {

  case 100:
    return send_packet_unit_short_info_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_SHORT_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_unit_short_info(struct conn_list *dest, const struct packet_unit_short_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_unit_short_info(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_unit_combat_info_100 hash_const

#define cmp_packet_unit_combat_info_100 cmp_const

BV_DEFINE(packet_unit_combat_info_100_fields, 5);

static struct packet_unit_combat_info *receive_packet_unit_combat_info_100(struct connection *pc, enum packet_type type)
{
  packet_unit_combat_info_100_fields fields;
  struct packet_unit_combat_info *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_unit_combat_info, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_combat_info_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_combat_info_100, cmp_packet_unit_combat_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'attacker_unit_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->attacker_unit_id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'defender_unit_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->defender_unit_id = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'attacker_hp'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->attacker_hp = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'defender_hp'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->defender_hp = readin;
    }
  }
  real_packet->make_winner_veteran = BV_ISSET(fields, 4);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_combat_info_100(struct connection *pc, const struct packet_unit_combat_info *packet)
{
  const struct packet_unit_combat_info *real_packet = packet;
  packet_unit_combat_info_100_fields fields;
  struct packet_unit_combat_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_COMBAT_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_COMBAT_INFO);

  log_packet_detailed("packet_unit_combat_info_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_combat_info_100, cmp_packet_unit_combat_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->attacker_unit_id != real_packet->attacker_unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->defender_unit_id != real_packet->defender_unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->attacker_hp != real_packet->attacker_hp);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->defender_hp != real_packet->defender_hp);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->make_winner_veteran != real_packet->make_winner_veteran);
  if(differ) {
    different++;
  }
  if (packet->make_winner_veteran) {
    BV_SET(fields, 4);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'attacker_unit_id' has changed");
    dio_put_uint16(&dout, real_packet->attacker_unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'defender_unit_id' has changed");
    dio_put_uint16(&dout, real_packet->defender_unit_id);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'attacker_hp' has changed");
    dio_put_uint8(&dout, real_packet->attacker_hp);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'defender_hp' has changed");
    dio_put_uint8(&dout, real_packet->defender_hp);
  }
  /* field 4 is folded into the header */

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_unit_combat_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_COMBAT_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_COMBAT_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_COMBAT_INFO] = variant;
}

struct packet_unit_combat_info *receive_packet_unit_combat_info(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_unit_combat_info at the server.");
  }
  ensure_valid_variant_packet_unit_combat_info(pc);

  switch(pc->phs.variant[PACKET_UNIT_COMBAT_INFO]) {
  case 100:
    return receive_packet_unit_combat_info_100(pc, type);
  default:
    log_debug("Unknown PACKET_UNIT_COMBAT_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_combat_info(struct connection *pc, const struct packet_unit_combat_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_unit_combat_info from the client.");
  }
  ensure_valid_variant_packet_unit_combat_info(pc);

  switch(pc->phs.variant[PACKET_UNIT_COMBAT_INFO]) {

  case 100:
    return send_packet_unit_combat_info_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_COMBAT_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_unit_combat_info(struct conn_list *dest, const struct packet_unit_combat_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_unit_combat_info(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_unit_move_100 hash_const

#define cmp_packet_unit_move_100 cmp_const

BV_DEFINE(packet_unit_move_100_fields, 2);

static struct packet_unit_move *receive_packet_unit_move_100(struct connection *pc, enum packet_type type)
{
  packet_unit_move_100_fields fields;
  struct packet_unit_move *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_unit_move, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_move_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_move_100, cmp_packet_unit_move_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->unit_id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'tile'");
    {
      int readin;
    
      dio_get_sint32(&din, &readin);
      real_packet->tile = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_move_100(struct connection *pc, const struct packet_unit_move *packet)
{
  const struct packet_unit_move *real_packet = packet;
  packet_unit_move_100_fields fields;
  struct packet_unit_move *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_MOVE;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_MOVE);

  log_packet_detailed("packet_unit_move_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_move_100, cmp_packet_unit_move_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'tile' has changed");
    dio_put_sint32(&dout, real_packet->tile);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_unit_move(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_MOVE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_MOVE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_MOVE] = variant;
}

struct packet_unit_move *receive_packet_unit_move(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_unit_move at the client.");
  }
  ensure_valid_variant_packet_unit_move(pc);

  switch(pc->phs.variant[PACKET_UNIT_MOVE]) {
  case 100:
    return receive_packet_unit_move_100(pc, type);
  default:
    log_debug("Unknown PACKET_UNIT_MOVE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_move(struct connection *pc, const struct packet_unit_move *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_move from the server.");
  }
  ensure_valid_variant_packet_unit_move(pc);

  switch(pc->phs.variant[PACKET_UNIT_MOVE]) {

  case 100:
    return send_packet_unit_move_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_MOVE variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_move(struct connection *pc, int unit_id, int tile)
{
  struct packet_unit_move packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  real_packet->tile = tile;
  
  return send_packet_unit_move(pc, real_packet);
}

#define hash_packet_unit_build_city_100 hash_const

#define cmp_packet_unit_build_city_100 cmp_const

BV_DEFINE(packet_unit_build_city_100_fields, 2);

static struct packet_unit_build_city *receive_packet_unit_build_city_100(struct connection *pc, enum packet_type type)
{
  packet_unit_build_city_100_fields fields;
  struct packet_unit_build_city *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_unit_build_city, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_build_city_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_build_city_100, cmp_packet_unit_build_city_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->unit_id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    dio_get_string(&din, real_packet->name, sizeof(real_packet->name));
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_build_city_100(struct connection *pc, const struct packet_unit_build_city *packet)
{
  const struct packet_unit_build_city *real_packet = packet;
  packet_unit_build_city_100_fields fields;
  struct packet_unit_build_city *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_BUILD_CITY;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_BUILD_CITY);

  log_packet_detailed("packet_unit_build_city_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_build_city_100, cmp_packet_unit_build_city_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_unit_build_city(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_BUILD_CITY] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_BUILD_CITY variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_BUILD_CITY] = variant;
}

struct packet_unit_build_city *receive_packet_unit_build_city(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_unit_build_city at the client.");
  }
  ensure_valid_variant_packet_unit_build_city(pc);

  switch(pc->phs.variant[PACKET_UNIT_BUILD_CITY]) {
  case 100:
    return receive_packet_unit_build_city_100(pc, type);
  default:
    log_debug("Unknown PACKET_UNIT_BUILD_CITY variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_build_city(struct connection *pc, const struct packet_unit_build_city *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_build_city from the server.");
  }
  ensure_valid_variant_packet_unit_build_city(pc);

  switch(pc->phs.variant[PACKET_UNIT_BUILD_CITY]) {

  case 100:
    return send_packet_unit_build_city_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_BUILD_CITY variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_build_city(struct connection *pc, int unit_id, const char *name)
{
  struct packet_unit_build_city packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  sz_strlcpy(real_packet->name, name);
  
  return send_packet_unit_build_city(pc, real_packet);
}

#define hash_packet_unit_disband_100 hash_const

#define cmp_packet_unit_disband_100 cmp_const

BV_DEFINE(packet_unit_disband_100_fields, 1);

static struct packet_unit_disband *receive_packet_unit_disband_100(struct connection *pc, enum packet_type type)
{
  packet_unit_disband_100_fields fields;
  struct packet_unit_disband *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_unit_disband, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_disband_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_disband_100, cmp_packet_unit_disband_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->unit_id = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_disband_100(struct connection *pc, const struct packet_unit_disband *packet)
{
  const struct packet_unit_disband *real_packet = packet;
  packet_unit_disband_100_fields fields;
  struct packet_unit_disband *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_DISBAND;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_DISBAND);

  log_packet_detailed("packet_unit_disband_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_disband_100, cmp_packet_unit_disband_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_unit_disband(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_DISBAND] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_DISBAND variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_DISBAND] = variant;
}

struct packet_unit_disband *receive_packet_unit_disband(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_unit_disband at the client.");
  }
  ensure_valid_variant_packet_unit_disband(pc);

  switch(pc->phs.variant[PACKET_UNIT_DISBAND]) {
  case 100:
    return receive_packet_unit_disband_100(pc, type);
  default:
    log_debug("Unknown PACKET_UNIT_DISBAND variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_disband(struct connection *pc, const struct packet_unit_disband *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_disband from the server.");
  }
  ensure_valid_variant_packet_unit_disband(pc);

  switch(pc->phs.variant[PACKET_UNIT_DISBAND]) {

  case 100:
    return send_packet_unit_disband_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_DISBAND variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_disband(struct connection *pc, int unit_id)
{
  struct packet_unit_disband packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  
  return send_packet_unit_disband(pc, real_packet);
}

#define hash_packet_unit_change_homecity_100 hash_const

#define cmp_packet_unit_change_homecity_100 cmp_const

BV_DEFINE(packet_unit_change_homecity_100_fields, 2);

static struct packet_unit_change_homecity *receive_packet_unit_change_homecity_100(struct connection *pc, enum packet_type type)
{
  packet_unit_change_homecity_100_fields fields;
  struct packet_unit_change_homecity *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_unit_change_homecity, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_change_homecity_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_change_homecity_100, cmp_packet_unit_change_homecity_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->unit_id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'city_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->city_id = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_change_homecity_100(struct connection *pc, const struct packet_unit_change_homecity *packet)
{
  const struct packet_unit_change_homecity *real_packet = packet;
  packet_unit_change_homecity_100_fields fields;
  struct packet_unit_change_homecity *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_CHANGE_HOMECITY;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_CHANGE_HOMECITY);

  log_packet_detailed("packet_unit_change_homecity_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_change_homecity_100, cmp_packet_unit_change_homecity_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'city_id' has changed");
    dio_put_uint16(&dout, real_packet->city_id);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_unit_change_homecity(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_CHANGE_HOMECITY] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_CHANGE_HOMECITY variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_CHANGE_HOMECITY] = variant;
}

struct packet_unit_change_homecity *receive_packet_unit_change_homecity(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_unit_change_homecity at the client.");
  }
  ensure_valid_variant_packet_unit_change_homecity(pc);

  switch(pc->phs.variant[PACKET_UNIT_CHANGE_HOMECITY]) {
  case 100:
    return receive_packet_unit_change_homecity_100(pc, type);
  default:
    log_debug("Unknown PACKET_UNIT_CHANGE_HOMECITY variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_change_homecity(struct connection *pc, const struct packet_unit_change_homecity *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_change_homecity from the server.");
  }
  ensure_valid_variant_packet_unit_change_homecity(pc);

  switch(pc->phs.variant[PACKET_UNIT_CHANGE_HOMECITY]) {

  case 100:
    return send_packet_unit_change_homecity_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_CHANGE_HOMECITY variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_change_homecity(struct connection *pc, int unit_id, int city_id)
{
  struct packet_unit_change_homecity packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  real_packet->city_id = city_id;
  
  return send_packet_unit_change_homecity(pc, real_packet);
}

#define hash_packet_unit_establish_trade_100 hash_const

#define cmp_packet_unit_establish_trade_100 cmp_const

BV_DEFINE(packet_unit_establish_trade_100_fields, 1);

static struct packet_unit_establish_trade *receive_packet_unit_establish_trade_100(struct connection *pc, enum packet_type type)
{
  packet_unit_establish_trade_100_fields fields;
  struct packet_unit_establish_trade *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_unit_establish_trade, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_establish_trade_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_establish_trade_100, cmp_packet_unit_establish_trade_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->unit_id = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_establish_trade_100(struct connection *pc, const struct packet_unit_establish_trade *packet)
{
  const struct packet_unit_establish_trade *real_packet = packet;
  packet_unit_establish_trade_100_fields fields;
  struct packet_unit_establish_trade *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_ESTABLISH_TRADE;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_ESTABLISH_TRADE);

  log_packet_detailed("packet_unit_establish_trade_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_establish_trade_100, cmp_packet_unit_establish_trade_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_unit_establish_trade(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_ESTABLISH_TRADE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_ESTABLISH_TRADE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_ESTABLISH_TRADE] = variant;
}

struct packet_unit_establish_trade *receive_packet_unit_establish_trade(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_unit_establish_trade at the client.");
  }
  ensure_valid_variant_packet_unit_establish_trade(pc);

  switch(pc->phs.variant[PACKET_UNIT_ESTABLISH_TRADE]) {
  case 100:
    return receive_packet_unit_establish_trade_100(pc, type);
  default:
    log_debug("Unknown PACKET_UNIT_ESTABLISH_TRADE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_establish_trade(struct connection *pc, const struct packet_unit_establish_trade *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_establish_trade from the server.");
  }
  ensure_valid_variant_packet_unit_establish_trade(pc);

  switch(pc->phs.variant[PACKET_UNIT_ESTABLISH_TRADE]) {

  case 100:
    return send_packet_unit_establish_trade_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_ESTABLISH_TRADE variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_establish_trade(struct connection *pc, int unit_id)
{
  struct packet_unit_establish_trade packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  
  return send_packet_unit_establish_trade(pc, real_packet);
}

#define hash_packet_unit_battlegroup_100 hash_const

#define cmp_packet_unit_battlegroup_100 cmp_const

BV_DEFINE(packet_unit_battlegroup_100_fields, 2);

static struct packet_unit_battlegroup *receive_packet_unit_battlegroup_100(struct connection *pc, enum packet_type type)
{
  packet_unit_battlegroup_100_fields fields;
  struct packet_unit_battlegroup *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_unit_battlegroup, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_battlegroup_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_battlegroup_100, cmp_packet_unit_battlegroup_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->unit_id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'battlegroup'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->battlegroup = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_battlegroup_100(struct connection *pc, const struct packet_unit_battlegroup *packet)
{
  const struct packet_unit_battlegroup *real_packet = packet;
  packet_unit_battlegroup_100_fields fields;
  struct packet_unit_battlegroup *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_BATTLEGROUP;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_BATTLEGROUP);

  log_packet_detailed("packet_unit_battlegroup_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_battlegroup_100, cmp_packet_unit_battlegroup_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->battlegroup != real_packet->battlegroup);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'battlegroup' has changed");
    dio_put_sint8(&dout, real_packet->battlegroup);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_unit_battlegroup(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_BATTLEGROUP] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_BATTLEGROUP variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_BATTLEGROUP] = variant;
}

struct packet_unit_battlegroup *receive_packet_unit_battlegroup(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_unit_battlegroup at the client.");
  }
  ensure_valid_variant_packet_unit_battlegroup(pc);

  switch(pc->phs.variant[PACKET_UNIT_BATTLEGROUP]) {
  case 100:
    return receive_packet_unit_battlegroup_100(pc, type);
  default:
    log_debug("Unknown PACKET_UNIT_BATTLEGROUP variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_battlegroup(struct connection *pc, const struct packet_unit_battlegroup *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_battlegroup from the server.");
  }
  ensure_valid_variant_packet_unit_battlegroup(pc);

  switch(pc->phs.variant[PACKET_UNIT_BATTLEGROUP]) {

  case 100:
    return send_packet_unit_battlegroup_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_BATTLEGROUP variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_battlegroup(struct connection *pc, int unit_id, int battlegroup)
{
  struct packet_unit_battlegroup packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  real_packet->battlegroup = battlegroup;
  
  return send_packet_unit_battlegroup(pc, real_packet);
}

#define hash_packet_unit_help_build_wonder_100 hash_const

#define cmp_packet_unit_help_build_wonder_100 cmp_const

BV_DEFINE(packet_unit_help_build_wonder_100_fields, 1);

static struct packet_unit_help_build_wonder *receive_packet_unit_help_build_wonder_100(struct connection *pc, enum packet_type type)
{
  packet_unit_help_build_wonder_100_fields fields;
  struct packet_unit_help_build_wonder *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_unit_help_build_wonder, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_help_build_wonder_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_help_build_wonder_100, cmp_packet_unit_help_build_wonder_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->unit_id = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_help_build_wonder_100(struct connection *pc, const struct packet_unit_help_build_wonder *packet)
{
  const struct packet_unit_help_build_wonder *real_packet = packet;
  packet_unit_help_build_wonder_100_fields fields;
  struct packet_unit_help_build_wonder *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_HELP_BUILD_WONDER;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_HELP_BUILD_WONDER);

  log_packet_detailed("packet_unit_help_build_wonder_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_help_build_wonder_100, cmp_packet_unit_help_build_wonder_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_unit_help_build_wonder(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_HELP_BUILD_WONDER] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_HELP_BUILD_WONDER variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_HELP_BUILD_WONDER] = variant;
}

struct packet_unit_help_build_wonder *receive_packet_unit_help_build_wonder(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_unit_help_build_wonder at the client.");
  }
  ensure_valid_variant_packet_unit_help_build_wonder(pc);

  switch(pc->phs.variant[PACKET_UNIT_HELP_BUILD_WONDER]) {
  case 100:
    return receive_packet_unit_help_build_wonder_100(pc, type);
  default:
    log_debug("Unknown PACKET_UNIT_HELP_BUILD_WONDER variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_help_build_wonder(struct connection *pc, const struct packet_unit_help_build_wonder *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_help_build_wonder from the server.");
  }
  ensure_valid_variant_packet_unit_help_build_wonder(pc);

  switch(pc->phs.variant[PACKET_UNIT_HELP_BUILD_WONDER]) {

  case 100:
    return send_packet_unit_help_build_wonder_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_HELP_BUILD_WONDER variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_help_build_wonder(struct connection *pc, int unit_id)
{
  struct packet_unit_help_build_wonder packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  
  return send_packet_unit_help_build_wonder(pc, real_packet);
}

#define hash_packet_unit_orders_100 hash_const

#define cmp_packet_unit_orders_100 cmp_const

BV_DEFINE(packet_unit_orders_100_fields, 10);

static struct packet_unit_orders *receive_packet_unit_orders_100(struct connection *pc, enum packet_type type)
{
  packet_unit_orders_100_fields fields;
  struct packet_unit_orders *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_unit_orders, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_orders_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_orders_100, cmp_packet_unit_orders_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->unit_id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'src_tile'");
    {
      int readin;
    
      dio_get_sint32(&din, &readin);
      real_packet->src_tile = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'length'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->length = readin;
    }
  }
  real_packet->repeat = BV_ISSET(fields, 3);
  real_packet->vigilant = BV_ISSET(fields, 4);
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'orders'");
    
    {
      int i;
    
      if(real_packet->length > MAX_LEN_ROUTE) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->length = MAX_LEN_ROUTE;
      }
      for (i = 0; i < real_packet->length; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->orders[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'dir'");
    
    {
      int i;
    
      if(real_packet->length > MAX_LEN_ROUTE) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->length = MAX_LEN_ROUTE;
      }
      for (i = 0; i < real_packet->length; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->dir[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'activity'");
    
    {
      int i;
    
      if(real_packet->length > MAX_LEN_ROUTE) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->length = MAX_LEN_ROUTE;
      }
      for (i = 0; i < real_packet->length; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->activity[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'base'");
    
    {
      int i;
    
      if(real_packet->length > MAX_LEN_ROUTE) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->length = MAX_LEN_ROUTE;
      }
      for (i = 0; i < real_packet->length; i++) {
        {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->base[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'dest_tile'");
    {
      int readin;
    
      dio_get_sint32(&din, &readin);
      real_packet->dest_tile = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_orders_100(struct connection *pc, const struct packet_unit_orders *packet)
{
  const struct packet_unit_orders *real_packet = packet;
  packet_unit_orders_100_fields fields;
  struct packet_unit_orders *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_ORDERS;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_ORDERS);

  log_packet_detailed("packet_unit_orders_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_orders_100, cmp_packet_unit_orders_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->src_tile != real_packet->src_tile);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->length != real_packet->length);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->repeat != real_packet->repeat);
  if(differ) {
    different++;
  }
  if (packet->repeat) {
    BV_SET(fields, 3);
  }

  differ = (old->vigilant != real_packet->vigilant);
  if(differ) {
    different++;
  }
  if (packet->vigilant) {
    BV_SET(fields, 4);
  }


    {
      differ = (old->length != real_packet->length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->length; i++) {
          if (old->orders[i] != real_packet->orders[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


    {
      differ = (old->length != real_packet->length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->length; i++) {
          if (old->dir[i] != real_packet->dir[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }


    {
      differ = (old->length != real_packet->length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->length; i++) {
          if (old->activity[i] != real_packet->activity[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }


    {
      differ = (old->length != real_packet->length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->length; i++) {
          if (old->base[i] != real_packet->base[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->dest_tile != real_packet->dest_tile);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'src_tile' has changed");
    dio_put_sint32(&dout, real_packet->src_tile);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'length' has changed");
    dio_put_uint16(&dout, real_packet->length);
  }
  /* field 3 is folded into the header */
  /* field 4 is folded into the header */
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'orders' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->length; i++) {
        dio_put_uint8(&dout, real_packet->orders[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'dir' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->length; i++) {
        dio_put_uint8(&dout, real_packet->dir[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'activity' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->length; i++) {
        dio_put_uint8(&dout, real_packet->activity[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'base' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->length; i++) {
        dio_put_sint8(&dout, real_packet->base[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'dest_tile' has changed");
    dio_put_sint32(&dout, real_packet->dest_tile);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_unit_orders(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_ORDERS] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_ORDERS variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_ORDERS] = variant;
}

struct packet_unit_orders *receive_packet_unit_orders(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_unit_orders at the client.");
  }
  ensure_valid_variant_packet_unit_orders(pc);

  switch(pc->phs.variant[PACKET_UNIT_ORDERS]) {
  case 100:
    return receive_packet_unit_orders_100(pc, type);
  default:
    log_debug("Unknown PACKET_UNIT_ORDERS variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_orders(struct connection *pc, const struct packet_unit_orders *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_orders from the server.");
  }
  ensure_valid_variant_packet_unit_orders(pc);

  switch(pc->phs.variant[PACKET_UNIT_ORDERS]) {

  case 100:
    return send_packet_unit_orders_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_ORDERS variant for connection %s", conn_description(pc));
    return -1;
  }
}
#define hash_packet_unit_autosettlers_100 hash_const

#define cmp_packet_unit_autosettlers_100 cmp_const

BV_DEFINE(packet_unit_autosettlers_100_fields, 1);

static struct packet_unit_autosettlers *receive_packet_unit_autosettlers_100(struct connection *pc, enum packet_type type)
{
  packet_unit_autosettlers_100_fields fields;
  struct packet_unit_autosettlers *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_unit_autosettlers, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_autosettlers_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_autosettlers_100, cmp_packet_unit_autosettlers_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->unit_id = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_autosettlers_100(struct connection *pc, const struct packet_unit_autosettlers *packet)
{
  const struct packet_unit_autosettlers *real_packet = packet;
  packet_unit_autosettlers_100_fields fields;
  struct packet_unit_autosettlers *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_AUTOSETTLERS;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_AUTOSETTLERS);

  log_packet_detailed("packet_unit_autosettlers_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_autosettlers_100, cmp_packet_unit_autosettlers_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_unit_autosettlers(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_AUTOSETTLERS] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_AUTOSETTLERS variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_AUTOSETTLERS] = variant;
}

struct packet_unit_autosettlers *receive_packet_unit_autosettlers(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_unit_autosettlers at the client.");
  }
  ensure_valid_variant_packet_unit_autosettlers(pc);

  switch(pc->phs.variant[PACKET_UNIT_AUTOSETTLERS]) {
  case 100:
    return receive_packet_unit_autosettlers_100(pc, type);
  default:
    log_debug("Unknown PACKET_UNIT_AUTOSETTLERS variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_autosettlers(struct connection *pc, const struct packet_unit_autosettlers *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_autosettlers from the server.");
  }
  ensure_valid_variant_packet_unit_autosettlers(pc);

  switch(pc->phs.variant[PACKET_UNIT_AUTOSETTLERS]) {

  case 100:
    return send_packet_unit_autosettlers_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_AUTOSETTLERS variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_autosettlers(struct connection *pc, int unit_id)
{
  struct packet_unit_autosettlers packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  
  return send_packet_unit_autosettlers(pc, real_packet);
}

#define hash_packet_unit_load_100 hash_const

#define cmp_packet_unit_load_100 cmp_const

BV_DEFINE(packet_unit_load_100_fields, 2);

static struct packet_unit_load *receive_packet_unit_load_100(struct connection *pc, enum packet_type type)
{
  packet_unit_load_100_fields fields;
  struct packet_unit_load *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_unit_load, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_load_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_load_100, cmp_packet_unit_load_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'cargo_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->cargo_id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'transporter_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->transporter_id = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_load_100(struct connection *pc, const struct packet_unit_load *packet)
{
  const struct packet_unit_load *real_packet = packet;
  packet_unit_load_100_fields fields;
  struct packet_unit_load *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_LOAD;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_LOAD);

  log_packet_detailed("packet_unit_load_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_load_100, cmp_packet_unit_load_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->cargo_id != real_packet->cargo_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->transporter_id != real_packet->transporter_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'cargo_id' has changed");
    dio_put_uint16(&dout, real_packet->cargo_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'transporter_id' has changed");
    dio_put_uint16(&dout, real_packet->transporter_id);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_unit_load(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_LOAD] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_LOAD variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_LOAD] = variant;
}

struct packet_unit_load *receive_packet_unit_load(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_unit_load at the client.");
  }
  ensure_valid_variant_packet_unit_load(pc);

  switch(pc->phs.variant[PACKET_UNIT_LOAD]) {
  case 100:
    return receive_packet_unit_load_100(pc, type);
  default:
    log_debug("Unknown PACKET_UNIT_LOAD variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_load(struct connection *pc, const struct packet_unit_load *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_load from the server.");
  }
  ensure_valid_variant_packet_unit_load(pc);

  switch(pc->phs.variant[PACKET_UNIT_LOAD]) {

  case 100:
    return send_packet_unit_load_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_LOAD variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_load(struct connection *pc, int cargo_id, int transporter_id)
{
  struct packet_unit_load packet, *real_packet = &packet;

  real_packet->cargo_id = cargo_id;
  real_packet->transporter_id = transporter_id;
  
  return send_packet_unit_load(pc, real_packet);
}

#define hash_packet_unit_unload_100 hash_const

#define cmp_packet_unit_unload_100 cmp_const

BV_DEFINE(packet_unit_unload_100_fields, 2);

static struct packet_unit_unload *receive_packet_unit_unload_100(struct connection *pc, enum packet_type type)
{
  packet_unit_unload_100_fields fields;
  struct packet_unit_unload *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_unit_unload, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_unload_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_unload_100, cmp_packet_unit_unload_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'cargo_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->cargo_id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'transporter_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->transporter_id = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_unload_100(struct connection *pc, const struct packet_unit_unload *packet)
{
  const struct packet_unit_unload *real_packet = packet;
  packet_unit_unload_100_fields fields;
  struct packet_unit_unload *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_UNLOAD;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_UNLOAD);

  log_packet_detailed("packet_unit_unload_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_unload_100, cmp_packet_unit_unload_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->cargo_id != real_packet->cargo_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->transporter_id != real_packet->transporter_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'cargo_id' has changed");
    dio_put_uint16(&dout, real_packet->cargo_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'transporter_id' has changed");
    dio_put_uint16(&dout, real_packet->transporter_id);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_unit_unload(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_UNLOAD] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_UNLOAD variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_UNLOAD] = variant;
}

struct packet_unit_unload *receive_packet_unit_unload(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_unit_unload at the client.");
  }
  ensure_valid_variant_packet_unit_unload(pc);

  switch(pc->phs.variant[PACKET_UNIT_UNLOAD]) {
  case 100:
    return receive_packet_unit_unload_100(pc, type);
  default:
    log_debug("Unknown PACKET_UNIT_UNLOAD variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_unload(struct connection *pc, const struct packet_unit_unload *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_unload from the server.");
  }
  ensure_valid_variant_packet_unit_unload(pc);

  switch(pc->phs.variant[PACKET_UNIT_UNLOAD]) {

  case 100:
    return send_packet_unit_unload_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_UNLOAD variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_unload(struct connection *pc, int cargo_id, int transporter_id)
{
  struct packet_unit_unload packet, *real_packet = &packet;

  real_packet->cargo_id = cargo_id;
  real_packet->transporter_id = transporter_id;
  
  return send_packet_unit_unload(pc, real_packet);
}

#define hash_packet_unit_upgrade_100 hash_const

#define cmp_packet_unit_upgrade_100 cmp_const

BV_DEFINE(packet_unit_upgrade_100_fields, 1);

static struct packet_unit_upgrade *receive_packet_unit_upgrade_100(struct connection *pc, enum packet_type type)
{
  packet_unit_upgrade_100_fields fields;
  struct packet_unit_upgrade *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_unit_upgrade, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_upgrade_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_upgrade_100, cmp_packet_unit_upgrade_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->unit_id = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_upgrade_100(struct connection *pc, const struct packet_unit_upgrade *packet)
{
  const struct packet_unit_upgrade *real_packet = packet;
  packet_unit_upgrade_100_fields fields;
  struct packet_unit_upgrade *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_UPGRADE;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_UPGRADE);

  log_packet_detailed("packet_unit_upgrade_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_upgrade_100, cmp_packet_unit_upgrade_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_unit_upgrade(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_UPGRADE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_UPGRADE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_UPGRADE] = variant;
}

struct packet_unit_upgrade *receive_packet_unit_upgrade(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_unit_upgrade at the client.");
  }
  ensure_valid_variant_packet_unit_upgrade(pc);

  switch(pc->phs.variant[PACKET_UNIT_UPGRADE]) {
  case 100:
    return receive_packet_unit_upgrade_100(pc, type);
  default:
    log_debug("Unknown PACKET_UNIT_UPGRADE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_upgrade(struct connection *pc, const struct packet_unit_upgrade *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_upgrade from the server.");
  }
  ensure_valid_variant_packet_unit_upgrade(pc);

  switch(pc->phs.variant[PACKET_UNIT_UPGRADE]) {

  case 100:
    return send_packet_unit_upgrade_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_UPGRADE variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_upgrade(struct connection *pc, int unit_id)
{
  struct packet_unit_upgrade packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  
  return send_packet_unit_upgrade(pc, real_packet);
}

#define hash_packet_unit_convert_100 hash_const

#define cmp_packet_unit_convert_100 cmp_const

BV_DEFINE(packet_unit_convert_100_fields, 1);

static struct packet_unit_convert *receive_packet_unit_convert_100(struct connection *pc, enum packet_type type)
{
  packet_unit_convert_100_fields fields;
  struct packet_unit_convert *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_unit_convert, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_convert_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_convert_100, cmp_packet_unit_convert_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->unit_id = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_convert_100(struct connection *pc, const struct packet_unit_convert *packet)
{
  const struct packet_unit_convert *real_packet = packet;
  packet_unit_convert_100_fields fields;
  struct packet_unit_convert *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_CONVERT;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_CONVERT);

  log_packet_detailed("packet_unit_convert_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_convert_100, cmp_packet_unit_convert_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_unit_convert(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_CONVERT] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_CONVERT variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_CONVERT] = variant;
}

struct packet_unit_convert *receive_packet_unit_convert(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_unit_convert at the client.");
  }
  ensure_valid_variant_packet_unit_convert(pc);

  switch(pc->phs.variant[PACKET_UNIT_CONVERT]) {
  case 100:
    return receive_packet_unit_convert_100(pc, type);
  default:
    log_debug("Unknown PACKET_UNIT_CONVERT variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_convert(struct connection *pc, const struct packet_unit_convert *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_convert from the server.");
  }
  ensure_valid_variant_packet_unit_convert(pc);

  switch(pc->phs.variant[PACKET_UNIT_CONVERT]) {

  case 100:
    return send_packet_unit_convert_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_CONVERT variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_convert(struct connection *pc, int unit_id)
{
  struct packet_unit_convert packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  
  return send_packet_unit_convert(pc, real_packet);
}

#define hash_packet_unit_nuke_100 hash_const

#define cmp_packet_unit_nuke_100 cmp_const

BV_DEFINE(packet_unit_nuke_100_fields, 1);

static struct packet_unit_nuke *receive_packet_unit_nuke_100(struct connection *pc, enum packet_type type)
{
  packet_unit_nuke_100_fields fields;
  struct packet_unit_nuke *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_unit_nuke, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_nuke_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_nuke_100, cmp_packet_unit_nuke_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->unit_id = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_nuke_100(struct connection *pc, const struct packet_unit_nuke *packet)
{
  const struct packet_unit_nuke *real_packet = packet;
  packet_unit_nuke_100_fields fields;
  struct packet_unit_nuke *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_NUKE;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_NUKE);

  log_packet_detailed("packet_unit_nuke_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_nuke_100, cmp_packet_unit_nuke_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_unit_nuke(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_NUKE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_NUKE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_NUKE] = variant;
}

struct packet_unit_nuke *receive_packet_unit_nuke(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_unit_nuke at the client.");
  }
  ensure_valid_variant_packet_unit_nuke(pc);

  switch(pc->phs.variant[PACKET_UNIT_NUKE]) {
  case 100:
    return receive_packet_unit_nuke_100(pc, type);
  default:
    log_debug("Unknown PACKET_UNIT_NUKE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_nuke(struct connection *pc, const struct packet_unit_nuke *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_nuke from the server.");
  }
  ensure_valid_variant_packet_unit_nuke(pc);

  switch(pc->phs.variant[PACKET_UNIT_NUKE]) {

  case 100:
    return send_packet_unit_nuke_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_NUKE variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_nuke(struct connection *pc, int unit_id)
{
  struct packet_unit_nuke packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  
  return send_packet_unit_nuke(pc, real_packet);
}

#define hash_packet_unit_paradrop_to_100 hash_const

#define cmp_packet_unit_paradrop_to_100 cmp_const

BV_DEFINE(packet_unit_paradrop_to_100_fields, 2);

static struct packet_unit_paradrop_to *receive_packet_unit_paradrop_to_100(struct connection *pc, enum packet_type type)
{
  packet_unit_paradrop_to_100_fields fields;
  struct packet_unit_paradrop_to *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_unit_paradrop_to, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_paradrop_to_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_paradrop_to_100, cmp_packet_unit_paradrop_to_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->unit_id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'tile'");
    {
      int readin;
    
      dio_get_sint32(&din, &readin);
      real_packet->tile = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_paradrop_to_100(struct connection *pc, const struct packet_unit_paradrop_to *packet)
{
  const struct packet_unit_paradrop_to *real_packet = packet;
  packet_unit_paradrop_to_100_fields fields;
  struct packet_unit_paradrop_to *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_PARADROP_TO;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_PARADROP_TO);

  log_packet_detailed("packet_unit_paradrop_to_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_paradrop_to_100, cmp_packet_unit_paradrop_to_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'tile' has changed");
    dio_put_sint32(&dout, real_packet->tile);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_unit_paradrop_to(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_PARADROP_TO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_PARADROP_TO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_PARADROP_TO] = variant;
}

struct packet_unit_paradrop_to *receive_packet_unit_paradrop_to(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_unit_paradrop_to at the client.");
  }
  ensure_valid_variant_packet_unit_paradrop_to(pc);

  switch(pc->phs.variant[PACKET_UNIT_PARADROP_TO]) {
  case 100:
    return receive_packet_unit_paradrop_to_100(pc, type);
  default:
    log_debug("Unknown PACKET_UNIT_PARADROP_TO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_paradrop_to(struct connection *pc, const struct packet_unit_paradrop_to *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_paradrop_to from the server.");
  }
  ensure_valid_variant_packet_unit_paradrop_to(pc);

  switch(pc->phs.variant[PACKET_UNIT_PARADROP_TO]) {

  case 100:
    return send_packet_unit_paradrop_to_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_PARADROP_TO variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_paradrop_to(struct connection *pc, int unit_id, int tile)
{
  struct packet_unit_paradrop_to packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  real_packet->tile = tile;
  
  return send_packet_unit_paradrop_to(pc, real_packet);
}

#define hash_packet_unit_airlift_100 hash_const

#define cmp_packet_unit_airlift_100 cmp_const

BV_DEFINE(packet_unit_airlift_100_fields, 2);

static struct packet_unit_airlift *receive_packet_unit_airlift_100(struct connection *pc, enum packet_type type)
{
  packet_unit_airlift_100_fields fields;
  struct packet_unit_airlift *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_unit_airlift, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_airlift_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_airlift_100, cmp_packet_unit_airlift_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->unit_id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'city_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->city_id = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_airlift_100(struct connection *pc, const struct packet_unit_airlift *packet)
{
  const struct packet_unit_airlift *real_packet = packet;
  packet_unit_airlift_100_fields fields;
  struct packet_unit_airlift *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_AIRLIFT;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_AIRLIFT);

  log_packet_detailed("packet_unit_airlift_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_airlift_100, cmp_packet_unit_airlift_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'city_id' has changed");
    dio_put_uint16(&dout, real_packet->city_id);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_unit_airlift(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_AIRLIFT] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_AIRLIFT variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_AIRLIFT] = variant;
}

struct packet_unit_airlift *receive_packet_unit_airlift(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_unit_airlift at the client.");
  }
  ensure_valid_variant_packet_unit_airlift(pc);

  switch(pc->phs.variant[PACKET_UNIT_AIRLIFT]) {
  case 100:
    return receive_packet_unit_airlift_100(pc, type);
  default:
    log_debug("Unknown PACKET_UNIT_AIRLIFT variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_airlift(struct connection *pc, const struct packet_unit_airlift *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_airlift from the server.");
  }
  ensure_valid_variant_packet_unit_airlift(pc);

  switch(pc->phs.variant[PACKET_UNIT_AIRLIFT]) {

  case 100:
    return send_packet_unit_airlift_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_AIRLIFT variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_airlift(struct connection *pc, int unit_id, int city_id)
{
  struct packet_unit_airlift packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  real_packet->city_id = city_id;
  
  return send_packet_unit_airlift(pc, real_packet);
}

#define hash_packet_unit_diplomat_query_100 hash_const

#define cmp_packet_unit_diplomat_query_100 cmp_const

BV_DEFINE(packet_unit_diplomat_query_100_fields, 4);

static struct packet_unit_diplomat_query *receive_packet_unit_diplomat_query_100(struct connection *pc, enum packet_type type)
{
  packet_unit_diplomat_query_100_fields fields;
  struct packet_unit_diplomat_query *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_unit_diplomat_query, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_diplomat_query_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_diplomat_query_100, cmp_packet_unit_diplomat_query_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'diplomat_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->diplomat_id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'target_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->target_id = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'value'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->value = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'action_type'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->action_type = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_diplomat_query_100(struct connection *pc, const struct packet_unit_diplomat_query *packet)
{
  const struct packet_unit_diplomat_query *real_packet = packet;
  packet_unit_diplomat_query_100_fields fields;
  struct packet_unit_diplomat_query *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_DIPLOMAT_QUERY;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_DIPLOMAT_QUERY);

  log_packet_detailed("packet_unit_diplomat_query_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_diplomat_query_100, cmp_packet_unit_diplomat_query_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->diplomat_id != real_packet->diplomat_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->target_id != real_packet->target_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->value != real_packet->value);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->action_type != real_packet->action_type);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'diplomat_id' has changed");
    dio_put_uint16(&dout, real_packet->diplomat_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'target_id' has changed");
    dio_put_uint16(&dout, real_packet->target_id);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'value' has changed");
    dio_put_sint16(&dout, real_packet->value);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'action_type' has changed");
    dio_put_uint8(&dout, real_packet->action_type);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_unit_diplomat_query(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_DIPLOMAT_QUERY] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_DIPLOMAT_QUERY variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_DIPLOMAT_QUERY] = variant;
}

struct packet_unit_diplomat_query *receive_packet_unit_diplomat_query(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_unit_diplomat_query at the client.");
  }
  ensure_valid_variant_packet_unit_diplomat_query(pc);

  switch(pc->phs.variant[PACKET_UNIT_DIPLOMAT_QUERY]) {
  case 100:
    return receive_packet_unit_diplomat_query_100(pc, type);
  default:
    log_debug("Unknown PACKET_UNIT_DIPLOMAT_QUERY variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_diplomat_query(struct connection *pc, const struct packet_unit_diplomat_query *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_diplomat_query from the server.");
  }
  ensure_valid_variant_packet_unit_diplomat_query(pc);

  switch(pc->phs.variant[PACKET_UNIT_DIPLOMAT_QUERY]) {

  case 100:
    return send_packet_unit_diplomat_query_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_DIPLOMAT_QUERY variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_diplomat_query(struct connection *pc, int diplomat_id, int target_id, int value, enum diplomat_actions action_type)
{
  struct packet_unit_diplomat_query packet, *real_packet = &packet;

  real_packet->diplomat_id = diplomat_id;
  real_packet->target_id = target_id;
  real_packet->value = value;
  real_packet->action_type = action_type;
  
  return send_packet_unit_diplomat_query(pc, real_packet);
}

#define hash_packet_unit_type_upgrade_100 hash_const

#define cmp_packet_unit_type_upgrade_100 cmp_const

BV_DEFINE(packet_unit_type_upgrade_100_fields, 1);

static struct packet_unit_type_upgrade *receive_packet_unit_type_upgrade_100(struct connection *pc, enum packet_type type)
{
  packet_unit_type_upgrade_100_fields fields;
  struct packet_unit_type_upgrade *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_unit_type_upgrade, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_type_upgrade_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_type_upgrade_100, cmp_packet_unit_type_upgrade_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->type = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_type_upgrade_100(struct connection *pc, const struct packet_unit_type_upgrade *packet)
{
  const struct packet_unit_type_upgrade *real_packet = packet;
  packet_unit_type_upgrade_100_fields fields;
  struct packet_unit_type_upgrade *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_TYPE_UPGRADE;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_TYPE_UPGRADE);

  log_packet_detailed("packet_unit_type_upgrade_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_type_upgrade_100, cmp_packet_unit_type_upgrade_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'type' has changed");
    dio_put_uint8(&dout, real_packet->type);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_unit_type_upgrade(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_TYPE_UPGRADE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_TYPE_UPGRADE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_TYPE_UPGRADE] = variant;
}

struct packet_unit_type_upgrade *receive_packet_unit_type_upgrade(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_unit_type_upgrade at the client.");
  }
  ensure_valid_variant_packet_unit_type_upgrade(pc);

  switch(pc->phs.variant[PACKET_UNIT_TYPE_UPGRADE]) {
  case 100:
    return receive_packet_unit_type_upgrade_100(pc, type);
  default:
    log_debug("Unknown PACKET_UNIT_TYPE_UPGRADE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_type_upgrade(struct connection *pc, const struct packet_unit_type_upgrade *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_type_upgrade from the server.");
  }
  ensure_valid_variant_packet_unit_type_upgrade(pc);

  switch(pc->phs.variant[PACKET_UNIT_TYPE_UPGRADE]) {

  case 100:
    return send_packet_unit_type_upgrade_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_TYPE_UPGRADE variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_type_upgrade(struct connection *pc, Unit_type_id type)
{
  struct packet_unit_type_upgrade packet, *real_packet = &packet;

  real_packet->type = type;
  
  return send_packet_unit_type_upgrade(pc, real_packet);
}

#define hash_packet_unit_diplomat_action_100 hash_const

#define cmp_packet_unit_diplomat_action_100 cmp_const

BV_DEFINE(packet_unit_diplomat_action_100_fields, 4);

static struct packet_unit_diplomat_action *receive_packet_unit_diplomat_action_100(struct connection *pc, enum packet_type type)
{
  packet_unit_diplomat_action_100_fields fields;
  struct packet_unit_diplomat_action *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_unit_diplomat_action, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_diplomat_action_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_diplomat_action_100, cmp_packet_unit_diplomat_action_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'diplomat_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->diplomat_id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'target_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->target_id = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'value'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->value = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'action_type'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->action_type = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_diplomat_action_100(struct connection *pc, const struct packet_unit_diplomat_action *packet)
{
  const struct packet_unit_diplomat_action *real_packet = packet;
  packet_unit_diplomat_action_100_fields fields;
  struct packet_unit_diplomat_action *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_DIPLOMAT_ACTION;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_DIPLOMAT_ACTION);

  log_packet_detailed("packet_unit_diplomat_action_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_diplomat_action_100, cmp_packet_unit_diplomat_action_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->diplomat_id != real_packet->diplomat_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->target_id != real_packet->target_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->value != real_packet->value);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->action_type != real_packet->action_type);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'diplomat_id' has changed");
    dio_put_uint16(&dout, real_packet->diplomat_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'target_id' has changed");
    dio_put_uint16(&dout, real_packet->target_id);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'value' has changed");
    dio_put_sint16(&dout, real_packet->value);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'action_type' has changed");
    dio_put_uint8(&dout, real_packet->action_type);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_unit_diplomat_action(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_DIPLOMAT_ACTION] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_DIPLOMAT_ACTION variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_DIPLOMAT_ACTION] = variant;
}

struct packet_unit_diplomat_action *receive_packet_unit_diplomat_action(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_unit_diplomat_action at the client.");
  }
  ensure_valid_variant_packet_unit_diplomat_action(pc);

  switch(pc->phs.variant[PACKET_UNIT_DIPLOMAT_ACTION]) {
  case 100:
    return receive_packet_unit_diplomat_action_100(pc, type);
  default:
    log_debug("Unknown PACKET_UNIT_DIPLOMAT_ACTION variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_diplomat_action(struct connection *pc, const struct packet_unit_diplomat_action *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_diplomat_action from the server.");
  }
  ensure_valid_variant_packet_unit_diplomat_action(pc);

  switch(pc->phs.variant[PACKET_UNIT_DIPLOMAT_ACTION]) {

  case 100:
    return send_packet_unit_diplomat_action_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_DIPLOMAT_ACTION variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_diplomat_action(struct connection *pc, int diplomat_id, int target_id, int value, enum diplomat_actions action_type)
{
  struct packet_unit_diplomat_action packet, *real_packet = &packet;

  real_packet->diplomat_id = diplomat_id;
  real_packet->target_id = target_id;
  real_packet->value = value;
  real_packet->action_type = action_type;
  
  return send_packet_unit_diplomat_action(pc, real_packet);
}

#define hash_packet_unit_diplomat_answer_100 hash_const

#define cmp_packet_unit_diplomat_answer_100 cmp_const

BV_DEFINE(packet_unit_diplomat_answer_100_fields, 4);

static struct packet_unit_diplomat_answer *receive_packet_unit_diplomat_answer_100(struct connection *pc, enum packet_type type)
{
  packet_unit_diplomat_answer_100_fields fields;
  struct packet_unit_diplomat_answer *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_unit_diplomat_answer, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_diplomat_answer_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_diplomat_answer_100, cmp_packet_unit_diplomat_answer_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'diplomat_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->diplomat_id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'target_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->target_id = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'cost'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->cost = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'action_type'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->action_type = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_diplomat_answer_100(struct connection *pc, const struct packet_unit_diplomat_answer *packet)
{
  const struct packet_unit_diplomat_answer *real_packet = packet;
  packet_unit_diplomat_answer_100_fields fields;
  struct packet_unit_diplomat_answer *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_DIPLOMAT_ANSWER;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_DIPLOMAT_ANSWER);

  log_packet_detailed("packet_unit_diplomat_answer_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_diplomat_answer_100, cmp_packet_unit_diplomat_answer_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->diplomat_id != real_packet->diplomat_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->target_id != real_packet->target_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->cost != real_packet->cost);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->action_type != real_packet->action_type);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'diplomat_id' has changed");
    dio_put_uint16(&dout, real_packet->diplomat_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'target_id' has changed");
    dio_put_uint16(&dout, real_packet->target_id);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'cost' has changed");
    dio_put_uint32(&dout, real_packet->cost);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'action_type' has changed");
    dio_put_uint8(&dout, real_packet->action_type);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_unit_diplomat_answer(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_DIPLOMAT_ANSWER] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_DIPLOMAT_ANSWER variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_DIPLOMAT_ANSWER] = variant;
}

struct packet_unit_diplomat_answer *receive_packet_unit_diplomat_answer(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_unit_diplomat_answer at the server.");
  }
  ensure_valid_variant_packet_unit_diplomat_answer(pc);

  switch(pc->phs.variant[PACKET_UNIT_DIPLOMAT_ANSWER]) {
  case 100:
    return receive_packet_unit_diplomat_answer_100(pc, type);
  default:
    log_debug("Unknown PACKET_UNIT_DIPLOMAT_ANSWER variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_diplomat_answer(struct connection *pc, const struct packet_unit_diplomat_answer *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_unit_diplomat_answer from the client.");
  }
  ensure_valid_variant_packet_unit_diplomat_answer(pc);

  switch(pc->phs.variant[PACKET_UNIT_DIPLOMAT_ANSWER]) {

  case 100:
    return send_packet_unit_diplomat_answer_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_DIPLOMAT_ANSWER variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_unit_diplomat_answer(struct conn_list *dest, const struct packet_unit_diplomat_answer *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_unit_diplomat_answer(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_unit_diplomat_answer(struct connection *pc, int diplomat_id, int target_id, int cost, enum diplomat_actions action_type)
{
  struct packet_unit_diplomat_answer packet, *real_packet = &packet;

  real_packet->diplomat_id = diplomat_id;
  real_packet->target_id = target_id;
  real_packet->cost = cost;
  real_packet->action_type = action_type;
  
  return send_packet_unit_diplomat_answer(pc, real_packet);
}

void dlsend_packet_unit_diplomat_answer(struct conn_list *dest, int diplomat_id, int target_id, int cost, enum diplomat_actions action_type)
{
  struct packet_unit_diplomat_answer packet, *real_packet = &packet;

  real_packet->diplomat_id = diplomat_id;
  real_packet->target_id = target_id;
  real_packet->cost = cost;
  real_packet->action_type = action_type;
  
  lsend_packet_unit_diplomat_answer(dest, real_packet);
}

#define hash_packet_unit_change_activity_100 hash_const

#define cmp_packet_unit_change_activity_100 cmp_const

BV_DEFINE(packet_unit_change_activity_100_fields, 4);

static struct packet_unit_change_activity *receive_packet_unit_change_activity_100(struct connection *pc, enum packet_type type)
{
  packet_unit_change_activity_100_fields fields;
  struct packet_unit_change_activity *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_unit_change_activity, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_change_activity_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_change_activity_100, cmp_packet_unit_change_activity_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->unit_id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'activity'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->activity = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'activity_target'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->activity_target = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'activity_base'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->activity_base = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_change_activity_100(struct connection *pc, const struct packet_unit_change_activity *packet)
{
  const struct packet_unit_change_activity *real_packet = packet;
  packet_unit_change_activity_100_fields fields;
  struct packet_unit_change_activity *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_CHANGE_ACTIVITY;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_CHANGE_ACTIVITY);

  log_packet_detailed("packet_unit_change_activity_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_change_activity_100, cmp_packet_unit_change_activity_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->activity != real_packet->activity);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->activity_target != real_packet->activity_target);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->activity_base != real_packet->activity_base);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'activity' has changed");
    dio_put_uint8(&dout, real_packet->activity);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'activity_target' has changed");
    dio_put_uint16(&dout, real_packet->activity_target);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'activity_base' has changed");
    dio_put_sint8(&dout, real_packet->activity_base);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_unit_change_activity(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_CHANGE_ACTIVITY] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_CHANGE_ACTIVITY variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_CHANGE_ACTIVITY] = variant;
}

struct packet_unit_change_activity *receive_packet_unit_change_activity(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_unit_change_activity at the client.");
  }
  ensure_valid_variant_packet_unit_change_activity(pc);

  switch(pc->phs.variant[PACKET_UNIT_CHANGE_ACTIVITY]) {
  case 100:
    return receive_packet_unit_change_activity_100(pc, type);
  default:
    log_debug("Unknown PACKET_UNIT_CHANGE_ACTIVITY variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_change_activity(struct connection *pc, const struct packet_unit_change_activity *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_change_activity from the server.");
  }
  ensure_valid_variant_packet_unit_change_activity(pc);

  switch(pc->phs.variant[PACKET_UNIT_CHANGE_ACTIVITY]) {

  case 100:
    return send_packet_unit_change_activity_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_CHANGE_ACTIVITY variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_change_activity(struct connection *pc, int unit_id, enum unit_activity activity, enum tile_special_type activity_target, Base_type_id activity_base)
{
  struct packet_unit_change_activity packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  real_packet->activity = activity;
  real_packet->activity_target = activity_target;
  real_packet->activity_base = activity_base;
  
  return send_packet_unit_change_activity(pc, real_packet);
}

#define hash_packet_diplomacy_init_meeting_req_100 hash_const

#define cmp_packet_diplomacy_init_meeting_req_100 cmp_const

BV_DEFINE(packet_diplomacy_init_meeting_req_100_fields, 1);

static struct packet_diplomacy_init_meeting_req *receive_packet_diplomacy_init_meeting_req_100(struct connection *pc, enum packet_type type)
{
  packet_diplomacy_init_meeting_req_100_fields fields;
  struct packet_diplomacy_init_meeting_req *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_diplomacy_init_meeting_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_init_meeting_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_init_meeting_req_100, cmp_packet_diplomacy_init_meeting_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'counterpart'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->counterpart = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_init_meeting_req_100(struct connection *pc, const struct packet_diplomacy_init_meeting_req *packet)
{
  const struct packet_diplomacy_init_meeting_req *real_packet = packet;
  packet_diplomacy_init_meeting_req_100_fields fields;
  struct packet_diplomacy_init_meeting_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_INIT_MEETING_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_INIT_MEETING_REQ);

  log_packet_detailed("packet_diplomacy_init_meeting_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_init_meeting_req_100, cmp_packet_diplomacy_init_meeting_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->counterpart != real_packet->counterpart);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'counterpart' has changed");
    dio_put_sint8(&dout, real_packet->counterpart);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_diplomacy_init_meeting_req(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_DIPLOMACY_INIT_MEETING_REQ] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_DIPLOMACY_INIT_MEETING_REQ variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_DIPLOMACY_INIT_MEETING_REQ] = variant;
}

struct packet_diplomacy_init_meeting_req *receive_packet_diplomacy_init_meeting_req(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_diplomacy_init_meeting_req at the client.");
  }
  ensure_valid_variant_packet_diplomacy_init_meeting_req(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_INIT_MEETING_REQ]) {
  case 100:
    return receive_packet_diplomacy_init_meeting_req_100(pc, type);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_INIT_MEETING_REQ variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_diplomacy_init_meeting_req(struct connection *pc, const struct packet_diplomacy_init_meeting_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_diplomacy_init_meeting_req from the server.");
  }
  ensure_valid_variant_packet_diplomacy_init_meeting_req(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_INIT_MEETING_REQ]) {

  case 100:
    return send_packet_diplomacy_init_meeting_req_100(pc, packet);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_INIT_MEETING_REQ variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_diplomacy_init_meeting_req(struct connection *pc, int counterpart)
{
  struct packet_diplomacy_init_meeting_req packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  
  return send_packet_diplomacy_init_meeting_req(pc, real_packet);
}

#define hash_packet_diplomacy_init_meeting_100 hash_const

#define cmp_packet_diplomacy_init_meeting_100 cmp_const

BV_DEFINE(packet_diplomacy_init_meeting_100_fields, 2);

static struct packet_diplomacy_init_meeting *receive_packet_diplomacy_init_meeting_100(struct connection *pc, enum packet_type type)
{
  packet_diplomacy_init_meeting_100_fields fields;
  struct packet_diplomacy_init_meeting *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_diplomacy_init_meeting, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_init_meeting_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_init_meeting_100, cmp_packet_diplomacy_init_meeting_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'counterpart'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->counterpart = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'initiated_from'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->initiated_from = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_init_meeting_100(struct connection *pc, const struct packet_diplomacy_init_meeting *packet)
{
  const struct packet_diplomacy_init_meeting *real_packet = packet;
  packet_diplomacy_init_meeting_100_fields fields;
  struct packet_diplomacy_init_meeting *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_INIT_MEETING;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_INIT_MEETING);

  log_packet_detailed("packet_diplomacy_init_meeting_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_init_meeting_100, cmp_packet_diplomacy_init_meeting_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->counterpart != real_packet->counterpart);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->initiated_from != real_packet->initiated_from);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'counterpart' has changed");
    dio_put_sint8(&dout, real_packet->counterpart);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'initiated_from' has changed");
    dio_put_sint8(&dout, real_packet->initiated_from);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_diplomacy_init_meeting(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_DIPLOMACY_INIT_MEETING] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_DIPLOMACY_INIT_MEETING variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_DIPLOMACY_INIT_MEETING] = variant;
}

struct packet_diplomacy_init_meeting *receive_packet_diplomacy_init_meeting(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_diplomacy_init_meeting at the server.");
  }
  ensure_valid_variant_packet_diplomacy_init_meeting(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_INIT_MEETING]) {
  case 100:
    return receive_packet_diplomacy_init_meeting_100(pc, type);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_INIT_MEETING variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_diplomacy_init_meeting(struct connection *pc, const struct packet_diplomacy_init_meeting *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_diplomacy_init_meeting from the client.");
  }
  ensure_valid_variant_packet_diplomacy_init_meeting(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_INIT_MEETING]) {

  case 100:
    return send_packet_diplomacy_init_meeting_100(pc, packet);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_INIT_MEETING variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_diplomacy_init_meeting(struct conn_list *dest, const struct packet_diplomacy_init_meeting *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_diplomacy_init_meeting(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_diplomacy_init_meeting(struct connection *pc, int counterpart, int initiated_from)
{
  struct packet_diplomacy_init_meeting packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->initiated_from = initiated_from;
  
  return send_packet_diplomacy_init_meeting(pc, real_packet);
}

void dlsend_packet_diplomacy_init_meeting(struct conn_list *dest, int counterpart, int initiated_from)
{
  struct packet_diplomacy_init_meeting packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->initiated_from = initiated_from;
  
  lsend_packet_diplomacy_init_meeting(dest, real_packet);
}

#define hash_packet_diplomacy_cancel_meeting_req_100 hash_const

#define cmp_packet_diplomacy_cancel_meeting_req_100 cmp_const

BV_DEFINE(packet_diplomacy_cancel_meeting_req_100_fields, 1);

static struct packet_diplomacy_cancel_meeting_req *receive_packet_diplomacy_cancel_meeting_req_100(struct connection *pc, enum packet_type type)
{
  packet_diplomacy_cancel_meeting_req_100_fields fields;
  struct packet_diplomacy_cancel_meeting_req *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_diplomacy_cancel_meeting_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_cancel_meeting_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_cancel_meeting_req_100, cmp_packet_diplomacy_cancel_meeting_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'counterpart'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->counterpart = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_cancel_meeting_req_100(struct connection *pc, const struct packet_diplomacy_cancel_meeting_req *packet)
{
  const struct packet_diplomacy_cancel_meeting_req *real_packet = packet;
  packet_diplomacy_cancel_meeting_req_100_fields fields;
  struct packet_diplomacy_cancel_meeting_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_CANCEL_MEETING_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_CANCEL_MEETING_REQ);

  log_packet_detailed("packet_diplomacy_cancel_meeting_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_cancel_meeting_req_100, cmp_packet_diplomacy_cancel_meeting_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->counterpart != real_packet->counterpart);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'counterpart' has changed");
    dio_put_sint8(&dout, real_packet->counterpart);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_diplomacy_cancel_meeting_req(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_DIPLOMACY_CANCEL_MEETING_REQ] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_DIPLOMACY_CANCEL_MEETING_REQ variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_DIPLOMACY_CANCEL_MEETING_REQ] = variant;
}

struct packet_diplomacy_cancel_meeting_req *receive_packet_diplomacy_cancel_meeting_req(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_diplomacy_cancel_meeting_req at the client.");
  }
  ensure_valid_variant_packet_diplomacy_cancel_meeting_req(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_CANCEL_MEETING_REQ]) {
  case 100:
    return receive_packet_diplomacy_cancel_meeting_req_100(pc, type);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_CANCEL_MEETING_REQ variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_diplomacy_cancel_meeting_req(struct connection *pc, const struct packet_diplomacy_cancel_meeting_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_diplomacy_cancel_meeting_req from the server.");
  }
  ensure_valid_variant_packet_diplomacy_cancel_meeting_req(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_CANCEL_MEETING_REQ]) {

  case 100:
    return send_packet_diplomacy_cancel_meeting_req_100(pc, packet);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_CANCEL_MEETING_REQ variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_diplomacy_cancel_meeting_req(struct connection *pc, int counterpart)
{
  struct packet_diplomacy_cancel_meeting_req packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  
  return send_packet_diplomacy_cancel_meeting_req(pc, real_packet);
}

#define hash_packet_diplomacy_cancel_meeting_100 hash_const

#define cmp_packet_diplomacy_cancel_meeting_100 cmp_const

BV_DEFINE(packet_diplomacy_cancel_meeting_100_fields, 2);

static struct packet_diplomacy_cancel_meeting *receive_packet_diplomacy_cancel_meeting_100(struct connection *pc, enum packet_type type)
{
  packet_diplomacy_cancel_meeting_100_fields fields;
  struct packet_diplomacy_cancel_meeting *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_diplomacy_cancel_meeting, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_cancel_meeting_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_cancel_meeting_100, cmp_packet_diplomacy_cancel_meeting_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'counterpart'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->counterpart = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'initiated_from'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->initiated_from = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_cancel_meeting_100(struct connection *pc, const struct packet_diplomacy_cancel_meeting *packet)
{
  const struct packet_diplomacy_cancel_meeting *real_packet = packet;
  packet_diplomacy_cancel_meeting_100_fields fields;
  struct packet_diplomacy_cancel_meeting *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_CANCEL_MEETING;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_CANCEL_MEETING);

  log_packet_detailed("packet_diplomacy_cancel_meeting_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_cancel_meeting_100, cmp_packet_diplomacy_cancel_meeting_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->counterpart != real_packet->counterpart);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->initiated_from != real_packet->initiated_from);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'counterpart' has changed");
    dio_put_sint8(&dout, real_packet->counterpart);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'initiated_from' has changed");
    dio_put_sint8(&dout, real_packet->initiated_from);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_diplomacy_cancel_meeting(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_DIPLOMACY_CANCEL_MEETING] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_DIPLOMACY_CANCEL_MEETING variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_DIPLOMACY_CANCEL_MEETING] = variant;
}

struct packet_diplomacy_cancel_meeting *receive_packet_diplomacy_cancel_meeting(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_diplomacy_cancel_meeting at the server.");
  }
  ensure_valid_variant_packet_diplomacy_cancel_meeting(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_CANCEL_MEETING]) {
  case 100:
    return receive_packet_diplomacy_cancel_meeting_100(pc, type);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_CANCEL_MEETING variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_diplomacy_cancel_meeting(struct connection *pc, const struct packet_diplomacy_cancel_meeting *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_diplomacy_cancel_meeting from the client.");
  }
  ensure_valid_variant_packet_diplomacy_cancel_meeting(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_CANCEL_MEETING]) {

  case 100:
    return send_packet_diplomacy_cancel_meeting_100(pc, packet);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_CANCEL_MEETING variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_diplomacy_cancel_meeting(struct conn_list *dest, const struct packet_diplomacy_cancel_meeting *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_diplomacy_cancel_meeting(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_diplomacy_cancel_meeting(struct connection *pc, int counterpart, int initiated_from)
{
  struct packet_diplomacy_cancel_meeting packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->initiated_from = initiated_from;
  
  return send_packet_diplomacy_cancel_meeting(pc, real_packet);
}

void dlsend_packet_diplomacy_cancel_meeting(struct conn_list *dest, int counterpart, int initiated_from)
{
  struct packet_diplomacy_cancel_meeting packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->initiated_from = initiated_from;
  
  lsend_packet_diplomacy_cancel_meeting(dest, real_packet);
}

#define hash_packet_diplomacy_create_clause_req_100 hash_const

#define cmp_packet_diplomacy_create_clause_req_100 cmp_const

BV_DEFINE(packet_diplomacy_create_clause_req_100_fields, 4);

static struct packet_diplomacy_create_clause_req *receive_packet_diplomacy_create_clause_req_100(struct connection *pc, enum packet_type type)
{
  packet_diplomacy_create_clause_req_100_fields fields;
  struct packet_diplomacy_create_clause_req *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_diplomacy_create_clause_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_create_clause_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_create_clause_req_100, cmp_packet_diplomacy_create_clause_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'counterpart'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->counterpart = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'giver'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->giver = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'value'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->value = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_create_clause_req_100(struct connection *pc, const struct packet_diplomacy_create_clause_req *packet)
{
  const struct packet_diplomacy_create_clause_req *real_packet = packet;
  packet_diplomacy_create_clause_req_100_fields fields;
  struct packet_diplomacy_create_clause_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_CREATE_CLAUSE_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_CREATE_CLAUSE_REQ);

  log_packet_detailed("packet_diplomacy_create_clause_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_create_clause_req_100, cmp_packet_diplomacy_create_clause_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->counterpart != real_packet->counterpart);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->giver != real_packet->giver);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->value != real_packet->value);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'counterpart' has changed");
    dio_put_sint8(&dout, real_packet->counterpart);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'giver' has changed");
    dio_put_sint8(&dout, real_packet->giver);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'type' has changed");
    dio_put_uint8(&dout, real_packet->type);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'value' has changed");
    dio_put_uint32(&dout, real_packet->value);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_diplomacy_create_clause_req(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_DIPLOMACY_CREATE_CLAUSE_REQ] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_DIPLOMACY_CREATE_CLAUSE_REQ variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_DIPLOMACY_CREATE_CLAUSE_REQ] = variant;
}

struct packet_diplomacy_create_clause_req *receive_packet_diplomacy_create_clause_req(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_diplomacy_create_clause_req at the client.");
  }
  ensure_valid_variant_packet_diplomacy_create_clause_req(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_CREATE_CLAUSE_REQ]) {
  case 100:
    return receive_packet_diplomacy_create_clause_req_100(pc, type);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_CREATE_CLAUSE_REQ variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_diplomacy_create_clause_req(struct connection *pc, const struct packet_diplomacy_create_clause_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_diplomacy_create_clause_req from the server.");
  }
  ensure_valid_variant_packet_diplomacy_create_clause_req(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_CREATE_CLAUSE_REQ]) {

  case 100:
    return send_packet_diplomacy_create_clause_req_100(pc, packet);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_CREATE_CLAUSE_REQ variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_diplomacy_create_clause_req(struct connection *pc, int counterpart, int giver, enum clause_type type, int value)
{
  struct packet_diplomacy_create_clause_req packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->giver = giver;
  real_packet->type = type;
  real_packet->value = value;
  
  return send_packet_diplomacy_create_clause_req(pc, real_packet);
}

#define hash_packet_diplomacy_create_clause_100 hash_const

#define cmp_packet_diplomacy_create_clause_100 cmp_const

BV_DEFINE(packet_diplomacy_create_clause_100_fields, 4);

static struct packet_diplomacy_create_clause *receive_packet_diplomacy_create_clause_100(struct connection *pc, enum packet_type type)
{
  packet_diplomacy_create_clause_100_fields fields;
  struct packet_diplomacy_create_clause *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_diplomacy_create_clause, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_create_clause_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_create_clause_100, cmp_packet_diplomacy_create_clause_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'counterpart'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->counterpart = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'giver'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->giver = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'value'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->value = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_create_clause_100(struct connection *pc, const struct packet_diplomacy_create_clause *packet)
{
  const struct packet_diplomacy_create_clause *real_packet = packet;
  packet_diplomacy_create_clause_100_fields fields;
  struct packet_diplomacy_create_clause *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_CREATE_CLAUSE;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_CREATE_CLAUSE);

  log_packet_detailed("packet_diplomacy_create_clause_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_create_clause_100, cmp_packet_diplomacy_create_clause_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->counterpart != real_packet->counterpart);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->giver != real_packet->giver);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->value != real_packet->value);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'counterpart' has changed");
    dio_put_sint8(&dout, real_packet->counterpart);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'giver' has changed");
    dio_put_sint8(&dout, real_packet->giver);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'type' has changed");
    dio_put_uint8(&dout, real_packet->type);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'value' has changed");
    dio_put_uint32(&dout, real_packet->value);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_diplomacy_create_clause(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_DIPLOMACY_CREATE_CLAUSE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_DIPLOMACY_CREATE_CLAUSE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_DIPLOMACY_CREATE_CLAUSE] = variant;
}

struct packet_diplomacy_create_clause *receive_packet_diplomacy_create_clause(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_diplomacy_create_clause at the server.");
  }
  ensure_valid_variant_packet_diplomacy_create_clause(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_CREATE_CLAUSE]) {
  case 100:
    return receive_packet_diplomacy_create_clause_100(pc, type);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_CREATE_CLAUSE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_diplomacy_create_clause(struct connection *pc, const struct packet_diplomacy_create_clause *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_diplomacy_create_clause from the client.");
  }
  ensure_valid_variant_packet_diplomacy_create_clause(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_CREATE_CLAUSE]) {

  case 100:
    return send_packet_diplomacy_create_clause_100(pc, packet);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_CREATE_CLAUSE variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_diplomacy_create_clause(struct conn_list *dest, const struct packet_diplomacy_create_clause *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_diplomacy_create_clause(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_diplomacy_create_clause(struct connection *pc, int counterpart, int giver, enum clause_type type, int value)
{
  struct packet_diplomacy_create_clause packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->giver = giver;
  real_packet->type = type;
  real_packet->value = value;
  
  return send_packet_diplomacy_create_clause(pc, real_packet);
}

void dlsend_packet_diplomacy_create_clause(struct conn_list *dest, int counterpart, int giver, enum clause_type type, int value)
{
  struct packet_diplomacy_create_clause packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->giver = giver;
  real_packet->type = type;
  real_packet->value = value;
  
  lsend_packet_diplomacy_create_clause(dest, real_packet);
}

#define hash_packet_diplomacy_remove_clause_req_100 hash_const

#define cmp_packet_diplomacy_remove_clause_req_100 cmp_const

BV_DEFINE(packet_diplomacy_remove_clause_req_100_fields, 4);

static struct packet_diplomacy_remove_clause_req *receive_packet_diplomacy_remove_clause_req_100(struct connection *pc, enum packet_type type)
{
  packet_diplomacy_remove_clause_req_100_fields fields;
  struct packet_diplomacy_remove_clause_req *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_diplomacy_remove_clause_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_remove_clause_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_remove_clause_req_100, cmp_packet_diplomacy_remove_clause_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'counterpart'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->counterpart = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'giver'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->giver = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'value'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->value = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_remove_clause_req_100(struct connection *pc, const struct packet_diplomacy_remove_clause_req *packet)
{
  const struct packet_diplomacy_remove_clause_req *real_packet = packet;
  packet_diplomacy_remove_clause_req_100_fields fields;
  struct packet_diplomacy_remove_clause_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ);

  log_packet_detailed("packet_diplomacy_remove_clause_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_remove_clause_req_100, cmp_packet_diplomacy_remove_clause_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->counterpart != real_packet->counterpart);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->giver != real_packet->giver);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->value != real_packet->value);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'counterpart' has changed");
    dio_put_sint8(&dout, real_packet->counterpart);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'giver' has changed");
    dio_put_sint8(&dout, real_packet->giver);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'type' has changed");
    dio_put_uint8(&dout, real_packet->type);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'value' has changed");
    dio_put_uint32(&dout, real_packet->value);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_diplomacy_remove_clause_req(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ] = variant;
}

struct packet_diplomacy_remove_clause_req *receive_packet_diplomacy_remove_clause_req(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_diplomacy_remove_clause_req at the client.");
  }
  ensure_valid_variant_packet_diplomacy_remove_clause_req(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ]) {
  case 100:
    return receive_packet_diplomacy_remove_clause_req_100(pc, type);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_diplomacy_remove_clause_req(struct connection *pc, const struct packet_diplomacy_remove_clause_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_diplomacy_remove_clause_req from the server.");
  }
  ensure_valid_variant_packet_diplomacy_remove_clause_req(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ]) {

  case 100:
    return send_packet_diplomacy_remove_clause_req_100(pc, packet);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_diplomacy_remove_clause_req(struct connection *pc, int counterpart, int giver, enum clause_type type, int value)
{
  struct packet_diplomacy_remove_clause_req packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->giver = giver;
  real_packet->type = type;
  real_packet->value = value;
  
  return send_packet_diplomacy_remove_clause_req(pc, real_packet);
}

#define hash_packet_diplomacy_remove_clause_100 hash_const

#define cmp_packet_diplomacy_remove_clause_100 cmp_const

BV_DEFINE(packet_diplomacy_remove_clause_100_fields, 4);

static struct packet_diplomacy_remove_clause *receive_packet_diplomacy_remove_clause_100(struct connection *pc, enum packet_type type)
{
  packet_diplomacy_remove_clause_100_fields fields;
  struct packet_diplomacy_remove_clause *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_diplomacy_remove_clause, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_remove_clause_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_remove_clause_100, cmp_packet_diplomacy_remove_clause_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'counterpart'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->counterpart = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'giver'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->giver = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'value'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->value = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_remove_clause_100(struct connection *pc, const struct packet_diplomacy_remove_clause *packet)
{
  const struct packet_diplomacy_remove_clause *real_packet = packet;
  packet_diplomacy_remove_clause_100_fields fields;
  struct packet_diplomacy_remove_clause *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_REMOVE_CLAUSE;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_REMOVE_CLAUSE);

  log_packet_detailed("packet_diplomacy_remove_clause_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_remove_clause_100, cmp_packet_diplomacy_remove_clause_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->counterpart != real_packet->counterpart);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->giver != real_packet->giver);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->value != real_packet->value);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'counterpart' has changed");
    dio_put_sint8(&dout, real_packet->counterpart);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'giver' has changed");
    dio_put_sint8(&dout, real_packet->giver);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'type' has changed");
    dio_put_uint8(&dout, real_packet->type);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'value' has changed");
    dio_put_uint32(&dout, real_packet->value);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_diplomacy_remove_clause(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_DIPLOMACY_REMOVE_CLAUSE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_DIPLOMACY_REMOVE_CLAUSE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_DIPLOMACY_REMOVE_CLAUSE] = variant;
}

struct packet_diplomacy_remove_clause *receive_packet_diplomacy_remove_clause(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_diplomacy_remove_clause at the server.");
  }
  ensure_valid_variant_packet_diplomacy_remove_clause(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_REMOVE_CLAUSE]) {
  case 100:
    return receive_packet_diplomacy_remove_clause_100(pc, type);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_REMOVE_CLAUSE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_diplomacy_remove_clause(struct connection *pc, const struct packet_diplomacy_remove_clause *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_diplomacy_remove_clause from the client.");
  }
  ensure_valid_variant_packet_diplomacy_remove_clause(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_REMOVE_CLAUSE]) {

  case 100:
    return send_packet_diplomacy_remove_clause_100(pc, packet);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_REMOVE_CLAUSE variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_diplomacy_remove_clause(struct conn_list *dest, const struct packet_diplomacy_remove_clause *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_diplomacy_remove_clause(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_diplomacy_remove_clause(struct connection *pc, int counterpart, int giver, enum clause_type type, int value)
{
  struct packet_diplomacy_remove_clause packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->giver = giver;
  real_packet->type = type;
  real_packet->value = value;
  
  return send_packet_diplomacy_remove_clause(pc, real_packet);
}

void dlsend_packet_diplomacy_remove_clause(struct conn_list *dest, int counterpart, int giver, enum clause_type type, int value)
{
  struct packet_diplomacy_remove_clause packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->giver = giver;
  real_packet->type = type;
  real_packet->value = value;
  
  lsend_packet_diplomacy_remove_clause(dest, real_packet);
}

#define hash_packet_diplomacy_accept_treaty_req_100 hash_const

#define cmp_packet_diplomacy_accept_treaty_req_100 cmp_const

BV_DEFINE(packet_diplomacy_accept_treaty_req_100_fields, 1);

static struct packet_diplomacy_accept_treaty_req *receive_packet_diplomacy_accept_treaty_req_100(struct connection *pc, enum packet_type type)
{
  packet_diplomacy_accept_treaty_req_100_fields fields;
  struct packet_diplomacy_accept_treaty_req *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_diplomacy_accept_treaty_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_accept_treaty_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_accept_treaty_req_100, cmp_packet_diplomacy_accept_treaty_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'counterpart'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->counterpart = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_accept_treaty_req_100(struct connection *pc, const struct packet_diplomacy_accept_treaty_req *packet)
{
  const struct packet_diplomacy_accept_treaty_req *real_packet = packet;
  packet_diplomacy_accept_treaty_req_100_fields fields;
  struct packet_diplomacy_accept_treaty_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_ACCEPT_TREATY_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_ACCEPT_TREATY_REQ);

  log_packet_detailed("packet_diplomacy_accept_treaty_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_accept_treaty_req_100, cmp_packet_diplomacy_accept_treaty_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->counterpart != real_packet->counterpart);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'counterpart' has changed");
    dio_put_sint8(&dout, real_packet->counterpart);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_diplomacy_accept_treaty_req(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_DIPLOMACY_ACCEPT_TREATY_REQ] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_DIPLOMACY_ACCEPT_TREATY_REQ variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_DIPLOMACY_ACCEPT_TREATY_REQ] = variant;
}

struct packet_diplomacy_accept_treaty_req *receive_packet_diplomacy_accept_treaty_req(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_diplomacy_accept_treaty_req at the client.");
  }
  ensure_valid_variant_packet_diplomacy_accept_treaty_req(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_ACCEPT_TREATY_REQ]) {
  case 100:
    return receive_packet_diplomacy_accept_treaty_req_100(pc, type);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_ACCEPT_TREATY_REQ variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_diplomacy_accept_treaty_req(struct connection *pc, const struct packet_diplomacy_accept_treaty_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_diplomacy_accept_treaty_req from the server.");
  }
  ensure_valid_variant_packet_diplomacy_accept_treaty_req(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_ACCEPT_TREATY_REQ]) {

  case 100:
    return send_packet_diplomacy_accept_treaty_req_100(pc, packet);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_ACCEPT_TREATY_REQ variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_diplomacy_accept_treaty_req(struct connection *pc, int counterpart)
{
  struct packet_diplomacy_accept_treaty_req packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  
  return send_packet_diplomacy_accept_treaty_req(pc, real_packet);
}

#define hash_packet_diplomacy_accept_treaty_100 hash_const

#define cmp_packet_diplomacy_accept_treaty_100 cmp_const

BV_DEFINE(packet_diplomacy_accept_treaty_100_fields, 3);

static struct packet_diplomacy_accept_treaty *receive_packet_diplomacy_accept_treaty_100(struct connection *pc, enum packet_type type)
{
  packet_diplomacy_accept_treaty_100_fields fields;
  struct packet_diplomacy_accept_treaty *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_diplomacy_accept_treaty, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_accept_treaty_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_accept_treaty_100, cmp_packet_diplomacy_accept_treaty_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'counterpart'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->counterpart = readin;
    }
  }
  real_packet->I_accepted = BV_ISSET(fields, 1);
  real_packet->other_accepted = BV_ISSET(fields, 2);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_accept_treaty_100(struct connection *pc, const struct packet_diplomacy_accept_treaty *packet)
{
  const struct packet_diplomacy_accept_treaty *real_packet = packet;
  packet_diplomacy_accept_treaty_100_fields fields;
  struct packet_diplomacy_accept_treaty *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_ACCEPT_TREATY;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_ACCEPT_TREATY);

  log_packet_detailed("packet_diplomacy_accept_treaty_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_accept_treaty_100, cmp_packet_diplomacy_accept_treaty_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->counterpart != real_packet->counterpart);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->I_accepted != real_packet->I_accepted);
  if(differ) {
    different++;
  }
  if (packet->I_accepted) {
    BV_SET(fields, 1);
  }

  differ = (old->other_accepted != real_packet->other_accepted);
  if(differ) {
    different++;
  }
  if (packet->other_accepted) {
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'counterpart' has changed");
    dio_put_sint8(&dout, real_packet->counterpart);
  }
  /* field 1 is folded into the header */
  /* field 2 is folded into the header */

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_diplomacy_accept_treaty(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_DIPLOMACY_ACCEPT_TREATY] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_DIPLOMACY_ACCEPT_TREATY variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_DIPLOMACY_ACCEPT_TREATY] = variant;
}

struct packet_diplomacy_accept_treaty *receive_packet_diplomacy_accept_treaty(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_diplomacy_accept_treaty at the server.");
  }
  ensure_valid_variant_packet_diplomacy_accept_treaty(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_ACCEPT_TREATY]) {
  case 100:
    return receive_packet_diplomacy_accept_treaty_100(pc, type);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_ACCEPT_TREATY variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_diplomacy_accept_treaty(struct connection *pc, const struct packet_diplomacy_accept_treaty *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_diplomacy_accept_treaty from the client.");
  }
  ensure_valid_variant_packet_diplomacy_accept_treaty(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_ACCEPT_TREATY]) {

  case 100:
    return send_packet_diplomacy_accept_treaty_100(pc, packet);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_ACCEPT_TREATY variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_diplomacy_accept_treaty(struct conn_list *dest, const struct packet_diplomacy_accept_treaty *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_diplomacy_accept_treaty(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_diplomacy_accept_treaty(struct connection *pc, int counterpart, bool I_accepted, bool other_accepted)
{
  struct packet_diplomacy_accept_treaty packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->I_accepted = I_accepted;
  real_packet->other_accepted = other_accepted;
  
  return send_packet_diplomacy_accept_treaty(pc, real_packet);
}

void dlsend_packet_diplomacy_accept_treaty(struct conn_list *dest, int counterpart, bool I_accepted, bool other_accepted)
{
  struct packet_diplomacy_accept_treaty packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->I_accepted = I_accepted;
  real_packet->other_accepted = other_accepted;
  
  lsend_packet_diplomacy_accept_treaty(dest, real_packet);
}

#define hash_packet_diplomacy_cancel_pact_100 hash_const

#define cmp_packet_diplomacy_cancel_pact_100 cmp_const

BV_DEFINE(packet_diplomacy_cancel_pact_100_fields, 2);

static struct packet_diplomacy_cancel_pact *receive_packet_diplomacy_cancel_pact_100(struct connection *pc, enum packet_type type)
{
  packet_diplomacy_cancel_pact_100_fields fields;
  struct packet_diplomacy_cancel_pact *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_diplomacy_cancel_pact, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_cancel_pact_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_cancel_pact_100, cmp_packet_diplomacy_cancel_pact_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'other_player_id'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->other_player_id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'clause'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->clause = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_cancel_pact_100(struct connection *pc, const struct packet_diplomacy_cancel_pact *packet)
{
  const struct packet_diplomacy_cancel_pact *real_packet = packet;
  packet_diplomacy_cancel_pact_100_fields fields;
  struct packet_diplomacy_cancel_pact *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_CANCEL_PACT;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_CANCEL_PACT);

  log_packet_detailed("packet_diplomacy_cancel_pact_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_cancel_pact_100, cmp_packet_diplomacy_cancel_pact_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->other_player_id != real_packet->other_player_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->clause != real_packet->clause);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'other_player_id' has changed");
    dio_put_sint8(&dout, real_packet->other_player_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'clause' has changed");
    dio_put_uint8(&dout, real_packet->clause);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_diplomacy_cancel_pact(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_DIPLOMACY_CANCEL_PACT] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_DIPLOMACY_CANCEL_PACT variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_DIPLOMACY_CANCEL_PACT] = variant;
}

struct packet_diplomacy_cancel_pact *receive_packet_diplomacy_cancel_pact(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_diplomacy_cancel_pact at the client.");
  }
  ensure_valid_variant_packet_diplomacy_cancel_pact(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_CANCEL_PACT]) {
  case 100:
    return receive_packet_diplomacy_cancel_pact_100(pc, type);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_CANCEL_PACT variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_diplomacy_cancel_pact(struct connection *pc, const struct packet_diplomacy_cancel_pact *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_diplomacy_cancel_pact from the server.");
  }
  ensure_valid_variant_packet_diplomacy_cancel_pact(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_CANCEL_PACT]) {

  case 100:
    return send_packet_diplomacy_cancel_pact_100(pc, packet);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_CANCEL_PACT variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_diplomacy_cancel_pact(struct connection *pc, int other_player_id, enum clause_type clause)
{
  struct packet_diplomacy_cancel_pact packet, *real_packet = &packet;

  real_packet->other_player_id = other_player_id;
  real_packet->clause = clause;
  
  return send_packet_diplomacy_cancel_pact(pc, real_packet);
}

#define hash_packet_page_msg_100 hash_const

#define cmp_packet_page_msg_100 cmp_const

BV_DEFINE(packet_page_msg_100_fields, 4);

static struct packet_page_msg *receive_packet_page_msg_100(struct connection *pc, enum packet_type type)
{
  packet_page_msg_100_fields fields;
  struct packet_page_msg *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_page_msg, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_page_msg_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_page_msg_100, cmp_packet_page_msg_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'caption'");
    dio_get_string(&din, real_packet->caption, sizeof(real_packet->caption));
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'headline'");
    dio_get_string(&din, real_packet->headline, sizeof(real_packet->headline));
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'lines'");
    dio_get_string(&din, real_packet->lines, sizeof(real_packet->lines));
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'event'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->event = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_page_msg_100(struct connection *pc, const struct packet_page_msg *packet)
{
  const struct packet_page_msg *real_packet = packet;
  packet_page_msg_100_fields fields;
  struct packet_page_msg *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PAGE_MSG;
  int different = 0;
  SEND_PACKET_START(PACKET_PAGE_MSG);

  log_packet_detailed("packet_page_msg_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_page_msg_100, cmp_packet_page_msg_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->caption, real_packet->caption) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->headline, real_packet->headline) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->lines, real_packet->lines) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->event != real_packet->event);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'caption' has changed");
    dio_put_string(&dout, real_packet->caption);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'headline' has changed");
    dio_put_string(&dout, real_packet->headline);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'lines' has changed");
    dio_put_string(&dout, real_packet->lines);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'event' has changed");
    dio_put_sint16(&dout, real_packet->event);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_page_msg(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_PAGE_MSG] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_PAGE_MSG variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_PAGE_MSG] = variant;
}

struct packet_page_msg *receive_packet_page_msg(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_page_msg at the server.");
  }
  ensure_valid_variant_packet_page_msg(pc);

  switch(pc->phs.variant[PACKET_PAGE_MSG]) {
  case 100:
    return receive_packet_page_msg_100(pc, type);
  default:
    log_debug("Unknown PACKET_PAGE_MSG variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_page_msg(struct connection *pc, const struct packet_page_msg *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_page_msg from the client.");
  }
  ensure_valid_variant_packet_page_msg(pc);

  switch(pc->phs.variant[PACKET_PAGE_MSG]) {

  case 100:
    return send_packet_page_msg_100(pc, packet);
  default:
    log_debug("Unknown PACKET_PAGE_MSG variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_page_msg(struct conn_list *dest, const struct packet_page_msg *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_page_msg(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_report_req_100 hash_const

#define cmp_packet_report_req_100 cmp_const

BV_DEFINE(packet_report_req_100_fields, 1);

static struct packet_report_req *receive_packet_report_req_100(struct connection *pc, enum packet_type type)
{
  packet_report_req_100_fields fields;
  struct packet_report_req *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_report_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_report_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_report_req_100, cmp_packet_report_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->type = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_report_req_100(struct connection *pc, const struct packet_report_req *packet)
{
  const struct packet_report_req *real_packet = packet;
  packet_report_req_100_fields fields;
  struct packet_report_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_REPORT_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_REPORT_REQ);

  log_packet_detailed("packet_report_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_report_req_100, cmp_packet_report_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'type' has changed");
    dio_put_uint8(&dout, real_packet->type);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_report_req(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_REPORT_REQ] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_REPORT_REQ variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_REPORT_REQ] = variant;
}

struct packet_report_req *receive_packet_report_req(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_report_req at the client.");
  }
  ensure_valid_variant_packet_report_req(pc);

  switch(pc->phs.variant[PACKET_REPORT_REQ]) {
  case 100:
    return receive_packet_report_req_100(pc, type);
  default:
    log_debug("Unknown PACKET_REPORT_REQ variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_report_req(struct connection *pc, const struct packet_report_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_report_req from the server.");
  }
  ensure_valid_variant_packet_report_req(pc);

  switch(pc->phs.variant[PACKET_REPORT_REQ]) {

  case 100:
    return send_packet_report_req_100(pc, packet);
  default:
    log_debug("Unknown PACKET_REPORT_REQ variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_report_req(struct connection *pc, enum report_type type)
{
  struct packet_report_req packet, *real_packet = &packet;

  real_packet->type = type;
  
  return send_packet_report_req(pc, real_packet);
}

static genhash_val_t hash_packet_conn_info_100(const void *vkey, size_t num_buckets)
{
  const struct packet_conn_info *key = (const struct packet_conn_info *) vkey;

  return ((key->id) % num_buckets);
}

static bool cmp_packet_conn_info_100(const void *vkey1, const void *vkey2)
{
  const struct packet_conn_info *key1 = (const struct packet_conn_info *) vkey1;
  const struct packet_conn_info *key2 = (const struct packet_conn_info *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_conn_info_100_fields, 8);

static struct packet_conn_info *receive_packet_conn_info_100(struct connection *pc, enum packet_type type)
{
  packet_conn_info_100_fields fields;
  struct packet_conn_info *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_conn_info, real_packet);

  DIO_BV_GET(&din, fields);
  {
    int readin;
  
    dio_get_sint16(&din, &readin);
    real_packet->id = readin;
  }

  log_packet_detailed("packet_conn_info_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_conn_info_100, cmp_packet_conn_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  real_packet->used = BV_ISSET(fields, 0);
  real_packet->established = BV_ISSET(fields, 1);
  real_packet->observer = BV_ISSET(fields, 2);
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'player_num'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->player_num = readin;
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'access_level'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->access_level = readin;
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'username'");
    dio_get_string(&din, real_packet->username, sizeof(real_packet->username));
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'addr'");
    dio_get_string(&din, real_packet->addr, sizeof(real_packet->addr));
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'capability'");
    dio_get_string(&din, real_packet->capability, sizeof(real_packet->capability));
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_conn_info_100(struct connection *pc, const struct packet_conn_info *packet)
{
  const struct packet_conn_info *real_packet = packet;
  packet_conn_info_100_fields fields;
  struct packet_conn_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CONN_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_CONN_INFO);

  log_packet_detailed("packet_conn_info_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_conn_info_100, cmp_packet_conn_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->used != real_packet->used);
  if(differ) {
    different++;
  }
  if (packet->used) {
    BV_SET(fields, 0);
  }

  differ = (old->established != real_packet->established);
  if(differ) {
    different++;
  }
  if (packet->established) {
    BV_SET(fields, 1);
  }

  differ = (old->observer != real_packet->observer);
  if(differ) {
    different++;
  }
  if (packet->observer) {
    BV_SET(fields, 2);
  }

  differ = (old->player_num != real_packet->player_num);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->access_level != real_packet->access_level);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (strcmp(old->username, real_packet->username) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (strcmp(old->addr, real_packet->addr) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (strcmp(old->capability, real_packet->capability) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, fields);
  dio_put_sint16(&dout, real_packet->id);

  /* field 0 is folded into the header */
  /* field 1 is folded into the header */
  /* field 2 is folded into the header */
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'player_num' has changed");
    dio_put_sint8(&dout, real_packet->player_num);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'access_level' has changed");
    dio_put_uint8(&dout, real_packet->access_level);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'username' has changed");
    dio_put_string(&dout, real_packet->username);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'addr' has changed");
    dio_put_string(&dout, real_packet->addr);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'capability' has changed");
    dio_put_string(&dout, real_packet->capability);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_conn_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CONN_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CONN_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CONN_INFO] = variant;
}

struct packet_conn_info *receive_packet_conn_info(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_conn_info at the server.");
  }
  ensure_valid_variant_packet_conn_info(pc);

  switch(pc->phs.variant[PACKET_CONN_INFO]) {
  case 100:
    return receive_packet_conn_info_100(pc, type);
  default:
    log_debug("Unknown PACKET_CONN_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_conn_info(struct connection *pc, const struct packet_conn_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_conn_info from the client.");
  }
  ensure_valid_variant_packet_conn_info(pc);

  switch(pc->phs.variant[PACKET_CONN_INFO]) {

  case 100:
    return send_packet_conn_info_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CONN_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_conn_info(struct conn_list *dest, const struct packet_conn_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_conn_info(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_conn_ping_info_100 hash_const

#define cmp_packet_conn_ping_info_100 cmp_const

BV_DEFINE(packet_conn_ping_info_100_fields, 3);

static struct packet_conn_ping_info *receive_packet_conn_ping_info_100(struct connection *pc, enum packet_type type)
{
  packet_conn_ping_info_100_fields fields;
  struct packet_conn_ping_info *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_conn_ping_info, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_conn_ping_info_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_conn_ping_info_100, cmp_packet_conn_ping_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'connections'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->connections = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'conn_id'");
    
    {
      int i;
    
      if(real_packet->connections > MAX_NUM_CONNECTIONS) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->connections = MAX_NUM_CONNECTIONS;
      }
      for (i = 0; i < real_packet->connections; i++) {
        {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->conn_id[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'ping_time'");
    
    {
      int i;
    
      if(real_packet->connections > MAX_NUM_CONNECTIONS) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->connections = MAX_NUM_CONNECTIONS;
      }
      for (i = 0; i < real_packet->connections; i++) {
        int tmp;
    
        dio_get_uint32(&din, &tmp);
        real_packet->ping_time[i] = (float)(tmp) / 1000000.0;
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_conn_ping_info_100(struct connection *pc, const struct packet_conn_ping_info *packet)
{
  const struct packet_conn_ping_info *real_packet = packet;
  packet_conn_ping_info_100_fields fields;
  struct packet_conn_ping_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CONN_PING_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_CONN_PING_INFO);

  log_packet_detailed("packet_conn_ping_info_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_conn_ping_info_100, cmp_packet_conn_ping_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->connections != real_packet->connections);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


    {
      differ = (old->connections != real_packet->connections);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->connections; i++) {
          if (old->conn_id[i] != real_packet->conn_id[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


    {
      differ = (old->connections != real_packet->connections);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->connections; i++) {
          if (old->ping_time[i] != real_packet->ping_time[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'connections' has changed");
    dio_put_uint8(&dout, real_packet->connections);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'conn_id' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->connections; i++) {
        dio_put_sint16(&dout, real_packet->conn_id[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'ping_time' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->connections; i++) {
          dio_put_uint32(&dout, (int)(real_packet->ping_time[i] * 1000000));
      }
    } 
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_conn_ping_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CONN_PING_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CONN_PING_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CONN_PING_INFO] = variant;
}

struct packet_conn_ping_info *receive_packet_conn_ping_info(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_conn_ping_info at the server.");
  }
  ensure_valid_variant_packet_conn_ping_info(pc);

  switch(pc->phs.variant[PACKET_CONN_PING_INFO]) {
  case 100:
    return receive_packet_conn_ping_info_100(pc, type);
  default:
    log_debug("Unknown PACKET_CONN_PING_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_conn_ping_info(struct connection *pc, const struct packet_conn_ping_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_conn_ping_info from the client.");
  }
  ensure_valid_variant_packet_conn_ping_info(pc);

  switch(pc->phs.variant[PACKET_CONN_PING_INFO]) {

  case 100:
    return send_packet_conn_ping_info_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CONN_PING_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_conn_ping_info(struct conn_list *dest, const struct packet_conn_ping_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_conn_ping_info(pconn, packet);
  } conn_list_iterate_end;
}

static struct packet_conn_ping *receive_packet_conn_ping_100(struct connection *pc, enum packet_type type)
{
  RECEIVE_PACKET_START(packet_conn_ping, real_packet);

  log_packet_detailed("packet_conn_ping_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_conn_ping_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_CONN_PING);

  log_packet_detailed("packet_conn_ping_100: sending info about ()");
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_conn_ping(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CONN_PING] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CONN_PING variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CONN_PING] = variant;
}

struct packet_conn_ping *receive_packet_conn_ping(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_conn_ping at the server.");
  }
  ensure_valid_variant_packet_conn_ping(pc);

  switch(pc->phs.variant[PACKET_CONN_PING]) {
  case 100:
    return receive_packet_conn_ping_100(pc, type);
  default:
    log_debug("Unknown PACKET_CONN_PING variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_conn_ping(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_conn_ping from the client.");
  }
  ensure_valid_variant_packet_conn_ping(pc);

  switch(pc->phs.variant[PACKET_CONN_PING]) {

  case 100:
    return send_packet_conn_ping_100(pc);
  default:
    log_debug("Unknown PACKET_CONN_PING variant for connection %s", conn_description(pc));
    return -1;
  }
}
static struct packet_conn_pong *receive_packet_conn_pong_100(struct connection *pc, enum packet_type type)
{
  RECEIVE_PACKET_START(packet_conn_pong, real_packet);

  log_packet_detailed("packet_conn_pong_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_conn_pong_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_CONN_PONG);

  log_packet_detailed("packet_conn_pong_100: sending info about ()");
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_conn_pong(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CONN_PONG] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CONN_PONG variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CONN_PONG] = variant;
}

struct packet_conn_pong *receive_packet_conn_pong(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_conn_pong at the client.");
  }
  ensure_valid_variant_packet_conn_pong(pc);

  switch(pc->phs.variant[PACKET_CONN_PONG]) {
  case 100:
    return receive_packet_conn_pong_100(pc, type);
  default:
    log_debug("Unknown PACKET_CONN_PONG variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_conn_pong(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_conn_pong from the server.");
  }
  ensure_valid_variant_packet_conn_pong(pc);

  switch(pc->phs.variant[PACKET_CONN_PONG]) {

  case 100:
    return send_packet_conn_pong_100(pc);
  default:
    log_debug("Unknown PACKET_CONN_PONG variant for connection %s", conn_description(pc));
    return -1;
  }
}
#define hash_packet_client_info_100 hash_const

#define cmp_packet_client_info_100 cmp_const

BV_DEFINE(packet_client_info_100_fields, 2);

static struct packet_client_info *receive_packet_client_info_100(struct connection *pc, enum packet_type type)
{
  packet_client_info_100_fields fields;
  struct packet_client_info *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_client_info, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_client_info_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_client_info_100, cmp_packet_client_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'gui'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->gui = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'distribution'");
    dio_get_string(&din, real_packet->distribution, sizeof(real_packet->distribution));
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_client_info_100(struct connection *pc, const struct packet_client_info *packet)
{
  const struct packet_client_info *real_packet = packet;
  packet_client_info_100_fields fields;
  struct packet_client_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CLIENT_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_CLIENT_INFO);

  log_packet_detailed("packet_client_info_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_client_info_100, cmp_packet_client_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->gui != real_packet->gui);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->distribution, real_packet->distribution) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'gui' has changed");
    dio_put_uint8(&dout, real_packet->gui);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'distribution' has changed");
    dio_put_string(&dout, real_packet->distribution);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_client_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CLIENT_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CLIENT_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CLIENT_INFO] = variant;
}

struct packet_client_info *receive_packet_client_info(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_client_info at the client.");
  }
  ensure_valid_variant_packet_client_info(pc);

  switch(pc->phs.variant[PACKET_CLIENT_INFO]) {
  case 100:
    return receive_packet_client_info_100(pc, type);
  default:
    log_debug("Unknown PACKET_CLIENT_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_client_info(struct connection *pc, const struct packet_client_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_client_info from the server.");
  }
  ensure_valid_variant_packet_client_info(pc);

  switch(pc->phs.variant[PACKET_CLIENT_INFO]) {

  case 100:
    return send_packet_client_info_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CLIENT_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
static struct packet_end_phase *receive_packet_end_phase_100(struct connection *pc, enum packet_type type)
{
  RECEIVE_PACKET_START(packet_end_phase, real_packet);

  log_packet_detailed("packet_end_phase_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_end_phase_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_END_PHASE);

  log_packet_detailed("packet_end_phase_100: sending info about ()");
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_end_phase(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_END_PHASE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_END_PHASE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_END_PHASE] = variant;
}

struct packet_end_phase *receive_packet_end_phase(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_end_phase at the server.");
  }
  ensure_valid_variant_packet_end_phase(pc);

  switch(pc->phs.variant[PACKET_END_PHASE]) {
  case 100:
    return receive_packet_end_phase_100(pc, type);
  default:
    log_debug("Unknown PACKET_END_PHASE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_end_phase(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_end_phase from the client.");
  }
  ensure_valid_variant_packet_end_phase(pc);

  switch(pc->phs.variant[PACKET_END_PHASE]) {

  case 100:
    return send_packet_end_phase_100(pc);
  default:
    log_debug("Unknown PACKET_END_PHASE variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_end_phase(struct conn_list *dest)
{
  conn_list_iterate(dest, pconn) {
    send_packet_end_phase(pconn);
  } conn_list_iterate_end;
}

#define hash_packet_start_phase_100 hash_const

#define cmp_packet_start_phase_100 cmp_const

BV_DEFINE(packet_start_phase_100_fields, 1);

static struct packet_start_phase *receive_packet_start_phase_100(struct connection *pc, enum packet_type type)
{
  packet_start_phase_100_fields fields;
  struct packet_start_phase *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_start_phase, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_start_phase_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_start_phase_100, cmp_packet_start_phase_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'phase'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->phase = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_start_phase_100(struct connection *pc, const struct packet_start_phase *packet)
{
  const struct packet_start_phase *real_packet = packet;
  packet_start_phase_100_fields fields;
  struct packet_start_phase *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_START_PHASE;
  int different = 0;
  SEND_PACKET_START(PACKET_START_PHASE);

  log_packet_detailed("packet_start_phase_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_start_phase_100, cmp_packet_start_phase_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->phase != real_packet->phase);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'phase' has changed");
    dio_put_sint16(&dout, real_packet->phase);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_start_phase(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_START_PHASE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_START_PHASE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_START_PHASE] = variant;
}

struct packet_start_phase *receive_packet_start_phase(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_start_phase at the server.");
  }
  ensure_valid_variant_packet_start_phase(pc);

  switch(pc->phs.variant[PACKET_START_PHASE]) {
  case 100:
    return receive_packet_start_phase_100(pc, type);
  default:
    log_debug("Unknown PACKET_START_PHASE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_start_phase(struct connection *pc, const struct packet_start_phase *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_start_phase from the client.");
  }
  ensure_valid_variant_packet_start_phase(pc);

  switch(pc->phs.variant[PACKET_START_PHASE]) {

  case 100:
    return send_packet_start_phase_100(pc, packet);
  default:
    log_debug("Unknown PACKET_START_PHASE variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_start_phase(struct conn_list *dest, const struct packet_start_phase *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_start_phase(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_start_phase(struct connection *pc, int phase)
{
  struct packet_start_phase packet, *real_packet = &packet;

  real_packet->phase = phase;
  
  return send_packet_start_phase(pc, real_packet);
}

void dlsend_packet_start_phase(struct conn_list *dest, int phase)
{
  struct packet_start_phase packet, *real_packet = &packet;

  real_packet->phase = phase;
  
  lsend_packet_start_phase(dest, real_packet);
}

#define hash_packet_new_year_100 hash_const

#define cmp_packet_new_year_100 cmp_const

BV_DEFINE(packet_new_year_100_fields, 2);

static struct packet_new_year *receive_packet_new_year_100(struct connection *pc, enum packet_type type)
{
  packet_new_year_100_fields fields;
  struct packet_new_year *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_new_year, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_new_year_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_new_year_100, cmp_packet_new_year_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'year'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->year = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'turn'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->turn = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_new_year_100(struct connection *pc, const struct packet_new_year *packet)
{
  const struct packet_new_year *real_packet = packet;
  packet_new_year_100_fields fields;
  struct packet_new_year *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_NEW_YEAR;
  int different = 0;
  SEND_PACKET_START(PACKET_NEW_YEAR);

  log_packet_detailed("packet_new_year_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_new_year_100, cmp_packet_new_year_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->year != real_packet->year);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->turn != real_packet->turn);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'year' has changed");
    dio_put_sint16(&dout, real_packet->year);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'turn' has changed");
    dio_put_sint16(&dout, real_packet->turn);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_new_year(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_NEW_YEAR] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_NEW_YEAR variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_NEW_YEAR] = variant;
}

struct packet_new_year *receive_packet_new_year(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_new_year at the server.");
  }
  ensure_valid_variant_packet_new_year(pc);

  switch(pc->phs.variant[PACKET_NEW_YEAR]) {
  case 100:
    return receive_packet_new_year_100(pc, type);
  default:
    log_debug("Unknown PACKET_NEW_YEAR variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_new_year(struct connection *pc, const struct packet_new_year *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_new_year from the client.");
  }
  ensure_valid_variant_packet_new_year(pc);

  switch(pc->phs.variant[PACKET_NEW_YEAR]) {

  case 100:
    return send_packet_new_year_100(pc, packet);
  default:
    log_debug("Unknown PACKET_NEW_YEAR variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_new_year(struct conn_list *dest, const struct packet_new_year *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_new_year(pconn, packet);
  } conn_list_iterate_end;
}

static struct packet_begin_turn *receive_packet_begin_turn_100(struct connection *pc, enum packet_type type)
{
  RECEIVE_PACKET_START(packet_begin_turn, real_packet);

  log_packet_detailed("packet_begin_turn_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_begin_turn_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_BEGIN_TURN);

  log_packet_detailed("packet_begin_turn_100: sending info about ()");
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_begin_turn(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_BEGIN_TURN] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_BEGIN_TURN variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_BEGIN_TURN] = variant;
}

struct packet_begin_turn *receive_packet_begin_turn(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_begin_turn at the server.");
  }
  ensure_valid_variant_packet_begin_turn(pc);

  switch(pc->phs.variant[PACKET_BEGIN_TURN]) {
  case 100:
    return receive_packet_begin_turn_100(pc, type);
  default:
    log_debug("Unknown PACKET_BEGIN_TURN variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_begin_turn(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_begin_turn from the client.");
  }
  ensure_valid_variant_packet_begin_turn(pc);

  switch(pc->phs.variant[PACKET_BEGIN_TURN]) {

  case 100:
    return send_packet_begin_turn_100(pc);
  default:
    log_debug("Unknown PACKET_BEGIN_TURN variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_begin_turn(struct conn_list *dest)
{
  conn_list_iterate(dest, pconn) {
    send_packet_begin_turn(pconn);
  } conn_list_iterate_end;
}

static struct packet_end_turn *receive_packet_end_turn_100(struct connection *pc, enum packet_type type)
{
  RECEIVE_PACKET_START(packet_end_turn, real_packet);

  log_packet_detailed("packet_end_turn_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_end_turn_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_END_TURN);

  log_packet_detailed("packet_end_turn_100: sending info about ()");
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_end_turn(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_END_TURN] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_END_TURN variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_END_TURN] = variant;
}

struct packet_end_turn *receive_packet_end_turn(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_end_turn at the server.");
  }
  ensure_valid_variant_packet_end_turn(pc);

  switch(pc->phs.variant[PACKET_END_TURN]) {
  case 100:
    return receive_packet_end_turn_100(pc, type);
  default:
    log_debug("Unknown PACKET_END_TURN variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_end_turn(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_end_turn from the client.");
  }
  ensure_valid_variant_packet_end_turn(pc);

  switch(pc->phs.variant[PACKET_END_TURN]) {

  case 100:
    return send_packet_end_turn_100(pc);
  default:
    log_debug("Unknown PACKET_END_TURN variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_end_turn(struct conn_list *dest)
{
  conn_list_iterate(dest, pconn) {
    send_packet_end_turn(pconn);
  } conn_list_iterate_end;
}

static struct packet_freeze_client *receive_packet_freeze_client_100(struct connection *pc, enum packet_type type)
{
  RECEIVE_PACKET_START(packet_freeze_client, real_packet);

  log_packet_detailed("packet_freeze_client_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_freeze_client_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_FREEZE_CLIENT);

  log_packet_detailed("packet_freeze_client_100: sending info about ()");
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_freeze_client(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_FREEZE_CLIENT] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_FREEZE_CLIENT variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_FREEZE_CLIENT] = variant;
}

struct packet_freeze_client *receive_packet_freeze_client(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_freeze_client at the server.");
  }
  ensure_valid_variant_packet_freeze_client(pc);

  switch(pc->phs.variant[PACKET_FREEZE_CLIENT]) {
  case 100:
    return receive_packet_freeze_client_100(pc, type);
  default:
    log_debug("Unknown PACKET_FREEZE_CLIENT variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_freeze_client(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_freeze_client from the client.");
  }
  ensure_valid_variant_packet_freeze_client(pc);

  switch(pc->phs.variant[PACKET_FREEZE_CLIENT]) {

  case 100:
    return send_packet_freeze_client_100(pc);
  default:
    log_debug("Unknown PACKET_FREEZE_CLIENT variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_freeze_client(struct conn_list *dest)
{
  conn_list_iterate(dest, pconn) {
    send_packet_freeze_client(pconn);
  } conn_list_iterate_end;
}

static struct packet_thaw_client *receive_packet_thaw_client_100(struct connection *pc, enum packet_type type)
{
  RECEIVE_PACKET_START(packet_thaw_client, real_packet);

  log_packet_detailed("packet_thaw_client_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_thaw_client_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_THAW_CLIENT);

  log_packet_detailed("packet_thaw_client_100: sending info about ()");
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_thaw_client(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_THAW_CLIENT] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_THAW_CLIENT variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_THAW_CLIENT] = variant;
}

struct packet_thaw_client *receive_packet_thaw_client(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_thaw_client at the server.");
  }
  ensure_valid_variant_packet_thaw_client(pc);

  switch(pc->phs.variant[PACKET_THAW_CLIENT]) {
  case 100:
    return receive_packet_thaw_client_100(pc, type);
  default:
    log_debug("Unknown PACKET_THAW_CLIENT variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_thaw_client(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_thaw_client from the client.");
  }
  ensure_valid_variant_packet_thaw_client(pc);

  switch(pc->phs.variant[PACKET_THAW_CLIENT]) {

  case 100:
    return send_packet_thaw_client_100(pc);
  default:
    log_debug("Unknown PACKET_THAW_CLIENT variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_thaw_client(struct conn_list *dest)
{
  conn_list_iterate(dest, pconn) {
    send_packet_thaw_client(pconn);
  } conn_list_iterate_end;
}

static struct packet_spaceship_launch *receive_packet_spaceship_launch_100(struct connection *pc, enum packet_type type)
{
  RECEIVE_PACKET_START(packet_spaceship_launch, real_packet);

  log_packet_detailed("packet_spaceship_launch_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_spaceship_launch_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_SPACESHIP_LAUNCH);

  log_packet_detailed("packet_spaceship_launch_100: sending info about ()");
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_spaceship_launch(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_SPACESHIP_LAUNCH] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_SPACESHIP_LAUNCH variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_SPACESHIP_LAUNCH] = variant;
}

struct packet_spaceship_launch *receive_packet_spaceship_launch(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_spaceship_launch at the client.");
  }
  ensure_valid_variant_packet_spaceship_launch(pc);

  switch(pc->phs.variant[PACKET_SPACESHIP_LAUNCH]) {
  case 100:
    return receive_packet_spaceship_launch_100(pc, type);
  default:
    log_debug("Unknown PACKET_SPACESHIP_LAUNCH variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_spaceship_launch(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_spaceship_launch from the server.");
  }
  ensure_valid_variant_packet_spaceship_launch(pc);

  switch(pc->phs.variant[PACKET_SPACESHIP_LAUNCH]) {

  case 100:
    return send_packet_spaceship_launch_100(pc);
  default:
    log_debug("Unknown PACKET_SPACESHIP_LAUNCH variant for connection %s", conn_description(pc));
    return -1;
  }
}
#define hash_packet_spaceship_place_100 hash_const

#define cmp_packet_spaceship_place_100 cmp_const

BV_DEFINE(packet_spaceship_place_100_fields, 2);

static struct packet_spaceship_place *receive_packet_spaceship_place_100(struct connection *pc, enum packet_type type)
{
  packet_spaceship_place_100_fields fields;
  struct packet_spaceship_place *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_spaceship_place, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_spaceship_place_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_spaceship_place_100, cmp_packet_spaceship_place_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'num'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->num = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_spaceship_place_100(struct connection *pc, const struct packet_spaceship_place *packet)
{
  const struct packet_spaceship_place *real_packet = packet;
  packet_spaceship_place_100_fields fields;
  struct packet_spaceship_place *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SPACESHIP_PLACE;
  int different = 0;
  SEND_PACKET_START(PACKET_SPACESHIP_PLACE);

  log_packet_detailed("packet_spaceship_place_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_spaceship_place_100, cmp_packet_spaceship_place_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->num != real_packet->num);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'type' has changed");
    dio_put_uint8(&dout, real_packet->type);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'num' has changed");
    dio_put_uint8(&dout, real_packet->num);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_spaceship_place(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_SPACESHIP_PLACE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_SPACESHIP_PLACE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_SPACESHIP_PLACE] = variant;
}

struct packet_spaceship_place *receive_packet_spaceship_place(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_spaceship_place at the client.");
  }
  ensure_valid_variant_packet_spaceship_place(pc);

  switch(pc->phs.variant[PACKET_SPACESHIP_PLACE]) {
  case 100:
    return receive_packet_spaceship_place_100(pc, type);
  default:
    log_debug("Unknown PACKET_SPACESHIP_PLACE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_spaceship_place(struct connection *pc, const struct packet_spaceship_place *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_spaceship_place from the server.");
  }
  ensure_valid_variant_packet_spaceship_place(pc);

  switch(pc->phs.variant[PACKET_SPACESHIP_PLACE]) {

  case 100:
    return send_packet_spaceship_place_100(pc, packet);
  default:
    log_debug("Unknown PACKET_SPACESHIP_PLACE variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_spaceship_place(struct connection *pc, enum spaceship_place_type type, int num)
{
  struct packet_spaceship_place packet, *real_packet = &packet;

  real_packet->type = type;
  real_packet->num = num;
  
  return send_packet_spaceship_place(pc, real_packet);
}

static genhash_val_t hash_packet_spaceship_info_100(const void *vkey, size_t num_buckets)
{
  const struct packet_spaceship_info *key = (const struct packet_spaceship_info *) vkey;

  return ((key->player_num) % num_buckets);
}

static bool cmp_packet_spaceship_info_100(const void *vkey1, const void *vkey2)
{
  const struct packet_spaceship_info *key1 = (const struct packet_spaceship_info *) vkey1;
  const struct packet_spaceship_info *key2 = (const struct packet_spaceship_info *) vkey2;

  return key1->player_num == key2->player_num;
}

BV_DEFINE(packet_spaceship_info_100_fields, 17);

static struct packet_spaceship_info *receive_packet_spaceship_info_100(struct connection *pc, enum packet_type type)
{
  packet_spaceship_info_100_fields fields;
  struct packet_spaceship_info *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_spaceship_info, real_packet);

  DIO_BV_GET(&din, fields);
  {
    int readin;
  
    dio_get_sint8(&din, &readin);
    real_packet->player_num = readin;
  }

  log_packet_detailed("packet_spaceship_info_100: got info about (%d)",
    real_packet->player_num);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_spaceship_info_100, cmp_packet_spaceship_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int player_num = real_packet->player_num;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->player_num = player_num;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'sship_state'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->sship_state = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'structurals'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->structurals = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'components'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->components = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'modules'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->modules = readin;
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'fuel'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->fuel = readin;
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'propulsion'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->propulsion = readin;
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'habitation'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->habitation = readin;
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'life_support'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->life_support = readin;
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'solar_panels'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->solar_panels = readin;
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'launch_year'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->launch_year = readin;
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'population'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->population = readin;
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'mass'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->mass = readin;
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'structure'");
    dio_get_bit_string(&din, real_packet->structure, sizeof(real_packet->structure));
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'support_rate'");
    {
      int tmp;
      
      dio_get_uint32(&din, &tmp);
      real_packet->support_rate = (float)(tmp) / 10000.0;
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'energy_rate'");
    {
      int tmp;
      
      dio_get_uint32(&din, &tmp);
      real_packet->energy_rate = (float)(tmp) / 10000.0;
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'success_rate'");
    {
      int tmp;
      
      dio_get_uint32(&din, &tmp);
      real_packet->success_rate = (float)(tmp) / 10000.0;
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'travel_time'");
    {
      int tmp;
      
      dio_get_uint32(&din, &tmp);
      real_packet->travel_time = (float)(tmp) / 10000.0;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_spaceship_info_100(struct connection *pc, const struct packet_spaceship_info *packet)
{
  const struct packet_spaceship_info *real_packet = packet;
  packet_spaceship_info_100_fields fields;
  struct packet_spaceship_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SPACESHIP_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_SPACESHIP_INFO);

  log_packet_detailed("packet_spaceship_info_100: sending info about (%d)",
    real_packet->player_num);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_spaceship_info_100, cmp_packet_spaceship_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->sship_state != real_packet->sship_state);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->structurals != real_packet->structurals);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->components != real_packet->components);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->modules != real_packet->modules);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->fuel != real_packet->fuel);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->propulsion != real_packet->propulsion);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->habitation != real_packet->habitation);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (old->life_support != real_packet->life_support);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->solar_panels != real_packet->solar_panels);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->launch_year != real_packet->launch_year);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->population != real_packet->population);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->mass != real_packet->mass);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = (strcmp(old->structure, real_packet->structure) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = (old->support_rate != real_packet->support_rate);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->energy_rate != real_packet->energy_rate);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->success_rate != real_packet->success_rate);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (old->travel_time != real_packet->travel_time);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }


  DIO_BV_PUT(&dout, fields);
  dio_put_sint8(&dout, real_packet->player_num);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'sship_state' has changed");
    dio_put_uint8(&dout, real_packet->sship_state);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'structurals' has changed");
    dio_put_uint8(&dout, real_packet->structurals);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'components' has changed");
    dio_put_uint8(&dout, real_packet->components);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'modules' has changed");
    dio_put_uint8(&dout, real_packet->modules);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'fuel' has changed");
    dio_put_uint8(&dout, real_packet->fuel);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'propulsion' has changed");
    dio_put_uint8(&dout, real_packet->propulsion);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'habitation' has changed");
    dio_put_uint8(&dout, real_packet->habitation);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'life_support' has changed");
    dio_put_uint8(&dout, real_packet->life_support);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'solar_panels' has changed");
    dio_put_uint8(&dout, real_packet->solar_panels);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'launch_year' has changed");
    dio_put_sint16(&dout, real_packet->launch_year);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'population' has changed");
    dio_put_uint32(&dout, real_packet->population);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'mass' has changed");
    dio_put_uint32(&dout, real_packet->mass);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'structure' has changed");
    dio_put_bit_string(&dout, real_packet->structure);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'support_rate' has changed");
    dio_put_uint32(&dout, (int)(real_packet->support_rate * 10000));
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'energy_rate' has changed");
    dio_put_uint32(&dout, (int)(real_packet->energy_rate * 10000));
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'success_rate' has changed");
    dio_put_uint32(&dout, (int)(real_packet->success_rate * 10000));
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'travel_time' has changed");
    dio_put_uint32(&dout, (int)(real_packet->travel_time * 10000));
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_spaceship_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_SPACESHIP_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_SPACESHIP_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_SPACESHIP_INFO] = variant;
}

struct packet_spaceship_info *receive_packet_spaceship_info(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_spaceship_info at the server.");
  }
  ensure_valid_variant_packet_spaceship_info(pc);

  switch(pc->phs.variant[PACKET_SPACESHIP_INFO]) {
  case 100:
    return receive_packet_spaceship_info_100(pc, type);
  default:
    log_debug("Unknown PACKET_SPACESHIP_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_spaceship_info(struct connection *pc, const struct packet_spaceship_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_spaceship_info from the client.");
  }
  ensure_valid_variant_packet_spaceship_info(pc);

  switch(pc->phs.variant[PACKET_SPACESHIP_INFO]) {

  case 100:
    return send_packet_spaceship_info_100(pc, packet);
  default:
    log_debug("Unknown PACKET_SPACESHIP_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_spaceship_info(struct conn_list *dest, const struct packet_spaceship_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_spaceship_info(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_unit_100 hash_const

#define cmp_packet_ruleset_unit_100 cmp_const

BV_DEFINE(packet_ruleset_unit_100_fields, 41);

static struct packet_ruleset_unit *receive_packet_ruleset_unit_100(struct connection *pc, enum packet_type type)
{
  packet_ruleset_unit_100_fields fields;
  struct packet_ruleset_unit *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_ruleset_unit, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_unit_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_unit_100, cmp_packet_ruleset_unit_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    dio_get_string(&din, real_packet->name, sizeof(real_packet->name));
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'rule_name'");
    dio_get_string(&din, real_packet->rule_name, sizeof(real_packet->rule_name));
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'graphic_str'");
    dio_get_string(&din, real_packet->graphic_str, sizeof(real_packet->graphic_str));
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'graphic_alt'");
    dio_get_string(&din, real_packet->graphic_alt, sizeof(real_packet->graphic_alt));
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'sound_move'");
    dio_get_string(&din, real_packet->sound_move, sizeof(real_packet->sound_move));
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'sound_move_alt'");
    dio_get_string(&din, real_packet->sound_move_alt, sizeof(real_packet->sound_move_alt));
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'sound_fight'");
    dio_get_string(&din, real_packet->sound_fight, sizeof(real_packet->sound_fight));
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'sound_fight_alt'");
    dio_get_string(&din, real_packet->sound_fight_alt, sizeof(real_packet->sound_fight_alt));
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'unit_class_id'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->unit_class_id = readin;
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'build_cost'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->build_cost = readin;
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'pop_cost'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->pop_cost = readin;
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'attack_strength'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->attack_strength = readin;
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'defense_strength'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->defense_strength = readin;
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'move_rate'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->move_rate = readin;
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'tech_requirement'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->tech_requirement = readin;
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'impr_requirement'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->impr_requirement = readin;
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'gov_requirement'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->gov_requirement = readin;
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'vision_radius_sq'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->vision_radius_sq = readin;
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'transport_capacity'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->transport_capacity = readin;
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'hp'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->hp = readin;
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  got field 'firepower'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->firepower = readin;
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'obsoleted_by'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->obsoleted_by = readin;
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'converted_to'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->converted_to = readin;
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'fuel'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->fuel = readin;
    }
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  got field 'happy_cost'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->happy_cost = readin;
    }
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  got field 'upkeep'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->upkeep[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  got field 'paratroopers_range'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->paratroopers_range = readin;
    }
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  got field 'paratroopers_mr_req'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->paratroopers_mr_req = readin;
    }
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  got field 'paratroopers_mr_sub'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->paratroopers_mr_sub = readin;
    }
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  got field 'veteran_levels'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->veteran_levels = readin;
    }
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  got field 'veteran_name'");
    
    {
      int i;
    
      if(real_packet->veteran_levels > MAX_VET_LEVELS) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->veteran_levels = MAX_VET_LEVELS;
      }
      for (i = 0; i < real_packet->veteran_levels; i++) {
        dio_get_string(&din, real_packet->veteran_name[i], sizeof(real_packet->veteran_name[i]));
      }
    }
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  got field 'power_fact'");
    
    {
      int i;
    
      if(real_packet->veteran_levels > MAX_VET_LEVELS) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->veteran_levels = MAX_VET_LEVELS;
      }
      for (i = 0; i < real_packet->veteran_levels; i++) {
        {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->power_fact[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  got field 'move_bonus'");
    
    {
      int i;
    
      if(real_packet->veteran_levels > MAX_VET_LEVELS) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->veteran_levels = MAX_VET_LEVELS;
      }
      for (i = 0; i < real_packet->veteran_levels; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->move_bonus[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  got field 'bombard_rate'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->bombard_rate = readin;
    }
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  got field 'city_size'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->city_size = readin;
    }
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  got field 'cargo'");
    DIO_BV_GET(&din, real_packet->cargo);
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  got field 'targets'");
    DIO_BV_GET(&din, real_packet->targets);
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  got field 'helptext'");
    dio_get_string(&din, real_packet->helptext, sizeof(real_packet->helptext));
  }
  if (BV_ISSET(fields, 39)) {
    log_packet_detailed("  got field 'flags'");
    DIO_BV_GET(&din, real_packet->flags);
  }
  if (BV_ISSET(fields, 40)) {
    log_packet_detailed("  got field 'roles'");
    DIO_BV_GET(&din, real_packet->roles);
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_unit_100(struct connection *pc, const struct packet_ruleset_unit *packet)
{
  const struct packet_ruleset_unit *real_packet = packet;
  packet_ruleset_unit_100_fields fields;
  struct packet_ruleset_unit *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_UNIT;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_UNIT);

  log_packet_detailed("packet_ruleset_unit_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_unit_100, cmp_packet_ruleset_unit_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (strcmp(old->graphic_str, real_packet->graphic_str) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (strcmp(old->graphic_alt, real_packet->graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (strcmp(old->sound_move, real_packet->sound_move) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (strcmp(old->sound_move_alt, real_packet->sound_move_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (strcmp(old->sound_fight, real_packet->sound_fight) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (strcmp(old->sound_fight_alt, real_packet->sound_fight_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->unit_class_id != real_packet->unit_class_id);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->build_cost != real_packet->build_cost);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->pop_cost != real_packet->pop_cost);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = (old->attack_strength != real_packet->attack_strength);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = (old->defense_strength != real_packet->defense_strength);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->move_rate != real_packet->move_rate);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->tech_requirement != real_packet->tech_requirement);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (old->impr_requirement != real_packet->impr_requirement);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }

  differ = (old->gov_requirement != real_packet->gov_requirement);
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }

  differ = (old->vision_radius_sq != real_packet->vision_radius_sq);
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }

  differ = (old->transport_capacity != real_packet->transport_capacity);
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }

  differ = (old->hp != real_packet->hp);
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }

  differ = (old->firepower != real_packet->firepower);
  if (differ) {
    different++;
    BV_SET(fields, 21);
  }

  differ = (old->obsoleted_by != real_packet->obsoleted_by);
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (old->converted_to != real_packet->converted_to);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }

  differ = (old->fuel != real_packet->fuel);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }

  differ = (old->happy_cost != real_packet->happy_cost);
  if (differ) {
    different++;
    BV_SET(fields, 25);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->upkeep[i] != real_packet->upkeep[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 26);
  }

  differ = (old->paratroopers_range != real_packet->paratroopers_range);
  if (differ) {
    different++;
    BV_SET(fields, 27);
  }

  differ = (old->paratroopers_mr_req != real_packet->paratroopers_mr_req);
  if (differ) {
    different++;
    BV_SET(fields, 28);
  }

  differ = (old->paratroopers_mr_sub != real_packet->paratroopers_mr_sub);
  if (differ) {
    different++;
    BV_SET(fields, 29);
  }

  differ = (old->veteran_levels != real_packet->veteran_levels);
  if (differ) {
    different++;
    BV_SET(fields, 30);
  }


    {
      differ = (old->veteran_levels != real_packet->veteran_levels);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->veteran_levels; i++) {
          if (strcmp(old->veteran_name[i], real_packet->veteran_name[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 31);
  }


    {
      differ = (old->veteran_levels != real_packet->veteran_levels);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->veteran_levels; i++) {
          if (old->power_fact[i] != real_packet->power_fact[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 32);
  }


    {
      differ = (old->veteran_levels != real_packet->veteran_levels);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->veteran_levels; i++) {
          if (old->move_bonus[i] != real_packet->move_bonus[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 33);
  }

  differ = (old->bombard_rate != real_packet->bombard_rate);
  if (differ) {
    different++;
    BV_SET(fields, 34);
  }

  differ = (old->city_size != real_packet->city_size);
  if (differ) {
    different++;
    BV_SET(fields, 35);
  }

  differ = !BV_ARE_EQUAL(old->cargo, real_packet->cargo);
  if (differ) {
    different++;
    BV_SET(fields, 36);
  }

  differ = !BV_ARE_EQUAL(old->targets, real_packet->targets);
  if (differ) {
    different++;
    BV_SET(fields, 37);
  }

  differ = (strcmp(old->helptext, real_packet->helptext) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 38);
  }

  differ = !BV_ARE_EQUAL(old->flags, real_packet->flags);
  if (differ) {
    different++;
    BV_SET(fields, 39);
  }

  differ = !BV_ARE_EQUAL(old->roles, real_packet->roles);
  if (differ) {
    different++;
    BV_SET(fields, 40);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    dio_put_uint8(&dout, real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'rule_name' has changed");
    dio_put_string(&dout, real_packet->rule_name);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'graphic_str' has changed");
    dio_put_string(&dout, real_packet->graphic_str);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'graphic_alt' has changed");
    dio_put_string(&dout, real_packet->graphic_alt);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'sound_move' has changed");
    dio_put_string(&dout, real_packet->sound_move);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'sound_move_alt' has changed");
    dio_put_string(&dout, real_packet->sound_move_alt);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'sound_fight' has changed");
    dio_put_string(&dout, real_packet->sound_fight);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'sound_fight_alt' has changed");
    dio_put_string(&dout, real_packet->sound_fight_alt);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'unit_class_id' has changed");
    dio_put_uint8(&dout, real_packet->unit_class_id);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'build_cost' has changed");
    dio_put_uint16(&dout, real_packet->build_cost);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'pop_cost' has changed");
    dio_put_uint8(&dout, real_packet->pop_cost);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'attack_strength' has changed");
    dio_put_uint8(&dout, real_packet->attack_strength);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'defense_strength' has changed");
    dio_put_uint8(&dout, real_packet->defense_strength);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'move_rate' has changed");
    dio_put_uint8(&dout, real_packet->move_rate);
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'tech_requirement' has changed");
    dio_put_uint8(&dout, real_packet->tech_requirement);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'impr_requirement' has changed");
    dio_put_uint8(&dout, real_packet->impr_requirement);
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'gov_requirement' has changed");
    dio_put_uint8(&dout, real_packet->gov_requirement);
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'vision_radius_sq' has changed");
    dio_put_uint16(&dout, real_packet->vision_radius_sq);
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'transport_capacity' has changed");
    dio_put_uint8(&dout, real_packet->transport_capacity);
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'hp' has changed");
    dio_put_uint8(&dout, real_packet->hp);
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  field 'firepower' has changed");
    dio_put_uint8(&dout, real_packet->firepower);
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'obsoleted_by' has changed");
    dio_put_sint8(&dout, real_packet->obsoleted_by);
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'converted_to' has changed");
    dio_put_sint8(&dout, real_packet->converted_to);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'fuel' has changed");
    dio_put_uint8(&dout, real_packet->fuel);
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  field 'happy_cost' has changed");
    dio_put_uint8(&dout, real_packet->happy_cost);
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  field 'upkeep' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint8(&dout, real_packet->upkeep[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  field 'paratroopers_range' has changed");
    dio_put_uint8(&dout, real_packet->paratroopers_range);
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  field 'paratroopers_mr_req' has changed");
    dio_put_uint8(&dout, real_packet->paratroopers_mr_req);
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  field 'paratroopers_mr_sub' has changed");
    dio_put_uint8(&dout, real_packet->paratroopers_mr_sub);
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  field 'veteran_levels' has changed");
    dio_put_uint8(&dout, real_packet->veteran_levels);
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  field 'veteran_name' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->veteran_levels; i++) {
        dio_put_string(&dout, real_packet->veteran_name[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  field 'power_fact' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->veteran_levels; i++) {
        dio_put_uint16(&dout, real_packet->power_fact[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  field 'move_bonus' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->veteran_levels; i++) {
        dio_put_uint8(&dout, real_packet->move_bonus[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  field 'bombard_rate' has changed");
    dio_put_uint8(&dout, real_packet->bombard_rate);
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  field 'city_size' has changed");
    dio_put_uint8(&dout, real_packet->city_size);
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  field 'cargo' has changed");
  DIO_BV_PUT(&dout, packet->cargo);
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  field 'targets' has changed");
  DIO_BV_PUT(&dout, packet->targets);
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  field 'helptext' has changed");
    dio_put_string(&dout, real_packet->helptext);
  }
  if (BV_ISSET(fields, 39)) {
    log_packet_detailed("  field 'flags' has changed");
  DIO_BV_PUT(&dout, packet->flags);
  }
  if (BV_ISSET(fields, 40)) {
    log_packet_detailed("  field 'roles' has changed");
  DIO_BV_PUT(&dout, packet->roles);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_ruleset_unit(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_UNIT] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_UNIT variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_UNIT] = variant;
}

struct packet_ruleset_unit *receive_packet_ruleset_unit(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_ruleset_unit at the server.");
  }
  ensure_valid_variant_packet_ruleset_unit(pc);

  switch(pc->phs.variant[PACKET_RULESET_UNIT]) {
  case 100:
    return receive_packet_ruleset_unit_100(pc, type);
  default:
    log_debug("Unknown PACKET_RULESET_UNIT variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_unit(struct connection *pc, const struct packet_ruleset_unit *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_unit from the client.");
  }
  ensure_valid_variant_packet_ruleset_unit(pc);

  switch(pc->phs.variant[PACKET_RULESET_UNIT]) {

  case 100:
    return send_packet_ruleset_unit_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_UNIT variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_unit(struct conn_list *dest, const struct packet_ruleset_unit *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_unit(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_game_100 hash_const

#define cmp_packet_ruleset_game_100 cmp_const

BV_DEFINE(packet_ruleset_game_100_fields, 10);

static struct packet_ruleset_game *receive_packet_ruleset_game_100(struct connection *pc, enum packet_type type)
{
  packet_ruleset_game_100_fields fields;
  struct packet_ruleset_game *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_ruleset_game, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_game_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_game_100, cmp_packet_ruleset_game_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'default_specialist'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->default_specialist = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'global_init_techs'");
    dio_get_tech_list(&din, real_packet->global_init_techs);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'global_init_buildings'");
    dio_get_building_list(&din, real_packet->global_init_buildings);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'veteran_levels'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->veteran_levels = readin;
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'veteran_name'");
    
    {
      int i;
    
      if(real_packet->veteran_levels > MAX_VET_LEVELS) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->veteran_levels = MAX_VET_LEVELS;
      }
      for (i = 0; i < real_packet->veteran_levels; i++) {
        dio_get_string(&din, real_packet->veteran_name[i], sizeof(real_packet->veteran_name[i]));
      }
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'power_fact'");
    
    {
      int i;
    
      if(real_packet->veteran_levels > MAX_VET_LEVELS) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->veteran_levels = MAX_VET_LEVELS;
      }
      for (i = 0; i < real_packet->veteran_levels; i++) {
        {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->power_fact[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'move_bonus'");
    
    {
      int i;
    
      if(real_packet->veteran_levels > MAX_VET_LEVELS) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->veteran_levels = MAX_VET_LEVELS;
      }
      for (i = 0; i < real_packet->veteran_levels; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->move_bonus[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'background_red'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->background_red = readin;
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'background_green'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->background_green = readin;
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'background_blue'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->background_blue = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_game_100(struct connection *pc, const struct packet_ruleset_game *packet)
{
  const struct packet_ruleset_game *real_packet = packet;
  packet_ruleset_game_100_fields fields;
  struct packet_ruleset_game *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_GAME;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_GAME);

  log_packet_detailed("packet_ruleset_game_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_game_100, cmp_packet_ruleset_game_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->default_specialist != real_packet->default_specialist);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


    {
      differ = (MAX_NUM_TECH_LIST != MAX_NUM_TECH_LIST);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_NUM_TECH_LIST; i++) {
          if (old->global_init_techs[i] != real_packet->global_init_techs[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


    {
      differ = (MAX_NUM_BUILDING_LIST != MAX_NUM_BUILDING_LIST);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_NUM_BUILDING_LIST; i++) {
          if (old->global_init_buildings[i] != real_packet->global_init_buildings[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->veteran_levels != real_packet->veteran_levels);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


    {
      differ = (old->veteran_levels != real_packet->veteran_levels);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->veteran_levels; i++) {
          if (strcmp(old->veteran_name[i], real_packet->veteran_name[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }


    {
      differ = (old->veteran_levels != real_packet->veteran_levels);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->veteran_levels; i++) {
          if (old->power_fact[i] != real_packet->power_fact[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


    {
      differ = (old->veteran_levels != real_packet->veteran_levels);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->veteran_levels; i++) {
          if (old->move_bonus[i] != real_packet->move_bonus[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (old->background_red != real_packet->background_red);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->background_green != real_packet->background_green);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->background_blue != real_packet->background_blue);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'default_specialist' has changed");
    dio_put_uint8(&dout, real_packet->default_specialist);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'global_init_techs' has changed");
    dio_put_tech_list(&dout, real_packet->global_init_techs);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'global_init_buildings' has changed");
    dio_put_building_list(&dout, real_packet->global_init_buildings);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'veteran_levels' has changed");
    dio_put_uint8(&dout, real_packet->veteran_levels);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'veteran_name' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->veteran_levels; i++) {
        dio_put_string(&dout, real_packet->veteran_name[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'power_fact' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->veteran_levels; i++) {
        dio_put_uint16(&dout, real_packet->power_fact[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'move_bonus' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->veteran_levels; i++) {
        dio_put_uint8(&dout, real_packet->move_bonus[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'background_red' has changed");
    dio_put_uint8(&dout, real_packet->background_red);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'background_green' has changed");
    dio_put_uint8(&dout, real_packet->background_green);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'background_blue' has changed");
    dio_put_uint8(&dout, real_packet->background_blue);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_ruleset_game(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_GAME] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_GAME variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_GAME] = variant;
}

struct packet_ruleset_game *receive_packet_ruleset_game(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_ruleset_game at the server.");
  }
  ensure_valid_variant_packet_ruleset_game(pc);

  switch(pc->phs.variant[PACKET_RULESET_GAME]) {
  case 100:
    return receive_packet_ruleset_game_100(pc, type);
  default:
    log_debug("Unknown PACKET_RULESET_GAME variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_game(struct connection *pc, const struct packet_ruleset_game *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_game from the client.");
  }
  ensure_valid_variant_packet_ruleset_game(pc);

  switch(pc->phs.variant[PACKET_RULESET_GAME]) {

  case 100:
    return send_packet_ruleset_game_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_GAME variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_game(struct conn_list *dest, const struct packet_ruleset_game *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_game(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_specialist_100 hash_const

#define cmp_packet_ruleset_specialist_100 cmp_const

BV_DEFINE(packet_ruleset_specialist_100_fields, 7);

static struct packet_ruleset_specialist *receive_packet_ruleset_specialist_100(struct connection *pc, enum packet_type type)
{
  packet_ruleset_specialist_100_fields fields;
  struct packet_ruleset_specialist *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_ruleset_specialist, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_specialist_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_specialist_100, cmp_packet_ruleset_specialist_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'plural_name'");
    dio_get_string(&din, real_packet->plural_name, sizeof(real_packet->plural_name));
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'rule_name'");
    dio_get_string(&din, real_packet->rule_name, sizeof(real_packet->rule_name));
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'short_name'");
    dio_get_string(&din, real_packet->short_name, sizeof(real_packet->short_name));
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'reqs_count'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->reqs_count = readin;
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'reqs'");
    
    {
      int i;
    
      if(real_packet->reqs_count > MAX_NUM_REQS) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->reqs_count = MAX_NUM_REQS;
      }
      for (i = 0; i < real_packet->reqs_count; i++) {
        dio_get_requirement(&din, &real_packet->reqs[i]);
      }
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'helptext'");
    dio_get_string(&din, real_packet->helptext, sizeof(real_packet->helptext));
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_specialist_100(struct connection *pc, const struct packet_ruleset_specialist *packet)
{
  const struct packet_ruleset_specialist *real_packet = packet;
  packet_ruleset_specialist_100_fields fields;
  struct packet_ruleset_specialist *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_SPECIALIST;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_SPECIALIST);

  log_packet_detailed("packet_ruleset_specialist_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_specialist_100, cmp_packet_ruleset_specialist_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->plural_name, real_packet->plural_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (strcmp(old->short_name, real_packet->short_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->reqs_count != real_packet->reqs_count);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }


    {
      differ = (old->reqs_count != real_packet->reqs_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->reqs_count; i++) {
          if (!are_requirements_equal(&old->reqs[i], &real_packet->reqs[i])) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (strcmp(old->helptext, real_packet->helptext) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    dio_put_uint8(&dout, real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'plural_name' has changed");
    dio_put_string(&dout, real_packet->plural_name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'rule_name' has changed");
    dio_put_string(&dout, real_packet->rule_name);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'short_name' has changed");
    dio_put_string(&dout, real_packet->short_name);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'reqs_count' has changed");
    dio_put_uint8(&dout, real_packet->reqs_count);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'reqs' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->reqs_count; i++) {
        dio_put_requirement(&dout, &real_packet->reqs[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'helptext' has changed");
    dio_put_string(&dout, real_packet->helptext);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_ruleset_specialist(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_SPECIALIST] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_SPECIALIST variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_SPECIALIST] = variant;
}

struct packet_ruleset_specialist *receive_packet_ruleset_specialist(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_ruleset_specialist at the server.");
  }
  ensure_valid_variant_packet_ruleset_specialist(pc);

  switch(pc->phs.variant[PACKET_RULESET_SPECIALIST]) {
  case 100:
    return receive_packet_ruleset_specialist_100(pc, type);
  default:
    log_debug("Unknown PACKET_RULESET_SPECIALIST variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_specialist(struct connection *pc, const struct packet_ruleset_specialist *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_specialist from the client.");
  }
  ensure_valid_variant_packet_ruleset_specialist(pc);

  switch(pc->phs.variant[PACKET_RULESET_SPECIALIST]) {

  case 100:
    return send_packet_ruleset_specialist_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_SPECIALIST variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_specialist(struct conn_list *dest, const struct packet_ruleset_specialist *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_specialist(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_government_ruler_title_100 hash_const

#define cmp_packet_ruleset_government_ruler_title_100 cmp_const

BV_DEFINE(packet_ruleset_government_ruler_title_100_fields, 4);

static struct packet_ruleset_government_ruler_title *receive_packet_ruleset_government_ruler_title_100(struct connection *pc, enum packet_type type)
{
  packet_ruleset_government_ruler_title_100_fields fields;
  struct packet_ruleset_government_ruler_title *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_ruleset_government_ruler_title, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_government_ruler_title_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_government_ruler_title_100, cmp_packet_ruleset_government_ruler_title_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'gov'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->gov = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'nation'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->nation = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'male_title'");
    dio_get_string(&din, real_packet->male_title, sizeof(real_packet->male_title));
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'female_title'");
    dio_get_string(&din, real_packet->female_title, sizeof(real_packet->female_title));
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_government_ruler_title_100(struct connection *pc, const struct packet_ruleset_government_ruler_title *packet)
{
  const struct packet_ruleset_government_ruler_title *real_packet = packet;
  packet_ruleset_government_ruler_title_100_fields fields;
  struct packet_ruleset_government_ruler_title *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_GOVERNMENT_RULER_TITLE;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_GOVERNMENT_RULER_TITLE);

  log_packet_detailed("packet_ruleset_government_ruler_title_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_government_ruler_title_100, cmp_packet_ruleset_government_ruler_title_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->gov != real_packet->gov);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->nation != real_packet->nation);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->male_title, real_packet->male_title) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (strcmp(old->female_title, real_packet->female_title) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'gov' has changed");
    dio_put_uint8(&dout, real_packet->gov);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'nation' has changed");
    dio_put_sint16(&dout, real_packet->nation);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'male_title' has changed");
    dio_put_string(&dout, real_packet->male_title);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'female_title' has changed");
    dio_put_string(&dout, real_packet->female_title);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_ruleset_government_ruler_title(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_GOVERNMENT_RULER_TITLE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_GOVERNMENT_RULER_TITLE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_GOVERNMENT_RULER_TITLE] = variant;
}

struct packet_ruleset_government_ruler_title *receive_packet_ruleset_government_ruler_title(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_ruleset_government_ruler_title at the server.");
  }
  ensure_valid_variant_packet_ruleset_government_ruler_title(pc);

  switch(pc->phs.variant[PACKET_RULESET_GOVERNMENT_RULER_TITLE]) {
  case 100:
    return receive_packet_ruleset_government_ruler_title_100(pc, type);
  default:
    log_debug("Unknown PACKET_RULESET_GOVERNMENT_RULER_TITLE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_government_ruler_title(struct connection *pc, const struct packet_ruleset_government_ruler_title *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_government_ruler_title from the client.");
  }
  ensure_valid_variant_packet_ruleset_government_ruler_title(pc);

  switch(pc->phs.variant[PACKET_RULESET_GOVERNMENT_RULER_TITLE]) {

  case 100:
    return send_packet_ruleset_government_ruler_title_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_GOVERNMENT_RULER_TITLE variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_government_ruler_title(struct conn_list *dest, const struct packet_ruleset_government_ruler_title *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_government_ruler_title(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_tech_100 hash_const

#define cmp_packet_ruleset_tech_100 cmp_const

BV_DEFINE(packet_ruleset_tech_100_fields, 11);

static struct packet_ruleset_tech *receive_packet_ruleset_tech_100(struct connection *pc, enum packet_type type)
{
  packet_ruleset_tech_100_fields fields;
  struct packet_ruleset_tech *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_ruleset_tech, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_tech_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_tech_100, cmp_packet_ruleset_tech_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'req'");
    
    {
      int i;
    
      for (i = 0; i < 2; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->req[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'root_req'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->root_req = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'flags'");
    DIO_BV_GET(&din, real_packet->flags);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'preset_cost'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->preset_cost = readin;
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'num_reqs'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->num_reqs = readin;
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'name'");
    dio_get_string(&din, real_packet->name, sizeof(real_packet->name));
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'rule_name'");
    dio_get_string(&din, real_packet->rule_name, sizeof(real_packet->rule_name));
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'helptext'");
    dio_get_string(&din, real_packet->helptext, sizeof(real_packet->helptext));
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'graphic_str'");
    dio_get_string(&din, real_packet->graphic_str, sizeof(real_packet->graphic_str));
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'graphic_alt'");
    dio_get_string(&din, real_packet->graphic_alt, sizeof(real_packet->graphic_alt));
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_tech_100(struct connection *pc, const struct packet_ruleset_tech *packet)
{
  const struct packet_ruleset_tech *real_packet = packet;
  packet_ruleset_tech_100_fields fields;
  struct packet_ruleset_tech *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_TECH;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_TECH);

  log_packet_detailed("packet_ruleset_tech_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_tech_100, cmp_packet_ruleset_tech_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


    {
      differ = (2 != 2);
      if(!differ) {
        int i;
        for (i = 0; i < 2; i++) {
          if (old->req[i] != real_packet->req[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->root_req != real_packet->root_req);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = !BV_ARE_EQUAL(old->flags, real_packet->flags);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->preset_cost != real_packet->preset_cost);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->num_reqs != real_packet->num_reqs);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (strcmp(old->helptext, real_packet->helptext) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (strcmp(old->graphic_str, real_packet->graphic_str) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (strcmp(old->graphic_alt, real_packet->graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    dio_put_uint8(&dout, real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'req' has changed");
  
    {
      int i;

      for (i = 0; i < 2; i++) {
        dio_put_uint8(&dout, real_packet->req[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'root_req' has changed");
    dio_put_uint8(&dout, real_packet->root_req);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'flags' has changed");
  DIO_BV_PUT(&dout, packet->flags);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'preset_cost' has changed");
    dio_put_uint32(&dout, real_packet->preset_cost);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'num_reqs' has changed");
    dio_put_uint32(&dout, real_packet->num_reqs);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'rule_name' has changed");
    dio_put_string(&dout, real_packet->rule_name);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'helptext' has changed");
    dio_put_string(&dout, real_packet->helptext);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'graphic_str' has changed");
    dio_put_string(&dout, real_packet->graphic_str);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'graphic_alt' has changed");
    dio_put_string(&dout, real_packet->graphic_alt);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_ruleset_tech(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_TECH] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_TECH variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_TECH] = variant;
}

struct packet_ruleset_tech *receive_packet_ruleset_tech(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_ruleset_tech at the server.");
  }
  ensure_valid_variant_packet_ruleset_tech(pc);

  switch(pc->phs.variant[PACKET_RULESET_TECH]) {
  case 100:
    return receive_packet_ruleset_tech_100(pc, type);
  default:
    log_debug("Unknown PACKET_RULESET_TECH variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_tech(struct connection *pc, const struct packet_ruleset_tech *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_tech from the client.");
  }
  ensure_valid_variant_packet_ruleset_tech(pc);

  switch(pc->phs.variant[PACKET_RULESET_TECH]) {

  case 100:
    return send_packet_ruleset_tech_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_TECH variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_tech(struct conn_list *dest, const struct packet_ruleset_tech *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_tech(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_government_100 hash_const

#define cmp_packet_ruleset_government_100 cmp_const

BV_DEFINE(packet_ruleset_government_100_fields, 8);

static struct packet_ruleset_government *receive_packet_ruleset_government_100(struct connection *pc, enum packet_type type)
{
  packet_ruleset_government_100_fields fields;
  struct packet_ruleset_government *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_ruleset_government, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_government_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_government_100, cmp_packet_ruleset_government_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'reqs_count'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->reqs_count = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'reqs'");
    
    {
      int i;
    
      if(real_packet->reqs_count > MAX_NUM_REQS) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->reqs_count = MAX_NUM_REQS;
      }
      for (i = 0; i < real_packet->reqs_count; i++) {
        dio_get_requirement(&din, &real_packet->reqs[i]);
      }
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'name'");
    dio_get_string(&din, real_packet->name, sizeof(real_packet->name));
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'rule_name'");
    dio_get_string(&din, real_packet->rule_name, sizeof(real_packet->rule_name));
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'graphic_str'");
    dio_get_string(&din, real_packet->graphic_str, sizeof(real_packet->graphic_str));
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'graphic_alt'");
    dio_get_string(&din, real_packet->graphic_alt, sizeof(real_packet->graphic_alt));
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'helptext'");
    dio_get_string(&din, real_packet->helptext, sizeof(real_packet->helptext));
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_government_100(struct connection *pc, const struct packet_ruleset_government *packet)
{
  const struct packet_ruleset_government *real_packet = packet;
  packet_ruleset_government_100_fields fields;
  struct packet_ruleset_government *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_GOVERNMENT;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_GOVERNMENT);

  log_packet_detailed("packet_ruleset_government_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_government_100, cmp_packet_ruleset_government_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->reqs_count != real_packet->reqs_count);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


    {
      differ = (old->reqs_count != real_packet->reqs_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->reqs_count; i++) {
          if (!are_requirements_equal(&old->reqs[i], &real_packet->reqs[i])) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (strcmp(old->graphic_str, real_packet->graphic_str) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (strcmp(old->graphic_alt, real_packet->graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (strcmp(old->helptext, real_packet->helptext) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    dio_put_uint8(&dout, real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'reqs_count' has changed");
    dio_put_uint8(&dout, real_packet->reqs_count);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'reqs' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->reqs_count; i++) {
        dio_put_requirement(&dout, &real_packet->reqs[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'rule_name' has changed");
    dio_put_string(&dout, real_packet->rule_name);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'graphic_str' has changed");
    dio_put_string(&dout, real_packet->graphic_str);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'graphic_alt' has changed");
    dio_put_string(&dout, real_packet->graphic_alt);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'helptext' has changed");
    dio_put_string(&dout, real_packet->helptext);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_ruleset_government(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_GOVERNMENT] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_GOVERNMENT variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_GOVERNMENT] = variant;
}

struct packet_ruleset_government *receive_packet_ruleset_government(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_ruleset_government at the server.");
  }
  ensure_valid_variant_packet_ruleset_government(pc);

  switch(pc->phs.variant[PACKET_RULESET_GOVERNMENT]) {
  case 100:
    return receive_packet_ruleset_government_100(pc, type);
  default:
    log_debug("Unknown PACKET_RULESET_GOVERNMENT variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_government(struct connection *pc, const struct packet_ruleset_government *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_government from the client.");
  }
  ensure_valid_variant_packet_ruleset_government(pc);

  switch(pc->phs.variant[PACKET_RULESET_GOVERNMENT]) {

  case 100:
    return send_packet_ruleset_government_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_GOVERNMENT variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_government(struct conn_list *dest, const struct packet_ruleset_government *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_government(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_terrain_control_100 hash_const

#define cmp_packet_ruleset_terrain_control_100 cmp_const

BV_DEFINE(packet_ruleset_terrain_control_100_fields, 15);

static struct packet_ruleset_terrain_control *receive_packet_ruleset_terrain_control_100(struct connection *pc, enum packet_type type)
{
  packet_ruleset_terrain_control_100_fields fields;
  struct packet_ruleset_terrain_control *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_ruleset_terrain_control, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_terrain_control_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_terrain_control_100, cmp_packet_ruleset_terrain_control_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  real_packet->may_road = BV_ISSET(fields, 0);
  real_packet->may_irrigate = BV_ISSET(fields, 1);
  real_packet->may_mine = BV_ISSET(fields, 2);
  real_packet->may_transform = BV_ISSET(fields, 3);
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'ocean_reclaim_requirement_pct'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->ocean_reclaim_requirement_pct = readin;
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'land_channel_requirement_pct'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->land_channel_requirement_pct = readin;
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'lake_max_size'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->lake_max_size = readin;
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'river_move_mode'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->river_move_mode = readin;
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'river_defense_bonus'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->river_defense_bonus = readin;
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'river_trade_incr'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->river_trade_incr = readin;
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'river_help_text'");
    dio_get_string(&din, real_packet->river_help_text, sizeof(real_packet->river_help_text));
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'road_superhighway_trade_bonus'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->road_superhighway_trade_bonus = readin;
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'rail_tile_bonus'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->rail_tile_bonus[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'pollution_tile_penalty'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->pollution_tile_penalty[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'fallout_tile_penalty'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->fallout_tile_penalty[i] = readin;
    }
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_terrain_control_100(struct connection *pc, const struct packet_ruleset_terrain_control *packet)
{
  const struct packet_ruleset_terrain_control *real_packet = packet;
  packet_ruleset_terrain_control_100_fields fields;
  struct packet_ruleset_terrain_control *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_TERRAIN_CONTROL;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_TERRAIN_CONTROL);

  log_packet_detailed("packet_ruleset_terrain_control_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_terrain_control_100, cmp_packet_ruleset_terrain_control_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->may_road != real_packet->may_road);
  if(differ) {
    different++;
  }
  if (packet->may_road) {
    BV_SET(fields, 0);
  }

  differ = (old->may_irrigate != real_packet->may_irrigate);
  if(differ) {
    different++;
  }
  if (packet->may_irrigate) {
    BV_SET(fields, 1);
  }

  differ = (old->may_mine != real_packet->may_mine);
  if(differ) {
    different++;
  }
  if (packet->may_mine) {
    BV_SET(fields, 2);
  }

  differ = (old->may_transform != real_packet->may_transform);
  if(differ) {
    different++;
  }
  if (packet->may_transform) {
    BV_SET(fields, 3);
  }

  differ = (old->ocean_reclaim_requirement_pct != real_packet->ocean_reclaim_requirement_pct);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->land_channel_requirement_pct != real_packet->land_channel_requirement_pct);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->lake_max_size != real_packet->lake_max_size);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (old->river_move_mode != real_packet->river_move_mode);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->river_defense_bonus != real_packet->river_defense_bonus);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->river_trade_incr != real_packet->river_trade_incr);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (strcmp(old->river_help_text, real_packet->river_help_text) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->road_superhighway_trade_bonus != real_packet->road_superhighway_trade_bonus);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->rail_tile_bonus[i] != real_packet->rail_tile_bonus[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->pollution_tile_penalty[i] != real_packet->pollution_tile_penalty[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->fallout_tile_penalty[i] != real_packet->fallout_tile_penalty[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }


  DIO_BV_PUT(&dout, fields);

  /* field 0 is folded into the header */
  /* field 1 is folded into the header */
  /* field 2 is folded into the header */
  /* field 3 is folded into the header */
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'ocean_reclaim_requirement_pct' has changed");
    dio_put_uint8(&dout, real_packet->ocean_reclaim_requirement_pct);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'land_channel_requirement_pct' has changed");
    dio_put_uint8(&dout, real_packet->land_channel_requirement_pct);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'lake_max_size' has changed");
    dio_put_uint8(&dout, real_packet->lake_max_size);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'river_move_mode' has changed");
    dio_put_uint8(&dout, real_packet->river_move_mode);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'river_defense_bonus' has changed");
    dio_put_sint16(&dout, real_packet->river_defense_bonus);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'river_trade_incr' has changed");
    dio_put_uint16(&dout, real_packet->river_trade_incr);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'river_help_text' has changed");
    dio_put_string(&dout, real_packet->river_help_text);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'road_superhighway_trade_bonus' has changed");
    dio_put_uint16(&dout, real_packet->road_superhighway_trade_bonus);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'rail_tile_bonus' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint16(&dout, real_packet->rail_tile_bonus[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'pollution_tile_penalty' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint8(&dout, real_packet->pollution_tile_penalty[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'fallout_tile_penalty' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint8(&dout, real_packet->fallout_tile_penalty[i]);
      }
    } 
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_ruleset_terrain_control(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_TERRAIN_CONTROL] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_TERRAIN_CONTROL variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_TERRAIN_CONTROL] = variant;
}

struct packet_ruleset_terrain_control *receive_packet_ruleset_terrain_control(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_ruleset_terrain_control at the server.");
  }
  ensure_valid_variant_packet_ruleset_terrain_control(pc);

  switch(pc->phs.variant[PACKET_RULESET_TERRAIN_CONTROL]) {
  case 100:
    return receive_packet_ruleset_terrain_control_100(pc, type);
  default:
    log_debug("Unknown PACKET_RULESET_TERRAIN_CONTROL variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_terrain_control(struct connection *pc, const struct packet_ruleset_terrain_control *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_terrain_control from the client.");
  }
  ensure_valid_variant_packet_ruleset_terrain_control(pc);

  switch(pc->phs.variant[PACKET_RULESET_TERRAIN_CONTROL]) {

  case 100:
    return send_packet_ruleset_terrain_control_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_TERRAIN_CONTROL variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_terrain_control(struct conn_list *dest, const struct packet_ruleset_terrain_control *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_terrain_control(pconn, packet);
  } conn_list_iterate_end;
}

static struct packet_rulesets_ready *receive_packet_rulesets_ready_100(struct connection *pc, enum packet_type type)
{
  RECEIVE_PACKET_START(packet_rulesets_ready, real_packet);

  log_packet_detailed("packet_rulesets_ready_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_rulesets_ready_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_RULESETS_READY);

  log_packet_detailed("packet_rulesets_ready_100: sending info about ()");
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_rulesets_ready(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESETS_READY] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESETS_READY variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESETS_READY] = variant;
}

struct packet_rulesets_ready *receive_packet_rulesets_ready(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_rulesets_ready at the server.");
  }
  ensure_valid_variant_packet_rulesets_ready(pc);

  switch(pc->phs.variant[PACKET_RULESETS_READY]) {
  case 100:
    return receive_packet_rulesets_ready_100(pc, type);
  default:
    log_debug("Unknown PACKET_RULESETS_READY variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_rulesets_ready(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_rulesets_ready from the client.");
  }
  ensure_valid_variant_packet_rulesets_ready(pc);

  switch(pc->phs.variant[PACKET_RULESETS_READY]) {

  case 100:
    return send_packet_rulesets_ready_100(pc);
  default:
    log_debug("Unknown PACKET_RULESETS_READY variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_rulesets_ready(struct conn_list *dest)
{
  conn_list_iterate(dest, pconn) {
    send_packet_rulesets_ready(pconn);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_nation_groups_100 hash_const

#define cmp_packet_ruleset_nation_groups_100 cmp_const

BV_DEFINE(packet_ruleset_nation_groups_100_fields, 2);

static struct packet_ruleset_nation_groups *receive_packet_ruleset_nation_groups_100(struct connection *pc, enum packet_type type)
{
  packet_ruleset_nation_groups_100_fields fields;
  struct packet_ruleset_nation_groups *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_ruleset_nation_groups, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_nation_groups_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_nation_groups_100, cmp_packet_ruleset_nation_groups_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'ngroups'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->ngroups = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'groups'");
    
    {
      int i;
    
      if(real_packet->ngroups > MAX_NUM_NATION_GROUPS) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->ngroups = MAX_NUM_NATION_GROUPS;
      }
      for (i = 0; i < real_packet->ngroups; i++) {
        dio_get_string(&din, real_packet->groups[i], sizeof(real_packet->groups[i]));
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_nation_groups_100(struct connection *pc, const struct packet_ruleset_nation_groups *packet)
{
  const struct packet_ruleset_nation_groups *real_packet = packet;
  packet_ruleset_nation_groups_100_fields fields;
  struct packet_ruleset_nation_groups *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_NATION_GROUPS;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_NATION_GROUPS);

  log_packet_detailed("packet_ruleset_nation_groups_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_nation_groups_100, cmp_packet_ruleset_nation_groups_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->ngroups != real_packet->ngroups);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


    {
      differ = (old->ngroups != real_packet->ngroups);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->ngroups; i++) {
          if (strcmp(old->groups[i], real_packet->groups[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'ngroups' has changed");
    dio_put_uint8(&dout, real_packet->ngroups);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'groups' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->ngroups; i++) {
        dio_put_string(&dout, real_packet->groups[i]);
      }
    } 
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_ruleset_nation_groups(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_NATION_GROUPS] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_NATION_GROUPS variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_NATION_GROUPS] = variant;
}

struct packet_ruleset_nation_groups *receive_packet_ruleset_nation_groups(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_ruleset_nation_groups at the server.");
  }
  ensure_valid_variant_packet_ruleset_nation_groups(pc);

  switch(pc->phs.variant[PACKET_RULESET_NATION_GROUPS]) {
  case 100:
    return receive_packet_ruleset_nation_groups_100(pc, type);
  default:
    log_debug("Unknown PACKET_RULESET_NATION_GROUPS variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_nation_groups(struct connection *pc, const struct packet_ruleset_nation_groups *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_nation_groups from the client.");
  }
  ensure_valid_variant_packet_ruleset_nation_groups(pc);

  switch(pc->phs.variant[PACKET_RULESET_NATION_GROUPS]) {

  case 100:
    return send_packet_ruleset_nation_groups_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_NATION_GROUPS variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_nation_groups(struct conn_list *dest, const struct packet_ruleset_nation_groups *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_nation_groups(pconn, packet);
  } conn_list_iterate_end;
}

static genhash_val_t hash_packet_ruleset_nation_100(const void *vkey, size_t num_buckets)
{
  const struct packet_ruleset_nation *key = (const struct packet_ruleset_nation *) vkey;

  return ((key->id) % num_buckets);
}

static bool cmp_packet_ruleset_nation_100(const void *vkey1, const void *vkey2)
{
  const struct packet_ruleset_nation *key1 = (const struct packet_ruleset_nation *) vkey1;
  const struct packet_ruleset_nation *key2 = (const struct packet_ruleset_nation *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_ruleset_nation_100_fields, 19);

static struct packet_ruleset_nation *receive_packet_ruleset_nation_100(struct connection *pc, enum packet_type type)
{
  packet_ruleset_nation_100_fields fields;
  struct packet_ruleset_nation *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_ruleset_nation, real_packet);

  DIO_BV_GET(&din, fields);
  {
    int readin;
  
    dio_get_sint16(&din, &readin);
    real_packet->id = readin;
  }

  log_packet_detailed("packet_ruleset_nation_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_nation_100, cmp_packet_ruleset_nation_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    Nation_type_id id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'adjective'");
    dio_get_string(&din, real_packet->adjective, sizeof(real_packet->adjective));
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'rule_name'");
    dio_get_string(&din, real_packet->rule_name, sizeof(real_packet->rule_name));
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'noun_plural'");
    dio_get_string(&din, real_packet->noun_plural, sizeof(real_packet->noun_plural));
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'graphic_str'");
    dio_get_string(&din, real_packet->graphic_str, sizeof(real_packet->graphic_str));
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'graphic_alt'");
    dio_get_string(&din, real_packet->graphic_alt, sizeof(real_packet->graphic_alt));
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'legend'");
    dio_get_string(&din, real_packet->legend, sizeof(real_packet->legend));
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'city_style'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->city_style = readin;
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'leader_count'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->leader_count = readin;
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'leader_name'");
    
    {
      int i;
    
      if(real_packet->leader_count > MAX_NUM_LEADERS) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->leader_count = MAX_NUM_LEADERS;
      }
      for (i = 0; i < real_packet->leader_count; i++) {
        dio_get_string(&din, real_packet->leader_name[i], sizeof(real_packet->leader_name[i]));
      }
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'leader_is_male'");
    
    {
      int i;
    
      if(real_packet->leader_count > MAX_NUM_LEADERS) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->leader_count = MAX_NUM_LEADERS;
      }
      for (i = 0; i < real_packet->leader_count; i++) {
        dio_get_bool8(&din, &real_packet->leader_is_male[i]);
      }
    }
  }
  real_packet->is_available = BV_ISSET(fields, 10);
  real_packet->is_playable = BV_ISSET(fields, 11);
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'barbarian_type'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->barbarian_type = readin;
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'ngroups'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->ngroups = readin;
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'groups'");
    
    {
      int i;
    
      if(real_packet->ngroups > MAX_NUM_NATION_GROUPS) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->ngroups = MAX_NUM_NATION_GROUPS;
      }
      for (i = 0; i < real_packet->ngroups; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->groups[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'init_government_id'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->init_government_id = readin;
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'init_techs'");
    dio_get_tech_list(&din, real_packet->init_techs);
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'init_units'");
    dio_get_unit_list(&din, real_packet->init_units);
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'init_buildings'");
    dio_get_building_list(&din, real_packet->init_buildings);
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_nation_100(struct connection *pc, const struct packet_ruleset_nation *packet)
{
  const struct packet_ruleset_nation *real_packet = packet;
  packet_ruleset_nation_100_fields fields;
  struct packet_ruleset_nation *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_NATION;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_NATION);

  log_packet_detailed("packet_ruleset_nation_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_nation_100, cmp_packet_ruleset_nation_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->adjective, real_packet->adjective) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->noun_plural, real_packet->noun_plural) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (strcmp(old->graphic_str, real_packet->graphic_str) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (strcmp(old->graphic_alt, real_packet->graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (strcmp(old->legend, real_packet->legend) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->city_style != real_packet->city_style);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (old->leader_count != real_packet->leader_count);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }


    {
      differ = (old->leader_count != real_packet->leader_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->leader_count; i++) {
          if (strcmp(old->leader_name[i], real_packet->leader_name[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }


    {
      differ = (old->leader_count != real_packet->leader_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->leader_count; i++) {
          if (old->leader_is_male[i] != real_packet->leader_is_male[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->is_available != real_packet->is_available);
  if(differ) {
    different++;
  }
  if (packet->is_available) {
    BV_SET(fields, 10);
  }

  differ = (old->is_playable != real_packet->is_playable);
  if(differ) {
    different++;
  }
  if (packet->is_playable) {
    BV_SET(fields, 11);
  }

  differ = (old->barbarian_type != real_packet->barbarian_type);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = (old->ngroups != real_packet->ngroups);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }


    {
      differ = (old->ngroups != real_packet->ngroups);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->ngroups; i++) {
          if (old->groups[i] != real_packet->groups[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->init_government_id != real_packet->init_government_id);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }


    {
      differ = (MAX_NUM_TECH_LIST != MAX_NUM_TECH_LIST);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_NUM_TECH_LIST; i++) {
          if (old->init_techs[i] != real_packet->init_techs[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }


    {
      differ = (MAX_NUM_UNIT_LIST != MAX_NUM_UNIT_LIST);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_NUM_UNIT_LIST; i++) {
          if (old->init_units[i] != real_packet->init_units[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }


    {
      differ = (MAX_NUM_BUILDING_LIST != MAX_NUM_BUILDING_LIST);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_NUM_BUILDING_LIST; i++) {
          if (old->init_buildings[i] != real_packet->init_buildings[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }


  DIO_BV_PUT(&dout, fields);
  dio_put_sint16(&dout, real_packet->id);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'adjective' has changed");
    dio_put_string(&dout, real_packet->adjective);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'rule_name' has changed");
    dio_put_string(&dout, real_packet->rule_name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'noun_plural' has changed");
    dio_put_string(&dout, real_packet->noun_plural);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'graphic_str' has changed");
    dio_put_string(&dout, real_packet->graphic_str);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'graphic_alt' has changed");
    dio_put_string(&dout, real_packet->graphic_alt);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'legend' has changed");
    dio_put_string(&dout, real_packet->legend);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'city_style' has changed");
    dio_put_uint8(&dout, real_packet->city_style);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'leader_count' has changed");
    dio_put_uint8(&dout, real_packet->leader_count);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'leader_name' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->leader_count; i++) {
        dio_put_string(&dout, real_packet->leader_name[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'leader_is_male' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->leader_count; i++) {
        dio_put_bool8(&dout, real_packet->leader_is_male[i]);
      }
    } 
  }
  /* field 10 is folded into the header */
  /* field 11 is folded into the header */
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'barbarian_type' has changed");
    dio_put_uint8(&dout, real_packet->barbarian_type);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'ngroups' has changed");
    dio_put_uint8(&dout, real_packet->ngroups);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'groups' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->ngroups; i++) {
        dio_put_uint8(&dout, real_packet->groups[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'init_government_id' has changed");
    dio_put_uint8(&dout, real_packet->init_government_id);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'init_techs' has changed");
    dio_put_tech_list(&dout, real_packet->init_techs);
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'init_units' has changed");
    dio_put_unit_list(&dout, real_packet->init_units);
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'init_buildings' has changed");
    dio_put_building_list(&dout, real_packet->init_buildings);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_ruleset_nation(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_NATION] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_NATION variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_NATION] = variant;
}

struct packet_ruleset_nation *receive_packet_ruleset_nation(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_ruleset_nation at the server.");
  }
  ensure_valid_variant_packet_ruleset_nation(pc);

  switch(pc->phs.variant[PACKET_RULESET_NATION]) {
  case 100:
    return receive_packet_ruleset_nation_100(pc, type);
  default:
    log_debug("Unknown PACKET_RULESET_NATION variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_nation(struct connection *pc, const struct packet_ruleset_nation *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_nation from the client.");
  }
  ensure_valid_variant_packet_ruleset_nation(pc);

  switch(pc->phs.variant[PACKET_RULESET_NATION]) {

  case 100:
    return send_packet_ruleset_nation_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_NATION variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_nation(struct conn_list *dest, const struct packet_ruleset_nation *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_nation(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_city_100 hash_const

#define cmp_packet_ruleset_city_100 cmp_const

BV_DEFINE(packet_ruleset_city_100_fields, 12);

static struct packet_ruleset_city *receive_packet_ruleset_city_100(struct connection *pc, enum packet_type type)
{
  packet_ruleset_city_100_fields fields;
  struct packet_ruleset_city *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_ruleset_city, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_city_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_city_100, cmp_packet_ruleset_city_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'style_id'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->style_id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    dio_get_string(&din, real_packet->name, sizeof(real_packet->name));
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'rule_name'");
    dio_get_string(&din, real_packet->rule_name, sizeof(real_packet->rule_name));
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'citizens_graphic'");
    dio_get_string(&din, real_packet->citizens_graphic, sizeof(real_packet->citizens_graphic));
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'citizens_graphic_alt'");
    dio_get_string(&din, real_packet->citizens_graphic_alt, sizeof(real_packet->citizens_graphic_alt));
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'reqs_count'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->reqs_count = readin;
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'reqs'");
    
    {
      int i;
    
      if(real_packet->reqs_count > MAX_NUM_REQS) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->reqs_count = MAX_NUM_REQS;
      }
      for (i = 0; i < real_packet->reqs_count; i++) {
        dio_get_requirement(&din, &real_packet->reqs[i]);
      }
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'graphic'");
    dio_get_string(&din, real_packet->graphic, sizeof(real_packet->graphic));
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'graphic_alt'");
    dio_get_string(&din, real_packet->graphic_alt, sizeof(real_packet->graphic_alt));
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'oceanic_graphic'");
    dio_get_string(&din, real_packet->oceanic_graphic, sizeof(real_packet->oceanic_graphic));
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'oceanic_graphic_alt'");
    dio_get_string(&din, real_packet->oceanic_graphic_alt, sizeof(real_packet->oceanic_graphic_alt));
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'replaced_by'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->replaced_by = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_city_100(struct connection *pc, const struct packet_ruleset_city *packet)
{
  const struct packet_ruleset_city *real_packet = packet;
  packet_ruleset_city_100_fields fields;
  struct packet_ruleset_city *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_CITY;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_CITY);

  log_packet_detailed("packet_ruleset_city_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_city_100, cmp_packet_ruleset_city_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->style_id != real_packet->style_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (strcmp(old->citizens_graphic, real_packet->citizens_graphic) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (strcmp(old->citizens_graphic_alt, real_packet->citizens_graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->reqs_count != real_packet->reqs_count);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


    {
      differ = (old->reqs_count != real_packet->reqs_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->reqs_count; i++) {
          if (!are_requirements_equal(&old->reqs[i], &real_packet->reqs[i])) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (strcmp(old->graphic, real_packet->graphic) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (strcmp(old->graphic_alt, real_packet->graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (strcmp(old->oceanic_graphic, real_packet->oceanic_graphic) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (strcmp(old->oceanic_graphic_alt, real_packet->oceanic_graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->replaced_by != real_packet->replaced_by);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'style_id' has changed");
    dio_put_uint8(&dout, real_packet->style_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'rule_name' has changed");
    dio_put_string(&dout, real_packet->rule_name);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'citizens_graphic' has changed");
    dio_put_string(&dout, real_packet->citizens_graphic);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'citizens_graphic_alt' has changed");
    dio_put_string(&dout, real_packet->citizens_graphic_alt);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'reqs_count' has changed");
    dio_put_uint8(&dout, real_packet->reqs_count);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'reqs' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->reqs_count; i++) {
        dio_put_requirement(&dout, &real_packet->reqs[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'graphic' has changed");
    dio_put_string(&dout, real_packet->graphic);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'graphic_alt' has changed");
    dio_put_string(&dout, real_packet->graphic_alt);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'oceanic_graphic' has changed");
    dio_put_string(&dout, real_packet->oceanic_graphic);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'oceanic_graphic_alt' has changed");
    dio_put_string(&dout, real_packet->oceanic_graphic_alt);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'replaced_by' has changed");
    dio_put_sint8(&dout, real_packet->replaced_by);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_ruleset_city(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_CITY] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_CITY variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_CITY] = variant;
}

struct packet_ruleset_city *receive_packet_ruleset_city(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_ruleset_city at the server.");
  }
  ensure_valid_variant_packet_ruleset_city(pc);

  switch(pc->phs.variant[PACKET_RULESET_CITY]) {
  case 100:
    return receive_packet_ruleset_city_100(pc, type);
  default:
    log_debug("Unknown PACKET_RULESET_CITY variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_city(struct connection *pc, const struct packet_ruleset_city *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_city from the client.");
  }
  ensure_valid_variant_packet_ruleset_city(pc);

  switch(pc->phs.variant[PACKET_RULESET_CITY]) {

  case 100:
    return send_packet_ruleset_city_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_CITY variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_city(struct conn_list *dest, const struct packet_ruleset_city *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_city(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_building_100 hash_const

#define cmp_packet_ruleset_building_100 cmp_const

BV_DEFINE(packet_ruleset_building_100_fields, 17);

static struct packet_ruleset_building *receive_packet_ruleset_building_100(struct connection *pc, enum packet_type type)
{
  packet_ruleset_building_100_fields fields;
  struct packet_ruleset_building *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_ruleset_building, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_building_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_building_100, cmp_packet_ruleset_building_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'genus'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->genus = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'name'");
    dio_get_string(&din, real_packet->name, sizeof(real_packet->name));
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'rule_name'");
    dio_get_string(&din, real_packet->rule_name, sizeof(real_packet->rule_name));
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'graphic_str'");
    dio_get_string(&din, real_packet->graphic_str, sizeof(real_packet->graphic_str));
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'graphic_alt'");
    dio_get_string(&din, real_packet->graphic_alt, sizeof(real_packet->graphic_alt));
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'reqs_count'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->reqs_count = readin;
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'reqs'");
    
    {
      int i;
    
      if(real_packet->reqs_count > MAX_NUM_REQS) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->reqs_count = MAX_NUM_REQS;
      }
      for (i = 0; i < real_packet->reqs_count; i++) {
        dio_get_requirement(&din, &real_packet->reqs[i]);
      }
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'obsolete_by'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->obsolete_by = readin;
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'replaced_by'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->replaced_by = readin;
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'build_cost'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->build_cost = readin;
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'upkeep'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->upkeep = readin;
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'sabotage'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->sabotage = readin;
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'flags'");
    DIO_BV_GET(&din, real_packet->flags);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'soundtag'");
    dio_get_string(&din, real_packet->soundtag, sizeof(real_packet->soundtag));
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'soundtag_alt'");
    dio_get_string(&din, real_packet->soundtag_alt, sizeof(real_packet->soundtag_alt));
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'helptext'");
    dio_get_string(&din, real_packet->helptext, sizeof(real_packet->helptext));
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_building_100(struct connection *pc, const struct packet_ruleset_building *packet)
{
  const struct packet_ruleset_building *real_packet = packet;
  packet_ruleset_building_100_fields fields;
  struct packet_ruleset_building *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_BUILDING;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_BUILDING);

  log_packet_detailed("packet_ruleset_building_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_building_100, cmp_packet_ruleset_building_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->genus != real_packet->genus);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (strcmp(old->graphic_str, real_packet->graphic_str) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (strcmp(old->graphic_alt, real_packet->graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->reqs_count != real_packet->reqs_count);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }


    {
      differ = (old->reqs_count != real_packet->reqs_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->reqs_count; i++) {
          if (!are_requirements_equal(&old->reqs[i], &real_packet->reqs[i])) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->obsolete_by != real_packet->obsolete_by);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->replaced_by != real_packet->replaced_by);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->build_cost != real_packet->build_cost);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->upkeep != real_packet->upkeep);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = (old->sabotage != real_packet->sabotage);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = !BV_ARE_EQUAL(old->flags, real_packet->flags);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (strcmp(old->soundtag, real_packet->soundtag) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (strcmp(old->soundtag_alt, real_packet->soundtag_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (strcmp(old->helptext, real_packet->helptext) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    dio_put_uint8(&dout, real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'genus' has changed");
    dio_put_uint8(&dout, real_packet->genus);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'rule_name' has changed");
    dio_put_string(&dout, real_packet->rule_name);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'graphic_str' has changed");
    dio_put_string(&dout, real_packet->graphic_str);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'graphic_alt' has changed");
    dio_put_string(&dout, real_packet->graphic_alt);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'reqs_count' has changed");
    dio_put_uint8(&dout, real_packet->reqs_count);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'reqs' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->reqs_count; i++) {
        dio_put_requirement(&dout, &real_packet->reqs[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'obsolete_by' has changed");
    dio_put_uint8(&dout, real_packet->obsolete_by);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'replaced_by' has changed");
    dio_put_uint8(&dout, real_packet->replaced_by);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'build_cost' has changed");
    dio_put_uint16(&dout, real_packet->build_cost);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'upkeep' has changed");
    dio_put_uint8(&dout, real_packet->upkeep);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'sabotage' has changed");
    dio_put_uint8(&dout, real_packet->sabotage);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'flags' has changed");
  DIO_BV_PUT(&dout, packet->flags);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'soundtag' has changed");
    dio_put_string(&dout, real_packet->soundtag);
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'soundtag_alt' has changed");
    dio_put_string(&dout, real_packet->soundtag_alt);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'helptext' has changed");
    dio_put_string(&dout, real_packet->helptext);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_ruleset_building(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_BUILDING] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_BUILDING variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_BUILDING] = variant;
}

struct packet_ruleset_building *receive_packet_ruleset_building(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_ruleset_building at the server.");
  }
  ensure_valid_variant_packet_ruleset_building(pc);

  switch(pc->phs.variant[PACKET_RULESET_BUILDING]) {
  case 100:
    return receive_packet_ruleset_building_100(pc, type);
  default:
    log_debug("Unknown PACKET_RULESET_BUILDING variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_building(struct connection *pc, const struct packet_ruleset_building *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_building from the client.");
  }
  ensure_valid_variant_packet_ruleset_building(pc);

  switch(pc->phs.variant[PACKET_RULESET_BUILDING]) {

  case 100:
    return send_packet_ruleset_building_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_BUILDING variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_building(struct conn_list *dest, const struct packet_ruleset_building *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_building(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_terrain_100 hash_const

#define cmp_packet_ruleset_terrain_100 cmp_const

BV_DEFINE(packet_ruleset_terrain_100_fields, 29);

static struct packet_ruleset_terrain *receive_packet_ruleset_terrain_100(struct connection *pc, enum packet_type type)
{
  packet_ruleset_terrain_100_fields fields;
  struct packet_ruleset_terrain *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_ruleset_terrain, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_terrain_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_terrain_100, cmp_packet_ruleset_terrain_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'flags'");
    DIO_BV_GET(&din, real_packet->flags);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'native_to'");
    DIO_BV_GET(&din, real_packet->native_to);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'name'");
    dio_get_string(&din, real_packet->name, sizeof(real_packet->name));
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'rule_name'");
    dio_get_string(&din, real_packet->rule_name, sizeof(real_packet->rule_name));
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'graphic_str'");
    dio_get_string(&din, real_packet->graphic_str, sizeof(real_packet->graphic_str));
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'graphic_alt'");
    dio_get_string(&din, real_packet->graphic_alt, sizeof(real_packet->graphic_alt));
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'movement_cost'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->movement_cost = readin;
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'defense_bonus'");
    {
      int readin;
    
      dio_get_sint16(&din, &readin);
      real_packet->defense_bonus = readin;
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'output'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->output[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'num_resources'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->num_resources = readin;
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'resources'");
    
    {
      int i;
    
      if(real_packet->num_resources > MAX_NUM_RESOURCES) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->num_resources = MAX_NUM_RESOURCES;
      }
      for (i = 0; i < real_packet->num_resources; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->resources[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'road_trade_incr'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->road_trade_incr = readin;
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'road_time'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->road_time = readin;
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'irrigation_result'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->irrigation_result = readin;
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'irrigation_food_incr'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->irrigation_food_incr = readin;
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'irrigation_time'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->irrigation_time = readin;
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'mining_result'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->mining_result = readin;
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'mining_shield_incr'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->mining_shield_incr = readin;
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'mining_time'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->mining_time = readin;
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'transform_result'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->transform_result = readin;
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  got field 'transform_time'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->transform_time = readin;
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'rail_time'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->rail_time = readin;
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'clean_pollution_time'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->clean_pollution_time = readin;
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'clean_fallout_time'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->clean_fallout_time = readin;
    }
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  got field 'color_red'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->color_red = readin;
    }
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  got field 'color_green'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->color_green = readin;
    }
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  got field 'color_blue'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->color_blue = readin;
    }
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  got field 'helptext'");
    dio_get_string(&din, real_packet->helptext, sizeof(real_packet->helptext));
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_terrain_100(struct connection *pc, const struct packet_ruleset_terrain *packet)
{
  const struct packet_ruleset_terrain *real_packet = packet;
  packet_ruleset_terrain_100_fields fields;
  struct packet_ruleset_terrain *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_TERRAIN;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_TERRAIN);

  log_packet_detailed("packet_ruleset_terrain_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_terrain_100, cmp_packet_ruleset_terrain_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = !BV_ARE_EQUAL(old->flags, real_packet->flags);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = !BV_ARE_EQUAL(old->native_to, real_packet->native_to);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (strcmp(old->graphic_str, real_packet->graphic_str) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (strcmp(old->graphic_alt, real_packet->graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (old->movement_cost != real_packet->movement_cost);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->defense_bonus != real_packet->defense_bonus);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->output[i] != real_packet->output[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->num_resources != real_packet->num_resources);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }


    {
      differ = (old->num_resources != real_packet->num_resources);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->num_resources; i++) {
          if (old->resources[i] != real_packet->resources[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = (old->road_trade_incr != real_packet->road_trade_incr);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = (old->road_time != real_packet->road_time);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->irrigation_result != real_packet->irrigation_result);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->irrigation_food_incr != real_packet->irrigation_food_incr);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (old->irrigation_time != real_packet->irrigation_time);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }

  differ = (old->mining_result != real_packet->mining_result);
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }

  differ = (old->mining_shield_incr != real_packet->mining_shield_incr);
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }

  differ = (old->mining_time != real_packet->mining_time);
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }

  differ = (old->transform_result != real_packet->transform_result);
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }

  differ = (old->transform_time != real_packet->transform_time);
  if (differ) {
    different++;
    BV_SET(fields, 21);
  }

  differ = (old->rail_time != real_packet->rail_time);
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (old->clean_pollution_time != real_packet->clean_pollution_time);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }

  differ = (old->clean_fallout_time != real_packet->clean_fallout_time);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }

  differ = (old->color_red != real_packet->color_red);
  if (differ) {
    different++;
    BV_SET(fields, 25);
  }

  differ = (old->color_green != real_packet->color_green);
  if (differ) {
    different++;
    BV_SET(fields, 26);
  }

  differ = (old->color_blue != real_packet->color_blue);
  if (differ) {
    different++;
    BV_SET(fields, 27);
  }

  differ = (strcmp(old->helptext, real_packet->helptext) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 28);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    dio_put_uint8(&dout, real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'flags' has changed");
  DIO_BV_PUT(&dout, packet->flags);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'native_to' has changed");
  DIO_BV_PUT(&dout, packet->native_to);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'rule_name' has changed");
    dio_put_string(&dout, real_packet->rule_name);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'graphic_str' has changed");
    dio_put_string(&dout, real_packet->graphic_str);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'graphic_alt' has changed");
    dio_put_string(&dout, real_packet->graphic_alt);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'movement_cost' has changed");
    dio_put_uint8(&dout, real_packet->movement_cost);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'defense_bonus' has changed");
    dio_put_sint16(&dout, real_packet->defense_bonus);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'output' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint8(&dout, real_packet->output[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'num_resources' has changed");
    dio_put_uint8(&dout, real_packet->num_resources);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'resources' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->num_resources; i++) {
        dio_put_uint8(&dout, real_packet->resources[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'road_trade_incr' has changed");
    dio_put_uint8(&dout, real_packet->road_trade_incr);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'road_time' has changed");
    dio_put_uint8(&dout, real_packet->road_time);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'irrigation_result' has changed");
    dio_put_uint8(&dout, real_packet->irrigation_result);
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'irrigation_food_incr' has changed");
    dio_put_uint8(&dout, real_packet->irrigation_food_incr);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'irrigation_time' has changed");
    dio_put_uint8(&dout, real_packet->irrigation_time);
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'mining_result' has changed");
    dio_put_uint8(&dout, real_packet->mining_result);
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'mining_shield_incr' has changed");
    dio_put_uint8(&dout, real_packet->mining_shield_incr);
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'mining_time' has changed");
    dio_put_uint8(&dout, real_packet->mining_time);
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'transform_result' has changed");
    dio_put_uint8(&dout, real_packet->transform_result);
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  field 'transform_time' has changed");
    dio_put_uint8(&dout, real_packet->transform_time);
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'rail_time' has changed");
    dio_put_uint8(&dout, real_packet->rail_time);
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'clean_pollution_time' has changed");
    dio_put_uint8(&dout, real_packet->clean_pollution_time);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'clean_fallout_time' has changed");
    dio_put_uint8(&dout, real_packet->clean_fallout_time);
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  field 'color_red' has changed");
    dio_put_uint8(&dout, real_packet->color_red);
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  field 'color_green' has changed");
    dio_put_uint8(&dout, real_packet->color_green);
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  field 'color_blue' has changed");
    dio_put_uint8(&dout, real_packet->color_blue);
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  field 'helptext' has changed");
    dio_put_string(&dout, real_packet->helptext);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_ruleset_terrain(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_TERRAIN] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_TERRAIN variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_TERRAIN] = variant;
}

struct packet_ruleset_terrain *receive_packet_ruleset_terrain(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_ruleset_terrain at the server.");
  }
  ensure_valid_variant_packet_ruleset_terrain(pc);

  switch(pc->phs.variant[PACKET_RULESET_TERRAIN]) {
  case 100:
    return receive_packet_ruleset_terrain_100(pc, type);
  default:
    log_debug("Unknown PACKET_RULESET_TERRAIN variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_terrain(struct connection *pc, const struct packet_ruleset_terrain *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_terrain from the client.");
  }
  ensure_valid_variant_packet_ruleset_terrain(pc);

  switch(pc->phs.variant[PACKET_RULESET_TERRAIN]) {

  case 100:
    return send_packet_ruleset_terrain_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_TERRAIN variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_terrain(struct conn_list *dest, const struct packet_ruleset_terrain *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_terrain(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_unit_class_100 hash_const

#define cmp_packet_ruleset_unit_class_100 cmp_const

BV_DEFINE(packet_ruleset_unit_class_100_fields, 8);

static struct packet_ruleset_unit_class *receive_packet_ruleset_unit_class_100(struct connection *pc, enum packet_type type)
{
  packet_ruleset_unit_class_100_fields fields;
  struct packet_ruleset_unit_class *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_ruleset_unit_class, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_unit_class_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_unit_class_100, cmp_packet_ruleset_unit_class_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    dio_get_string(&din, real_packet->name, sizeof(real_packet->name));
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'rule_name'");
    dio_get_string(&din, real_packet->rule_name, sizeof(real_packet->rule_name));
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'move_type'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->move_type = readin;
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'min_speed'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->min_speed = readin;
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'hp_loss_pct'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->hp_loss_pct = readin;
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'hut_behavior'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->hut_behavior = readin;
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'flags'");
    DIO_BV_GET(&din, real_packet->flags);
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_unit_class_100(struct connection *pc, const struct packet_ruleset_unit_class *packet)
{
  const struct packet_ruleset_unit_class *real_packet = packet;
  packet_ruleset_unit_class_100_fields fields;
  struct packet_ruleset_unit_class *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_UNIT_CLASS;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_UNIT_CLASS);

  log_packet_detailed("packet_ruleset_unit_class_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_unit_class_100, cmp_packet_ruleset_unit_class_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->move_type != real_packet->move_type);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->min_speed != real_packet->min_speed);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->hp_loss_pct != real_packet->hp_loss_pct);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->hut_behavior != real_packet->hut_behavior);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = !BV_ARE_EQUAL(old->flags, real_packet->flags);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    dio_put_uint8(&dout, real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'rule_name' has changed");
    dio_put_string(&dout, real_packet->rule_name);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'move_type' has changed");
    dio_put_uint8(&dout, real_packet->move_type);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'min_speed' has changed");
    dio_put_uint8(&dout, real_packet->min_speed);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'hp_loss_pct' has changed");
    dio_put_uint8(&dout, real_packet->hp_loss_pct);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'hut_behavior' has changed");
    dio_put_uint8(&dout, real_packet->hut_behavior);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'flags' has changed");
  DIO_BV_PUT(&dout, packet->flags);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_ruleset_unit_class(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_UNIT_CLASS] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_UNIT_CLASS variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_UNIT_CLASS] = variant;
}

struct packet_ruleset_unit_class *receive_packet_ruleset_unit_class(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_ruleset_unit_class at the server.");
  }
  ensure_valid_variant_packet_ruleset_unit_class(pc);

  switch(pc->phs.variant[PACKET_RULESET_UNIT_CLASS]) {
  case 100:
    return receive_packet_ruleset_unit_class_100(pc, type);
  default:
    log_debug("Unknown PACKET_RULESET_UNIT_CLASS variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_unit_class(struct connection *pc, const struct packet_ruleset_unit_class *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_unit_class from the client.");
  }
  ensure_valid_variant_packet_ruleset_unit_class(pc);

  switch(pc->phs.variant[PACKET_RULESET_UNIT_CLASS]) {

  case 100:
    return send_packet_ruleset_unit_class_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_UNIT_CLASS variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_unit_class(struct conn_list *dest, const struct packet_ruleset_unit_class *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_unit_class(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_base_100 hash_const

#define cmp_packet_ruleset_base_100 cmp_const

BV_DEFINE(packet_ruleset_base_100_fields, 20);

static struct packet_ruleset_base *receive_packet_ruleset_base_100(struct connection *pc, enum packet_type type)
{
  packet_ruleset_base_100_fields fields;
  struct packet_ruleset_base *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_ruleset_base, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_base_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_base_100, cmp_packet_ruleset_base_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    dio_get_string(&din, real_packet->name, sizeof(real_packet->name));
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'rule_name'");
    dio_get_string(&din, real_packet->rule_name, sizeof(real_packet->rule_name));
  }
  real_packet->buildable = BV_ISSET(fields, 3);
  real_packet->pillageable = BV_ISSET(fields, 4);
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'graphic_str'");
    dio_get_string(&din, real_packet->graphic_str, sizeof(real_packet->graphic_str));
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'graphic_alt'");
    dio_get_string(&din, real_packet->graphic_alt, sizeof(real_packet->graphic_alt));
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'activity_gfx'");
    dio_get_string(&din, real_packet->activity_gfx, sizeof(real_packet->activity_gfx));
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'reqs_count'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->reqs_count = readin;
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'reqs'");
    
    {
      int i;
    
      if(real_packet->reqs_count > MAX_NUM_REQS) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->reqs_count = MAX_NUM_REQS;
      }
      for (i = 0; i < real_packet->reqs_count; i++) {
        dio_get_requirement(&din, &real_packet->reqs[i]);
      }
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'gui_type'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->gui_type = readin;
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'native_to'");
    DIO_BV_GET(&din, real_packet->native_to);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'build_time'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->build_time = readin;
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'defense_bonus'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->defense_bonus = readin;
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'border_sq'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->border_sq = readin;
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'vision_main_sq'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->vision_main_sq = readin;
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'vision_invis_sq'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->vision_invis_sq = readin;
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'flags'");
    DIO_BV_GET(&din, real_packet->flags);
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'conflicts'");
    DIO_BV_GET(&din, real_packet->conflicts);
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'helptext'");
    dio_get_string(&din, real_packet->helptext, sizeof(real_packet->helptext));
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_base_100(struct connection *pc, const struct packet_ruleset_base *packet)
{
  const struct packet_ruleset_base *real_packet = packet;
  packet_ruleset_base_100_fields fields;
  struct packet_ruleset_base *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_BASE;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_BASE);

  log_packet_detailed("packet_ruleset_base_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_base_100, cmp_packet_ruleset_base_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->buildable != real_packet->buildable);
  if(differ) {
    different++;
  }
  if (packet->buildable) {
    BV_SET(fields, 3);
  }

  differ = (old->pillageable != real_packet->pillageable);
  if(differ) {
    different++;
  }
  if (packet->pillageable) {
    BV_SET(fields, 4);
  }

  differ = (strcmp(old->graphic_str, real_packet->graphic_str) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (strcmp(old->graphic_alt, real_packet->graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (strcmp(old->activity_gfx, real_packet->activity_gfx) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->reqs_count != real_packet->reqs_count);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }


    {
      differ = (old->reqs_count != real_packet->reqs_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->reqs_count; i++) {
          if (!are_requirements_equal(&old->reqs[i], &real_packet->reqs[i])) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->gui_type != real_packet->gui_type);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = !BV_ARE_EQUAL(old->native_to, real_packet->native_to);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = (old->build_time != real_packet->build_time);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = (old->defense_bonus != real_packet->defense_bonus);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->border_sq != real_packet->border_sq);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->vision_main_sq != real_packet->vision_main_sq);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (old->vision_invis_sq != real_packet->vision_invis_sq);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }

  differ = !BV_ARE_EQUAL(old->flags, real_packet->flags);
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }

  differ = !BV_ARE_EQUAL(old->conflicts, real_packet->conflicts);
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }

  differ = (strcmp(old->helptext, real_packet->helptext) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    dio_put_uint8(&dout, real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'rule_name' has changed");
    dio_put_string(&dout, real_packet->rule_name);
  }
  /* field 3 is folded into the header */
  /* field 4 is folded into the header */
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'graphic_str' has changed");
    dio_put_string(&dout, real_packet->graphic_str);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'graphic_alt' has changed");
    dio_put_string(&dout, real_packet->graphic_alt);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'activity_gfx' has changed");
    dio_put_string(&dout, real_packet->activity_gfx);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'reqs_count' has changed");
    dio_put_uint8(&dout, real_packet->reqs_count);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'reqs' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->reqs_count; i++) {
        dio_put_requirement(&dout, &real_packet->reqs[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'gui_type' has changed");
    dio_put_uint8(&dout, real_packet->gui_type);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'native_to' has changed");
  DIO_BV_PUT(&dout, packet->native_to);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'build_time' has changed");
    dio_put_uint8(&dout, real_packet->build_time);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'defense_bonus' has changed");
    dio_put_uint8(&dout, real_packet->defense_bonus);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'border_sq' has changed");
    dio_put_sint8(&dout, real_packet->border_sq);
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'vision_main_sq' has changed");
    dio_put_sint8(&dout, real_packet->vision_main_sq);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'vision_invis_sq' has changed");
    dio_put_sint8(&dout, real_packet->vision_invis_sq);
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'flags' has changed");
  DIO_BV_PUT(&dout, packet->flags);
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'conflicts' has changed");
  DIO_BV_PUT(&dout, packet->conflicts);
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'helptext' has changed");
    dio_put_string(&dout, real_packet->helptext);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_ruleset_base(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_BASE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_BASE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_BASE] = variant;
}

struct packet_ruleset_base *receive_packet_ruleset_base(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_ruleset_base at the server.");
  }
  ensure_valid_variant_packet_ruleset_base(pc);

  switch(pc->phs.variant[PACKET_RULESET_BASE]) {
  case 100:
    return receive_packet_ruleset_base_100(pc, type);
  default:
    log_debug("Unknown PACKET_RULESET_BASE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_base(struct connection *pc, const struct packet_ruleset_base *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_base from the client.");
  }
  ensure_valid_variant_packet_ruleset_base(pc);

  switch(pc->phs.variant[PACKET_RULESET_BASE]) {

  case 100:
    return send_packet_ruleset_base_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_BASE variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_base(struct conn_list *dest, const struct packet_ruleset_base *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_base(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_control_100 hash_const

#define cmp_packet_ruleset_control_100 cmp_const

BV_DEFINE(packet_ruleset_control_100_fields, 14);

static struct packet_ruleset_control *receive_packet_ruleset_control_100(struct connection *pc, enum packet_type type)
{
  packet_ruleset_control_100_fields fields;
  struct packet_ruleset_control *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_ruleset_control, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_control_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_control_100, cmp_packet_ruleset_control_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'num_unit_classes'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->num_unit_classes = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'num_unit_types'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->num_unit_types = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'num_impr_types'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->num_impr_types = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'num_tech_types'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->num_tech_types = readin;
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'num_base_types'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->num_base_types = readin;
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'government_count'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->government_count = readin;
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'nation_count'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->nation_count = readin;
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'styles_count'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->styles_count = readin;
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'terrain_count'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->terrain_count = readin;
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'resource_count'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->resource_count = readin;
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'num_specialist_types'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->num_specialist_types = readin;
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'prefered_tileset'");
    dio_get_string(&din, real_packet->prefered_tileset, sizeof(real_packet->prefered_tileset));
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'name'");
    dio_get_string(&din, real_packet->name, sizeof(real_packet->name));
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'description'");
    dio_get_string(&din, real_packet->description, sizeof(real_packet->description));
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_control_100(struct connection *pc, const struct packet_ruleset_control *packet)
{
  const struct packet_ruleset_control *real_packet = packet;
  packet_ruleset_control_100_fields fields;
  struct packet_ruleset_control *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_CONTROL;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_CONTROL);

  log_packet_detailed("packet_ruleset_control_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_control_100, cmp_packet_ruleset_control_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->num_unit_classes != real_packet->num_unit_classes);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->num_unit_types != real_packet->num_unit_types);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->num_impr_types != real_packet->num_impr_types);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->num_tech_types != real_packet->num_tech_types);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->num_base_types != real_packet->num_base_types);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->government_count != real_packet->government_count);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->nation_count != real_packet->nation_count);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (old->styles_count != real_packet->styles_count);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->terrain_count != real_packet->terrain_count);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->resource_count != real_packet->resource_count);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->num_specialist_types != real_packet->num_specialist_types);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (strcmp(old->prefered_tileset, real_packet->prefered_tileset) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = (strcmp(old->description, real_packet->description) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'num_unit_classes' has changed");
    dio_put_uint16(&dout, real_packet->num_unit_classes);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'num_unit_types' has changed");
    dio_put_uint16(&dout, real_packet->num_unit_types);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'num_impr_types' has changed");
    dio_put_uint16(&dout, real_packet->num_impr_types);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'num_tech_types' has changed");
    dio_put_uint16(&dout, real_packet->num_tech_types);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'num_base_types' has changed");
    dio_put_uint16(&dout, real_packet->num_base_types);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'government_count' has changed");
    dio_put_uint16(&dout, real_packet->government_count);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'nation_count' has changed");
    dio_put_uint16(&dout, real_packet->nation_count);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'styles_count' has changed");
    dio_put_uint16(&dout, real_packet->styles_count);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'terrain_count' has changed");
    dio_put_uint16(&dout, real_packet->terrain_count);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'resource_count' has changed");
    dio_put_uint16(&dout, real_packet->resource_count);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'num_specialist_types' has changed");
    dio_put_uint16(&dout, real_packet->num_specialist_types);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'prefered_tileset' has changed");
    dio_put_string(&dout, real_packet->prefered_tileset);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'description' has changed");
    dio_put_string(&dout, real_packet->description);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_ruleset_control(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_CONTROL] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_CONTROL variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_CONTROL] = variant;
}

struct packet_ruleset_control *receive_packet_ruleset_control(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_ruleset_control at the server.");
  }
  ensure_valid_variant_packet_ruleset_control(pc);

  switch(pc->phs.variant[PACKET_RULESET_CONTROL]) {
  case 100:
    return receive_packet_ruleset_control_100(pc, type);
  default:
    log_debug("Unknown PACKET_RULESET_CONTROL variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_control(struct connection *pc, const struct packet_ruleset_control *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_control from the client.");
  }
  ensure_valid_variant_packet_ruleset_control(pc);

  switch(pc->phs.variant[PACKET_RULESET_CONTROL]) {

  case 100:
    return send_packet_ruleset_control_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_CONTROL variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_control(struct conn_list *dest, const struct packet_ruleset_control *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_control(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_single_want_hack_req_100 hash_const

#define cmp_packet_single_want_hack_req_100 cmp_const

BV_DEFINE(packet_single_want_hack_req_100_fields, 1);

static struct packet_single_want_hack_req *receive_packet_single_want_hack_req_100(struct connection *pc, enum packet_type type)
{
  packet_single_want_hack_req_100_fields fields;
  struct packet_single_want_hack_req *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_single_want_hack_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_single_want_hack_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_single_want_hack_req_100, cmp_packet_single_want_hack_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'token'");
    dio_get_string(&din, real_packet->token, sizeof(real_packet->token));
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_single_want_hack_req_100(struct connection *pc, const struct packet_single_want_hack_req *packet)
{
  const struct packet_single_want_hack_req *real_packet = packet;
  packet_single_want_hack_req_100_fields fields;
  struct packet_single_want_hack_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SINGLE_WANT_HACK_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_SINGLE_WANT_HACK_REQ);

  log_packet_detailed("packet_single_want_hack_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_single_want_hack_req_100, cmp_packet_single_want_hack_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->token, real_packet->token) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'token' has changed");
    dio_put_string(&dout, real_packet->token);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_single_want_hack_req(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_SINGLE_WANT_HACK_REQ] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_SINGLE_WANT_HACK_REQ variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_SINGLE_WANT_HACK_REQ] = variant;
}

struct packet_single_want_hack_req *receive_packet_single_want_hack_req(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_error("Receiving packet_single_want_hack_req at the client.");
  }
  ensure_valid_variant_packet_single_want_hack_req(pc);

  switch(pc->phs.variant[PACKET_SINGLE_WANT_HACK_REQ]) {
  case 100:
    return receive_packet_single_want_hack_req_100(pc, type);
  default:
    log_debug("Unknown PACKET_SINGLE_WANT_HACK_REQ variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_single_want_hack_req(struct connection *pc, const struct packet_single_want_hack_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_single_want_hack_req from the server.");
  }
  ensure_valid_variant_packet_single_want_hack_req(pc);

  switch(pc->phs.variant[PACKET_SINGLE_WANT_HACK_REQ]) {

  case 100:
    return send_packet_single_want_hack_req_100(pc, packet);
  default:
    log_debug("Unknown PACKET_SINGLE_WANT_HACK_REQ variant for connection %s", conn_description(pc));
    return -1;
  }
}
#define hash_packet_single_want_hack_reply_100 hash_const

#define cmp_packet_single_want_hack_reply_100 cmp_const

BV_DEFINE(packet_single_want_hack_reply_100_fields, 1);

static struct packet_single_want_hack_reply *receive_packet_single_want_hack_reply_100(struct connection *pc, enum packet_type type)
{
  packet_single_want_hack_reply_100_fields fields;
  struct packet_single_want_hack_reply *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_single_want_hack_reply, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_single_want_hack_reply_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_single_want_hack_reply_100, cmp_packet_single_want_hack_reply_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  real_packet->you_have_hack = BV_ISSET(fields, 0);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_single_want_hack_reply_100(struct connection *pc, const struct packet_single_want_hack_reply *packet)
{
  const struct packet_single_want_hack_reply *real_packet = packet;
  packet_single_want_hack_reply_100_fields fields;
  struct packet_single_want_hack_reply *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SINGLE_WANT_HACK_REPLY;
  int different = 0;
  SEND_PACKET_START(PACKET_SINGLE_WANT_HACK_REPLY);

  log_packet_detailed("packet_single_want_hack_reply_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_single_want_hack_reply_100, cmp_packet_single_want_hack_reply_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->you_have_hack != real_packet->you_have_hack);
  if(differ) {
    different++;
  }
  if (packet->you_have_hack) {
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  /* field 0 is folded into the header */

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_single_want_hack_reply(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_SINGLE_WANT_HACK_REPLY] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_SINGLE_WANT_HACK_REPLY variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_SINGLE_WANT_HACK_REPLY] = variant;
}

struct packet_single_want_hack_reply *receive_packet_single_want_hack_reply(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_single_want_hack_reply at the server.");
  }
  ensure_valid_variant_packet_single_want_hack_reply(pc);

  switch(pc->phs.variant[PACKET_SINGLE_WANT_HACK_REPLY]) {
  case 100:
    return receive_packet_single_want_hack_reply_100(pc, type);
  default:
    log_debug("Unknown PACKET_SINGLE_WANT_HACK_REPLY variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_single_want_hack_reply(struct connection *pc, const struct packet_single_want_hack_reply *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_single_want_hack_reply from the client.");
  }
  ensure_valid_variant_packet_single_want_hack_reply(pc);

  switch(pc->phs.variant[PACKET_SINGLE_WANT_HACK_REPLY]) {

  case 100:
    return send_packet_single_want_hack_reply_100(pc, packet);
  default:
    log_debug("Unknown PACKET_SINGLE_WANT_HACK_REPLY variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_single_want_hack_reply(struct connection *pc, bool you_have_hack)
{
  struct packet_single_want_hack_reply packet, *real_packet = &packet;

  real_packet->you_have_hack = you_have_hack;
  
  return send_packet_single_want_hack_reply(pc, real_packet);
}

#define hash_packet_ruleset_choices_100 hash_const

#define cmp_packet_ruleset_choices_100 cmp_const

BV_DEFINE(packet_ruleset_choices_100_fields, 2);

static struct packet_ruleset_choices *receive_packet_ruleset_choices_100(struct connection *pc, enum packet_type type)
{
  packet_ruleset_choices_100_fields fields;
  struct packet_ruleset_choices *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_ruleset_choices, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_choices_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_choices_100, cmp_packet_ruleset_choices_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'ruleset_count'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->ruleset_count = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'rulesets'");
    
    {
      int i;
    
      if(real_packet->ruleset_count > MAX_NUM_RULESETS) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->ruleset_count = MAX_NUM_RULESETS;
      }
      for (i = 0; i < real_packet->ruleset_count; i++) {
        dio_get_string(&din, real_packet->rulesets[i], sizeof(real_packet->rulesets[i]));
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_choices_100(struct connection *pc, const struct packet_ruleset_choices *packet)
{
  const struct packet_ruleset_choices *real_packet = packet;
  packet_ruleset_choices_100_fields fields;
  struct packet_ruleset_choices *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_CHOICES;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_CHOICES);

  log_packet_detailed("packet_ruleset_choices_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_choices_100, cmp_packet_ruleset_choices_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->ruleset_count != real_packet->ruleset_count);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


    {
      differ = (old->ruleset_count != real_packet->ruleset_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->ruleset_count; i++) {
          if (strcmp(old->rulesets[i], real_packet->rulesets[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'ruleset_count' has changed");
    dio_put_uint8(&dout, real_packet->ruleset_count);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'rulesets' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->ruleset_count; i++) {
        dio_put_string(&dout, real_packet->rulesets[i]);
      }
    } 
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_ruleset_choices(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_CHOICES] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_CHOICES variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_CHOICES] = variant;
}

struct packet_ruleset_choices *receive_packet_ruleset_choices(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_ruleset_choices at the server.");
  }
  ensure_valid_variant_packet_ruleset_choices(pc);

  switch(pc->phs.variant[PACKET_RULESET_CHOICES]) {
  case 100:
    return receive_packet_ruleset_choices_100(pc, type);
  default:
    log_debug("Unknown PACKET_RULESET_CHOICES variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_choices(struct connection *pc, const struct packet_ruleset_choices *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_choices from the client.");
  }
  ensure_valid_variant_packet_ruleset_choices(pc);

  switch(pc->phs.variant[PACKET_RULESET_CHOICES]) {

  case 100:
    return send_packet_ruleset_choices_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_CHOICES variant for connection %s", conn_description(pc));
    return -1;
  }
}
#define hash_packet_game_load_100 hash_const

#define cmp_packet_game_load_100 cmp_const

BV_DEFINE(packet_game_load_100_fields, 2);

static struct packet_game_load *receive_packet_game_load_100(struct connection *pc, enum packet_type type)
{
  packet_game_load_100_fields fields;
  struct packet_game_load *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_game_load, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_game_load_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_game_load_100, cmp_packet_game_load_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  real_packet->load_successful = BV_ISSET(fields, 0);
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'load_filename'");
    dio_get_string(&din, real_packet->load_filename, sizeof(real_packet->load_filename));
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_game_load_100(struct connection *pc, const struct packet_game_load *packet)
{
  const struct packet_game_load *real_packet = packet;
  packet_game_load_100_fields fields;
  struct packet_game_load *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_GAME_LOAD;
  int different = 0;
  SEND_PACKET_START(PACKET_GAME_LOAD);

  log_packet_detailed("packet_game_load_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_game_load_100, cmp_packet_game_load_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->load_successful != real_packet->load_successful);
  if(differ) {
    different++;
  }
  if (packet->load_successful) {
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->load_filename, real_packet->load_filename) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  /* field 0 is folded into the header */
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'load_filename' has changed");
    dio_put_string(&dout, real_packet->load_filename);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_game_load(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_GAME_LOAD] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_GAME_LOAD variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_GAME_LOAD] = variant;
}

struct packet_game_load *receive_packet_game_load(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_game_load at the server.");
  }
  ensure_valid_variant_packet_game_load(pc);

  switch(pc->phs.variant[PACKET_GAME_LOAD]) {
  case 100:
    return receive_packet_game_load_100(pc, type);
  default:
    log_debug("Unknown PACKET_GAME_LOAD variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_game_load(struct connection *pc, const struct packet_game_load *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_game_load from the client.");
  }
  ensure_valid_variant_packet_game_load(pc);

  switch(pc->phs.variant[PACKET_GAME_LOAD]) {

  case 100:
    return send_packet_game_load_100(pc, packet);
  default:
    log_debug("Unknown PACKET_GAME_LOAD variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_game_load(struct conn_list *dest, const struct packet_game_load *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_game_load(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_game_load(struct connection *pc, bool load_successful, const char *load_filename)
{
  struct packet_game_load packet, *real_packet = &packet;

  real_packet->load_successful = load_successful;
  sz_strlcpy(real_packet->load_filename, load_filename);
  
  return send_packet_game_load(pc, real_packet);
}

void dlsend_packet_game_load(struct conn_list *dest, bool load_successful, const char *load_filename)
{
  struct packet_game_load packet, *real_packet = &packet;

  real_packet->load_successful = load_successful;
  sz_strlcpy(real_packet->load_filename, load_filename);
  
  lsend_packet_game_load(dest, real_packet);
}

#define hash_packet_server_setting_control_100 hash_const

#define cmp_packet_server_setting_control_100 cmp_const

BV_DEFINE(packet_server_setting_control_100_fields, 3);

static struct packet_server_setting_control *receive_packet_server_setting_control_100(struct connection *pc, enum packet_type type)
{
  packet_server_setting_control_100_fields fields;
  struct packet_server_setting_control *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_server_setting_control, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_server_setting_control_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_server_setting_control_100, cmp_packet_server_setting_control_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'settings_num'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->settings_num = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'categories_num'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->categories_num = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'category_names'");
    
    {
      int i;
    
      if(real_packet->categories_num > 256) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->categories_num = 256;
      }
      for (i = 0; i < real_packet->categories_num; i++) {
        dio_get_string(&din, real_packet->category_names[i], sizeof(real_packet->category_names[i]));
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_server_setting_control_100(struct connection *pc, const struct packet_server_setting_control *packet)
{
  const struct packet_server_setting_control *real_packet = packet;
  packet_server_setting_control_100_fields fields;
  struct packet_server_setting_control *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SERVER_SETTING_CONTROL;
  int different = 0;
  SEND_PACKET_START(PACKET_SERVER_SETTING_CONTROL);

  log_packet_detailed("packet_server_setting_control_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_server_setting_control_100, cmp_packet_server_setting_control_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->settings_num != real_packet->settings_num);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->categories_num != real_packet->categories_num);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


    {
      differ = (old->categories_num != real_packet->categories_num);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->categories_num; i++) {
          if (strcmp(old->category_names[i], real_packet->category_names[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'settings_num' has changed");
    dio_put_uint16(&dout, real_packet->settings_num);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'categories_num' has changed");
    dio_put_uint8(&dout, real_packet->categories_num);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'category_names' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->categories_num; i++) {
        dio_put_string(&dout, real_packet->category_names[i]);
      }
    } 
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_server_setting_control(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_SERVER_SETTING_CONTROL] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_SERVER_SETTING_CONTROL variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_SERVER_SETTING_CONTROL] = variant;
}

struct packet_server_setting_control *receive_packet_server_setting_control(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_server_setting_control at the server.");
  }
  ensure_valid_variant_packet_server_setting_control(pc);

  switch(pc->phs.variant[PACKET_SERVER_SETTING_CONTROL]) {
  case 100:
    return receive_packet_server_setting_control_100(pc, type);
  default:
    log_debug("Unknown PACKET_SERVER_SETTING_CONTROL variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_server_setting_control(struct connection *pc, const struct packet_server_setting_control *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_server_setting_control from the client.");
  }
  ensure_valid_variant_packet_server_setting_control(pc);

  switch(pc->phs.variant[PACKET_SERVER_SETTING_CONTROL]) {

  case 100:
    return send_packet_server_setting_control_100(pc, packet);
  default:
    log_debug("Unknown PACKET_SERVER_SETTING_CONTROL variant for connection %s", conn_description(pc));
    return -1;
  }
}
static genhash_val_t hash_packet_server_setting_const_100(const void *vkey, size_t num_buckets)
{
  const struct packet_server_setting_const *key = (const struct packet_server_setting_const *) vkey;

  return ((key->id) % num_buckets);
}

static bool cmp_packet_server_setting_const_100(const void *vkey1, const void *vkey2)
{
  const struct packet_server_setting_const *key1 = (const struct packet_server_setting_const *) vkey1;
  const struct packet_server_setting_const *key2 = (const struct packet_server_setting_const *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_server_setting_const_100_fields, 4);

static struct packet_server_setting_const *receive_packet_server_setting_const_100(struct connection *pc, enum packet_type type)
{
  packet_server_setting_const_100_fields fields;
  struct packet_server_setting_const *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_server_setting_const, real_packet);

  DIO_BV_GET(&din, fields);
  {
    int readin;
  
    dio_get_uint16(&din, &readin);
    real_packet->id = readin;
  }

  log_packet_detailed("packet_server_setting_const_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_server_setting_const_100, cmp_packet_server_setting_const_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'name'");
    dio_get_string(&din, real_packet->name, sizeof(real_packet->name));
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'short_help'");
    dio_get_string(&din, real_packet->short_help, sizeof(real_packet->short_help));
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'extra_help'");
    dio_get_string(&din, real_packet->extra_help, sizeof(real_packet->extra_help));
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'category'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->category = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_server_setting_const_100(struct connection *pc, const struct packet_server_setting_const *packet)
{
  const struct packet_server_setting_const *real_packet = packet;
  packet_server_setting_const_100_fields fields;
  struct packet_server_setting_const *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SERVER_SETTING_CONST;
  int different = 0;
  SEND_PACKET_START(PACKET_SERVER_SETTING_CONST);

  log_packet_detailed("packet_server_setting_const_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_server_setting_const_100, cmp_packet_server_setting_const_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->short_help, real_packet->short_help) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->extra_help, real_packet->extra_help) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->category != real_packet->category);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, fields);
  dio_put_uint16(&dout, real_packet->id);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'short_help' has changed");
    dio_put_string(&dout, real_packet->short_help);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'extra_help' has changed");
    dio_put_string(&dout, real_packet->extra_help);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'category' has changed");
    dio_put_uint8(&dout, real_packet->category);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_server_setting_const(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_SERVER_SETTING_CONST] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_SERVER_SETTING_CONST variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_SERVER_SETTING_CONST] = variant;
}

struct packet_server_setting_const *receive_packet_server_setting_const(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_server_setting_const at the server.");
  }
  ensure_valid_variant_packet_server_setting_const(pc);

  switch(pc->phs.variant[PACKET_SERVER_SETTING_CONST]) {
  case 100:
    return receive_packet_server_setting_const_100(pc, type);
  default:
    log_debug("Unknown PACKET_SERVER_SETTING_CONST variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_server_setting_const(struct connection *pc, const struct packet_server_setting_const *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_server_setting_const from the client.");
  }
  ensure_valid_variant_packet_server_setting_const(pc);

  switch(pc->phs.variant[PACKET_SERVER_SETTING_CONST]) {

  case 100:
    return send_packet_server_setting_const_100(pc, packet);
  default:
    log_debug("Unknown PACKET_SERVER_SETTING_CONST variant for connection %s", conn_description(pc));
    return -1;
  }
}
static genhash_val_t hash_packet_server_setting_bool_100(const void *vkey, size_t num_buckets)
{
  const struct packet_server_setting_bool *key = (const struct packet_server_setting_bool *) vkey;

  return ((key->id) % num_buckets);
}

static bool cmp_packet_server_setting_bool_100(const void *vkey1, const void *vkey2)
{
  const struct packet_server_setting_bool *key1 = (const struct packet_server_setting_bool *) vkey1;
  const struct packet_server_setting_bool *key2 = (const struct packet_server_setting_bool *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_server_setting_bool_100_fields, 5);

static struct packet_server_setting_bool *receive_packet_server_setting_bool_100(struct connection *pc, enum packet_type type)
{
  packet_server_setting_bool_100_fields fields;
  struct packet_server_setting_bool *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_server_setting_bool, real_packet);

  DIO_BV_GET(&din, fields);
  {
    int readin;
  
    dio_get_uint16(&din, &readin);
    real_packet->id = readin;
  }

  log_packet_detailed("packet_server_setting_bool_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_server_setting_bool_100, cmp_packet_server_setting_bool_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  real_packet->is_visible = BV_ISSET(fields, 0);
  real_packet->is_changeable = BV_ISSET(fields, 1);
  real_packet->initial_setting = BV_ISSET(fields, 2);
  real_packet->val = BV_ISSET(fields, 3);
  real_packet->default_val = BV_ISSET(fields, 4);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_server_setting_bool_100(struct connection *pc, const struct packet_server_setting_bool *packet)
{
  const struct packet_server_setting_bool *real_packet = packet;
  packet_server_setting_bool_100_fields fields;
  struct packet_server_setting_bool *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SERVER_SETTING_BOOL;
  int different = 0;
  SEND_PACKET_START(PACKET_SERVER_SETTING_BOOL);

  log_packet_detailed("packet_server_setting_bool_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_server_setting_bool_100, cmp_packet_server_setting_bool_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->is_visible != real_packet->is_visible);
  if(differ) {
    different++;
  }
  if (packet->is_visible) {
    BV_SET(fields, 0);
  }

  differ = (old->is_changeable != real_packet->is_changeable);
  if(differ) {
    different++;
  }
  if (packet->is_changeable) {
    BV_SET(fields, 1);
  }

  differ = (old->initial_setting != real_packet->initial_setting);
  if(differ) {
    different++;
  }
  if (packet->initial_setting) {
    BV_SET(fields, 2);
  }

  differ = (old->val != real_packet->val);
  if(differ) {
    different++;
  }
  if (packet->val) {
    BV_SET(fields, 3);
  }

  differ = (old->default_val != real_packet->default_val);
  if(differ) {
    different++;
  }
  if (packet->default_val) {
    BV_SET(fields, 4);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, fields);
  dio_put_uint16(&dout, real_packet->id);

  /* field 0 is folded into the header */
  /* field 1 is folded into the header */
  /* field 2 is folded into the header */
  /* field 3 is folded into the header */
  /* field 4 is folded into the header */

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_server_setting_bool(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_SERVER_SETTING_BOOL] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_SERVER_SETTING_BOOL variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_SERVER_SETTING_BOOL] = variant;
}

struct packet_server_setting_bool *receive_packet_server_setting_bool(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_server_setting_bool at the server.");
  }
  ensure_valid_variant_packet_server_setting_bool(pc);

  switch(pc->phs.variant[PACKET_SERVER_SETTING_BOOL]) {
  case 100:
    return receive_packet_server_setting_bool_100(pc, type);
  default:
    log_debug("Unknown PACKET_SERVER_SETTING_BOOL variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_server_setting_bool(struct connection *pc, const struct packet_server_setting_bool *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_server_setting_bool from the client.");
  }
  ensure_valid_variant_packet_server_setting_bool(pc);

  switch(pc->phs.variant[PACKET_SERVER_SETTING_BOOL]) {

  case 100:
    return send_packet_server_setting_bool_100(pc, packet);
  default:
    log_debug("Unknown PACKET_SERVER_SETTING_BOOL variant for connection %s", conn_description(pc));
    return -1;
  }
}
static genhash_val_t hash_packet_server_setting_int_100(const void *vkey, size_t num_buckets)
{
  const struct packet_server_setting_int *key = (const struct packet_server_setting_int *) vkey;

  return ((key->id) % num_buckets);
}

static bool cmp_packet_server_setting_int_100(const void *vkey1, const void *vkey2)
{
  const struct packet_server_setting_int *key1 = (const struct packet_server_setting_int *) vkey1;
  const struct packet_server_setting_int *key2 = (const struct packet_server_setting_int *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_server_setting_int_100_fields, 7);

static struct packet_server_setting_int *receive_packet_server_setting_int_100(struct connection *pc, enum packet_type type)
{
  packet_server_setting_int_100_fields fields;
  struct packet_server_setting_int *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_server_setting_int, real_packet);

  DIO_BV_GET(&din, fields);
  {
    int readin;
  
    dio_get_uint16(&din, &readin);
    real_packet->id = readin;
  }

  log_packet_detailed("packet_server_setting_int_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_server_setting_int_100, cmp_packet_server_setting_int_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  real_packet->is_visible = BV_ISSET(fields, 0);
  real_packet->is_changeable = BV_ISSET(fields, 1);
  real_packet->initial_setting = BV_ISSET(fields, 2);
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'val'");
    {
      int readin;
    
      dio_get_sint32(&din, &readin);
      real_packet->val = readin;
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'default_val'");
    {
      int readin;
    
      dio_get_sint32(&din, &readin);
      real_packet->default_val = readin;
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'min_val'");
    {
      int readin;
    
      dio_get_sint32(&din, &readin);
      real_packet->min_val = readin;
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'max_val'");
    {
      int readin;
    
      dio_get_sint32(&din, &readin);
      real_packet->max_val = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_server_setting_int_100(struct connection *pc, const struct packet_server_setting_int *packet)
{
  const struct packet_server_setting_int *real_packet = packet;
  packet_server_setting_int_100_fields fields;
  struct packet_server_setting_int *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SERVER_SETTING_INT;
  int different = 0;
  SEND_PACKET_START(PACKET_SERVER_SETTING_INT);

  log_packet_detailed("packet_server_setting_int_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_server_setting_int_100, cmp_packet_server_setting_int_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->is_visible != real_packet->is_visible);
  if(differ) {
    different++;
  }
  if (packet->is_visible) {
    BV_SET(fields, 0);
  }

  differ = (old->is_changeable != real_packet->is_changeable);
  if(differ) {
    different++;
  }
  if (packet->is_changeable) {
    BV_SET(fields, 1);
  }

  differ = (old->initial_setting != real_packet->initial_setting);
  if(differ) {
    different++;
  }
  if (packet->initial_setting) {
    BV_SET(fields, 2);
  }

  differ = (old->val != real_packet->val);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->default_val != real_packet->default_val);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->min_val != real_packet->min_val);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->max_val != real_packet->max_val);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, fields);
  dio_put_uint16(&dout, real_packet->id);

  /* field 0 is folded into the header */
  /* field 1 is folded into the header */
  /* field 2 is folded into the header */
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'val' has changed");
    dio_put_sint32(&dout, real_packet->val);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'default_val' has changed");
    dio_put_sint32(&dout, real_packet->default_val);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'min_val' has changed");
    dio_put_sint32(&dout, real_packet->min_val);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'max_val' has changed");
    dio_put_sint32(&dout, real_packet->max_val);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_server_setting_int(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_SERVER_SETTING_INT] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_SERVER_SETTING_INT variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_SERVER_SETTING_INT] = variant;
}

struct packet_server_setting_int *receive_packet_server_setting_int(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_server_setting_int at the server.");
  }
  ensure_valid_variant_packet_server_setting_int(pc);

  switch(pc->phs.variant[PACKET_SERVER_SETTING_INT]) {
  case 100:
    return receive_packet_server_setting_int_100(pc, type);
  default:
    log_debug("Unknown PACKET_SERVER_SETTING_INT variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_server_setting_int(struct connection *pc, const struct packet_server_setting_int *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_server_setting_int from the client.");
  }
  ensure_valid_variant_packet_server_setting_int(pc);

  switch(pc->phs.variant[PACKET_SERVER_SETTING_INT]) {

  case 100:
    return send_packet_server_setting_int_100(pc, packet);
  default:
    log_debug("Unknown PACKET_SERVER_SETTING_INT variant for connection %s", conn_description(pc));
    return -1;
  }
}
static genhash_val_t hash_packet_server_setting_str_100(const void *vkey, size_t num_buckets)
{
  const struct packet_server_setting_str *key = (const struct packet_server_setting_str *) vkey;

  return ((key->id) % num_buckets);
}

static bool cmp_packet_server_setting_str_100(const void *vkey1, const void *vkey2)
{
  const struct packet_server_setting_str *key1 = (const struct packet_server_setting_str *) vkey1;
  const struct packet_server_setting_str *key2 = (const struct packet_server_setting_str *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_server_setting_str_100_fields, 5);

static struct packet_server_setting_str *receive_packet_server_setting_str_100(struct connection *pc, enum packet_type type)
{
  packet_server_setting_str_100_fields fields;
  struct packet_server_setting_str *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_server_setting_str, real_packet);

  DIO_BV_GET(&din, fields);
  {
    int readin;
  
    dio_get_uint16(&din, &readin);
    real_packet->id = readin;
  }

  log_packet_detailed("packet_server_setting_str_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_server_setting_str_100, cmp_packet_server_setting_str_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  real_packet->is_visible = BV_ISSET(fields, 0);
  real_packet->is_changeable = BV_ISSET(fields, 1);
  real_packet->initial_setting = BV_ISSET(fields, 2);
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'val'");
    dio_get_string(&din, real_packet->val, sizeof(real_packet->val));
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'default_val'");
    dio_get_string(&din, real_packet->default_val, sizeof(real_packet->default_val));
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_server_setting_str_100(struct connection *pc, const struct packet_server_setting_str *packet)
{
  const struct packet_server_setting_str *real_packet = packet;
  packet_server_setting_str_100_fields fields;
  struct packet_server_setting_str *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SERVER_SETTING_STR;
  int different = 0;
  SEND_PACKET_START(PACKET_SERVER_SETTING_STR);

  log_packet_detailed("packet_server_setting_str_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_server_setting_str_100, cmp_packet_server_setting_str_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->is_visible != real_packet->is_visible);
  if(differ) {
    different++;
  }
  if (packet->is_visible) {
    BV_SET(fields, 0);
  }

  differ = (old->is_changeable != real_packet->is_changeable);
  if(differ) {
    different++;
  }
  if (packet->is_changeable) {
    BV_SET(fields, 1);
  }

  differ = (old->initial_setting != real_packet->initial_setting);
  if(differ) {
    different++;
  }
  if (packet->initial_setting) {
    BV_SET(fields, 2);
  }

  differ = (strcmp(old->val, real_packet->val) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (strcmp(old->default_val, real_packet->default_val) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, fields);
  dio_put_uint16(&dout, real_packet->id);

  /* field 0 is folded into the header */
  /* field 1 is folded into the header */
  /* field 2 is folded into the header */
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'val' has changed");
    dio_put_string(&dout, real_packet->val);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'default_val' has changed");
    dio_put_string(&dout, real_packet->default_val);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_server_setting_str(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_SERVER_SETTING_STR] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_SERVER_SETTING_STR variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_SERVER_SETTING_STR] = variant;
}

struct packet_server_setting_str *receive_packet_server_setting_str(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_server_setting_str at the server.");
  }
  ensure_valid_variant_packet_server_setting_str(pc);

  switch(pc->phs.variant[PACKET_SERVER_SETTING_STR]) {
  case 100:
    return receive_packet_server_setting_str_100(pc, type);
  default:
    log_debug("Unknown PACKET_SERVER_SETTING_STR variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_server_setting_str(struct connection *pc, const struct packet_server_setting_str *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_server_setting_str from the client.");
  }
  ensure_valid_variant_packet_server_setting_str(pc);

  switch(pc->phs.variant[PACKET_SERVER_SETTING_STR]) {

  case 100:
    return send_packet_server_setting_str_100(pc, packet);
  default:
    log_debug("Unknown PACKET_SERVER_SETTING_STR variant for connection %s", conn_description(pc));
    return -1;
  }
}
static genhash_val_t hash_packet_server_setting_enum_100(const void *vkey, size_t num_buckets)
{
  const struct packet_server_setting_enum *key = (const struct packet_server_setting_enum *) vkey;

  return ((key->id) % num_buckets);
}

static bool cmp_packet_server_setting_enum_100(const void *vkey1, const void *vkey2)
{
  const struct packet_server_setting_enum *key1 = (const struct packet_server_setting_enum *) vkey1;
  const struct packet_server_setting_enum *key2 = (const struct packet_server_setting_enum *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_server_setting_enum_100_fields, 8);

static struct packet_server_setting_enum *receive_packet_server_setting_enum_100(struct connection *pc, enum packet_type type)
{
  packet_server_setting_enum_100_fields fields;
  struct packet_server_setting_enum *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_server_setting_enum, real_packet);

  DIO_BV_GET(&din, fields);
  {
    int readin;
  
    dio_get_uint16(&din, &readin);
    real_packet->id = readin;
  }

  log_packet_detailed("packet_server_setting_enum_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_server_setting_enum_100, cmp_packet_server_setting_enum_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  real_packet->is_visible = BV_ISSET(fields, 0);
  real_packet->is_changeable = BV_ISSET(fields, 1);
  real_packet->initial_setting = BV_ISSET(fields, 2);
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'val'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->val = readin;
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'default_val'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->default_val = readin;
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'values_num'");
    {
      int readin;
    
      dio_get_sint8(&din, &readin);
      real_packet->values_num = readin;
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'support_names'");
    
    {
      int i;
    
      if(real_packet->values_num > 64) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->values_num = 64;
      }
      for (i = 0; i < real_packet->values_num; i++) {
        dio_get_string(&din, real_packet->support_names[i], sizeof(real_packet->support_names[i]));
      }
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'pretty_names'");
    
    {
      int i;
    
      if(real_packet->values_num > 64) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->values_num = 64;
      }
      for (i = 0; i < real_packet->values_num; i++) {
        dio_get_string(&din, real_packet->pretty_names[i], sizeof(real_packet->pretty_names[i]));
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_server_setting_enum_100(struct connection *pc, const struct packet_server_setting_enum *packet)
{
  const struct packet_server_setting_enum *real_packet = packet;
  packet_server_setting_enum_100_fields fields;
  struct packet_server_setting_enum *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SERVER_SETTING_ENUM;
  int different = 0;
  SEND_PACKET_START(PACKET_SERVER_SETTING_ENUM);

  log_packet_detailed("packet_server_setting_enum_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_server_setting_enum_100, cmp_packet_server_setting_enum_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->is_visible != real_packet->is_visible);
  if(differ) {
    different++;
  }
  if (packet->is_visible) {
    BV_SET(fields, 0);
  }

  differ = (old->is_changeable != real_packet->is_changeable);
  if(differ) {
    different++;
  }
  if (packet->is_changeable) {
    BV_SET(fields, 1);
  }

  differ = (old->initial_setting != real_packet->initial_setting);
  if(differ) {
    different++;
  }
  if (packet->initial_setting) {
    BV_SET(fields, 2);
  }

  differ = (old->val != real_packet->val);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->default_val != real_packet->default_val);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->values_num != real_packet->values_num);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


    {
      differ = (old->values_num != real_packet->values_num);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->values_num; i++) {
          if (strcmp(old->support_names[i], real_packet->support_names[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }


    {
      differ = (old->values_num != real_packet->values_num);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->values_num; i++) {
          if (strcmp(old->pretty_names[i], real_packet->pretty_names[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, fields);
  dio_put_uint16(&dout, real_packet->id);

  /* field 0 is folded into the header */
  /* field 1 is folded into the header */
  /* field 2 is folded into the header */
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'val' has changed");
    dio_put_sint8(&dout, real_packet->val);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'default_val' has changed");
    dio_put_sint8(&dout, real_packet->default_val);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'values_num' has changed");
    dio_put_sint8(&dout, real_packet->values_num);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'support_names' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->values_num; i++) {
        dio_put_string(&dout, real_packet->support_names[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'pretty_names' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->values_num; i++) {
        dio_put_string(&dout, real_packet->pretty_names[i]);
      }
    } 
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_server_setting_enum(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_SERVER_SETTING_ENUM] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_SERVER_SETTING_ENUM variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_SERVER_SETTING_ENUM] = variant;
}

struct packet_server_setting_enum *receive_packet_server_setting_enum(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_server_setting_enum at the server.");
  }
  ensure_valid_variant_packet_server_setting_enum(pc);

  switch(pc->phs.variant[PACKET_SERVER_SETTING_ENUM]) {
  case 100:
    return receive_packet_server_setting_enum_100(pc, type);
  default:
    log_debug("Unknown PACKET_SERVER_SETTING_ENUM variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_server_setting_enum(struct connection *pc, const struct packet_server_setting_enum *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_server_setting_enum from the client.");
  }
  ensure_valid_variant_packet_server_setting_enum(pc);

  switch(pc->phs.variant[PACKET_SERVER_SETTING_ENUM]) {

  case 100:
    return send_packet_server_setting_enum_100(pc, packet);
  default:
    log_debug("Unknown PACKET_SERVER_SETTING_ENUM variant for connection %s", conn_description(pc));
    return -1;
  }
}
static genhash_val_t hash_packet_server_setting_bitwise_100(const void *vkey, size_t num_buckets)
{
  const struct packet_server_setting_bitwise *key = (const struct packet_server_setting_bitwise *) vkey;

  return ((key->id) % num_buckets);
}

static bool cmp_packet_server_setting_bitwise_100(const void *vkey1, const void *vkey2)
{
  const struct packet_server_setting_bitwise *key1 = (const struct packet_server_setting_bitwise *) vkey1;
  const struct packet_server_setting_bitwise *key2 = (const struct packet_server_setting_bitwise *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_server_setting_bitwise_100_fields, 8);

static struct packet_server_setting_bitwise *receive_packet_server_setting_bitwise_100(struct connection *pc, enum packet_type type)
{
  packet_server_setting_bitwise_100_fields fields;
  struct packet_server_setting_bitwise *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_server_setting_bitwise, real_packet);

  DIO_BV_GET(&din, fields);
  {
    int readin;
  
    dio_get_uint16(&din, &readin);
    real_packet->id = readin;
  }

  log_packet_detailed("packet_server_setting_bitwise_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_server_setting_bitwise_100, cmp_packet_server_setting_bitwise_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  real_packet->is_visible = BV_ISSET(fields, 0);
  real_packet->is_changeable = BV_ISSET(fields, 1);
  real_packet->initial_setting = BV_ISSET(fields, 2);
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'val'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->val = readin;
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'default_val'");
    {
      int readin;
    
      dio_get_uint16(&din, &readin);
      real_packet->default_val = readin;
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'bits_num'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->bits_num = readin;
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'support_names'");
    
    {
      int i;
    
      if(real_packet->bits_num > 64) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->bits_num = 64;
      }
      for (i = 0; i < real_packet->bits_num; i++) {
        dio_get_string(&din, real_packet->support_names[i], sizeof(real_packet->support_names[i]));
      }
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'pretty_names'");
    
    {
      int i;
    
      if(real_packet->bits_num > 64) {
        log_error("packets_gen.c: WARNING: truncation array");
        real_packet->bits_num = 64;
      }
      for (i = 0; i < real_packet->bits_num; i++) {
        dio_get_string(&din, real_packet->pretty_names[i], sizeof(real_packet->pretty_names[i]));
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_server_setting_bitwise_100(struct connection *pc, const struct packet_server_setting_bitwise *packet)
{
  const struct packet_server_setting_bitwise *real_packet = packet;
  packet_server_setting_bitwise_100_fields fields;
  struct packet_server_setting_bitwise *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SERVER_SETTING_BITWISE;
  int different = 0;
  SEND_PACKET_START(PACKET_SERVER_SETTING_BITWISE);

  log_packet_detailed("packet_server_setting_bitwise_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_server_setting_bitwise_100, cmp_packet_server_setting_bitwise_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->is_visible != real_packet->is_visible);
  if(differ) {
    different++;
  }
  if (packet->is_visible) {
    BV_SET(fields, 0);
  }

  differ = (old->is_changeable != real_packet->is_changeable);
  if(differ) {
    different++;
  }
  if (packet->is_changeable) {
    BV_SET(fields, 1);
  }

  differ = (old->initial_setting != real_packet->initial_setting);
  if(differ) {
    different++;
  }
  if (packet->initial_setting) {
    BV_SET(fields, 2);
  }

  differ = (old->val != real_packet->val);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->default_val != real_packet->default_val);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->bits_num != real_packet->bits_num);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


    {
      differ = (old->bits_num != real_packet->bits_num);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->bits_num; i++) {
          if (strcmp(old->support_names[i], real_packet->support_names[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }


    {
      differ = (old->bits_num != real_packet->bits_num);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->bits_num; i++) {
          if (strcmp(old->pretty_names[i], real_packet->pretty_names[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, fields);
  dio_put_uint16(&dout, real_packet->id);

  /* field 0 is folded into the header */
  /* field 1 is folded into the header */
  /* field 2 is folded into the header */
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'val' has changed");
    dio_put_uint16(&dout, real_packet->val);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'default_val' has changed");
    dio_put_uint16(&dout, real_packet->default_val);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'bits_num' has changed");
    dio_put_uint8(&dout, real_packet->bits_num);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'support_names' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->bits_num; i++) {
        dio_put_string(&dout, real_packet->support_names[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'pretty_names' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->bits_num; i++) {
        dio_put_string(&dout, real_packet->pretty_names[i]);
      }
    } 
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_server_setting_bitwise(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_SERVER_SETTING_BITWISE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_SERVER_SETTING_BITWISE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_SERVER_SETTING_BITWISE] = variant;
}

struct packet_server_setting_bitwise *receive_packet_server_setting_bitwise(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_server_setting_bitwise at the server.");
  }
  ensure_valid_variant_packet_server_setting_bitwise(pc);

  switch(pc->phs.variant[PACKET_SERVER_SETTING_BITWISE]) {
  case 100:
    return receive_packet_server_setting_bitwise_100(pc, type);
  default:
    log_debug("Unknown PACKET_SERVER_SETTING_BITWISE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_server_setting_bitwise(struct connection *pc, const struct packet_server_setting_bitwise *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_server_setting_bitwise from the client.");
  }
  ensure_valid_variant_packet_server_setting_bitwise(pc);

  switch(pc->phs.variant[PACKET_SERVER_SETTING_BITWISE]) {

  case 100:
    return send_packet_server_setting_bitwise_100(pc, packet);
  default:
    log_debug("Unknown PACKET_SERVER_SETTING_BITWISE variant for connection %s", conn_description(pc));
    return -1;
  }
}
#define hash_packet_ruleset_effect_100 hash_const

#define cmp_packet_ruleset_effect_100 cmp_const

BV_DEFINE(packet_ruleset_effect_100_fields, 2);

static struct packet_ruleset_effect *receive_packet_ruleset_effect_100(struct connection *pc, enum packet_type type)
{
  packet_ruleset_effect_100_fields fields;
  struct packet_ruleset_effect *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_ruleset_effect, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_effect_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_effect_100, cmp_packet_ruleset_effect_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'effect_type'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->effect_type = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'effect_value'");
    {
      int readin;
    
      dio_get_sint32(&din, &readin);
      real_packet->effect_value = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_effect_100(struct connection *pc, const struct packet_ruleset_effect *packet)
{
  const struct packet_ruleset_effect *real_packet = packet;
  packet_ruleset_effect_100_fields fields;
  struct packet_ruleset_effect *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_EFFECT;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_EFFECT);

  log_packet_detailed("packet_ruleset_effect_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_effect_100, cmp_packet_ruleset_effect_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->effect_type != real_packet->effect_type);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->effect_value != real_packet->effect_value);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'effect_type' has changed");
    dio_put_uint8(&dout, real_packet->effect_type);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'effect_value' has changed");
    dio_put_sint32(&dout, real_packet->effect_value);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_ruleset_effect(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_EFFECT] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_EFFECT variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_EFFECT] = variant;
}

struct packet_ruleset_effect *receive_packet_ruleset_effect(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_ruleset_effect at the server.");
  }
  ensure_valid_variant_packet_ruleset_effect(pc);

  switch(pc->phs.variant[PACKET_RULESET_EFFECT]) {
  case 100:
    return receive_packet_ruleset_effect_100(pc, type);
  default:
    log_debug("Unknown PACKET_RULESET_EFFECT variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_effect(struct connection *pc, const struct packet_ruleset_effect *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_effect from the client.");
  }
  ensure_valid_variant_packet_ruleset_effect(pc);

  switch(pc->phs.variant[PACKET_RULESET_EFFECT]) {

  case 100:
    return send_packet_ruleset_effect_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_EFFECT variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_effect(struct conn_list *dest, const struct packet_ruleset_effect *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_effect(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_effect_req_100 hash_const

#define cmp_packet_ruleset_effect_req_100 cmp_const

BV_DEFINE(packet_ruleset_effect_req_100_fields, 7);

static struct packet_ruleset_effect_req *receive_packet_ruleset_effect_req_100(struct connection *pc, enum packet_type type)
{
  packet_ruleset_effect_req_100_fields fields;
  struct packet_ruleset_effect_req *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_ruleset_effect_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_effect_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_effect_req_100, cmp_packet_ruleset_effect_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'effect_id'");
    {
      int readin;
    
      dio_get_uint32(&din, &readin);
      real_packet->effect_id = readin;
    }
  }
  real_packet->neg = BV_ISSET(fields, 1);
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'source_type'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->source_type = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'source_value'");
    {
      int readin;
    
      dio_get_sint32(&din, &readin);
      real_packet->source_value = readin;
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'range'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->range = readin;
    }
  }
  real_packet->survives = BV_ISSET(fields, 5);
  real_packet->negated = BV_ISSET(fields, 6);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_effect_req_100(struct connection *pc, const struct packet_ruleset_effect_req *packet)
{
  const struct packet_ruleset_effect_req *real_packet = packet;
  packet_ruleset_effect_req_100_fields fields;
  struct packet_ruleset_effect_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_EFFECT_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_EFFECT_REQ);

  log_packet_detailed("packet_ruleset_effect_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_effect_req_100, cmp_packet_ruleset_effect_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->effect_id != real_packet->effect_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->neg != real_packet->neg);
  if(differ) {
    different++;
  }
  if (packet->neg) {
    BV_SET(fields, 1);
  }

  differ = (old->source_type != real_packet->source_type);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->source_value != real_packet->source_value);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->range != real_packet->range);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->survives != real_packet->survives);
  if(differ) {
    different++;
  }
  if (packet->survives) {
    BV_SET(fields, 5);
  }

  differ = (old->negated != real_packet->negated);
  if(differ) {
    different++;
  }
  if (packet->negated) {
    BV_SET(fields, 6);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'effect_id' has changed");
    dio_put_uint32(&dout, real_packet->effect_id);
  }
  /* field 1 is folded into the header */
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'source_type' has changed");
    dio_put_uint8(&dout, real_packet->source_type);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'source_value' has changed");
    dio_put_sint32(&dout, real_packet->source_value);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'range' has changed");
    dio_put_uint8(&dout, real_packet->range);
  }
  /* field 5 is folded into the header */
  /* field 6 is folded into the header */

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_ruleset_effect_req(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_EFFECT_REQ] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_EFFECT_REQ variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_EFFECT_REQ] = variant;
}

struct packet_ruleset_effect_req *receive_packet_ruleset_effect_req(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_ruleset_effect_req at the server.");
  }
  ensure_valid_variant_packet_ruleset_effect_req(pc);

  switch(pc->phs.variant[PACKET_RULESET_EFFECT_REQ]) {
  case 100:
    return receive_packet_ruleset_effect_req_100(pc, type);
  default:
    log_debug("Unknown PACKET_RULESET_EFFECT_REQ variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_effect_req(struct connection *pc, const struct packet_ruleset_effect_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_effect_req from the client.");
  }
  ensure_valid_variant_packet_ruleset_effect_req(pc);

  switch(pc->phs.variant[PACKET_RULESET_EFFECT_REQ]) {

  case 100:
    return send_packet_ruleset_effect_req_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_EFFECT_REQ variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_effect_req(struct conn_list *dest, const struct packet_ruleset_effect_req *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_effect_req(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_resource_100 hash_const

#define cmp_packet_ruleset_resource_100 cmp_const

BV_DEFINE(packet_ruleset_resource_100_fields, 6);

static struct packet_ruleset_resource *receive_packet_ruleset_resource_100(struct connection *pc, enum packet_type type)
{
  packet_ruleset_resource_100_fields fields;
  struct packet_ruleset_resource *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_ruleset_resource, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_resource_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_resource_100, cmp_packet_ruleset_resource_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    dio_get_string(&din, real_packet->name, sizeof(real_packet->name));
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'rule_name'");
    dio_get_string(&din, real_packet->rule_name, sizeof(real_packet->rule_name));
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'output'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        {
      int readin;
    
      dio_get_uint8(&din, &readin);
      real_packet->output[i] = readin;
    }
      }
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'graphic_str'");
    dio_get_string(&din, real_packet->graphic_str, sizeof(real_packet->graphic_str));
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'graphic_alt'");
    dio_get_string(&din, real_packet->graphic_alt, sizeof(real_packet->graphic_alt));
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_resource_100(struct connection *pc, const struct packet_ruleset_resource *packet)
{
  const struct packet_ruleset_resource *real_packet = packet;
  packet_ruleset_resource_100_fields fields;
  struct packet_ruleset_resource *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_RESOURCE;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_RESOURCE);

  log_packet_detailed("packet_ruleset_resource_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_resource_100, cmp_packet_ruleset_resource_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->output[i] != real_packet->output[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (strcmp(old->graphic_str, real_packet->graphic_str) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (strcmp(old->graphic_alt, real_packet->graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    dio_put_uint8(&dout, real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'rule_name' has changed");
    dio_put_string(&dout, real_packet->rule_name);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'output' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint8(&dout, real_packet->output[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'graphic_str' has changed");
    dio_put_string(&dout, real_packet->graphic_str);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'graphic_alt' has changed");
    dio_put_string(&dout, real_packet->graphic_alt);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_ruleset_resource(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_RESOURCE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_RESOURCE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_RESOURCE] = variant;
}

struct packet_ruleset_resource *receive_packet_ruleset_resource(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_error("Receiving packet_ruleset_resource at the server.");
  }
  ensure_valid_variant_packet_ruleset_resource(pc);

  switch(pc->phs.variant[PACKET_RULESET_RESOURCE]) {
  case 100:
    return receive_packet_ruleset_resource_100(pc, type);
  default:
    log_debug("Unknown PACKET_RULESET_RESOURCE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_resource(struct connection *pc, const struct packet_ruleset_resource *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_resource from the client.");
  }
  ensure_valid_variant_packet_ruleset_resource(pc);

  switch(pc->phs.variant[PACKET_RULESET_RESOURCE]) {

  case 100:
    return send_packet_ruleset_resource_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_RESOURCE variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_resource(struct conn_list *dest, const struct packet_ruleset_resource *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_resource(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_scenario_info_100 hash_const

#define cmp_packet_scenario_info_100 cmp_const

BV_DEFINE(packet_scenario_info_100_fields, 4);

static struct packet_scenario_info *receive_packet_scenario_info_100(struct connection *pc, enum packet_type type)
{
  packet_scenario_info_100_fields fields;
  struct packet_scenario_info *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_scenario_info, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_scenario_info_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_scenario_info_100, cmp_packet_scenario_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  real_packet->is_scenario = BV_ISSET(fields, 0);
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    dio_get_string(&din, real_packet->name, sizeof(real_packet->name));
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'description'");
    dio_get_string(&din, real_packet->description, sizeof(real_packet->description));
  }
  real_packet->players = BV_ISSET(fields, 3);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_scenario_info_100(struct connection *pc, const struct packet_scenario_info *packet)
{
  const struct packet_scenario_info *real_packet = packet;
  packet_scenario_info_100_fields fields;
  struct packet_scenario_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SCENARIO_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_SCENARIO_INFO);

  log_packet_detailed("packet_scenario_info_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_scenario_info_100, cmp_packet_scenario_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->is_scenario != real_packet->is_scenario);
  if(differ) {
    different++;
  }
  if (packet->is_scenario) {
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->description, real_packet->description) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->players != real_packet->players);
  if(differ) {
    different++;
  }
  if (packet->players) {
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, fields);

  /* field 0 is folded into the header */
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'description' has changed");
    dio_put_string(&dout, real_packet->description);
  }
  /* field 3 is folded into the header */

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_scenario_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_SCENARIO_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_SCENARIO_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_SCENARIO_INFO] = variant;
}

struct packet_scenario_info *receive_packet_scenario_info(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  ensure_valid_variant_packet_scenario_info(pc);

  switch(pc->phs.variant[PACKET_SCENARIO_INFO]) {
  case 100:
    return receive_packet_scenario_info_100(pc, type);
  default:
    log_debug("Unknown PACKET_SCENARIO_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_scenario_info(struct connection *pc, const struct packet_scenario_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  ensure_valid_variant_packet_scenario_info(pc);

  switch(pc->phs.variant[PACKET_SCENARIO_INFO]) {

  case 100:
    return send_packet_scenario_info_100(pc, packet);
  default:
    log_debug("Unknown PACKET_SCENARIO_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
#define hash_packet_save_scenario_100 hash_const

#define cmp_packet_save_scenario_100 cmp_const

BV_DEFINE(packet_save_scenario_100_fields, 1);

static struct packet_save_scenario *receive_packet_save_scenario_100(struct connection *pc, enum packet_type type)
{
  packet_save_scenario_100_fields fields;
  struct packet_save_scenario *old;
  struct genhash **hash = pc->phs.received + type;
  RECEIVE_PACKET_START(packet_save_scenario, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_save_scenario_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_save_scenario_100, cmp_packet_save_scenario_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'name'");
    dio_get_string(&din, real_packet->name, sizeof(real_packet->name));
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_save_scenario_100(struct connection *pc, const struct packet_save_scenario *packet)
{
  const struct packet_save_scenario *real_packet = packet;
  packet_save_scenario_100_fields fields;
  struct packet_save_scenario *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SAVE_SCENARIO;
  int different = 0;
  SEND_PACKET_START(PACKET_SAVE_SCENARIO);

  log_packet_detailed("packet_save_scenario_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_save_scenario_100, cmp_packet_save_scenario_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }

  *old = *real_packet;
  SEND_PACKET_END;
}

static void ensure_valid_variant_packet_save_scenario(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_SAVE_SCENARIO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_SAVE_SCENARIO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_SAVE_SCENARIO] = variant;
}

struct packet_save_scenario *receive_packet_save_scenario(struct connection *pc, enum packet_type type)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the close