/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.visualnet;

import hypergraph.graphApi.Graph;
import hypergraph.visualnet.AbstractGraphLayout;

public abstract class IteratingGraphLayout
extends AbstractGraphLayout {
    long totalTime;
    long numberOfIter;
    private IterationThread thread = new IterationThread();

    protected IterationThread getThread() {
        return this.thread;
    }

    protected abstract void iteration(IterationThread var1);

    public void invalidate() {
        super.invalidate();
        this.thread.startIterating();
    }

    public void layout() {
        if (this.thread != null && !this.thread.isRunning()) {
            this.thread.start();
            this.thread.startIterating();
        }
    }

    public class IterationThread
    extends Thread {
        private boolean iterating = false;
        private boolean running = false;

        public void startIterating() {
            this.iterating = true;
        }

        public void stopIterating() {
            this.iterating = false;
        }

        public boolean isIterating() {
            return this.iterating;
        }

        public void stopThread() {
            this.running = false;
        }

        public boolean isRunning() {
            return this.running;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.running = true;
            while (this.running) {
                if (this.isIterating()) {
                    ++IteratingGraphLayout.this.numberOfIter;
                    long l = System.currentTimeMillis();
                    Graph graph = IteratingGraphLayout.this.getGraph();
                    synchronized (graph) {
                        IteratingGraphLayout.this.iteration(this);
                    }
                    l = System.currentTimeMillis() - l;
                    IteratingGraphLayout.this.totalTime += l;
                }
                try {
                    IterationThread.sleep(10L);
                }
                catch (Exception exception) {}
            }
        }
    }
}

