/**************************************************************************\
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
	Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <signal.h>
#include <unistd.h>
#include <time.h>
#include <sys/time.h>
#include <errno.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

#include <ibtk/version.h>
#include <ibtk/iwindow.h>
#include <ibtk/ibox.h>
#include <ibtk/itextbox.h>
#include <ibtk/istatbar.h>
#include <ibtk/ibutton.h>
#include <ibtk/isbutton.h>
#include <ibtk/islider.h>
#include <ibtk/iintbox.h>
#include <ibtk/irealbox.h>
#include <ibtk/ilistbox.h>

#ifdef USE_DGA
#include <X11/extensions/xf86dga.h>
#define private pprivate
#include <X11/extensions/xf86vmode.h>
XF86VidModeModeInfo oldv;
#endif USE_DGA

#include "config.h"
#include "gatos.h"
#include "freq.h"
#include "cc.h"
#include "xutils.h"
#include "version.h"

#ifdef USE_IPC
#include "ipc.h"
#endif

extern int errno;

static IWindow *mwin = NULL;
static Window icon;
static IButton *aguib = NULL, *captguib = NULL, *chguib = NULL;
static IButton *setupb = NULL;
static ISButton *inp1 = NULL, *inp2 = NULL, *inp3 = NULL;
static ISButton *coldb = NULL, *muteb = NULL, *stereob = NULL, *sapb = NULL;
static ISButton *fullb = NULL, *deskb = NULL, *topb = NULL, *senscb = NULL;
static IListBox *CCl = NULL;
static IIntBox *dotb = NULL, *ahb = NULL;
static ITextBox *dotl = NULL, *CCb = NULL;
static ISButton *ahl = NULL, *CCt = NULL;

#ifdef USE_DGA
static ISButton *dgab = NULL;
#endif USE_DGA

static ISlider *gammas = NULL;
static IRealBox *freq = NULL;
static ISlider *svol = NULL, *sbr = NULL, *scnt = NULL, *shue = NULL;
static ISlider *ssat = NULL;
static ISlider *cvol = NULL, *cbr = NULL, *ccnt = NULL, *chue = NULL;
static ISlider *csat = NULL;
static IButton *scanb = NULL, *cadd = NULL, *crem = NULL, *creset = NULL;
static IRealBox *cfreq = NULL;
static IBox *nameb = NULL, *chnb = NULL;
static IIntBox *chnum = NULL;
static IButton *snapb = NULL, *recb = NULL, *stopb = NULL, *playb = NULL;
static IButton *clearb = NULL;
static IIntBox *xcaptb = NULL, *ycaptb = NULL;
static IBox *captfl = NULL;

static IListBox *formb = NULL, *mixerb = NULL;
static ITextBox *forml = NULL, *optl = NULL, *mixl = NULL;
static ISButton *svszb = NULL, *farb = NULL;
static IButton *convertb = NULL, *rescanb = NULL, *doneb = NULL;

static ITextBox *csitp1 = NULL, *csitb1 = NULL, *csitp2 = NULL, *csitb2 = NULL;
static IStatBar *csisb = NULL;
static IButton *cscan = NULL;

#ifdef GATOSBUTTONS
static IIntBox *testb[GATOSBUTTONS];
static ITextBox *testl[GATOSBUTTONS];
#endif GATOSBUTTONS

#define MAXGUI		3

static double *stdfreq;
static int maxstdchan=0;

static int autohide = 200, useautohide = 200;
static int full = 0, usedesk = 0, sdesk = 0, mapped = 0, ontop = 0;
static int oldxp = 0, oldyp = 0, oldx = 0, oldy = 0, tmpfar;
static int advgui=0, captgui=0, changui=0, setupgui=0, scangui=0, show=1;
static int ixs, iys, svsz = 1, far = 1, lasttime;
static int prevch, lprev=0, favch[8] = {-1, -1, -1, -1, -1, -1, -1, -1};
static int ccmode = CC_MODE_CC1;
static int paused = 0;
static time_t ltime = 0;

static struct timeval timeout;
static int useCC = 0;

#ifdef USE_DGA
char *frame; 
int rowlen, bank, mem, depth, ctrx, ctry;
static int usedga = 0;
int fulldga = 0;
#endif USE_DGA

static int xcl = -1, ycl = -1;

PALETTE pal;

XImage *message = NULL;
char *lastmessage = NULL;
long lastmessagesize = -1;
long lastmessage_x = -1, lastmessage_y = -1;
long message_x = 10, message_y = 5;
long messageon = 0;
// int message_turn_gui_on = 0; // Don't want to Hide old GUI.

XImage *channel = NULL;
char *lastchannel = NULL;
long lastchannelsize = -1;
long lastchannel_x = -1, lastchannel_y = -1;
long channel_x = 10, channel_y = 5;
long channelon = 0;

#define FIRST_MODE		0
#define MODE_VOLUME 		0
#define MODE_BRIGHTNESS 	1
#define MODE_CONTRAST  		2
#define MODE_INPUT_SOURCE	3
#define MODE_CC			4
#define MODE_SAP		5
#define LAST_MODE		5
#define FREE_MODE		(LAST_MODE+1)

int message_mode = MODE_VOLUME;

//  char *mode_name[] = {
//  		"Volume",
//  		"Brightness",
//  		"Contrast",
//  		"Input",
//  		"Caption",
//  		"Sap" };
		

long cctexton = 0;

int transparent_letters = -1;
long cctext_x = 10, cctext_y = 50;
long cctext_width = 1,cctext_height = 1;
int cctext_repaint = 1;

static long slideron = 0; /* tells whether the slider has been drawn */
static long slider_timeout = 180;
long slider_x = 0, slider_y = 0;

void toggleshow(void);
void initgui(void);
void updategui(void);
void updatechgui(void);
void ActivityCB(IWindow *w);
void ExposeCB(IWindow *w);
void ResizeCB(IWindow *w, int x, int y);
void RepositionCB(IWindow *w, int x, int y);
void OtherEventCB(IWindow *w, XEvent *ev);
void ClickCB(IWindow *w, int, int, int);
void DblClickCB(IWindow *w, int, int, int);
void DragCB(IWindow *w, int, int, int);
void ReleaseCB(IWindow *w, int, int, int);
void KeyMappingCB(IWindow *w, XEvent *ev);
void ButtonRadioReleaseCB(IWindow *w, int, int, int);
void chchan(IDoDad *p, IDoDad *d);
void snapcb(IDoDad *p, IDoDad *d, int);
void reccb(IDoDad *p, IDoDad *d, int);
void playcb(IDoDad *p, IDoDad *d, int);
void stopcb(IDoDad *p, IDoDad *d, int);
void clearcb(IDoDad *p, IDoDad *d, int);
void chcfreq(IDoDad *p, IDoDad *d);
void chfreq(IDoDad *p, IDoDad *d);
void cremcb(IDoDad *p, IDoDad *d, int);
void caddcb(IDoDad *p, IDoDad *d, int);
void cresetcb(IDoDad *p, IDoDad *d, int);
void loadstate(void);
void savestate(void);
void UP_CB(void);
void DOWN_CB(void);
void LEFT_CB(void);
void RIGHT_CB(void);
void deskCB(IDoDad *p, IDoDad *d, int x);
void CCtCB(IDoDad *p, IDoDad *d, int x);
void CCCB(IDoDad *p, IDoDad *d, int x);
void ShowMessage(char *);
void ShowChannel(char *);
void ShowControl(void);
void EraseMessage(void);
void EraseChannel(void);
void ShowCCStrings(void);
void EraseCCStrings(void);
void ShowCCText(void);
void EraseCCText(void);
void UniDrawRectangle(int x, int y, int width, int height, long color);
void DrawSlider(long value, long maxvalue, int erase);
void fullCB(IDoDad *p, IDoDad *d, int x);
void dotCB(IDoDad *p, IDoDad *d);
void ahCB(IDoDad *p, IDoDad *d);
void ahlCB(IDoDad *p, IDoDad *d, int x);
void senscCB(IDoDad *p, IDoDad *d, int x);

#ifdef USE_DGA
void dgaCB(IDoDad *p, IDoDad *d, int x);
#endif USE_DGA

void ResetAutoHide();
void visibility(XVisibilityEvent &);
void OnTopAgain(int);
int is_channel_enabled(void);

#ifdef CC_CURSES
#include "ccshow.h"
#endif CC_CURSES

#ifdef USE_IPC
int playback_running = 0;
#endif USE_IPC

/* ------------------------------------------------------------------------ */

void hookfn(void)  {
#ifdef USE_IPC
  char tmpbuf[80];

  if(playback_running) {
    if(ipc_receive_message((char *)&tmpbuf)) {
      if((strcmp(tmpbuf, "PLAYBACK-TERMINATED")) == 0) {
        gatos_stop();
        stopb->Disable();
        playb->Enable();
        XFlush(mwin->GetDisplay());
        playback_running = 0;
        }
      else if((strcmp(tmpbuf, "PLAYBACK-NOFILE")) == 0) {
        stopb->Disable();
        playb->Enable();
        XFlush(mwin->GetDisplay());
        playback_running = 0;
        }
      }
    }
#endif USE_IPC

  if(usedesk && sdesk) {
    XSetForeground(mwin->GetDisplay(), mwin->GetGC(), mwin->GetWinBGColor());
    XFillRectangle(mwin->GetDisplay(), mwin->GetRootWindow(), mwin->GetGC(),
		   0, 0, mwin->XDeskSize(), mwin->YDeskSize());
    }
  if(useautohide && show) {
    if(autohide) {
      --autohide;
      if(show && (!autohide)) { toggleshow(); XFlush(mwin->GetDisplay()); }
      }
    }
  if(useCC) { 
    cc_hook(); 

#ifdef CC_CURSES
    cc_show();
#else
    ShowCCText(); XFlush(mwin->GetDisplay());
#endif CC_CURSES

    }
  if(slideron > 1) slideron--;
  if(slideron == 1) {
    DrawSlider(100, 100, 1); XFlush(mwin->GetDisplay());
    slideron = 0;
    }
  if(channelon > 1) channelon--;
  if(channelon == 1) {
    EraseChannel(); XFlush(mwin->GetDisplay());		
    channelon = 0;
    }
  if(messageon > 1) messageon--;
  if(messageon == 1) {
    EraseMessage(); XFlush(mwin->GetDisplay());		
    messageon=0;
// Don't want to hide old GUI - ISG
// if(message_turn_gui_on) {
//   if(!show) toggleshow();
//   message_turn_gui_on = 0;
//   XFlush(mwin->GetDisplay());
//   }
    }

#ifndef CC_CURSES
  if(cctexton > 1) cctexton--;
  if(cctexton == 1) {
    /* EraseCCText(); XFlush(mwin->GetDisplay()); */
    cctexton = 0;
    }
#endif CC_CURSES

  }

/* ------------------------------------------------------------------------ */

int main(int argc, char **argv)  {
  int i, verb = 0, chkdisp = 1;

  bindtextdomain(PACKAGE, GATOS_LOCALEDIR);
  textdomain(PACKAGE);

  for(i=1; i<argc; i++) {
    if(!strcmp(argv[i],"-nosa")) gatos_setnosa(1) ; /* For testing /AA */
    else if(!strcmp(argv[i],"-pci") && i+1<argc) {
      i++ ; gatos_setpci(argv[i]);    /* Override pciaddr in gatos.conf */
      }
    else if(!strcmp(argv[i],"-q"))              verb |= GATOSQUIET;
    else if(!strcmp(argv[i],"-v") 
             || !strcmp(argv[i],"--verbose"))   verb |= 1;
    else if(!strcmp(argv[i],"-qv"))             verb |= 1|GATOSQUIET;
    else if(!strcmp(argv[i],"-vq"))             verb |= 1|GATOSQUIET;
    else if(!strncmp(argv[i],"-d",2))           verb |= atoi(argv[i]+2);
    else if(!strcmp(argv[i],"--force-display")) chkdisp = 0;
    }

  if(chkdisp) {
    if(exported_display()) {
      fprintf(stderr, _("xatitv doesn't work with remote display, use --force-display to override.\n"));
      exit(1);
      }
    }

  /* Check installed ibtk version */
  check_ibtk_version();

  mwin = new IWindow("XATITV-GATOS", "#102030", &icon, 96, 72);

#ifdef USE_DGA
  XF86DGAGetVideo(mwin->GetDisplay(), 0, (char**)&frame, &rowlen, &bank, &mem);
#endif USE_DGA

  gatos_setverbosity(verb);
  if(VERBOSE) {
    fprintf(stderr, _("IBTK version %s\n"), IBTK_FULL_VERSION_STRING);
    fprintf(stderr, GetXVendorRelease(mwin->GetDisplay()));
    }
  int tmp = gatos_init(GATOS_OVERLAY|GATOS_TUNER|GATOS_WRITE_BUFFER|GATOS_READ_BUFFER);
  if(tmp == ENOENT) { 
    printf(_("Configfile not found - Running gatos-conf.\n"));
    if(getuid()) {
      char buf[256];
      printf(_("If prompted for a password, Enter root password to run gatos-conf.\n"));
      sprintf(buf, "su -c %s%c", GATOS_CONF, 0);
      system(buf);
      }
    else {
      system(GATOS_CONF);
      }
    printf(_("Continuing execution of xatitv."));
    tmp = gatos_init(GATOS_OVERLAY|GATOS_TUNER|GATOS_WRITE_BUFFER|GATOS_READ_BUFFER);
    }
  if(tmp) { 
    perror(_("xatitv: gatos_init()")); 
    exit(1); 
    }
  ixs = gatos_xcapt(); iys = gatos_ycapt(); prevch = gatos_channel(); 
  loadstate();

  mwin->SetBufSize(640, 480); // This IS correct, even for PAL  --ISG
  mwin->Map(ixs, iys);
  mwin->SetUnhandledCallback(OtherEventCB);
  mwin->SetClickCallback(ClickCB);
  mwin->SetDblClickCallback(DblClickCB);
  mwin->SetDragCallback(DragCB);
  mwin->SetReleaseCallback(ReleaseCB);
  mwin->SetResizeCallback(ResizeCB);
  mwin->SetRepositionCallback(RepositionCB);
  mwin->SetExposeCallback(ExposeCB);
  mwin->SetActivityCallback(ActivityCB);
  mwin->SetKeyMappingCallback(KeyMappingCB);
  initgui();

  if(gatos_setcolorkey(mwin->GetWinBGColor())) { 
    perror(_("xatitv: gatos_setcolorkey()")); 
    exit(1);
    }
  gatos_enable_sound(1);
  gatos_enable_video(1);
  gatos_enable_capture(1);
/*
  createProtoImage(mwin->GetDisplay(),mwin->GetWindow());
  fillPalette(mwin->GetDisplay(),mwin->GetWindow(),mwin->GetGC(),&pal);
*/
  if(show) { show = 0; toggleshow(); } 
  timeout.tv_sec = 0;
  timeout.tv_usec = 33000; /* 33 ms = one frame at for 60 HZ fields*/
  mwin->RegisterHook(&hookfn, &timeout);
  mwin->DispatchEvents();
  if(full) fullCB(fullb, fullb, 0);
  if(useautohide && (!autohide) && (!show)) { 
    toggleshow(); 
    XFlush(mwin->GetDisplay());
    }
  savestate();  

/* change 0 to 1 to get printout about hash effectiveness */
#if 0  
  print_xutils_stats(); 
#endif 0

#ifdef CC_CURSES
  cc_mode(-1); 
#endif CC_CURSES

  gatos_terminate();
  }

/* ------------------------------------------------------------------------ */

void chname(IDoDad *p, IDoDad *d)  {
  int start = -1, ctr, done = 0, len = strlen(nameb->GetText());

  if(len < 1) return;
  if(!strncasecmp(nameb->GetText(), gatos_channame(gatos_channel()), len)) {
    nameb->SetChangeCallback(NULL);
    nameb->SetText(chnb->GetText());
    nameb->SetCurPos(nameb->CurPos(), strlen(nameb->GetText()));
    nameb->SetChangeCallback(chname);
    nameb->Redraw();
    return;
    }
  for(ctr = 0; done == 0 && ctr < gatos_numchans(); ctr++) {
    if(!strncasecmp(nameb->GetText(), gatos_channame(ctr), len)) done = 1;
/*
    if(done) 
      printf("\"%s\" == \"%s\"\n", nameb->GetText(), gatos_channame(ctr));
    else printf("\"%s\" != \"%s\"\n", nameb->GetText(), gatos_channame(ctr));
*/
    }
  if(nameb->CurPos() == (int)strlen(nameb->GetText())) start=nameb->CurPos();
  if(done != 0) {
    chnum->SetVal(ctr-1);
    chnum->Redraw();
    if(start >= 0) {
      nameb->SetCurPos(start, strlen(nameb->GetText()));
      }
    }
  }

/* ------------------------------------------------------------------------ */

void chdesc(IDoDad *p, IDoDad *d)  {
  if(gatos_mux() != 2) return;
  gatos_setchanname(gatos_channel(), ((IBox *)d)->GetText());
  }

/* ------------------------------------------------------------------------ */

void updatetextbox()  {
  if(chnb == NULL) return;
  chnb->SetChangeCallback(NULL);
  if(gatos_mux() == 2 && gatos_numchans() < 1) {
    chnb->Disable(); chnum->Disable(); nameb->Disable();
    return;
    }
  else if(gatos_mux() != 2) {
    chnb->Enable(); chnum->Disable(); nameb->Disable();
    }
  else {
    chnb->Enable();
    if(is_channel_enabled()) chnum->Enable(); 
    else chnum->Disable(); 
    nameb->Enable();
    }
  if(gatos_mux() == 2) chnb->SetText(gatos_channame(gatos_channel()));
  else if(gatos_mux() == 3) chnb->SetText(_("S-Video Input"));
  else if(gatos_mux() == 1) chnb->SetText(_("Composite-Video Input"));
  else chnb->SetText(_("Not Connected"));
  chnb->SetChangeCallback(chdesc);
  chnb->Redraw();
  nameb->SetChangeCallback(NULL);
  nameb->SetText(chnb->GetText());
  nameb->SetChangeCallback(chname);
  nameb->Redraw();
  char buf[256];
  sprintf(buf, "XATITV-GATOS: %s%c", chnb->GetText(), 0);
  mwin->SetTitle(buf);
  }

/* ------------------------------------------------------------------------ */

void keypress(XKeyEvent &e)  {
  char buf[256];
  KeySym key;
  int len;

  if(scangui) return;
  len = XLookupString(&e, buf, sizeof(buf), &key, NULL);

  switch(key) {
    case(XK_KP_Multiply): 
      fullb->Press(0, 0, 0); 
      break;
    case(XK_KP_Enter):
    case(XK_Return): 
      ltime = 0; 
      mwin->TakeFocus(NULL); 
      break;
    case(XK_KP_Divide): 
      muteb->Press(0, 0, 0); 
      break;
    case(XK_quoteleft): 
      CCt->Press(0, 0, 0); 
      break;
    case(XK_less): 
    case(XK_comma):
      mwin->Resize(mwin->XSize()/2, mwin->YSize()/2); 
      break;
    case(XK_greater): 
    case(XK_period):
      mwin->Resize(2*mwin->XSize(), 2*mwin->YSize());
      break;
    case(XK_Print):
      snapcb(NULL, snapb, 0);
      break;
    case(XK_Pause):
      gatos_enable_capture(paused);
      paused = !paused;
      break;
    case(XK_Tab):
#ifdef USE_DGA
      if(!fulldga)
#endif USE_DGA
	toggleshow();
      break;
    case(XK_Up):
      UP_CB();
      break;
    case(XK_Down): 
      DOWN_CB();
      break;
    case(XK_Right): 
      RIGHT_CB();
      break;
    case(XK_Left): 
      LEFT_CB();
      break;
    case(XK_Escape): 
      mwin->Close();
      break;
    case(XK_KP_Add): 
      chnum->Increment(); 
      break;
    case(XK_KP_Subtract): 
      chnum->Decrement(); 
      break;
    case(XK_F1): {
      if(e.state & ControlMask) favch[0] = gatos_channel();
      else if(favch[0] >= 0) { chnum->SetVal(favch[0]); chnum->Redraw(); }
      }
      break;
    case(XK_F2): {
      if(e.state & ControlMask) favch[1] = gatos_channel();
      else if(favch[1] >= 0) { chnum->SetVal(favch[1]); chnum->Redraw(); }
      }
      break;
    case(XK_F3): {
      if(e.state & ControlMask) favch[2] = gatos_channel();
      else if(favch[2] >= 0) { chnum->SetVal(favch[2]); chnum->Redraw(); }
      }
      break;
    case(XK_F4): {
      if(e.state & ControlMask) favch[3] = gatos_channel();
      else if(favch[3] >= 0) { chnum->SetVal(favch[3]); chnum->Redraw(); }
      }
      break;
    case(XK_F5): {
      if(e.state & ControlMask) favch[4] = gatos_channel();
      else if(favch[4] >= 0) { chnum->SetVal(favch[4]); chnum->Redraw(); }
      }
      break;
    case(XK_F6): {
      if(e.state & ControlMask) favch[5] = gatos_channel();
      else if(favch[5] >= 0) { chnum->SetVal(favch[5]); chnum->Redraw(); }
      }
      break;
    case(XK_F7): {
      if(e.state & ControlMask) favch[6] = gatos_channel();
      else if(favch[6] >= 0) { chnum->SetVal(favch[6]); chnum->Redraw(); }
      }
      break;
    case(XK_F8): {
      if(e.state & ControlMask) favch[7] = gatos_channel();
      else if(favch[7] >= 0) { chnum->SetVal(favch[7]); chnum->Redraw(); }
      }
      break;
    case(XK_F9): 
      gatos_debug1(); 
      break;
    case(XK_F10): 
      gatos_debug2(); 
      break;
    case(XK_F11): 
      gatos_debug3(); 
      break;
    case(XK_F12): 
      gatos_debug4(); 
      break;
    case(XK_BackSpace): {
      int tmpc = gatos_channel();
      chnum->SetVal(prevch);
      lprev = 1;
      prevch = tmpc;
      chnum->Redraw();
      break;
      }
    default: {
      buf[len] = 0;
      if(buf[0] != 0 && buf[1] == 0) {
	switch(buf[0]) {
	  case('0'): case('1'): case('2'): case('3'): case('4'): 
	  case('5'): case('6'): case('7'): case('8'): case('9'): {
	    time_t ttime = time(NULL);
	    if(ttime < ltime+2) {
	      int v = (chnum->GetVal() * 10) + buf[0] - '0';
	      if(gatos_numchans() > 99 && v > gatos_numchans()) v %= 1000;
	      else if(gatos_numchans() > 9 && v > gatos_numchans()) v %= 100;
	      else if(v > gatos_numchans()) v %= 10;
	      if(v > gatos_numchans()) v = gatos_numchans();
	      else if(v < 1) v = 1;
	      chnum->SetVal(v);
	      }
	    else {
	      chnum->SetVal(buf[0] - '0');
	      }
	    ltime = ttime;
//	    mwin->TakeFocus(chnum); chnum->Press(1,9,0); chnum->Redraw();
	    }
	    break;
	  case('<'): 
	    mwin->Resize(mwin->XSize()/2, mwin->YSize()/2); 
	    break;
	  case('>'): 
	    mwin->Resize(2*mwin->XSize(), 2*mwin->YSize()); 
	    break;
	  case('/'):
	    muteb->Press(0, 0, 0); 
	    break;
	  default: {
	    if(show && (!setupgui)) {
	      nameb->SetCurPos(0, strlen(nameb->GetText())); 
	      nameb->KeyDown(e);
	      mwin->TakeFocus(nameb); 
	      nameb->Redraw();
	      }
	    }
	    break;
	  }
	}
//    else printf(_("Pressed %.4X\n"), 
//                XKeycodeToKeysym(mwin->GetDisplay(), e.keycode, 0));
      }
    }
  }

/* ------------------------------------------------------------------------ */

void DOWN_CB(void)  {
  if(messageon) {
    message_mode--;
    if(message_mode < FIRST_MODE) message_mode = LAST_MODE;
    }
  ShowControl();
  }

/* ------------------------------------------------------------------------ */

void UP_CB(void)  {
  if(messageon){
    message_mode++;
    if(message_mode > LAST_MODE) message_mode = FIRST_MODE;
    }
  ShowControl();
  }

/* ------------------------------------------------------------------------ */

void RIGHT_CB(void)  {

  if(messageon)
    switch(message_mode) {
      case MODE_VOLUME:
	svol->SetValue(svol->Value()+1); 
	break;
      case MODE_BRIGHTNESS:
	if(sbr->Value() < sbr->Max()) sbr->SetValue(sbr->Value()+1);
	break;
      case MODE_CONTRAST:
	if(scnt->Value() < scnt->Max()) scnt->SetValue(scnt->Value()+1);
	break;
      case MODE_INPUT_SOURCE:
	if(gatos_mux() == 3 || gatos_mux() == 0) {
	  inp3->Press(0, 0, 0);
	  }
	else if(gatos_mux() == 1) {
	  inp1->Press(0, 0, 0);
	  }
	else {
	  inp2->Press(0, 0, 0);
	  }
	break;
      case MODE_SAP:
	sapb->Press(0, 0, 0);
	break;
      case MODE_CC:
	if(!useCC) ccmode = -1;
	ccmode++;
	if(ccmode >= 4) ccmode = -1;
	// CCCB(NULL,NULL,ccmode);
	if(ccmode == -1 && CCt->State()) CCt->Press(0, 0, 0);
	else if(ccmode >= 0 && (!CCt->State())) CCt->Press(0, 0, 0);
	if(ccmode >= 0) CCl->Select(ccmode);
	break;
      default:
	break;
      }
  ShowControl();		
  }

/* ------------------------------------------------------------------------ */

void LEFT_CB(void)  {

  if(messageon)
    switch(message_mode) {
      case MODE_VOLUME:
	svol->SetValue(svol->Value()-1); 
	break;
      case MODE_BRIGHTNESS:
	if(sbr->Value() > sbr->Min()) sbr->SetValue(sbr->Value()-1);
	break;
      case MODE_CONTRAST:
	if(scnt->Value() > scnt->Min()) scnt->SetValue(scnt->Value()-1);
	break;
      case MODE_INPUT_SOURCE:
	if(gatos_mux() == 3 || gatos_mux() == 0) {
	  inp2->Press(0, 0, 0);
	  }
	else if(gatos_mux() == 1) {
	  inp3->Press(0, 0, 0);
	  }
	else {
	  inp1->Press(0, 0, 0);
	  }
	break;
      case MODE_SAP:
	stereob->Press(0, 0, 0);
	break;
      case MODE_CC:
	if(!useCC) ccmode = -1;
	ccmode--;
	if(ccmode < -1) ccmode = 3;
	// CCCB(NULL,NULL,ccmode);
	if(ccmode == -1 && CCt->State()) CCt->Press(0, 0, 0);
	else if(ccmode >= 0 && (!CCt->State())) CCt->Press(0, 0, 0);
	if(ccmode >= 0) CCl->Select(ccmode);
	break;
      default:
	break;
      }
  ShowControl();		
  }

/* ------------------------------------------------------------------------ */

void ClickCB(IWindow *w, int b, int x, int y)  {

#ifdef USE_DGA
  if(!fulldga) {
#endif USE_DGA

    if(b > 1 && (!scangui)) toggleshow();
    else { xcl = x; ycl = y; }

#ifdef USE_DGA
    }
#endif USE_DGA

  }

/* ------------------------------------------------------------------------ */

void DblClickCB(IWindow *w, int b, int x, int y)  {
  if(b == 1) fullb->Press(0, 0, 0); 
  }

/* ------------------------------------------------------------------------ */

void DragCB(IWindow *w, int b, int x, int y)  {
  if(xcl >= 0 && (b & Button1Mask)) {
    int x1, x2, y1, y2;
    x1 = x <? xcl; x2 = x >? xcl;
    y1 = y <? ycl; y2 = y >? ycl;
    if(farb->State()) {
      if((y2 - y1) > ((x2 - x1)*gatos_ycaptmax())/gatos_xcaptmax()) {
	if(ycl < y) y2 = y1+((x2 - x1)*gatos_ycaptmax())/gatos_xcaptmax();
	else y1 = y2-((x2-x1)*gatos_ycaptmax())/gatos_xcaptmax();
	}
      else {
	if(xcl < x) x2 = x1+((y2 - y1)*gatos_xcaptmax())/gatos_ycaptmax();
	else x1 = x2-((y2 - y1)*gatos_xcaptmax())/gatos_ycaptmax();
	}
      }
    XSetForeground(mwin->GetDisplay(), mwin->GetClipGC(), 
		   mwin->GetWinBGColor());
    XFillRectangle(mwin->GetDisplay(), mwin->GetWindow(), mwin->GetClipGC(),
		   0, 0, mwin->XSize(), mwin->YSize());
    XSetForeground(mwin->GetDisplay(), mwin->GetClipGC(), mwin->GetBGColor());
    XDrawRectangle(mwin->GetDisplay(), mwin->GetWindow(), mwin->GetClipGC(),
		   x1, y1, x2-x1, y2-y1);
    }
  }

/* ------------------------------------------------------------------------ */

void ReleaseCB(IWindow *w, int b, int x, int y)  {
  if(xcl >= 0) {
    if(x < 0) x = 0; if(y < 0) y = 0;
    if(x >= mwin->XSize()) x = mwin->XSize()-1;
    if(y >= mwin->YSize()) y = mwin->YSize()-1;
    int xp = gatos_xstart(), yp = gatos_ystart();
    int xs = gatos_xend()-xp, ys = gatos_yend()-yp;
    int xb = (xcl <? x), yb = (ycl <? y), xe = (xcl >? x)+1, ye = (ycl >? y)+1;
    int x1 = xp+(xb*xs)/mwin->XSize(), y1 = yp+(yb*ys)/mwin->YSize();
    int x2 = xp+(xe*xs)/mwin->XSize(), y2 = yp+(ye*ys)/mwin->YSize();
    if(x1 >= x2-1 || y1 >= y2-1) { 
      x1 = 0; y1 = 0; x2 = gatos_xcapt(); y2 = gatos_ycapt(); 
      }
    else if(farb->State()) {
      if((y2 - y1) > ((x2 - x1)*gatos_ycaptmax())/gatos_xcaptmax()) {
	if(ycl < y) y2 = y1+((x2-x1)*gatos_ycaptmax())/gatos_xcaptmax();
	else y1 = y2-((x2-x1)*gatos_ycaptmax())/gatos_xcaptmax();
	}
      else {
	if(xcl < x) x2 = x1+((y2-y1)*gatos_xcaptmax())/gatos_ycaptmax();
	else x1 = x2-((y2-y1)*gatos_xcaptmax())/gatos_ycaptmax();
	}
      }
    gatos_setsubgeometry(x1, y1, x2, y2);
    XSetForeground(mwin->GetDisplay(), mwin->GetClipGC(), 
		   mwin->GetWinBGColor());
    XFillRectangle(mwin->GetDisplay(), mwin->GetWindow(), mwin->GetClipGC(),
		   0, 0, mwin->XSize(), mwin->YSize());
    xcl = -1; ycl = -1;
    }
  }

/* ------------------------------------------------------------------------ */

void ResetAutoHide()  {
  if(useautohide) {
    if((!show) && (!autohide)) toggleshow();
    autohide = useautohide;
    }
  }

/* ------------------------------------------------------------------------ */

void OtherEventCB(IWindow *w, XEvent *ev)  {
  switch(ev->type) {
    case KeyPress: 
      keypress(ev->xkey); 
      break;
    case MapNotify: {
      /* mwin->Redraw(); */ 
      mwin->RebuildClip(); cctext_repaint = 1; ShowCCText();
      if(!mapped) createProtoImage(mwin->GetDisplay(), mwin->GetWindow());
      if(!mapped) fillPalette(mwin->GetDisplay(), mwin->GetWindow(),
			      mwin->GetGC(), &pal);
      if(!mapped && (transparent_letters < 0)) {
	if(get_actual_depth() == 8) transparent_letters=0;
	else transparent_letters = 1;
        }
      gatos_setgeometry(w->XSize(), w->YSize(), w->XPos(), w->YPos());
      gatos_setmapped(1); mapped = 1;
      if(usedesk) {
	XClearWindow(mwin->GetDisplay(), mwin->GetRootWindow());
	sdesk = 0;
	}
      cctext_repaint = 1;
      }
      break;
    case UnmapNotify: {
      if(!usedesk) { gatos_setmapped(0); mapped = 0; }
      else {
	XSetForeground(mwin->GetDisplay(), mwin->GetGC(), 
		       mwin->GetWinBGColor());
	XFillRectangle(mwin->GetDisplay(), mwin->GetRootWindow(), 
		       mwin->GetGC(), 0, 0, mwin->XDeskSize(), 
		       mwin->YDeskSize());
	gatos_setgeometry(mwin->XDeskSize(), mwin->YDeskSize(), 0, 0);
	sdesk = 1;
	}
      }
      break;
    case VisibilityNotify: 
      visibility(ev->xvisibility); 
      break;
/*
    default: {
      if(desk && (!mapped)) {
	XSetForeground(mwin->GetDisplay(), mwin->GetGC(), 
	mwin->GetWinBGColor());
	XFillRectangle(mwin->GetDisplay(), mwin->GetRootWindow(), 
	mwin->GetGC(), 0, 0, mwin->XDeskSize(), mwin->YDeskSize());
	gatos_setgeometry(mwin->XDeskSize(), mwin->YDeskSize(), 0, 0);
	}
      }break;
*/
    }
  }

/* ------------------------------------------------------------------------ */

void ExposeCB(IWindow *w)  {
  /*gatos_setgeometry(w->XSize(), w->YSize(), w->XPos(), w->YPos()); /AA */
  }

/* ------------------------------------------------------------------------ */

void ActivityCB(IWindow *w)  {
  ResetAutoHide();
  }

/* ------------------------------------------------------------------------ */

void ResizeCB(IWindow *w, int x, int y)  {
  if(usedesk && !mapped) return;
  if(far) {
    int xs = x, ys = y;
    if(xs != gatos.xsize && ys != gatos.ysize) {
      if(ys > (xs*gatos_ycaptmax())/gatos_xcaptmax())
        ys = (xs*gatos_ycaptmax())/gatos_xcaptmax();
      else
        xs = (ys*gatos_xcaptmax())/gatos_ycaptmax();
      }
    else if(xs != gatos.xsize) {
      ys = (xs*gatos_ycaptmax())/gatos_xcaptmax();
      }
    else if(ys != gatos.ysize) {
      xs = (ys*gatos_xcaptmax())/gatos_ycaptmax();
      }
    if(xs != x || ys != y) mwin->Resize(xs, ys);
    }
  else gatos_setgeometry(w->XSize(), w->YSize(), w->XPos(), w->YPos());
  mwin->RebuildClip();
  }

/* ------------------------------------------------------------------------ */

void RepositionCB(IWindow *w, int x, int y)  {
  if(usedesk && !mapped) return;
  gatos_setgeometry(w->XSize(), w->YSize(), w->XPos(), w->YPos());
  }

/* ------------------------------------------------------------------------ */
/* Get new keyboard mapping .DCB */
void KeyMappingCB(IWindow *w, XEvent *ev)  {
  XRefreshKeyboardMapping(&ev->xmapping);
  }

/* ------------------------------------------------------------------------ */

void ButtonRadioReleaseCB(IDoDad *p, IDoDad *d, int x) {
  if(d == inp1 && (inp1->State() == 0
		    && inp2->State() == 0
		    && inp3->State() == 0)) inp1->Press(1, 0, 0);
  if(d == inp2 && (inp1->State() == 0
		    && inp2->State() == 0
		    && inp3->State() == 0)) inp2->Press(1, 0, 0);
  if(d == inp3 && (inp1->State() == 0
		    && inp2->State() == 0
		    && inp3->State() == 0)) inp3->Press(1, 0, 0);
  }

/* ------------------------------------------------------------------------ */

void inp(IDoDad *p, IDoDad *d, int x)  {
  int omux = gatos_mux();

  if(d == inp1) { 
    gatos_setmux(3); 
    if(chnum != NULL) chnum->Disable(); 
    }
  else if(d == inp2) { 
    gatos_setmux(1); 
    if(chnum != NULL) chnum->Disable(); 
    }
  else if(d == inp3) { 
    gatos_setmux(2); 
    if(chnum != NULL) {
      chnum->Enable(); chchan(NULL, chnum); 
      } 
    }
  else {
    fprintf(stderr, _("Bad ButtonPress!\n"));
    exit(1);
    }
  if(d != inp1 && inp1->State() == 1) inp1->Press(1, 0, 0);
  if(d != inp2 && inp2->State() == 1) inp2->Press(1, 0, 0);
  if(d != inp3 && inp3->State() == 1) inp3->Press(1, 0, 0);
  updatetextbox();
  if(omux != gatos_mux()) cc_reset();
  }

/* ------------------------------------------------------------------------ */

void chcapt(IDoDad *p, IDoDad *d)  {
  gatos_setcapturesize(xcaptb->GetVal(), ycaptb->GetVal());
  }

/* ------------------------------------------------------------------------ */

void chfreq(IDoDad *p, IDoDad *d)  {
  gatos_settuner(((IRealBox *)d)->GetVal());
  }

/* ------------------------------------------------------------------------ */

void chcfreq(IDoDad *p, IDoDad *d)  {
  gatos_setchanfreq(gatos_channel(), ((IRealBox *)d)->GetVal());
  }

/* ------------------------------------------------------------------------ */

void csld(IDoDad *p, IDoDad *d, int x)  {
  if(d == cvol) gatos_setchanvolume(gatos_channel(), x);
  else if(d == cbr) gatos_setchanbrightness(gatos_channel(), x);
  else if(d == ccnt) gatos_setchancontrast(gatos_channel(), x);
  else if(d == chue) gatos_setchanhue(gatos_channel(), x);
  else if(d == csat) gatos_setchansaturation(gatos_channel(), x);
  else {
    fprintf(stderr, _("Bad Slider Pressed!\n"));
    exit(1);
    }
  }

/* ------------------------------------------------------------------------ */

void sld(IDoDad *p, IDoDad *d, int x)  {
  if(d == svol) gatos_setvolume(x);
  else if(d == sbr) gatos_setbrightness(x);
  else if(d == scnt) gatos_setcontrast(x);
  else if(d == shue) gatos_sethue(x);
  else if(d == ssat) gatos_setsaturation(x);
  else if(d == gammas) gatos_setgamma(x);
  else {
    fprintf(stderr, _("Bad Slider Pressed!\n"));
    exit(1);
    }
  }

/* ------------------------------------------------------------------------ */

#ifdef USE_DGA
void dgaCB(IDoDad *p, IDoDad *d, int x)  {
  if(full) { 
    int tmpd = usedesk; usedesk = 0; fullb->Press( 0, 0, 0); usedesk = tmpd; 
    }
  usedga = x;
  }
#endif USE_DGA

/* ------------------------------------------------------------------------ */

void senscCB(IDoDad *p, IDoDad *d, int x)  {
  gatos_setsenscan(x);
  }

/* ------------------------------------------------------------------------ */

void ahlCB(IDoDad *p, IDoDad *d, int x)  {
  if(!x) {
    ahb->Disable();
    useautohide = 0;
    }
  else {
    useautohide = (((IIntBox*)ahb)->GetVal())*100;
    ahb->Enable();
    if(ahb->GetVal() <= 0) ahb->SetVal(1);
    }
  }

/* ------------------------------------------------------------------------ */

void ahCB(IDoDad *p, IDoDad *d)  {
  useautohide = (((IIntBox*)d)->GetVal())*100;
  autohide = useautohide;
  if((!useautohide) && (ahl->State())) ahl->Press(0, 0, 0);
  }

/* ------------------------------------------------------------------------ */

void dotCB(IDoDad *p, IDoDad *d)  {
  gatos_setoverclock(((IIntBox*)d)->GetVal());
  }

/* ------------------------------------------------------------------------ */

#ifdef GATOSBUTTONS
void testCB(IDoDad *p, IDoDad *d)  {
  int which;

  for(which = 0; which<GATOSBUTTONS && d != testb[which]; ++which)
  if(which >= GATOSBUTTONS) {
    fprintf(stderr, _("Bad Testbutton Pressed!\n"));
    exit(-1);
    }
  gatos_settestbutton(which, ((IIntBox*)d)->GetVal());
  }
#endif GATOSBUTTONS

/* ------------------------------------------------------------------------ */

void deskCB(IDoDad *p, IDoDad *d, int x)  {
  usedesk = x;
  if(usedesk) mwin->DisableIcon();
  else mwin->EnableIcon();
  }

/* ------------------------------------------------------------------------ */

void CCtCB(IDoDad *p, IDoDad *d, int x)  {
  CCCB(p, CCl, x ? ccmode : -1);
  }

/* ------------------------------------------------------------------------ */

void CCCB(IDoDad *p, IDoDad *d, int x)  {
  x += 1; if(!CCt->State()) x = 0;
  if((!useCC) && x) {
    useCC = 1;
    ccmode = x-1;
    if(gatos_setCC(GET_CC|GET_EDS)) { useCC = 0; ccmode = -1;}
    else { 

#ifdef CC_CURSES
      cc_mode(ccmode);
#else
      EraseCCText();
      XFlush(mwin->GetDisplay());
#endif CC_CURSES

      cc_reset(); 
      }
    }
  else if(x) {
    ccmode = x-1;

#ifdef CC_CURSES
    cc_mode(ccmode);
#else
    EraseCCText();
    XFlush(mwin->GetDisplay());
    cctext_repaint = 1;
    ShowCCText();
#endif CC_CURSES

    }
  else {
    useCC = 0; gatos_setCC(0);

#ifdef CC_CURSES
    cc_mode(-1);
#else
    EraseCCText();
    XFlush(mwin->GetDisplay());
#endif CC_CURSES

    }
  }

/* ------------------------------------------------------------------------ */

void topCB(IDoDad *p, IDoDad *d, int x)  {
  ontop = x;
  }

/* ------------------------------------------------------------------------ */

void EraseChannel(void)  {
  if(channel == NULL) return;
  UniDrawRectangle(channel_x, channel_y, channel->width, channel->height,
		   gatos_colorkey());
  XFreeImage(channel);
  channel = NULL;				
  }

/* ------------------------------------------------------------------------ */

void ShowChannel(char *string)  {
  int size, window_x;
// Don't want to hide old GUI. -ISG
//if(show){
//	toggleshow();
//	channel_turn_gui_on=1;
//	}

#ifdef USE_DGA
  if(usedga && full) {
    size = gatos_ydim();
    window_x = gatos_xdim();
    }
  else
#endif USE_DGA

    {
    size = mwin->YSize();
    window_x = mwin->XSize();
    }
  size = size/10;
  if((channel == NULL) 
      || (lastchannel == NULL)
      || strcmp(lastchannel, string) 
      || (size != lastchannelsize)) {
    EraseChannel();
    if(transparent_letters) pal.bg_col = gatos_colorkey();
    else pal.bg_col = pal.black_col;
    channel = printString(string, "fixed", size,&pal);
    if(lastchannel != NULL) free(lastchannel);
    lastchannel = strdup(string);
    lastchannelsize = size;
    lastchannel_x = channel_x;
    lastchannel_y = channel_y;
    }
  channel_y = 10;
  channel_x = window_x-channel->width;

#ifdef USE_DGA
  if(usedga && full) {
    DGAPutImage((u8*)frame, mwin->XDeskSize(), channel_x, channel_y, channel);
    }
  else
#endif USE_DGA

    {
    XPutImage(mwin->GetDisplay(), mwin->GetWindow(), mwin->GetGC(), channel, 
	      0, 0, channel_x, channel_y, channel->width, channel->height);
    }
  channelon = 2*slider_timeout;
  }

/* ------------------------------------------------------------------------ */

void ShowMessage(char *string)  {
  int size;

// Don't want to hide old GUI. -ISG
//if(show){
//	toggleshow();
//	message_turn_gui_on=1;
//	}

#ifdef USE_DGA
  if(usedga && full) {
    size = gatos_ydim();
    }
  else
#endif USE_DGA

    {
    size = mwin->YSize();
    }
  size = size/10;
  if((message == NULL)
      || (lastmessage == NULL)
      || strcmp(lastmessage, string)
      || (size != lastmessagesize)) {
    EraseMessage();
    if(transparent_letters) pal.bg_col = gatos_colorkey();
    else pal.bg_col = pal.black_col;
    message = printString(string, "fixed", size, &pal);
    if(lastmessage != NULL) free(lastmessage);
    lastmessage = strdup(string);
    lastmessagesize = size;
    lastmessage_x = message_x;
    lastmessage_y = message_y;
    }
  message_y = slider_y-message->height-5;

#ifdef USE_DGA
  if(usedga && full) {
    DGAPutImage((u8*)frame, mwin->XDeskSize(), message_x, message_y, message);
    }
  else
#endif USE_DGA

    {
    XPutImage(mwin->GetDisplay(), mwin->GetWindow(), mwin->GetGC(), message, 
	      0, 0, message_x, message_y, message->width, message->height);
    }
  messageon = slider_timeout;
  }

/* ------------------------------------------------------------------------ */

void EraseMessage(void)  {
  if(message == NULL) return;
  UniDrawRectangle(message_x, message_y, message->width, message->height,
		   gatos_colorkey());
  XFreeImage(message);
  message = NULL;				
  }

/* ------------------------------------------------------------------------ */

void ShowControl(void)  {
  switch(message_mode) {
    case MODE_VOLUME:
      DrawSlider(svol->Value(), 100, 2);
      ShowMessage(_("Volume"));
      DrawSlider(svol->Value(), 100, 0);
      return;
    case MODE_BRIGHTNESS:
      DrawSlider(sbr->Value()-sbr->Min(), sbr->Max()-sbr->Min(), 2);
      ShowMessage(_("Brightness"));
      DrawSlider(sbr->Value()-sbr->Min(), sbr->Max()-sbr->Min(), 0);
      return;
    case MODE_CONTRAST:
      DrawSlider(scnt->Value()-scnt->Min(), scnt->Max()-scnt->Min(), 2);
      ShowMessage(_("Contrast"));
      DrawSlider(scnt->Value()-scnt->Min(), scnt->Max()-scnt->Min(), 0);
      return;
    case MODE_INPUT_SOURCE:
      DrawSlider(1, 100, 1);
      if(gatos_mux() == 3 || gatos_mux() == 0) {
	ShowMessage(_("Input:\\rS-Video"));
        }
      else if(gatos_mux() == 1) {
	ShowMessage(_("Input:\\rComposite"));
        }
      else {
	ShowMessage(_("Input:\\rTV signal"));
        }
      return;
    case MODE_CC:
      DrawSlider(1, 100, 1);
      if(!useCC) {
	ShowMessage(_("Caption:\\rNone"));
	return;
        }
      switch(ccmode) {
        case -1:
	  ShowMessage(_("Caption:\\rNone"));
	  return;
        case CC_MODE_CC1: 
	  ShowMessage(_("Caption:\\rCC1"));
	  return;
        case CC_MODE_CC2: 
	  ShowMessage(_("Caption:\\rCC2"));
	  return;
        case CC_MODE_TEXT1:
	  ShowMessage(_("Caption:\\rTEXT1"));
	  return;
        case CC_MODE_TEXT2:
	  ShowMessage(_("Caption:\\rTEXT2"));
	  return;
        default:
	  ShowMessage(_("Caption:\\rERROR"));
	  return;
        }
      return;
    case MODE_SAP:
      DrawSlider(1, 100, 1);
      if(gatos_sap()) {
	if(gatos_stereo()) {
	  ShowMessage(_("Stereo/SAP:\\rST/SAP"));
	  }
	else {
	  ShowMessage(_("Stereo/SAP:\\r  /SAP"));
	  }
        } 
      else {
	if(gatos_stereo()) {
	  ShowMessage(_("Stereo/SAP:\\rST/"));
	  } 
	else {
	  ShowMessage(_("Stereo/SAP:\\r  /"));
	  }
        }
      return;
    default:
      return;
    }
  }

/* ------------------------------------------------------------------------ */

int charNotValid(char c)  {
  if(c == 1) return 1;
  if(c < 10) return 1;
  if((c >= 'a') && (c <= 'z')) return 0;
  if((c >= 'A') && (c <= 'Z')) return 0;
  if(c == ' ') return 0;
  if(c == '.') return 0;
  if(c == ':') return 0;
  if(c == ';') return 0;
  if(c == '\'') return 0;
  if(c == '?') return 0;
  if(c == '-') return 0;
  if(c == '\"') return 0; //" Just for emacs hilit19 display bug
  return 2;
  }

/* ------------------------------------------------------------------------ */

void cleanString(char *string)  {
  int i, j;

  for(i = 0; string[i]; i++)
    switch(charNotValid(string[i])) {
      case 1:
	string[i] = ' ';
	for(j = 0; string[i+j]; j++) {
	  string[i+j] = string[i+j+1];
	  }
	i--;
	break;
      case 2: 
	string[i] = ' ';
	break;
      default: 
	break;
      }
  }

/* ------------------------------------------------------------------------ */

void ShowCCText(void)  {
  int size;
  long window_x, window_y, slider_grid;
  int i, j, k;
  XImage *im;
  GC gc;

  if(!useCC) return;
 if(ccmode < 0) return;

 gc = mwin->GetClipGC();

#ifdef USE_DGA
 if(usedga && full) {
   window_x = gatos_xdim();
   window_y = gatos_ydim();
   } 
 else
#endif USE_DGA

   {
   window_x = mwin->XSize();
   window_y = mwin->YSize();
   }

/* slider grid is the minimum unit of graphic detail.
   It should be 10 at window_x=1024 and of course not less than 1 */
   
 slider_grid = window_x/100;
 if(slider_grid < 1) slider_grid = 1;

 cctext_x = 10;
 size = window_x/24;
 if(size > window_y/18) size = window_y/18;
 if(size < 1) size = 1;
 cctext_y = 5;
 if(transparent_letters) pal.bg_col = gatos_colorkey();
 else pal.bg_col = pal.black_col;


 struct ccdata * ccdat = cc_get_data();
 struct ccdata ccd = ccdat[ccmode];

 if(*ccd.clrflag) {
   EraseCCText();
   }
 for(j = 0; j < ccd.num_row; j++) {
   k = ccd.row[j]-1;
   for(i = 0; i < CC_COLUMNS; i++) {
     if(cctext_repaint 
	 || *ccd.clrflag 
	 || (ccd.attrib[j][i] & CC_ATTR_NEWCHAR)) {
       ccd.attrib[j][i] &= ~CC_ATTR_NEWCHAR;
       im = getCCChar(ccd.text[j][i], size, ccd.attrib[j][i], &pal);
       cctext_width = im->width;
       cctext_height = im->height;

#ifdef USE_DGA
       if(usedga && full) {
	 DGAPutImage((u8*)frame, mwin->XDeskSize(), cctext_x+i*im->width,
		     cctext_y+k*im->height, im);
         }
        else
#endif USE_DGA

	 {
	 XPutImage(mwin->GetDisplay(), mwin->GetWindow(), gc, im, 0, 0,
		   cctext_x+i*im->width, cctext_y+k*im->height, im->width,
		   im->height);
	 }
       cctexton = slider_timeout;
       }
     }
   }
  *ccd.clrflag = 0;
  cctext_repaint = 0;
  }

/* ------------------------------------------------------------------------ */

void EraseCCText(void)  {
  long window_x, window_y;
  long m;

#ifdef USE_DGA
  if(usedga && full) {
    window_x = gatos_xdim();
    window_y = gatos_ydim();
    } 
  else
#endif USE_DGA

    {
    window_x = mwin->XSize();
    window_y = mwin->YSize();
    }
  UniDrawRectangle(0, 0, window_x, window_y, gatos_colorkey());
  m = messageon;
  if(m) {
    ShowControl();
    messageon = m;
    }
  }

/* ------------------------------------------------------------------------ */

void UniDrawRectangle(int x, int y, int width, int height, long color)  {
  GC gc;

#ifdef USE_DGA
  if(usedga && full) {
    DGADrawRectangle((u8*)frame, depth, mwin->XDeskSize(), x, y,
		     width, height, color);
    } 
  else {
#endif USE_DGA

    if(show) gc = mwin->GetClipGC();
    else gc = mwin->GetGC();
    XSetForeground(mwin->GetDisplay(), gc, color);
    XFillRectangle(mwin->GetDisplay(), mwin->GetWindow(), gc, 
		   x, y, width, height);
#ifdef USE_DGA
    }
#endif USE_DGA

  }

/* ------------------------------------------------------------------------ */
/* These are the constants that regulate green,yellow and red appearance
   the maximum is 100 */
long yellow_start = 33;
long red_start = 66;   

/* erase: 
    0 : do normal painting 
    1 : erase slider
    2 : only perform slider_x,slider_y calculation
    */
			
void DrawSlider(long value, long maxvalue, int erase)  {
  long slider_width, slider_height, slider_grid, slider_height_small;
  long slider_step;
  long window_x ,window_y;
  long i;
  long color;

#ifdef USE_DGA
  if(usedga && full) {
    window_x = gatos_xdim();
    window_y = gatos_ydim();
    }
  else
#endif USE_DGA

    {
    window_x = mwin->XSize();
    window_y = mwin->YSize();
    }

/* slider grid is the minimum unit of graphic detail.
   It should 10 at window_x=1024 and of course not less than 1 */
   
  slider_grid = window_x/100;
  if(slider_grid < 1) slider_grid = 1;

  slider_y = window_y-6*slider_grid;
  slider_width = window_x-4*slider_grid;
  slider_height = 4*slider_grid;
  slider_height_small = slider_grid;
  slider_step = slider_grid+slider_grid/2;
  slider_x = 2*slider_grid;
  /* note that (slider_height-slider_height_small)/2==slider_step */
  if(erase == 2) return;
	
  if(value < 0) value = 0;
  if(maxvalue < 0) maxvalue = 1;
  if(value > maxvalue) value = maxvalue;
  if(erase == 1) {
    UniDrawRectangle(slider_x, slider_y, slider_width, slider_height,
		     gatos_colorkey());
    slideron = 0;
    slider_y = window_y;
    return;
    }
  for(i = 0; i < slider_width/(2*slider_step); i++) {
    if(i*100*2*slider_step < yellow_start*slider_width) 
      color = mwin->greencol;
    else if(i*100*2*slider_step < red_start*slider_width) 
      color = mwin->yellowcol;
    else color = mwin->redcol;
    if(i*maxvalue*2*slider_step < slider_width*value) {
      /* draw big ones */
      UniDrawRectangle(slider_x+i*2*slider_step, slider_y, slider_step,
		       slider_height, color);
      }
    else {
      /* draw dashes */
      UniDrawRectangle(slider_x+i*2*slider_step, slider_y, slider_step,
		       slider_height, gatos_colorkey());
      UniDrawRectangle(slider_x+i*2*slider_step, slider_y+slider_step,
		       slider_step, slider_height_small, color);
      }
    }
  slideron = slider_timeout;
  }

/* ------------------------------------------------------------------------ */

void EraseSlider(void)  {

  }
	
/* ------------------------------------------------------------------------ */

void fullCB(IDoDad *p, IDoDad *d, int x)  {

#ifdef USE_DGA
  static int oauto, ouauto; //oshow;
#endif USE_DGA

  if(x && full == 0) {

#ifdef USE_DGA
    if(usedga) {
      depth = DefaultDepth(mwin->GetDisplay(), 0);
      XGrabKeyboard(mwin->GetDisplay(), DefaultRootWindow(mwin->GetDisplay()), 
		    True, GrabModeAsync, GrabModeAsync, CurrentTime);
      XGrabPointer(mwin->GetDisplay(), DefaultRootWindow(mwin->GetDisplay()), 
		   True, PointerMotionMask | ButtonPressMask | 
		   ButtonReleaseMask, GrabModeAsync, GrabModeAsync, 
		   None, None, CurrentTime);
      XF86DGADirectVideo(mwin->GetDisplay(), 0, XF86DGADirectGraphics);
      {
      int ctr, n;
      double maxclock = gatos.aticard[gatos.cardidx].dotclock 
	                + gatos_overclock();
      maxclock *= 1000.0;
      XF86VidModeModeInfo curv, **allv;
      XF86VidModeGetAllModeLines(mwin->GetDisplay(), 0, &n, &allv);
      oldv = *(allv[0]);
      curv = oldv;
      if(curv.dotclock >= maxclock) {
	for(ctr = 0; ctr < n; ctr++)  {
	  if(allv[ctr]->dotclock < maxclock
	      && (allv[ctr]->hdisplay > curv.hdisplay
	      || allv[ctr]->vdisplay > curv.vdisplay
	      || curv.dotclock >= maxclock)) {
	    curv = *(allv[ctr]);
	    }
	  }
        }
      free(allv);
      XF86VidModeSwitchToMode(mwin->GetDisplay(), 0, &curv);
      }

     /* old quick-and-dirty DGA colorset method
      if(depth<=8)
	memset((unsigned char *)frame, 0,
		mwin->YDeskSize( ) * mwin->XDeskSize());
      else if(depth<=16)
	memset((unsigned char *)frame, 0,
		mwin->YDeskSize( ) * mwin->XDeskSize() << 1);
      else if(depth<=32)
	memset((unsigned char *)frame, 0,
		mwin->YDeskSize( ) * mwin->XDeskSize() << 2);
      else { printf("AARRGGGHH!!\n"); exit(0); }
      gatos_setcolorkey(0); */
	
	
      XF86DGASetViewPort(mwin->GetDisplay(), 0, 0, 0);
      XF86DGAGetViewPortSize(mwin->GetDisplay(), 0, &ctrx, &ctry);
      gatos_setgeometry(ctrx, ctry, 0, 0);
      DGADrawRectangle((u8 *)frame, depth, mwin->XDeskSize(),
		       0, 0, ctrx, ctry, gatos_colorkey());
      //oshow=show;
      fulldga = 1; oauto = autohide; ouauto = useautohide;
      useautohide = 0; autohide = 0; 
      //if(show) toggleshow(); 
      }
    else {
#endif USE_DGA

      tmpfar = far; far = 0; oldx = mwin->XSize(); oldy = mwin->YSize();
      oldxp = mwin->XPos(); oldyp = mwin->YPos();
      XMoveResizeWindow(mwin->GetDisplay(),mwin->GetWindow(), 0, 0,
			mwin->XDeskSize(), mwin->YDeskSize());

#ifdef USE_DGA
      }
#endif USE_DGA

    full = 1;
    }
  else if((!x) && full == 1) {

#ifdef USE_DGA
    if(usedga) {
      autohide = oauto; useautohide = ouauto; fulldga = 0;
      //show=0; if(oshow) toggleshow();
      //XF86VidModeSwitchToMode(mwin->GetDisplay(), 0, &oldv);
      XUngrabPointer(mwin->GetDisplay(), CurrentTime);
      XUngrabKeyboard(mwin->GetDisplay(), CurrentTime);
      XF86VidModeSwitchToMode(mwin->GetDisplay(), 0, &oldv);
      XF86DGADirectVideo(mwin->GetDisplay(), 0, 0);
      gatos_setcolorkey(mwin->GetWinBGColor());
      gatos_setgeometry(mwin->XSize(), mwin->YSize(), 
			mwin->XPos(), mwin->YPos());
      }
    else {
#endif USE_DGA

      XMoveResizeWindow(mwin->GetDisplay(), mwin->GetWindow(),
			oldxp, oldyp, oldx, oldy);
      far = tmpfar;

#ifdef USE_DGA
      }
#endif USE_DGA

    if(sdesk) {
      XSetForeground(mwin->GetDisplay(), mwin->GetGC(), 
		     mwin->GetWinBGColor());
      XFillRectangle(mwin->GetDisplay(), mwin->GetRootWindow(), mwin->GetGC(),
		     0, 0, mwin->XDeskSize(), mwin->YDeskSize());
      gatos_setgeometry(mwin->XDeskSize(), mwin->YDeskSize(), 0, 0);
      }
    full = 0;
    }
  }

/* ------------------------------------------------------------------------ */

//void iaCB(IDoDad *p, IDoDad *d, int x)  {
//  if((((ISButton *)d)->State()) && (!gatos_intaudio()))
//    gatos_setintaudio(1);
//  else if((((ISButton *)d)->State() == 0) && (gatos_intaudio()))
//    gatos_setintaudio(0);
//  }

/* ------------------------------------------------------------------------ */

void svszCB(IDoDad *p, IDoDad *d, int x)  {
  svsz = ((ISButton *)d)->State();
  }

/* ------------------------------------------------------------------------ */

void farCB(IDoDad *p, IDoDad *d, int x)  {
  far = ((ISButton *)d)->State();
  }

/* ------------------------------------------------------------------------ */

void coldCB(IDoDad *p, IDoDad *d, int x)  {
  if((((ISButton *)d)->State()) && (!gatos_cold())) {
    gatos_setcold(1);
    }
  else if((((ISButton *)d)->State()==0) && (gatos_cold())) {
    gatos_setcold(0);
    }
  }

/* ------------------------------------------------------------------------ */

void muteCB(IDoDad *p, IDoDad *d, int x)  {
  if((((ISButton *)d)->State()) && (!gatos_mute())) {
    gatos_setmute(1);
    }
  else if((((ISButton *)d)->State()==0) && (gatos_mute())) {
    gatos_setmute(0);
    }
  }

/* ------------------------------------------------------------------------ */

void stereoCB(IDoDad *p, IDoDad *d, int x)  {
  if((((ISButton *)d)->State()==0) && gatos_stereo()) {
    gatos_setstereo(!gatos_stereo());
    }
  else if((((ISButton *)d)->State()) && (!gatos_stereo())) {
    gatos_setstereo(!gatos_stereo());
    }
  }

/* ------------------------------------------------------------------------ */

void sapCB(IDoDad *p, IDoDad *d, int x)  {
  if((((ISButton *)d)->State()==0) && gatos_sap()) {
    gatos_setsap(!gatos_sap());
    }
  else if((((ISButton *)d)->State()) && (!gatos_sap())) {
    gatos_setsap(!gatos_sap());
    }
  }

/* ------------------------------------------------------------------------ */

void guich(IDoDad *p, IDoDad *d, int x)  {
  if(d == aguib) advgui = ((ISButton*)d)->State();
  else if(d == chguib) changui = ((ISButton*)d)->State();
  else if(d == captguib) captgui = ((ISButton*)d)->State();
  else {
    fprintf(stderr, _("Bad ButtonPress!\n"));
    exit(1);
    }
  updategui();
  }

/* ------------------------------------------------------------------------ */

void snapcb(IDoDad *p, IDoDad *d, int n)  {
  int h = xcaptb->GetVal(), v = ycaptb->GetVal();
  unsigned char *rgb = new unsigned char[3*h*v];
  gatos_rgbcapture(rgb);
  FILE *fl = fopen(captfl->GetText(), "w");
  fprintf(fl,"P6\n%d %d\n255\n",h,v) ;
  fwrite(rgb, 3, h*v, fl);
  fclose(fl);
  delete rgb;

  /* Increment filename */
  char buf[256], *ind;
  sprintf(buf, "%s%c", captfl->GetText(), 0);
  ind = &(buf[strlen(buf)]);
  while(ind > buf) {
    --ind;
    if(*ind >= '0' && *ind <= '8') { ++(*ind); break; }
    else if(*ind == '9') { *ind = '0'; }
    }
  captfl->SetText(buf);
  }

/* ------------------------------------------------------------------------ */

void reccb(IDoDad *p, IDoDad *d, int n)  {
  gatos_capture(captfl->GetText(), 0);
  recb->Disable();
  stopb->Enable();
  }

/* ------------------------------------------------------------------------ */

void playcb(IDoDad *p, IDoDad *d, int n)  {

#ifdef USE_IPC
  playback_running = 1;
#endif

  gatos_playback(captfl->GetText(), 0);
  playb->Disable();
  stopb->Enable();
  }

/* ------------------------------------------------------------------------ */

void clearcb(IDoDad *p, IDoDad *d, int n)  {
  unlink(captfl->GetText());
  }

/* ------------------------------------------------------------------------ */

void stopcb(IDoDad *p, IDoDad *d, int n)  {

  gatos_stop();

#ifdef USE_IPC
  if(playback_running) playback_running = 0;
#endif

  playb->Enable();
  recb->Enable();
  stopb->Disable();
  }

/* ------------------------------------------------------------------------ */

void cremcb(IDoDad *p, IDoDad *d, int)  {
  if(!gatos_tvtype()) {
    gatos_delchan(gatos_channel());
    if(gatos_channel() > 0) chnum->SetVal(gatos_channel());
    else chnum->SetVal(gatos_channel()+1);
    chnum->SetMax(gatos_numchans()-1);
    chnum->SetMin(0);
    chchan(NULL, chnum);
    chnum->Redraw();
    }
  else {
    gatos_disablechan(gatos_channel());
    chnum->SetElementFlag(chnum->GetVal(), ELEMENT_SKIP);
    chnum->Increment();
    }
  }

/* ------------------------------------------------------------------------ */

void caddcb(IDoDad *p, IDoDad *d, int)  {
  if(!gatos_tvtype()) {
    int ch = gatos_addchan(freq->GetVal(), _("New Channel"));
    chnum->Enable(); nameb->Enable();
    chnum->SetMax(gatos_numchans()-1);
    chnum->SetVal(ch+1);
    updatechgui();
    chnum->Redraw();
    }
  else {
    gatos_enablechan(gatos_channel());
    chnum->ClearElementFlag(chnum->GetVal(), ELEMENT_SKIP);
    }
  }

/* ------------------------------------------------------------------------ */

void cresetcb(IDoDad *p, IDoDad *d, int)  {
  cvol->SetValue(0);
  cbr->SetValue(0);
  ccnt->SetValue(0);
  chue->SetValue(0);
  csat->SetValue(0);
  }

/* ------------------------------------------------------------------------ */

void chchan(IDoDad *p, IDoDad *d)  {
  timeval tv;
  gettimeofday(&tv, NULL);
  time_t tmpt = tv.tv_sec;

#ifdef CC_CURSES
  if(useCC) cc_show();
#else
  EraseCCText();	
  if(useCC) ShowCCText();
#endif CC_CURSES

  if(lprev || lasttime < (tmpt-5)) {
    prevch = gatos_channel();  lprev = 0;
    }
  lasttime = tmpt;

  gatos.channel = ((IIntBox *)d)->GetVal();  // need this to update GUI.
  updatetextbox();
  updatechgui();
  /* Display message about a new channel */
#ifdef USE_DGA
  if((!show) || (usedga && full))
#else
  if(!show)
#endif USE_DGA
    ShowChannel(chnb->GetText());

  if(gatos_mux() == 2) {
    gatos_setchan(((IIntBox *)d)->GetVal());
    }
  cc_reset(); 
  }

/* ------------------------------------------------------------------------ */

void mixerCB(IDoDad *p, IDoDad *d, int n)  {
  gatos_setsoundmixer(n);
  }

/* ------------------------------------------------------------------------ */

void tvtypeCB(IDoDad *p, IDoDad *d, int n)  {
  if(tvtype_format[n]) gatos_setformat(tvtype_format[n]);
  gatos_settvtype(n);
  stdfreq = (double *)tvtype_chanfreq[n];
  maxstdchan = tvtype_chanmax[n];
  }

/* ------------------------------------------------------------------------ */

void setupCB(IDoDad *p, IDoDad *d, int n)  {
  if(((IButton *)d) == setupb) setupgui = 1;
  else if(((IButton *)d) == doneb) setupgui = 0;
  else {
    fprintf(stderr, _("Bad ButtonPress!\n"));
    exit(1);
    }
  updategui();
  }

/* ------------------------------------------------------------------------ */

static int scan_cancel = 0;

void canCB(IDoDad *p, IDoDad *d, int n)  {
  scan_cancel = 1;
  }

/* ------------------------------------------------------------------------ */

int scannerCB(double p)  {
  mwin->DispatchCurrentEvents();
  csisb->SetProgress(p-gatos_minfreq());
  csisb->Redraw();
  return (scan_cancel || mwin->HasQuit());
  }

/* ------------------------------------------------------------------------ */

void convert(IDoDad *p, IDoDad *d, int n)  {
  if(gatos_tvtype() > 0) {
    int ctr, ctrs, onum = gatos_numchans();
    char buf[128];
    chnum->SetMin(0);
    chnum->SetMax(maxstdchan-1);
    for(ctrs = 0; ctrs < maxstdchan; ctrs++) {
      if(stdfreq[ctrs] != 0.0) {
	if(VERBOSE) printf("%d: %f\n", ctrs, stdfreq[ctrs]);
	int best = -1; float diff, bdiff = 1.0;
	for(ctr = 0; ctr < onum; ctr++) {
	  diff = stdfreq[ctrs]-gatos_chanfreq(ctr);
	  diff *= diff;
	  if(gatos_chanenabled(ctr) && diff < bdiff)
	    { best = ctr; bdiff = diff; }
	  }
	if(best >= 0) {
	  if((gatos_channame(best)[0] <= '9' 
	      && gatos_channame(best)[0] >= '0'
	      && gatos_channame(best)[1] <= '9' 
	      && gatos_channame(best)[1] >= '0'
	      && gatos_channame(best)[2] <= '9' 
	      && gatos_channame(best)[2] >= '0'
	      && gatos_channame(best)[4] <= '9' 
	      && gatos_channame(best)[4] >= '0'
	      && gatos_channame(best)[5] <= '9' 
	      && gatos_channame(best)[5] >= '0'
	      && gatos_channame(best)[6] <= '9' 
	      && gatos_channame(best)[6] >= '0'
	      && gatos_channame(best)[3] == '.' 
	      && gatos_channame(best)[7] == ' '
	      && gatos_channame(best)[8] == 'M' 
	      && gatos_channame(best)[9] == 'H'
	      && gatos_channame(best)[10] == 'z' 
	      && gatos_channame(best)[11] == 0)
	      || (gatos_channame(best)[0] <= '9' 
	      && gatos_channame(best)[0] >= '0'
	      && gatos_channame(best)[1] <= '9' 
	      && gatos_channame(best)[1] >= '0'
	      && gatos_channame(best)[3] <= '9' 
	      && gatos_channame(best)[3] >= '0'
	      && gatos_channame(best)[4] <= '9' 
	      && gatos_channame(best)[4] >= '0'
	      && gatos_channame(best)[5] <= '9' 
	      && gatos_channame(best)[5] >= '0'
	      && gatos_channame(best)[2] == '.' 
	      && gatos_channame(best)[6] == ' '
	      && gatos_channame(best)[7] == 'M' 
	      && gatos_channame(best)[8] == 'H'
	      && gatos_channame(best)[9] == 'z' 
	      && gatos_channame(best)[10] == 0)) {
	    sprintf(buf, _("Channel %d%c"), ctrs, 0);
	    if(gatos_chanenabled(best)) {
	      int ch = gatos_addchan(gatos_chanfreq(best), buf);
	      gatos_enablechan(ch);
	      if(chnum) chnum->ClearElementFlag(ch-onum, ELEMENT_SKIP);
	      }
	    else {
	      int ch = gatos_addchan(gatos_chanfreq(best), buf);
	      gatos_disablechan(ch);
	      if(chnum) chnum->SetElementFlag(ch-onum, ELEMENT_SKIP);
	      }
	    }
	  else {
	    if(gatos_chanenabled(best)) {
	      int ch = gatos_addchan(gatos_chanfreq(best), 
				     gatos_channame(best));
	      gatos_enablechan(ch);
	      if(chnum) chnum->ClearElementFlag(ch-onum, ELEMENT_SKIP);
	      }
	    else {
	      int ch = gatos_addchan(gatos_chanfreq(best), 
				     gatos_channame(best));
	      gatos_disablechan(ch);
	      if(chnum) chnum->SetElementFlag(ch-onum, ELEMENT_SKIP);
	      }
	    }
	  }
	else {
	  sprintf(buf, _("Channel %d%c"), ctrs, 0);
	  int ch = gatos_addchan(stdfreq[ctrs], buf);
	  gatos_disablechan(ch);
	  if(chnum) chnum->SetElementFlag(ch-onum, ELEMENT_SKIP);
	  }
	}
      else {
	sprintf(buf, _("Channel %d%c"), ctrs, 0);
	int ch = gatos_addchan(stdfreq[ctrs], buf);
	gatos_disablechan(ch);
	if(chnum) chnum->SetElementFlag(ch-onum, ELEMENT_SKIP);
	}
      }
    for(ctr = 0; ctr < onum; ctr++) gatos_delchan(0);
    chchan(NULL, chnum);
    updatechgui();
    if(is_channel_enabled()) chnum->Enable();
    else chnum->Disable();
    chnum->Redraw();
    }
  }

/* ------------------------------------------------------------------------ */

void scanchan(IDoDad *p, IDoDad *d, int n)  {
  int sh = show; show = 0; updategui();

  scan_cancel = 0;
  scangui = 1;
  csitb1->Show();
  csitb2->Show();
  csitp1->Show();
  csitp2->Show();
  csisb->SetTotalWork(gatos_maxfreq()-gatos_minfreq());
  csisb->SetProgress(0.0);
  csisb->Show();
  cscan->Show();
  if(d == rescanb) chan_clearchans();
  gatos_chanscan(scannerCB);
  csitb1->Hide();
  csitb2->Hide();
  csitp1->Hide();
  csitp2->Hide();
  csisb->Hide();
  cscan->Hide();
  chchan(NULL, chnum);
  show = sh; updategui();
  convert(NULL, NULL, n);
  scangui = 0;
  }

/* ------------------------------------------------------------------------ */

void toggleshow()  {
  show = !show;
  updategui();
  }

/* ------------------------------------------------------------------------ */

void updatechgui()  {
  cfreq->SetChangeCallback(NULL);
  cvol->SetChangeCallback(NULL);
  cbr->SetChangeCallback(NULL);
  ccnt->SetChangeCallback(NULL);
  chue->SetChangeCallback(NULL);
  csat->SetChangeCallback(NULL);
  freq->SetChangeCallback(NULL);

  cfreq->SetVal(gatos_chanfreq(gatos_channel())); cfreq->Redraw();
  cvol->SetValue(gatos_chanvolume(gatos_channel()));
  cbr->SetValue(gatos_chanbrightness(gatos_channel()));
  ccnt->SetValue(gatos_chancontrast(gatos_channel()));
  chue->SetValue(gatos_chanhue(gatos_channel()));
  csat->SetValue(gatos_chansaturation(gatos_channel()));

  freq->SetVal(gatos_chanfreq(gatos_channel()));
  freq->Redraw();
  cfreq->SetChangeCallback(&chcfreq);
  cvol->SetChangeCallback(csld);
  cbr->SetChangeCallback(csld);
  ccnt->SetChangeCallback(csld);
  chue->SetChangeCallback(csld);
  csat->SetChangeCallback(csld);
  freq->SetChangeCallback(&chfreq);
  }

/* ------------------------------------------------------------------------ */

void updategui()  {
  csitb1->Hide();
  csitb2->Hide();
  csitp1->Hide();
  csitp2->Hide();
  csisb->Hide();
  cscan->Hide();
  if(show && (!setupgui)) {
    setupb->Show();
    aguib->Show();
    chguib->Show();
    captguib->Show();
    inp1->Show();
    inp2->Show();
    inp3->Show();
    svol->Show();
    chnum->Show();
    nameb->Show();
    muteb->Show();
    if(!gatos_audiotype())
      muteb->Disable();
    else
      muteb->Enable();
    CCt->Show();
    }
  else {
    setupb->Hide();
    aguib->Hide();
    chguib->Hide();
    captguib->Hide();
    inp1->Hide();
    inp2->Hide();
    inp3->Hide();
    svol->Hide();
    chnum->Hide();
    nameb->Hide();
    muteb->Hide();
    CCt->Hide();
    }
  if(show && (!setupgui) && advgui) {
    sbr->Show();
    scnt->Show();
    shue->Show();
    ssat->Show();
    stereob->Show();
    fullb->Show();
    sapb->Show();
    coldb->Show();
    gammas->Show();
    freq->Show();
    scanb->Show();
    }
  else {
    sbr->Hide();
    scnt->Hide();
    shue->Hide();
    ssat->Hide();
    stereob->Hide();
    fullb->Hide();
    sapb->Hide();
    coldb->Hide();
    gammas->Hide();
    freq->Hide();
    scanb->Hide();
    }
  if(show && (!setupgui) && captgui) {
    snapb->Show();
    playb->Show();
    recb->Show();
    stopb->Show();
    clearb->Show();
    captfl->Show();
    xcaptb->Show();
    ycaptb->Show();
    }
  else {
    snapb->Hide();
    playb->Hide();
    recb->Hide();
    stopb->Hide();
    clearb->Hide();
    captfl->Hide();
    xcaptb->Hide();
    ycaptb->Hide();
    }
  if(show && (!setupgui) && changui) {
    cvol->Show();
    cbr->Show();
    ccnt->Show();
    chue->Show();
    csat->Show();
    cadd->Show();
    crem->Show();
    creset->Show();
    cfreq->Show();
    chnb->Show();
    }
  else {
    cvol->Hide();
    cbr->Hide();
    ccnt->Hide();
    chue->Hide();
    csat->Hide();
    crem->Hide();
    cadd->Hide();
    creset->Hide();
    cfreq->Hide();
    chnb->Hide();
    }
  if(show && setupgui) {
    formb->Show();
    forml->Show();
    optl->Show();
    if(gatos_nummixers() > 0) { 
      mixl->Show(); 
      mixerb->Show();
      }
    svszb->Show();
    farb->Show();
    doneb->Show();
    rescanb->Show();
    convertb->Show();
    deskb->Show();
    CCb->Show();
    CCl->Show();
    topb->Show();
    dotb->Show();
    dotl->Show();
    ahb->Show();
    ahl->Show();
    senscb->Show();

#ifdef USE_DGA
    dgab->Show();
#endif USE_DGA

#ifdef GATOSBUTTONS
    int ctr;
    for(ctr = 0; ctr < GATOSBUTTONS; ++ctr) {
      testb[ctr]->Show();
      testl[ctr]->Show();
      }
#endif GATOSBUTTONS

    }
  else {
    formb->Hide();
    if(gatos_nummixers() > 0) {
      mixerb->Hide();
      mixl->Hide();
      }
    forml->Hide();
    optl->Hide();
    svszb->Hide();
    farb->Hide();
    doneb->Hide();
    rescanb->Hide();
    convertb->Hide();
    deskb->Hide();
    CCb->Hide();
    CCl->Hide();
    topb->Hide();
    dotb->Hide();
    dotl->Hide();
    ahb->Hide();
    ahl->Hide();
    senscb->Hide();

#ifdef USE_DGA
    dgab->Hide();
#endif USE_DGA

#ifdef GATOSBUTTONS
    int ctr;
    for(ctr = 0; ctr < GATOSBUTTONS; ++ctr) {
      testb[ctr]->Hide();
      testl[ctr]->Hide();
      }
#endif GATOSBUTTONS

    }
  mwin->RebuildClip();
//  mwin->Redraw();
  cctext_repaint = 1;
  ShowCCText();
  }

/* ------------------------------------------------------------------------ */

void initgui()  {
/* Install the on-top war prevention handler */
  struct sigaction act;
  act.sa_flags = 0;

#if defined(__linux__)
  act.sa_restorer = NULL;
#endif __linux__

  sigemptyset(&act.sa_mask);
  act.sa_handler = &OnTopAgain;
  sigaction(SIGALRM, &act, NULL);

/* Round up standards and mixer box sizes for faster clip regions */
  int stsz = ((NUM_STANDARDS*13+6+9)/10)*10;
  int mxsz = ((gatos_nummixers()*13+6+9)/10)*10;

  setupb = new IButton(_("Setup"), mwin, 80, 10, 50, 20);
  setupb->SetClickCallback(&setupCB); 
  aguib = new ISButton(_("Adv."), mwin, 130, 10, 50, 20);
  if(advgui) aguib->Press(0, 0, 0);
  aguib->SetDownCallback(&guich); aguib->SetUpCallback(&guich);
  captguib = new ISButton(_("Capture"), mwin, 180, 10, 50, 20);
  if(captgui) captguib->Press(0, 0, 0);
  captguib->SetDownCallback(&guich); captguib->SetUpCallback(&guich);
  chguib = new ISButton(_("Edit Channel"), mwin, 140, 70, 90, 20);
  if(changui) chguib->Press(0, 0, 0);
  chguib->SetDownCallback(&guich); chguib->SetUpCallback(&guich);
  inp3 = new ISButton(_("TV"), mwin, 10, 10, 20, 20);
  inp2 = new ISButton(_("CV"), mwin, 30, 10, 20, 20);
  inp1 = new ISButton(_("SV"), mwin, 50, 10, 20, 20);
  inp1->SetDownCallback(inp); inp1->SetUpCallback(ButtonRadioReleaseCB);
  if(gatos_mux() == 3 || gatos_mux() == 0) inp1->Press(0, 0, 0);
  inp2->SetDownCallback(inp); inp2->SetUpCallback(ButtonRadioReleaseCB);
  if(gatos_mux() == 1) inp2->Press(0, 0, 0);
  inp3->SetDownCallback(inp); inp3->SetUpCallback(ButtonRadioReleaseCB);
  if(gatos_mux() == 2) inp3->Press(0, 0, 0);

  svol = new ISlider(_("Volume: "), mwin, 10, 30, 150, 20);
  svol->SetMin(0); svol->SetMax(100); svol->SetValue(gatos_volume());
  svol->SetChangeCallback(sld);
  if(gatos_nummixers() <= 0) svol->Disable();
  muteb = new ISButton(_("Mute"), mwin, 160, 30, 40, 20);
  muteb->SetDownCallback(muteCB); muteb->SetUpCallback(muteCB);
  if(gatos_mute()) muteb->Press(0, 0, 0);
  if(!gatos_audiotype())
    muteb->Disable();
  else
    muteb->Enable();
  CCt = new ISButton(_("CC"), mwin, 200, 30, 30, 20);
  CCt->SetDownCallback(CCtCB); CCt->SetUpCallback(CCtCB);

  chnum = new IIntBox(0, mwin, 10, 50, 50, 20);
  chnum->SetMin(0);
  chnum->SetMax(gatos_numchans()-1); chnum->SetVal(gatos_channel());
  chnum->SetFlags(IBTK_WRAP|IBTK_SUPPLEMENTARY);
  chnum->SetChangeCallback(chchan);
  for(int ctr = 0; ctr < gatos_numchans(); ctr++) {
    if(chan_flag(ctr, CHANNEL_SKIP))
      if(chnum) chnum->SetElementFlag(ctr, ELEMENT_SKIP);
    }

  if(gatos_mux() != 2) chnum->Disable();
  nameb = new IBox("", mwin, 60, 50, 170, 20);
  nameb->SetChangeCallback(chname);
  freq = new IRealBox(gatos_chanfreq(gatos_channel()),
		      mwin, 10, 70, 80, 20);
  freq->SetMin(gatos_minfreq()); freq->SetMax(gatos_maxfreq());
  freq->SetIncVal(0.0625); freq->SetChangeCallback(&chfreq);

  sbr = new ISlider(_("Brightness: "), mwin, 10, 90, 220, 20);
  sbr->SetMin(0); sbr->SetMax(200); sbr->SetValue(gatos_brightness());
  sbr->SetChangeCallback(sld);
  scnt = new ISlider(_("Contrast: "), mwin, 10, 110, 220, 20);
  scnt->SetMin(0); scnt->SetMax(200); scnt->SetValue(gatos_contrast());
  scnt->SetChangeCallback(sld);
  shue = new ISlider(_("Hue: "), mwin, 10, 130, 220, 20);
  shue->SetMin(-90); shue->SetMax(90); shue->SetValue(gatos_hue());
  shue->SetChangeCallback(sld);
  ssat = new ISlider(_("Saturation: "), mwin, 10, 150, 220, 20);
  ssat->SetMin(0); ssat->SetMax(200); ssat->SetValue(gatos_saturation());
  ssat->SetChangeCallback(sld);
  stereob = new ISButton(_("Stereo"), mwin, 110, 170, 50, 20);
  stereob->SetDownCallback(stereoCB); stereob->SetUpCallback(stereoCB);
  if(gatos_stereo()) stereob->Press(0, 0, 0);
  sapb = new ISButton(_("SAP"), mwin, 160, 170, 30, 20);
  sapb->SetDownCallback(sapCB); sapb->SetUpCallback(sapCB);
  if(gatos_sap()) sapb->Press(0, 0, 0);
  fullb = new ISButton(_("Full"), mwin, 190, 170, 40, 20);
  fullb->SetDownCallback(fullCB); fullb->SetUpCallback(fullCB);
  coldb = new ISButton(_("Cold"), mwin, 10, 170, 40, 20);
  coldb->SetDownCallback(coldCB); coldb->SetUpCallback(coldCB);
  if(gatos_cold()) coldb->Press(0, 0, 0);
  gammas = new ISlider(_("Gamma: "), mwin, 50, 170, 60, 20);
  gammas->SetMin(0); gammas->SetMax(3); gammas->SetValue(gatos_gamma());
  gammas->SetChangeCallback(sld);
  scanb = new IButton(_("Scan"), mwin, 90, 70, 50, 20);
  scanb->SetDownCallback(scanchan);

  clearb = new IButton(_("Delete"), mwin, 30, 200, 60, 20);
  clearb->SetClickCallback(&clearcb);
  captfl = new IBox("gatos000.ppm", mwin, 90, 200, 120, 20);
  snapb = new IButton(_("Snap"), mwin, 30, 220, 45, 20);
  snapb->SetClickCallback(&snapcb);
  recb = new IButton(_("Rec"), mwin, 75, 220, 45, 20);
  recb->SetClickCallback(&reccb);
  playb = new IButton(_("Play"), mwin, 120, 220, 45, 20);
  playb->SetClickCallback(&playcb);
  stopb = new IButton(_("Stop"), mwin, 165, 220, 45, 20);
  stopb->Disable(); stopb->SetClickCallback(&stopcb);
  xcaptb = new IIntBox(gatos_xcapt(), mwin, 30, 240, 90, 20);
  xcaptb->SetMin(gatos_xcaptmin()); xcaptb->SetMax(gatos_xcaptmax());
  xcaptb->SetChangeCallback(&chcapt);
  ycaptb = new IIntBox(gatos_ycapt(), mwin, 120, 240, 90, 20);
  ycaptb->SetMin(gatos_ycaptmin()); ycaptb->SetMax(gatos_ycaptmax());
  ycaptb->SetChangeCallback(&chcapt);

  cadd = new IButton(_("Add"), mwin, 240, 10, 50, 20);
  cadd->SetClickCallback(&caddcb);
  crem = new IButton(_("Remove"), mwin, 290, 10, 50, 20);
  crem->SetClickCallback(&cremcb);
  cfreq = new IRealBox(gatos_chanfreq(gatos_channel()),
		       mwin, 240, 30, 100, 20);
  cfreq->SetMin(gatos_minfreq()); cfreq->SetMax(gatos_maxfreq());
  cfreq->SetIncVal(0.0625); cfreq->SetChangeCallback(&chcfreq);
  chnb = new IBox("", mwin, 240, 50, 100, 20);
  chnb->SetChangeCallback(chdesc);
  updatetextbox();
  cvol = new ISlider(_("Vol: "), mwin, 240, 70, 100, 20);
  cvol->SetMin(-30); cvol->SetMax(30);
  cvol->SetValue(gatos_chanvolume(gatos_channel()));
  cvol->SetChangeCallback(csld);
  if(gatos_nummixers() <= 0) cvol->Disable();
  cbr = new ISlider(_("Bright: "), mwin, 240, 90, 100, 20);
  cbr->SetMin(-30); cbr->SetMax(30);
  cbr->SetValue(gatos_chanbrightness(gatos_channel()));
  cbr->SetChangeCallback(csld);
  ccnt = new ISlider(_("Contr: "), mwin, 240, 110, 100, 20);
  ccnt->SetMin(-30); ccnt->SetMax(30);
  ccnt->SetValue(gatos_chancontrast(gatos_channel()));
  ccnt->SetChangeCallback(csld);
  chue = new ISlider(_("Hue: "), mwin, 240, 130, 100, 20);
  chue->SetMin(-30); chue->SetMax(30);
  chue->SetValue(gatos_chanhue(gatos_channel()));
  chue->SetChangeCallback(csld);
  csat = new ISlider(_("Sat: "), mwin, 240, 150, 100, 20);
  csat->SetMin(-30); csat->SetMax(30);
  csat->SetValue(gatos_chansaturation(gatos_channel()));
  csat->SetChangeCallback(csld);
  creset = new IButton(_("Set to Default"), mwin, 240, 170, 100, 20);
  creset->SetClickCallback(&cresetcb);

  forml = new ITextBox(_("Select Television Type"), mwin, 10, 10, 300, 20);
  formb = new IListBox((char **)tvtype_names, NUM_STANDARDS, mwin, 10, 30, 300,
		       stsz);
  formb->SetSelCallback(tvtypeCB); formb->SetDCCallback(tvtypeCB);
  formb->Select(gatos_tvtype());
  if(gatos_nummixers() > 0) {
    mixl = new ITextBox(_("Mixer"), mwin, 460, 10, 100, 20);
    mixerb = new IListBox(gatos_mixerlabels(), gatos_nummixers(),
			  mwin, 460, 30, 100, mxsz);
    mixerb->SetSelCallback(mixerCB); mixerb->SetDCCallback(mixerCB);
    mixerb->Select(gatos_mixer());
    }
  optl = new ITextBox(_("Option"), mwin, 320, 10, 130, 20);
  svszb = new ISButton(_("Save Window Size"), mwin, 320, 30, 130, 20);
  if(svsz) svszb->Press(0, 0, 0);
  svszb->SetDownCallback(svszCB); svszb->SetUpCallback(svszCB);
  farb = new ISButton(_("Fixed Aspect Ratio"), mwin, 320, 50, 130, 20);
  if(far) farb->Press(0, 0, 0);
  farb->SetDownCallback(farCB); farb->SetUpCallback(farCB);
  topb = new ISButton(_("Always On Top"), mwin, 320, 70, 130, 20);
  if(ontop) topb->Press(0, 0, 0);
  topb->SetDownCallback(topCB); topb->SetUpCallback(topCB);
  deskb = new ISButton(_("Use Desktop Mode"), mwin, 320, 90, 130, 20);
  deskb->SetDownCallback(deskCB); deskb->SetUpCallback(deskCB);
  if(usedesk) deskb->Press(0, 0, 0);
  ahb = new IIntBox((useautohide+99)/100, mwin, 410, 110, 40, 20);
  ahb->SetMin(0); ahb->SetMax(10); ahb->SetChangeCallback(ahCB);
  ahl = new ISButton(_("Autohide"), mwin, 320, 110, 90, 20);
  ahl->SetDownCallback(ahlCB); ahl->SetUpCallback(ahlCB);
  if(useautohide) ahl->Press(0, 0, 0);
  else ahb->Disable();
  senscb = new ISButton(_("Use Sensitive SCAN"), mwin, 320, 130, 130, 20);
  if(gatos_senscan()) senscb->Press(0, 0, 0);
  senscb->SetDownCallback(senscCB); senscb->SetUpCallback(senscCB);
  dotl = new ITextBox(_("Overclock"), mwin, 320, 150, 90, 20);
  dotb = new IIntBox(gatos_overclock(), mwin, 410, 150, 40, 20);
  dotb->SetMin(-20); dotb->SetMax(20); dotb->SetChangeCallback(dotCB);

#ifdef USE_DGA
  dgab = new ISButton(_("Use DGA/VM"), mwin, 320, 170, 130, 20);
  if(usedga) dgab->Press(0, 0, 0);
  dgab->SetDownCallback(dgaCB); dgab->SetUpCallback(dgaCB);
#endif USE_DGA

#ifdef GATOSBUTTONS
  int ctr; char buf[16];

  for(ctr = 0; ctr < GATOSBUTTONS; ++ctr) {
    sprintf(buf, _("Test Var #%d%c"), ctr+1, 0);
    testl[ctr] = new ITextBox(buf, mwin, 320, 200+(20*ctr), 90, 20);
    testb[ctr] = new IIntBox(gatos_testbutton(ctr), mwin,
			     410, 200+(20*ctr), 40, 20);
    testb[ctr]->SetMin(-1000000); testb[ctr]->SetMax(1000000);
    testb[ctr]->SetChangeCallback(testCB);
    }
#endif GATOSBUTTONS

  CCb = new ITextBox(_("CC Mode"), mwin, 10, stsz+40, 110, 20);
  char *ccms[4] = { _("CC1"), _("CC2"), _("Text1"), _("Text2") };
  CCl = new IListBox(ccms, 4, mwin, 10, stsz+60, 110, 4*13+6);
  CCl->Select(ccmode); CCl->SetSelCallback(CCCB);

  rescanb = new IButton(_("Rescan Channels"), mwin, 130, stsz+40, 140, 20);
  rescanb->SetClickCallback(&scanchan); 
  convertb = new IButton(_("Convert to Standard"), mwin, 130, stsz+60, 
			 140, 20);
  convertb->SetClickCallback(&convert); 

  doneb = new IButton(_("Done"), mwin, 130, stsz+80, 140, 20);
  doneb->SetClickCallback(&setupCB); 

  csitb1 = new ITextBox(_("Scanning For Channels"), mwin, 10, 10, 200, 20);
  csitp1 = new ITextBox("", mwin, 10, 30, 20, 20);
  csisb = new IStatBar(mwin, 30, 30, 160, 20);
  csitp2 = new ITextBox("", mwin, 190, 30, 20, 20);
  csitb2 = new ITextBox(_("Please Be Patient"), mwin, 10, 50, 200, 20);
  cscan = new IButton(_("Done"), mwin, 30, 80, 160, 20);
  cscan->SetClickCallback(&canCB);

  updategui();
  updatetextbox();
//  mwin->Redraw();
  }

/* ------------------------------------------------------------------------ */

void loadstate()  {
  gatos_getintvalue("Autohide=", &useautohide);
  gatos_getintvalue("ShowGUI=", &show);
  gatos_getintvalue("ChanGUI=", &changui);
  gatos_getintvalue("CaptGUI=", &captgui);
  gatos_getintvalue("AdvGUI=", &advgui);
  gatos_getintvalue("SaveSize=", &svsz);
  gatos_getintvalue("FixedAspectRatio=", &far);

#ifdef USE_DGA
  gatos_getintvalue("UseDGA=", &usedga);
#endif USE_DGA

  gatos_getintvalue("UseDesktopMode=", &usedesk);
  gatos_getintvalue("AlwaysOnTop=", &ontop);
  gatos_getintvalue("CC_Mode=", &ccmode);
  gatos_getintvalue("FavChannel1=", &favch[0]);
  gatos_getintvalue("FavChannel2=", &favch[1]);
  gatos_getintvalue("FavChannel3=", &favch[2]);
  gatos_getintvalue("FavChannel4=", &favch[3]);
  gatos_getintvalue("FavChannel5=", &favch[4]);
  gatos_getintvalue("FavChannel6=", &favch[5]);
  gatos_getintvalue("FavChannel7=", &favch[6]);
  gatos_getintvalue("FavChannel8=", &favch[7]);
  gatos_getintvalue("SaveSize=", &svsz);
  if(svsz) {
    gatos_getintvalue("XSize=", &ixs);
    gatos_getintvalue("YSize=", &iys);

    /* If UseDGA is unset and SaveSize is set, and
     * if xatitv is equal/wider than RootWindow, xatitv
     * will crash (green window).
     * So xatitv window geometry will be forced to 
     * RootWindow geometry - 50 (really arbitrary!). DCB
     */
#ifdef USE_DGA
    if(usedga == 0) {
#endif USE_DGA

      if(ixs >= GetWindowXSize(mwin->GetDisplay(), 
			       mwin->GetRootWindow())
	  || iys >= GetWindowYSize(mwin->GetDisplay(),
				   mwin->GetRootWindow())) {
	ixs = (GetWindowXSize(mwin->GetDisplay(), mwin->GetRootWindow())-50);
	iys = (GetWindowYSize(mwin->GetDisplay(), mwin->GetRootWindow())-50);
        }

#ifdef USE_DGA
      }
#endif USE_DGA

    }
  }

/* ------------------------------------------------------------------------ */

void savestate()  {
  gatos_setintvalue("Autohide=", useautohide);
  gatos_setintvalue("ShowGUI=", show);
  gatos_setintvalue("ChanGUI=", changui);
  gatos_setintvalue("CaptGUI=", captgui);
  gatos_setintvalue("AdvGUI=", advgui);
  gatos_setintvalue("SaveSize=", svsz);
  gatos_setintvalue("FixedAspectRatio=", far);

#ifdef USE_DGA
  gatos_setintvalue("UseDGA=", usedga);
#endif USE_DGA

  gatos_setintvalue("UseDesktopMode=", usedesk);
  gatos_setintvalue("AlwaysOnTop=", ontop);
  gatos_setintvalue("CC_Mode=", ccmode);
  gatos_setintvalue("FavChannel1=", favch[0]);
  gatos_setintvalue("FavChannel2=", favch[1]);
  gatos_setintvalue("FavChannel3=", favch[2]);
  gatos_setintvalue("FavChannel4=", favch[3]);
  gatos_setintvalue("FavChannel5=", favch[4]);
  gatos_setintvalue("FavChannel6=", favch[5]);
  gatos_setintvalue("FavChannel7=", favch[6]);
  gatos_setintvalue("FavChannel8=", favch[7]);
  gatos_setintvalue("SaveSize=", svsz);
  gatos_setintvalue("XSize=", mwin->XSize());
  gatos_setintvalue("YSize=", mwin->YSize());
  }

/* ------------------------------------------------------------------------ */
/*
void visibility(XVisibilityEvent &e) {
  if(ontop && e.state) XRaiseWindow(mwin->GetDisplay(), mwin->GetWindow());
  gatos_setvisibility(e.state);
  cctext_repaint=1;
  }
*/
/* ------------------------------------------------------------------------ */

void OnTopAgain(int sig)  {
  ontop = 1;
  XRaiseWindow(mwin->GetDisplay(), mwin->GetWindow());
  }

/* ------------------------------------------------------------------------ */

void visibility(XVisibilityEvent &e)  {
  if(ontop && e.state) {
    if(ontop > 10) {
      ontop = 0; alarm(7);
      }
    else {
      ontop++;
      XRaiseWindow(mwin->GetDisplay(), mwin->GetWindow());
      }
    }
  gatos_setvisibility(e.state);
  cctext_repaint = 1;
  }

/* ------------------------------------------------------------------------ */
/*
 * Return 1 if at least 1 channel is enabled
 */
int is_channel_enabled(void)  {
  int ctrs;

  for(ctrs = 0; ctrs < maxstdchan; ctrs++) {
    if(gatos_chanenabled(ctrs)) return 1;
    }
  return 0;
  }

/* ------------------------------------------------------------------------ */
