*
* $Id: lr2bod.F,v 1.1.1.1 1995/10/24 10:21:57 cernlib Exp $
*
* $Log: lr2bod.F,v $
* Revision 1.1.1.1  1995/10/24 10:21:57  cernlib
* Geant
*
*
#include "geant321/pilot.h"
*CMZ :  3.21/02 29/03/94  15.41.48  by  S.Giani
*-- Author :
      SUBROUTINE LR2BOD(D,LD,KZ1,KZ2,A1,A2,Z1,Z2,ATAR,Q,SQ,ID,MT)
C       THIS ROUTINE CALCULATES THE EXIT ENERGIES AND DIRECTIONAL
C       COSINES FOR THE CHARGED PARTICLE AND RECOIL NUCLEUS FOR
C       A TWO-BODY REACTION USING AN EVAPORATION SPECTRUM AND
C       MOMEMTUM BALANCE.  IT ALSO SETS ALL EXIT PARAMETERS FOR
C       THE COLLISION PRODUCTS AND STORES THEM IN THE RECOIL BANK.
C       THE TWO BODY REACTION RESULTS FROM THE BREAK-UP OF A NUCLEUS
C       LEFT IN AN EXCITED STATE BY AN INELASTIC COLLISION
C       DESIGNATED BY A LR-FLAG IN THE INELASTIC RESOLVED DATA
#include "geant321/minput.inc"
#include "geant321/mconst.inc"
#include "geant321/mnutrn.inc"
#include "geant321/mrecoi.inc"
#include "geant321/mapoll.inc"
#include "geant321/mmass.inc"
#include "geant321/mpstor.inc"
      DIMENSION D(*),LD(*)
      SAVE
C       CALCULATE THE CONSTANTS USED IN THE KINEMATIIC EQUATIONS
      ZATAR=ATAR*9.31075E+08
C       FOR A CARBON-ALPHA EMISSION THE RECOIL MASS IS KNOWN EXACTLY
      IF(KZ1+KZ2.EQ.6)Z2=ZATAR-Z1-SQ
      IF(KZ1+KZ2.EQ.6)A2=Z2/9.31075E+08
C       TRANSFER THE RECOILING COMPOUND NUCLEUS PARAMETERS OUT OF
C       COMMON RECOIL FOR USE IN THE MOMENTUM BALANCE EQUATIONS
      ERCN=ER
      URCN=UR
      VRCN=VR
      WRCN=WR
      ARCN=AR
      NZRCN=NZR
      ZARCN=ARCN*9.31075E+08
      IF(MT.EQ.23)GO TO 10
C       CALCULATE THE COULOMB BARRIER (CB)
      CALL BARIER(KZ1,KZ2,A1,A2,CB)
C       CALCULATE THE ENERGY AVAILABLE IN THE CENTER OF MASS (EAV)
      CALL EVAPLR(E,Q,SQ,ATAR,CB,EX)
      EAV=EX+CB
      GO TO 30
   10 IF((ID.EQ.54).AND.(KZ1+KZ2.EQ.6))GO TO 20
      EAV=ABS(Q)+SQ
      GO TO 30
   20 Q=EOLD-E-ERCN
      IF(Q.LE.ABS(SQ))Q=7.65300E+06
      EAV=Q+SQ
   30 CONTINUE
C       CALCULATE THE CHARGED PARTICLE ENERGY USING CONSERVATION
C       OF MOMENTUM (CENTER OF MASS SYSTEM)
      E1CM=(A2/(A1+A2))*EAV
C       ASSUME ISOTROPIC CHARGED PARTICLE EMISSION IN THE CENTER
C       OF MASS COORDINATE SYSTEM
      R=FLTRNF(0)
      FM=2.0*R-1.0
C       CALCULATE THE VELOCITY OF THE CENTER OF MASS AND THE
C       CHARGED PARTICLE IN THE CENTER OF MASS SYSTEM
      VCM=SQRT((2.0*ERCN)/ZARCN)
      V1CM=SQRT((2.0*E1CM)/Z1)
C       CALCULATE THE CHARGED PARTICLE ENERGY IN THE LABORATORY
C       COORDINATE SYSTEM
      E1=0.5*Z1*(VCM**2+V1CM**2+VCM*V1CM*FM)
C       CONVERT THE COSINE OF THE SCATTERING ANGLE IN THE CENTER OF
C       MASS COORDINATE SYSTEM TO THE LABORATORY COORDINATE SYSTEM
      FM=(V1CM*FM+VCM)/(SQRT(((V1CM*FM+VCM)**2)+((V1CM*(1.0-FM**2))
     1**2)))
C       CALCULATE THE CHARGED PARTICLE EXIT DIRECTIONAL COSINES
      SINPSI=SQRT(1.0-FM**2)
      CALL AZIRN(SINETA,COSETA)
      STHETA=1.0-URCN**2
      IF(STHETA)50,50,40
   40 STHETA=SQRT(STHETA)
      COSPHI=VRCN/STHETA
      SINPHI=WRCN/STHETA
      GO TO 60
   50 COSPHI=1.0
      SINPHI=0.0
      STHETA=0.0
   60 U1=URCN*FM-COSETA*SINPSI*STHETA
      V1=VRCN*FM+URCN*COSPHI*COSETA*SINPSI-SINPHI*SINPSI*SINETA
      W1=WRCN*FM+URCN*SINPHI*COSETA*SINPSI+COSPHI*SINPSI*SINETA
      S=1.0/SQRT(U1**2+V1**2+W1**2)
      U1=U1*S
      V1=V1*S
      W1=W1*S
C       CALCULATE AND SET THE CHARGED PARTICLE EXIT PARAMETERS
      XR=X
      YR=Y
      ZR=Z
      WATER=WTBC
      NZR=KZ1
      AGER=AGE
      NCOLR=NCOL
      MTNR=MT
      AR=A1
      ENIR=EOLD
      UNIR=UOLD
      VNIR=VOLD
      WNIR=WOLD
      ENOR=E
      UNOR=U
      VNOR=V
      WNOR=W
      WTNR=WATE
      QR=Q
      UR=U1
      VR=V1
      WR=W1
      ER=E1
C       STORE THE CHARGED PARTICLE IN THE RECOIL BANK
      EP = ER
      UP = UR
      VP = VR
      WP = WR
      AGEP = AGE
      MTP = MT
      AMP = AR
      ZMP = FLOAT(NZR)
      CALL STOPAR(IDHEVY,NHEVY)
C       CALCULATE THE TOTAL MOMENTUM BEFORE THE COLLISION
C       COMPOUND NUCLEUS MOMENTUM BEFORE THE COLLISION (PI) EQUALS
C       THE TOTAL MOMENTUM
      PI=SQRT(2.0*ZARCN*ERCN)
C       CALCULATE THE TOTAL MOMEMTUM OF THE EXIT CHARGED PARTICLE
      PO=SQRT(2.0*Z1*E1)
C       CALCULATE THE DIRECTIONAL MOMENTUM OF THE RECOIL NUCLEUS
      PRX=PI*URCN-PO*U1
      PRY=PI*VRCN-PO*V1
      PRZ=PI*WRCN-PO*W1
C       CALCULATE THE TOTAL MOMENTUM OF THE RECOIL NUCLEUS
      PR=SQRT(PRX**2+PRY**2+PRZ**2)
C       CALCULATE THE RECOIL NUCLEUS DIRECTIONAL COSINES
      U2=PRX/PR
      V2=PRY/PR
      W2=PRZ/PR
C       CALCULATE THE RECOIL NUCLEUS EXIT ENERGY
      XM = A2*931.075E6
      E2 = SQRT(PR**2+XM**2) - XM
C       CALCULATE AND SET THE CHARGED PARTICLE EXIT PARAMETERS
      XR=X
      YR=Y
      ZR=Z
      WATER=WTBC
      NZR=KZ2
      AGER=AGE
      NCOLR=NCOL
      MTNR=MT
      AR=A2
      ENIR=EOLD
      UNIR=UOLD
      VNIR=VOLD
      WNIR=WOLD
      ENOR=E
      UNOR=U
      VNOR=V
      WNOR=W
      WTNR=WATE
      QR=Q
      UR=U2
      VR=V2
      WR=W2
      ER=E2
      IF((KZ2.EQ.4).AND.(MT.EQ.23))RETURN
C       STORE THE RECOIL HEAVY ION IN THE RECOIL BANK
      EP = ER
      UP = UR
      VP = VR
      WP = WR
      AGEP = AGE
      MTP = MT
      AMP = AR
      ZMP = FLOAT(NZR)
      CALL STOPAR(IDHEVY,NHEVY)
      RETURN
      END
