// -*-C++-*-
// This file is part of the gmod package
// Copyright (C) 1997 by Andrew J. Robinson

#include "CommentShell.h"

CommentShell::CommentShell(QWidget *w) : QWidget(w, "commentShell")
{
  setMinimumSize(60, 40);
  setCaption("Xgmod Comment");
 
  commentEdit = new QMultiLineEdit(this, "commentLabel");
  commentEdit->setGeometry(5, 5, 200, 160);
  commentEdit->setReadOnly(TRUE);
  commentEdit->setFrameStyle(QFrame::Panel | QFrame::Sunken);

  closeButton = new QPushButton(this, "closeButton");
  closeButton->setText("Close");
  closeButton->setGeometry(75, 200, 60, 25);
  closeButton->connect(closeButton,  SIGNAL(clicked()), this, SLOT(closeCommentShell()));
  
  resize(210, 200);
}

void
CommentShell::setComment(char *text, int lineLen)
{
  char *beginLine, *endLine;
  char oldChar;

  beginLine = text;
  commentEdit->setAutoUpdate(FALSE);
  commentEdit->clear();

  if (!*beginLine || !lineLen)
    commentEdit->setText(text);
  else
    while (*beginLine)
      {
	endLine = beginLine + 1;
	
	while (*endLine && (*endLine != '\n') &&
	       (endLine < (beginLine + lineLen)))
	  endLine++;
	
	oldChar = *endLine;
	*endLine = 0;
	commentEdit->insertLine(beginLine);
	*endLine = oldChar;
	
	if (oldChar == '\n')
	  endLine++;
	
	beginLine = endLine;
      }
  
  commentEdit->repaint();
  commentEdit->setAutoUpdate(TRUE);
}

void
CommentShell::showCommentShell()
{
  show();
}

void
CommentShell::closeCommentShell()
{
  close();
}

void
CommentShell::resizeEvent(QResizeEvent *)
{
  closeButton->move((width() - 60) / 2, height() - 30);
  commentEdit->resize(width() - 10, height() - 40);
}

#ifndef DEPEND
#include "CommentShell.moc"
#endif
