// -*-C++-*-
// This file is part of the gmod package
// Copyright (C) 1997 by Andrew J. Robinson

#include <sys/ioctl.h>
#include <stdlib.h>		/* for "free" */
#include <ctype.h>		/* for "isprint */
#include <unistd.h>		/* for "pause" */

#ifdef USE_LOCAL
#include "soundcard.h"
#else
#include <sys/soundcard.h>
#endif

#include <sys/ultrasound.h>

#include "defines.h"
#include "structs.h"
#include "globals.h"

#include "Sample.h"

int
panning (int ch)
{
  static int panningTab[] =
    {0, 255, 255, 0};

  return panningTab[ch % 4];
}

double lastSync;
double lastDump;

void
syncTime ()
{
  SEQ_DECLAREBUF();

  if (nextTime > thisTime)
    {
      SEQ_WAIT_TIME ((long) nextTime);
      thisTime = nextTime;
    }
}

void
freePatterns ()
{
  int i;
  extern Sample *samples[];

  for (i = 0; i < MAX_PATTERN * MAX_TRACK; i++)
    if (patternTable[i] != NULL)
    {
      free (patternTable[i]);
      patternTable[i] = NULL;
    }

  for (i = 0; i < MAX_SAMPLES; i++)
    if (samples[i])
      {
	delete samples[i];
	samples[i] = 0;
      }
}

void
removeNoprint (char *string)
{
  char *str2 = string;

  /* remove non-printable characters */

  while (*str2 != '\0')
    {
      if (!isprint (*str2))
	*str2 = '?';
      str2++;
    }

#if 0
  /* remove trailing blanks */

  str2--;

  while ((str2 >= string) && (*str2 == ' '))
    str2--;

  *(str2 + 1) = '\0';
#endif
}
