-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/gsql_types.adb,v $
--  Description     : commonly used types                                    --
--  Author          : Michael Erdmann                                        --
--  Created         : 8.8.2001                                               --
--  Last Modified By: $Author: me $
--  Last Modified On: $Date: 2001/10/01 08:47:14 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Michael Erdmann                                       --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Functional description                                                   --
--  ======================                                                   --
--                                                                           --
--  Author                                                                   --
--  ======                                                                   --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Text_IO;                 use Ada.Text_IO;
with Ada.Characters.Handling;     use Ada.Characters.Handling;
with Ada.Strings;                 use Ada.Strings;
with Ada.Strings.Unbounded;       use Ada.Strings.Unbounded;
with Ada.Strings.Fixed;           use Ada.Strings.Fixed;
with Unchecked_Deallocation;
with Ada.Characters.Latin_1;      use Ada.Characters.Latin_1;

package body GSQL_Types is

    Version : constant String := "$Id: gsql_types.adb,v 1.2 2001/10/01 08:47:14 me Exp $";

    --------------------
    -- To_Text_Buffer --
    --------------------
    procedure To_Text_Buffer(
       S     : in String;
       T     : out Text_Buffer;
       Last  : out Positive ) is
       -- split a string into a text buffer.
       Start : Positive := S'First;
    begin
       for L in T'Range loop
          declare
             Result : Unbounded_String := Null_Unbounded_String;
             C      : Character;
          begin
             while Start in S'Range loop
                C := S(Start);
                Start := Start + 1;

                if C /= LF then
                   Result := Result & C;
                else
                   exit;
                end if;
             end loop;

             T(L) := Result;
          end;

          Last := L;
          exit when not ( Start in  S'Range );

       end loop;
    end To_Text_Buffer;


    -------------------
    -- To_Textbuffer --
    -------------------
    function To_Text_Buffer(
       S      : in String ) return Text_Buffer is
       Result : Text_Buffer( 1..Max_Section_Length );
       ---  translate string into text buffer
       Last   : Positive;
    begin
       To_Text_Buffer( S, Result, Last );
       return Result( 1..Last );
    end To_Text_Buffer;

    ---------------
    -- To_String --
    ---------------
    function To_String(
       T      : in Text_Buffer ) return String is
       R      : Unbounded_String := Null_Unbounded_String;
    begin
       for I in T'Range loop
          R := R & (T(I) & ASCII.LF);
       end loop;
       return To_String( R );
    end To_String;

    ------------
    -- Insert --
    ------------
    procedure Insert(
       Dest : out Text_Buffer;
       Src  : in Text_Buffer;
       Last : in out Positive ) is
   begin
       for I in Src'Range loop
          Dest(Last) := Src(I);
          Last := Last + 1;
       end loop;
   end Insert;

   ------------
   -- Insert --
   ------------
   procedure Insert(
      Dest : out Text_Buffer;
      Src  : in Unbounded_String;
      Last : in out Positive ) is
   begin
      if Last in Dest'Range then
         Dest(Last) := Src;
         Last := Last + 1;
      end if;
   end Insert;

end GSQL_Types;
