------------------------------------------------------------------------------
--  Ada95 Interface to Oracle RDBMS                                         --
--  Copyright (C) 2000-2006 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-variable.adb,v 1.18 2008/07/03 06:22:48 vagul Exp $

with OCI.Thread;
with System;

package body OCI.Thick.Variable is

   use type Sb4;

   ----------
   -- Bind --
   ----------

   procedure Bind
     (Stmt   : in     Statement;
      Value  : in out Var_Type;
      Name   : in     String;
      Oblige : in     Boolean := True)
   is
      use type C.int;
      Rc : constant SWord
        := OCIBindByName
             (Stmtp       => OCIStmt (Handle (Stmt)),
              Bindpp      => Value.Bind'Access,
              Errhp       => Thread.Error,
              Placeholder => C.To_C (Name),
              Placeh_Len  => Name'Length,
              Valuep      => Value.Value'Address,
              Value_Sz    => Value.Value'Size / System.Storage_Unit,
              Dty         => Value.Type_Id,
              Indp        => Value.Indicator'Unchecked_Access);
   begin
      if Rc = OCI_ERROR
        and then not (not Oblige and then Last_Error_Code = 1036)
      then
         Check_Error (Rc);
      end if;
   end Bind;

   procedure Bind
     (Stmt     : in     Statement;
      Value    : in out Var_Type;
      Position : in     Positive)
   is
      Rc : constant SWord :=
        OCIBindByPos
          (Stmtp    => OCIStmt (Handle (Stmt)),
           Bindpp   => Value.Bind'Access,
           Errhp    => Thread.Error,
           Position => Ub4 (Position),
           Valuep   => Value.Value'Address,
           Value_Sz => Value.Value'Size / System.Storage_Unit,
           Dty      => Value.Type_Id,
           Indp     => Value.Indicator'Unchecked_Access);
   begin
      Check_Error (Rc);
   end Bind;

   ------------
   -- Define --
   ------------

   procedure Define
     (Stmt     : in     Statement;
      Value    : in out Var_Type;
      Position : in     Positive)
   is
      Rc : constant SWord := OCIDefineByPos
          (Stmtp    => OCIStmt (Handle (Stmt)),
           Defnpp   => Value.Define'Access,
           Errhp    => Thread.Error,
           Position => Ub4 (Position),
           Value    => Value.Value'Address,
           Value_Sz => Value.Value'Size / System.Storage_Unit,
           Dty      => Value.Type_Id,
           Indp     => Value.Indicator'Unchecked_Access);
   begin
      Check_Error (Rc);
   end Define;

   ---------------
   -- Get_Value --
   ---------------

   function Get_Value
     (Var     : in Var_Type;
      Default : in Variable_Type;
      Mode    : in Default_Mode := Instead_Any)
      return  Variable_Type is
   begin
      if not Is_Attached (Var) then
         if Mode = Instead_Not_Attached or Mode = Instead_Any then
            return Default;
         else
            raise Not_Attached;
         end if;
      elsif Is_Null (Var) then
         if Mode = Instead_Null or Mode = Instead_Any then
            return Default;
         else
            raise Null_Value;
         end if;
      else
         return Var.Value;
      end if;
   end Get_Value;

   function Get_Value (Var : Var_Type) return Variable_Type is
   begin
      if Is_Null (Var) then
         raise Null_Value;
      else
         return Var.Value;
      end if;
   end Get_Value;

   ------------------------
   -- Get_Value_Internal --
   ------------------------

   function Get_Value_Internal (Var : Var_Type) return Variable_Type is
   begin
      return Var.Value;
   end Get_Value_Internal;

   ---------------
   -- Set_Value --
   ---------------

   procedure Set_Value (Var : in out Var_Type; Value : Variable_Type) is
   begin
      Var.Indicator := 0;
      Var.Value     := Value;
   end Set_Value;

end OCI.Thick.Variable;
