/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * gnome-scan
 * Copyright (C) Étienne Bersac 2007 <bersace03@laposte.net>
 * 
 * gnome-scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

#ifndef _GNOME_SCAN_PREVIEW_SINK_H_
#define _GNOME_SCAN_PREVIEW_SINK_H_

#include <glib-object.h>
#include "gnome-scan-sink.h"

G_BEGIN_DECLS

#define GNOME_TYPE_SCAN_PREVIEW_SINK             (gnome_scan_preview_sink_get_type ())
#define GNOME_SCAN_PREVIEW_SINK(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_TYPE_SCAN_PREVIEW_SINK, GnomeScanPreviewSink))
#define GNOME_SCAN_PREVIEW_SINK_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_TYPE_SCAN_PREVIEW_SINK, GnomeScanPreviewSinkClass))
#define GNOME_IS_SCAN_PREVIEW_SINK(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_TYPE_SCAN_PREVIEW_SINK))
#define GNOME_IS_SCAN_PREVIEW_SINK_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_SCAN_PREVIEW_SINK))
#define GNOME_SCAN_PREVIEW_SINK_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_TYPE_SCAN_PREVIEW_SINK, GnomeScanPreviewSinkClass))

typedef struct _GnomeScanPreviewSinkClass GnomeScanPreviewSinkClass;
typedef struct _GnomeScanPreviewSink GnomeScanPreviewSink;

struct _GnomeScanPreviewSinkClass
{
	GnomeScanSinkClass parent_class;
};

/**
 * GnomeScanPreviewSink:
 *
 * 
 **/
struct _GnomeScanPreviewSink
{
	/*< private >*/
	GnomeScanSink parent_instance;
};

GType gnome_scan_preview_sink_get_type (void) G_GNUC_CONST;
GnomeScanSink*	gnome_scan_preview_sink_new (void);
GdkPixbuf*		gnome_scan_preview_sink_get_pixbuf (GnomeScanPreviewSink *sink);

G_END_DECLS

#endif /* _GNOME_SCAN_PREVIEW_SINK_H_ */
