// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package apprunneriface provides an interface to enable mocking the AWS App Runner service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package apprunneriface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/apprunner"
)

// AppRunnerAPI provides an interface to enable mocking the
// apprunner.AppRunner service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS App Runner.
//    func myFunc(svc apprunneriface.AppRunnerAPI) bool {
//        // Make svc.AssociateCustomDomain request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := apprunner.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockAppRunnerClient struct {
//        apprunneriface.AppRunnerAPI
//    }
//    func (m *mockAppRunnerClient) AssociateCustomDomain(input *apprunner.AssociateCustomDomainInput) (*apprunner.AssociateCustomDomainOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockAppRunnerClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type AppRunnerAPI interface {
	AssociateCustomDomain(*apprunner.AssociateCustomDomainInput) (*apprunner.AssociateCustomDomainOutput, error)
	AssociateCustomDomainWithContext(aws.Context, *apprunner.AssociateCustomDomainInput, ...request.Option) (*apprunner.AssociateCustomDomainOutput, error)
	AssociateCustomDomainRequest(*apprunner.AssociateCustomDomainInput) (*request.Request, *apprunner.AssociateCustomDomainOutput)

	CreateAutoScalingConfiguration(*apprunner.CreateAutoScalingConfigurationInput) (*apprunner.CreateAutoScalingConfigurationOutput, error)
	CreateAutoScalingConfigurationWithContext(aws.Context, *apprunner.CreateAutoScalingConfigurationInput, ...request.Option) (*apprunner.CreateAutoScalingConfigurationOutput, error)
	CreateAutoScalingConfigurationRequest(*apprunner.CreateAutoScalingConfigurationInput) (*request.Request, *apprunner.CreateAutoScalingConfigurationOutput)

	CreateConnection(*apprunner.CreateConnectionInput) (*apprunner.CreateConnectionOutput, error)
	CreateConnectionWithContext(aws.Context, *apprunner.CreateConnectionInput, ...request.Option) (*apprunner.CreateConnectionOutput, error)
	CreateConnectionRequest(*apprunner.CreateConnectionInput) (*request.Request, *apprunner.CreateConnectionOutput)

	CreateService(*apprunner.CreateServiceInput) (*apprunner.CreateServiceOutput, error)
	CreateServiceWithContext(aws.Context, *apprunner.CreateServiceInput, ...request.Option) (*apprunner.CreateServiceOutput, error)
	CreateServiceRequest(*apprunner.CreateServiceInput) (*request.Request, *apprunner.CreateServiceOutput)

	DeleteAutoScalingConfiguration(*apprunner.DeleteAutoScalingConfigurationInput) (*apprunner.DeleteAutoScalingConfigurationOutput, error)
	DeleteAutoScalingConfigurationWithContext(aws.Context, *apprunner.DeleteAutoScalingConfigurationInput, ...request.Option) (*apprunner.DeleteAutoScalingConfigurationOutput, error)
	DeleteAutoScalingConfigurationRequest(*apprunner.DeleteAutoScalingConfigurationInput) (*request.Request, *apprunner.DeleteAutoScalingConfigurationOutput)

	DeleteConnection(*apprunner.DeleteConnectionInput) (*apprunner.DeleteConnectionOutput, error)
	DeleteConnectionWithContext(aws.Context, *apprunner.DeleteConnectionInput, ...request.Option) (*apprunner.DeleteConnectionOutput, error)
	DeleteConnectionRequest(*apprunner.DeleteConnectionInput) (*request.Request, *apprunner.DeleteConnectionOutput)

	DeleteService(*apprunner.DeleteServiceInput) (*apprunner.DeleteServiceOutput, error)
	DeleteServiceWithContext(aws.Context, *apprunner.DeleteServiceInput, ...request.Option) (*apprunner.DeleteServiceOutput, error)
	DeleteServiceRequest(*apprunner.DeleteServiceInput) (*request.Request, *apprunner.DeleteServiceOutput)

	DescribeAutoScalingConfiguration(*apprunner.DescribeAutoScalingConfigurationInput) (*apprunner.DescribeAutoScalingConfigurationOutput, error)
	DescribeAutoScalingConfigurationWithContext(aws.Context, *apprunner.DescribeAutoScalingConfigurationInput, ...request.Option) (*apprunner.DescribeAutoScalingConfigurationOutput, error)
	DescribeAutoScalingConfigurationRequest(*apprunner.DescribeAutoScalingConfigurationInput) (*request.Request, *apprunner.DescribeAutoScalingConfigurationOutput)

	DescribeCustomDomains(*apprunner.DescribeCustomDomainsInput) (*apprunner.DescribeCustomDomainsOutput, error)
	DescribeCustomDomainsWithContext(aws.Context, *apprunner.DescribeCustomDomainsInput, ...request.Option) (*apprunner.DescribeCustomDomainsOutput, error)
	DescribeCustomDomainsRequest(*apprunner.DescribeCustomDomainsInput) (*request.Request, *apprunner.DescribeCustomDomainsOutput)

	DescribeCustomDomainsPages(*apprunner.DescribeCustomDomainsInput, func(*apprunner.DescribeCustomDomainsOutput, bool) bool) error
	DescribeCustomDomainsPagesWithContext(aws.Context, *apprunner.DescribeCustomDomainsInput, func(*apprunner.DescribeCustomDomainsOutput, bool) bool, ...request.Option) error

	DescribeService(*apprunner.DescribeServiceInput) (*apprunner.DescribeServiceOutput, error)
	DescribeServiceWithContext(aws.Context, *apprunner.DescribeServiceInput, ...request.Option) (*apprunner.DescribeServiceOutput, error)
	DescribeServiceRequest(*apprunner.DescribeServiceInput) (*request.Request, *apprunner.DescribeServiceOutput)

	DisassociateCustomDomain(*apprunner.DisassociateCustomDomainInput) (*apprunner.DisassociateCustomDomainOutput, error)
	DisassociateCustomDomainWithContext(aws.Context, *apprunner.DisassociateCustomDomainInput, ...request.Option) (*apprunner.DisassociateCustomDomainOutput, error)
	DisassociateCustomDomainRequest(*apprunner.DisassociateCustomDomainInput) (*request.Request, *apprunner.DisassociateCustomDomainOutput)

	ListAutoScalingConfigurations(*apprunner.ListAutoScalingConfigurationsInput) (*apprunner.ListAutoScalingConfigurationsOutput, error)
	ListAutoScalingConfigurationsWithContext(aws.Context, *apprunner.ListAutoScalingConfigurationsInput, ...request.Option) (*apprunner.ListAutoScalingConfigurationsOutput, error)
	ListAutoScalingConfigurationsRequest(*apprunner.ListAutoScalingConfigurationsInput) (*request.Request, *apprunner.ListAutoScalingConfigurationsOutput)

	ListAutoScalingConfigurationsPages(*apprunner.ListAutoScalingConfigurationsInput, func(*apprunner.ListAutoScalingConfigurationsOutput, bool) bool) error
	ListAutoScalingConfigurationsPagesWithContext(aws.Context, *apprunner.ListAutoScalingConfigurationsInput, func(*apprunner.ListAutoScalingConfigurationsOutput, bool) bool, ...request.Option) error

	ListConnections(*apprunner.ListConnectionsInput) (*apprunner.ListConnectionsOutput, error)
	ListConnectionsWithContext(aws.Context, *apprunner.ListConnectionsInput, ...request.Option) (*apprunner.ListConnectionsOutput, error)
	ListConnectionsRequest(*apprunner.ListConnectionsInput) (*request.Request, *apprunner.ListConnectionsOutput)

	ListConnectionsPages(*apprunner.ListConnectionsInput, func(*apprunner.ListConnectionsOutput, bool) bool) error
	ListConnectionsPagesWithContext(aws.Context, *apprunner.ListConnectionsInput, func(*apprunner.ListConnectionsOutput, bool) bool, ...request.Option) error

	ListOperations(*apprunner.ListOperationsInput) (*apprunner.ListOperationsOutput, error)
	ListOperationsWithContext(aws.Context, *apprunner.ListOperationsInput, ...request.Option) (*apprunner.ListOperationsOutput, error)
	ListOperationsRequest(*apprunner.ListOperationsInput) (*request.Request, *apprunner.ListOperationsOutput)

	ListOperationsPages(*apprunner.ListOperationsInput, func(*apprunner.ListOperationsOutput, bool) bool) error
	ListOperationsPagesWithContext(aws.Context, *apprunner.ListOperationsInput, func(*apprunner.ListOperationsOutput, bool) bool, ...request.Option) error

	ListServices(*apprunner.ListServicesInput) (*apprunner.ListServicesOutput, error)
	ListServicesWithContext(aws.Context, *apprunner.ListServicesInput, ...request.Option) (*apprunner.ListServicesOutput, error)
	ListServicesRequest(*apprunner.ListServicesInput) (*request.Request, *apprunner.ListServicesOutput)

	ListServicesPages(*apprunner.ListServicesInput, func(*apprunner.ListServicesOutput, bool) bool) error
	ListServicesPagesWithContext(aws.Context, *apprunner.ListServicesInput, func(*apprunner.ListServicesOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*apprunner.ListTagsForResourceInput) (*apprunner.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *apprunner.ListTagsForResourceInput, ...request.Option) (*apprunner.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*apprunner.ListTagsForResourceInput) (*request.Request, *apprunner.ListTagsForResourceOutput)

	PauseService(*apprunner.PauseServiceInput) (*apprunner.PauseServiceOutput, error)
	PauseServiceWithContext(aws.Context, *apprunner.PauseServiceInput, ...request.Option) (*apprunner.PauseServiceOutput, error)
	PauseServiceRequest(*apprunner.PauseServiceInput) (*request.Request, *apprunner.PauseServiceOutput)

	ResumeService(*apprunner.ResumeServiceInput) (*apprunner.ResumeServiceOutput, error)
	ResumeServiceWithContext(aws.Context, *apprunner.ResumeServiceInput, ...request.Option) (*apprunner.ResumeServiceOutput, error)
	ResumeServiceRequest(*apprunner.ResumeServiceInput) (*request.Request, *apprunner.ResumeServiceOutput)

	StartDeployment(*apprunner.StartDeploymentInput) (*apprunner.StartDeploymentOutput, error)
	StartDeploymentWithContext(aws.Context, *apprunner.StartDeploymentInput, ...request.Option) (*apprunner.StartDeploymentOutput, error)
	StartDeploymentRequest(*apprunner.StartDeploymentInput) (*request.Request, *apprunner.StartDeploymentOutput)

	TagResource(*apprunner.TagResourceInput) (*apprunner.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *apprunner.TagResourceInput, ...request.Option) (*apprunner.TagResourceOutput, error)
	TagResourceRequest(*apprunner.TagResourceInput) (*request.Request, *apprunner.TagResourceOutput)

	UntagResource(*apprunner.UntagResourceInput) (*apprunner.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *apprunner.UntagResourceInput, ...request.Option) (*apprunner.UntagResourceOutput, error)
	UntagResourceRequest(*apprunner.UntagResourceInput) (*request.Request, *apprunner.UntagResourceOutput)

	UpdateService(*apprunner.UpdateServiceInput) (*apprunner.UpdateServiceOutput, error)
	UpdateServiceWithContext(aws.Context, *apprunner.UpdateServiceInput, ...request.Option) (*apprunner.UpdateServiceOutput, error)
	UpdateServiceRequest(*apprunner.UpdateServiceInput) (*request.Request, *apprunner.UpdateServiceOutput)
}

var _ AppRunnerAPI = (*apprunner.AppRunner)(nil)
