// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package ssmincidentsiface provides an interface to enable mocking the AWS Systems Manager Incident Manager service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package ssmincidentsiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/ssmincidents"
)

// SSMIncidentsAPI provides an interface to enable mocking the
// ssmincidents.SSMIncidents service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS Systems Manager Incident Manager.
//    func myFunc(svc ssmincidentsiface.SSMIncidentsAPI) bool {
//        // Make svc.CreateReplicationSet request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := ssmincidents.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockSSMIncidentsClient struct {
//        ssmincidentsiface.SSMIncidentsAPI
//    }
//    func (m *mockSSMIncidentsClient) CreateReplicationSet(input *ssmincidents.CreateReplicationSetInput) (*ssmincidents.CreateReplicationSetOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockSSMIncidentsClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type SSMIncidentsAPI interface {
	CreateReplicationSet(*ssmincidents.CreateReplicationSetInput) (*ssmincidents.CreateReplicationSetOutput, error)
	CreateReplicationSetWithContext(aws.Context, *ssmincidents.CreateReplicationSetInput, ...request.Option) (*ssmincidents.CreateReplicationSetOutput, error)
	CreateReplicationSetRequest(*ssmincidents.CreateReplicationSetInput) (*request.Request, *ssmincidents.CreateReplicationSetOutput)

	CreateResponsePlan(*ssmincidents.CreateResponsePlanInput) (*ssmincidents.CreateResponsePlanOutput, error)
	CreateResponsePlanWithContext(aws.Context, *ssmincidents.CreateResponsePlanInput, ...request.Option) (*ssmincidents.CreateResponsePlanOutput, error)
	CreateResponsePlanRequest(*ssmincidents.CreateResponsePlanInput) (*request.Request, *ssmincidents.CreateResponsePlanOutput)

	CreateTimelineEvent(*ssmincidents.CreateTimelineEventInput) (*ssmincidents.CreateTimelineEventOutput, error)
	CreateTimelineEventWithContext(aws.Context, *ssmincidents.CreateTimelineEventInput, ...request.Option) (*ssmincidents.CreateTimelineEventOutput, error)
	CreateTimelineEventRequest(*ssmincidents.CreateTimelineEventInput) (*request.Request, *ssmincidents.CreateTimelineEventOutput)

	DeleteIncidentRecord(*ssmincidents.DeleteIncidentRecordInput) (*ssmincidents.DeleteIncidentRecordOutput, error)
	DeleteIncidentRecordWithContext(aws.Context, *ssmincidents.DeleteIncidentRecordInput, ...request.Option) (*ssmincidents.DeleteIncidentRecordOutput, error)
	DeleteIncidentRecordRequest(*ssmincidents.DeleteIncidentRecordInput) (*request.Request, *ssmincidents.DeleteIncidentRecordOutput)

	DeleteReplicationSet(*ssmincidents.DeleteReplicationSetInput) (*ssmincidents.DeleteReplicationSetOutput, error)
	DeleteReplicationSetWithContext(aws.Context, *ssmincidents.DeleteReplicationSetInput, ...request.Option) (*ssmincidents.DeleteReplicationSetOutput, error)
	DeleteReplicationSetRequest(*ssmincidents.DeleteReplicationSetInput) (*request.Request, *ssmincidents.DeleteReplicationSetOutput)

	DeleteResourcePolicy(*ssmincidents.DeleteResourcePolicyInput) (*ssmincidents.DeleteResourcePolicyOutput, error)
	DeleteResourcePolicyWithContext(aws.Context, *ssmincidents.DeleteResourcePolicyInput, ...request.Option) (*ssmincidents.DeleteResourcePolicyOutput, error)
	DeleteResourcePolicyRequest(*ssmincidents.DeleteResourcePolicyInput) (*request.Request, *ssmincidents.DeleteResourcePolicyOutput)

	DeleteResponsePlan(*ssmincidents.DeleteResponsePlanInput) (*ssmincidents.DeleteResponsePlanOutput, error)
	DeleteResponsePlanWithContext(aws.Context, *ssmincidents.DeleteResponsePlanInput, ...request.Option) (*ssmincidents.DeleteResponsePlanOutput, error)
	DeleteResponsePlanRequest(*ssmincidents.DeleteResponsePlanInput) (*request.Request, *ssmincidents.DeleteResponsePlanOutput)

	DeleteTimelineEvent(*ssmincidents.DeleteTimelineEventInput) (*ssmincidents.DeleteTimelineEventOutput, error)
	DeleteTimelineEventWithContext(aws.Context, *ssmincidents.DeleteTimelineEventInput, ...request.Option) (*ssmincidents.DeleteTimelineEventOutput, error)
	DeleteTimelineEventRequest(*ssmincidents.DeleteTimelineEventInput) (*request.Request, *ssmincidents.DeleteTimelineEventOutput)

	GetIncidentRecord(*ssmincidents.GetIncidentRecordInput) (*ssmincidents.GetIncidentRecordOutput, error)
	GetIncidentRecordWithContext(aws.Context, *ssmincidents.GetIncidentRecordInput, ...request.Option) (*ssmincidents.GetIncidentRecordOutput, error)
	GetIncidentRecordRequest(*ssmincidents.GetIncidentRecordInput) (*request.Request, *ssmincidents.GetIncidentRecordOutput)

	GetReplicationSet(*ssmincidents.GetReplicationSetInput) (*ssmincidents.GetReplicationSetOutput, error)
	GetReplicationSetWithContext(aws.Context, *ssmincidents.GetReplicationSetInput, ...request.Option) (*ssmincidents.GetReplicationSetOutput, error)
	GetReplicationSetRequest(*ssmincidents.GetReplicationSetInput) (*request.Request, *ssmincidents.GetReplicationSetOutput)

	GetResourcePolicies(*ssmincidents.GetResourcePoliciesInput) (*ssmincidents.GetResourcePoliciesOutput, error)
	GetResourcePoliciesWithContext(aws.Context, *ssmincidents.GetResourcePoliciesInput, ...request.Option) (*ssmincidents.GetResourcePoliciesOutput, error)
	GetResourcePoliciesRequest(*ssmincidents.GetResourcePoliciesInput) (*request.Request, *ssmincidents.GetResourcePoliciesOutput)

	GetResourcePoliciesPages(*ssmincidents.GetResourcePoliciesInput, func(*ssmincidents.GetResourcePoliciesOutput, bool) bool) error
	GetResourcePoliciesPagesWithContext(aws.Context, *ssmincidents.GetResourcePoliciesInput, func(*ssmincidents.GetResourcePoliciesOutput, bool) bool, ...request.Option) error

	GetResponsePlan(*ssmincidents.GetResponsePlanInput) (*ssmincidents.GetResponsePlanOutput, error)
	GetResponsePlanWithContext(aws.Context, *ssmincidents.GetResponsePlanInput, ...request.Option) (*ssmincidents.GetResponsePlanOutput, error)
	GetResponsePlanRequest(*ssmincidents.GetResponsePlanInput) (*request.Request, *ssmincidents.GetResponsePlanOutput)

	GetTimelineEvent(*ssmincidents.GetTimelineEventInput) (*ssmincidents.GetTimelineEventOutput, error)
	GetTimelineEventWithContext(aws.Context, *ssmincidents.GetTimelineEventInput, ...request.Option) (*ssmincidents.GetTimelineEventOutput, error)
	GetTimelineEventRequest(*ssmincidents.GetTimelineEventInput) (*request.Request, *ssmincidents.GetTimelineEventOutput)

	ListIncidentRecords(*ssmincidents.ListIncidentRecordsInput) (*ssmincidents.ListIncidentRecordsOutput, error)
	ListIncidentRecordsWithContext(aws.Context, *ssmincidents.ListIncidentRecordsInput, ...request.Option) (*ssmincidents.ListIncidentRecordsOutput, error)
	ListIncidentRecordsRequest(*ssmincidents.ListIncidentRecordsInput) (*request.Request, *ssmincidents.ListIncidentRecordsOutput)

	ListIncidentRecordsPages(*ssmincidents.ListIncidentRecordsInput, func(*ssmincidents.ListIncidentRecordsOutput, bool) bool) error
	ListIncidentRecordsPagesWithContext(aws.Context, *ssmincidents.ListIncidentRecordsInput, func(*ssmincidents.ListIncidentRecordsOutput, bool) bool, ...request.Option) error

	ListRelatedItems(*ssmincidents.ListRelatedItemsInput) (*ssmincidents.ListRelatedItemsOutput, error)
	ListRelatedItemsWithContext(aws.Context, *ssmincidents.ListRelatedItemsInput, ...request.Option) (*ssmincidents.ListRelatedItemsOutput, error)
	ListRelatedItemsRequest(*ssmincidents.ListRelatedItemsInput) (*request.Request, *ssmincidents.ListRelatedItemsOutput)

	ListRelatedItemsPages(*ssmincidents.ListRelatedItemsInput, func(*ssmincidents.ListRelatedItemsOutput, bool) bool) error
	ListRelatedItemsPagesWithContext(aws.Context, *ssmincidents.ListRelatedItemsInput, func(*ssmincidents.ListRelatedItemsOutput, bool) bool, ...request.Option) error

	ListReplicationSets(*ssmincidents.ListReplicationSetsInput) (*ssmincidents.ListReplicationSetsOutput, error)
	ListReplicationSetsWithContext(aws.Context, *ssmincidents.ListReplicationSetsInput, ...request.Option) (*ssmincidents.ListReplicationSetsOutput, error)
	ListReplicationSetsRequest(*ssmincidents.ListReplicationSetsInput) (*request.Request, *ssmincidents.ListReplicationSetsOutput)

	ListReplicationSetsPages(*ssmincidents.ListReplicationSetsInput, func(*ssmincidents.ListReplicationSetsOutput, bool) bool) error
	ListReplicationSetsPagesWithContext(aws.Context, *ssmincidents.ListReplicationSetsInput, func(*ssmincidents.ListReplicationSetsOutput, bool) bool, ...request.Option) error

	ListResponsePlans(*ssmincidents.ListResponsePlansInput) (*ssmincidents.ListResponsePlansOutput, error)
	ListResponsePlansWithContext(aws.Context, *ssmincidents.ListResponsePlansInput, ...request.Option) (*ssmincidents.ListResponsePlansOutput, error)
	ListResponsePlansRequest(*ssmincidents.ListResponsePlansInput) (*request.Request, *ssmincidents.ListResponsePlansOutput)

	ListResponsePlansPages(*ssmincidents.ListResponsePlansInput, func(*ssmincidents.ListResponsePlansOutput, bool) bool) error
	ListResponsePlansPagesWithContext(aws.Context, *ssmincidents.ListResponsePlansInput, func(*ssmincidents.ListResponsePlansOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*ssmincidents.ListTagsForResourceInput) (*ssmincidents.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *ssmincidents.ListTagsForResourceInput, ...request.Option) (*ssmincidents.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*ssmincidents.ListTagsForResourceInput) (*request.Request, *ssmincidents.ListTagsForResourceOutput)

	ListTimelineEvents(*ssmincidents.ListTimelineEventsInput) (*ssmincidents.ListTimelineEventsOutput, error)
	ListTimelineEventsWithContext(aws.Context, *ssmincidents.ListTimelineEventsInput, ...request.Option) (*ssmincidents.ListTimelineEventsOutput, error)
	ListTimelineEventsRequest(*ssmincidents.ListTimelineEventsInput) (*request.Request, *ssmincidents.ListTimelineEventsOutput)

	ListTimelineEventsPages(*ssmincidents.ListTimelineEventsInput, func(*ssmincidents.ListTimelineEventsOutput, bool) bool) error
	ListTimelineEventsPagesWithContext(aws.Context, *ssmincidents.ListTimelineEventsInput, func(*ssmincidents.ListTimelineEventsOutput, bool) bool, ...request.Option) error

	PutResourcePolicy(*ssmincidents.PutResourcePolicyInput) (*ssmincidents.PutResourcePolicyOutput, error)
	PutResourcePolicyWithContext(aws.Context, *ssmincidents.PutResourcePolicyInput, ...request.Option) (*ssmincidents.PutResourcePolicyOutput, error)
	PutResourcePolicyRequest(*ssmincidents.PutResourcePolicyInput) (*request.Request, *ssmincidents.PutResourcePolicyOutput)

	StartIncident(*ssmincidents.StartIncidentInput) (*ssmincidents.StartIncidentOutput, error)
	StartIncidentWithContext(aws.Context, *ssmincidents.StartIncidentInput, ...request.Option) (*ssmincidents.StartIncidentOutput, error)
	StartIncidentRequest(*ssmincidents.StartIncidentInput) (*request.Request, *ssmincidents.StartIncidentOutput)

	TagResource(*ssmincidents.TagResourceInput) (*ssmincidents.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *ssmincidents.TagResourceInput, ...request.Option) (*ssmincidents.TagResourceOutput, error)
	TagResourceRequest(*ssmincidents.TagResourceInput) (*request.Request, *ssmincidents.TagResourceOutput)

	UntagResource(*ssmincidents.UntagResourceInput) (*ssmincidents.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *ssmincidents.UntagResourceInput, ...request.Option) (*ssmincidents.UntagResourceOutput, error)
	UntagResourceRequest(*ssmincidents.UntagResourceInput) (*request.Request, *ssmincidents.UntagResourceOutput)

	UpdateDeletionProtection(*ssmincidents.UpdateDeletionProtectionInput) (*ssmincidents.UpdateDeletionProtectionOutput, error)
	UpdateDeletionProtectionWithContext(aws.Context, *ssmincidents.UpdateDeletionProtectionInput, ...request.Option) (*ssmincidents.UpdateDeletionProtectionOutput, error)
	UpdateDeletionProtectionRequest(*ssmincidents.UpdateDeletionProtectionInput) (*request.Request, *ssmincidents.UpdateDeletionProtectionOutput)

	UpdateIncidentRecord(*ssmincidents.UpdateIncidentRecordInput) (*ssmincidents.UpdateIncidentRecordOutput, error)
	UpdateIncidentRecordWithContext(aws.Context, *ssmincidents.UpdateIncidentRecordInput, ...request.Option) (*ssmincidents.UpdateIncidentRecordOutput, error)
	UpdateIncidentRecordRequest(*ssmincidents.UpdateIncidentRecordInput) (*request.Request, *ssmincidents.UpdateIncidentRecordOutput)

	UpdateRelatedItems(*ssmincidents.UpdateRelatedItemsInput) (*ssmincidents.UpdateRelatedItemsOutput, error)
	UpdateRelatedItemsWithContext(aws.Context, *ssmincidents.UpdateRelatedItemsInput, ...request.Option) (*ssmincidents.UpdateRelatedItemsOutput, error)
	UpdateRelatedItemsRequest(*ssmincidents.UpdateRelatedItemsInput) (*request.Request, *ssmincidents.UpdateRelatedItemsOutput)

	UpdateReplicationSet(*ssmincidents.UpdateReplicationSetInput) (*ssmincidents.UpdateReplicationSetOutput, error)
	UpdateReplicationSetWithContext(aws.Context, *ssmincidents.UpdateReplicationSetInput, ...request.Option) (*ssmincidents.UpdateReplicationSetOutput, error)
	UpdateReplicationSetRequest(*ssmincidents.UpdateReplicationSetInput) (*request.Request, *ssmincidents.UpdateReplicationSetOutput)

	UpdateResponsePlan(*ssmincidents.UpdateResponsePlanInput) (*ssmincidents.UpdateResponsePlanOutput, error)
	UpdateResponsePlanWithContext(aws.Context, *ssmincidents.UpdateResponsePlanInput, ...request.Option) (*ssmincidents.UpdateResponsePlanOutput, error)
	UpdateResponsePlanRequest(*ssmincidents.UpdateResponsePlanInput) (*request.Request, *ssmincidents.UpdateResponsePlanOutput)

	UpdateTimelineEvent(*ssmincidents.UpdateTimelineEventInput) (*ssmincidents.UpdateTimelineEventOutput, error)
	UpdateTimelineEventWithContext(aws.Context, *ssmincidents.UpdateTimelineEventInput, ...request.Option) (*ssmincidents.UpdateTimelineEventOutput, error)
	UpdateTimelineEventRequest(*ssmincidents.UpdateTimelineEventInput) (*request.Request, *ssmincidents.UpdateTimelineEventOutput)

	WaitUntilWaitForReplicationSetActive(*ssmincidents.GetReplicationSetInput) error
	WaitUntilWaitForReplicationSetActiveWithContext(aws.Context, *ssmincidents.GetReplicationSetInput, ...request.WaiterOption) error

	WaitUntilWaitForReplicationSetDeleted(*ssmincidents.GetReplicationSetInput) error
	WaitUntilWaitForReplicationSetDeletedWithContext(aws.Context, *ssmincidents.GetReplicationSetInput, ...request.WaiterOption) error
}

var _ SSMIncidentsAPI = (*ssmincidents.SSMIncidents)(nil)
