/*
 * Copyright 2012 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies;

import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.api.artifacts.ClientModule;

public class ClientModuleDependencyDescriptor extends EnhancedDependencyDescriptor {
    private final ModuleDescriptor targetModule;

    public ClientModuleDependencyDescriptor(ClientModule moduleDependency, ModuleDescriptor md, ModuleDescriptor targetModule, ModuleRevisionId mrid, boolean force, boolean changing, boolean transitive) {
        super(moduleDependency, md, mrid, force, changing, transitive);
        this.targetModule = targetModule;
    }

    public ModuleDescriptor getTargetModule() {
        return targetModule;
    }
}
