/*
 * Copyright 2015 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.internal.operations;

import org.gradle.api.Nullable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.concurrent.StoppableExecutor;

public class DefaultBuildOperationProcessor implements BuildOperationProcessor, Stoppable {

    private final StoppableExecutor fixedSizePool;

    public DefaultBuildOperationProcessor(ExecutorFactory executorFactory, int maxWorkerCount) {
        this.fixedSizePool = executorFactory.create("build operations", maxWorkerCount);
    }

    public <T extends BuildOperation> BuildOperationQueue<T> newQueue(BuildOperationWorker<T> worker, @Nullable String logLocation) {
        return new DefaultBuildOperationQueue<T>(fixedSizePool, worker, logLocation);
    }

    public void stop() {
        fixedSizePool.stop();
    }
}
