/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This package contains mutable and immutable sorted map interfaces.
 * <p>
 *     A sorted map is a map which contains elements in sorted order. It allows for faster retrievals.
 * </p>
 * <p>
 * This package contains 3 interfaces:
 * <ul>
 *     <li>
 *         {@link com.gs.collections.api.map.sorted.MutableSortedMap} - an implementation of a JCF Map which provides methods matching the Smalltalk Collection protocol.
 *     </li>
 *     <li>
 *         {@link com.gs.collections.api.map.sorted.ImmutableSortedMap} - the non-mutable equivalent of {@link com.gs.collections.api.map.sorted.MutableSortedMap}.
 *     </li>
 *     <li>
 *         {@link com.gs.collections.api.map.sorted.SortedMapIterable} - a map which contains elements in sorted order.
 *     </li>
 * </ul>
 * </p>
 */
package com.gs.collections.api.map.sorted;
