/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This package contains interfaces for {@link com.gs.collections.api.multimap.list.ListMultimap}.
 * <p>
 *     A ListMultimap is a type of {@link com.gs.collections.api.multimap.Multimap} that stores the values for keys in a {@link com.gs.collections.api.list.MutableList}.
 * </p>
 * <p>
 * This package contains 3 interfaces:
 * <ul>
 *     <li>
 *         {@link com.gs.collections.api.multimap.list.ListMultimap} - A Read-only List Multimap API.
 *     </li>
 *     <li>
 *         {@link com.gs.collections.api.multimap.list.MutableListMultimap} - Modifiable List multimap.
 *     </li>
 *     <li>
 *         {@link com.gs.collections.api.multimap.list.ImmutableListMultimap} - Non-modifiable equivalent interface to {@link com.gs.collections.api.multimap.list.MutableListMultimap}.
 *     </li>
 * </ul>
 * </p>
 */
package com.gs.collections.api.multimap.list;
