module DB.HSQL.PG.Type where

import Foreign(Word32)

import Database.HSQL(SqlType(..))

#include <postgres.h>
#include <catalog/pg_type.h>

-- |
type Oid = #type Oid

-- |
mkSqlType :: Oid -> Int -> SqlType
mkSqlType (#const BPCHAROID)    size = SqlChar (size-4)
mkSqlType (#const VARCHAROID)   size = SqlVarChar (size-4)
mkSqlType (#const NAMEOID)      size = SqlVarChar 31
mkSqlType (#const TEXTOID)      size = SqlText
mkSqlType (#const NUMERICOID)   size = 
    SqlNumeric ((size-4) `div` 0x10000) ((size-4) `mod` 0x10000)
mkSqlType (#const INT2OID)      size = SqlSmallInt
mkSqlType (#const INT4OID)      size = SqlInteger
mkSqlType (#const FLOAT4OID)    size = SqlReal
mkSqlType (#const FLOAT8OID)    size = SqlDouble
mkSqlType (#const BOOLOID)      size = SqlBit
mkSqlType (#const BITOID)       size = SqlBinary size
mkSqlType (#const VARBITOID)    size = SqlVarBinary size
mkSqlType (#const BYTEAOID)     size = SqlTinyInt
mkSqlType (#const INT8OID)      size = SqlBigInt
mkSqlType (#const DATEOID)      size = SqlDate
mkSqlType (#const TIMEOID)      size = SqlTime
mkSqlType (#const TIMETZOID)    size = SqlTimeTZ
mkSqlType (#const ABSTIMEOID)   size = SqlAbsTime
mkSqlType (#const RELTIMEOID)   size = SqlRelTime
mkSqlType (#const INTERVALOID)  size = SqlTimeInterval
mkSqlType (#const TINTERVALOID) size = SqlAbsTimeInterval
mkSqlType (#const TIMESTAMPOID)	size = SqlDateTime
mkSqlType (#const TIMESTAMPTZOID)	size = SqlDateTimeTZ
mkSqlType (#const CASHOID)      size = SqlMoney
mkSqlType (#const INETOID)      size = SqlINetAddr
mkSqlType (#const 829)          size = SqlMacAddr		-- hack
mkSqlType (#const CIDROID)      size = SqlCIDRAddr
mkSqlType (#const POINTOID)     size = SqlPoint
mkSqlType (#const LSEGOID)      size = SqlLSeg
mkSqlType (#const PATHOID)      size = SqlPath
mkSqlType (#const BOXOID)       size = SqlBox
mkSqlType (#const POLYGONOID)   size = SqlPolygon
mkSqlType (#const LINEOID)      size = SqlLine
mkSqlType (#const CIRCLEOID)    size = SqlCircle
mkSqlType tp   size = SqlUnknown (fromIntegral tp)