------------------------------------------------------------------------------
-- |
-- Module:      Database.PostgreSQL.Simple.TypeInfo
-- Copyright:   (c) 2011-2012 Leon P Smith
-- License:     BSD3
-- Maintainer:  Leon P Smith <leon@melding-monads.com>
-- Stability:   experimental
--
-- This module contains portions of the @pg_type@ table that are relevant
-- to postgresql-simple and are believed to not change between PostgreSQL
-- versions.
--
------------------------------------------------------------------------------

-- Note that this file is generated by tools/GenTypeInfo.hs, and should
-- not be edited directly

module Database.PostgreSQL.Simple.TypeInfo.Static
     ( TypeInfo(..)
     , staticTypeInfo
     , bool
     , boolOid
     , bytea
     , byteaOid
     , char
     , charOid
     , name
     , nameOid
     , int8
     , int8Oid
     , int2
     , int2Oid
     , int4
     , int4Oid
     , regproc
     , regprocOid
     , text
     , textOid
     , oid
     , oidOid
     , tid
     , tidOid
     , xid
     , xidOid
     , cid
     , cidOid
     , xml
     , xmlOid
     , point
     , pointOid
     , lseg
     , lsegOid
     , path
     , pathOid
     , box
     , boxOid
     , polygon
     , polygonOid
     , line
     , lineOid
     , cidr
     , cidrOid
     , float4
     , float4Oid
     , float8
     , float8Oid
     , unknown
     , unknownOid
     , circle
     , circleOid
     , money
     , moneyOid
     , macaddr
     , macaddrOid
     , inet
     , inetOid
     , bpchar
     , bpcharOid
     , varchar
     , varcharOid
     , date
     , dateOid
     , time
     , timeOid
     , timestamp
     , timestampOid
     , timestamptz
     , timestamptzOid
     , interval
     , intervalOid
     , timetz
     , timetzOid
     , bit
     , bitOid
     , varbit
     , varbitOid
     , numeric
     , numericOid
     , refcursor
     , refcursorOid
     , record
     , recordOid
     , void
     , voidOid
     , array_record
     , array_recordOid
     , regprocedure
     , regprocedureOid
     , regoper
     , regoperOid
     , regoperator
     , regoperatorOid
     , regclass
     , regclassOid
     , regtype
     , regtypeOid
     , uuid
     , uuidOid
     , json
     , jsonOid
     , jsonb
     , jsonbOid
     , int2vector
     , int2vectorOid
     , oidvector
     , oidvectorOid
     , array_xml
     , array_xmlOid
     , array_json
     , array_jsonOid
     , array_line
     , array_lineOid
     , array_cidr
     , array_cidrOid
     , array_circle
     , array_circleOid
     , array_money
     , array_moneyOid
     , array_bool
     , array_boolOid
     , array_bytea
     , array_byteaOid
     , array_char
     , array_charOid
     , array_name
     , array_nameOid
     , array_int2
     , array_int2Oid
     , array_int2vector
     , array_int2vectorOid
     , array_int4
     , array_int4Oid
     , array_regproc
     , array_regprocOid
     , array_text
     , array_textOid
     , array_tid
     , array_tidOid
     , array_xid
     , array_xidOid
     , array_cid
     , array_cidOid
     , array_oidvector
     , array_oidvectorOid
     , array_bpchar
     , array_bpcharOid
     , array_varchar
     , array_varcharOid
     , array_int8
     , array_int8Oid
     , array_point
     , array_pointOid
     , array_lseg
     , array_lsegOid
     , array_path
     , array_pathOid
     , array_box
     , array_boxOid
     , array_float4
     , array_float4Oid
     , array_float8
     , array_float8Oid
     , array_polygon
     , array_polygonOid
     , array_oid
     , array_oidOid
     , array_macaddr
     , array_macaddrOid
     , array_inet
     , array_inetOid
     , array_timestamp
     , array_timestampOid
     , array_date
     , array_dateOid
     , array_time
     , array_timeOid
     , array_timestamptz
     , array_timestamptzOid
     , array_interval
     , array_intervalOid
     , array_numeric
     , array_numericOid
     , array_timetz
     , array_timetzOid
     , array_bit
     , array_bitOid
     , array_varbit
     , array_varbitOid
     , array_refcursor
     , array_refcursorOid
     , array_regprocedure
     , array_regprocedureOid
     , array_regoper
     , array_regoperOid
     , array_regoperator
     , array_regoperatorOid
     , array_regclass
     , array_regclassOid
     , array_regtype
     , array_regtypeOid
     , array_uuid
     , array_uuidOid
     , array_jsonb
     , array_jsonbOid
     , int4range
     , int4rangeOid
     , _int4range
     , _int4rangeOid
     , numrange
     , numrangeOid
     , _numrange
     , _numrangeOid
     , tsrange
     , tsrangeOid
     , _tsrange
     , _tsrangeOid
     , tstzrange
     , tstzrangeOid
     , _tstzrange
     , _tstzrangeOid
     , daterange
     , daterangeOid
     , _daterange
     , _daterangeOid
     , int8range
     , int8rangeOid
     , _int8range
     , _int8rangeOid
     ) where

import Database.PostgreSQL.LibPQ (Oid(..))
import Database.PostgreSQL.Simple.TypeInfo.Types

staticTypeInfo :: Oid -> Maybe TypeInfo
staticTypeInfo (Oid x) = case x of
    16   -> Just bool
    17   -> Just bytea
    18   -> Just char
    19   -> Just name
    20   -> Just int8
    21   -> Just int2
    23   -> Just int4
    24   -> Just regproc
    25   -> Just text
    26   -> Just oid
    27   -> Just tid
    28   -> Just xid
    29   -> Just cid
    142  -> Just xml
    600  -> Just point
    601  -> Just lseg
    602  -> Just path
    603  -> Just box
    604  -> Just polygon
    628  -> Just line
    650  -> Just cidr
    700  -> Just float4
    701  -> Just float8
    705  -> Just unknown
    718  -> Just circle
    790  -> Just money
    829  -> Just macaddr
    869  -> Just inet
    1042 -> Just bpchar
    1043 -> Just varchar
    1082 -> Just date
    1083 -> Just time
    1114 -> Just timestamp
    1184 -> Just timestamptz
    1186 -> Just interval
    1266 -> Just timetz
    1560 -> Just bit
    1562 -> Just varbit
    1700 -> Just numeric
    1790 -> Just refcursor
    2249 -> Just record
    2278 -> Just void
    2287 -> Just array_record
    2202 -> Just regprocedure
    2203 -> Just regoper
    2204 -> Just regoperator
    2205 -> Just regclass
    2206 -> Just regtype
    2950 -> Just uuid
    114  -> Just json
    3802 -> Just jsonb
    22   -> Just int2vector
    30   -> Just oidvector
    143  -> Just array_xml
    199  -> Just array_json
    629  -> Just array_line
    651  -> Just array_cidr
    719  -> Just array_circle
    791  -> Just array_money
    1000 -> Just array_bool
    1001 -> Just array_bytea
    1002 -> Just array_char
    1003 -> Just array_name
    1005 -> Just array_int2
    1006 -> Just array_int2vector
    1007 -> Just array_int4
    1008 -> Just array_regproc
    1009 -> Just array_text
    1010 -> Just array_tid
    1011 -> Just array_xid
    1012 -> Just array_cid
    1013 -> Just array_oidvector
    1014 -> Just array_bpchar
    1015 -> Just array_varchar
    1016 -> Just array_int8
    1017 -> Just array_point
    1018 -> Just array_lseg
    1019 -> Just array_path
    1020 -> Just array_box
    1021 -> Just array_float4
    1022 -> Just array_float8
    1027 -> Just array_polygon
    1028 -> Just array_oid
    1040 -> Just array_macaddr
    1041 -> Just array_inet
    1115 -> Just array_timestamp
    1182 -> Just array_date
    1183 -> Just array_time
    1185 -> Just array_timestamptz
    1187 -> Just array_interval
    1231 -> Just array_numeric
    1270 -> Just array_timetz
    1561 -> Just array_bit
    1563 -> Just array_varbit
    2201 -> Just array_refcursor
    2207 -> Just array_regprocedure
    2208 -> Just array_regoper
    2209 -> Just array_regoperator
    2210 -> Just array_regclass
    2211 -> Just array_regtype
    2951 -> Just array_uuid
    3807 -> Just array_jsonb
    3904 -> Just int4range
    3905 -> Just _int4range
    3906 -> Just numrange
    3907 -> Just _numrange
    3908 -> Just tsrange
    3909 -> Just _tsrange
    3910 -> Just tstzrange
    3911 -> Just _tstzrange
    3912 -> Just daterange
    3913 -> Just _daterange
    3926 -> Just int8range
    3927 -> Just _int8range
    _ -> Nothing

bool :: TypeInfo
bool =  Basic {
    typoid      = boolOid,
    typcategory = 'B',
    typdelim    = ',',
    typname     = "bool"
  }

boolOid :: Oid
boolOid = Oid 16
{-# INLINE boolOid #-}

bytea :: TypeInfo
bytea =  Basic {
    typoid      = byteaOid,
    typcategory = 'U',
    typdelim    = ',',
    typname     = "bytea"
  }

byteaOid :: Oid
byteaOid = Oid 17
{-# INLINE byteaOid #-}

char :: TypeInfo
char =  Basic {
    typoid      = charOid,
    typcategory = 'S',
    typdelim    = ',',
    typname     = "char"
  }

charOid :: Oid
charOid = Oid 18
{-# INLINE charOid #-}

name :: TypeInfo
name =  Basic {
    typoid      = nameOid,
    typcategory = 'S',
    typdelim    = ',',
    typname     = "name"
  }

nameOid :: Oid
nameOid = Oid 19
{-# INLINE nameOid #-}

int8 :: TypeInfo
int8 =  Basic {
    typoid      = int8Oid,
    typcategory = 'N',
    typdelim    = ',',
    typname     = "int8"
  }

int8Oid :: Oid
int8Oid = Oid 20
{-# INLINE int8Oid #-}

int2 :: TypeInfo
int2 =  Basic {
    typoid      = int2Oid,
    typcategory = 'N',
    typdelim    = ',',
    typname     = "int2"
  }

int2Oid :: Oid
int2Oid = Oid 21
{-# INLINE int2Oid #-}

int4 :: TypeInfo
int4 =  Basic {
    typoid      = int4Oid,
    typcategory = 'N',
    typdelim    = ',',
    typname     = "int4"
  }

int4Oid :: Oid
int4Oid = Oid 23
{-# INLINE int4Oid #-}

regproc :: TypeInfo
regproc =  Basic {
    typoid      = regprocOid,
    typcategory = 'N',
    typdelim    = ',',
    typname     = "regproc"
  }

regprocOid :: Oid
regprocOid = Oid 24
{-# INLINE regprocOid #-}

text :: TypeInfo
text =  Basic {
    typoid      = textOid,
    typcategory = 'S',
    typdelim    = ',',
    typname     = "text"
  }

textOid :: Oid
textOid = Oid 25
{-# INLINE textOid #-}

oid :: TypeInfo
oid =  Basic {
    typoid      = oidOid,
    typcategory = 'N',
    typdelim    = ',',
    typname     = "oid"
  }

oidOid :: Oid
oidOid = Oid 26
{-# INLINE oidOid #-}

tid :: TypeInfo
tid =  Basic {
    typoid      = tidOid,
    typcategory = 'U',
    typdelim    = ',',
    typname     = "tid"
  }

tidOid :: Oid
tidOid = Oid 27
{-# INLINE tidOid #-}

xid :: TypeInfo
xid =  Basic {
    typoid      = xidOid,
    typcategory = 'U',
    typdelim    = ',',
    typname     = "xid"
  }

xidOid :: Oid
xidOid = Oid 28
{-# INLINE xidOid #-}

cid :: TypeInfo
cid =  Basic {
    typoid      = cidOid,
    typcategory = 'U',
    typdelim    = ',',
    typname     = "cid"
  }

cidOid :: Oid
cidOid = Oid 29
{-# INLINE cidOid #-}

xml :: TypeInfo
xml =  Basic {
    typoid      = xmlOid,
    typcategory = 'U',
    typdelim    = ',',
    typname     = "xml"
  }

xmlOid :: Oid
xmlOid = Oid 142
{-# INLINE xmlOid #-}

point :: TypeInfo
point =  Basic {
    typoid      = pointOid,
    typcategory = 'G',
    typdelim    = ',',
    typname     = "point"
  }

pointOid :: Oid
pointOid = Oid 600
{-# INLINE pointOid #-}

lseg :: TypeInfo
lseg =  Basic {
    typoid      = lsegOid,
    typcategory = 'G',
    typdelim    = ',',
    typname     = "lseg"
  }

lsegOid :: Oid
lsegOid = Oid 601
{-# INLINE lsegOid #-}

path :: TypeInfo
path =  Basic {
    typoid      = pathOid,
    typcategory = 'G',
    typdelim    = ',',
    typname     = "path"
  }

pathOid :: Oid
pathOid = Oid 602
{-# INLINE pathOid #-}

box :: TypeInfo
box =  Basic {
    typoid      = boxOid,
    typcategory = 'G',
    typdelim    = ';',
    typname     = "box"
  }

boxOid :: Oid
boxOid = Oid 603
{-# INLINE boxOid #-}

polygon :: TypeInfo
polygon =  Basic {
    typoid      = polygonOid,
    typcategory = 'G',
    typdelim    = ',',
    typname     = "polygon"
  }

polygonOid :: Oid
polygonOid = Oid 604
{-# INLINE polygonOid #-}

line :: TypeInfo
line =  Basic {
    typoid      = lineOid,
    typcategory = 'G',
    typdelim    = ',',
    typname     = "line"
  }

lineOid :: Oid
lineOid = Oid 628
{-# INLINE lineOid #-}

cidr :: TypeInfo
cidr =  Basic {
    typoid      = cidrOid,
    typcategory = 'I',
    typdelim    = ',',
    typname     = "cidr"
  }

cidrOid :: Oid
cidrOid = Oid 650
{-# INLINE cidrOid #-}

float4 :: TypeInfo
float4 =  Basic {
    typoid      = float4Oid,
    typcategory = 'N',
    typdelim    = ',',
    typname     = "float4"
  }

float4Oid :: Oid
float4Oid = Oid 700
{-# INLINE float4Oid #-}

float8 :: TypeInfo
float8 =  Basic {
    typoid      = float8Oid,
    typcategory = 'N',
    typdelim    = ',',
    typname     = "float8"
  }

float8Oid :: Oid
float8Oid = Oid 701
{-# INLINE float8Oid #-}

unknown :: TypeInfo
unknown =  Basic {
    typoid      = unknownOid,
    typcategory = 'X',
    typdelim    = ',',
    typname     = "unknown"
  }

unknownOid :: Oid
unknownOid = Oid 705
{-# INLINE unknownOid #-}

circle :: TypeInfo
circle =  Basic {
    typoid      = circleOid,
    typcategory = 'G',
    typdelim    = ',',
    typname     = "circle"
  }

circleOid :: Oid
circleOid = Oid 718
{-# INLINE circleOid #-}

money :: TypeInfo
money =  Basic {
    typoid      = moneyOid,
    typcategory = 'N',
    typdelim    = ',',
    typname     = "money"
  }

moneyOid :: Oid
moneyOid = Oid 790
{-# INLINE moneyOid #-}

macaddr :: TypeInfo
macaddr =  Basic {
    typoid      = macaddrOid,
    typcategory = 'U',
    typdelim    = ',',
    typname     = "macaddr"
  }

macaddrOid :: Oid
macaddrOid = Oid 829
{-# INLINE macaddrOid #-}

inet :: TypeInfo
inet =  Basic {
    typoid      = inetOid,
    typcategory = 'I',
    typdelim    = ',',
    typname     = "inet"
  }

inetOid :: Oid
inetOid = Oid 869
{-# INLINE inetOid #-}

bpchar :: TypeInfo
bpchar =  Basic {
    typoid      = bpcharOid,
    typcategory = 'S',
    typdelim    = ',',
    typname     = "bpchar"
  }

bpcharOid :: Oid
bpcharOid = Oid 1042
{-# INLINE bpcharOid #-}

varchar :: TypeInfo
varchar =  Basic {
    typoid      = varcharOid,
    typcategory = 'S',
    typdelim    = ',',
    typname     = "varchar"
  }

varcharOid :: Oid
varcharOid = Oid 1043
{-# INLINE varcharOid #-}

date :: TypeInfo
date =  Basic {
    typoid      = dateOid,
    typcategory = 'D',
    typdelim    = ',',
    typname     = "date"
  }

dateOid :: Oid
dateOid = Oid 1082
{-# INLINE dateOid #-}

time :: TypeInfo
time =  Basic {
    typoid      = timeOid,
    typcategory = 'D',
    typdelim    = ',',
    typname     = "time"
  }

timeOid :: Oid
timeOid = Oid 1083
{-# INLINE timeOid #-}

timestamp :: TypeInfo
timestamp =  Basic {
    typoid      = timestampOid,
    typcategory = 'D',
    typdelim    = ',',
    typname     = "timestamp"
  }

timestampOid :: Oid
timestampOid = Oid 1114
{-# INLINE timestampOid #-}

timestamptz :: TypeInfo
timestamptz =  Basic {
    typoid      = timestamptzOid,
    typcategory = 'D',
    typdelim    = ',',
    typname     = "timestamptz"
  }

timestamptzOid :: Oid
timestamptzOid = Oid 1184
{-# INLINE timestamptzOid #-}

interval :: TypeInfo
interval =  Basic {
    typoid      = intervalOid,
    typcategory = 'T',
    typdelim    = ',',
    typname     = "interval"
  }

intervalOid :: Oid
intervalOid = Oid 1186
{-# INLINE intervalOid #-}

timetz :: TypeInfo
timetz =  Basic {
    typoid      = timetzOid,
    typcategory = 'D',
    typdelim    = ',',
    typname     = "timetz"
  }

timetzOid :: Oid
timetzOid = Oid 1266
{-# INLINE timetzOid #-}

bit :: TypeInfo
bit =  Basic {
    typoid      = bitOid,
    typcategory = 'V',
    typdelim    = ',',
    typname     = "bit"
  }

bitOid :: Oid
bitOid = Oid 1560
{-# INLINE bitOid #-}

varbit :: TypeInfo
varbit =  Basic {
    typoid      = varbitOid,
    typcategory = 'V',
    typdelim    = ',',
    typname     = "varbit"
  }

varbitOid :: Oid
varbitOid = Oid 1562
{-# INLINE varbitOid #-}

numeric :: TypeInfo
numeric =  Basic {
    typoid      = numericOid,
    typcategory = 'N',
    typdelim    = ',',
    typname     = "numeric"
  }

numericOid :: Oid
numericOid = Oid 1700
{-# INLINE numericOid #-}

refcursor :: TypeInfo
refcursor =  Basic {
    typoid      = refcursorOid,
    typcategory = 'U',
    typdelim    = ',',
    typname     = "refcursor"
  }

refcursorOid :: Oid
refcursorOid = Oid 1790
{-# INLINE refcursorOid #-}

record :: TypeInfo
record =  Basic {
    typoid      = recordOid,
    typcategory = 'P',
    typdelim    = ',',
    typname     = "record"
  }

recordOid :: Oid
recordOid = Oid 2249
{-# INLINE recordOid #-}

void :: TypeInfo
void =  Basic {
    typoid      = voidOid,
    typcategory = 'P',
    typdelim    = ',',
    typname     = "void"
  }

voidOid :: Oid
voidOid = Oid 2278
{-# INLINE voidOid #-}

array_record :: TypeInfo
array_record =  Array {
    typoid      = array_recordOid,
    typcategory = 'P',
    typdelim    = ',',
    typname     = "_record",
    typelem     = record
  }

array_recordOid :: Oid
array_recordOid = Oid 2287
{-# INLINE array_recordOid #-}

regprocedure :: TypeInfo
regprocedure =  Basic {
    typoid      = regprocedureOid,
    typcategory = 'N',
    typdelim    = ',',
    typname     = "regprocedure"
  }

regprocedureOid :: Oid
regprocedureOid = Oid 2202
{-# INLINE regprocedureOid #-}

regoper :: TypeInfo
regoper =  Basic {
    typoid      = regoperOid,
    typcategory = 'N',
    typdelim    = ',',
    typname     = "regoper"
  }

regoperOid :: Oid
regoperOid = Oid 2203
{-# INLINE regoperOid #-}

regoperator :: TypeInfo
regoperator =  Basic {
    typoid      = regoperatorOid,
    typcategory = 'N',
    typdelim    = ',',
    typname     = "regoperator"
  }

regoperatorOid :: Oid
regoperatorOid = Oid 2204
{-# INLINE regoperatorOid #-}

regclass :: TypeInfo
regclass =  Basic {
    typoid      = regclassOid,
    typcategory = 'N',
    typdelim    = ',',
    typname     = "regclass"
  }

regclassOid :: Oid
regclassOid = Oid 2205
{-# INLINE regclassOid #-}

regtype :: TypeInfo
regtype =  Basic {
    typoid      = regtypeOid,
    typcategory = 'N',
    typdelim    = ',',
    typname     = "regtype"
  }

regtypeOid :: Oid
regtypeOid = Oid 2206
{-# INLINE regtypeOid #-}

uuid :: TypeInfo
uuid =  Basic {
    typoid      = uuidOid,
    typcategory = 'U',
    typdelim    = ',',
    typname     = "uuid"
  }

uuidOid :: Oid
uuidOid = Oid 2950
{-# INLINE uuidOid #-}

json :: TypeInfo
json =  Basic {
    typoid      = jsonOid,
    typcategory = 'U',
    typdelim    = ',',
    typname     = "json"
  }

jsonOid :: Oid
jsonOid = Oid 114
{-# INLINE jsonOid #-}

jsonb :: TypeInfo
jsonb =  Basic {
    typoid      = jsonbOid,
    typcategory = 'U',
    typdelim    = ',',
    typname     = "jsonb"
  }

jsonbOid :: Oid
jsonbOid = Oid 3802
{-# INLINE jsonbOid #-}

int2vector :: TypeInfo
int2vector =  Array {
    typoid      = int2vectorOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "int2vector",
    typelem     = int2
  }

int2vectorOid :: Oid
int2vectorOid = Oid 22
{-# INLINE int2vectorOid #-}

oidvector :: TypeInfo
oidvector =  Array {
    typoid      = oidvectorOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "oidvector",
    typelem     = oid
  }

oidvectorOid :: Oid
oidvectorOid = Oid 30
{-# INLINE oidvectorOid #-}

array_xml :: TypeInfo
array_xml =  Array {
    typoid      = array_xmlOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_xml",
    typelem     = xml
  }

array_xmlOid :: Oid
array_xmlOid = Oid 143
{-# INLINE array_xmlOid #-}

array_json :: TypeInfo
array_json =  Array {
    typoid      = array_jsonOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_json",
    typelem     = json
  }

array_jsonOid :: Oid
array_jsonOid = Oid 199
{-# INLINE array_jsonOid #-}

array_line :: TypeInfo
array_line =  Array {
    typoid      = array_lineOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_line",
    typelem     = line
  }

array_lineOid :: Oid
array_lineOid = Oid 629
{-# INLINE array_lineOid #-}

array_cidr :: TypeInfo
array_cidr =  Array {
    typoid      = array_cidrOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_cidr",
    typelem     = cidr
  }

array_cidrOid :: Oid
array_cidrOid = Oid 651
{-# INLINE array_cidrOid #-}

array_circle :: TypeInfo
array_circle =  Array {
    typoid      = array_circleOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_circle",
    typelem     = circle
  }

array_circleOid :: Oid
array_circleOid = Oid 719
{-# INLINE array_circleOid #-}

array_money :: TypeInfo
array_money =  Array {
    typoid      = array_moneyOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_money",
    typelem     = money
  }

array_moneyOid :: Oid
array_moneyOid = Oid 791
{-# INLINE array_moneyOid #-}

array_bool :: TypeInfo
array_bool =  Array {
    typoid      = array_boolOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_bool",
    typelem     = bool
  }

array_boolOid :: Oid
array_boolOid = Oid 1000
{-# INLINE array_boolOid #-}

array_bytea :: TypeInfo
array_bytea =  Array {
    typoid      = array_byteaOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_bytea",
    typelem     = bytea
  }

array_byteaOid :: Oid
array_byteaOid = Oid 1001
{-# INLINE array_byteaOid #-}

array_char :: TypeInfo
array_char =  Array {
    typoid      = array_charOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_char",
    typelem     = char
  }

array_charOid :: Oid
array_charOid = Oid 1002
{-# INLINE array_charOid #-}

array_name :: TypeInfo
array_name =  Array {
    typoid      = array_nameOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_name",
    typelem     = name
  }

array_nameOid :: Oid
array_nameOid = Oid 1003
{-# INLINE array_nameOid #-}

array_int2 :: TypeInfo
array_int2 =  Array {
    typoid      = array_int2Oid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_int2",
    typelem     = int2
  }

array_int2Oid :: Oid
array_int2Oid = Oid 1005
{-# INLINE array_int2Oid #-}

array_int2vector :: TypeInfo
array_int2vector =  Array {
    typoid      = array_int2vectorOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_int2vector",
    typelem     = int2vector
  }

array_int2vectorOid :: Oid
array_int2vectorOid = Oid 1006
{-# INLINE array_int2vectorOid #-}

array_int4 :: TypeInfo
array_int4 =  Array {
    typoid      = array_int4Oid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_int4",
    typelem     = int4
  }

array_int4Oid :: Oid
array_int4Oid = Oid 1007
{-# INLINE array_int4Oid #-}

array_regproc :: TypeInfo
array_regproc =  Array {
    typoid      = array_regprocOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_regproc",
    typelem     = regproc
  }

array_regprocOid :: Oid
array_regprocOid = Oid 1008
{-# INLINE array_regprocOid #-}

array_text :: TypeInfo
array_text =  Array {
    typoid      = array_textOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_text",
    typelem     = text
  }

array_textOid :: Oid
array_textOid = Oid 1009
{-# INLINE array_textOid #-}

array_tid :: TypeInfo
array_tid =  Array {
    typoid      = array_tidOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_tid",
    typelem     = tid
  }

array_tidOid :: Oid
array_tidOid = Oid 1010
{-# INLINE array_tidOid #-}

array_xid :: TypeInfo
array_xid =  Array {
    typoid      = array_xidOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_xid",
    typelem     = xid
  }

array_xidOid :: Oid
array_xidOid = Oid 1011
{-# INLINE array_xidOid #-}

array_cid :: TypeInfo
array_cid =  Array {
    typoid      = array_cidOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_cid",
    typelem     = cid
  }

array_cidOid :: Oid
array_cidOid = Oid 1012
{-# INLINE array_cidOid #-}

array_oidvector :: TypeInfo
array_oidvector =  Array {
    typoid      = array_oidvectorOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_oidvector",
    typelem     = oidvector
  }

array_oidvectorOid :: Oid
array_oidvectorOid = Oid 1013
{-# INLINE array_oidvectorOid #-}

array_bpchar :: TypeInfo
array_bpchar =  Array {
    typoid      = array_bpcharOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_bpchar",
    typelem     = bpchar
  }

array_bpcharOid :: Oid
array_bpcharOid = Oid 1014
{-# INLINE array_bpcharOid #-}

array_varchar :: TypeInfo
array_varchar =  Array {
    typoid      = array_varcharOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_varchar",
    typelem     = varchar
  }

array_varcharOid :: Oid
array_varcharOid = Oid 1015
{-# INLINE array_varcharOid #-}

array_int8 :: TypeInfo
array_int8 =  Array {
    typoid      = array_int8Oid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_int8",
    typelem     = int8
  }

array_int8Oid :: Oid
array_int8Oid = Oid 1016
{-# INLINE array_int8Oid #-}

array_point :: TypeInfo
array_point =  Array {
    typoid      = array_pointOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_point",
    typelem     = point
  }

array_pointOid :: Oid
array_pointOid = Oid 1017
{-# INLINE array_pointOid #-}

array_lseg :: TypeInfo
array_lseg =  Array {
    typoid      = array_lsegOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_lseg",
    typelem     = lseg
  }

array_lsegOid :: Oid
array_lsegOid = Oid 1018
{-# INLINE array_lsegOid #-}

array_path :: TypeInfo
array_path =  Array {
    typoid      = array_pathOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_path",
    typelem     = path
  }

array_pathOid :: Oid
array_pathOid = Oid 1019
{-# INLINE array_pathOid #-}

array_box :: TypeInfo
array_box =  Array {
    typoid      = array_boxOid,
    typcategory = 'A',
    typdelim    = ';',
    typname     = "_box",
    typelem     = box
  }

array_boxOid :: Oid
array_boxOid = Oid 1020
{-# INLINE array_boxOid #-}

array_float4 :: TypeInfo
array_float4 =  Array {
    typoid      = array_float4Oid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_float4",
    typelem     = float4
  }

array_float4Oid :: Oid
array_float4Oid = Oid 1021
{-# INLINE array_float4Oid #-}

array_float8 :: TypeInfo
array_float8 =  Array {
    typoid      = array_float8Oid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_float8",
    typelem     = float8
  }

array_float8Oid :: Oid
array_float8Oid = Oid 1022
{-# INLINE array_float8Oid #-}

array_polygon :: TypeInfo
array_polygon =  Array {
    typoid      = array_polygonOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_polygon",
    typelem     = polygon
  }

array_polygonOid :: Oid
array_polygonOid = Oid 1027
{-# INLINE array_polygonOid #-}

array_oid :: TypeInfo
array_oid =  Array {
    typoid      = array_oidOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_oid",
    typelem     = oid
  }

array_oidOid :: Oid
array_oidOid = Oid 1028
{-# INLINE array_oidOid #-}

array_macaddr :: TypeInfo
array_macaddr =  Array {
    typoid      = array_macaddrOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_macaddr",
    typelem     = macaddr
  }

array_macaddrOid :: Oid
array_macaddrOid = Oid 1040
{-# INLINE array_macaddrOid #-}

array_inet :: TypeInfo
array_inet =  Array {
    typoid      = array_inetOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_inet",
    typelem     = inet
  }

array_inetOid :: Oid
array_inetOid = Oid 1041
{-# INLINE array_inetOid #-}

array_timestamp :: TypeInfo
array_timestamp =  Array {
    typoid      = array_timestampOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_timestamp",
    typelem     = timestamp
  }

array_timestampOid :: Oid
array_timestampOid = Oid 1115
{-# INLINE array_timestampOid #-}

array_date :: TypeInfo
array_date =  Array {
    typoid      = array_dateOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_date",
    typelem     = date
  }

array_dateOid :: Oid
array_dateOid = Oid 1182
{-# INLINE array_dateOid #-}

array_time :: TypeInfo
array_time =  Array {
    typoid      = array_timeOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_time",
    typelem     = time
  }

array_timeOid :: Oid
array_timeOid = Oid 1183
{-# INLINE array_timeOid #-}

array_timestamptz :: TypeInfo
array_timestamptz =  Array {
    typoid      = array_timestamptzOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_timestamptz",
    typelem     = timestamptz
  }

array_timestamptzOid :: Oid
array_timestamptzOid = Oid 1185
{-# INLINE array_timestamptzOid #-}

array_interval :: TypeInfo
array_interval =  Array {
    typoid      = array_intervalOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_interval",
    typelem     = interval
  }

array_intervalOid :: Oid
array_intervalOid = Oid 1187
{-# INLINE array_intervalOid #-}

array_numeric :: TypeInfo
array_numeric =  Array {
    typoid      = array_numericOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_numeric",
    typelem     = numeric
  }

array_numericOid :: Oid
array_numericOid = Oid 1231
{-# INLINE array_numericOid #-}

array_timetz :: TypeInfo
array_timetz =  Array {
    typoid      = array_timetzOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_timetz",
    typelem     = timetz
  }

array_timetzOid :: Oid
array_timetzOid = Oid 1270
{-# INLINE array_timetzOid #-}

array_bit :: TypeInfo
array_bit =  Array {
    typoid      = array_bitOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_bit",
    typelem     = bit
  }

array_bitOid :: Oid
array_bitOid = Oid 1561
{-# INLINE array_bitOid #-}

array_varbit :: TypeInfo
array_varbit =  Array {
    typoid      = array_varbitOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_varbit",
    typelem     = varbit
  }

array_varbitOid :: Oid
array_varbitOid = Oid 1563
{-# INLINE array_varbitOid #-}

array_refcursor :: TypeInfo
array_refcursor =  Array {
    typoid      = array_refcursorOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_refcursor",
    typelem     = refcursor
  }

array_refcursorOid :: Oid
array_refcursorOid = Oid 2201
{-# INLINE array_refcursorOid #-}

array_regprocedure :: TypeInfo
array_regprocedure =  Array {
    typoid      = array_regprocedureOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_regprocedure",
    typelem     = regprocedure
  }

array_regprocedureOid :: Oid
array_regprocedureOid = Oid 2207
{-# INLINE array_regprocedureOid #-}

array_regoper :: TypeInfo
array_regoper =  Array {
    typoid      = array_regoperOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_regoper",
    typelem     = regoper
  }

array_regoperOid :: Oid
array_regoperOid = Oid 2208
{-# INLINE array_regoperOid #-}

array_regoperator :: TypeInfo
array_regoperator =  Array {
    typoid      = array_regoperatorOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_regoperator",
    typelem     = regoperator
  }

array_regoperatorOid :: Oid
array_regoperatorOid = Oid 2209
{-# INLINE array_regoperatorOid #-}

array_regclass :: TypeInfo
array_regclass =  Array {
    typoid      = array_regclassOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_regclass",
    typelem     = regclass
  }

array_regclassOid :: Oid
array_regclassOid = Oid 2210
{-# INLINE array_regclassOid #-}

array_regtype :: TypeInfo
array_regtype =  Array {
    typoid      = array_regtypeOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_regtype",
    typelem     = regtype
  }

array_regtypeOid :: Oid
array_regtypeOid = Oid 2211
{-# INLINE array_regtypeOid #-}

array_uuid :: TypeInfo
array_uuid =  Array {
    typoid      = array_uuidOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_uuid",
    typelem     = uuid
  }

array_uuidOid :: Oid
array_uuidOid = Oid 2951
{-# INLINE array_uuidOid #-}

array_jsonb :: TypeInfo
array_jsonb =  Array {
    typoid      = array_jsonbOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_jsonb",
    typelem     = jsonb
  }

array_jsonbOid :: Oid
array_jsonbOid = Oid 3807
{-# INLINE array_jsonbOid #-}

int4range :: TypeInfo
int4range =  Range {
    typoid      = int4rangeOid,
    typcategory = 'R',
    typdelim    = ',',
    typname     = "int4range",
    rngsubtype  = int4
  }

int4rangeOid :: Oid
int4rangeOid = Oid 3904
{-# INLINE int4rangeOid #-}

_int4range :: TypeInfo
_int4range =  Array {
    typoid      = _int4rangeOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_int4range",
    typelem     = int4range
  }

_int4rangeOid :: Oid
_int4rangeOid = Oid 3905
{-# INLINE _int4rangeOid #-}

numrange :: TypeInfo
numrange =  Range {
    typoid      = numrangeOid,
    typcategory = 'R',
    typdelim    = ',',
    typname     = "numrange",
    rngsubtype  = numeric
  }

numrangeOid :: Oid
numrangeOid = Oid 3906
{-# INLINE numrangeOid #-}

_numrange :: TypeInfo
_numrange =  Array {
    typoid      = _numrangeOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_numrange",
    typelem     = numrange
  }

_numrangeOid :: Oid
_numrangeOid = Oid 3907
{-# INLINE _numrangeOid #-}

tsrange :: TypeInfo
tsrange =  Range {
    typoid      = tsrangeOid,
    typcategory = 'R',
    typdelim    = ',',
    typname     = "tsrange",
    rngsubtype  = timestamp
  }

tsrangeOid :: Oid
tsrangeOid = Oid 3908
{-# INLINE tsrangeOid #-}

_tsrange :: TypeInfo
_tsrange =  Array {
    typoid      = _tsrangeOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_tsrange",
    typelem     = tsrange
  }

_tsrangeOid :: Oid
_tsrangeOid = Oid 3909
{-# INLINE _tsrangeOid #-}

tstzrange :: TypeInfo
tstzrange =  Range {
    typoid      = tstzrangeOid,
    typcategory = 'R',
    typdelim    = ',',
    typname     = "tstzrange",
    rngsubtype  = timestamptz
  }

tstzrangeOid :: Oid
tstzrangeOid = Oid 3910
{-# INLINE tstzrangeOid #-}

_tstzrange :: TypeInfo
_tstzrange =  Array {
    typoid      = _tstzrangeOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_tstzrange",
    typelem     = tstzrange
  }

_tstzrangeOid :: Oid
_tstzrangeOid = Oid 3911
{-# INLINE _tstzrangeOid #-}

daterange :: TypeInfo
daterange =  Range {
    typoid      = daterangeOid,
    typcategory = 'R',
    typdelim    = ',',
    typname     = "daterange",
    rngsubtype  = date
  }

daterangeOid :: Oid
daterangeOid = Oid 3912
{-# INLINE daterangeOid #-}

_daterange :: TypeInfo
_daterange =  Array {
    typoid      = _daterangeOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_daterange",
    typelem     = daterange
  }

_daterangeOid :: Oid
_daterangeOid = Oid 3913
{-# INLINE _daterangeOid #-}

int8range :: TypeInfo
int8range =  Range {
    typoid      = int8rangeOid,
    typcategory = 'R',
    typdelim    = ',',
    typname     = "int8range",
    rngsubtype  = int8
  }

int8rangeOid :: Oid
int8rangeOid = Oid 3926
{-# INLINE int8rangeOid #-}

_int8range :: TypeInfo
_int8range =  Array {
    typoid      = _int8rangeOid,
    typcategory = 'A',
    typdelim    = ',',
    typname     = "_int8range",
    typelem     = int8range
  }

_int8rangeOid :: Oid
_int8rangeOid = Oid 3927
{-# INLINE _int8rangeOid #-}
