/*
 * Copyright (C)2005-2013 Haxe Foundation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

// This file is generated, do not edit!
package js.html;

/** <p>The HTML <em>menu</em> element (<code>&lt;menu&gt;</code>) represents an unordered list of menu choices, or commands.</p>
<p>There is no limitation to the depth and nesting of lists defined with the <code><a rel="custom" href="/api/js/html/MenuElement">&lt;menu&gt;</a></code>
, <code><a rel="custom" href="/api/js/html/OListElement">&lt;ol&gt;</a></code>
 and <code><a rel="custom" href="/api/js/html/UListElement">&lt;ul&gt;</a></code>
 elements.</p>
<div class="note"><strong>Usage note: </strong> The <code><a rel="custom" href="/api/js/html/MenuElement">&lt;menu&gt;</a></code>
 and <code><a rel="custom" href="/api/js/html/UListElement">&lt;ul&gt;</a></code>
 both represent an unordered list of items. They differ in the way that the <code><a rel="custom" href="/api/js/html/UListElement">&lt;ul&gt;</a></code>
 element only contains items to display while the <code><a rel="custom" href="/api/js/html/MenuElement">&lt;menu&gt;</a></code>
 element contains interactive items, to act on.</div>
<div class="note"><strong>Note</strong>: This element was deprecated in HTML4, but reintroduced in HTML5.</div><br><br>
Documentation for this class was provided by <a href="https://developer.mozilla.org/en/HTML/Element/menu">MDN</a>. */
@:native("HTMLMenuElement")
extern class MenuElement extends Element
{
	var compact : Bool;

}
