#! /bin/awk
BEGIN {
	printf("%s", "[REV]\nID=1.0.0\nAPP=IC-PCR1000  Revision 2.0\n")
	bank = 0
	chan = 0
}
{
	if (NF < 4 && $1 == "bank") {
		printf("[BANK%02d]\n", bank)
		printf("BANKNAME=%s\n", $3)
		printf("ACTIVECH=0\n")
		bank++
		chan = 0
	}
	if (NF == 4) {

		printf("%02d=%s,,%.3f,%s,3k,OFF,3kHz,OFF,OFF,OFF\n", chan, $4, $1 / 1000, $2)
		chan++;
	}
} END {
	for (; bank < 20; bank++) {
		printf("[BANK%02d]\n", bank)
		printf("BANKNAME=\n")
		printf("ACTIVECH=0\n")
	}
}
