;=========================== begin_copyright_notice ============================
;
; Copyright (C) 2025 Intel Corporation
;
; SPDX-License-Identifier: MIT
;
;============================ end_copyright_notice =============================

; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; REQUIRES: regkeys
; RUN: igc_opt -S --igc-split-loads -platformpvc --regkey=LS_enableLoadSplitting=1 --regkey=LS_ignoreSplitThreshold=1 --regkey=LS_minSplitSize_GRF=0 --regkey=LS_minSplitSize_E=0 %s | FileCheck %s --check-prefix=MINSPLIT
; RUN: igc_opt -S --igc-split-loads -platformpvc --regkey=LS_enableLoadSplitting=1 --regkey=LS_ignoreSplitThreshold=1 --regkey=LS_minSplitSize_GRF=0 --regkey=LS_minSplitSize_E=8 %s | FileCheck %s --check-prefix=SPLIT8

declare spir_func void @fun_v4i32(<4 x i32>)
declare spir_func void @fun_v8i32(<8 x i32>)
declare spir_func void @fun_v16i32(<16 x i32>)

declare spir_func void @fun_v4fl(<4 x float>)
declare spir_func void @fun_v8fl(<8 x float>)
declare spir_func void @fun_v16fl(<16 x float>)

declare spir_func void @fun_v8i16(<8 x i16>)

declare spir_func <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64, i32, i32, i32, i32, i32, i32, i32, i32, i32, i1, i1, i32)
declare spir_func <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64, i32, i32, i32, i32, i32, i32, i32, i32, i32, i1, i1, i32)

define spir_kernel void @basic_shuffles_fail_1(i64 %ptr) {
  ; Undefs in range:
; MINSPLIT-LABEL: @basic_shuffles_fail_1(
; MINSPLIT-NEXT:    [[VEC1:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[PICK1:%.*]] = shufflevector <16 x i32> [[VEC1]], <16 x i32> undef, <4 x i32> <i32 undef, i32 1, i32 2, i32 3>
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK1]])
; MINSPLIT-NEXT:    [[VEC2:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[PICK2_1:%.*]] = shufflevector <16 x i32> [[VEC2]], <16 x i32> undef, <4 x i32> <i32 0, i32 undef, i32 1, i32 2>
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK2_1]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @basic_shuffles_fail_1(
; SPLIT8-NEXT:    [[VEC1:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[PICK1:%.*]] = shufflevector <16 x i32> [[VEC1]], <16 x i32> undef, <4 x i32> <i32 undef, i32 1, i32 2, i32 3>
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK1]])
; SPLIT8-NEXT:    [[VEC2:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[PICK2_1:%.*]] = shufflevector <16 x i32> [[VEC2]], <16 x i32> undef, <4 x i32> <i32 0, i32 undef, i32 1, i32 2>
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK2_1]])
; SPLIT8-NEXT:    ret void
;
  %vec1 = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 %ptr, i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
  %pick1 = shufflevector <16 x i32> %vec1, <16 x i32> undef, <4 x i32> <i32 undef, i32 1, i32 2, i32 3>
  call void @fun_v4i32(<4 x i32> %pick1)

  %vec2 = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 %ptr, i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
  %pick2.1 = shufflevector <16 x i32> %vec2, <16 x i32> undef, <4 x i32> <i32 0, i32 undef, i32 1, i32 2>
  call void @fun_v4i32(<4 x i32> %pick2.1)

  ret void
}

define spir_kernel void @basic_shuffles_fail_2(i64 %ptr) {
  ; Wrong picks:
; MINSPLIT-LABEL: @basic_shuffles_fail_2(
; MINSPLIT-NEXT:    [[VEC1:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[PICK1_1:%.*]] = shufflevector <16 x i32> [[VEC1]], <16 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 1>
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK1_1]])
; MINSPLIT-NEXT:    [[VEC2:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[PICK2_1:%.*]] = shufflevector <16 x i32> [[VEC2]], <16 x i32> undef, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK2_1]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @basic_shuffles_fail_2(
; SPLIT8-NEXT:    [[VEC1:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[PICK1_1:%.*]] = shufflevector <16 x i32> [[VEC1]], <16 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 1>
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK1_1]])
; SPLIT8-NEXT:    [[VEC2:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[PICK2_1:%.*]] = shufflevector <16 x i32> [[VEC2]], <16 x i32> undef, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK2_1]])
; SPLIT8-NEXT:    ret void
;
  %vec1 = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 %ptr, i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
  %pick1.1 = shufflevector <16 x i32> %vec1, <16 x i32> undef, <4 x i32> <i32 0, i32 0, i32 0, i32 1>
  call void @fun_v4i32(<4 x i32> %pick1.1)

  %vec2 = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 %ptr, i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
  %pick2.1 = shufflevector <16 x i32> %vec2, <16 x i32> undef, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  call void @fun_v4i32(<4 x i32> %pick2.1)

  ret void
}

define spir_kernel void @basic_shuffles_fail_3(i64 %ptr) {
  ; Elements picked from two vectors:
; MINSPLIT-LABEL: @basic_shuffles_fail_3(
; MINSPLIT-NEXT:    [[VEC2:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[PICK2_1:%.*]] = shufflevector <16 x i32> [[VEC2]], <16 x i32> zeroinitializer, <4 x i32> <i32 14, i32 15, i32 16, i32 17>
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK2_1]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @basic_shuffles_fail_3(
; SPLIT8-NEXT:    [[VEC2:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[PICK2_1:%.*]] = shufflevector <16 x i32> [[VEC2]], <16 x i32> zeroinitializer, <4 x i32> <i32 14, i32 15, i32 16, i32 17>
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK2_1]])
; SPLIT8-NEXT:    ret void
;
  %vec2 = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 %ptr, i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
  %pick2.1 = shufflevector <16 x i32> %vec2, <16 x i32> zeroinitializer, <4 x i32> <i32 14, i32 15, i32 16, i32 17>
  call void @fun_v4i32(<4 x i32> %pick2.1)
  ret void
}

define spir_kernel void @basic_shuffles_fail_4(i64 %ptr) {
  ; Not a pick:
; MINSPLIT-LABEL: @basic_shuffles_fail_4(
; MINSPLIT-NEXT:    [[VEC5:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    call void @fun_v16i32(<16 x i32> [[VEC5]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @basic_shuffles_fail_4(
; SPLIT8-NEXT:    [[VEC5:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    call void @fun_v16i32(<16 x i32> [[VEC5]])
; SPLIT8-NEXT:    ret void
;
  %vec5 = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 %ptr, i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
  call void @fun_v16i32(<16 x i32> %vec5)
  ret void
}

define spir_kernel void @basic_shuffles_fail_5(i64 %ptr) {
  ; Not a valid tree of instructions:
; MINSPLIT-LABEL: @basic_shuffles_fail_5(
; MINSPLIT-NEXT:    [[VEC6:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[VECADD:%.*]] = insertelement <16 x i32> [[VEC6]], i32 1234, i32 5
; MINSPLIT-NEXT:    call void @fun_v16i32(<16 x i32> [[VECADD]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @basic_shuffles_fail_5(
; SPLIT8-NEXT:    [[VEC6:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[VECADD:%.*]] = insertelement <16 x i32> [[VEC6]], i32 1234, i32 5
; SPLIT8-NEXT:    call void @fun_v16i32(<16 x i32> [[VECADD]])
; SPLIT8-NEXT:    ret void
;
  %vec6 = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 %ptr, i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
  %vecadd = insertelement <16 x i32> %vec6, i32 1234, i32 5
  call void @fun_v16i32(<16 x i32> %vecadd)
  ret void
}

define spir_kernel void @basic_shuffles_fail_6(i64 %ptr) {
  ; Does not cover:
; MINSPLIT-LABEL: @basic_shuffles_fail_6(
; MINSPLIT-NEXT:    [[VEC6:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[PICK6_1:%.*]] = shufflevector <16 x i32> [[VEC6]], <16 x i32> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK6_1]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @basic_shuffles_fail_6(
; SPLIT8-NEXT:    [[VEC6:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[PICK6_1:%.*]] = shufflevector <16 x i32> [[VEC6]], <16 x i32> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK6_1]])
; SPLIT8-NEXT:    ret void
;
  %vec6 = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 %ptr, i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
  %pick6.1 = shufflevector <16 x i32> %vec6, <16 x i32> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  call void @fun_v4i32(<4 x i32> %pick6.1)
  ret void
}

define spir_kernel void @basic_shuffles_fail_7(i64 %ptr) {
  ; Divisibility fail:
; MINSPLIT-LABEL: @basic_shuffles_fail_7(
; MINSPLIT-NEXT:    [[VEC6:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[PICK6_1:%.*]] = shufflevector <16 x i32> [[VEC6]], <16 x i32> undef, <4 x i32> <i32 1, i32 2, i32 3, i32 4>
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK6_1]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @basic_shuffles_fail_7(
; SPLIT8-NEXT:    [[VEC6:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[PICK6_1:%.*]] = shufflevector <16 x i32> [[VEC6]], <16 x i32> undef, <4 x i32> <i32 1, i32 2, i32 3, i32 4>
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK6_1]])
; SPLIT8-NEXT:    ret void
;
  %vec6 = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 %ptr, i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
  %pick6.1 = shufflevector <16 x i32> %vec6, <16 x i32> undef, <4 x i32> <i32 1, i32 2, i32 3, i32 4>
  call void @fun_v4i32(<4 x i32> %pick6.1)
  ret void
}

define spir_kernel void @trees_fail_1(i64 %ptr) {
  ; Bitcast changes the bit width of the scalar type:
; MINSPLIT-LABEL: @trees_fail_1(
; MINSPLIT-NEXT:    [[VEC1:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[PICK1_1_I32:%.*]] = shufflevector <16 x i32> [[VEC1]], <16 x i32> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; MINSPLIT-NEXT:    [[PICK1_1_I16:%.*]] = bitcast <4 x i32> [[PICK1_1_I32]] to <8 x i16>
; MINSPLIT-NEXT:    call void @fun_v8i16(<8 x i16> [[PICK1_1_I16]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @trees_fail_1(
; SPLIT8-NEXT:    [[VEC1:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[PICK1_1_I32:%.*]] = shufflevector <16 x i32> [[VEC1]], <16 x i32> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; SPLIT8-NEXT:    [[PICK1_1_I16:%.*]] = bitcast <4 x i32> [[PICK1_1_I32]] to <8 x i16>
; SPLIT8-NEXT:    call void @fun_v8i16(<8 x i16> [[PICK1_1_I16]])
; SPLIT8-NEXT:    ret void
;
  %vec1 = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 %ptr, i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
  %pick1.1.i32 = shufflevector <16 x i32> %vec1, <16 x i32> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %pick1.1.i16 = bitcast <4 x i32> %pick1.1.i32 to <8 x i16>
  call void @fun_v8i16(<8 x i16> %pick1.1.i16)
  ret void
}

define spir_kernel void @trees_fail_2(i64 %ptr) {
  ; No users:
; MINSPLIT-LABEL: @trees_fail_2(
; MINSPLIT-NEXT:    [[VEC1:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[PICK1_1:%.*]] = shufflevector <16 x i32> [[VEC1]], <16 x i32> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; MINSPLIT-NEXT:    [[PICK1_2:%.*]] = shufflevector <16 x i32> [[VEC1]], <16 x i32> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
; MINSPLIT-NEXT:    [[PICK1_3:%.*]] = shufflevector <16 x i32> [[VEC1]], <16 x i32> undef, <4 x i32> <i32 8, i32 9, i32 10, i32 11>
; MINSPLIT-NEXT:    [[PICK1_4:%.*]] = shufflevector <16 x i32> [[VEC1]], <16 x i32> undef, <4 x i32> <i32 12, i32 13, i32 14, i32 15>
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @trees_fail_2(
; SPLIT8-NEXT:    [[VEC1:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[PICK1_1:%.*]] = shufflevector <16 x i32> [[VEC1]], <16 x i32> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; SPLIT8-NEXT:    [[PICK1_2:%.*]] = shufflevector <16 x i32> [[VEC1]], <16 x i32> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
; SPLIT8-NEXT:    [[PICK1_3:%.*]] = shufflevector <16 x i32> [[VEC1]], <16 x i32> undef, <4 x i32> <i32 8, i32 9, i32 10, i32 11>
; SPLIT8-NEXT:    [[PICK1_4:%.*]] = shufflevector <16 x i32> [[VEC1]], <16 x i32> undef, <4 x i32> <i32 12, i32 13, i32 14, i32 15>
; SPLIT8-NEXT:    ret void
;
  %vec1 = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 %ptr, i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
  %pick1.1 = shufflevector <16 x i32> %vec1, <16 x i32> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %pick1.2 = shufflevector <16 x i32> %vec1, <16 x i32> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %pick1.3 = shufflevector <16 x i32> %vec1, <16 x i32> undef, <4 x i32> <i32 8, i32 9, i32 10, i32 11>
  %pick1.4 = shufflevector <16 x i32> %vec1, <16 x i32> undef, <4 x i32> <i32 12, i32 13, i32 14, i32 15>
  ret void
}
