PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE mailboxes (idx        INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT, mailbox    TEXT    NOT NULL CHECK (mailbox != '') UNIQUE, subscribed BOOLEAN NOT NULL);
INSERT INTO mailboxes VALUES(1,'a.b1.c2',0);
INSERT INTO mailboxes VALUES(2,'a.b1.c1',0);
INSERT INTO mailboxes VALUES(3,'INBOX',0);
INSERT INTO mailboxes VALUES(4,'a2',0);
INSERT INTO mailboxes VALUES(5,'a.b2.c',0);
CREATE TABLE local (idx           INTEGER         NOT NULL PRIMARY KEY REFERENCES mailboxes(idx), UIDVALIDITY   UNSIGNED INT    NOT NULL CHECK (UIDVALIDITY > 0), UIDNEXT       UNSIGNED INT    NOT NULL, HIGHESTMODSEQ UNSIGNED BIGINT NOT NULL);
CREATE TABLE remote (idx           INTEGER         NOT NULL PRIMARY KEY REFERENCES mailboxes(idx), UIDVALIDITY   UNSIGNED INT    NOT NULL CHECK (UIDVALIDITY > 0), UIDNEXT       UNSIGNED INT    NOT NULL, HIGHESTMODSEQ UNSIGNED BIGINT NOT NULL);
CREATE TABLE mapping (idx  INTEGER      NOT NULL REFERENCES mailboxes(idx), lUID UNSIGNED INT NOT NULL CHECK (lUID > 0), rUID UNSIGNED INT NOT NULL CHECK (rUID > 0), PRIMARY KEY (idx,lUID), UNIQUE      (idx,rUID));
DELETE FROM sqlite_sequence;
INSERT INTO sqlite_sequence VALUES('mailboxes',5);
COMMIT;
