#line 2 "lexer.cc"

#line 4 "lexer.cc"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

/* %not-for-header */

/* %if-c-only */
/* %if-not-reentrant */
#define yy_create_buffer eval_create_buffer
#define yy_delete_buffer eval_delete_buffer
#define yy_flex_debug eval_flex_debug
#define yy_init_buffer eval_init_buffer
#define yy_flush_buffer eval_flush_buffer
#define yy_load_buffer_state eval_load_buffer_state
#define yy_switch_to_buffer eval_switch_to_buffer
#define yyin evalin
#define yyleng evalleng
#define yylex evallex
#define yylineno evallineno
#define yyout evalout
#define yyrestart evalrestart
#define yytext evaltext
#define yywrap evalwrap
#define yyalloc evalalloc
#define yyrealloc evalrealloc
#define yyfree evalfree

/* %endif */
/* %endif */
/* %ok-for-header */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 35
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* %if-c++-only */
/* %endif */

/* %if-c-only */
    
/* %endif */

/* %if-c-only */

/* %endif */

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
/* %if-c-only */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
/* %endif */

/* %if-tables-serialization */
/* %endif */
/* end standard C headers. */

/* %if-c-or-c++ */
/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
typedef uint64_t flex_uint64_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

/* %endif */

/* %if-c++-only */
/* %endif */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* %not-for-header */

/* Returned upon end-of-file. */
#define YY_NULL 0
/* %ok-for-header */

/* %not-for-header */

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)
/* %ok-for-header */

/* %if-reentrant */
/* %endif */

/* %if-not-reentrant */

/* %endif */

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE evalrestart(evalin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

/* %if-not-reentrant */
extern yy_size_t evalleng;
/* %endif */

/* %if-c-only */
/* %if-not-reentrant */
extern FILE *evalin, *evalout;
/* %endif */
/* %endif */

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    /* Note: We specifically omit the test for yy_rule_can_match_eol because it requires
     *       access to the local variable yy_act. Since yyless() is a macro, it would break
     *       existing scanners that call yyless() from OUTSIDE evallex. 
     *       One obvious solution it to make yy_act a global. I tried that, and saw
     *       a 5% performance hit in a non-evallineno scanner, because yy_act is
     *       normally declared as a register variable-- so it is not worth it.
     */
    #define  YY_LESS_LINENO(n) \
            do { \
                yy_size_t yyl;\
                for ( yyl = n; yyl < evalleng; ++yyl )\
                    if ( evaltext[yyl] == '\n' )\
                        --evallineno;\
            }while(0)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up evaltext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up evaltext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
/* %if-c-only */
	FILE *yy_input_file;
/* %endif */

/* %if-c++-only */
/* %endif */

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	yy_size_t yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via evalrestart()), so that the user can continue scanning by
	 * just pointing evalin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* %if-c-only Standard (non-C++) definition */
/* %not-for-header */

/* %if-not-reentrant */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */
/* %endif */
/* %ok-for-header */

/* %endif */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* %if-c-only Standard (non-C++) definition */

/* %if-not-reentrant */
/* %not-for-header */

/* yy_hold_char holds the character lost when evaltext is formed. */
static char yy_hold_char;
static yy_size_t yy_n_chars;		/* number of characters read into yy_ch_buf */
yy_size_t evalleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow evalwrap()'s to do buffer switches
 * instead of setting up a fresh evalin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;
/* %ok-for-header */

/* %endif */

void evalrestart (FILE *input_file  );
void eval_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE eval_create_buffer (FILE *file,int size  );
void eval_delete_buffer (YY_BUFFER_STATE b  );
void eval_flush_buffer (YY_BUFFER_STATE b  );
void evalpush_buffer_state (YY_BUFFER_STATE new_buffer  );
void evalpop_buffer_state (void );

static void evalensure_buffer_stack (void );
static void eval_load_buffer_state (void );
static void eval_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER eval_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE eval_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE eval_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE eval_scan_bytes (yyconst char *bytes,yy_size_t len  );

/* %endif */

void *evalalloc (yy_size_t  );
void *evalrealloc (void *,yy_size_t  );
void evalfree (void *  );

#define yy_new_buffer eval_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        evalensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            eval_create_buffer(evalin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        evalensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            eval_create_buffer(evalin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* %% [1.0] evaltext/evalin/evalout/yy_state_type/evallineno etc. def's & init go here */
/* Begin user sect3 */

#define evalwrap(n) 1
#define YY_SKIP_YYWRAP

#define FLEX_DEBUG

typedef unsigned char YY_CHAR;

FILE *evalin = (FILE *) 0, *evalout = (FILE *) 0;

typedef int yy_state_type;

extern int evallineno;

int evallineno = 1;

extern char *evaltext;
#define yytext_ptr evaltext

/* %if-c-only Standard (non-C++) definition */

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yy_fatal_error (yyconst char msg[]  );

/* %endif */

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up evaltext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
/* %% [2.0] code to fiddle evaltext and evalleng for yymore() goes here \ */\
	evalleng = (yy_size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
/* %% [3.0] code to copy yytext_ptr to evaltext[] goes here, if %array \ */\
	(yy_c_buf_p) = yy_cp;

/* %% [4.0] data tables for the DFA and the user's section 1 definitions go here */
#define YY_NUM_RULES 54
#define YY_END_OF_BUFFER 55
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[213] =
    {   0,
        0,    0,   55,   53,    1,    2,   53,   47,   48,   52,
       51,   53,   46,    5,    5,   53,   53,   53,   53,   49,
       50,   53,   53,   53,   53,   53,   53,   53,   53,   53,
       53,   53,   53,   53,   53,   53,   53,   53,    1,    2,
        0,    3,    5,    0,    5,    0,    0,    0,    0,    7,
        8,    0,    0,    0,    0,    6,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,   44,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    4,    7,
       38,   43,    0,    0,    0,   20,    0,    0,    0,   15,

        0,    0,    0,    0,   21,    0,   23,    0,    0,   42,
        0,    0,   17,    0,    0,   19,    0,    0,    0,    0,
        0,    0,    0,    0,   35,    0,    0,    0,    0,   24,
        0,    0,    0,    0,    0,    0,    0,    0,   22,   30,
        0,    0,    0,   14,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   25,   18,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,   26,
       39,    0,   16,   27,    0,   40,    0,   45,    0,    9,
        0,   10,   11,   29,    0,    0,   33,   28,    7,    0,
        0,    0,   31,    0,    0,   32,    0,    0,    0,   13,

       12,    0,    0,    0,   41,   37,    0,   36,    0,    0,
       34,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    1,    1,    1,    1,    1,    4,    5,
        6,    7,    1,    8,    9,   10,    1,   11,   12,   12,
       12,   13,   12,   14,   12,   12,   12,   15,    1,    1,
       16,    1,    1,    1,   17,   17,   17,   17,   17,   17,
       18,   18,   18,   18,   18,   18,   18,   18,   18,   18,
       18,   18,   18,   18,   18,   18,   18,   19,   18,   18,
       20,    1,   21,    1,   22,    1,   23,   24,   25,   26,

       27,   28,   29,   30,   31,   18,   32,   33,   34,   35,
       36,   37,   18,   38,   39,   40,   41,   42,   18,   43,
       44,   18,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[45] =
    {   0,
        1,    1,    2,    1,    1,    1,    1,    1,    1,    3,
        4,    4,    4,    4,    5,    1,    4,    1,    1,    1,
        1,    1,    4,    4,    4,    4,    4,    4,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1
    } ;

static yyconst flex_int16_t yy_base[218] =
    {   0,
        0,    0,  325,  326,  322,  320,  318,  326,  326,  326,
      326,   34,  326,   39,   36,  306,  304,   81,  115,  326,
      326,   24,   37,   37,   26,  288,   45,  290,   43,   48,
      281,   43,   59,  289,  106,   50,  288,  283,  311,  309,
      307,  326,  122,  137,  112,  295,  294,    0,  293,    0,
      326,  143,  150,    0,    0,  326,  274,  280,  282,  269,
      263,  262,  261,  269,  276,  255,  270,  252,   74,  260,
      259,  268,  258,  262,  250,  249,    0,  261,  247,  253,
      262,  259,  259,  239,  258,  245,  256,  146,    0,    0,
        0,    0,  252,  252,  253,    0,  248,  235,  247,  233,

      236,  233,  244,  235,    0,  235,    0,  242,  225,    0,
      233,  225,  148,  239,  235,    0,  221,  219,  223,  231,
      230,  154,  229,  231,    0,  215,  212,  225,  210,    0,
      222,  221,  208,  223,  218,  200,  207,  219,    0,    0,
      197,  214,  199,    0,  199,  201,  210,  162,  197,  194,
      196,  193,  193,  192,    0,    0,  202,  202,  189,  189,
      190,  198,  156,  185,  184,  190,  172,  169,  166,    0,
        0,  168,    0,    0,  174,    0,  177,    0,  175,    0,
      175,    0,    0,    0,  169,  173,  189,    0,  170,  166,
      161,  157,    0,  156,  158,    0,  183,  153,  162,    0,

        0,  161,  156,  161,    0,    0,  164,    0,  124,  115,
        0,  326,  208,  210,  212,   85,  215
    } ;

static yyconst flex_int16_t yy_def[218] =
    {   0,
      212,    1,  212,  212,  212,  212,  213,  212,  212,  212,
      212,  212,  212,  212,   14,  214,  212,  212,   18,  212,
      212,   18,   18,   18,   18,   19,   19,   19,   19,   19,
       19,   19,   19,   19,   19,   19,   19,   19,  212,  212,
      213,  212,  212,  212,   14,  214,  215,  216,  214,  217,
      212,  212,   19,   18,   19,  212,   19,   19,   19,   19,
       18,   19,   19,   19,   19,   19,   19,   19,   19,   19,
       19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
       19,   19,   19,   19,   19,   19,   19,  212,  216,  217,
       19,   19,   19,   19,   19,   19,   19,   19,   19,   19,

       19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
       19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
       19,  212,   19,   19,   19,   19,   19,   19,   19,   19,
       19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
       19,   19,   19,   19,   19,   19,   19,  212,   19,   19,
       19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
       19,   19,   19,   19,   19,   19,   19,   19,  212,   19,
       19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
       19,   19,   19,   19,   19,   19,   19,   19,  212,   19,
       19,   19,   19,   19,   19,   19,   19,   19,   19,   19,

       19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
       19,    0,  212,  212,  212,  212,  212
    } ;

static yyconst flex_int16_t yy_nxt[371] =
    {   0,
        4,    5,    6,    7,    8,    9,   10,   11,   12,   13,
       14,   15,   15,   15,   16,   17,   18,   19,   19,   20,
       21,    4,   22,   18,   23,   24,   25,   18,   26,   27,
       28,   19,   29,   30,   31,   32,   33,   34,   35,   36,
       19,   37,   19,   38,   43,   43,   43,   43,   44,   45,
       45,   45,   45,   46,  212,   47,   57,   48,   58,   61,
       63,   47,   47,   47,   47,   47,   47,   59,   64,   70,
       72,   66,   60,   71,   73,   62,   84,   67,  212,   76,
       77,   48,   52,   52,   68,   78,   74,   85,   89,   53,
       79,   54,   54,   54,   54,   46,  103,   54,   55,   55,

      104,   56,   53,   54,   54,   54,   54,   54,   54,   55,
       55,   55,   55,   55,   55,   55,   55,   55,   55,   55,
       55,   55,   55,   55,   55,   55,   55,   55,   55,  212,
      212,   55,   43,   43,   43,   43,   81,   55,   55,   55,
       55,   55,   55,   82,   52,   52,   83,   88,   88,   88,
       88,  212,  212,  211,  212,  122,   88,   88,   88,   88,
      139,  140,  210,   56,  148,  148,  148,  148,  182,  183,
      212,  169,  148,  148,  148,  148,  189,  189,  189,  189,
      189,  189,  189,  189,  212,  212,  209,  208,  207,  206,
      205,  204,  202,  201,  200,  199,  198,  197,  196,  195,

      194,  193,  192,  212,  191,  190,  188,  203,   41,  187,
       41,   41,   41,   49,   49,   47,   47,   90,   90,   90,
      186,  185,  184,  181,  180,  179,  178,  177,  176,  175,
      174,  173,  172,  171,  170,  168,  167,  166,  165,  164,
      163,  162,  161,  160,  159,  158,  157,  156,  155,  154,
      153,  152,  151,  150,  149,  147,  146,  145,  144,  143,
      142,  141,  138,  137,  136,  135,  134,  133,  132,  131,
      130,  129,  128,  127,  126,  125,  124,  123,  121,  120,
      119,  118,  117,  116,  115,  114,  113,  112,  111,  110,
      109,  108,  107,  106,  105,  102,  101,  100,   99,   98,

       97,   96,   95,   94,   93,   92,   91,   50,   46,   50,
       42,   40,   39,   87,   86,   80,   75,   69,   65,   51,
       50,   42,   40,   39,  212,    3,  212,  212,  212,  212,
      212,  212,  212,  212,  212,  212,  212,  212,  212,  212,
      212,  212,  212,  212,  212,  212,  212,  212,  212,  212,
      212,  212,  212,  212,  212,  212,  212,  212,  212,  212,
      212,  212,  212,  212,  212,  212,  212,  212,  212,  212
    } ;

static yyconst flex_int16_t yy_chk[371] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,   12,   12,   12,   12,   14,   14,
       14,   14,   14,   14,   15,   14,   22,   14,   22,   24,
       25,   14,   14,   14,   14,   14,   14,   23,   25,   29,
       30,   27,   23,   29,   30,   24,   36,   27,   15,   32,
       32,   14,   18,   18,   27,   33,   30,   36,  216,   18,
       33,   18,   18,   18,   18,   18,   69,   18,   18,   18,

       69,   18,   18,   18,   18,   18,   18,   18,   18,   18,
       18,   18,   18,   18,   18,   18,   18,   18,   18,   18,
       18,   18,   18,   18,   18,   19,   19,   19,   19,   19,
       45,   19,   43,   43,   43,   43,   35,   19,   19,   19,
       19,   19,   19,   35,   52,   52,   35,   44,   44,   44,
       44,   53,   53,  210,   45,   88,   88,   88,   88,   88,
      113,  113,  209,   52,  122,  122,  122,  122,  163,  163,
       53,  148,  148,  148,  148,  148,  169,  169,  169,  169,
      189,  189,  189,  189,  197,  197,  207,  204,  203,  202,
      199,  198,  195,  194,  192,  191,  190,  187,  186,  185,

      181,  179,  177,  197,  175,  172,  168,  197,  213,  167,
      213,  213,  213,  214,  214,  215,  215,  217,  217,  217,
      166,  165,  164,  162,  161,  160,  159,  158,  157,  154,
      153,  152,  151,  150,  149,  147,  146,  145,  143,  142,
      141,  138,  137,  136,  135,  134,  133,  132,  131,  129,
      128,  127,  126,  124,  123,  121,  120,  119,  118,  117,
      115,  114,  112,  111,  109,  108,  106,  104,  103,  102,
      101,  100,   99,   98,   97,   95,   94,   93,   87,   86,
       85,   84,   83,   82,   81,   80,   79,   78,   76,   75,
       74,   73,   72,   71,   70,   68,   67,   66,   65,   64,

       63,   62,   61,   60,   59,   58,   57,   49,   47,   46,
       41,   40,   39,   38,   37,   34,   31,   28,   26,   17,
       16,    7,    6,    5,    3,  212,  212,  212,  212,  212,
      212,  212,  212,  212,  212,  212,  212,  212,  212,  212,
      212,  212,  212,  212,  212,  212,  212,  212,  212,  212,
      212,  212,  212,  212,  212,  212,  212,  212,  212,  212,
      212,  212,  212,  212,  212,  212,  212,  212,  212,  212
    } ;

/* Table of booleans, true if rule could match eol. */
static yyconst flex_int32_t yy_rule_can_match_eol[55] =
    {   0,
0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,     };

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int eval_flex_debug;
int eval_flex_debug = 1;

static yyconst flex_int16_t yy_rule_linenum[54] =
    {   0,
      105,  110,  116,  126,  132,  150,  174,  188,  189,  190,
      191,  192,  193,  194,  195,  196,  197,  198,  199,  200,
      201,  202,  203,  204,  205,  206,  207,  208,  209,  210,
      211,  212,  213,  214,  215,  216,  217,  218,  219,  220,
      221,  222,  223,  224,  225,  226,  227,  228,  229,  230,
      231,  232,  233
    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *evaltext;
#line 1 "lexer.ll"
/* Copyright (C) 2015-2019 Internet Systems Consortium, Inc. ("ISC")

   This Source Code Form is subject to the terms of the Mozilla Public
   License, v. 2.0. If a copy of the MPL was not distributed with this
   file, You can obtain one at http://mozilla.org/MPL/2.0/. */
#line 8 "lexer.ll"

/* Generated files do not make clang static analyser so happy */
#ifndef __clang_analyzer__

#include <cerrno>
#include <climits>
#include <cstdlib>
#include <string>
#include <eval/eval_context.h>
#include <eval/parser.h>
#include <asiolink/io_address.h>
#include <boost/lexical_cast.hpp>

/* Please avoid C++ style comments (// ... eol) as they break flex 2.6.2 */

/* Work around an incompatibility in flex (at least versions
   2.5.31 through 2.5.33): it generates code that does
   not conform to C89.  See Debian bug 333231
   <http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=333231>. */
# undef evalwrap
# define evalwrap() 1

/* The location of the current token. The lexer will keep updating it. This
   variable will be useful for logging errors. */
static isc::eval::location loc;

namespace {
    bool start_token_flag = false;
    isc::eval::EvalContext::ParserType start_token_value;
};

/* To avoid the call to exit... oops! */
#define YY_FATAL_ERROR(msg) isc::eval::EvalContext::fatal(msg)
/* noyywrap disables automatic rewinding for the next file to parse. Since we
   always parse only a single string, there's no need to do any wraps. And
   using evalwrap requires linking with -lfl, which provides the default evalwrap
   implementation that always returns 1 anyway. */
/* nounput simplifies the lexer, by removing support for putting a character
   back into the input stream. We never use such capability anyway. */
/* batch means that we'll never use the generated lexer interactively. */
/* Enables debug mode. To see the debug messages, one needs to also set
   eval_flex_debug to 1, then the debug messages will be printed on stderr. */
/* I have no idea what this option does, except it was specified in the bison
   examples and Postgres folks added it to remove gcc 4.3 warnings. Let's
   be on the safe side and keep it. */
#define YY_NO_INPUT 1
/* This line tells flex to track the line numbers. It's not really that
   useful for client classes, which typically are one-liners, but it may be
   useful in more complex cases. */
/* These are not token expressions yet, just convenience expressions that
   can be used during actual token definitions. Note some can match
   incorrect inputs (e.g., IP addresses) which must be checked. */
#line 80 "lexer.ll"
/* This code run each time a pattern is matched. It updates the location
   by moving it ahead by evalleng bytes. evalleng specifies the length of the
   currently matched token. */
#define YY_USER_ACTION  loc.columns(evalleng);
#line 799 "lexer.cc"

#define INITIAL 0

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
/* %if-c-only */
#include <unistd.h>
/* %endif */
/* %if-c++-only */
/* %endif */
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* %if-c-only Reentrant structure and macros (non-C++). */
/* %if-reentrant */
/* %if-c-only */

static int yy_init_globals (void );

/* %endif */
/* %if-reentrant */
/* %endif */
/* %endif End reentrant structures and macros. */

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int evallex_destroy (void );

int evalget_debug (void );

void evalset_debug (int debug_flag  );

YY_EXTRA_TYPE evalget_extra (void );

void evalset_extra (YY_EXTRA_TYPE user_defined  );

FILE *evalget_in (void );

void evalset_in  (FILE * in_str  );

FILE *evalget_out (void );

void evalset_out  (FILE * out_str  );

yy_size_t evalget_leng (void );

char *evalget_text (void );

int evalget_lineno (void );

void evalset_lineno (int line_number  );

/* %if-bison-bridge */
/* %endif */

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int evalwrap (void );
#else
extern int evalwrap (void );
#endif
#endif

/* %not-for-header */

/* %ok-for-header */

/* %endif */

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT
/* %if-c-only Standard (non-C++) definition */
/* %not-for-header */

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif
/* %ok-for-header */

/* %endif */
#endif

/* %if-c-only */

/* %endif */

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* %if-c-only Standard (non-C++) definition */
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO fwrite( evaltext, evalleng, 1, evalout )
/* %endif */
/* %if-c++-only C++ definition */
/* %endif */
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
/* %% [5.0] fread()/read() definition of YY_INPUT goes here unless we're doing C++ \ */\
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		yy_size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( evalin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( evalin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, evalin))==0 && ferror(evalin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(evalin); \
			} \
		}\
\
/* %if-c++-only C++ definition \ */\
/* %endif */

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
/* %if-c-only */
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
/* %endif */
/* %if-c++-only */
/* %endif */
#endif

/* %if-tables-serialization structures and prototypes */
/* %not-for-header */

/* %ok-for-header */

/* %not-for-header */

/* %tables-yydmap generated elements */
/* %endif */
/* end tables serialization structures and prototypes */

/* %ok-for-header */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1
/* %if-c-only Standard (non-C++) definition */

extern int evallex (void);

#define YY_DECL int evallex (void)
/* %endif */
/* %if-c++-only C++ definition */
/* %endif */
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after evaltext and evalleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

/* %% [6.0] YY_RULE_SETUP definition goes here */
#define YY_RULE_SETUP \
	YY_USER_ACTION

/* %not-for-header */

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    
/* %% [7.0] user's declarations go here */
#line 86 "lexer.ll"



    /* Code run each time evallex is called. */
    loc.step();

    if (start_token_flag) {
        start_token_flag = false;
        switch (start_token_value) {
        case EvalContext::PARSER_BOOL:
            return isc::eval::EvalParser::make_TOPLEVEL_BOOL(loc);
        default:
        case EvalContext::PARSER_STRING:
            return isc::eval::EvalParser::make_TOPLEVEL_STRING(loc);
        }
    }



#line 1059 "lexer.cc"

	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! evalin )
/* %if-c-only */
			evalin = stdin;
/* %endif */
/* %if-c++-only */
/* %endif */

		if ( ! evalout )
/* %if-c-only */
			evalout = stdout;
/* %endif */
/* %if-c++-only */
/* %endif */

		if ( ! YY_CURRENT_BUFFER ) {
			evalensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				eval_create_buffer(evalin,YY_BUF_SIZE );
		}

		eval_load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
/* %% [8.0] yymore()-related code goes here */
		yy_cp = (yy_c_buf_p);

		/* Support of evaltext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

/* %% [9.0] code to set up and find next match goes here */
		yy_current_state = (yy_start);
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 213 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 212 );
		yy_cp = (yy_last_accepting_cpos);
		yy_current_state = (yy_last_accepting_state);

yy_find_action:
/* %% [10.0] code to find the action number goes here */
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

/* %% [11.0] code for evallineno update goes here */

		if ( yy_act != YY_END_OF_BUFFER && yy_rule_can_match_eol[yy_act] )
			{
			yy_size_t yyl;
			for ( yyl = 0; yyl < evalleng; ++yyl )
				if ( evaltext[yyl] == '\n' )
					   
    evallineno++;
;
			}

do_action:	/* This label is used only to access EOF actions. */

/* %% [12.0] debug code goes here */
		if ( eval_flex_debug )
			{
			if ( yy_act == 0 )
				fprintf( stderr, "--scanner backing up\n" );
			else if ( yy_act < 54 )
				fprintf( stderr, "--accepting rule at line %ld (\"%s\")\n",
				         (long)yy_rule_linenum[yy_act], evaltext );
			else if ( yy_act == 54 )
				fprintf( stderr, "--accepting default rule (\"%s\")\n",
				         evaltext );
			else if ( yy_act == 55 )
				fprintf( stderr, "--(end of buffer or a NUL)\n" );
			else
				fprintf( stderr, "--EOF (start condition %d)\n", YY_START );
			}

		switch ( yy_act )
	{ /* beginning of action switch */
/* %% [13.0] actions go here */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 105 "lexer.ll"
{
    /* Ok, we found a with space. Let's ignore it and update loc variable. */
    loc.step();
}
	YY_BREAK
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 110 "lexer.ll"
{
    /* Newline found. Let's update the location and continue. */
    loc.lines(evalleng);
    loc.step();
}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 116 "lexer.ll"
{
    /* A string has been matched. It contains the actual string and single quotes.
       We need to get those quotes out of the way and just use its content, e.g.
       for 'foo' we should get foo */
    std::string tmp(evaltext+1);
    tmp.resize(tmp.size() - 1);

    return isc::eval::EvalParser::make_STRING(tmp, loc);
}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 126 "lexer.ll"
{
    /* A hex string has been matched. It contains the '0x' or '0X' header
       followed by at least one hexadecimal digit. */
    return isc::eval::EvalParser::make_HEXSTRING(evaltext, loc);
}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 132 "lexer.ll"
{
    /* An integer was found. */
    std::string tmp(evaltext);

    try {
        /* In substring we want to use negative values (e.g. -1).
           In enterprise-id we need to use values up to 0xffffffff.
           To cover both of those use cases, we need at least
           int64_t. */
        static_cast<void>(boost::lexical_cast<int64_t>(tmp));
    } catch (const boost::bad_lexical_cast &) {
        driver.error(loc, "Failed to convert " + tmp + " to an integer.");
    }

    /* The parser needs the string form as double conversion is no lossless */
    return isc::eval::EvalParser::make_INTEGER(tmp, loc);
}
	YY_BREAK
case 6:
/* rule 6 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up evaltext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up evaltext again */
YY_RULE_SETUP
#line 150 "lexer.ll"
{
    /* This string specifies option name starting with a letter
       and further containing letters, digits, hyphens and
       underscores and finishing by letters or digits. */
    /* Moved from a variable trailing context to C++ code as it was too slow */
    std::string tmp(evaltext);
    /* remove possible trailing blanks or newlines */
    while (tmp.size() > 1) {
        char last = tmp[tmp.size() - 1];
        if ((last != ' ') && (last != '\t') && (last != '\n')) {
            break;
        }
        if (last == '\n') {
            /* Take embedded newlines into account */
            /* Can make it more complex to handle spaces after the last
               newline but currently keep it simple... */
            loc.lines();
            loc.step();
        }
        tmp.resize(tmp.size() - 1);
    }
    return isc::eval::EvalParser::make_OPTION_NAME(tmp, loc);
}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 174 "lexer.ll"
{
    /* IPv4 or IPv6 address */
    std::string tmp(evaltext);

    /* Some incorrect addresses can match so we have to check. */
    try {
        isc::asiolink::IOAddress ip(tmp);
    } catch (...) {
        driver.error(loc, "Failed to convert " + tmp + " to an IP address.");
    }

    return isc::eval::EvalParser::make_IP_ADDRESS(evaltext, loc);
}
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 188 "lexer.ll"
return isc::eval::EvalParser::make_EQUAL(loc);
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 189 "lexer.ll"
return isc::eval::EvalParser::make_OPTION(loc);
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 190 "lexer.ll"
return isc::eval::EvalParser::make_RELAY4(loc);
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 191 "lexer.ll"
return isc::eval::EvalParser::make_RELAY6(loc);
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 192 "lexer.ll"
return isc::eval::EvalParser::make_PEERADDR(loc);
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 193 "lexer.ll"
return isc::eval::EvalParser::make_LINKADDR(loc);
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 194 "lexer.ll"
return isc::eval::EvalParser::make_TEXT(loc);
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 195 "lexer.ll"
return isc::eval::EvalParser::make_HEX(loc);
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 196 "lexer.ll"
return isc::eval::EvalParser::make_EXISTS(loc);
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 197 "lexer.ll"
return isc::eval::EvalParser::make_PKT(loc);
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 198 "lexer.ll"
return isc::eval::EvalParser::make_IFACE(loc);
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 199 "lexer.ll"
return isc::eval::EvalParser::make_SRC(loc);
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 200 "lexer.ll"
return isc::eval::EvalParser::make_DST(loc);
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 201 "lexer.ll"
return isc::eval::EvalParser::make_LEN(loc);
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 202 "lexer.ll"
return isc::eval::EvalParser::make_PKT4(loc);
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 203 "lexer.ll"
return isc::eval::EvalParser::make_CHADDR(loc);
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 204 "lexer.ll"
return isc::eval::EvalParser::make_HLEN(loc);
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 205 "lexer.ll"
return isc::eval::EvalParser::make_HTYPE(loc);
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 206 "lexer.ll"
return isc::eval::EvalParser::make_CIADDR(loc);
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 207 "lexer.ll"
return isc::eval::EvalParser::make_GIADDR(loc);
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 208 "lexer.ll"
return isc::eval::EvalParser::make_YIADDR(loc);
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 209 "lexer.ll"
return isc::eval::EvalParser::make_SIADDR(loc);
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 210 "lexer.ll"
return isc::eval::EvalParser::make_PKT6(loc);
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 211 "lexer.ll"
return isc::eval::EvalParser::make_MSGTYPE(loc);
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 212 "lexer.ll"
return isc::eval::EvalParser::make_TRANSID(loc);
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 213 "lexer.ll"
return isc::eval::EvalParser::make_VENDOR(loc);
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 214 "lexer.ll"
return isc::eval::EvalParser::make_VENDOR_CLASS(loc);
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 215 "lexer.ll"
return isc::eval::EvalParser::make_DATA(loc);
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 216 "lexer.ll"
return isc::eval::EvalParser::make_ENTERPRISE(loc);
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 217 "lexer.ll"
return isc::eval::EvalParser::make_SUBSTRING(loc);
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 218 "lexer.ll"
return isc::eval::EvalParser::make_ALL(loc);
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 219 "lexer.ll"
return isc::eval::EvalParser::make_CONCAT(loc);
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 220 "lexer.ll"
return isc::eval::EvalParser::make_IFELSE(loc);
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 221 "lexer.ll"
return isc::eval::EvalParser::make_TOHEXSTRING(loc);
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 222 "lexer.ll"
return isc::eval::EvalParser::make_NOT(loc);
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 223 "lexer.ll"
return isc::eval::EvalParser::make_AND(loc);
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 224 "lexer.ll"
return isc::eval::EvalParser::make_OR(loc);
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 225 "lexer.ll"
return isc::eval::EvalParser::make_MEMBER(loc);
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 226 "lexer.ll"
return isc::eval::EvalParser::make_DOT(loc);
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 227 "lexer.ll"
return isc::eval::EvalParser::make_LPAREN(loc);
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 228 "lexer.ll"
return isc::eval::EvalParser::make_RPAREN(loc);
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 229 "lexer.ll"
return isc::eval::EvalParser::make_LBRACKET(loc);
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 230 "lexer.ll"
return isc::eval::EvalParser::make_RBRACKET(loc);
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 231 "lexer.ll"
return isc::eval::EvalParser::make_COMA(loc);
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 232 "lexer.ll"
return isc::eval::EvalParser::make_ANY(loc);
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 233 "lexer.ll"
driver.error (loc, "Invalid character: " + std::string(evaltext));
	YY_BREAK
case YY_STATE_EOF(INITIAL):
#line 234 "lexer.ll"
return isc::eval::EvalParser::make_END(loc);
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 235 "lexer.ll"
ECHO;
	YY_BREAK
#line 1527 "lexer.cc"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed evalin at a new source and called
			 * evallex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = evalin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
/* %% [14.0] code to do back-up for compressed tables and set up yy_cp goes here */
				yy_cp = (yy_last_accepting_cpos);
				yy_current_state = (yy_last_accepting_state);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( evalwrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * evaltext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of evallex */
/* %ok-for-header */

/* %if-c++-only */
/* %not-for-header */

/* %ok-for-header */

/* %endif */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
/* %if-c-only */
static int yy_get_next_buffer (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			yy_size_t num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				yy_size_t new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					evalrealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			evalrestart(evalin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) ((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) evalrealloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

/* %if-c-only */
/* %not-for-header */

    static yy_state_type yy_get_previous_state (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    
/* %% [15.0] code to get the start state into yy_current_state goes here */
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
/* %% [16.0] code to find the next state goes here */
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 213 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
/* %if-c-only */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
/* %endif */
/* %if-c++-only */
/* %endif */
{
	register int yy_is_jam;
    /* %% [17.0] code to find the next state, and perhaps do backing up, goes here */
	register char *yy_cp = (yy_c_buf_p);

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 213 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 212);

	return yy_is_jam ? 0 : yy_current_state;
}

/* %if-c-only */

/* %endif */

/* %if-c-only */
#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

/* %endif */
/* %if-c++-only */
/* %endif */
{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			yy_size_t offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					evalrestart(evalin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( evalwrap( ) )
						return 0;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve evaltext */
	(yy_hold_char) = *++(yy_c_buf_p);

/* %% [19.0] update BOL and evallineno */
	if ( c == '\n' )
		   
    evallineno++;
;

	return c;
}
/* %if-c-only */
#endif	/* ifndef YY_NO_INPUT */
/* %endif */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
/* %if-c-only */
    void evalrestart  (FILE * input_file )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    
	if ( ! YY_CURRENT_BUFFER ){
        evalensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            eval_create_buffer(evalin,YY_BUF_SIZE );
	}

	eval_init_buffer(YY_CURRENT_BUFFER,input_file );
	eval_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
/* %if-c-only */
    void eval_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		evalpop_buffer_state();
	 *		evalpush_buffer_state(new_buffer);
     */
	evalensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	eval_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (evalwrap()) processing, but the only time this flag
	 * is looked at is after evalwrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

/* %if-c-only */
static void eval_load_buffer_state  (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	evalin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
/* %if-c-only */
    YY_BUFFER_STATE eval_create_buffer  (FILE * file, int  size )
/* %endif */
/* %if-c++-only */
/* %endif */
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) evalalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in eval_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) evalalloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in eval_create_buffer()" );

	b->yy_is_our_buffer = 1;

	eval_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with eval_create_buffer()
 * 
 */
/* %if-c-only */
    void eval_delete_buffer (YY_BUFFER_STATE  b )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		evalfree((void *) b->yy_ch_buf  );

	evalfree((void *) b  );
}

/* %if-c-only */

#ifndef __cplusplus
extern int isatty (int );
#endif /* __cplusplus */
    
/* %endif */

/* %if-c++-only */
/* %endif */

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a evalrestart() or at EOF.
 */
/* %if-c-only */
    static void eval_init_buffer  (YY_BUFFER_STATE  b, FILE * file )
/* %endif */
/* %if-c++-only */
/* %endif */

{
	int oerrno = errno;
    
	eval_flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then eval_init_buffer was _probably_
     * called from evalrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

/* %if-c-only */

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
/* %endif */
/* %if-c++-only */
/* %endif */
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
/* %if-c-only */
    void eval_flush_buffer (YY_BUFFER_STATE  b )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		eval_load_buffer_state( );
}

/* %if-c-or-c++ */
/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
/* %if-c-only */
void evalpush_buffer_state (YY_BUFFER_STATE new_buffer )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	if (new_buffer == NULL)
		return;

	evalensure_buffer_stack();

	/* This block is copied from eval_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from eval_switch_to_buffer. */
	eval_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}
/* %endif */

/* %if-c-or-c++ */
/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
/* %if-c-only */
void evalpop_buffer_state (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	if (!YY_CURRENT_BUFFER)
		return;

	eval_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		eval_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}
/* %endif */

/* %if-c-or-c++ */
/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
/* %if-c-only */
static void evalensure_buffer_stack (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)evalalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in evalensure_buffer_stack()" );
								  
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)evalrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in evalensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}
/* %endif */

/* %if-c-only */
/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE eval_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) evalalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in eval_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	eval_switch_to_buffer(b  );

	return b;
}
/* %endif */

/* %if-c-only */
/** Setup the input buffer state to scan a string. The next call to evallex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       eval_scan_bytes() instead.
 */
YY_BUFFER_STATE eval_scan_string (yyconst char * yystr )
{
    
	return eval_scan_bytes(yystr,strlen(yystr) );
}
/* %endif */

/* %if-c-only */
/** Setup the input buffer state to scan the given bytes. The next call to evallex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE eval_scan_bytes  (yyconst char * yybytes, yy_size_t  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n, i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) evalalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in eval_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = eval_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in eval_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}
/* %endif */

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

/* %if-c-only */
static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}
/* %endif */
/* %if-c++-only */
/* %endif */

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up evaltext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		evaltext[evalleng] = (yy_hold_char); \
		(yy_c_buf_p) = evaltext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		evalleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/* %if-c-only */
/* %if-reentrant */
/* %endif */

/** Get the current line number.
 * 
 */
int evalget_lineno  (void)
{
        
    return evallineno;
}

/** Get the input stream.
 * 
 */
FILE *evalget_in  (void)
{
        return evalin;
}

/** Get the output stream.
 * 
 */
FILE *evalget_out  (void)
{
        return evalout;
}

/** Get the length of the current token.
 * 
 */
yy_size_t evalget_leng  (void)
{
        return evalleng;
}

/** Get the current token.
 * 
 */

char *evalget_text  (void)
{
        return evaltext;
}

/* %if-reentrant */
/* %endif */

/** Set the current line number.
 * @param line_number
 * 
 */
void evalset_lineno (int  line_number )
{
    
    evallineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see eval_switch_to_buffer
 */
void evalset_in (FILE *  in_str )
{
        evalin = in_str ;
}

void evalset_out (FILE *  out_str )
{
        evalout = out_str ;
}

int evalget_debug  (void)
{
        return eval_flex_debug;
}

void evalset_debug (int  bdebug )
{
        eval_flex_debug = bdebug ;
}

/* %endif */

/* %if-reentrant */
/* %if-bison-bridge */
/* %endif */
/* %endif if-c-only */

/* %if-c-only */
static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from evallex_destroy(), so don't allocate here.
     */

    /* We do not touch evallineno unless the option is enabled. */
    evallineno =  1;
    
    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    evalin = stdin;
    evalout = stdout;
#else
    evalin = (FILE *) 0;
    evalout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * evallex_init()
     */
    return 0;
}
/* %endif */

/* %if-c-only SNIP! this currently causes conflicts with the c++ scanner */
/* evallex_destroy is for both reentrant and non-reentrant scanners. */
int evallex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		eval_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		evalpop_buffer_state();
	}

	/* Destroy the stack itself. */
	evalfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * evallex() is called, initialization will occur. */
    yy_init_globals( );

/* %if-reentrant */
/* %endif */
    return 0;
}
/* %endif */

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *evalalloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *evalrealloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void evalfree (void * ptr )
{
	free( (char *) ptr );	/* see evalrealloc() for (char *) cast */
}

/* %if-tables-serialization definitions */
/* %define-yytables   The name for this specific scanner's tables. */
#define YYTABLES_NAME "yytables"
/* %endif */

/* %ok-for-header */

#line 235 "lexer.ll"



using namespace isc::eval;

void
EvalContext::scanStringBegin(ParserType type)
{
    start_token_flag = true;
    start_token_value = type;

    loc.initialize(&file_);
    eval_flex_debug = trace_scanning_;
    YY_BUFFER_STATE buffer;
    buffer = eval_scan_bytes(string_.c_str(), string_.size());
    if (!buffer) {
        fatal("cannot scan string");
        /* fatal() throws an exception so this can't be reached */
    }
}

void
EvalContext::scanStringEnd()
{
    eval_delete_buffer(YY_CURRENT_BUFFER);
}

namespace {
/** To avoid unused function error */
class Dummy {
    /* cppcheck-suppress unusedPrivateFunction */
    void dummy() { yy_fatal_error("Fix me: how to disable its definition?"); }
};
}
#endif /* !__clang_analyzer__ */

