/*
 * DockableWindowContainer.java - holds dockable windows
 * Copyright (C) 2000 Slava Pestov
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package org.gjt.sp.jedit.gui;

/** A container for dockable windows.
 *
 * This class should never be used directly, and is not public.
 * @author Slava Pestov
 * @version $Id: DockableWindowContainer.java 23664 2014-08-22 05:11:25Z ezust $
 * @since jEdit 2.6pre3
 */
public interface DockableWindowContainer
{
	void register(DockableWindowManagerImpl.Entry entry);
	void remove(DockableWindowManagerImpl.Entry entry);
	void unregister(DockableWindowManagerImpl.Entry entry);
	void show(DockableWindowManagerImpl.Entry entry);
	boolean isVisible(DockableWindowManagerImpl.Entry entry);
}
