/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlUtil {
    private static final String FIELD_DELIMITER_STRING = "||";
    private static final Pattern FIELD_DELIMITER_PATTERN = Pattern.compile("\\|\\|");

    public static String encode(String fragment) {
        if (fragment == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(fragment.length() + 10);
        char[] characters = fragment.toCharArray();
        block6: for (int i = 0; i < characters.length; ++i) {
            switch (characters[i]) {
                case '<': {
                    builder.append("&lt;");
                    continue block6;
                }
                case '>': {
                    builder.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    builder.append("&quot;");
                    continue block6;
                }
                case '&': {
                    builder.append("&amp;");
                    continue block6;
                }
                default: {
                    builder.append(characters[i]);
                }
            }
        }
        return builder.toString();
    }

    public static String combineValues(Collection<String> values) {
        if (values == null || values.size() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(values.size() * 30);
        for (String value : values) {
            builder.append(value).append(FIELD_DELIMITER_STRING);
        }
        return HtmlUtil.encode(builder.toString());
    }

    public static Collection<String> splitValues(String value) {
        if (value == null || value.length() == 0) {
            return Collections.emptyList();
        }
        String[] splits = FIELD_DELIMITER_PATTERN.split(value);
        return Arrays.asList(splits);
    }
}

