/***************************************************************************
 *   Copyright (C) 2008-2011 by Marcel Hasler                              *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This file is part of KOSD.                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#include "kosd.h"

#include <QtDBus>

void KOsd::showBattery(unsigned char percent, bool plugged)
{
    QDBusMessage m = QDBusMessage::createMethodCall("org.kde.kded", "/modules/kosd", "org.kde.kosd", "showBattery");
    m << static_cast<int>(percent) << plugged;
    QDBusConnection::sessionBus().call(m);
}


void KOsd::showBrightness(unsigned char percent)
{
    QDBusMessage m = QDBusMessage::createMethodCall("org.kde.kded", "/modules/kosd", "org.kde.kosd", "showBrightness");
    m << static_cast<int>(percent);
    QDBusConnection::sessionBus().call(m);
}


void KOsd::showVolume(unsigned char percent, bool muted)
{
    QDBusMessage m = QDBusMessage::createMethodCall("org.kde.kded", "/modules/kosd", "org.kde.kosd", "showVolume");
    m << static_cast<int>(percent) << muted;
    QDBusConnection::sessionBus().call(m);
}


void KOsd::showCustom(const QString &svg, const QStringList &elements, const QString &text, unsigned char percent)
{
    QDBusMessage m = QDBusMessage::createMethodCall("org.kde.kded", "/modules/kosd", "org.kde.kosd", "showCustomSvg");
    m << svg << elements << text << static_cast<int>(percent);
    QDBusConnection::sessionBus().call(m);
}


void KOsd::showCustom(const QString &pixmap, const QString &text, unsigned char percent)
{
    QDBusMessage m = QDBusMessage::createMethodCall("org.kde.kded", "/modules/kosd", "org.kde.kosd", "showCustomPixmap");
    m << pixmap << text << static_cast<int>(percent);
    QDBusConnection::sessionBus().call(m);
}


void KOsd::parseConfiguration()
{
    QDBusMessage m = QDBusMessage::createMethodCall("org.kde.kded", "/modules/kosd", "org.kde.kosd", "parseConfiguration");
    QDBusConnection::sessionBus().call(m);
}
    