/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@RunWith(JUnit3RunnerWithInners.class)
public class KotlinEvaluateExpressionTestGenerated extends AbstractKotlinEvaluateExpressionTest {
    @TestMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SingleBreakpoint extends AbstractKotlinEvaluateExpressionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doSingleBreakpointTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("abstractFunCall.kt")
        public void testAbstractFunCall() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/abstractFunCall.kt");
        }

        @TestMetadata("accessToOverridenPropertyWithBackingField.kt")
        public void testAccessToOverridenPropertyWithBackingField() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/accessToOverridenPropertyWithBackingField.kt");
        }

        public void testAllFilesPresentInSingleBreakpoint() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("annotationValue.kt")
        public void testAnnotationValue() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/annotationValue.kt");
        }

        @TestMetadata("anonymousObjects.kt")
        public void testAnonymousObjects() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/anonymousObjects.kt");
        }

        @TestMetadata("arrays.kt")
        public void testArrays() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/arrays.kt");
        }

        @TestMetadata("boxParam.kt")
        public void testBoxParam() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/boxParam.kt");
        }

        @TestMetadata("boxReturnValue.kt")
        public void testBoxReturnValue() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/boxReturnValue.kt");
        }

        @TestMetadata("breakpointInInlineFun.kt")
        public void testBreakpointInInlineFun() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/breakpointInInlineFun.kt");
        }

        @TestMetadata("callableBug.kt")
        public void testCallableBug() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/callableBug.kt");
        }

        @TestMetadata("classFromAnotherPackage.kt")
        public void testClassFromAnotherPackage() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/classFromAnotherPackage.kt");
        }

        @TestMetadata("classObjectVal.kt")
        public void testClassObjectVal() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/classObjectVal.kt");
        }

        @TestMetadata("collections.kt")
        public void testCollections() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/collections.kt");
        }

        @TestMetadata("dataClassCopy.kt")
        public void testDataClassCopy() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/dataClassCopy.kt");
        }

        @TestMetadata("defaultParameterValues.kt")
        public void testDefaultParameterValues() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/defaultParameterValues.kt");
        }

        @TestMetadata("defaultParameterValues2.kt")
        public void testDefaultParameterValues2() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/defaultParameterValues2.kt");
        }

        @TestMetadata("delegatedPropertyInOtherFile.kt")
        public void testDelegatedPropertyInOtherFile() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/delegatedPropertyInOtherFile.kt");
        }

        @TestMetadata("delegatedVariables.kt")
        public void testDelegatedVariables() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/delegatedVariables.kt");
        }

        @TestMetadata("dependentOnFile.kt")
        public void testDependentOnFile() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/dependentOnFile.kt");
        }

        @TestMetadata("doubles.kt")
        public void testDoubles() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/doubles.kt");
        }

        @TestMetadata("enums.kt")
        public void testEnums() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/enums.kt");
        }

        @TestMetadata("errors.kt")
        public void testErrors() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/errors.kt");
        }

        @TestMetadata("escapedNames.kt")
        public void testEscapedNames() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/escapedNames.kt");
        }

        @TestMetadata("extractLocalVariables.kt")
        public void testExtractLocalVariables() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extractLocalVariables.kt");
        }

        @TestMetadata("extractThis.kt")
        public void testExtractThis() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extractThis.kt");
        }

        @TestMetadata("extractThisInTrait.kt")
        public void testExtractThisInTrait() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extractThisInTrait.kt");
        }

        @TestMetadata("extractVariablesFromCall.kt")
        public void testExtractVariablesFromCall() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extractVariablesFromCall.kt");
        }

        @TestMetadata("fieldGetters.kt")
        public void testFieldGetters() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/fieldGetters.kt");
        }

        @TestMetadata("fileWithError.kt")
        public void testFileWithError() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/fileWithError.kt");
        }

        @TestMetadata("funFromSuperClass.kt")
        public void testFunFromSuperClass() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/funFromSuperClass.kt");
        }

        @TestMetadata("genericCrossinlineArgument.kt")
        public void testGenericCrossinlineArgument() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/genericCrossinlineArgument.kt");
        }

        @TestMetadata("imports.kt")
        public void testImports() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/imports.kt");
        }

        @TestMetadata("importsLambdaContext.kt")
        public void testImportsLambdaContext() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/importsLambdaContext.kt");
        }

        @TestMetadata("inlineFunInMultiFilePackage.kt")
        public void testInlineFunInMultiFilePackage() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/inlineFunInMultiFilePackage.kt");
        }

        @TestMetadata("inlineFunction.kt")
        public void testInlineFunction() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/inlineFunction.kt");
        }

        @TestMetadata("inlineFunctionBreakpointAnotherFile.kt")
        public void testInlineFunctionBreakpointAnotherFile() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/inlineFunctionBreakpointAnotherFile.kt");
        }

        @TestMetadata("inlineFunctionBreakpointVariants.kt")
        public void testInlineFunctionBreakpointVariants() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/inlineFunctionBreakpointVariants.kt");
        }

        @TestMetadata("inlineMethodsInSignature.kt")
        public void testInlineMethodsInSignature() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/inlineMethodsInSignature.kt");
        }

        @TestMetadata("innerClass.kt")
        public void testInnerClass() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/innerClass.kt");
        }

        @TestMetadata("insertInBlock.kt")
        public void testInsertInBlock() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/insertInBlock.kt");
        }

        @TestMetadata("internalFunctionEvaluate.kt")
        public void testInternalFunctionEvaluate() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/internalFunctionEvaluate.kt");
        }

        @TestMetadata("internalProperty.kt")
        public void testInternalProperty() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/internalProperty.kt");
        }

        @TestMetadata("javaStaticMethods.kt")
        public void testJavaStaticMethods() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/javaStaticMethods.kt");
        }

        @TestMetadata("kt12206BasePropertyWithoutBackingField.kt")
        public void testKt12206BasePropertyWithoutBackingField() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/kt12206BasePropertyWithoutBackingField.kt");
        }

        @TestMetadata("kt17514.kt")
        public void testKt17514() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/kt17514.kt");
        }

        @TestMetadata("kt22366.kt")
        public void testKt22366() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/kt22366.kt");
        }

        @TestMetadata("kt25220.kt")
        public void testKt25220() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/kt25220.kt");
        }

        @TestMetadata("kt25222.kt")
        public void testKt25222() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/kt25222.kt");
        }

        @TestMetadata("kt28087.kt")
        public void testKt28087() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/kt28087.kt");
        }

        @TestMetadata("kt29179.kt")
        public void testKt29179() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/kt29179.kt");
        }

        @TestMetadata("kt5554OnlyIntsShouldBeCoerced.kt")
        public void testKt5554OnlyIntsShouldBeCoerced() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/kt5554OnlyIntsShouldBeCoerced.kt");
        }

        @TestMetadata("kt7046localVarInInline.kt")
        public void testKt7046localVarInInline() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/kt7046localVarInInline.kt");
        }

        @TestMetadata("localClass.kt")
        public void testLocalClass() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/localClass.kt");
        }

        @TestMetadata("localVariables.kt")
        public void testLocalVariables() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/localVariables.kt");
        }

        @TestMetadata("methodWithBreakpoint.kt")
        public void testMethodWithBreakpoint() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/methodWithBreakpoint.kt");
        }

        @TestMetadata("multilineExpressionAtBreakpoint.kt")
        public void testMultilineExpressionAtBreakpoint() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/multilineExpressionAtBreakpoint.kt");
        }

        @TestMetadata("nestedInlineArguments.kt")
        public void testNestedInlineArguments() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/nestedInlineArguments.kt");
        }

        @TestMetadata("onClassHeader.kt")
        public void testOnClassHeader() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/onClassHeader.kt");
        }

        @TestMetadata("onGetter.kt")
        public void testOnGetter() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/onGetter.kt");
        }

        @TestMetadata("onObjectHeader.kt")
        public void testOnObjectHeader() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/onObjectHeader.kt");
        }

        @TestMetadata("package.kt")
        public void testPackage() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/package.kt");
        }

        @TestMetadata("parametersOfInlineFun.kt")
        public void testParametersOfInlineFun() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/parametersOfInlineFun.kt");
        }

        @TestMetadata("parametersOfInlineFunSeveralOnLine.kt")
        public void testParametersOfInlineFunSeveralOnLine() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/parametersOfInlineFunSeveralOnLine.kt");
        }

        @TestMetadata("privateClass.kt")
        public void testPrivateClass() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/privateClass.kt");
        }

        @TestMetadata("privateFieldInCompanion.kt")
        public void testPrivateFieldInCompanion() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/privateFieldInCompanion.kt");
        }

        @TestMetadata("privateMember.kt")
        public void testPrivateMember() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/privateMember.kt");
        }

        @TestMetadata("privatePropertyWithExplicitDefaultGetter.kt")
        public void testPrivatePropertyWithExplicitDefaultGetter() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/privatePropertyWithExplicitDefaultGetter.kt");
        }

        @TestMetadata("protectedMember.kt")
        public void testProtectedMember() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/protectedMember.kt");
        }

        @TestMetadata("rawTypeskt11831.kt")
        public void testRawTypeskt11831() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/rawTypeskt11831.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/simple.kt");
        }

        @TestMetadata("staticField.kt")
        public void testStaticField() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/staticField.kt");
        }

        @TestMetadata("stdlib.kt")
        public void testStdlib() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/stdlib.kt");
        }

        @TestMetadata("typeParameterRef.kt")
        public void testTypeParameterRef() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/typeParameterRef.kt");
        }

        @TestMetadata("unboxParam.kt")
        public void testUnboxParam() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/unboxParam.kt");
        }

        @TestMetadata("unsafeCall.kt")
        public void testUnsafeCall() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/unsafeCall.kt");
        }

        @TestMetadata("vars.kt")
        public void testVars() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/vars.kt");
        }

        @TestMetadata("whenEvaluation.kt")
        public void testWhenEvaluation() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/whenEvaluation.kt");
        }

        @TestMetadata(".kt.kt")
        public void test_kt() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/.kt.kt");
        }

        @TestMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/compilingEvaluator")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CompilingEvaluator extends AbstractKotlinEvaluateExpressionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doSingleBreakpointTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCompilingEvaluator() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/compilingEvaluator"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ceAnonymousObject.kt")
            public void testCeAnonymousObject() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/compilingEvaluator/ceAnonymousObject.kt");
            }

            @TestMetadata("ceAnonymousObjectCapturedInClosure.kt")
            public void testCeAnonymousObjectCapturedInClosure() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/compilingEvaluator/ceAnonymousObjectCapturedInClosure.kt");
            }

            @TestMetadata("ceAnonymousObjectThisAsReceiver.kt")
            public void testCeAnonymousObjectThisAsReceiver() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/compilingEvaluator/ceAnonymousObjectThisAsReceiver.kt");
            }

            @TestMetadata("ceLambda.kt")
            public void testCeLambda() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/compilingEvaluator/ceLambda.kt");
            }

            @TestMetadata("ceLocalClass.kt")
            public void testCeLocalClass() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/compilingEvaluator/ceLocalClass.kt");
            }

            @TestMetadata("ceLocalClassMembers.kt")
            public void testCeLocalClassMembers() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/compilingEvaluator/ceLocalClassMembers.kt");
            }

            @TestMetadata("ceLocalClassWithSuperClass.kt")
            public void testCeLocalClassWithSuperClass() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/compilingEvaluator/ceLocalClassWithSuperClass.kt");
            }

            @TestMetadata("ceMembers.kt")
            public void testCeMembers() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/compilingEvaluator/ceMembers.kt");
            }

            @TestMetadata("ceObject.kt")
            public void testCeObject() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/compilingEvaluator/ceObject.kt");
            }

            @TestMetadata("ceSeveralLambdas.kt")
            public void testCeSeveralLambdas() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/compilingEvaluator/ceSeveralLambdas.kt");
            }

            @TestMetadata("ceSuperAccess.kt")
            public void testCeSuperAccess() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/compilingEvaluator/ceSuperAccess.kt");
            }
        }

        @TestMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/coroutines")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Coroutines extends AbstractKotlinEvaluateExpressionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doSingleBreakpointTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCoroutines() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/coroutines"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("anyUpdateInvokeStatic.kt")
            public void testAnyUpdateInvokeStatic() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/coroutines/anyUpdateInvokeStatic.kt");
            }

            @TestMetadata("anyUpdateVariable.kt")
            public void testAnyUpdateVariable() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/coroutines/anyUpdateVariable.kt");
            }

            @TestMetadata("primitivesCoertion.kt")
            public void testPrimitivesCoertion() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/coroutines/primitivesCoertion.kt");
            }

            @TestMetadata("stringUpdateInvokeStatic.kt")
            public void testStringUpdateInvokeStatic() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/coroutines/stringUpdateInvokeStatic.kt");
            }

            @TestMetadata("stringUpdateInvokeVirtual.kt")
            public void testStringUpdateInvokeVirtual() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/coroutines/stringUpdateInvokeVirtual.kt");
            }

            @TestMetadata("stringUpdatePutField.kt")
            public void testStringUpdatePutField() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/coroutines/stringUpdatePutField.kt");
            }

            @TestMetadata("stringUpdateVariable.kt")
            public void testStringUpdateVariable() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/coroutines/stringUpdateVariable.kt");
            }
        }

        @TestMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/createExpression")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CreateExpression extends AbstractKotlinEvaluateExpressionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doSingleBreakpointTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCreateExpression() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/createExpression"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("createExpressionCastToBuiltIn.kt")
            public void testCreateExpressionCastToBuiltIn() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/createExpression/createExpressionCastToBuiltIn.kt");
            }

            @TestMetadata("createExpressionSimple.kt")
            public void testCreateExpressionSimple() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/createExpression/createExpressionSimple.kt");
            }

            @TestMetadata("createExpressionWithArray.kt")
            public void testCreateExpressionWithArray() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/createExpression/createExpressionWithArray.kt");
            }
        }

        @TestMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extraVariables")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ExtraVariables extends AbstractKotlinEvaluateExpressionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doSingleBreakpointTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInExtraVariables() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extraVariables"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("evBreakpointOnPropertyDeclaration.kt")
            public void testEvBreakpointOnPropertyDeclaration() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extraVariables/evBreakpointOnPropertyDeclaration.kt");
            }

            @TestMetadata("evDelegatedProperty.kt")
            public void testEvDelegatedProperty() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extraVariables/evDelegatedProperty.kt");
            }

            @TestMetadata("evDuplicateItems.kt")
            public void testEvDuplicateItems() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extraVariables/evDuplicateItems.kt");
            }

            @TestMetadata("evFinalProperty.kt")
            public void testEvFinalProperty() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extraVariables/evFinalProperty.kt");
            }

            @TestMetadata("evFunctionDeclaration.kt")
            public void testEvFunctionDeclaration() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extraVariables/evFunctionDeclaration.kt");
            }

            @TestMetadata("evLineRange.kt")
            public void testEvLineRange() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extraVariables/evLineRange.kt");
            }

            @TestMetadata("evProperty.kt")
            public void testEvProperty() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extraVariables/evProperty.kt");
            }

            @TestMetadata("evPropertyRefExpr.kt")
            public void testEvPropertyRefExpr() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extraVariables/evPropertyRefExpr.kt");
            }

            @TestMetadata("evSkipAnonymousObject.kt")
            public void testEvSkipAnonymousObject() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extraVariables/evSkipAnonymousObject.kt");
            }

            @TestMetadata("evSkipLambda.kt")
            public void testEvSkipLambda() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extraVariables/evSkipLambda.kt");
            }

            @TestMetadata("evSkipLocalClass.kt")
            public void testEvSkipLocalClass() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extraVariables/evSkipLocalClass.kt");
            }
        }

        @TestMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Frame extends AbstractKotlinEvaluateExpressionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doSingleBreakpointTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFrame() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("catchVariable.kt")
            public void testCatchVariable() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/catchVariable.kt");
            }

            @TestMetadata("coroutineContextFun.kt")
            public void testCoroutineContextFun() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/coroutineContextFun.kt");
            }

            @TestMetadata("coroutineContextLambda.kt")
            public void testCoroutineContextLambda() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/coroutineContextLambda.kt");
            }

            @TestMetadata("defaultImplsMangling.kt")
            public void testDefaultImplsMangling() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/defaultImplsMangling.kt");
            }

            @TestMetadata("delegatedPropertyInClass.kt")
            public void testDelegatedPropertyInClass() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/delegatedPropertyInClass.kt");
            }

            @TestMetadata("delegatedPropertyInClassKotlinVariables.kt")
            public void testDelegatedPropertyInClassKotlinVariables() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/delegatedPropertyInClassKotlinVariables.kt");
            }

            @TestMetadata("delegatedPropertyInClassWithToString.kt")
            public void testDelegatedPropertyInClassWithToString() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/delegatedPropertyInClassWithToString.kt");
            }

            @TestMetadata("delegatedPropertyInClassWoRenderer.kt")
            public void testDelegatedPropertyInClassWoRenderer() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/delegatedPropertyInClassWoRenderer.kt");
            }

            @TestMetadata("frameAnonymousObject.kt")
            public void testFrameAnonymousObject() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameAnonymousObject.kt");
            }

            @TestMetadata("frameClassObject.kt")
            public void testFrameClassObject() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameClassObject.kt");
            }

            @TestMetadata("frameClosingBracket.kt")
            public void testFrameClosingBracket() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameClosingBracket.kt");
            }

            @TestMetadata("frameExtFunExtFun.kt")
            public void testFrameExtFunExtFun() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameExtFunExtFun.kt");
            }

            @TestMetadata("frameExtensionFun.kt")
            public void testFrameExtensionFun() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameExtensionFun.kt");
            }

            @TestMetadata("frameInlineArgument.kt")
            public void testFrameInlineArgument() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameInlineArgument.kt");
            }

            @TestMetadata("frameInlineArgumentInsideInlineFun.kt")
            public void testFrameInlineArgumentInsideInlineFun() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameInlineArgumentInsideInlineFun.kt");
            }

            @TestMetadata("frameInlineFun.kt")
            public void testFrameInlineFun() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameInlineFun.kt");
            }

            @TestMetadata("frameInlineFunCallInsideInlineFun.kt")
            public void testFrameInlineFunCallInsideInlineFun() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameInlineFunCallInsideInlineFun.kt");
            }

            @TestMetadata("frameInlineFunCallInsideInlineFunKotlinVariables.kt")
            public void testFrameInlineFunCallInsideInlineFunKotlinVariables() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameInlineFunCallInsideInlineFunKotlinVariables.kt");
            }

            @TestMetadata("frameInnerClass.kt")
            public void testFrameInnerClass() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameInnerClass.kt");
            }

            @TestMetadata("frameInnerLambda.kt")
            public void testFrameInnerLambda() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameInnerLambda.kt");
            }

            @TestMetadata("frameLambda.kt")
            public void testFrameLambda() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameLambda.kt");
            }

            @TestMetadata("frameLambdaNotUsed.kt")
            public void testFrameLambdaNotUsed() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameLambdaNotUsed.kt");
            }

            @TestMetadata("frameLocalVariable.kt")
            public void testFrameLocalVariable() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameLocalVariable.kt");
            }

            @TestMetadata("frameObject.kt")
            public void testFrameObject() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameObject.kt");
            }

            @TestMetadata("frameSharedVar.kt")
            public void testFrameSharedVar() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameSharedVar.kt");
            }

            @TestMetadata("frameSharedVarLocalVar.kt")
            public void testFrameSharedVarLocalVar() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameSharedVarLocalVar.kt");
            }

            @TestMetadata("frameSimple.kt")
            public void testFrameSimple() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameSimple.kt");
            }

            @TestMetadata("frameThis0.kt")
            public void testFrameThis0() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameThis0.kt");
            }

            @TestMetadata("frameThis0Ext.kt")
            public void testFrameThis0Ext() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameThis0Ext.kt");
            }

            @TestMetadata("frameThis0This0.kt")
            public void testFrameThis0This0() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameThis0This0.kt");
            }

            @TestMetadata("hideContinuationThis.kt")
            public void testHideContinuationThis() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/hideContinuationThis.kt");
            }

            @TestMetadata("hideSyntheticThis.kt")
            public void testHideSyntheticThis() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/hideSyntheticThis.kt");
            }

            @TestMetadata("lambdaFun1.kt")
            public void testLambdaFun1() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/lambdaFun1.kt");
            }

            @TestMetadata("lambdaFun2.kt")
            public void testLambdaFun2() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/lambdaFun2.kt");
            }

            @TestMetadata("lambdaFun3.kt")
            public void testLambdaFun3() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/lambdaFun3.kt");
            }

            @TestMetadata("lambdaFun4.kt")
            public void testLambdaFun4() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/lambdaFun4.kt");
            }

            @TestMetadata("lambdaParameterMangling.kt")
            public void testLambdaParameterMangling() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/lambdaParameterMangling.kt");
            }

            @TestMetadata("lambdaThisMangling.kt")
            public void testLambdaThisMangling() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/lambdaThisMangling.kt");
            }

            @TestMetadata("localFunctionMangling.kt")
            public void testLocalFunctionMangling() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/localFunctionMangling.kt");
            }

            @TestMetadata("remapThis.kt")
            public void testRemapThis() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/remapThis.kt");
            }

            @TestMetadata("suspendContinuation.kt")
            public void testSuspendContinuation() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/suspendContinuation.kt");
            }
        }

        @TestMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/javaContext")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class JavaContext extends AbstractKotlinEvaluateExpressionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doSingleBreakpointTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInJavaContext() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/javaContext"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("jcBlock.kt")
            public void testJcBlock() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/javaContext/jcBlock.kt");
            }

            @TestMetadata("jcImports.kt")
            public void testJcImports() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/javaContext/jcImports.kt");
            }

            @TestMetadata("jcLocalVariable.kt")
            public void testJcLocalVariable() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/javaContext/jcLocalVariable.kt");
            }

            @TestMetadata("jcMarkedObject.kt")
            public void testJcMarkedObject() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/javaContext/jcMarkedObject.kt");
            }

            @TestMetadata("jcProperty.kt")
            public void testJcProperty() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/javaContext/jcProperty.kt");
            }

            @TestMetadata("jcSimple.kt")
            public void testJcSimple() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/javaContext/jcSimple.kt");
            }
        }

        @TestMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/labels")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Labels extends AbstractKotlinEvaluateExpressionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doSingleBreakpointTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInLabels() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/labels"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("lCallOnLabeledObj.kt")
            public void testLCallOnLabeledObj() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/labels/lCallOnLabeledObj.kt");
            }

            @TestMetadata("lIdentifier.kt")
            public void testLIdentifier() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/labels/lIdentifier.kt");
            }

            @TestMetadata("lSeveralLabels.kt")
            public void testLSeveralLabels() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/labels/lSeveralLabels.kt");
            }

            @TestMetadata("lSimple.kt")
            public void testLSimple() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/labels/lSimple.kt");
            }

            @TestMetadata("ldifferentTypes.kt")
            public void testLdifferentTypes() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/labels/ldifferentTypes.kt");
            }
        }

        @TestMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/lambdas")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Lambdas extends AbstractKotlinEvaluateExpressionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doSingleBreakpointTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInLambdas() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/lambdas"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("destructuringParam.kt")
            public void testDestructuringParam() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/lambdas/destructuringParam.kt");
            }

            @TestMetadata("inlineFunctionalExpression.kt")
            public void testInlineFunctionalExpression() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/lambdas/inlineFunctionalExpression.kt");
            }

            @TestMetadata("inlineLambda.kt")
            public void testInlineLambda() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/lambdas/inlineLambda.kt");
            }

            @TestMetadata("lambdaOnReturn.kt")
            public void testLambdaOnReturn() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/lambdas/lambdaOnReturn.kt");
            }

            @TestMetadata("lambdaOnSecondLine.kt")
            public void testLambdaOnSecondLine() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/lambdas/lambdaOnSecondLine.kt");
            }

            @TestMetadata("oneLineFunctionalExpression.kt")
            public void testOneLineFunctionalExpression() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/lambdas/oneLineFunctionalExpression.kt");
            }

            @TestMetadata("oneLineLambda.kt")
            public void testOneLineLambda() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/lambdas/oneLineLambda.kt");
            }

            @TestMetadata("twoLambdasOnOneLineFirst.kt")
            public void testTwoLambdasOnOneLineFirst() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/lambdas/twoLambdasOnOneLineFirst.kt");
            }

            @TestMetadata("twoLambdasOnOneLineSecond.kt")
            public void testTwoLambdasOnOneLineSecond() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/lambdas/twoLambdasOnOneLineSecond.kt");
            }

            @TestMetadata("underscoreNames.kt")
            public void testUnderscoreNames() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/lambdas/underscoreNames.kt");
            }
        }

        @TestMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/renderer")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Renderer extends AbstractKotlinEvaluateExpressionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doSingleBreakpointTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInRenderer() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/renderer"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("toStringRenderer.kt")
            public void testToStringRenderer() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/renderer/toStringRenderer.kt");
            }
        }
    }

    @TestMetadata("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MultipleBreakpoints extends AbstractKotlinEvaluateExpressionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doMultipleBreakpointsTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInMultipleBreakpoints() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("clearCache.kt")
        public void testClearCache() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/clearCache.kt");
        }

        @TestMetadata("constructors.kt")
        public void testConstructors() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/constructors.kt");
        }

        @TestMetadata("exceptions.kt")
        public void testExceptions() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/exceptions.kt");
        }

        @TestMetadata("extensionMemberFunction.kt")
        public void testExtensionMemberFunction() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/extensionMemberFunction.kt");
        }

        @TestMetadata("extensionMemberFunctionInObject.kt")
        public void testExtensionMemberFunctionInObject() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/extensionMemberFunctionInObject.kt");
        }

        @TestMetadata("extensionMemberProperty.kt")
        public void testExtensionMemberProperty() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/extensionMemberProperty.kt");
        }

        @TestMetadata("fieldVariable.kt")
        public void testFieldVariable() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/fieldVariable.kt");
        }

        @TestMetadata("funFromOuterClassInLamdba.kt")
        public void testFunFromOuterClassInLamdba() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/funFromOuterClassInLamdba.kt");
        }

        @TestMetadata("initializer.kt")
        public void testInitializer() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/initializer.kt");
        }

        @TestMetadata("invisibleDeclarations.kt")
        public void testInvisibleDeclarations() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/invisibleDeclarations.kt");
        }

        @TestMetadata("isInsideInlineLambda.kt")
        public void testIsInsideInlineLambda() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/isInsideInlineLambda.kt");
        }

        @TestMetadata("localFun.kt")
        public void testLocalFun() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/localFun.kt");
        }

        @TestMetadata("multipleBreakpointsAtLine.kt")
        public void testMultipleBreakpointsAtLine() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/multipleBreakpointsAtLine.kt");
        }

        @TestMetadata("nonCapturedVariables.kt")
        public void testNonCapturedVariables() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/nonCapturedVariables.kt");
        }

        @TestMetadata("privateMembersPriority.kt")
        public void testPrivateMembersPriority() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/privateMembersPriority.kt");
        }

        @TestMetadata("remappedParameterInInline.kt")
        public void testRemappedParameterInInline() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/remappedParameterInInline.kt");
        }

        @TestMetadata("smartcasts.kt")
        public void testSmartcasts() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/smartcasts.kt");
        }

        @TestMetadata("thisLabels.kt")
        public void testThisLabels() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/thisLabels.kt");
        }

        @TestMetadata("whenEntry.kt")
        public void testWhenEntry() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/whenEntry.kt");
        }

        @TestMetadata("withoutBodyFunctions.kt")
        public void testWithoutBodyFunctions() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/withoutBodyFunctions.kt");
        }

        @TestMetadata("withoutBodyProperties.kt")
        public void testWithoutBodyProperties() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/withoutBodyProperties.kt");
        }

        @TestMetadata("withoutBodyProperties2.kt")
        public void testWithoutBodyProperties2() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/withoutBodyProperties2.kt");
        }

        @TestMetadata("withoutBodyTypeParameters.kt")
        public void testWithoutBodyTypeParameters() throws Exception {
            runTest("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/withoutBodyTypeParameters.kt");
        }

        @TestMetadata("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/library")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Library extends AbstractKotlinEvaluateExpressionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doMultipleBreakpointsTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInLibrary() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/library"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("customLibClassName.kt")
            public void testCustomLibClassName() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/library/customLibClassName.kt");
            }

            @TestMetadata("localFunInLibrary.kt")
            public void testLocalFunInLibrary() throws Exception {
                runTest("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/library/localFunInLibrary.kt");
            }
        }
    }
}
