package junit.test.svg;

import latexDraw.parsers.svg.MalformedSVGDocument;
import latexDraw.parsers.svg.SVGAttributes;
import latexDraw.parsers.svg.SVGElements;
import latexDraw.parsers.svg.elements.SVGDefsElement;
import latexDraw.parsers.svg.elements.SVGMarkerElement;

import org.junit.Test;

/** 
 * This class contains tests for the SVGDefsElement class.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 02/02/08<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class TestSVGDefsElement extends AbstractTestSVGElement
{
	@Test
	public void testEnableRendering()
	{
		try
		{
			SVGDefsElement defs = new SVGDefsElement(node, null);
			assertFalse(defs.enableRendering());
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	@Test
	public void testGetDef()
	{
		try
		{
			SVGDefsElement defs = new SVGDefsElement(node, null);
			SVGMarkerElement mark = new SVGMarkerElement(node.getOwnerDocument());
			
			mark.setAttribute(SVGAttributes.SVG_ID, SVGAttributes.SVG_ID);
			defs.appendChild(mark);
			
			assertNull(defs.getDef(null));
			assertNull(defs.getDef("")); //$NON-NLS-1$
			assertNull(defs.getDef("dsqd")); //$NON-NLS-1$
			assertEquals(mark, defs.getDef("id")); //$NON-NLS-1$
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	
	@Test
	public void testContructor()
	{
		try
		{ 
			new SVGDefsElement(null, null);
			fail();
		}
		catch(Exception e){/**/}

		try
		{
			new SVGDefsElement(node, null);
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	@Override
	public String getNameNode()
	{
		return SVGElements.SVG_DEFS;
	}
}
